/*
 * make vf which which converts ascii font in vertical mode to rotated font
 * mkrotvf cmr10 rcmr10 /.../cmr10.tfm [VFDIR]
 *	cmr10.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"bifont.h"

#define	UNIT	1048576		/* 1 fixpoint real = 2^20 */
#define	VFRATIO	UNIT

/* hard coded data */
/* end of hard coded data */

char *font;
char *rotfont;
int vfds;
char *vfdir, *vfdirsep;
FILE *tfm, *vf;

/* set by readtfm */
extern byte header[];
extern byte width[];
extern byte char_info[];
extern int id, nt, lh, bc, ec, nw, ds;

main(ac, av)
int ac;
char *av[];
{
    int ac0;
    char name[64];

    ac0 = 0;
    font = av[ac0+1];
    rotfont = av[ac0+2];
    if ((tfm = fopen(av[ac0+3], "r")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[ac0+3]);
	exit(1);
    }
    if (!readtfm(tfm)) {
	fprintf(stderr, "%s is not tfm\n", av[ac0+3]);
	exit(1);
    }
    vfds = ds;

    vfdir = (ac > ac0+4) ? av[ac0+4] : "";
    vfdirsep = (strlen(vfdir) > 0 && vfdir[strlen(vfdir)-1] != '/') ? "/" : "";
    sprintf(name, "%s%s%s.vf", vfdir, vfdirsep, font);
    if ((vf = fopen(name, "w")) == NULL) {
	fprintf(stderr, "cannot write %s\n", name);
	exit(1);
    }
    vertvf();
    fclose(vf);

    exit(0);
}

vertvf()
{
    long len;
    int i;

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putbytes(vf, header, 2*4);	/* check sum & design size */

    putuint(vf, FNT_DEF1, 1);
    putuint(vf, 1, 1);
    putuint(vf, 0, 4);
    putuint(vf, VFRATIO, 4);
    putuint(vf, vfds, 4);
    putuint(vf, 0, 1);
    putuint(vf, strlen(rotfont), 1);
    putbytes(vf, rotfont, strlen(rotfont));

    for (i = bc; i <= ec; i++)
	vfchar(i);

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}

vfchar(c)
int c;
{
    int pl;
    unsigned char *b;

    pl = 2;	/* DIR 3 */
    pl += (c <= SETC_127) ? 1 : 2;

    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, c, 4);
    putbytes(vf, width+char_info[(c-bc)*4]*4, 4);
    putuint(vf, DIR, 1);
    putuint(vf, 3, 1);
    if (c <= SETC_127)
	putuint(vf, c, 1);
    else {
	putuint(vf, SET1, 1);
	putuint(vf, c, 1);
    }
}
