!-------------------------------------------------
!  UWpack Module
!-------------------------------------------------
module uwpack
  use dcl_common
  contains
!-------------------------------------------------
    subroutine DclSetXGrid(x)  !ʻγʻɸƺɸͤꤹ롥
      real, intent(in), dimension(:) :: x  !xɸuɸϤͤǻꤹ

      call prcopn('DclSetXGrid')
      call uwsgxa(x,size(x))
      call prccls('DclSetXGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclGetXGrid(x)    !ꤵƤʻκɸ
      real, intent(out), dimension(:) :: x

      call prcopn('DclGetXGrid')
      call uwqgxa(x,size(x)) 
      call prccls('DclGetXGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclSetYGrid(y)    !ʻγʻɸƺɸͤꤹ롥
      real, intent(in), dimension(:) :: y  ! yɸuɸϤͤǻꤹ

      call prcopn('DclSetYGrid')
      call uwsgya(y, size(y))
      call prccls('DclSetYGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclGetYGrid(y)    !ꤵƤʻκɸ
      real, intent(out), dimension(:) :: y

      call prcopn('DclGetYGrid')
      call uwqgya(y,size(y))
      call prccls('DclGetYGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclSetXEvenGrid(xmin,xmax,n)  !ʻɸֳ֤ꤹ롥
      real,   intent(in) :: xmin, xmax       !uɸϤˤxɸκǾ
      integer,intent(in) :: n                !xγʻ

      call prcopn('DclSetXEvenGrid')
      call uwsgxb(xmin,xmax,n) 
      call prccls('DclSetXEvenGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclSetYEvenGrid(ymin,ymax,n)  !ʻɸֳ֤ꤹ롥
      real,    intent(in) :: ymin,ymax       !uɸϤˤyɸκǾ
      integer, intent(in) :: n               !yγʻ

      call prcopn('DclSetYEvenGrid')
      call uwsgyb(ymin,ymax,n)   
      call prccls('DclSetYEvenGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclGetXEvenGrid(xmin,xmax,n)  !ʻɸκǾ,,ʻλ
      real,   intent(out) :: xmin,xmax       !uɸϤˤxɸκǾ
      integer,intent(out) :: n               !xγʻ

      call prcopn('DclGetXEvenGrid')
      call uwqgxb(xmin,xmax,n)  
      call prccls('DclGetXEvenGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclGetYEvenGrid(ymin,ymax,n)  !ʻɸκǾ,,ʻλ
      real,      intent(out) :: ymin,ymax    !uɸϤˤyɸκǾ
      integer,   intent(out) :: n            !yγʻ

      call prcopn('DclGetYEvenGrid')
      call uwqgyb(ymin,ymax,n)       
      call prccls('DclGetYEvenGrid')
    end subroutine
!-------------------------------------------------
    function DclGetXGridValue(ix)            !ʻκɸ֤ͤ
      real                :: DclGetXGridValue
      integer, intent(in) :: ix              !ʻֹ

      call prcopn('DclGetXGridValue')
      DclGetXGridValue = ruwgx(ix)   
      call prccls('DclGetXGridValue')
    end function
!-------------------------------------------------
    function DclGetYGridValue(iy)            !ʻκɸ֤ͤ
      real                :: DclGetYGridValue
      integer, intent(in) :: iy              !ʻֹ

      call prcopn('DclGetYGridValue')
      DclGetYGridValue = ruwgy(iy)  
      call prccls('DclGetYGridValue')
    end function
!-------------------------------------------------
    function DclGetXGridNumber(x)            !ɸͤ˺Ǥᤤʻֹ֤
      integer             :: DclGetXGridNumber
      real,    intent(in) :: x               !ɸ

      call prcopn('DclGetXGridNumber')
      DclGetXGridNumber = iuwgx(x) 
      call prccls('DclGetXGridNumber')
    end function
!-------------------------------------------------
    function DclGetYGridNumber(y)            !ɸͤ˺Ǥᤤʻֹ֤
      integer             :: DclGetYGridNumber
      real,    intent(in) :: y               !ʻֹ

      call prcopn('DclGetYGridNumber')
      DclGetYGridNumber = iuwgy(y) 
      call prccls('DclGetYGridNumber')
    end function
end module
