dnl $Id: aclocal.m4 7 2001-06-24 22:57:37Z toyoda $
dnl DCL macros for dcl-f90-unix
dnl Copyright(C) by GFD-Dennou Club, 1999, 2001.  All rights reserved.

dnl DCLF90_PROG_FC()
dnl ----------------
dnl get the name and required option of the Fortran 90 compiler.
dnl
AC_DEFUN(DCLF90_PROG_FC,
[
    SUNOS5=no
    case `uname -s` in
        HI-OSF*)
            fflags="-i,E,L,EU"
            ;;
        HP-UX)
            flibs=-lU77
            ;;
        SunOS)
            case `uname -r` in
                5*)
                    SUNOS5=yes
                    ;;
            esac
            ;;
        *)
            ;;
    esac
    forts="frt xlf cf90 lf90 lf95 f90 f95"

    FFLAGS="${FFLAGS-} ${fflags-}"
    FLIBS="${FLIBS-} ${flibs-}"

    case "${FC+set}" in
        set)
            case "$FC" in
                '')
                    AC_MSG_WARN(no Fortran compiler)
                    ;;
                *)
                    AC_MSG_CHECKING(user-defined Fortran compiler \"$FC\")
                    cat << EOF > conftest.f90
program conftest
print *, 'Hello, World'
end program conftest
EOF
                    doit='$FC -c ${FFLAGS-} conftest.f90'
                    if AC_TRY_EVAL(doit); then
                        AC_MSG_RESULT(works)
                    else
                        AC_MSG_WARN($FC failed to compile test program)
                        FC=
                    fi
                    rm -f conftest.*
                    ;;
            esac
            ;;
        *)
	    AC_MSG_CHECKING(Fortran 90 compiler)
            echo ''
            for fc in $forts; do
                AC_CHECK_PROG(FC, $fc, $fc)
                case "${FC-}" in
                    '')
                        ;;
                    *)
                        cat << EOF > conftest.f90
program conftest
print *, 'Hello, World'
end program conftest
EOF
                    doit='$FC -c ${FFLAGS-} conftest.f90'
                    if AC_TRY_EVAL(doit); then
                        break
                    else
                        AC_MSG_WARN($FC failed to compile test program)
                        unset FC
                        unset ac_cv_prog_FC
                    fi
                    ;;
                esac
            done
            rm -f conftest.*
            case "${FC-}" in
                '')
                    AC_MSG_WARN(Could not find working Fortran compiler)
                    FC=
                    ;;
            esac
            ;;
    esac

dnl === shared library option ===
dnl If Sun Fortran 90 is selected, -R<f90_dir> should be specified
dnl in the compilation process
dnl
    if test ${SUNOS5} = yes && test "${FC}" = "f90"; then
        AC_PATH_PROG(SUNFC,"f90")
        flibdir=`dirname ${SUNFC}`
        flibdir=`echo $flibdir | sed -e s/bin/lib/`
        FLIBS="${FLIBS-} -R"$flibdir
    fi

    DCLF90_MODULE_STYLE
    AC_SUBST(FC)
    AC_SUBST(FFLAGS)
    AC_SUBST(FLIBS)
])

AC_DEFUN(DCLF90_MODULE_STYLE,
[
    AC_CACHE_CHECK(module passing style, dc_cv_fortran_module_style,
[
    cat << EOF > conftest1.f90
module conftestm
character, parameter:: i = 'X'
end module
EOF
    cat << EOF > conftest2.f90
program conftest2
use conftestm
print *, i
end program conftest2
EOF
    AC_TRY_COMMAND($FC -c ${FFLAGS-} conftest1.f90)
    if AC_TRY_COMMAND($FC -c ${FFLAGS-} conftest2.f90); then
	if test -f CONFTESTM.mod; then
    	    dc_cv_fortran_module_style=UCASE.mod
        elif test -f conftestm.mod; then
    	    dc_cv_fortran_module_style=lcase.mod
        else
            AC_MSG_ERROR(unknown type of dependency file)
        fi
    elif AC_TRY_COMMAND($FC -c -Am ${FFLAGS-} conftest1.f90 && dnl
	$FC -c -Am ${FFLAGS-} conftest2.f90) ; then
    	dc_cv_fortran_module_style=fqs.mod
    elif AC_TRY_COMMAND(cp conftest1.f90 conftestm.f90 && dnl
	$FC -c ${FFLAGS-} conftest2.f90) ; then
    	dc_cv_fortran_module_style=hitachi.include
    fi
    rm -f conftest?.*
])
    MODULE_STYLE=$dc_cv_fortran_module_style
    MODEXT=.mod
    case $MODULE_STYLE in
    fqs.mod)
	FFLAGS="${FFLAGS:-} -Am"
        ;;
    hitachi.include)
	MODEXT=.f90
	;;
    esac
    AC_SUBST(MODULE_STYLE)
    AC_SUBST(MODEXT)
])

dnl DCLF90_FIND_DCL()
dnl -----------------
dnl look up the base DCL.
AC_DEFUN(DCLF90_FIND_DCL,
[
    DCL_STYLE=none
dnl
dnl --- search dclconfig/dclfrt with environment or path ---
dnl
    AC_CHECK_PROG(DCLCONFIG, dclconfig, `which dclconfig`, none)
    if test str"$DCLCONFIG" != str"none"; then
	DCL_STYLE=dclconfig:$DCLCONFIG
    fi
    if test str"$DCL_STYLE" = str"none"; then
        AC_CHECK_PROG(DCLFRT, dclfrt, `which dclfrt`, none)
        if test str"$DCLFRT" != str"none"; then
	    DCL_STYLE=dclfrt:$DCLFRT
        fi
    fi
    if test str"$DCL_STYLE" = str"none"; then
        if test -f ${DCL:-/} ; then
	    DCL_STYLE=library:$DCL
        fi
    fi
dnl
dnl --- heuristic search for command or library ---
dnl
    if test str"$DCL_STYLE" = str"none"; then
	echo hmmm, the base DCL not found yet, searching with heuristics...
        for dir in /bin /usr/bin /usr/local/bin /usr/local/dcl*/bin \
 /usr/dcl*/bin /usr/local/bin/dcl* /usr/local/dcl*/bin /usr/bin/dcl* \
/usr/lib/dcl*/bin /opt/dcl*/bin ${HOME}/bin ${HOME}/*/bin
	do
	    test -d $dir || continue
	    if test -x $dir/dclconfig; then
		DCLCONFIG=$dir/dclconfig
		DCL_STYLE=dclconfig:$DCLCONFIG
            elif test -x $dir/dclfrt; then
		DCLFRT=$dir/dclfrt
		DCL_STYLE=dclfrt:$DCLFRT
            fi
	done
    fi
    if test str"$DCL_STYLE" = str"none"; then
        for dir in /lib /usr/lib /usr/local/lib /usr/local/dcl*/lib \
/usr/dcl*/lib /usr/local/lib/dcl* /usr/local/dcl*/lib /usr/lib/dcl* \
/usr/lib/dcl*/lib /opt/dcl*/lib ${HOME}/lib ${HOME}/*/lib
        do
	    test -d $dir || continue
            for lib in $dir/libdcl.a $dir/libdcl*f77.a; do
		test -f $lib || continue
		DCL=$lib
		DCL_STYLE=library:$DCL
	        break
	    done
            test str"$DCL_STYLE" != str"none" && break
        done
    fi
    test str"$DCL_STYLE" = str"none" && AC_MSG_ERROR(base dcl not found)
    echo the base dcl is found ${DCL_STYLE}
    case $DCL_STYLE in
    dclconfig:*)
	dclbindir=`$DCLCONFIG --bindir`
	dcllibdir=`$DCLCONFIG --libdir`
	LDFLAGS="$LDFLAGS `$DCLCONFIG --ldflags --ldlibs`
	;;
    dclfrt:*)
	dclbindir=`dirname $DCLFRT`
	LDFLAGS=`sed -ne 's/set *ldflags *= *//p; s/set *ldlibs *= *//p' $DCLFRT`
	;;
    library:*)
	;;
    *)
	AC_MSG_ERROR(unknown DCL_STYLE)
	;;
    esac
    : ${prefix:=/usr/local/dcl-f90}
    AC_SUBST(LIBINSTDIR)
    AC_SUBST(MODINSTDIR)
    AC_SUBST(DOCDIR)
])

