---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, cellules, tables, fusionner des cellules,
              fusionner des cases, multiligne
---

# Comment fusionner des cellules d'une même colonne dans un tableau ?

Certains tableaux nécessitent une cellule qui s'étendent sur plusieurs lignes. 
Le cas classique est celui où la colonne la plus à gauche étiquette 
le reste de la table. Si cette présentation peut être éventuellement traitée
en utilisant une séparation diagonale comme vu à la question 
"[](/3_composition/tableaux/cellules/diviser_une_cellule_en_diagonale)", 
cette technique reste très limitée. Voici des solutions plus générales.


## Avec l'extension <ctanpkg:multirow>

L'extension <ctanpkg:multirow> vous permet de construire des cellules 
s'étendant sur plusieurs lignes. Par exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{multirow}

\begin{document}
\begin{tabular}{|c|c|}
  \hline
  \multirow{4}{*}{Texte multiligne}
    & Ligne 1 \\
    & Ligne 2 \\
    & Ligne 3 \\
    & Ligne 4 \\
  \hline
\end{tabular}
\end{document}
```

L'extension centrera verticalement "Texte multiligne" dans la cellule étendue. 
Notez que les lignes qui ne contiennent pas la spécification multiligne 
doivent avoir des cellules vides pour laisser la place à la cellule multiligne.

Le symbole `*` peut être remplacé par une largeur de colonne. Dans ce cas, 
le contenu de la cellule multiligne peut contenir des sauts de ligne imposés :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{multirow}

\begin{document}
\begin{tabular}{|c|c|}
  \hline
  \multirow{4}{25mm}{Texte%
    \\multiligne}
    & Ligne 1 \\
    & Ligne 2 \\
    & Ligne 3 \\
    & Ligne 4 \\
  \hline
\end{tabular}
\end{document}
```

Un effet similaire (permettant un peu plus de sophistication) peut être obtenu
en mettant un tableau plus petit qui aligne le texte dans une commande 
`\multirow` utilisant `*`.

La commande `\multirow` peut également être utilisée pour placer 
des textes écrits verticalement d'un côté ou de l'autre d'un tableau 
(à l'aide de l'extension <ctanpkg:graphicx> qui fournit la commande 
`\rotatebox`) :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{multirow}
  \usepackage{graphicx}

\begin{document}
\begin{tabular}{|l|l|}
  \hline
  \multirow{4}{*}{%
    \rotatebox{90}{Texte}}
    & Ligne 1 \\
    & Ligne 2 \\
    & Ligne 3 \\
    & Ligne 4 \\
  \hline
\end{tabular}
\end{document}
```

Cet exemple donne un texte qui va vers le haut. Pour un texte allant 
vers le bas, il faudrait prendre un angle de `-90`.

Pour créer une cellule s'étendant sur plusieurs lignes et plusieurs colonnes, 
il faut inclure la commande `\multirow` à l'intérieur de la commande 
`\multicolumn`, l'inverse ne fonctionnant pas :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{multirow}

\begin{document}
\begin{tabular}{|c|c|c|}\hline
  \multicolumn{2}{|c|}{
   \multirow{2}{*}{Cellules combinées}}
     & Haut droit \\ \cline{3-3}
   \multicolumn{2}{|c|}{}  & Centre droit \\ \hline
   Bas gauche & Bas centre  & Bas droit \\ \hline
\end{tabular}
\end{document}
```

L'extension <ctanpkg:multirow> est configurée pour interagir 
avec l'extension <ctanpkg:bigstrut> (abordée dans la question 
"[](/3_composition/tableaux/lignes/augmenter_la_largeur_des_lignes_d_un_tableau)"). 
Vous pouvez utiliser un argument facultatif de la commande `\multirow` 
pour dire combien de lignes de votre cellule multiligne sont ouvertes 
avec `\bigstrut`.

La documentation de <ctanpkg:multirow> et de <ctanpkg:bigstrut> se trouve, 
sous forme de commentaires, dans les fichiers des extensions elles-mêmes.


## Avec l'extension <ctanpkg:tabularray> 

L'extension <ctanpkg:tabularray> propose une syntaxe plus unifiée pour
présenter des tableaux. Au sein de son environnment `tblr`, elle traite 
en particulier la fusion des cellules avec sa commande `\SetCell` placée
dans la cellule qui doit être s'étaler dans le tableau. Elle a 
pour syntaxe :

```{noedit}
\SetCell[r=⟨hauteur⟩,c=⟨largeur⟩]{⟨alignement⟩}
``` 

Dans cette syntaxe, `⟨hauteur⟩` est le nombre de lignes fusionnées, 
`⟨largeur⟩` le nombre de colonne fusionnées tandis que `⟨alignement⟩`
vaut `c`,`l` ou `r` selon les conventions usuelles d'alignement 
dans les tableaux.

L'extension propose également une variante syntaxique où les définitions 
de fusion peuvent se faire dans l'en-tête du tableau avec l'option 

```{noedit}
cell{⟨x⟩}{⟨y⟩}={r=⟨hauteur⟩,c=⟨largeur⟩}{⟨alignement⟩}
```

Ici, `⟨x⟩` et `⟨y⟩` désignent les coordonnées de la cellule à modifier 
dans le tableau.

Voici un exemple des deux méthodes :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tabularray}

\begin{document}

Un tableau avec le code de fusion dans les cellules :
\begin{table}[h]
\centering
\begin{tblr}{|c|c|}
  \hline
  \SetCell[r=4]{c} Texte multiligne & Ligne 1 \\
  Ho !                              & Ligne 2 \\
  Hooooo !                          & Ligne 3 \\
  Hooooooooooooooooooooooooo !      & Ligne 4 \\
  \hline
\end{tblr}
\end{table}

Le même tableau avec le code de fusion dans l'en-tête
du tableau :

\begin{table}[h]
\centering
\begin{tblr}{colspec={|c|c|},cell{1}{1}={r=4}{c}}
  \hline
  Texte multiligne & Ligne 1 \\
                   & Ligne 2 \\
                   & Ligne 3 \\
                   & Ligne 4 \\
  \hline
\end{tblr}
\end{table}
\end{document}
```

:::{todo} Poursuivre la rédaction d'exemples.
:::

D'autres fonctionnalités de cette extension sont présentées à la question
"[](/3_composition/tableaux/tableau_tabularray)".


:::{sources}
- [Merging cells in a column of a table](faquk:FAQ-multirow)
- [Documentation](texdoc:tabularray) de <ctanpkg:tabularray> 
:::