---
title: PyInstrument
summary: Easily Instrument your Schema
tags: instrumentation,profiling
---

# `PyInstrument`

This extension allows you to instrument your schema and inspect the call stack.

## Usage example:

```python
import strawberry
from strawberry.extensions import pyinstrument


@strawberry.type
class Query:
    @strawberry.field
    def hello(self) -> str:
        return "Hello, world!"


schema = strawberry.Schema(
    Query,
    extensions=[
        pyinstrument.PyInstrument(report_path="pyinstrument.html"),
    ],
)
```

## API reference:

```python
class PyInstrument(report_Path=Path("pyinstrument.html")): ...
```

#### `report_path: Path = Path("pyinstrument.html")`

Path to write the HTML PyInstrument report
