/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import uk.me.nxg.unity.Dimensions;
import uk.me.nxg.unity.FunctionOfUnit;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.SimpleUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.SyntaxFactory;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitWriter;
import uk.me.nxg.unity.UnwritableExpression;

public class UnitExpr
implements Iterable<OneUnit>,
Comparable<UnitExpr> {
    private final double logFactor;
    private final List<OneUnit> unitsList;
    private SortedSet<OneUnit> unitsSet;
    private final UnitDefinitionMap.Resolver resolver;
    private static UnitExpr dimensionlessExpression = null;

    UnitExpr(double d, List<OneUnit> list) {
        this(d, list, null);
    }

    UnitExpr(double d, List<OneUnit> list, List<OneUnit> list2) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("UnitExpr must have non-empty numerator");
        }
        this.logFactor = d;
        this.unitsList = list2 == null ? list : OneUnit.divide(list, list2);
        assert (this.unitsList != null && this.unitsList.size() > 0);
        this.resolver = this.unitsList.get(0).getUnitResolver();
        assert (this.resolver != null);
        this.unitsSet = null;
    }

    private UnitExpr() {
        this.logFactor = 0.0;
        this.unitsList = null;
        this.resolver = null;
        this.unitsSet = null;
    }

    public static UnitExpr getDimensionlessExpression() {
        if (dimensionlessExpression == null) {
            dimensionlessExpression = new UnitExpr();
        }
        return dimensionlessExpression;
    }

    public UnitExpr canonicalize() {
        if (this.unitsList == null) {
            return this;
        }
        ArrayList<OneUnit> arrayList = new ArrayList<OneUnit>(this.getSortedSet());
        return new UnitExpr(this.logFactor, arrayList);
    }

    public double getLogFactor() {
        return this.logFactor;
    }

    public double getFactor() {
        return Math.pow(10.0, this.logFactor);
    }

    List<OneUnit> getUnitsList() {
        return this.unitsList;
    }

    private SortedSet<OneUnit> getSortedSet() {
        if (this.unitsSet == null) {
            this.unitsSet = this.unitsList == null ? new TreeSet<OneUnit>() : new TreeSet<OneUnit>(this.unitsList);
        }
        return this.unitsSet;
    }

    @Override
    public Iterator<OneUnit> iterator() {
        if (this.unitsList == null) {
            return new Iterator<OneUnit>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public OneUnit next() {
                    throw new NoSuchElementException("No more OneUnit in list");
                }
            };
        }
        return this.unitsList.iterator();
    }

    public Iterator<OneUnit> sortedIterator() {
        return this.getSortedSet().iterator();
    }

    public OneUnit getUnit(UnitDefinition unitDefinition) {
        if (unitDefinition == null) {
            throw new IllegalArgumentException("getUnit(UnitDefinition) argument may not be null");
        }
        for (OneUnit oneUnit : this) {
            if (oneUnit instanceof SimpleUnit) {
                UnitDefinition unitDefinition2 = oneUnit.getBaseUnitDefinition();
                if (unitDefinition2 == null || !unitDefinition2.equals(unitDefinition)) continue;
                return oneUnit;
            }
            assert (oneUnit instanceof FunctionOfUnit);
            OneUnit oneUnit2 = ((FunctionOfUnit)oneUnit).getUnit(unitDefinition);
            if (oneUnit2 == null) continue;
            return oneUnit;
        }
        return null;
    }

    public OneUnit getUnit(String string) {
        if (string == null) {
            throw new IllegalArgumentException("getUnit(String) argument may not be null");
        }
        if (this.resolver == null) {
            return null;
        }
        UnitDefinition unitDefinition = this.resolver.lookupSymbol(string);
        if (unitDefinition != null) {
            return this.getUnit(unitDefinition);
        }
        for (OneUnit oneUnit : this) {
            String string2 = oneUnit.getBaseUnitString();
            if (string2 == null || !string2.equals(string)) continue;
            return oneUnit;
        }
        return null;
    }

    public OneUnit getUnit(int n) {
        if (this.unitsList == null) {
            throw new IndexOutOfBoundsException("Dimensionless UnitExpr has no units");
        }
        return this.unitsList.get(n);
    }

    public int size() {
        return this.unitsList == null ? 0 : this.unitsList.size();
    }

    UnitDefinitionMap.Resolver getUnitResolver() {
        return this.resolver;
    }

    public boolean allUnitsRecommended(Syntax syntax) {
        for (OneUnit oneUnit : this) {
            if (oneUnit.isRecommendedUnit(syntax)) continue;
            return false;
        }
        return true;
    }

    public boolean allUnitsRecognised() {
        return this.allUnitsRecognised(Syntax.ALL, true);
    }

    public boolean allUnitsRecognised(Syntax syntax) {
        return this.allUnitsRecognised(syntax, false);
    }

    public boolean allUnitsRecognised(Syntax syntax, boolean bl) {
        for (OneUnit oneUnit : this) {
            if (!oneUnit.isRecognisedUnit(syntax)) {
                return false;
            }
            if (bl || !oneUnit.wasGuessed()) continue;
            return false;
        }
        return true;
    }

    public boolean allUsageConstraintsSatisfied(Syntax syntax) {
        for (OneUnit oneUnit : this) {
            if (oneUnit.satisfiesUsageConstraints(syntax)) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyConformant(Syntax syntax) {
        for (OneUnit oneUnit : this) {
            if (oneUnit.satisfiesUsageConstraints(syntax) && oneUnit.isRecommendedUnit(syntax)) continue;
            return false;
        }
        return true;
    }

    public Dimensions getDimensions() {
        Dimensions dimensions = Dimensions.unity();
        for (OneUnit oneUnit : this) {
            if (oneUnit.getDimensions() == null) {
                return null;
            }
            dimensions = dimensions.multiply(oneUnit.getDimensions(), oneUnit.getExponent());
        }
        return dimensions;
    }

    @Override
    public int compareTo(UnitExpr unitExpr) {
        int n;
        if (this.logFactor == unitExpr.logFactor) {
            Iterator<OneUnit> iterator = this.sortedIterator();
            Iterator<OneUnit> iterator2 = unitExpr.sortedIterator();
            n = 0;
            while (n == 0) {
                if (iterator.hasNext() && iterator2.hasNext()) {
                    OneUnit oneUnit = iterator.next();
                    OneUnit oneUnit2 = iterator2.next();
                    n = oneUnit.compareTo(oneUnit2);
                    continue;
                }
                if (!iterator.hasNext() && !iterator2.hasNext()) {
                    n = 0;
                    break;
                }
                n = iterator.hasNext() ? 1 : -1;
            }
        } else {
            n = this.logFactor < unitExpr.logFactor ? -1 : 1;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof UnitExpr) {
            return this.compareTo((UnitExpr)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        try {
            return this.toString(null, null);
        }
        catch (UnwritableExpression unwritableExpression) {
            throw new AssertionError((Object)("UnitExpr.toString(FITS) failed: this shouldn't happen: " + unwritableExpression));
        }
    }

    public String toString(Syntax syntax) throws UnwritableExpression {
        return this.toString(syntax, null);
    }

    public String toString(Syntax syntax, Locale locale) throws UnwritableExpression {
        UnitWriter unitWriter = SyntaxFactory.createWriter(syntax == null ? Syntax.FITS : syntax, this);
        if (locale != null) {
            unitWriter.setLocale(locale);
        }
        return unitWriter.write();
    }

    public String toDebugString() {
        try {
            return this.toString(Syntax.DEBUG, null);
        }
        catch (UnwritableExpression unwritableExpression) {
            throw new AssertionError((Object)("Debug writer failed: " + unwritableExpression));
        }
    }
}

