## Tutorials and examples

These tutorials are command line tutorials that should work on Mac OS
X and Linux. They require about 5 GB of disk space and 5 GB of RAM.

* [Installing sourmash with conda](tutorial-install.md)

* [The first sourmash tutorial - making signatures, comparing, and searching](tutorial-basic.md)

* [Using sourmash LCA to do taxonomic classification](tutorials-lca.md)

* [Analyzing the genomic and taxonomic composition of an environmental genome using GTDB and sample-specific MAGs with sourmash](tutorial-lemonade.md)

* [Some sourmash command line examples!](sourmash-examples.ipynb)

## How-To Guides

* [Classifying genome and metagenome sketches](classifying-signatures.md)

* [Working with private collections of genome sketches](sourmash-collections.ipynb)

* [Using the `LCA_Database` API](using-LCA-database-API.ipynb)

* [Building plots from `sourmash compare` output](plotting-compare.ipynb).

* [A short guide to using sourmash output with R](other-languages.md).

## Frequently Asked Questions

* [Frequently asked questions](faq.md)

## How sourmash works under the hood

* [An introduction to k-mers for genome comparison and analysis](kmers-and-minhash.ipynb)
* [Support, versioning, and migration between versions](support.md)

## Reference material

* [UNIX command-line documentation](command-line.md)
* [Genbank and GTDB databases and taxonomy files](databases.md)
* [Python examples using the API](api-example.md)
* [Publications about sourmash](publications.md)
* [A guide to the internal design and structure of sourmash](sourmash-internals.md)
* [Funding acknowledgements](funding.md)

## Developing and extending sourmash

* [Getting started with sourmash development](developer.md)
* [Releasing a new version of sourmash](release.md)

## [Full table of contents for all docs](toc.md)
