#ifndef DSREDITWINDOW_H
#define DSREDITWINDOW_H

#include <QWidget>
#include "molecule.h"
#include "dsrgui.h"


struct DSRUnitCell{
  //! cell parameter a
  double a;
  //! cell parameter b
  double b;
  //! cell parameter c
  double c;
  //! cell parameter alpha
  double alpha;
  //! cell parameter beta
  double beta;
  //! cell parameter gamma
  double gamma;
};

class DSREditWindow : public QWidget
{
  Q_OBJECT
public:
  explicit DSREditWindow(Molecule *mol, DSRMol *header,
                         QString dsr_db_path, QString nametag,
                         QVector<QStringList> fragmentsList, DSRGui *parent = 0);
  QSize minimumSizeHint() const;
  QSize sizeHint() const;
  QVBoxLayout *mainVLayout;
  QGridLayout *maingrid;
  QHBoxLayout *cellLayout;
  QTextEdit *atomsEdit;
  QTextEdit *restrEdit;
  QLabel *infoLabel;
  QWidget *m_gui;
  DSRMol *m_header;
  DSRMol *new_header;
  QVector<QStringList> m_frags;
  QPushButton *updateButton;
  QPushButton *addButton;
  QPushButton *deleteButton;
  QPushButton *mailButton;
  QPushButton *clearButton;
  QPushButton *use_selected;
  QPushButton *renameButton;
  QPushButton *accept_renameButton;
  QPushButton *abort_renameButton;
  QGridLayout *buttonlayout;
  double a, b, c, alpha, beta, gamma; //!< unit cell values of the edited fragment.
  QVector<QStringList> myAtoms;  //!< Custom made atoms from the atoms textedit field
  QVector<QStringList> myRestraints; //!< Custom made restraints from the restraints edit field
  QString fragname, resiclass;
  QString mydsrdbpath;
  QString m_nametag;
  bool userdb;
  QString *oldatoms; //! atom list before entering rename mode
  QString *oldrestraints; //! restraints list before entering rename mode
  QStringList *previous_atoms; //! atom names when leaving renameAtoms()
  QStringList *first_atnames;
  QLineEdit *nameEdit;
           // *sourceEdit;
  Molecule *m_mol;
  QLineEdit *cell_a,
            *cell_b,
            *cell_c,
            *cell_alpha,
            *cell_beta,
            *cell_gamma;
  QStringList RESTRAINT_CARDS;
  bool badLine;
  ~DSREditWindow();

  void renameRestraints(QStringList new_atnames, int cursopos);

private:
  QLineEdit *resicledit;
  DSRGlWindow *myedgl;

signals:
  //void atomsChanged(QVector<QStringList> atoms);
  void line_error(QString error);
  void updated(QString m_nametag);

public slots:
  void setNamefromDB(DSRMol *header);
  void setResidueFromDB(DSRMol *header);
  void setRestraintsFromDB(DSRMol *header);
  void setCellFromDB(DSRMol *header);
  void setDBTypeFromDB(DSRMol *header);
  void setAtomsFromDB(DSRMol *header);
  void makeUnitCellEdit();
  int getCharWidth(int numchars);
  void checkResiClassInput(QString text);
  void set_a_value(QString a);
  void set_b_value(QString b);
  void set_c_value(QString c);
  void set_alpha_value(QString alpha);
  void set_beta_value(QString beta);
  void set_gamma_value(QString gamma);
  void setFragmentName(QString name);
  void setAtoms();
  QStringList checkAtomLine(QStringList line, int num);
  void setInfoLabel(QString myerror);
  void setRestraints();
  void checkRestraintLine(QStringList restrline, int num);
  void deleteFragment(QString nametag);
  void writeFragmentDB(QStringList database);
  QStringList readFragmentDB();
  bool doesFragExist(QString name, bool fullname);
  QString randString(int len);
  QString inventNameTag(int length);
  QStringList combineDataToNewFragment();
  void addFragment();
  void updateFragment();
  bool validateCell();
  void setSelectedAtoms();
  void mailHome();
  bool myisAscii(QString);
  void deleteCurrentFragment();
  void updateFraglist();
  void enterRenameMode();
  void leaveRenameMode();
  void renameAtoms();
  void abortRenameMode();
  void clearAll();
private slots:




private:
  void connectSignalsAndSlots();

};

#endif // DSREDITWINDOW_H
