% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croston.R
\name{forecast.croston_model}
\alias{forecast.croston_model}
\alias{croston}
\title{Forecasts for intermittent demand using Croston's method}
\usage{
\method{forecast}{croston_model}(object, h = 10, ...)

croston(y, h = 10, alpha = 0.1, type = c("croston", "sba", "sbj"), x = y)
}
\arguments{
\item{object}{An object of class \code{croston_model} as returned by \code{\link[=croston_model]{croston_model()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{...}{Additional arguments affecting the forecasts produced. If
\code{model = NULL}, \code{forecast.ts} passes these to \code{\link[=ets]{ets()}} or
\code{\link[=stlf]{stlf()}} depending on the frequency of the time series. If
\code{model} is not \code{NULL}, the arguments are passed to the relevant
modelling function.}

\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{alpha}{Value of alpha. Default value is 0.1.}

\item{type}{Which variant of Croston's method to use. Defaults to \code{"croston"} for
Croston's method, but can also be set to \code{"sba"} for the Syntetos-Boylan
approximation, and \code{"sbj"} for the Shale-Boylan-Johnston method.}

\item{x}{Deprecated. Included for backwards compatibility.}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts and other information for Croston's forecasts applied to
y.
}
\details{
Based on Croston's (1972) method for intermittent demand forecasting, also
described in Shenstone and Hyndman (2005). Croston's method involves using
simple exponential smoothing (SES) on the non-zero elements of the time
series and a separate application of SES to the times between non-zero
elements of the time series. The smoothing parameters of the two
applications of SES are assumed to be equal and are denoted by \code{alpha}.

Note that prediction intervals are not computed as Croston's method has no
underlying stochastic model.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
y <- rpois(20, lambda = 0.3)
fcast <- croston(y)
autoplot(fcast)

}
\references{
Croston, J. (1972) "Forecasting and stock control for
intermittent demands", \emph{Operational Research Quarterly}, \bold{23}(3),
289-303.

Shale, E.A., Boylan, J.E., & Johnston, F.R. (2006). Forecasting for intermittent demand:
the estimation of an unbiased average. \emph{Journal of the Operational Research Society}, \bold{57}(5), 588-592.

Shenstone, L., and Hyndman, R.J. (2005) "Stochastic models underlying
Croston's method for intermittent demand forecasting". \emph{Journal of
Forecasting}, \bold{24}, 389-402.

Syntetos A.A., Boylan J.E. (2001). On the bias of intermittent demand estimates.
\emph{International Journal of Production Economics}, \bold{71}, 457–466.
}
\seealso{
\code{\link[=ses]{ses()}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
