#!/usr/bin/env python3
import mysql.connector
import yaml
import re
import os

# import json
db = mysql.connector.connect(host="webapps-db-prod", user="ecmwf_ro", password="ecmwf_ro", database="param")
# db = MySQLdb.connect("bol-db-products-prod-01.ecmwf.int", "ecmwf_ro", "ecmwf_ro", "chem")
# db = MySQLdb.connect("k8s-bol-webapps-test-worker-016.ecmwf.int", "products", "products", "chem", port=30544)
                     
PRODGEN = {}
if os.path.exists("prodgen-chemids.yaml"):
    with open("prodgen-chemids.yaml") as f:
        PRODGEN = yaml.load(f.read(), Loader=yaml.FullLoader)
    PRODGEN = {item[0]: item[1:] for item in PRODGEN}

# print(json.dumps(PRODGEN))

CHEMSIDS = {}
if os.path.exists("chemids.yaml"):
    with open("chemids.yaml") as f:
        CHEMSIDSTMP = yaml.load(f.read(), Loader=yaml.FullLoader)
    # Convert list of lists to dictionary
    CHEMSIDS = {item[0]: item[1:] for item in CHEMSIDS}

cursor = db.cursor()

cursor.execute("select * from chem")

for data in cursor.fetchall():
    chemid, abbr, longname = int(data[0]), data[1].lower(), data[2].lower()

    abbr = re.sub(r"\W", "_", abbr)
    abbr = re.sub(r"_+", "_", abbr)
    abbr = re.sub(r"^_", "", abbr)
    abbr = re.sub(r"_$", "", abbr)

    if not abbr:
        abbr = "_chem_%06d" % (chemid,)

    entry = [abbr.strip(), longname.strip()]

    if chemid in PRODGEN:
        pgen = [str(x).lower() for x in PRODGEN[chemid]]
        p = []
        for n in pgen:
            if (
                n not in entry
            ):  #  and (' ' not in n) and ('.' not in n): #  and ('-' not in n):
                entry.append(n)
                p.append(n)

    entry = tuple(entry)

    if chemid in CHEMSIDS:
        before = tuple(CHEMSIDS[chemid])
        if before != entry:
            print(
                "WARNING! updated chemid: {},  {} => {}".format(chemid, before, entry)
            )
            CHEMSIDS[chemid] = list(entry)
    else:
        print("new chemid: {} {}".format(chemid, entry))
        CHEMSIDS[chemid] = list(entry)

cursor.close()
db.close()


for chemid, entry in PRODGEN.items():
    if chemid not in CHEMSIDS:
        print("WARNING! adding pseudo-chemid: {},  {}".format(chemid, tuple(entry)))
        CHEMSIDS[chemid] = entry

# Convert to list of lists
chemid_list = [[k] + v for k, v in CHEMSIDS.items()]

with open("chemids.yaml", "w") as f:
    f.write(
        "# File automatically generated by %s\n# Do not edit\n\n"
        % (os.path.basename(__file__))
    )
#    f.write(yaml.safe_dump(CHEMSIDS, default_flow_style=True))
    yaml.safe_dump(chemid_list, f, default_flow_style=None)