/*
 * Copyright 2012 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
#include "include/core/SkPath.h"
#include "include/core/SkPathBuilder.h"
#include "include/core/SkPathTypes.h"
#include "include/pathops/SkPathOps.h"
#include "src/base/SkFloatBits.h"
#include "tests/PathOpsExtendedTest.h"
#include "tests/Test.h"

#include <array>
#include <cstddef>

#define TEST(name) { name, #name }

static void skpcheeseandburger_com225(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(555, 468);
    builder.lineTo(555, 362);
    builder.lineTo(872, 362);
    builder.lineTo(872, 468);
    builder.lineTo(555, 468);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(859.11792f, 397.320343f);
    builderB.cubicTo(855.523071f, 399.691284f, 853.721191f, 402.40863f, 853.721191f, 405.552216f);
    builderB.cubicTo(853.721191f, 407.911163f, 854.727478f, 410.115387f, 857.043518f, 412.252716f);
    builderB.cubicTo(859.920532f, 414.916138f, 862.704773f, 417.086426f, 864.679382f, 418.852386f);
    builderB.cubicTo(866.382446f, 420.371765f, 867.19104f, 422.108795f, 867.19104f, 423.506378f);
    builderB.cubicTo(867.19104f, 424.551605f, 866.741821f, 425.539886f, 865.935242f, 426.281616f);
    builderB.cubicTo(865.250366f, 426.910553f, 864.662415f, 427.339813f, 864.139282f, 427.4646f);
    builderB.cubicTo(863.536377f, 427.605347f, 862.259521f, 426.491272f, 860.366821f, 424.208191f);
    builderB.cubicTo(858.345276f, 421.770355f, 857.317017f, 419.733856f, 857.317017f, 417.98587f);
    builderB.cubicTo(857.317017f, 417.198212f, 857.942993f, 415.930389f, 857.942993f, 415.930389f);
    builderB.cubicTo(857.942993f, 415.930389f, 852.106018f, 421.296173f, 852.279663f, 422.549042f);
    builderB.cubicTo(852.462402f, 423.890747f, 853.669312f, 425.703613f, 855.876465f, 428.252258f);
    builderB.cubicTo(858.038818f, 430.754944f, 859.4953f, 431.840088f, 860.190125f, 431.594513f);
    builderB.cubicTo(862.571045f, 430.754944f, 865.48999f, 429.237549f, 868.44397f, 427.018372f);
    builderB.cubicTo(870.505371f, 425.470032f, 871.582581f, 423.534332f, 871.582581f, 421.001678f);
    builderB.cubicTo(871.582581f, 417.945923f, 870.056213f, 415.171692f, 867.015381f, 412.640045f);
    builderB.cubicTo(863.683105f, 409.872803f, 861.445923f, 408.027954f, 860.551514f, 407.140503f);
    builderB.cubicTo(858.660767f, 405.264709f, 857.765259f, 403.50174f, 857.765259f, 402.187988f);
    builderB.cubicTo(857.765259f, 401.141785f, 858.339355f, 400.394073f, 859.476318f, 399.925873f);
    builderB.cubicTo(860.004395f, 399.704254f, 861.270264f, 400.515869f, 863.156006f, 402.36969f);
    builderB.cubicTo(865.094727f, 404.28241f, 866.203796f, 405.565186f, 866.383484f, 406.130219f);
    builderB.cubicTo(868.250244f, 404.305359f, 869.179688f, 403.397919f, 871.046509f, 401.58902f);
    builderB.cubicTo(868.26825f, 399.296967f, 864.431824f, 394.705841f, 863.156006f, 394.600037f);
    builderB.cubicTo(863.145996f, 394.600037f, 863.136108f, 394.59903f, 863.126099f, 394.59903f);
    builderB.cubicTo(862.352417f, 394.598022f, 859.909607f, 396.79425f, 859.11792f, 397.320343f);
    builderB.moveTo(832.164246f, 394.307526f);
    builderB.cubicTo(832.451721f, 394.425323f, 832.598511f, 394.486206f, 832.886963f, 394.605011f);
    builderB.cubicTo(834.078979f, 395.474518f, 834.674927f, 395.90979f, 835.867859f, 396.781281f);
    builderB.cubicTo(836.502808f, 397.325348f, 836.863159f, 398.000183f, 836.863159f, 398.964539f);
    builderB.lineTo(836.863159f, 419.740845f);
    builderB.cubicTo(836.863159f, 420.876923f, 836.319092f, 422.17868f, 835.055298f, 423.617188f);
    builderB.cubicTo(836.39502f, 424.512665f, 837.063843f, 424.961884f, 838.39856f, 425.864349f);
    builderB.cubicTo(839.477661f, 426.578125f, 841.37439f, 427.27594f, 842.275879f, 427.443634f);
    builderB.cubicTo(842.999634f, 427.574402f, 843.82019f, 427.513519f, 844.354309f, 427.216034f);
    builderB.cubicTo(846.956787f, 425.765503f, 848.689819f, 423.588257f, 848.58606f, 423.483429f);
    builderB.cubicTo(848.58606f, 423.483429f, 846.877991f, 423.327698f, 845.971558f, 422.807587f);
    builderB.cubicTo(845.253784f, 422.284485f, 844.892395f, 422.022949f, 844.171631f, 421.502838f);
    builderB.cubicTo(843.361023f, 420.915833f, 842.907837f, 420.308899f, 842.907837f, 419.350525f);
    builderB.lineTo(842.907837f, 399.445709f);
    builderB.cubicTo(842.907837f, 398.053101f, 843.272217f, 397.417175f, 843.812256f, 397.518005f);
    builderB.cubicTo(844.170654f, 397.583893f, 844.711731f, 398.122986f, 845.432495f, 398.782837f);
    builderB.cubicTo(846.116333f, 399.402771f, 846.459717f, 399.709259f, 847.14856f, 400.3302f);
    builderB.cubicTo(844.986206f, 402.099152f, 843.988892f, 403.926025f, 843.988892f, 405.932556f);
    builderB.cubicTo(843.988892f, 410.209229f, 848.272583f, 410.951935f, 849.576355f, 408.394348f);
    builderB.cubicTo(849.871826f, 407.816345f, 850.421875f, 406.214081f, 850.387939f, 406.196106f);
    builderB.cubicTo(850.387939f, 406.196106f, 849.305786f, 406.771118f, 848.495239f, 406.615387f);
    builderB.cubicTo(846.96582f, 406.316895f, 846.153198f, 405.46637f, 846.153198f, 403.89505f);
    builderB.cubicTo(846.153198f, 401.796661f, 848.50116f, 399.09729f, 852.279663f, 396.270142f);
    builderB.cubicTo(851.014893f, 395.315796f, 847.723511f, 391.546265f, 846.875f, 391.546265f);
    builderB.cubicTo(846.330933f, 391.546265f, 843.988892f, 394.403351f, 843.273193f, 394.972382f);
    builderB.cubicTo(840.889282f, 392.886963f, 839.700317f, 391.850739f, 837.312378f, 389.786285f);
    builderB.cubicTo(835.257935f, 391.589203f, 834.225708f, 392.491638f, 832.164246f, 394.307526f);
    builderB.moveTo(818.860107f, 392.707275f);
    builderB.cubicTo(819.857361f, 393.382111f, 822.302124f, 395.764038f, 824.387573f, 397.051819f);
    builderB.cubicTo(822.57666f, 398.249756f, 820.582092f, 399.687286f, 818.860107f, 400.827332f);
    builderB.lineTo(818.860107f, 392.707275f);
    builderB.close();
    builderB.moveTo(810.69812f, 391.096039f);
    builderB.cubicTo(810.69812f, 391.096039f, 812.786499f, 394.093903f, 812.786499f, 394.965393f);
    builderB.lineTo(812.786499f, 415.743713f);
    builderB.cubicTo(812.786499f, 417.753265f, 811.881042f, 418.497986f, 810.974609f, 419.769806f);
    builderB.cubicTo(813.948486f, 421.160431f, 815.437988f, 421.864197f, 818.404846f, 423.283783f);
    builderB.cubicTo(819.948181f, 423.95462f, 822.417969f, 424.592529f, 823.937317f, 423.782928f);
    builderB.cubicTo(827.905518f, 421.663544f, 831.53125f, 417.600525f, 832.255005f, 415.191681f);
    builderB.cubicTo(833.882263f, 409.877808f, 823.095825f, 411.495026f, 823.119751f, 411.518982f);
    builderB.cubicTo(823.119751f, 411.518982f, 832.000488f, 411.874359f, 830.537964f, 416.29776f);
    builderB.cubicTo(829.888123f, 418.253418f, 827.278564f, 420.292908f, 825.385864f, 419.55719f);
    builderB.cubicTo(821.14209f, 417.915985f, 818.861023f, 417.414856f, 818.861023f, 414.970032f);
    builderB.lineTo(818.861023f, 403.096436f);
    builderB.cubicTo(822.126404f, 399.132233f, 831.289673f, 395.897797f, 831.356567f, 395.657227f);
    builderB.cubicTo(831.356567f, 395.657227f, 823.022888f, 387.594055f, 821.763062f, 387.476257f);
    builderB.cubicTo(821.755066f, 387.47525f, 821.746094f, 387.47525f, 821.737061f, 387.47525f);
    builderB.cubicTo(820.793701f, 387.47525f, 810.72406f, 390.967255f, 810.69812f, 391.096039f);
    builderB.moveTo(624.254211f, 390.498077f);
    builderB.cubicTo(625.252502f, 390.893402f, 627.708252f, 392.592468f, 629.796692f, 393.307251f);
    builderB.cubicTo(627.978821f, 395.006317f, 625.980225f, 397.000916f, 624.254211f, 398.618134f);
    builderB.lineTo(624.254211f, 390.498077f);
    builderB.close();
    builderB.moveTo(627.160217f, 384.460449f);
    builderB.cubicTo(626.286743f, 384.51535f, 616.076233f, 390.993225f, 616.086243f, 391.141968f);
    builderB.cubicTo(616.086243f, 391.141968f, 618.173645f, 393.561798f, 618.173645f, 394.437317f);
    builderB.lineTo(618.173645f, 415.216614f);
    builderB.cubicTo(618.173645f, 417.222168f, 617.265198f, 418.219482f, 616.355774f, 419.742859f);
    builderB.cubicTo(619.331665f, 420.307892f, 620.824097f, 420.599396f, 623.802979f, 421.198364f);
    builderB.cubicTo(625.346313f, 421.437958f, 627.818115f, 421.39801f, 629.342468f, 420.166138f);
    builderB.cubicTo(633.340576f, 416.939667f, 636.982361f, 411.871368f, 637.714111f, 409.263855f);
    builderB.cubicTo(639.348267f, 403.500732f, 628.508911f, 408.111816f, 628.52887f, 408.126801f);
    builderB.cubicTo(628.52887f, 408.126801f, 637.468506f, 405.998444f, 635.985046f, 410.844147f);
    builderB.cubicTo(635.332153f, 412.984467f, 632.705688f, 415.748718f, 630.801941f, 415.541077f);
    builderB.cubicTo(626.537292f, 415.072876f, 624.257202f, 415.202667f, 624.257202f, 412.755859f);
    builderB.cubicTo(624.257202f, 408.007019f, 624.255188f, 405.636078f, 624.255188f, 400.884247f);
    builderB.cubicTo(627.525574f, 396.016602f, 636.801636f, 390.283447f, 636.801636f, 389.97995f);
    builderB.cubicTo(636.801636f, 389.97995f, 628.360168f, 384.458435f, 627.18219f, 384.458435f);
    builderB.cubicTo(627.174194f, 384.460449f, 627.167236f, 384.460449f, 627.160217f, 384.460449f);
    builderB.moveTo(796.530396f, 416.438538f);
    builderB.cubicTo(795.892517f, 416.365662f, 794.527832f, 415.589996f, 792.348572f, 414.036652f);
    builderB.lineTo(792.348572f, 391.425476f);
    builderB.cubicTo(792.348572f, 390.465118f, 792.530273f, 390.047852f, 792.89563f, 390.088776f);
    builderB.cubicTo(793.075317f, 390.109741f, 793.3479f, 390.317383f, 793.804077f, 390.629852f);
    builderB.cubicTo(795.113831f, 391.585205f, 795.768738f, 392.059387f, 797.077515f, 393.018738f);
    builderB.cubicTo(797.983948f, 393.648651f, 798.348267f, 394.219666f, 798.348267f, 394.742767f);
    builderB.lineTo(798.348267f, 413.253998f);
    builderB.cubicTo(798.348267f, 415.391327f, 797.783264f, 416.451508f, 796.728088f, 416.451508f);
    builderB.cubicTo(796.664185f, 416.4505f, 796.598267f, 416.446533f, 796.530396f, 416.438538f);
    builderB.moveTo(795.165771f, 383.714722f);
    builderB.cubicTo(794.022705f, 383.851471f, 783.959961f, 388.652252f, 783.880127f, 388.873871f);
    builderB.cubicTo(783.880127f, 388.873871f, 785.054077f, 389.871155f, 785.522339f, 390.606873f);
    builderB.cubicTo(786.000488f, 391.361603f, 786.246094f, 391.9935f, 786.246094f, 392.427765f);
    builderB.lineTo(786.246094f, 411.987183f);
    builderB.cubicTo(786.246094f, 413.733185f, 784.160645f, 416.428558f, 784.246521f, 416.759979f);
    builderB.cubicTo(784.258484f, 416.79892f, 785.432495f, 417.14032f, 785.793823f, 417.350952f);
    builderB.cubicTo(786.739258f, 417.937958f, 787.213379f, 418.228455f, 788.161804f, 418.821442f);
    builderB.cubicTo(789.342773f, 419.554199f, 790.619568f, 419.956482f, 791.892395f, 420.098236f);
    builderB.cubicTo(794.533813f, 420.390747f, 796.717102f, 419.337555f, 798.349304f, 416.999573f);
    builderB.lineTo(798.349304f, 425.212463f);
    builderB.cubicTo(797.94696f, 425.47702f, 797.750305f, 425.609772f, 797.356018f, 425.874329f);
    builderB.cubicTo(795.259583f, 423.619202f, 792.806824f, 422.286499f, 789.985657f, 421.984009f);
    builderB.cubicTo(785.157959f, 421.463898f, 780.409119f, 428.344086f, 780.423096f, 428.346069f);
    builderB.cubicTo(780.423096f, 428.346069f, 783.340088f, 424.960907f, 785.889709f, 425.218445f);
    builderB.cubicTo(789.25592f, 425.565857f, 793.166199f, 430.745972f, 793.805115f, 430.790894f);
    builderB.cubicTo(793.940857f, 430.798889f, 795.918457f, 429.091797f, 798.454102f, 427.383728f);
    builderB.cubicTo(801.049683f, 425.635742f, 804.230225f, 423.886749f, 806.619141f, 423.980591f);
    builderB.cubicTo(805.621826f, 423.586243f, 805.048828f, 423.074127f, 804.804199f, 422.609924f);
    builderB.cubicTo(804.616577f, 422.25354f, 804.616577f, 421.539764f, 804.616577f, 420.31488f);
    builderB.cubicTo(804.623535f, 411.732605f, 804.623535f, 403.147339f, 804.623535f, 394.562073f);
    builderB.cubicTo(804.623535f, 392.464691f, 805.970215f, 391.000183f, 805.984192f, 390.896362f);
    builderB.cubicTo(805.984192f, 390.896362f, 796.785034f, 383.7117f, 795.219666f, 383.7117f);
    builderB.cubicTo(795.19873f, 383.712708f, 795.181763f, 383.712708f, 795.165771f, 383.714722f);
    builderB.moveTo(648.092285f, 387.883545f);
    builderB.cubicTo(649.095581f, 388.312805f, 651.55835f, 390.099762f, 653.655701f, 390.884399f);
    builderB.cubicTo(651.831848f, 392.522583f, 649.82428f, 394.447296f, 648.092285f, 396.003601f);
    builderB.lineTo(648.092285f, 387.883545f);
    builderB.close();
    builderB.moveTo(651.009277f, 381.943756f);
    builderB.cubicTo(650.147766f, 381.983704f, 639.893372f, 388.105164f, 639.899353f, 388.254913f);
    builderB.cubicTo(639.899353f, 388.254913f, 641.987793f, 390.744659f, 641.987793f, 391.617157f);
    builderB.lineTo(641.987793f, 412.399475f);
    builderB.cubicTo(641.987793f, 414.409027f, 641.082336f, 415.369354f, 640.169861f, 416.864807f);
    builderB.cubicTo(643.155762f, 417.53064f, 644.650208f, 417.87207f, 647.638062f, 418.573853f);
    builderB.cubicTo(649.188416f, 418.865356f, 651.666138f, 418.908295f, 653.19751f, 417.725311f);
    builderB.cubicTo(657.204651f, 414.633636f, 660.859375f, 409.690125f, 661.590088f, 407.106567f);
    builderB.cubicTo(663.231262f, 401.397339f, 652.356934f, 405.644073f, 652.375916f, 405.663025f);
    builderB.cubicTo(652.375916f, 405.663025f, 661.338562f, 403.835175f, 659.857056f, 408.632935f);
    builderB.cubicTo(659.199219f, 410.748291f, 656.568726f, 413.424713f, 654.656982f, 413.151184f);
    builderB.cubicTo(650.381348f, 412.536224f, 648.092285f, 412.591125f, 648.092285f, 410.146332f);
    builderB.lineTo(648.092285f, 398.270721f);
    builderB.cubicTo(651.374634f, 393.5159f, 660.66571f, 388.09021f, 660.674683f, 387.791718f);
    builderB.cubicTo(660.674683f, 387.791718f, 652.188232f, 381.941772f, 651.022278f, 381.942749f);
    builderB.cubicTo(651.01825f, 381.942749f, 651.013245f, 381.942749f, 651.009277f, 381.943756f);
    builderB.moveTo(761.636353f, 385.965851f);
    builderB.cubicTo(761.927856f, 386.056702f, 762.071594f, 386.098633f, 762.363098f, 386.189453f);
    builderB.cubicTo(763.570007f, 386.938171f, 764.175964f, 387.311554f, 765.376892f, 388.066254f);
    builderB.cubicTo(766.019775f, 388.546417f, 766.384155f, 389.184326f, 766.384155f, 390.147675f);
    builderB.lineTo(766.384155f, 410.924011f);
    builderB.cubicTo(766.384155f, 412.057037f, 765.836121f, 413.410736f, 764.559326f, 414.979034f);
    builderB.cubicTo(765.911987f, 415.738739f, 766.579834f, 416.12207f, 767.934509f, 416.887756f);
    builderB.cubicTo(769.029602f, 417.495728f, 770.944336f, 418.000854f, 771.85675f, 418.075714f);
    builderB.cubicTo(772.58551f, 418.134613f, 773.413086f, 417.987854f, 773.950195f, 417.638458f);
    builderB.cubicTo(776.583618f, 415.917419f, 778.332642f, 413.564453f, 778.237793f, 413.473633f);
    builderB.cubicTo(778.237793f, 413.473633f, 776.507812f, 413.497559f, 775.596313f, 413.066315f);
    builderB.cubicTo(774.866577f, 412.61908f, 774.497253f, 412.39447f, 773.771484f, 411.951233f);
    builderB.cubicTo(772.947876f, 411.444092f, 772.493652f, 410.877075f, 772.493652f, 409.919708f);
    builderB.lineTo(772.493652f, 390.013885f);
    builderB.cubicTo(772.493652f, 388.618286f, 772.860046f, 387.949432f, 773.407104f, 387.995361f);
    builderB.cubicTo(773.771484f, 388.026306f, 774.318542f, 388.509491f, 775.049316f, 389.09848f);
    builderB.cubicTo(775.742065f, 389.646515f, 776.088501f, 389.923065f, 776.77533f, 390.470123f);
    builderB.cubicTo(774.590088f, 392.45871f, 773.589783f, 394.385376f, 773.589783f, 396.395935f);
    builderB.cubicTo(773.589783f, 400.673584f, 777.907349f, 401.008026f, 779.237122f, 398.292694f);
    builderB.cubicTo(779.539551f, 397.684723f, 780.089661f, 396.027557f, 780.058716f, 396.01358f);
    builderB.cubicTo(780.058716f, 396.01358f, 778.970581f, 396.694427f, 778.149963f, 396.618561f);
    builderB.cubicTo(776.598633f, 396.4758f, 775.775024f, 395.709106f, 775.775024f, 394.13681f);
    builderB.cubicTo(775.775024f, 392.042419f, 778.149963f, 389.103455f, 781.973389f, 385.892975f);
    builderB.cubicTo(780.697571f, 385.06839f, 777.326416f, 381.676208f, 776.506775f, 381.719147f);
    builderB.cubicTo(775.908813f, 381.747101f, 773.588806f, 384.868744f, 772.860046f, 385.506622f);
    builderB.cubicTo(770.451172f, 383.664795f, 769.248291f, 382.749359f, 766.843384f, 380.929504f);
    builderB.cubicTo(764.758972f, 382.934052f, 763.716736f, 383.940338f, 761.636353f, 385.965851f);
    builderB.moveTo(672.996521f, 379.821411f);
    builderB.cubicTo(672.123047f, 379.891266f, 669.7052f, 382.898132f, 668.887573f, 383.64682f);
    builderB.cubicTo(665.239868f, 386.999084f, 663.41095f, 390.213562f, 663.41095f, 393.356171f);
    builderB.cubicTo(663.41095f, 395.715118f, 664.439209f, 397.642792f, 666.785156f, 399.150208f);
    builderB.cubicTo(669.702148f, 401.02002f, 672.547302f, 402.439575f, 674.545837f, 403.655487f);
    builderB.cubicTo(676.261902f, 404.697693f, 677.105469f, 406.231049f, 677.105469f, 407.625671f);
    builderB.cubicTo(677.105469f, 408.671875f, 676.651245f, 409.777954f, 675.825684f, 410.7453f);
    builderB.cubicTo(675.12384f, 411.569885f, 674.538879f, 412.145905f, 673.997803f, 412.417419f);
    builderB.cubicTo(673.38385f, 412.724915f, 672.080078f, 411.958221f, 670.166382f, 410.198242f);
    builderB.cubicTo(668.113892f, 408.319458f, 667.062683f, 406.55249f, 667.062683f, 404.808502f);
    builderB.cubicTo(667.062683f, 404.020844f, 667.701599f, 402.580322f, 667.701599f, 402.580322f);
    builderB.cubicTo(667.701599f, 402.580322f, 661.773804f, 409.542358f, 661.951477f, 410.7453f);
    builderB.cubicTo(662.13916f, 412.037079f, 663.368042f, 413.524536f, 665.60321f, 415.469208f);
    builderB.cubicTo(667.791443f, 417.368927f, 669.261963f, 418.074738f, 669.983704f, 417.630493f);
    builderB.cubicTo(672.412537f, 416.138062f, 675.369446f, 413.822021f, 678.385254f, 410.790222f);
    builderB.cubicTo(680.485657f, 408.677856f, 681.587769f, 406.446686f, 681.587769f, 403.917023f);
    builderB.cubicTo(681.587769f, 400.859283f, 680.007446f, 398.490356f, 676.923767f, 396.806244f);
    builderB.cubicTo(673.540588f, 394.957428f, 671.257507f, 393.71756f, 670.351074f, 393.075653f);
    builderB.cubicTo(668.434326f, 391.71698f, 667.518921f, 390.193604f, 667.518921f, 388.88385f);
    builderB.cubicTo(667.518921f, 387.837646f, 668.101929f, 386.934204f, 669.25592f, 386.156525f);
    builderB.cubicTo(669.796997f, 385.788147f, 671.085815f, 386.257355f, 672.997498f, 387.592072f);
    builderB.cubicTo(674.966125f, 388.968689f, 676.104187f, 389.951019f, 676.284851f, 390.465118f);
    builderB.cubicTo(678.186584f, 388.130127f, 679.136963f, 386.966125f, 681.035706f, 384.646118f);
    builderB.cubicTo(678.244507f, 383.133728f, 674.247375f, 379.819397f, 673.044434f, 379.819397f);
    builderB.cubicTo(673.027466f, 379.819397f, 673.011475f, 379.820404f, 672.996521f, 379.821411f);
    builderB.moveTo(732.95459f, 384.60318f);
    builderB.cubicTo(733.246094f, 384.680054f, 733.391846f, 384.720001f, 733.689331f, 384.794861f);
    builderB.cubicTo(735.072937f, 385.500641f, 735.769714f, 385.856049f, 737.162354f, 386.563812f);
    builderB.cubicTo(737.891113f, 386.938171f, 738.164612f, 387.642975f, 738.164612f, 388.6073f);
    builderB.lineTo(738.164612f, 408.510132f);
    builderB.cubicTo(738.164612f, 410.257141f, 737.709412f, 411.893341f, 736.064209f, 413.416718f);
    builderB.cubicTo(737.635498f, 414.235321f, 738.419189f, 414.651611f, 739.991455f, 415.475189f);
    builderB.cubicTo(740.997742f, 416.034241f, 742.186707f, 416.344696f, 743.098145f, 416.379639f);
    builderB.cubicTo(743.830872f, 416.410583f, 744.476807f, 416.175964f, 745.019836f, 415.851532f);
    builderB.cubicTo(746.476318f, 414.977051f, 748.58075f, 413.571442f, 749.225647f, 413.079285f);
    builderB.cubicTo(751.012573f, 414.253296f, 751.907043f, 414.845276f, 753.69696f, 416.028229f);
    builderB.cubicTo(754.703247f, 416.610229f, 755.706543f, 416.84082f, 756.528076f, 416.892761f);
    builderB.cubicTo(757.259827f, 416.93866f, 757.996582f, 416.807892f, 758.537659f, 416.494446f);
    builderB.cubicTo(760.814758f, 415.174713f, 762.185425f, 413.509552f, 762.552734f, 412.830719f);
    builderB.cubicTo(761.637329f, 412.681976f, 759.633789f, 411.58786f, 759.263428f, 411.387207f);
    builderB.cubicTo(758.607544f, 410.994873f, 758.279114f, 410.803223f, 757.621216f, 410.413879f);
    builderB.cubicTo(756.983276f, 410.020538f, 756.616943f, 409.301788f, 756.616943f, 408.343445f);
    builderB.lineTo(756.616943f, 388.351746f);
    builderB.cubicTo(756.616943f, 387.387421f, 757.164978f, 386.548859f, 758.627502f, 385.067383f);
    builderB.cubicTo(755.523804f, 383.05484f, 753.97052f, 382.057556f, 750.862854f, 380.078949f);
    builderB.cubicTo(749.001038f, 382.112457f, 748.069641f, 383.130707f, 746.207825f, 385.174194f);
    builderB.cubicTo(746.501343f, 385.292999f, 746.647095f, 385.353912f, 746.939575f, 385.472687f);
    builderB.cubicTo(747.996765f, 386.183472f, 748.525879f, 386.538879f, 749.587036f, 387.257629f);
    builderB.cubicTo(750.224915f, 387.724823f, 750.498474f, 388.351746f, 750.498474f, 389.223267f);
    builderB.lineTo(750.498474f, 407.822327f);
    builderB.cubicTo(750.498474f, 408.694824f, 750.339722f, 409.955658f, 749.951416f, 410.847137f);
    builderB.cubicTo(749.550049f, 411.761566f, 749.039978f, 411.585876f, 748.487915f, 411.560913f);
    builderB.cubicTo(747.393799f, 411.503998f, 746.385498f, 410.53067f, 745.473083f, 410.022552f);
    builderB.cubicTo(744.760254f, 409.627228f, 744.380981f, 409.013275f, 744.380981f, 407.965088f);
    builderB.lineTo(744.380981f, 386.840363f);
    builderB.cubicTo(744.380981f, 385.791138f, 744.833191f, 384.763916f, 745.657776f, 383.839508f);
    builderB.cubicTo(742.656921f, 382.101501f, 741.161499f, 381.234985f, 738.162659f, 379.525909f);
    builderB.cubicTo(736.083191f, 381.548431f, 735.039978f, 382.562683f, 732.95459f, 384.60318f);
    builderB.moveTo(692.546936f, 385.171204f);
    builderB.cubicTo(693.552246f, 385.667358f, 696.018005f, 387.607025f, 698.122375f, 388.521454f);
    builderB.cubicTo(696.293518f, 390.043854f, 694.281982f, 391.844757f, 692.546936f, 393.294281f);
    builderB.lineTo(692.546936f, 385.171204f);
    builderB.close();
    builderB.moveTo(695.4729f, 379.417084f);
    builderB.cubicTo(694.635376f, 379.426086f, 684.32605f, 384.880707f, 684.322083f, 385.025452f);
    builderB.cubicTo(684.322083f, 385.025452f, 686.422485f, 387.645966f, 686.422485f, 388.521454f);
    builderB.lineTo(686.422485f, 409.300781f);
    builderB.cubicTo(686.422485f, 411.312347f, 685.51001f, 412.21579f, 684.595581f, 413.65033f);
    builderB.cubicTo(687.592468f, 414.504852f, 689.089905f, 414.945099f, 692.088745f, 415.833557f);
    builderB.cubicTo(693.645081f, 416.221893f, 696.128784f, 416.420563f, 697.667114f, 415.334412f);
    builderB.cubicTo(701.67926f, 412.494293f, 705.344971f, 407.783386f, 706.077698f, 405.240753f);
    builderB.cubicTo(707.721924f, 399.638367f, 696.822632f, 403.198273f, 696.845581f, 403.216248f);
    builderB.cubicTo(696.845581f, 403.216248f, 705.825134f, 401.960388f, 704.337708f, 406.658325f);
    builderB.cubicTo(703.683838f, 408.733765f, 701.044373f, 411.241455f, 699.129639f, 410.847137f);
    builderB.cubicTo(694.843018f, 409.968628f, 692.545959f, 409.876801f, 692.545959f, 407.432983f);
    builderB.lineTo(692.545959f, 395.563354f);
    builderB.cubicTo(695.838318f, 391.012177f, 705.134338f, 386.160522f, 705.162292f, 385.873993f);
    builderB.cubicTo(705.162292f, 385.873993f, 696.635925f, 379.416107f, 695.473938f, 379.417084f);
    builderB.cubicTo(695.474915f, 379.417084f, 695.473938f, 379.417084f, 695.4729f, 379.417084f);
    builderB.moveTo(570.463562f, 420.81601f);
    builderB.lineTo(570.463562f, 402.922729f);
    builderB.cubicTo(571.039551f, 402.800934f, 571.327087f, 402.743042f, 571.901123f, 402.625244f);
    builderB.lineTo(571.901123f, 423.142029f);
    builderB.cubicTo(570.911804f, 422.823578f, 570.463562f, 422.123779f, 570.463562f, 420.81601f);
    builderB.moveTo(570.463562f, 384.062134f);
    builderB.cubicTo(571.039551f, 384.149963f, 571.327087f, 384.198883f, 571.901123f, 384.290741f);
    builderB.lineTo(571.901123f, 401.580048f);
    builderB.cubicTo(571.327087f, 401.695862f, 571.039551f, 401.756744f, 570.463562f, 401.874542f);
    builderB.lineTo(570.463562f, 384.062134f);
    builderB.close();
    builderB.moveTo(573.880676f, 376.556f);
    builderB.cubicTo(572.483093f, 376.996246f, 561.476013f, 385.624451f, 561.482971f, 385.70929f);
    builderB.cubicTo(561.482971f, 385.70929f, 563.637268f, 388.554413f, 563.637268f, 389.688446f);
    builderB.lineTo(563.637268f, 398.423462f);
    builderB.cubicTo(556.411682f, 399.838043f, 555.429382f, 404.307373f, 555.418396f, 405.679993f);
    builderB.lineTo(555.418396f, 405.724915f);
    builderB.cubicTo(555.42041f, 405.94455f, 555.448364f, 406.073334f, 555.477295f, 406.083313f);
    builderB.cubicTo(555.477295f, 406.083313f, 558.070862f, 404.250458f, 563.637268f, 403.222229f);
    builderB.lineTo(563.637268f, 404.797516f);
    builderB.cubicTo(556.993713f, 406.233063f, 555.191772f, 412.494293f, 555.569153f, 412.614105f);
    builderB.cubicTo(555.569153f, 412.614105f, 561.572815f, 410.21521f, 563.637268f, 409.598267f);
    builderB.lineTo(563.637268f, 424.00354f);
    builderB.cubicTo(563.637268f, 426.357483f, 563.36676f, 427.901855f, 562.291565f, 429.70874f);
    builderB.cubicTo(565.448181f, 430.067139f, 567.028442f, 430.256805f, 570.192017f, 430.653137f);
    builderB.cubicTo(571.99292f, 430.893707f, 574.782166f, 430.669098f, 576.403381f, 429.136719f);
    builderB.cubicTo(580.960571f, 424.828125f, 586.135681f, 419.346527f, 586.135681f, 416.115082f);
    builderB.lineTo(586.135681f, 406.511566f);
    builderB.cubicTo(586.135681f, 405.377533f, 586.047791f, 404.608856f, 586.678711f, 403.271149f);
    builderB.cubicTo(584.151062f, 404.98819f, 582.888245f, 405.851715f, 580.362549f, 407.587738f);
    builderB.cubicTo(579.281433f, 408.320465f, 579.192566f, 409.2948f, 579.192566f, 410.955933f);
    builderB.lineTo(579.192566f, 421.869202f);
    builderB.cubicTo(579.192566f, 423.180969f, 577.746033f, 423.273804f, 577.392639f, 423.266815f);
    builderB.cubicTo(575.636658f, 423.228882f, 574.153259f, 423.295776f, 573.071106f, 423.077148f);
    builderB.lineTo(573.071106f, 384.663086f);
    builderB.cubicTo(575.230408f, 385.379852f, 576.309509f, 385.742249f, 578.473816f, 386.473999f);
    builderB.cubicTo(579.373291f, 386.996094f, 579.553955f, 387.490234f, 579.553955f, 388.013336f);
    builderB.cubicTo(581.861023f, 384.848785f, 583.015991f, 383.267487f, 585.325073f, 380.114899f);
    builderB.cubicTo(581.680298f, 379.229431f, 575.865295f, 376.520081f, 574.157227f, 376.521057f);
    builderB.cubicTo(574.047424f, 376.522064f, 573.955566f, 376.533051f, 573.880676f, 376.556f);
    builderB.moveTo(593.447083f, 375.096527f);
    builderB.cubicTo(592.363953f, 375.804291f, 591.821899f, 376.772644f, 591.821899f, 377.908691f);
    builderB.lineTo(591.821899f, 419.46933f);
    builderB.cubicTo(591.821899f, 420.517517f, 591.187012f, 422.018951f, 589.921143f, 423.991577f);
    builderB.cubicTo(591.2948f, 424.412842f, 591.982605f, 424.622467f, 593.354248f, 425.050751f);
    builderB.cubicTo(594.53125f, 425.462036f, 595.525513f, 425.555878f, 596.427979f, 425.404144f);
    builderB.cubicTo(597.150757f, 425.279358f, 597.785645f, 424.914978f, 598.326721f, 424.475739f);
    builderB.cubicTo(600.935242f, 422.385315f, 602.846985f, 419.809753f, 602.759094f, 419.749847f);
    builderB.cubicTo(602.759094f, 419.749847f, 601.582153f, 419.935516f, 600.59082f, 419.831696f);
    builderB.cubicTo(600.0448f, 419.74585f, 599.774231f, 419.700928f, 599.233154f, 419.615082f);
    builderB.cubicTo(598.416565f, 419.484314f, 597.965332f, 418.860382f, 597.965332f, 417.988861f);
    builderB.lineTo(597.965332f, 396.857147f);
    builderB.cubicTo(597.965332f, 395.376678f, 598.326721f, 394.617004f, 598.867798f, 394.528137f);
    builderB.cubicTo(599.232178f, 394.466248f, 599.773254f, 394.731812f, 600.59082f, 395.124115f);
    builderB.cubicTo(601.601074f, 395.589325f, 602.111206f, 395.819946f, 603.123474f, 396.288116f);
    builderB.cubicTo(603.93811f, 396.686432f, 603.93512f, 397.38324f, 603.93512f, 398.169891f);
    builderB.cubicTo(603.93512f, 405.971497f, 603.93512f, 413.768127f, 603.93811f, 421.569702f);
    builderB.cubicTo(603.93811f, 425.325256f, 601.109924f, 430.634155f, 601.133911f, 430.656128f);
    builderB.cubicTo(601.133911f, 430.656128f, 605.184937f, 427.222015f, 607.017822f, 424.414825f);
    builderB.cubicTo(609.118164f, 421.201355f, 610.280212f, 417.987854f, 610.280212f, 415.109802f);
    builderB.lineTo(610.280212f, 394.593048f);
    builderB.cubicTo(610.280212f, 393.890228f, 610.823242f, 393.112579f, 611.728699f, 392.020447f);
    builderB.cubicTo(608.827698f, 390.960266f, 604.000977f, 387.703857f, 602.759094f, 387.967407f);
    builderB.cubicTo(602.120239f, 388.104187f, 599.957947f, 391.29071f, 597.965332f, 393.27829f);
    builderB.lineTo(597.965332f, 374.422668f);
    builderB.cubicTo(597.965332f, 373.461334f, 598.326721f, 372.440063f, 598.867798f, 371.567566f);
    builderB.cubicTo(596.701538f, 372.96817f, 595.616394f, 373.677948f, 593.447083f, 375.096527f);
    builderB.moveTo(718.054138f, 409.318756f);
    builderB.cubicTo(717.461182f, 408.789673f, 716.867188f, 408.178711f, 716.867188f, 407.218353f);
    builderB.lineTo(716.867188f, 387.053986f);
    builderB.cubicTo(716.867188f, 385.305969f, 717.323425f, 385.566528f, 718.328674f, 386.013763f);
    builderB.cubicTo(719.645386f, 386.859314f, 720.307251f, 387.284576f, 721.622009f, 388.135132f);
    builderB.cubicTo(722.266907f, 388.4935f, 722.903809f, 388.934753f, 722.903809f, 389.721405f);
    builderB.lineTo(722.903809f, 407.794373f);
    builderB.cubicTo(722.903809f, 408.66687f, 722.746094f, 410.490753f, 722.259888f, 410.758301f);
    builderB.cubicTo(722.125122f, 410.83017f, 721.950439f, 410.862122f, 721.746826f, 410.862122f);
    builderB.cubicTo(720.655701f, 410.864105f, 718.747925f, 409.936707f, 718.054138f, 409.318756f);
    builderB.moveTo(711.928711f, 364.782227f);
    builderB.cubicTo(711.195923f, 365.134613f, 710.648865f, 365.834412f, 710.648865f, 366.794769f);
    builderB.lineTo(710.648865f, 407.392059f);
    builderB.cubicTo(710.648865f, 409.397614f, 708.519531f, 411.37323f, 708.547485f, 411.684692f);
    builderB.cubicTo(708.550476f, 411.745605f, 711.838867f, 413.067322f, 713.849365f, 414.368073f);
    builderB.cubicTo(717.766663f, 416.906738f, 720.162537f, 415.845551f, 722.354797f, 414.073608f);
    builderB.cubicTo(724.059875f, 412.69397f, 726.55957f, 410.981903f, 730.675537f, 410.124359f);
    builderB.cubicTo(729.75708f, 409.143066f, 729.213013f, 407.993042f, 729.213013f, 406.683289f);
    builderB.cubicTo(729.213013f, 399.630402f, 729.209045f, 396.103455f, 729.209045f, 389.047546f);
    builderB.cubicTo(729.209045f, 387.648956f, 730.577698f, 385.292023f, 730.583679f, 385.149261f);
    builderB.cubicTo(730.583679f, 385.149261f, 720.888306f, 378.762207f, 719.609497f, 378.947906f);
    builderB.cubicTo(719.275085f, 378.996826f, 717.872498f, 381.118164f, 716.868225f, 381.896851f);
    builderB.lineTo(716.868225f, 365.046783f);
    builderB.cubicTo(716.868225f, 363.740021f, 716.960083f, 363.043213f, 717.597961f, 362);
    builderB.cubicTo(715.331848f, 363.104095f, 714.19873f, 363.657166f, 711.928711f, 364.782227f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpeverytechpro_blogspot_com100(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1074.29285f, 627.292786f);
    builder.quadTo(1074.58582f, 627, 1075, 627);
    builder.lineTo(1117, 627);
    builder.quadTo(1124.04163f, 627, 1129.02246f, 631.9776f);
    builder.quadTo(1134, 636.958374f, 1134, 644);
    builder.lineTo(1134, 645);
    builder.quadTo(1134, 652.041626f, 1129.02246f, 657.0224f);
    builder.quadTo(1124.04163f, 662, 1117, 662);
    builder.lineTo(1075, 662);
    builder.quadTo(1074.58582f, 662, 1074.29285f, 661.707214f);
    builder.quadTo(1074, 661.414185f, 1074, 661);
    builder.lineTo(1074, 628);
    builder.quadTo(1074, 627.585815f, 1074.29285f, 627.292786f);
    builder.close();
    builder.moveTo(1076, 629);
    builder.lineTo(1117, 629);
    builder.cubicTo(1125.2843f, 629, 1132, 635.715698f, 1132, 644);
    builder.lineTo(1132, 645);
    builder.cubicTo(1132, 653.284302f, 1125.2843f, 660, 1117, 660);
    builder.lineTo(1076, 660);
    builder.lineTo(1076, 629);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1074, 627);
    builderB.lineTo(1075, 628);
    builderB.lineTo(1116.5f, 644.5f);
    builderB.lineTo(1134, 627);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpflite_com41(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(301.464081f, 424);
    builder.lineTo(296, 433.46405f);
    builder.lineTo(296, 433.810822f);
    builder.lineTo(303.25589f, 438);
    builder.lineTo(304.729736f, 438);
    builder.lineTo(311, 427.139557f);
    builder.lineTo(311, 426.305237f);
    builder.lineTo(307.007202f, 424);
    builder.lineTo(301.464081f, 424);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(302.849854f, 421.599762f);
    builderB.lineTo(311.510101f, 426.599762f);
    builderB.lineTo(304.510101f, 438.724121f);
    builderB.lineTo(295.849854f, 433.724121f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpilkoora_com37(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(818, 157);
    builder.cubicTo(818, 148.715729f, 824.715698f, 142, 833, 142);
    builder.lineTo(909, 142);
    builder.lineTo(909, 143);
    builder.lineTo(833, 143);
    builder.cubicTo(825.268005f, 143, 819, 149.268005f, 819, 157);
    builder.lineTo(819, 926);
    builder.lineTo(818, 926);
    builder.lineTo(818, 157);
    builder.close();
    builder.moveTo(1184, 926);
    builder.lineTo(1185, 926);
    builder.lineTo(1185, 157);
    builder.cubicTo(1185, 148.715729f, 1178.2843f, 142, 1170, 142);
    builder.lineTo(1093, 142);
    builder.lineTo(1093, 143);
    builder.lineTo(1170, 143);
    builder.cubicTo(1177.73193f, 143, 1184, 149.268005f, 1184, 157);
    builder.lineTo(1184, 926);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1185, 142);
    builderB.lineTo(1001.5f, 325.5f);
    builderB.lineTo(1001.5f, 782.5f);
    builderB.lineTo(1185, 966);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpmm4everfriends_com43(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(540.74231f, 215.922546f);
    builder.cubicTo(540.893127f, 215.391159f, 541.443909f, 215.090134f, 541.972473f, 215.250168f);
    builder.lineTo(581.213318f, 227.131104f);
    builder.cubicTo(581.741882f, 227.291153f, 582.048157f, 227.851654f, 581.897339f, 228.383041f);
    builder.lineTo(576.708923f, 246.663925f);
    builder.cubicTo(576.558167f, 247.195297f, 576.007324f, 247.496338f, 575.47876f, 247.336288f);
    builder.lineTo(536.237915f, 235.455353f);
    builder.cubicTo(535.709351f, 235.295319f, 535.403137f, 234.734802f, 535.553894f, 234.20343f);
    builder.lineTo(540.74231f, 215.922546f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(541.015381f, 214.960388f);
    builderB.lineTo(582.17041f, 227.420883f);
    builderB.lineTo(576.435852f, 247.626068f);
    builderB.lineTo(535.280823f, 235.165573f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpmtrk_uz27(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(33, 787);
    builder.lineTo(33, 412);
    builder.lineTo(1233, 412);
    builder.lineTo(1233, 787);
    builder.quadTo(1233, 793.213196f, 1228.60803f, 797.607971f);
    builder.quadTo(1224.21326f, 802, 1218, 802);
    builder.lineTo(48, 802);
    builder.quadTo(41.7867966f, 802, 37.3919983f, 797.607971f);
    builder.quadTo(33, 793.213196f, 33, 787);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(33, 412);
    builderB.lineTo(1233, 412);
    builderB.lineTo(1233, 787);
    builderB.quadTo(1233, 793.213196f, 1228.60791f, 797.608032f);
    builderB.quadTo(1224.21313f, 802, 1218, 802);
    builderB.lineTo(48, 802);
    builderB.quadTo(41.7867432f, 802, 37.3919678f, 797.608032f);
    builderB.quadTo(33, 793.213196f, 33, 787);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpfrauen_magazin_com83(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(808, 886);
    builder.cubicTo(805.581055f, 886, 803.563293f, 887.717773f, 803.100037f, 890);
    builder.lineTo(1122.90002f, 890);
    builder.cubicTo(1122.43677f, 887.717773f, 1120.41895f, 886, 1118, 886);
    builder.lineTo(808, 886);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(808, 886);
    builderB.lineTo(1118, 886);
    builderB.cubicTo(1120.76147f, 886, 1123, 888.238586f, 1123, 891);
    builderB.lineTo(1123, 1521);
    builderB.cubicTo(1123, 1523.20911f, 1120.76147f, 1525, 1118, 1525);
    builderB.lineTo(808, 1525);
    builderB.cubicTo(805.238586f, 1525, 803, 1523.20911f, 803, 1521);
    builderB.lineTo(803, 891);
    builderB.cubicTo(803, 888.238586f, 805.238586f, 886, 808, 886);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpi_gino_com16(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(184, 734);
    builder.quadTo(133.051727f, 734, 97.0258636f, 770.025879f);
    builder.quadTo(61, 806.051758f, 61, 857);
    builder.quadTo(61, 895.835083f, 81.9317017f, 926);
    builder.lineTo(286.068298f, 926);
    builder.quadTo(307, 895.835083f, 307, 857);
    builder.quadTo(307, 806.051758f, 270.974121f, 770.025879f);
    builder.quadTo(234.948273f, 734, 184, 734);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(185, 734);
    builderB.cubicTo(252.93103f, 734, 308, 789.06897f, 308, 857);
    builderB.cubicTo(308, 924.93103f, 252.93103f, 980, 185, 980);
    builderB.lineTo(184, 980);
    builderB.cubicTo(116.068977f, 980, 61, 924.93103f, 61, 857);
    builderB.cubicTo(61, 789.06897f, 116.068977f, 734, 184, 734);
    builderB.lineTo(185, 734);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skppchappy_com_au102(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(363, 493);
    builder.cubicTo(360.790863f, 493, 359, 494.790863f, 359, 497);
    builder.lineTo(359, 656);
    builder.cubicTo(359, 658.209106f, 360.790863f, 660, 363, 660);
    builder.lineTo(623.001709f, 660);
    builder.cubicTo(624.657776f, 659.999023f, 626, 658.65625f, 626, 657);
    builder.lineTo(626, 496);
    builder.cubicTo(626, 494.343872f, 624.657959f, 493.00116f, 623.002075f, 493);
    builder.lineTo(363, 493);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(362, 494);
    builderB.lineTo(623, 494);
    builderB.cubicTo(624.65686f, 494, 626, 494.895416f, 626, 496);
    builderB.lineTo(626, 657);
    builderB.cubicTo(626, 658.65686f, 624.65686f, 660, 623, 660);
    builderB.lineTo(362, 660);
    builderB.cubicTo(360.34314f, 660, 359, 658.65686f, 359, 657);
    builderB.lineTo(359, 496);
    builderB.cubicTo(359, 494.895416f, 360.34314f, 494, 362, 494);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpsciality_com161(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(656, 728);
    builder.cubicTo(653.790833f, 728, 652, 729.790833f, 652, 732);
    builder.lineTo(652, 789);
    builder.cubicTo(652, 791.209106f, 653.790833f, 793, 656, 793);
    builder.lineTo(769.001282f, 793);
    builder.cubicTo(770.657532f, 792.999268f, 772, 791.656433f, 772, 790);
    builder.lineTo(772, 731);
    builder.cubicTo(772, 729.34314f, 770.65686f, 728, 769, 728);
    builder.lineTo(656, 728);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(655, 729);
    builderB.lineTo(769, 729);
    builderB.cubicTo(770.65686f, 729, 772, 729.895447f, 772, 731);
    builderB.lineTo(772, 790);
    builderB.cubicTo(772, 791.65686f, 770.65686f, 793, 769, 793);
    builderB.lineTo(655, 793);
    builderB.cubicTo(653.34314f, 793, 652, 791.65686f, 652, 790);
    builderB.lineTo(652, 731);
    builderB.cubicTo(652, 729.895447f, 653.34314f, 729, 655, 729);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpsudoestenegocios_com186(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(0, 495);
    builder.lineTo(1.23685242e-14f, 293);
    builder.lineTo(44, 293);
    builder.quadTo(45.6568527f, 293, 46.8288002f, 294.171204f);
    builder.quadTo(48, 295.34314f, 48, 297);
    builder.lineTo(48, 491);
    builder.quadTo(48, 492.65686f, 46.8288002f, 493.828796f);
    builder.quadTo(45.6568527f, 495, 44, 495);
    builder.lineTo(0, 495);
    builder.close();
    builder.moveTo(1, 294);
    builder.lineTo(44, 294);
    builder.cubicTo(45.6568565f, 294, 47, 295.34314f, 47, 297);
    builder.lineTo(47, 491);
    builder.cubicTo(47, 492.65686f, 45.6568565f, 494, 44, 494);
    builder.lineTo(1, 494);
    builder.lineTo(1, 294);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(48, 495);
    builderB.lineTo(24, 471);
    builderB.lineTo(24, 317);
    builderB.lineTo(48, 293);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpthesuburbanite_com213(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(863.439026f, 692);
    builder.lineTo(863.283264f, 692);
    builder.lineTo(802, 708.420837f);
    builder.lineTo(802, 718.773621f);
    builder.lineTo(866, 701.624817f);
    builder.lineTo(866, 701.557922f);
    builder.lineTo(863.439026f, 692);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(783.256775f, 713.443054f);
    builderB.lineTo(863.428589f, 691.96106f);
    builderB.lineTo(866.016724f, 701.620361f);
    builderB.lineTo(785.84491f, 723.102356f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skphostloco_com11(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(6.66133815e-16f, 648);
    builder.lineTo(25.8522835f, 648);
    builder.quadTo(27.5087376f, 647.999634f, 28.6807098f, 646.82843f);
    builder.quadTo(29.8518829f, 645.656433f, 29.8522835f, 644);
    builder.lineTo(29.8522835f, 467);
    builder.quadTo(29.8518829f, 465.343536f, 28.6807098f, 464.17157f);
    builder.quadTo(27.5087376f, 463.000397f, 25.8522835f, 463);
    builder.lineTo(2.22044605e-16f, 463);
    builder.lineTo(6.66133815e-16f, 648);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(0, 463);
    builderB.lineTo(30, 463);
    builderB.lineTo(30, 648);
    builderB.lineTo(0, 648);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpsergeychunkevich_com8(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(0, 926);
    builder.lineTo(0, 0);
    builder.lineTo(1265, 0);
    builder.lineTo(1265, 926);
    builder.lineTo(0, 926);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(37, 374);
    builderB.lineTo(37, 535);
    builderB.cubicTo(37, 536.65686f, 35.6568565f, 538, 34, 538);
    builderB.lineTo(1.02866934e-14f, 538);
    builderB.lineTo(6.12303177e-17f, 371);
    builderB.lineTo(34, 371);
    builderB.cubicTo(35.6568565f, 371, 37, 372.34314f, 37, 374);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skptracksflow_com9(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(16, 56);
    builder.lineTo(32, 56);
    builder.lineTo(32, 72);
    builder.lineTo(16, 72);
    builder.lineTo(16, 56);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kEvenOdd);
    builderB.moveTo(31.65625f, 70.0555649f);
    builderB.lineTo(31.65625f, 70.0554962f);
    builderB.lineTo(26.9727192f, 65.3615341f);
    builderB.cubicTo(27.6210003f, 64.4029694f, 28.0048752f, 63.2470932f, 28.0048752f, 62.0027809f);
    builderB.cubicTo(28.0048752f, 58.6875305f, 25.3199062f, 56, 22.0046558f, 56);
    builderB.cubicTo(18.6894073f, 56, 16.0031872f, 58.6875305f, 16.0031872f, 62.0027809f);
    builderB.cubicTo(16.0031872f, 65.3180008f, 18.6913433f, 68.0055618f, 22.0066261f, 68.0055618f);
    builderB.cubicTo(23.2509995f, 68.0055618f, 24.4072189f, 67.6187515f, 25.3657818f, 66.9704056f);
    builderB.lineTo(30.0599365f, 71.65625f);
    builderB.lineTo(30.0600014f, 71.65625f);
    builderB.cubicTo(30.2668133f, 71.875f, 30.5524693f, 71.9992828f, 30.868f, 71.9992828f);
    builderB.cubicTo(31.4994049f, 71.9992828f, 32.0014687f, 71.4909363f, 32.0014687f, 70.8595276f);
    builderB.cubicTo(32.0015335f, 70.5439072f, 31.875f, 70.2623444f, 31.65625f, 70.0555649f);
    builderB.close();
    builderB.moveTo(18.0054054f, 62.0027809f);
    builderB.cubicTo(18.0054054f, 59.7925949f, 19.7970943f, 58.0009079f, 22.0072823f, 58.0009079f);
    builderB.cubicTo(24.2174377f, 58.0009079f, 26.0091248f, 59.7925949f, 26.0091248f, 62.0027809f);
    builderB.cubicTo(26.0091248f, 64.2129364f, 24.2174377f, 66.0046234f, 22.0072803f, 66.0046234f);
    builderB.cubicTo(19.7970943f, 66.0045929f, 18.0054054f, 64.2129059f, 18.0054054f, 62.0027809f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpautobutler_dk29(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(0, 926);
    builder.lineTo(0, 0);
    builder.lineTo(1265, 0);
    builder.lineTo(1265, 926);
    builder.lineTo(0, 926);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(21, 162);
    builderB.lineTo(21, 301);
    builderB.lineTo(8.57224448e-15f, 301);
    builderB.lineTo(6.12303177e-17f, 162);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skponlinecollege_org144(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(179, 407);
    builder.cubicTo(177.34314f, 407, 176, 408.34314f, 176, 410);
    builder.lineTo(176, 436);
    builder.cubicTo(176, 437.65686f, 177.34314f, 439, 179, 439);
    builder.lineTo(337.002289f, 439);
    builder.cubicTo(338.105835f, 438.998779f, 339, 438.103821f, 339, 437);
    builder.lineTo(339, 409);
    builder.cubicTo(339, 407.896362f, 338.10611f, 407.001526f, 337.002838f, 407);
    builder.lineTo(179, 407);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(179, 408);
    builderB.lineTo(337, 408);
    builderB.cubicTo(338.65686f, 408, 340, 408.895416f, 340, 410);
    builderB.lineTo(340, 436);
    builderB.cubicTo(340, 437.65686f, 338.65686f, 439, 337, 439);
    builderB.lineTo(179, 439);
    builderB.cubicTo(177.895432f, 439, 177, 437.65686f, 177, 436);
    builderB.lineTo(177, 410);
    builderB.cubicTo(177, 408.895416f, 177.895432f, 408, 179, 408);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpnational_com_au81(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(807, 817);
    builder.quadTo(806.585876f, 817.000122f, 806.292908f, 817.292908f);
    builder.quadTo(806.000122f, 817.585876f, 806, 818);
    builder.lineTo(806, 881);
    builder.lineTo(1111, 881);
    builder.lineTo(1111, 818);
    builder.quadTo(1110.99988f, 817.585876f, 1110.70715f, 817.292908f);
    builder.quadTo(1110.41406f, 817.000122f, 1110, 817);
    builder.lineTo(807, 817);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(807, 817);
    builderB.lineTo(1110, 817);
    builderB.cubicTo(1110.55225f, 817, 1111, 817.447693f, 1111, 818);
    builderB.lineTo(1111, 880);
    builderB.lineTo(806, 880);
    builderB.lineTo(806, 818);
    builderB.cubicTo(806, 817.447693f, 806.447693f, 817, 807, 817);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skprentacheat_com30(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(967, 263);
    builder.quadTo(966.585876f, 263.000092f, 966.292908f, 263.292908f);
    builder.quadTo(966.000122f, 263.585876f, 966, 264);
    builder.lineTo(966, 301);
    builder.lineTo(1214, 301);
    builder.lineTo(1214, 264);
    builder.quadTo(1213.99988f, 263.585876f, 1213.70715f, 263.292908f);
    builder.quadTo(1213.41406f, 263.000092f, 1213, 263);
    builder.lineTo(967, 263);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(967, 263);
    builderB.lineTo(1213, 263);
    builderB.cubicTo(1213.55225f, 263, 1214, 263.447723f, 1214, 264);
    builderB.lineTo(1214, 300);
    builderB.lineTo(966, 300);
    builderB.lineTo(966, 264);
    builderB.cubicTo(966, 263.447723f, 966.447693f, 263, 967, 263);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpbreakmystyle_com10(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(271.032867f, -5.32907052e-15f);
    builder.lineTo(56.9671326f, -5.16253706e-15f);
    builder.quadTo(52.7835083f, 3.69968891f, 48.7416f, 7.74160004f);
    builder.quadTo(1, 55.4831848f, 1, 123);
    builder.quadTo(1, 190.516815f, 48.7416f, 238.258392f);
    builder.quadTo(96.4831848f, 286, 164, 286);
    builder.quadTo(231.516815f, 286, 279.258392f, 238.258392f);
    builder.quadTo(327, 190.516815f, 327, 123);
    builder.quadTo(327, 55.4831848f, 279.258392f, 7.74160004f);
    builder.quadTo(275.216431f, 3.69964004f, 271.032867f, -5.32907052e-15f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(327, 123);
    builderB.quadTo(327, 190.516815f, 279.258392f, 238.258392f);
    builderB.quadTo(231.516815f, 286, 164, 286);
    builderB.quadTo(96.4831848f, 286, 48.7416f, 238.258392f);
    builderB.quadTo(1, 190.516815f, 1, 123);
    builderB.quadTo(1, 55.4831848f, 48.7416f, 7.74160004f);
    builderB.quadTo(96.4831848f, -40, 164, -40);
    builderB.quadTo(231.516815f, -40, 279.258392f, 7.74160004f);
    builderB.quadTo(327, 55.4831848f, 327, 123);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpsd_graphic_net104(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(475.421448f, 836.985962f);
    builder.lineTo(461.280975f, 841.990662f);
    builder.cubicTo(466.80899f, 857.609802f, 458.62854f, 874.752991f, 443.009399f, 880.281006f);
    builder.cubicTo(435.199829f, 883.044983f, 427.009247f, 882.381897f, 420.080048f, 879.075378f);
    builder.lineTo(413.620056f, 892.613037f);
    builder.quadTo(430.419983f, 900.629761f, 447.96701f, 894.43811f);
    builder.quadTo(448.00708f, 894.42395f, 448.014038f, 894.421509f);
    builder.quadTo(448.043976f, 894.410889f, 448.061066f, 894.404846f);
    builder.quadTo(465.596313f, 888.179932f, 473.613037f, 871.379944f);
    builder.quadTo(477.351227f, 863.546143f, 478, 855.549866f);
    builder.lineTo(478, 848.804321f);
    builder.quadTo(477.528076f, 842.93811f, 475.421448f, 836.985962f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(405.592621f, 909.435547f);
    builderB.lineTo(390.578583f, 867.014099f);
    builderB.lineTo(433, 852.000061f);
    builderB.lineTo(490.435486f, 879.40741f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpnaoxrane_ru23(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(458.703552f, 275.050262f);
    builder.quadTo(487.41687f, 273.000702f, 528, 273);
    builder.lineTo(529, 273);
    builder.quadTo(530.242371f, 273.000305f, 531.121338f, 273.878693f);
    builder.quadTo(531.999695f, 274.75766f, 532, 276);
    builder.lineTo(532, 378);
    builder.quadTo(531.990173f, 380.898804f, 503.296448f, 382.949738f);
    builder.quadTo(474.58313f, 384.999298f, 434, 385);
    builder.lineTo(433, 385);
    builder.quadTo(431.75766f, 384.999695f, 430.878693f, 384.121307f);
    builder.quadTo(430.000305f, 383.24234f, 430, 382);
    builder.lineTo(430, 280);
    builder.quadTo(430.009796f, 277.101196f, 458.703552f, 275.050262f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(528, 278);
    builderB.lineTo(529, 278);
    builderB.cubicTo(530.65686f, 278, 532, 278, 532, 278);
    builderB.lineTo(532, 378);
    builderB.cubicTo(532, 379.104584f, 488.123932f, 380, 434, 380);
    builderB.lineTo(433, 380);
    builderB.cubicTo(431.34314f, 380, 430, 380, 430, 380);
    builderB.lineTo(430, 280);
    builderB.cubicTo(430, 278.895416f, 473.876068f, 278, 528, 278);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skptcmevents_org23(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(465.503998f, 546);
    builder.lineTo(347, 546);
    builder.lineTo(347, 632);
    builder.lineTo(469.104248f, 632);
    builder.quadTo(470.79007f, 627.638672f, 471.833496f, 621.036255f);
    builder.quadTo(474.902588f, 601.562866f, 470.591064f, 574.024353f);
    builder.lineTo(468.507751f, 560.724426f);
    builder.quadTo(467.275146f, 552.856262f, 465.84668f, 547.288391f);
    builder.quadTo(465.670349f, 546.601501f, 465.503998f, 546);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(363.052246f, 542.495361f);
    builderB.lineTo(463.779907f, 542.671143f);
    builderB.cubicTo(464.829529f, 542.672974f, 466.946289f, 550.755676f, 468.507751f, 560.724426f);
    builderB.lineTo(470.591064f, 574.024353f);
    builderB.cubicTo(476.26178f, 610.226624f, 471.498932f, 639.557922f, 459.953003f, 639.537781f);
    builderB.lineTo(368.727936f, 639.378601f);
    builderB.cubicTo(351.933868f, 639.349304f, 337.053741f, 631.244324f, 335.492249f, 621.275574f);
    builderB.lineTo(325.968597f, 560.475708f);
    builderB.cubicTo(324.407104f, 550.506958f, 341.01001f, 542.456909f, 363.052246f, 542.495361f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpredbullskatearcade_es16(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(936.765625f, 458.965302f);
    builder.cubicTo(937.028442f, 453.863251f, 933.145813f, 449.864502f, 928.093445f, 450.033905f);
    builder.lineTo(661.882263f, 458.958862f);
    builder.lineTo(661.875366f, 458.959106f);
    builder.cubicTo(656.828369f, 459.13205f, 652.525085f, 463.399719f, 652.258545f, 468.496124f);
    builder.lineTo(652.258179f, 468.503662f);
    builder.lineTo(649.021729f, 531.322754f);
    builder.cubicTo(648.75885f, 536.424805f, 652.641479f, 540.423523f, 657.693848f, 540.25415f);
    builder.lineTo(923.905029f, 531.329163f);
    builder.cubicTo(928.955017f, 531.159851f, 933.262268f, 526.890442f, 933.528809f, 521.791565f);
    builder.lineTo(933.529175f, 521.784363f);
    builder.lineTo(936.765625f, 458.965302f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(661.882263f, 458.958862f);
    builderB.lineTo(928.093445f, 450.033905f);
    builderB.cubicTo(929.103882f, 450, 929.709961f, 454.108612f, 929.447144f, 459.210663f);
    builderB.lineTo(926.210693f, 522.029724f);
    builderB.cubicTo(926.079224f, 524.58075f, 925.153442f, 526.676208f, 924.143066f, 526.710083f);
    builderB.lineTo(657.931885f, 535.635071f);
    builderB.cubicTo(652.879456f, 535.804443f, 648.890259f, 533.873779f, 649.021729f, 531.322754f);
    builderB.lineTo(652.258179f, 468.503662f);
    builderB.cubicTo(652.520996f, 463.401611f, 656.829834f, 459.128235f, 661.882263f, 458.958862f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpfinanzasdigital_com9(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(156, 126);
    builder.quadTo(154.343552f, 126.000397f, 153.17157f, 127.17157f);
    builder.quadTo(152.000397f, 128.343552f, 152, 130);
    builder.lineTo(152, 174);
    builder.lineTo(1114, 174);
    builder.lineTo(1114, 130);
    builder.quadTo(1113.99963f, 128.343552f, 1112.82837f, 127.17157f);
    builder.quadTo(1111.65649f, 126.000397f, 1110, 126);
    builder.lineTo(156, 126);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(156, 126);
    builderB.lineTo(1110, 126);
    builderB.cubicTo(1111.65686f, 126, 1113, 127.790863f, 1113, 130);
    builderB.lineTo(1113, 174);
    builderB.lineTo(153, 174);
    builderB.lineTo(153, 130);
    builderB.cubicTo(153, 127.790863f, 154.34314f, 126, 156, 126);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skppartainasdemo250_org56(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(182.000015f, 645);
    builder.lineTo(182, 640);
    builder.cubicTo(174.322327f, 640, 166.644669f, 637.071045f, 160.786804f, 631.213196f);
    builder.cubicTo(149.071075f, 619.497437f, 149.071075f, 600.502563f, 160.786804f, 588.786804f);
    builder.lineTo(157.251266f, 585.251221f);
    builder.quadTo(147, 595.502502f, 147.000015f, 610);
    builder.quadTo(147, 624.482605f, 157.230255f, 634.727722f);
    builder.quadTo(157.251251f, 634.748779f, 157.251282f, 634.748779f);
    builder.quadTo(157.282852f, 634.780334f, 157.272263f, 634.769775f);
    builder.quadTo(167.517334f, 645, 182.000015f, 645);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(182, 659.497498f);
    builderB.lineTo(206.748749f, 634.748718f);
    builderB.lineTo(182.000015f, 610);
    builderB.lineTo(132.502533f, 610);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpmlk_com326(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(154, 670);
    builder.cubicTo(151.238571f, 670, 149, 672.238586f, 149, 675);
    builder.lineTo(149, 710.001465f);
    builder.cubicTo(149.000809f, 712.209961f, 150.791367f, 714, 153, 714);
    builder.lineTo(189, 714);
    builder.cubicTo(191.209137f, 714, 193, 712.209167f, 193, 710);
    builder.lineTo(193, 675);
    builder.cubicTo(193, 672.238586f, 190.761429f, 670, 188, 670);
    builder.lineTo(154, 670);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(154, 671);
    builderB.lineTo(188, 671);
    builderB.cubicTo(190.761429f, 671, 193, 672.790833f, 193, 675);
    builderB.lineTo(193, 710);
    builderB.cubicTo(193, 712.761414f, 190.761429f, 715, 188, 715);
    builderB.lineTo(154, 715);
    builderB.cubicTo(151.238571f, 715, 149, 712.761414f, 149, 710);
    builderB.lineTo(149, 675);
    builderB.cubicTo(149, 672.790833f, 151.238571f, 671, 154, 671);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpcyclist_friends_gr52(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(50, 182);
    builder.lineTo(1215, 182);
    builder.lineTo(1215, 202);
    builder.quadTo(1214.99951f, 204.070572f, 1213.53552f, 205.535538f);
    builder.quadTo(1212.07056f, 206.999496f, 1210, 207);
    builder.lineTo(55, 207);
    builder.quadTo(52.9294319f, 206.999496f, 51.4644661f, 205.535538f);
    builder.quadTo(50.0004997f, 204.070572f, 50, 202);
    builder.lineTo(50, 182);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(50, 183);
    builderB.lineTo(1215, 183);
    builderB.lineTo(1215, 202);
    builderB.cubicTo(1215, 204.761429f, 1212.76147f, 207, 1210, 207);
    builderB.lineTo(55, 207);
    builderB.cubicTo(52.238575f, 207, 50, 204.761429f, 50, 202);
    builderB.lineTo(50, 183);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_fj_p_com_22(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(172, 201);
    builder.lineTo(172, 202);
    builder.lineTo(220, 202);
    builder.cubicTo(221.65686f, 202, 223, 200.65686f, 223, 199);
    builder.cubicTo(223, 200.104568f, 221.65686f, 201, 220, 201);
    builder.lineTo(172, 201);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(161, 202);
    builderB.lineTo(161, 199);
    builderB.lineTo(223, 199.000015f);
    builderB.lineTo(223, 202);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_lavoixdunord_fr_11(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(806, 57);
    builder.cubicTo(806, 55.3431473f, 807.34314f, 54, 809, 54);
    builder.lineTo(930, 54);
    builder.cubicTo(931.65686f, 54, 933, 55.3431473f, 933, 57);
    builder.lineTo(933, 91);
    builder.cubicTo(933, 92.6568527f, 931.65686f, 94, 930, 94);
    builder.lineTo(809, 94);
    builder.cubicTo(807.34314f, 94, 806, 92.6568527f, 806, 91);
    builder.lineTo(806, 57);
    builder.close();
    builder.moveTo(808, 58);
    builder.cubicTo(808, 56.8954315f, 808.895447f, 56, 810, 56);
    builder.lineTo(929, 56);
    builder.cubicTo(930.104553f, 56, 931, 56.8954315f, 931, 58);
    builder.lineTo(931, 90);
    builder.cubicTo(931, 91.1045685f, 930.104553f, 92, 929, 92);
    builder.lineTo(810, 92);
    builder.cubicTo(808.895447f, 92, 808, 91.1045685f, 808, 90);
    builder.lineTo(808, 58);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(806, 54);
    builderB.lineTo(808, 56);
    builderB.lineTo(935.02002f, 56.0200005f);
    builderB.lineTo(933, 54);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skppptv_com_62(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(173, 5342);
    builder.quadTo(171.343536f, 5342.00049f, 170.17157f, 5343.17139f);
    builder.quadTo(169.000397f, 5344.34375f, 169, 5346);
    builder.lineTo(169, 5372);
    builder.lineTo(234, 5372);
    builder.lineTo(234, 5346);
    builder.quadTo(233.999603f, 5344.34375f, 232.82843f, 5343.17139f);
    builder.quadTo(231.656464f, 5342.00049f, 230, 5342);
    builder.lineTo(173, 5342);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(173, 5342);
    builderB.lineTo(230, 5342);
    builderB.cubicTo(231.65686f, 5342, 233, 5343.79102f, 233, 5346);
    builderB.lineTo(233, 5372);
    builderB.lineTo(169, 5372);
    builderB.lineTo(169, 5346);
    builderB.cubicTo(169, 5343.79102f, 170.790863f, 5342, 173, 5342);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_booking_com_68(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(90, 187);
    builder.cubicTo(90, 185.34314f, 91.3431473f, 184, 93, 184);
    builder.lineTo(588, 184);
    builder.cubicTo(589.65686f, 184, 591, 185.34314f, 591, 187);
    builder.lineTo(591, 218);
    builder.cubicTo(591, 219.65686f, 589.65686f, 221, 588, 221);
    builder.lineTo(93, 221);
    builder.cubicTo(91.3431473f, 221, 90, 219.65686f, 90, 218);
    builder.lineTo(90, 187);
    builder.close();
    builder.moveTo(92, 188);
    builder.cubicTo(92, 186.895432f, 92.8954315f, 186, 94, 186);
    builder.lineTo(587, 186);
    builder.cubicTo(588.104553f, 186, 589, 186.895432f, 589, 188);
    builder.lineTo(589, 217);
    builder.cubicTo(589, 218.104568f, 588.104553f, 219, 587, 219);
    builder.lineTo(94, 219);
    builder.cubicTo(92.8954315f, 219, 92, 218.104568f, 92, 217);
    builder.lineTo(92, 188);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(90, 184);
    builderB.lineTo(92, 186);
    builderB.lineTo(593.02002f, 186.020004f);
    builderB.lineTo(591, 184);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_despegar_com_mx_272(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(635, 1788);
    builder.cubicTo(635, 1786.34314f, 636.34314f, 1785, 638, 1785);
    builder.lineTo(832, 1785);
    builder.cubicTo(833.65686f, 1785, 835, 1786.34314f, 835, 1788);
    builder.lineTo(835, 1812);
    builder.cubicTo(835, 1813.65686f, 833.65686f, 1815, 832, 1815);
    builder.lineTo(638, 1815);
    builder.cubicTo(636.34314f, 1815, 635, 1813.65686f, 635, 1812);
    builder.lineTo(635, 1788);
    builder.close();
    builder.moveTo(637, 1789);
    builder.cubicTo(637, 1787.89539f, 637.895447f, 1787, 639, 1787);
    builder.lineTo(831, 1787);
    builder.cubicTo(832.104553f, 1787, 833, 1787.89539f, 833, 1789);
    builder.lineTo(833, 1811);
    builder.cubicTo(833, 1812.10461f, 832.104553f, 1813, 831, 1813);
    builder.lineTo(639, 1813);
    builder.cubicTo(637.895447f, 1813, 637, 1812.10461f, 637, 1811);
    builder.lineTo(637, 1789);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(835, 1785);
    builderB.lineTo(833, 1787);
    builderB.lineTo(832.97998f, 1817.02002f);
    builderB.lineTo(835, 1815);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_joomla_org_23(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(320, 347);
    builder.cubicTo(320, 344.238586f, 322.238586f, 342, 325, 342);
    builder.lineTo(416, 342);
    builder.cubicTo(418.761414f, 342, 421, 344.238586f, 421, 347);
    builder.cubicTo(421, 344.790863f, 418.761414f, 343, 416, 343);
    builder.lineTo(325, 343);
    builder.cubicTo(322.238586f, 343, 320, 344.790863f, 320, 347);
    builder.close();
    builder.moveTo(320, 378);
    builder.cubicTo(320, 380.761414f, 322.238586f, 383, 325, 383);
    builder.lineTo(416, 383);
    builder.cubicTo(418.761414f, 383, 421, 380.761414f, 421, 378);
    builder.cubicTo(421, 380.209137f, 418.761414f, 382, 416, 382);
    builder.lineTo(325, 382);
    builder.cubicTo(322.238586f, 382, 320, 380.209137f, 320, 378);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(320, 383);
    builderB.lineTo(320, 378);
    builderB.lineTo(421, 378.000031f);
    builderB.lineTo(421, 383);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_macrumors_com_131(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(136, 14089);
    builder.lineTo(136, 14056);
    builder.lineTo(778, 14056);
    builder.lineTo(778, 14089);
    builder.quadTo(777.999573f, 14090.6562f, 776.82843f, 14091.8281f);
    builder.quadTo(775.656433f, 14093, 774, 14093);
    builder.lineTo(140, 14093);
    builder.quadTo(138.343552f, 14093, 137.17157f, 14091.8281f);
    builder.quadTo(136.000397f, 14090.6562f, 136, 14089);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(136, 14057);
    builderB.lineTo(778, 14057);
    builderB.lineTo(778, 14089);
    builderB.cubicTo(778, 14091.209f, 776.209167f, 14093, 774, 14093);
    builderB.lineTo(140, 14093);
    builderB.cubicTo(137.790863f, 14093, 136, 14091.209f, 136, 14089);
    builderB.lineTo(136, 14057);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_leadpages_net_84(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(377.1716f, 5910.17139f);
    builder.cubicTo(376.447723f, 5910.89551f, 376, 5911.89551f, 376, 5913);
    builder.lineTo(376, 5972);
    builder.cubicTo(376, 5974.20898f, 377.790863f, 5976, 380, 5976);
    builder.cubicTo(378.34314f, 5976, 377, 5974.20898f, 377, 5972);
    builder.lineTo(377, 5913);
    builder.cubicTo(377, 5912.17139f, 377.335785f, 5911.42188f, 377.878693f, 5910.87891f);
    builder.lineTo(377.1716f, 5910.17139f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(376, 5909);
    builderB.lineTo(378.481873f, 5909);
    builderB.lineTo(379.999878f, 5976);
    builderB.lineTo(376, 5976);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_briian_com_34(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(843, 216);
    builder.cubicTo(843, 213.238571f, 845.238586f, 211, 848, 211);
    builder.lineTo(1191, 211);
    builder.cubicTo(1193.76147f, 211, 1196, 213.238571f, 1196, 216);
    builder.lineTo(1196, 779);
    builder.cubicTo(1196, 781.761414f, 1193.76147f, 784, 1191, 784);
    builder.lineTo(848, 784);
    builder.cubicTo(845.238586f, 784, 843, 781.761414f, 843, 779);
    builder.lineTo(843, 216);
    builder.close();
    builder.moveTo(844, 217);
    builder.cubicTo(844, 214.238571f, 846.238586f, 212, 849, 212);
    builder.lineTo(1190, 212);
    builder.cubicTo(1192.76147f, 212, 1195, 214.238571f, 1195, 217);
    builder.lineTo(1195, 778);
    builder.cubicTo(1195, 779.65686f, 1192.76147f, 781, 1190, 781);
    builder.lineTo(849, 781);
    builder.cubicTo(846.238586f, 781, 844, 779.65686f, 844, 778);
    builder.lineTo(844, 217);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(843, 784);
    builderB.lineTo(843, 779);
    builderB.lineTo(1196, 779.000061f);
    builderB.lineTo(1196, 784);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_sciality_com_100(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(162, 468);
    builder.cubicTo(159.790863f, 468, 158, 469.790863f, 158, 472);
    builder.lineTo(158, 528);
    builder.cubicTo(158, 530.209106f, 159.790863f, 532, 162, 532);
    builder.lineTo(275, 532);
    builder.cubicTo(277.209137f, 532, 279, 530.209106f, 279, 528);
    builder.lineTo(279, 472);
    builder.cubicTo(279, 469.790863f, 277.209137f, 468, 275, 468);
    builder.lineTo(162, 468);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(275, 468);
    builderB.cubicTo(276.65686f, 468, 278, 469.34314f, 278, 471);
    builderB.lineTo(278, 529);
    builderB.cubicTo(278, 530.65686f, 276.65686f, 532, 275, 532);
    builderB.lineTo(161, 532);
    builderB.cubicTo(159.34314f, 532, 158, 530.65686f, 158, 529);
    builderB.lineTo(158, 471);
    builderB.cubicTo(158, 469.34314f, 159.34314f, 468, 161, 468);
    builderB.lineTo(275, 468);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_sciality_com_101(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(162, 468);
    builder.cubicTo(159.790863f, 468, 158, 469.790863f, 158, 472);
    builder.lineTo(158, 528);
    builder.cubicTo(158, 530.209106f, 159.790863f, 532, 162, 532);
    builder.lineTo(275.009186f, 532);
    builder.cubicTo(276.661774f, 531.994995f, 278, 530.653748f, 278, 529);
    builder.lineTo(278, 471);
    builder.cubicTo(278, 469.346375f, 276.662079f, 468.005249f, 275.009705f, 468);
    builder.lineTo(162, 468);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(161, 469);
    builderB.lineTo(275, 469);
    builderB.cubicTo(276.65686f, 469, 278, 469.895416f, 278, 471);
    builderB.lineTo(278, 529);
    builderB.cubicTo(278, 530.65686f, 276.65686f, 532, 275, 532);
    builderB.lineTo(161, 532);
    builderB.cubicTo(159.34314f, 532, 158, 530.65686f, 158, 529);
    builderB.lineTo(158, 471);
    builderB.cubicTo(158, 469.895416f, 159.34314f, 469, 161, 469);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_meb_gov_tr_5(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(137.34314f, 145.34314f);
    builder.quadTo(139.687088f, 143.000793f, 143, 143);
    builder.lineTo(242, 143);
    builder.quadTo(245.312912f, 143.000793f, 247.65686f, 145.34314f);
    builder.quadTo(249.999207f, 147.687088f, 250, 151);
    builder.lineTo(250, 177);
    builder.lineTo(135, 177);
    builder.lineTo(135, 151);
    builder.quadTo(135.000793f, 147.687088f, 137.34314f, 145.34314f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(135, 143);
    builderB.lineTo(250, 143);
    builderB.lineTo(250, 177);
    builderB.lineTo(135, 177);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_meb_gov_tr_6(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(143, 143);
    builder.quadTo(139.687088f, 143.000793f, 137.34314f, 145.34314f);
    builder.quadTo(135.000793f, 147.687088f, 135, 151);
    builder.lineTo(135, 177);
    builder.lineTo(250, 177);
    builder.lineTo(250, 151);
    builder.quadTo(249.999207f, 147.687088f, 247.65686f, 145.34314f);
    builder.quadTo(245.312912f, 143.000793f, 242, 143);
    builder.lineTo(143, 143);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(143, 143);
    builderB.lineTo(242, 143);
    builderB.cubicTo(245.865997f, 143, 249, 146.581726f, 249, 151);
    builderB.lineTo(249, 177);
    builderB.lineTo(135, 177);
    builderB.lineTo(135, 151);
    builderB.cubicTo(135, 146.581726f, 138.581726f, 143, 143, 143);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpgithub_io_25(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1001.87866f, 14.8786793f);
    builder.quadTo(1002.75745f, 14.0001001f, 1004, 14);
    builder.lineTo(1105, 14);
    builder.quadTo(1106.24255f, 14.0001001f, 1107.12134f, 14.8786793f);
    builder.quadTo(1107.99988f, 15.7574596f, 1108, 17);
    builder.lineTo(1108, 41);
    builder.quadTo(1107.99988f, 42.2425423f, 1107.12134f, 43.1213188f);
    builder.quadTo(1106.24255f, 43.9999008f, 1105, 44);
    builder.lineTo(1004, 44);
    builder.quadTo(1002.75745f, 43.9999008f, 1001.87866f, 43.1213188f);
    builder.quadTo(1001.00012f, 42.2425423f, 1001, 41);
    builder.lineTo(1001, 17);
    builder.quadTo(1001.00012f, 15.7574596f, 1001.87866f, 14.8786793f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(1005, 16);
    builderB.lineTo(1104, 16);
    builderB.cubicTo(1105.10461f, 16, 1106, 16.8954296f, 1106, 18);
    builderB.lineTo(1106, 40);
    builderB.cubicTo(1106, 41.1045685f, 1105.10461f, 42, 1104, 42);
    builderB.lineTo(1005, 42);
    builderB.cubicTo(1003.89545f, 42, 1003, 41.1045685f, 1003, 40);
    builderB.lineTo(1003, 18);
    builderB.cubicTo(1003, 16.8954296f, 1003.89545f, 16, 1005, 16);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpgithub_io_26(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1001.87866f, 14.8786793f);
    builder.quadTo(1002.75745f, 14.0001001f, 1004, 14);
    builder.lineTo(1105, 14);
    builder.quadTo(1106.24255f, 14.0001001f, 1107.12134f, 14.8786793f);
    builder.quadTo(1107.99988f, 15.7574596f, 1108, 17);
    builder.lineTo(1108, 41);
    builder.quadTo(1107.99988f, 42.2425423f, 1107.12134f, 43.1213188f);
    builder.quadTo(1106.24255f, 43.9999008f, 1105, 44);
    builder.lineTo(1004, 44);
    builder.quadTo(1002.75745f, 43.9999008f, 1001.87866f, 43.1213188f);
    builder.quadTo(1001.00012f, 42.2425423f, 1001, 41);
    builder.lineTo(1001, 17);
    builder.quadTo(1001.00012f, 15.7574596f, 1001.87866f, 14.8786793f);
    builder.close();
    builder.moveTo(1003, 18);
    builder.cubicTo(1003, 16.8954296f, 1003.89545f, 16, 1005, 16);
    builder.lineTo(1104, 16);
    builder.cubicTo(1105.10461f, 16, 1106, 16.8954296f, 1106, 18);
    builder.lineTo(1106, 40);
    builder.cubicTo(1106, 41.1045685f, 1105.10461f, 42, 1104, 42);
    builder.lineTo(1005, 42);
    builder.cubicTo(1003.89545f, 42, 1003, 41.1045685f, 1003, 40);
    builder.lineTo(1003, 18);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1108, 14);
    builderB.lineTo(1106, 16);
    builderB.lineTo(1105.97998f, 46.0200005f);
    builderB.lineTo(1108, 44);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpskpicture14(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(0, 994);
    builder.lineTo(0, 0);
    builder.lineTo(512, 0);
    builder.lineTo(512, 994);
    builder.lineTo(0, 994);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(-317, 168);
    builderB.quadTo(-317, 166.757385f, -316.121338f, 165.878662f);
    builderB.quadTo(-315.242645f, 165, -314, 165);
    builderB.lineTo(320, 165);
    builderB.quadTo(321.242615f, 165, 322.121338f, 165.878662f);
    builderB.quadTo(323, 166.757385f, 323, 168);
    builderB.lineTo(323, 193);
    builderB.lineTo(-317, 193);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpskpicture15(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(0, 193);
    builder.lineTo(323, 193);
    builder.lineTo(323, 168);
    builder.quadTo(323, 166.757385f, 322.121338f, 165.878662f);
    builder.quadTo(321.242615f, 165, 320, 165);
    builder.lineTo(0, 165);
    builder.lineTo(0, 193);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kInverseWinding);
    builderB.moveTo(-314, 165);
    builderB.lineTo(320, 165);
    builderB.cubicTo(321.65686f, 165, 323, 166.34314f, 323, 168);
    builderB.lineTo(323, 192);
    builderB.lineTo(-317, 192);
    builderB.lineTo(-317, 168);
    builderB.cubicTo(-317, 166.34314f, -315.65686f, 165, -314, 165);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpelpais_com_18(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(183, 8507);
    builder.lineTo(552, 8506.99023f);
    builder.lineTo(552, 8508);
    builder.lineTo(183, 8508);
    builder.lineTo(183, 8507);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(183, 8508);
    builderB.lineTo(183, 8506.99023f);
    builderB.lineTo(552, 8507);
    builderB.lineTo(552, 8508);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpnamecheap_com_405(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(140, 1000);
    builder.lineTo(140, 842);
    builder.lineTo(141, 842);
    builder.lineTo(141.14502f, 1000);
    builder.lineTo(140, 1000);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(140, 842);
    builderB.lineTo(141.008835f, 837.9646f);
    builderB.lineTo(141.235291f, 1109.05884f);
    builderB.lineTo(140, 1114);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_alrakoba_net_62(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(134.34314f, 9802.34277f);
    builder.quadTo(132, 9804.68652f, 132, 9808);
    builder.lineTo(132, 9822);
    builder.quadTo(132, 9825.31348f, 134.34314f, 9827.65723f);
    builder.quadTo(136.686295f, 9830, 140, 9830);
    builder.lineTo(140.028473f, 9830);
    builder.lineTo(139.877213f, 9828.90723f);
    builder.quadTo(137.692032f, 9828.5332f, 136.050247f, 9826.65723f);
    builder.quadTo(134, 9824.31348f, 134, 9821);
    builder.lineTo(134, 9809);
    builder.quadTo(134, 9806.10059f, 136.050247f, 9804.0498f);
    builder.lineTo(134.34314f, 9802.34277f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(132, 9800);
    builderB.lineTo(135.962357f, 9800);
    builderB.lineTo(140, 9830);
    builderB.lineTo(132, 9830);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_cityads_ru_249(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(817.464478f, 11.4644661f);
    builder.quadTo(818.928955f, 10, 821, 10);
    builder.lineTo(998, 10);
    builder.quadTo(999.082947f, 10, 1000, 10.4003992f);
    builder.lineTo(1000, 13.3527431f);
    builder.quadTo(999.917603f, 13.2607508f, 999.82843f, 13.1715727f);
    builder.quadTo(998.65686f, 12, 997, 12);
    builder.lineTo(822, 12);
    builder.quadTo(820.34314f, 12, 819.17157f, 13.1715727f);
    builder.quadTo(818, 14.3431454f, 818, 16);
    builder.lineTo(818, 28);
    builder.quadTo(818, 29.6568546f, 819.17157f, 30.8284264f);
    builder.quadTo(820.34314f, 32, 822, 32);
    builder.lineTo(997, 32);
    builder.quadTo(998.65686f, 32, 999.82843f, 30.8284264f);
    builder.quadTo(999.917603f, 30.7392426f, 1000, 30.6472569f);
    builder.lineTo(1000, 33.5996017f);
    builder.quadTo(999.082947f, 34, 998, 34);
    builder.lineTo(821, 34);
    builder.quadTo(818.928955f, 34, 817.464478f, 32.5355339f);
    builder.quadTo(816, 31.0710678f, 816, 29);
    builder.lineTo(816, 15);
    builder.quadTo(816, 12.9289322f, 817.464478f, 11.4644661f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1003, 10);
    builderB.lineTo(1000, 13);
    builderB.lineTo(999.969971f, 37.0299988f);
    builderB.lineTo(1003, 34);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_dealnews_com_315(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(966.464478f, 4261.46436f);
    builder.quadTo(965, 4262.92871f, 965, 4265);
    builder.lineTo(965, 4276);
    builder.quadTo(965, 4278.07129f, 966.464478f, 4279.53564f);
    builder.quadTo(967.928955f, 4281, 970, 4281);
    builder.lineTo(970.020325f, 4281);
    builder.lineTo(969.887512f, 4279.81641f);
    builder.quadTo(968.928284f, 4279.48145f, 968.17157f, 4278.53564f);
    builder.quadTo(967, 4277.07129f, 967, 4275);
    builder.lineTo(967, 4266);
    builder.quadTo(967, 4264.44287f, 968.035217f, 4263.31396f);
    builder.lineTo(968, 4263);
    builder.lineTo(966.464478f, 4261.46436f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(965, 4260);
    builderB.lineTo(967.716675f, 4260);
    builderB.lineTo(970, 4281);
    builderB.lineTo(965, 4281);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_inmotionhosting_com_9(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(991.633911f, 1839);
    builder.lineTo(964.265015f, 1839);
    builder.lineTo(963.734985f, 1893.73242f);
    builder.lineTo(991.3703f, 1894);
    builder.lineTo(1018.23492f, 1894);
    builder.lineTo(1018.76501f, 1839.2627f);
    builder.lineTo(991.638184f, 1839);
    builder.lineTo(991.633911f, 1839);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(964.267578f, 1838.73499f);
    builderB.lineTo(1019.26501f, 1839.26758f);
    builderB.lineTo(1018.73242f, 1894.26501f);
    builderB.lineTo(963.734985f, 1893.73242f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_alucinados_net_101(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1129.53552f, 1164.46448f);
    builder.lineTo(1128, 1166);
    builder.lineTo(1128.12231f, 1166.49548f);
    builder.quadTo(1129, 1167.56592f, 1129, 1169);
    builder.lineTo(1129, 1170.05054f);
    builder.lineTo(1130.34509f, 1175.49878f);
    builder.quadTo(1131, 1174.38513f, 1131, 1173);
    builder.lineTo(1131, 1168);
    builder.quadTo(1131, 1165.92896f, 1129.53552f, 1164.46448f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1131, 1163);
    builderB.lineTo(-43515.8555f, -177415.594f);
    builderB.lineTo(1129.76465f, 1173.05884f);
    builderB.lineTo(1131, 1178);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_hairjobsearch_com_31(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(143.292892f, 0.707106769f);
    builder.quadTo(143, 0.414213538f, 143, 0);
    builder.lineTo(1123, 0);
    builder.quadTo(1123, 0.414213538f, 1122.70715f, 0.707106769f);
    builder.quadTo(1122.41418f, 1, 1122, 1);
    builder.lineTo(144, 1);
    builder.quadTo(143.585785f, 1, 143.292892f, 0.707106769f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(143, 1);
    builderB.lineTo(144, 0);
    builderB.lineTo(1122, 0);
    builderB.lineTo(1123, 1);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_heartiste_wordpress_com_86(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(741, 9432);
    builder.lineTo(761, 9431.99023f);
    builder.lineTo(761, 9433);
    builder.lineTo(741, 9433);
    builder.lineTo(741, 9432);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(741, 9433);
    builderB.lineTo(741, 9431.99023f);
    builderB.lineTo(761, 9432);
    builderB.lineTo(761, 9433);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_argus_presse_fr_41(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 343);
    builder.lineTo(165, 343);
    builder.lineTo(165, 364.869873f);
    builder.lineTo(1000, 364.869873f);
    builder.lineTo(1000, 343);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(165, 343.000031f);
    builderB.lineTo(1000, 343.000031f);
    builderB.lineTo(1000, 364.869904f);
    builderB.lineTo(165, 364.869904f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_320kbps_net_2231(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(838, 9125);
    builder.lineTo(862, 9124.99023f);
    builder.lineTo(862, 9126);
    builder.lineTo(838, 9126);
    builder.lineTo(838, 9125);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(838, 9126);
    builderB.lineTo(838, 9124.99023f);
    builderB.lineTo(862, 9125);
    builderB.lineTo(862, 9126);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_exystence_net_61(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(143, 9075);
    builder.lineTo(316, 9075);
    builder.lineTo(316, 9073.99023f);
    builder.lineTo(143, 9074);
    builder.lineTo(143, 9075);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(143, 9075);
    builderB.lineTo(143, 9073.99023f);
    builderB.lineTo(316, 9074);
    builderB.lineTo(316, 9075);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_trashness_com_36(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(541.5f, 4835.99512f);
    builder.lineTo(91.5f, 4836);
    builder.lineTo(91.5f, 4836.5f);
    builder.lineTo(541.5f, 4836.5f);
    builder.lineTo(541.5f, 4835.99512f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(91.5f, 4836.5f);
    builderB.lineTo(91.5f, 4835.99512f);
    builderB.lineTo(541.5f, 4836);
    builderB.lineTo(541.5f, 4836.5f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_getgold_jp_731(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(284.878693f, 10134.8789f);
    builder.quadTo(284, 10135.7578f, 284, 10137);
    builder.lineTo(284, 10216);
    builder.quadTo(284, 10217.2422f, 284.878693f, 10218.1211f);
    builder.quadTo(285.125122f, 10218.3672f, 285.40213f, 10218.5459f);
    builder.lineTo(286, 10138);
    builder.lineTo(286, 10136);
    builder.lineTo(284.878693f, 10134.8789f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(284, 10134);
    builderB.lineTo(286.05957f, 10129.8809f);
    builderB.lineTo(285.399994f, 10216.2002f);
    builderB.lineTo(284, 10219);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_maturesupertube_com_21(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(3.17157292f, 11831.1719f);
    builder.quadTo(4.34314585f, 11830, 6, 11830);
    builder.lineTo(1259, 11830);
    builder.quadTo(1260.65686f, 11830, 1261.82837f, 11831.1719f);
    builder.quadTo(1263, 11832.3428f, 1263, 11834);
    builder.lineTo(1263, 11848);
    builder.quadTo(1263, 11849.6572f, 1261.82837f, 11850.8281f);
    builder.quadTo(1260.65686f, 11852, 1259, 11852);
    builder.lineTo(6, 11852);
    builder.quadTo(4.34314585f, 11852, 3.17157292f, 11850.8281f);
    builder.quadTo(2, 11849.6572f, 2, 11848);
    builder.lineTo(2, 11834);
    builder.quadTo(2, 11832.3428f, 3.17157292f, 11831.1719f);
    builder.close();
    builder.moveTo(3.87867975f, 11831.8789f);
    builder.quadTo(4.7573595f, 11831, 6, 11831);
    builder.lineTo(1259, 11831);
    builder.quadTo(1260.24268f, 11831, 1261.12134f, 11831.8789f);
    builder.quadTo(1262, 11832.7578f, 1262, 11834);
    builder.lineTo(1262, 11848);
    builder.quadTo(1262, 11849.2422f, 1261.12134f, 11850.1211f);
    builder.quadTo(1260.24268f, 11851, 1259, 11851);
    builder.lineTo(6, 11851);
    builder.quadTo(4.7573595f, 11851, 3.87867975f, 11850.1211f);
    builder.quadTo(3, 11849.2422f, 3, 11848);
    builder.lineTo(3, 11834);
    builder.quadTo(3, 11832.7578f, 3.87867975f, 11831.8789f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(2, 11830);
    builderB.lineTo(4.5f, 11832.5f);
    builderB.lineTo(1260.5f, 11832.5f);
    builderB.lineTo(1263, 11830);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_hubbyscook_com_22(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 902.329346f);
    builder.quadTo(998, 905.250427f, 998, 909);
    builder.lineTo(998, 910);
    builder.quadTo(998, 913.749573f, 1000, 916.670654f);
    builder.lineTo(1000, 902.329346f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(998, 910);
    builderB.lineTo(998, 909);
    builderB.quadTo(998, 904.029419f, 1001.51471f, 900.514709f);
    builderB.quadTo(1005.02942f, 897, 1010, 897);
    builderB.lineTo(1011, 897);
    builderB.quadTo(1015.14215f, 897, 1018.07104f, 900.514709f);
    builderB.quadTo(1021, 904.029419f, 1021, 909);
    builderB.lineTo(1021, 910);
    builderB.quadTo(1021, 914.142151f, 1018.07104f, 917.071045f);
    builderB.quadTo(1015.14215f, 920, 1011, 920);
    builderB.lineTo(1010, 920);
    builderB.quadTo(1005.02942f, 920, 1001.51471f, 917.071045f);
    builderB.quadTo(998, 914.142151f, 998, 910);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_gruposejaumdivulgador_com_br_4(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(610.5f, 5.78626502e-14f);
    builder.lineTo(1083.5f, -6.12303177e-17f);
    builder.lineTo(1083.5f, 469);
    builder.lineTo(610.5f, 469);
    builder.lineTo(610.5f, 5.78626502e-14f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(611, 0);
    builderB.lineTo(1084, 0);
    builderB.lineTo(1084, 469);
    builderB.lineTo(611, 469);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_phototransferapp_com_24(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(85.6091843f, 5.92893219f);
    builder.quadTo(89.6041641f, 3, 93.7462997f, 3);
    builder.lineTo(1212.74634f, 3);
    builder.quadTo(1216.88843f, 3, 1218.75134f, 5.92893219f);
    builder.quadTo(1220.61414f, 8.85775471f, 1219.10669f, 12.9996767f);
    builder.quadTo(1220.46338f, 9.27196693f, 1218.4939f, 6.63603878f);
    builder.quadTo(1216.52441f, 4, 1212.38232f, 4);
    builder.lineTo(93.3823318f, 4);
    builder.quadTo(89.2401962f, 4, 85.3518219f, 6.63603878f);
    builder.quadTo(81.4634476f, 9.27207756f, 80.1065979f, 13);
    builder.quadTo(81.614212f, 8.85786438f, 85.6091843f, 5.92893219f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(83.7462997f, 3);
    builderB.lineTo(1222.74634f, 3);
    builderB.lineTo(1219.10657f, 13);
    builderB.lineTo(80.1065979f, 13);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_phototransferapp_com_24x(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(85.6091843f, 5.92893219f);
    builder.quadTo(89.6041641f, 3, 93.7462997f, 3);
    builder.lineTo(112.74634f, 3);
    builder.quadTo(116.88843f, 3, 118.75134f, 5.92893219f);
    builder.quadTo(120.61414f, 8.85775471f, 119.10669f, 12.9996767f);
    builder.quadTo(120.46338f, 9.27196693f, 118.4939f, 6.63603878f);
    builder.quadTo(116.52441f, 4, 112.38232f, 4);
    builder.lineTo(93.3823318f, 4);
    builder.quadTo(89.2401962f, 4, 85.3518219f, 6.63603878f);
    builder.quadTo(81.4634476f, 9.27207756f, 80.1065979f, 13);
    builder.quadTo(81.614212f, 8.85786438f, 85.6091843f, 5.92893219f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(83.7462997f, 3);
    builderB.lineTo(122.74634f, 3);
    builderB.lineTo(119.10657f, 13);
    builderB.lineTo(80.1065979f, 13);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_helha_be_109(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(117.686981f, 3339.08423f);
    builder.lineTo(109.533035f, 3350.72925f);
    builder.quadTo(107.120552f, 3354.17456f, 103.879379f, 3354.41821f);
    builder.quadTo(100.638504f, 3354.66187f, 98.4674301f, 3351.56177f);
    builder.quadTo(100.87973f, 3355.00635f, 104.291222f, 3355.00635f);
    builder.quadTo(107.70298f, 3355.00635f, 110.115463f, 3351.56104f);
    builder.lineTo(118, 3340.30078f);
    builder.lineTo(118, 3339.53125f);
    builder.lineTo(117.686981f, 3339.08423f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(118.269409f, 3339.91602f);
    builderB.lineTo(117.686981f, 3339.08423f);
    builderB.lineTo(98.4669647f, 3351.56104f);
    builderB.lineTo(104.291214f, 3359.87891f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_cooksnaps_com_32(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(509.34021f, 176);
    builder.lineTo(505, 176);
    builder.quadTo(500.964233f, 176, 497.299988f, 176.896912f);
    builder.quadTo(493.678162f, 177.952286f, 490.183014f, 179.9702f);
    builder.lineTo(489.316986f, 180.4702f);
    builder.quadTo(485.175385f, 182.861359f, 482.115265f, 186.082397f);
    builder.quadTo(479.69455f, 188.700821f, 477.995941f, 191.618286f);
    builder.quadTo(476.316772f, 194.550476f, 475.258759f, 197.959335f);
    builder.quadTo(474, 202.218979f, 474, 207);
    builder.lineTo(474, 208);
    builder.quadTo(474, 212.03569f, 474.896851f, 215.699799f);
    builder.quadTo(475.950256f, 219.315002f, 477.962708f, 222.803986f);
    builder.lineTo(477.970215f, 222.816986f);
    builder.lineTo(478.470215f, 223.683014f);
    builder.quadTo(478.474915f, 223.691162f, 478.479645f, 223.69931f);
    builder.quadTo(480.867981f, 227.831055f, 484.082947f, 230.885254f);
    builder.quadTo(486.701447f, 233.305939f, 489.61908f, 235.004517f);
    builder.quadTo(492.550232f, 236.682983f, 495.957611f, 237.740738f);
    builder.quadTo(500.217987f, 239, 505, 239);
    builder.lineTo(509.482178f, 239);
    builder.quadTo(515.299133f, 238.212051f, 520.801941f, 235.038513f);
    builder.quadTo(520.809509f, 235.034164f, 520.817017f, 235.0298f);
    builder.lineTo(521.683044f, 234.5298f);
    builder.quadTo(521.692078f, 234.524582f, 521.701111f, 234.519348f);
    builder.quadTo(532.80603f, 228.09938f, 536.126709f, 215.70639f);
    builder.quadTo(539.450134f, 203.303314f, 533.029785f, 192.183014f);
    builder.lineTo(532.529785f, 191.316986f);
    builder.quadTo(526.109497f, 180.196686f, 513.706421f, 176.873276f);
    builder.quadTo(511.503082f, 176.282898f, 509.34021f, 176);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(478.470215f, 223.683014f);
    builderB.lineTo(477.970215f, 222.816986f);
    builderB.quadTo(471.549896f, 211.696686f, 474.873322f, 199.293594f);
    builderB.quadTo(478.196686f, 186.890503f, 489.316986f, 180.4702f);
    builderB.lineTo(490.183014f, 179.9702f);
    builderB.quadTo(501.303345f, 173.549896f, 513.706421f, 176.873276f);
    builderB.quadTo(526.109497f, 180.196686f, 532.529785f, 191.316986f);
    builderB.lineTo(533.029785f, 192.183014f);
    builderB.quadTo(539.450134f, 203.303314f, 536.126709f, 215.70639f);
    builderB.quadTo(532.803345f, 228.109497f, 521.683044f, 234.5298f);
    builderB.lineTo(520.817017f, 235.0298f);
    builderB.quadTo(509.696686f, 241.450104f, 497.29361f, 238.126709f);
    builderB.quadTo(484.890533f, 234.803314f, 478.470215f, 223.683014f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_cooksnaps_com_32a(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(497.299988f, 176.896912f);
    builder.quadTo(493.678162f, 177.952286f, 490.183014f, 179.9702f);
    builder.lineTo(489.316986f, 180.4702f);
    builder.quadTo(485.175385f, 182.861359f, 482.115265f, 186.082397f);
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(474.873322f, 199.293594f);
    builderB.quadTo(478.196686f, 186.890503f, 489.316986f, 180.4702f);
    builderB.lineTo(490.183014f, 179.9702f);
    builderB.quadTo(501.303345f, 173.549896f, 513.706421f, 176.873276f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_contextualnewsfeeds_com_346(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(460.257355f, 1202.27808f);
    builder.lineTo(460.257355f, 1204.27808f);
    builder.quadTo(461.081207f, 1204.27808f, 461.665161f, 1203.69873f);
    builder.lineTo(461.67157f, 1203.69238f);
    builder.lineTo(466.621307f, 1198.74268f);
    builder.quadTo(466.623993f, 1198.73999f, 466.626648f, 1198.7373f);
    builder.quadTo(466.914185f, 1198.44604f, 466.914185f, 1198.03552f);
    builder.quadTo(466.914215f, 1197.62122f, 466.621307f, 1197.32837f);
    builder.lineTo(465.914215f, 1196.62122f);
    builder.lineTo(460.257355f, 1202.27808f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(460.257355f, 1205.10657f);
    builderB.lineTo(458.828979f, 1203.67822f);
    builderB.lineTo(465.914215f, 1196.62122f);
    builderB.lineTo(467.32843f, 1198.03552f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_pindosiya_com_99(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(899.17157f, 548.17157f);
    builder.quadTo(898, 549.34314f, 898, 551);
    builder.lineTo(898, 556);
    builder.lineTo(899.027283f, 556);
    builder.lineTo(900.02356f, 551.602844f);
    builder.quadTo(900.06073f, 551.297058f, 900.156555f, 551.015747f);
    builder.lineTo(900.5f, 549.5f);
    builder.lineTo(899.17157f, 548.17157f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(898, 547);
    builderB.lineTo(901.086914f, 547);
    builderB.lineTo(899, 556);
    builderB.lineTo(898, 556);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_karnivool_com_au_11(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(0, 1431);
    builder.lineTo(0, 775);
    builder.lineTo(1265, 775);
    builder.lineTo(1265, 1431);
    builder.lineTo(0, 1431);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(32.3243904f, 851);
    builderB.lineTo(459.324402f, 851);
    builderB.lineTo(427, 1081);
    builderB.lineTo(-3.81469727e-06f, 1081);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_tunero_de_24(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1020.79303f, 2252);
    builder.quadTo(1018.72198f, 2252, 1016.86798f, 2253.46436f);
    builder.quadTo(1015.02032f, 2254.92383f, 1014.4668f, 2256.98584f);
    builder.lineTo(1014.46301f, 2257);
    builder.lineTo(1011.53705f, 2268);
    builder.quadTo(1010.98615f, 2270.07104f, 1012.06104f, 2271.53564f);
    builder.quadTo(1013.13599f, 2273, 1015.20703f, 2273);
    builder.lineTo(1083.20703f, 2273);
    builder.quadTo(1085.27808f, 2273, 1087.13208f, 2271.53564f);
    builder.quadTo(1088.97144f, 2270.08252f, 1089.52832f, 2268.03271f);
    builder.lineTo(1089.53711f, 2268);
    builder.lineTo(1092.46301f, 2257);
    builder.lineTo(1092.4679f, 2256.98145f);
    builder.quadTo(1093.00916f, 2254.92236f, 1091.93909f, 2253.46436f);
    builder.quadTo(1090.86414f, 2252, 1088.79297f, 2252);
    builder.lineTo(1020.79303f, 2252);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1011.53705f, 2268);
    builderB.lineTo(1014.46301f, 2257);
    builderB.quadTo(1015.01392f, 2254.92896f, 1016.86798f, 2253.46436f);
    builderB.quadTo(1018.72198f, 2252, 1020.79303f, 2252);
    builderB.lineTo(1088.79297f, 2252);
    builderB.quadTo(1090.86414f, 2252, 1091.93909f, 2253.46436f);
    builderB.quadTo(1093.01392f, 2254.92896f, 1092.46301f, 2257);
    builderB.lineTo(1089.53711f, 2268);
    builderB.quadTo(1088.98608f, 2270.07104f, 1087.13208f, 2271.53564f);
    builderB.quadTo(1085.27808f, 2273, 1083.20703f, 2273);
    builderB.lineTo(1015.20703f, 2273);
    builderB.quadTo(1013.13599f, 2273, 1012.06104f, 2271.53564f);
    builderB.quadTo(1010.98615f, 2270.07104f, 1011.53705f, 2268);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_docgelo_com_66(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(22.5f, 24174.5f);
    builder.lineTo(185.5f, 24174.498f);
    builder.lineTo(185.5f, 24174.75f);
    builder.lineTo(22.5f, 24174.75f);
    builder.lineTo(22.5f, 24174.5f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(22.5f, 24174.75f);
    builderB.lineTo(22.5f, 24174.498f);
    builderB.lineTo(185.5f, 24174.5f);
    builderB.lineTo(185.5f, 24174.75f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_kpopexplorer_net_22(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 866.329346f);
    builder.quadTo(998, 869.250427f, 998, 873);
    builder.lineTo(998, 874);
    builder.quadTo(998, 877.749573f, 1000, 880.670654f);
    builder.lineTo(1000, 866.329346f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(998, 874);
    builderB.lineTo(998, 873);
    builderB.quadTo(998, 868.029419f, 1001.51471f, 864.514709f);
    builderB.quadTo(1005.02942f, 861, 1010, 861);
    builderB.lineTo(1011, 861);
    builderB.quadTo(1015.14215f, 861, 1018.07104f, 864.514709f);
    builderB.quadTo(1021, 868.029419f, 1021, 873);
    builderB.lineTo(1021, 874);
    builderB.quadTo(1021, 878.142151f, 1018.07104f, 881.071045f);
    builderB.quadTo(1015.14215f, 884, 1011, 884);
    builderB.lineTo(1010, 884);
    builderB.quadTo(1005.02942f, 884, 1001.51471f, 881.071045f);
    builderB.quadTo(998, 878.142151f, 998, 874);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_artblart_com_8(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(22.5f, 24527.25f);
    builder.lineTo(45, 24527.248f);
    builder.lineTo(45, 24527.5f);
    builder.lineTo(22.5f, 24527.5f);
    builder.lineTo(22.5f, 24527.25f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(22.5f, 24527.5f);
    builderB.lineTo(22.5f, 24527.248f);
    builderB.lineTo(45, 24527.25f);
    builderB.lineTo(45, 24527.5f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_jessicaslens_wordpress_com_222(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 844.329346f);
    builder.quadTo(998, 847.250427f, 998, 851);
    builder.lineTo(998, 852);
    builder.quadTo(998, 855.749573f, 1000, 858.670654f);
    builder.lineTo(1000, 844.329346f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(998, 852);
    builderB.lineTo(998, 851);
    builderB.quadTo(998, 846.029419f, 1001.51471f, 842.514709f);
    builderB.quadTo(1005.02942f, 839, 1010, 839);
    builderB.lineTo(1011, 839);
    builderB.quadTo(1015.14215f, 839, 1018.07104f, 842.514709f);
    builderB.quadTo(1021, 846.029419f, 1021, 851);
    builderB.lineTo(1021, 852);
    builderB.quadTo(1021, 856.142151f, 1018.07104f, 859.071045f);
    builderB.quadTo(1015.14215f, 862, 1011, 862);
    builderB.lineTo(1010, 862);
    builderB.quadTo(1005.02942f, 862, 1001.51471f, 859.071045f);
    builderB.quadTo(998, 856.142151f, 998, 852);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_simplysaru_com_40(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 866.329346f);
    builder.quadTo(998, 869.250427f, 998, 873);
    builder.lineTo(998, 874);
    builder.quadTo(998, 877.749573f, 1000, 880.670654f);
    builder.lineTo(1000, 866.329346f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(998, 874);
    builderB.lineTo(998, 873);
    builderB.quadTo(998, 868.029419f, 1001.51471f, 864.514709f);
    builderB.quadTo(1005.02942f, 861, 1010, 861);
    builderB.lineTo(1011, 861);
    builderB.quadTo(1015.14215f, 861, 1018.07104f, 864.514709f);
    builderB.quadTo(1021, 868.029419f, 1021, 873);
    builderB.lineTo(1021, 874);
    builderB.quadTo(1021, 878.142151f, 1018.07104f, 881.071045f);
    builderB.quadTo(1015.14215f, 884, 1011, 884);
    builderB.lineTo(1010, 884);
    builderB.quadTo(1005.02942f, 884, 1001.51471f, 881.071045f);
    builderB.quadTo(998, 878.142151f, 998, 874);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_partsdata_de_53(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(407, 119);
    builder.lineTo(407, 28);
    builder.lineTo(647, 28);
    builder.lineTo(647, 119);
    builder.lineTo(407, 119);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(471.228394f, 64.443222f);
    builderB.cubicTo(471.193878f, 60.953373f, 470.234985f, 52.4797592f, 462.201569f, 46.6231461f);
    builderB.cubicTo(454.168152f, 40.7665405f, 446.592804f, 41.993145f, 443.033936f, 42.8568878f);
    builderB.cubicTo(439.475098f, 43.7206268f, 436.978638f, 45.4052658f, 436.304871f, 45.7851906f);
    builderB.cubicTo(435.631104f, 46.1651154f, 435.156006f, 45.8026352f, 434.957306f, 45.6384506f);
    builderB.cubicTo(434.758636f, 45.4742737f, 431.460999f, 42.0105858f, 430.916901f, 41.4664841f);
    builderB.cubicTo(430.372803f, 40.9223785f, 429.731628f, 41.3303604f, 429.375214f, 41.6996689f);
    builderB.cubicTo(429.375214f, 41.6996689f, 420.610016f, 50.5190887f, 419.918793f, 51.1754227f);
    builderB.cubicTo(419.22757f, 51.8321419f, 419.331482f, 52.2465706f, 419.884308f, 52.8339005f);
    builderB.cubicTo(420.437134f, 53.4212303f, 425.170624f, 58.0167313f, 425.619568f, 58.4660416f);
    builderB.cubicTo(426.068512f, 58.9153557f, 426.137878f, 59.2952805f, 426.137878f, 59.8136024f);
    builderB.cubicTo(426.137878f, 60.3319244f, 426.103394f, 103.141357f, 426.103394f, 103.970215f);
    builderB.cubicTo(426.103394f, 104.799835f, 426.310791f, 105.525177f, 427.17453f, 105.525177f);
    builderB.cubicTo(428.038269f, 105.525177f, 440.131409f, 105.491432f, 440.85675f, 105.491432f);
    builderB.cubicTo(441.582489f, 105.491432f, 441.996918f, 104.903343f, 441.996918f, 104.17762f);
    builderB.cubicTo(441.996918f, 103.452271f, 441.996918f, 89.5622559f, 441.996918f, 87.8002701f);
    builderB.cubicTo(441.996918f, 86.0382843f, 442.342712f, 86.2453079f, 442.826141f, 86.3491974f);
    builderB.cubicTo(443.309601f, 86.4530945f, 445.832184f, 87.040802f, 448.700195f, 87.040802f);
    builderB.cubicTo(466.87442f, 86.6949997f, 471.815338f, 69.4876556f, 471.228394f, 64.443222f);
    builderB.close();
    builderB.moveTo(448.873108f, 72.4595642f);
    builderB.cubicTo(444.636658f, 72.4595642f, 441.202545f, 69.0254517f, 441.202545f, 64.7890244f);
    builderB.cubicTo(441.202545f, 60.5525932f, 444.636658f, 57.1184845f, 448.873108f, 57.1184845f);
    builderB.cubicTo(453.109528f, 57.1184845f, 456.54364f, 60.552597f, 456.54364f, 64.7890244f);
    builderB.cubicTo(456.54364f, 69.0254517f, 453.109528f, 72.4595642f, 448.873108f, 72.4595642f);
    builderB.close();
    builderB.moveTo(520.242859f, 82.5275803f);
    builderB.cubicTo(519.733276f, 81.6547394f, 494.845154f, 41.3379478f, 494.263123f, 40.3923073f);
    builderB.cubicTo(493.681122f, 39.4462852f, 493.244324f, 39.5918846f, 492.807495f, 40.3195038f);
    builderB.cubicTo(492.515167f, 40.8071136f, 467.238037f, 81.6790085f, 466.528625f, 82.8373566f);
    builderB.cubicTo(465.819183f, 83.9945831f, 466.497528f, 84.2975311f, 466.904358f, 84.5792542f);
    builderB.cubicTo(466.904358f, 84.5792542f, 477.399689f, 91.2036743f, 478.235748f, 91.6981049f);
    builderB.cubicTo(479.071838f, 92.1929092f, 479.396393f, 91.9028473f, 479.669403f, 91.5104141f);
    builderB.cubicTo(479.942383f, 91.1175995f, 484.106384f, 84.1549606f, 484.481781f, 83.5570221f);
    builderB.cubicTo(484.857147f, 82.9602051f, 485.198792f, 82.8741379f, 485.966583f, 82.8741379f);
    builderB.cubicTo(486.734406f, 82.8741379f, 499.635925f, 82.8062668f, 500.830322f, 82.8062668f);
    builderB.cubicTo(502.024658f, 82.8062668f, 502.229797f, 83.4038391f, 502.400452f, 83.6427078f);
    builderB.cubicTo(502.571045f, 83.8815842f, 506.615631f, 90.7414703f, 506.990997f, 91.2870865f);
    builderB.cubicTo(507.651123f, 92.2475128f, 508.017395f, 92.1333847f, 508.672241f, 91.6962051f);
    builderB.cubicTo(509.327423f, 91.2597809f, 519.442444f, 85.0744324f, 520.243286f, 84.4920349f);
    builderB.cubicTo(521.042908f, 83.9100189f, 520.751709f, 83.4004211f, 520.242859f, 82.5275803f);
    builderB.close();
    builderB.moveTo(493.720551f, 72.4811783f);
    builderB.cubicTo(491.265442f, 72.4811783f, 489.275574f, 70.4905548f, 489.275574f, 68.0362091f);
    builderB.cubicTo(489.275574f, 65.5811005f, 491.265808f, 63.5912399f, 493.720551f, 63.5912399f);
    builderB.cubicTo(496.175262f, 63.5912399f, 498.165527f, 65.5814819f, 498.165527f, 68.0362091f);
    builderB.cubicTo(498.165894f, 70.4905548f, 496.175659f, 72.4811783f, 493.720551f, 72.4811783f);
    builderB.close();
    builderB.moveTo(526.561707f, 42.132679f);
    builderB.cubicTo(526.876404f, 41.786499f, 527.537292f, 41.1881752f, 528.512878f, 42.1956215f);
    builderB.cubicTo(529.488892f, 43.2030678f, 531.691833f, 45.2486725f, 531.881042f, 45.4693451f);
    builderB.cubicTo(532.07019f, 45.6896439f, 532.762939f, 46.2875862f, 533.517883f, 45.7525826f);
    builderB.cubicTo(534.272827f, 45.2172012f, 539.497681f, 41.9753265f, 545.384277f, 42.132679f);
    builderB.cubicTo(546.203247f, 42.2270889f, 546.580566f, 42.5421791f, 546.612f, 43.8324814f);
    builderB.cubicTo(546.643494f, 45.1227837f, 546.674561f, 55.1957283f, 546.612f, 56.2657356f);
    builderB.cubicTo(546.549072f, 57.3361206f, 546.549072f, 57.7452469f, 544.975525f, 57.8396568f);
    builderB.cubicTo(543.401978f, 57.9340706f, 538.742798f, 59.5709305f, 538.774658f, 64.6070251f);
    builderB.cubicTo(538.806458f, 69.6431122f, 538.806091f, 86.2631226f, 538.806091f, 86.9554901f);
    builderB.cubicTo(538.806091f, 87.6478424f, 538.585815f, 88.4349976f, 537.484314f, 88.4349976f);
    builderB.cubicTo(536.382446f, 88.4349976f, 524.79895f, 88.4031372f, 524.04364f, 88.4031372f);
    builderB.cubicTo(523.287964f, 88.4031372f, 522.910706f, 88.3402023f, 522.910706f, 86.8606949f);
    builderB.cubicTo(522.910706f, 85.3823242f, 522.910706f, 60.6094704f, 522.910706f, 60.0740852f);
    builderB.cubicTo(522.910706f, 59.5387039f, 522.81665f, 58.9092865f, 522.470093f, 58.6260452f);
    builderB.cubicTo(522.123901f, 58.3428116f, 517.465088f, 53.621048f, 517.181885f, 53.3378105f);
    builderB.cubicTo(516.898621f, 53.0545731f, 516.300659f, 52.330368f, 517.213318f, 51.5121231f);
    builderB.cubicTo(518.125977f, 50.6942635f, 526.561707f, 42.132679f, 526.561707f, 42.132679f);
    builderB.close();
    builderB.moveTo(550.169006f, 43.7373123f);
    builderB.cubicTo(550.169006f, 42.6358337f, 550.767334f, 42.2263336f, 551.49115f, 42.2263336f);
    builderB.cubicTo(552.214966f, 42.2263336f, 552.781433f, 42.2263336f, 552.938843f, 42.2263336f);
    builderB.cubicTo(553.096191f, 42.2263336f, 553.725586f, 41.8801537f, 553.662598f, 41.124855f);
    builderB.cubicTo(553.600098f, 40.369175f, 553.662598f, 31.4614124f, 553.662598f, 30.8005257f);
    builderB.cubicTo(553.662598f, 30.1396389f, 553.75708f, 29.1951332f, 555.110657f, 29.1951332f);
    builderB.cubicTo(556.463928f, 29.1951332f, 566.536865f, 29.1951332f, 567.859009f, 29.1951332f);
    builderB.cubicTo(569.180786f, 29.1951332f, 569.463623f, 30.1711082f, 569.463623f, 30.7690544f);
    builderB.cubicTo(569.463623f, 31.3670006f, 569.463623f, 40.2122002f, 569.463623f, 41.0619125f);
    builderB.cubicTo(569.463623f, 41.9116249f, 569.746887f, 42.3207474f, 570.659912f, 42.3207474f);
    builderB.cubicTo(571.572571f, 42.3207474f, 575.507568f, 42.2263336f, 576.199951f, 42.2263336f);
    builderB.cubicTo(576.892273f, 42.2263336f, 577.742004f, 42.5725098f, 577.742004f, 43.8631973f);
    builderB.cubicTo(577.742004f, 45.1538811f, 577.742004f, 55.8877106f, 577.742004f, 56.5800705f);
    builderB.cubicTo(577.742004f, 57.2724266f, 577.616455f, 58.0595779f, 576.45166f, 58.0595779f);
    builderB.cubicTo(575.286865f, 58.0595779f, 570.943115f, 58.0595779f, 570.471069f, 58.0595779f);
    builderB.cubicTo(569.999023f, 58.0595779f, 569.479919f, 57.8389015f, 569.479919f, 59.0510979f);
    builderB.cubicTo(569.479919f, 60.2629128f, 569.479919f, 66.2124176f, 569.479919f, 67.1880188f);
    builderB.cubicTo(569.479919f, 68.1636047f, 570.628418f, 73.6406708f, 575.917053f, 73.6406708f);
    builderB.cubicTo(577.018921f, 73.6406708f, 577.742737f, 73.9242859f, 577.742737f, 75.4348907f);
    builderB.cubicTo(577.742737f, 76.945488f, 577.742737f, 87.0813751f, 577.742737f, 87.8366699f);
    builderB.cubicTo(577.742737f, 88.5915909f, 577.648315f, 89.4416809f, 576.295044f, 89.4416809f);
    builderB.cubicTo(574.028809f, 89.6312714f, 553.978088f, 88.0254974f, 553.631897f, 65.928421f);
    builderB.cubicTo(553.631897f, 65.928421f, 553.631897f, 59.6964378f, 553.631897f, 58.972229f);
    builderB.cubicTo(553.631897f, 58.2484055f, 553.034363f, 58.0436554f, 552.703735f, 58.0436554f);
    builderB.cubicTo(552.372681f, 58.0436554f, 551.522949f, 58.0436554f, 551.208252f, 58.0436554f);
    builderB.cubicTo(550.893921f, 58.0436554f, 550.170105f, 58.0906677f, 550.170105f, 56.6115417f);
    builderB.cubicTo(550.170105f, 55.1324081f, 550.169006f, 43.7373123f, 550.169006f, 43.7373123f);
    builderB.close();
    builderB.moveTo(611.203857f, 39.5509338f);
    builderB.cubicTo(612.084961f, 39.5509338f, 612.620422f, 40.0544662f, 612.620422f, 40.8097687f);
    builderB.cubicTo(612.620422f, 41.5650673f, 612.620422f, 53.1486092f, 612.620422f, 53.6839905f);
    builderB.cubicTo(612.620422f, 54.2193718f, 612.651489f, 55.2264404f, 611.612976f, 55.2264404f);
    builderB.cubicTo(610.574463f, 55.2264404f, 604.404663f, 55.9817429f, 604.404663f, 61.899395f);
    builderB.cubicTo(604.404663f, 65.4878235f, 604.373169f, 66.6211548f, 604.373169f, 67.5338135f);
    builderB.cubicTo(604.373169f, 68.0684357f, 604.414124f, 74.3353043f, 599.934631f, 80.4702148f);
    builderB.cubicTo(596.765564f, 84.8109131f, 590.664368f, 89.3942871f, 582.150208f, 89.630127f);
    builderB.cubicTo(580.028015f, 89.630127f, 580.230469f, 88.5286484f, 580.230469f, 88.1820908f);
    builderB.cubicTo(580.230469f, 87.5845184f, 580.198975f, 75.8436279f, 580.198975f, 75.2142105f);
    builderB.cubicTo(580.198975f, 74.5844116f, 580.608154f, 73.8605804f, 581.58374f, 73.8605804f);
    builderB.cubicTo(583.40979f, 73.8605804f, 588.603271f, 72.7905731f, 588.603271f, 66.9043884f);
    builderB.cubicTo(588.603271f, 61.3958588f, 588.603271f, 61.8679237f, 588.603271f, 61.0496788f);
    builderB.cubicTo(588.603271f, 60.2314377f, 588.666565f, 54.3137856f, 593.230591f, 48.3961296f);
    builderB.cubicTo(597.794617f, 42.4784775f, 604.814087f, 39.5509338f, 611.203857f, 39.5509338f);
    builderB.close();
    builderB.moveTo(635.22937f, 81.9311447f);
    builderB.cubicTo(635.057617f, 81.6475296f, 634.869141f, 81.3851471f, 634.664429f, 81.1439972f);
    builderB.lineTo(635.039001f, 81.0385895f);
    builderB.cubicTo(635.447754f, 80.9233246f, 635.729858f, 80.5509796f, 635.729858f, 80.1263123f);
    builderB.lineTo(635.729858f, 78.6149597f);
    builderB.cubicTo(635.729858f, 78.3309631f, 635.602417f, 78.0617523f, 635.382935f, 77.8816452f);
    builderB.cubicTo(635.162598f, 77.7015381f, 634.873291f, 77.6295013f, 634.595764f, 77.6852341f);
    builderB.cubicTo(633.906799f, 77.8232498f, 633.194397f, 77.9017334f, 632.478149f, 77.9191818f);
    builderB.cubicTo(631.714844f, 77.9373779f, 630.851501f, 77.9464874f, 629.911133f, 77.9464874f);
    builderB.lineTo(615.131226f, 77.9464874f);
    builderB.cubicTo(614.607605f, 77.9464874f, 614.18335f, 78.3707733f, 614.18335f, 78.8944016f);
    builderB.lineTo(614.18335f, 81.1337585f);
    builderB.cubicTo(614.18335f, 81.6573868f, 614.607605f, 82.0816803f, 615.131226f, 82.0816803f);
    builderB.lineTo(619.693787f, 82.0816803f);
    builderB.cubicTo(619.680908f, 82.1423492f, 619.669128f, 82.2026367f, 619.657776f, 82.2629166f);
    builderB.cubicTo(619.571289f, 82.728157f, 619.529602f, 83.3200302f, 619.529602f, 84.0730591f);
    builderB.cubicTo(619.529602f, 86.3196259f, 620.260254f, 88.1236954f, 621.701477f, 89.4348602f);
    builderB.cubicTo(623.116516f, 90.7225037f, 625.163269f, 91.3754272f, 627.784058f, 91.3754272f);
    builderB.cubicTo(630.525024f, 91.3754272f, 632.517944f, 90.8669662f, 633.876099f, 89.8208466f);
    builderB.cubicTo(635.291565f, 88.7314987f, 636.009705f, 87.0798492f, 636.009705f, 84.9129181f);
    builderB.cubicTo(636.010071f, 83.7905807f, 635.747314f, 82.7873077f, 635.22937f, 81.9311447f);
    builderB.close();
    builderB.moveTo(631.880554f, 85.7326736f);
    builderB.cubicTo(631.690552f, 86.0545807f, 631.436157f, 86.307869f, 631.102844f, 86.5076904f);
    builderB.cubicTo(630.736206f, 86.7279816f, 630.277039f, 86.8906479f, 629.737854f, 86.9903717f);
    builderB.cubicTo(629.146362f, 87.1003265f, 628.488892f, 87.1564484f, 627.783997f, 87.1564484f);
    builderB.cubicTo(626.159668f, 87.1564484f, 624.996399f, 86.8656235f, 624.327881f, 86.293457f);
    builderB.cubicTo(623.693604f, 85.7489777f, 623.385315f, 84.995575f, 623.385315f, 83.9896393f);
    builderB.cubicTo(623.385315f, 83.3655396f, 623.431519f, 82.8718567f, 623.522583f, 82.5215149f);
    builderB.cubicTo(623.563477f, 82.3645325f, 623.616943f, 82.2189331f, 623.684448f, 82.0824356f);
    builderB.lineTo(630.008179f, 82.0824356f);
    builderB.cubicTo(630.758911f, 82.247757f, 631.311401f, 82.5256805f, 631.650757f, 82.9101562f);
    builderB.cubicTo(631.990112f, 83.2942505f, 632.154663f, 83.8303986f, 632.154663f, 84.549675f);
    builderB.cubicTo(632.154663f, 85.02742f, 632.062927f, 85.4251709f, 631.880554f, 85.7326736f);
    builderB.close();
    builderB.moveTo(635.667664f, 69.5979919f);
    builderB.cubicTo(635.518311f, 69.0645142f, 635.325684f, 68.5818329f, 635.093994f, 68.1620941f);
    builderB.cubicTo(634.940796f, 67.8856812f, 634.770569f, 67.6316376f, 634.586304f, 67.4026184f);
    builderB.lineTo(635.054565f, 67.2619476f);
    builderB.cubicTo(635.455322f, 67.1417542f, 635.729858f, 66.7724457f, 635.729858f, 66.3538437f);
    builderB.lineTo(635.729858f, 64.7021942f);
    builderB.cubicTo(635.729858f, 64.4045486f, 635.590332f, 64.1243439f, 635.3526f, 63.9449997f);
    builderB.cubicTo(635.115234f, 63.7660294f, 634.807373f, 63.7087784f, 634.521057f, 63.7906761f);
    builderB.cubicTo(634.059998f, 63.9226265f, 633.544678f, 64.0155258f, 632.988831f, 64.0659485f);
    builderB.cubicTo(631.578735f, 64.1941071f, 629.921387f, 64.1565704f, 628.141968f, 64.0632935f);
    builderB.cubicTo(627.067383f, 64.0068054f, 625.948853f, 63.9779854f, 624.81665f, 63.9779854f);
    builderB.cubicTo(624.253601f, 63.9779854f, 623.681396f, 64.0359955f, 623.116089f, 64.1512604f);
    builderB.cubicTo(622.479126f, 64.2809448f, 621.888367f, 64.5437012f, 621.35907f, 64.9315872f);
    builderB.cubicTo(620.807007f, 65.3365402f, 620.360352f, 65.9159088f, 620.031189f, 66.6548996f);
    builderB.cubicTo(619.712708f, 67.3722839f, 619.557983f, 68.2625656f, 619.557983f, 69.3769379f);
    builderB.cubicTo(619.557983f, 70.4655304f, 619.669128f, 71.5268097f, 619.887878f, 72.5323639f);
    builderB.cubicTo(620.11499f, 73.573555f, 620.473694f, 74.5040283f, 620.954468f, 75.2983856f);
    builderB.cubicTo(621.196411f, 75.6976471f, 621.693481f, 75.861824f, 622.124939f, 75.6847534f);
    builderB.lineTo(623.832336f, 74.9851913f);
    builderB.cubicTo(624.086365f, 74.8809204f, 624.282776f, 74.6716156f, 624.370728f, 74.4111328f);
    builderB.cubicTo(624.45874f, 74.15065f, 624.429138f, 73.8651276f, 624.290405f, 73.6281509f);
    builderB.cubicTo(624.166382f, 73.416954f, 624.051147f, 73.1644287f, 623.947205f, 72.875885f);
    builderB.cubicTo(623.836853f, 72.5702744f, 623.741333f, 72.2407837f, 623.663574f, 71.8968811f);
    builderB.cubicTo(623.584717f, 71.549942f, 623.522217f, 71.2018585f, 623.477417f, 70.8621292f);
    builderB.cubicTo(623.434937f, 70.5409775f, 623.41333f, 70.2391663f, 623.41333f, 69.9646454f);
    builderB.cubicTo(623.41333f, 68.8229752f, 623.672729f, 68.4748993f, 623.75116f, 68.3960266f);
    builderB.cubicTo(623.853577f, 68.2940369f, 624.20166f, 68.0574341f, 625.236755f, 68.0574341f);
    builderB.cubicTo(625.39679f, 68.0574341f, 625.566284f, 68.0616074f, 625.744446f, 68.0695648f);
    builderB.lineTo(625.744446f, 68.7331085f);
    builderB.cubicTo(625.744446f, 69.8065338f, 625.819153f, 70.8048782f, 625.967041f, 71.70047f);
    builderB.cubicTo(626.12323f, 72.6483841f, 626.392456f, 73.4825516f, 626.767456f, 74.1794586f);
    builderB.cubicTo(627.173523f, 74.9328613f, 627.730957f, 75.5292969f, 628.424438f, 75.9528198f);
    builderB.cubicTo(629.123596f, 76.3790054f, 629.981628f, 76.5951309f, 630.975464f, 76.5951309f);
    builderB.cubicTo(631.722046f, 76.5951309f, 632.406799f, 76.4597626f, 633.009644f, 76.1924591f);
    builderB.cubicTo(633.611816f, 75.9262848f, 634.136536f, 75.5543213f, 634.567688f, 75.0875626f);
    builderB.cubicTo(634.998779f, 74.6223297f, 635.333191f, 74.0672302f, 635.561096f, 73.4370575f);
    builderB.cubicTo(635.78479f, 72.8212891f, 635.898193f, 72.1520538f, 635.898193f, 71.4479446f);
    builderB.cubicTo(635.898193f, 70.7688599f, 635.820496f, 70.1462708f, 635.667664f, 69.5979919f);
    builderB.close();
    builderB.moveTo(631.656494f, 71.9905396f);
    builderB.cubicTo(631.416077f, 72.2574692f, 631.13739f, 72.3765259f, 630.751404f, 72.3765259f);
    builderB.cubicTo(630.390015f, 72.3765259f, 630.239502f, 72.2536774f, 630.190247f, 72.2127228f);
    builderB.cubicTo(630.002197f, 72.0587845f, 629.853149f, 71.8483429f, 629.735596f, 71.5704193f);
    builderB.cubicTo(629.594177f, 71.2348557f, 629.494507f, 70.8310394f, 629.439453f, 70.3714905f);
    builderB.cubicTo(629.379211f, 69.8607559f, 629.348511f, 69.3284073f, 629.348511f, 68.7892303f);
    builderB.cubicTo(629.348511f, 68.5765228f, 629.351929f, 68.3603973f, 629.357971f, 68.1416168f);
    builderB.lineTo(630.581177f, 68.1416168f);
    builderB.cubicTo(630.702515f, 68.2026672f, 630.831787f, 68.2841797f, 630.967163f, 68.3857956f);
    builderB.cubicTo(631.149902f, 68.523056f, 631.322815f, 68.703537f, 631.480225f, 68.922699f);
    builderB.cubicTo(631.639038f, 69.1437531f, 631.77478f, 69.4186478f, 631.884399f, 69.7390442f);
    builderB.cubicTo(631.989807f, 70.0488281f, 632.04364f, 70.4169922f, 632.04364f, 70.8329391f);
    builderB.cubicTo(632.042847f, 71.3228302f, 631.916565f, 71.7012329f, 631.656494f, 71.9905396f);
    builderB.close();
    builderB.moveTo(622.689575f, 63.4953079f);
    builderB.lineTo(620.72998f, 63.4953079f);
    builderB.cubicTo(620.206421f, 63.4953079f, 619.782104f, 63.0710182f, 619.782104f, 62.54739f);
    builderB.lineTo(619.782104f, 61.3116837f);
    builderB.lineTo(617.958679f, 61.3116837f);
    builderB.cubicTo(617.536255f, 61.3116837f, 617.164307f, 61.0318604f, 617.047913f, 60.6257744f);
    builderB.lineTo(616.404114f, 58.3864136f);
    builderB.cubicTo(616.321411f, 58.1001472f, 616.378662f, 57.7922592f, 616.557678f, 57.5541458f);
    builderB.cubicTo(616.737061f, 57.3164062f, 617.017212f, 57.1764946f, 617.31488f, 57.1764946f);
    builderB.lineTo(619.782104f, 57.1764946f);
    builderB.lineTo(619.782104f, 54.3171997f);
    builderB.cubicTo(619.782104f, 53.7935715f, 620.206421f, 53.3692818f, 620.730042f, 53.3692818f);
    builderB.lineTo(622.689575f, 53.3692818f);
    builderB.cubicTo(623.213196f, 53.3692818f, 623.637512f, 53.7935715f, 623.637512f, 54.3171997f);
    builderB.lineTo(623.637512f, 57.1764946f);
    builderB.lineTo(630.443176f, 57.1764946f);
    builderB.cubicTo(631.548828f, 57.1764946f, 631.921936f, 57.0028381f, 632.009888f, 56.9493713f);
    builderB.cubicTo(632.057617f, 56.9205589f, 632.154724f, 56.8621674f, 632.154724f, 56.5288773f);
    builderB.cubicTo(632.154724f, 56.139473f, 632.116821f, 55.8179398f, 632.04248f, 55.5737572f);
    builderB.cubicTo(631.949219f, 55.268528f, 631.822205f, 54.9193192f, 631.665588f, 54.5363579f);
    builderB.cubicTo(631.563599f, 54.288002f, 631.572327f, 54.0085602f, 631.688354f, 53.7670288f);
    builderB.cubicTo(631.804749f, 53.5251198f, 632.017456f, 53.3438797f, 632.274536f, 53.2680435f);
    builderB.lineTo(633.9823f, 52.7641296f);
    builderB.cubicTo(634.430115f, 52.6325607f, 634.90332f, 52.8437576f, 635.105042f, 53.2623596f);
    builderB.cubicTo(635.375f, 53.8235245f, 635.59491f, 54.4404297f, 635.758301f, 55.0956268f);
    builderB.cubicTo(635.925537f, 55.7656174f, 636.010498f, 56.4928589f, 636.010498f, 57.2565002f);
    builderB.cubicTo(636.010498f, 58.7109833f, 635.553589f, 59.7790947f, 634.653076f, 60.4316406f);
    builderB.cubicTo(633.835938f, 61.0235176f, 632.596069f, 61.311306f, 630.863647f, 61.311306f);
    builderB.lineTo(623.637878f, 61.311306f);
    builderB.lineTo(623.637878f, 62.5470123f);
    builderB.cubicTo(623.637451f, 63.071022f, 623.213196f, 63.4953079f, 622.689575f, 63.4953079f);
    builderB.close();
    builderB.moveTo(635.667664f, 46.2246475f);
    builderB.cubicTo(635.518311f, 45.6911545f, 635.325684f, 45.2084808f, 635.093994f, 44.7887421f);
    builderB.cubicTo(634.940796f, 44.5123291f, 634.770569f, 44.2582855f, 634.586304f, 44.029274f);
    builderB.lineTo(635.054565f, 43.8886032f);
    builderB.cubicTo(635.455322f, 43.7684059f, 635.729858f, 43.3990974f, 635.729858f, 42.9804955f);
    builderB.lineTo(635.729858f, 41.328846f);
    builderB.cubicTo(635.729858f, 41.0312004f, 635.590332f, 40.7509995f, 635.3526f, 40.5716515f);
    builderB.cubicTo(635.115234f, 40.3926849f, 634.807373f, 40.3354301f, 634.521057f, 40.4173279f);
    builderB.cubicTo(634.059998f, 40.5492783f, 633.544678f, 40.6421738f, 632.988831f, 40.6926041f);
    builderB.cubicTo(631.578735f, 40.8207626f, 629.921387f, 40.7836075f, 628.141968f, 40.689949f);
    builderB.cubicTo(627.067383f, 40.6334534f, 625.948853f, 40.6046371f, 624.81665f, 40.6046371f);
    builderB.cubicTo(624.253601f, 40.6046371f, 623.681396f, 40.6626511f, 623.116089f, 40.777916f);
    builderB.cubicTo(622.479126f, 40.9075928f, 621.888367f, 41.1703568f, 621.35907f, 41.5582428f);
    builderB.cubicTo(620.807007f, 41.963192f, 620.360352f, 42.5425606f, 620.031189f, 43.2815552f);
    builderB.cubicTo(619.712708f, 43.9989395f, 619.557983f, 44.8892212f, 619.557983f, 46.0035934f);
    builderB.cubicTo(619.557983f, 47.0921783f, 619.669128f, 48.1534653f, 619.887878f, 49.1590195f);
    builderB.cubicTo(620.11499f, 50.2002106f, 620.473694f, 51.1306839f, 620.954468f, 51.9250374f);
    builderB.cubicTo(621.196411f, 52.3243027f, 621.693481f, 52.4880981f, 622.124939f, 52.311409f);
    builderB.lineTo(623.832336f, 51.6118431f);
    builderB.cubicTo(624.086365f, 51.5075722f, 624.282776f, 51.2982712f, 624.370728f, 51.0377846f);
    builderB.cubicTo(624.45874f, 50.777298f, 624.429138f, 50.4917831f, 624.290405f, 50.2548065f);
    builderB.cubicTo(624.166382f, 50.0436096f, 624.051147f, 49.7910843f, 623.947205f, 49.5025406f);
    builderB.cubicTo(623.836853f, 49.1969299f, 623.741333f, 48.8674355f, 623.663574f, 48.5235291f);
    builderB.cubicTo(623.584717f, 48.1765938f, 623.522217f, 47.8285179f, 623.477417f, 47.4887848f);
    builderB.cubicTo(623.434937f, 47.1676331f, 623.41333f, 46.8658142f, 623.41333f, 46.5912971f);
    builderB.cubicTo(623.41333f, 45.4496269f, 623.672729f, 45.1015511f, 623.75116f, 45.0226822f);
    builderB.cubicTo(623.853577f, 44.9206886f, 624.20166f, 44.6840897f, 625.236755f, 44.6840897f);
    builderB.cubicTo(625.39679f, 44.6840897f, 625.566284f, 44.6882591f, 625.744446f, 44.6962204f);
    builderB.lineTo(625.744446f, 45.3597641f);
    builderB.cubicTo(625.744446f, 46.4331856f, 625.819153f, 47.43153f, 625.967041f, 48.3271217f);
    builderB.cubicTo(626.12323f, 49.2750397f, 626.392456f, 50.1092072f, 626.767456f, 50.8061142f);
    builderB.cubicTo(627.173523f, 51.5595169f, 627.730957f, 52.1559486f, 628.424438f, 52.5794754f);
    builderB.cubicTo(629.123596f, 53.005661f, 629.981628f, 53.2217865f, 630.975464f, 53.2217865f);
    builderB.cubicTo(631.722046f, 53.2217865f, 632.406799f, 53.086422f, 633.009644f, 52.8191147f);
    builderB.cubicTo(633.611816f, 52.5529366f, 634.136536f, 52.1809769f, 634.567688f, 51.7142181f);
    builderB.cubicTo(634.998779f, 51.2489815f, 635.333191f, 50.693882f, 635.561096f, 50.0637054f);
    builderB.cubicTo(635.78479f, 49.4479408f, 635.898193f, 48.7787094f, 635.898193f, 48.0746002f);
    builderB.cubicTo(635.898193f, 47.3958893f, 635.820496f, 46.7733002f, 635.667664f, 46.2246475f);
    builderB.close();
    builderB.moveTo(631.656494f, 48.6171875f);
    builderB.cubicTo(631.416077f, 48.8841209f, 631.13739f, 49.0031815f, 630.751404f, 49.0031815f);
    builderB.cubicTo(630.390015f, 49.0031815f, 630.239502f, 48.8803291f, 630.190247f, 48.8393784f);
    builderB.cubicTo(630.002197f, 48.6854401f, 629.853149f, 48.4749985f, 629.735596f, 48.1970711f);
    builderB.cubicTo(629.594177f, 47.8615112f, 629.494507f, 47.457695f, 629.439453f, 46.9981461f);
    builderB.cubicTo(629.379211f, 46.4874115f, 629.348511f, 45.9550591f, 629.348511f, 45.4158859f);
    builderB.cubicTo(629.348511f, 45.2031708f, 629.351929f, 44.9870453f, 629.357971f, 44.7682648f);
    builderB.lineTo(630.581177f, 44.7682648f);
    builderB.cubicTo(630.702515f, 44.8293152f, 630.831787f, 44.9108353f, 630.967163f, 45.0124512f);
    builderB.cubicTo(631.149902f, 45.1497116f, 631.322815f, 45.3301926f, 631.480225f, 45.5493507f);
    builderB.cubicTo(631.639038f, 45.7704048f, 631.77478f, 46.0453033f, 631.884399f, 46.3656998f);
    builderB.cubicTo(631.989807f, 46.6754761f, 632.04364f, 47.0436478f, 632.04364f, 47.4595947f);
    builderB.cubicTo(632.042847f, 47.949852f, 631.916565f, 48.3282623f, 631.656494f, 48.6171875f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_seopack_blogspot_com_2153(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(999.892212f, 246);
    builder.lineTo(927.340759f, 245.505722f);
    builder.quadTo(928.068054f, 246, 929, 246);
    builder.lineTo(999.892212f, 246);
    builder.close();
    builder.moveTo(927.340759f, 245.505722f);
    builder.lineTo(926.5f, 245.5f);
    builder.lineTo(925.17157f, 246.82843f);
    builder.quadTo(926.34314f, 248, 928, 248);
    builder.lineTo(1000, 248);
    builder.lineTo(1000, 246);
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(924, 248);
    builderB.lineTo(924, 245.472672f);
    builderB.lineTo(1143, 247);
    builderB.lineTo(1143, 248);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_lokado_de_173(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 896.991394f);
    builder.quadTo(999.789917f, 896.718872f, 999.535522f, 896.464478f);
    builder.quadTo(998.071045f, 895, 996, 895);
    builder.lineTo(956, 895);
    builder.quadTo(951.857849f, 895, 948.928955f, 897.928955f);
    builder.quadTo(946, 900.857849f, 946, 905);
    builder.lineTo(946, 906);
    builder.quadTo(946, 910.142151f, 948.928955f, 913.071045f);
    builder.quadTo(951.857849f, 916, 956, 916);
    builder.lineTo(996, 916);
    builder.quadTo(998.071045f, 916, 999.535522f, 914.535522f);
    builder.quadTo(999.789917f, 914.281128f, 1000, 914.008606f);
    builder.lineTo(1000, 896.991394f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(946, 906);
    builderB.lineTo(946, 905);
    builderB.quadTo(946, 901.272095f, 948.928955f, 898.636047f);
    builderB.quadTo(951.857849f, 896, 956, 896);
    builderB.lineTo(996, 896);
    builderB.quadTo(998.071045f, 896, 999.535522f, 897.17157f);
    builderB.quadTo(1001, 898.34314f, 1001, 900);
    builderB.lineTo(1001, 911);
    builderB.quadTo(1001, 913.071045f, 999.535522f, 914.535522f);
    builderB.quadTo(998.071045f, 916, 996, 916);
    builderB.lineTo(956, 916);
    builderB.quadTo(951.857849f, 916, 948.928955f, 913.071045f);
    builderB.quadTo(946, 910.142151f, 946, 906);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_wartepop_blogspot_com_br_6(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(90.9763107f, 153.309662f);
    builder.quadTo(91.9526215f, 152.333344f, 93.3333359f, 152.333344f);
    builder.lineTo(124.666664f, 152.333344f);
    builder.quadTo(126.047379f, 152.333344f, 127.023689f, 153.309662f);
    builder.quadTo(128, 154.285965f, 128, 155.666672f);
    builder.lineTo(128, 163.666672f);
    builder.lineTo(90, 163.666672f);
    builder.lineTo(90, 155.666672f);
    builder.quadTo(90, 154.285965f, 90.9763107f, 153.309662f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(90, 163.666672f);
    builderB.lineTo(90, 155.666672f);
    builderB.quadTo(90, 154.285965f, 90.9763107f, 153.309662f);
    builderB.quadTo(91.9526215f, 152.333344f, 93.3333359f, 152.333344f);
    builderB.lineTo(124.666672f, 152.333344f);
    builderB.quadTo(125.909309f, 152.333344f, 126.787994f, 153.309662f);
    builderB.quadTo(127.666672f, 154.285965f, 127.666672f, 155.666672f);
    builderB.lineTo(127.666672f, 163.666672f);
    builderB.lineTo(127.666672f, 163.666672f);
    builderB.lineTo(127.666672f, 163.666672f);
    builderB.lineTo(90, 163.666672f);
    builderB.lineTo(90, 163.666672f);
    builderB.lineTo(90, 163.666672f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_wartepop_blogspot_com_br_6a(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(90.9763107f, 153.309662f);
    builder.quadTo(91.9526215f, 152.333344f, 93.3333359f, 152.333344f);
    builder.lineTo(124.666672f, 152.333344f);
    builder.quadTo(126.047379f, 152.333344f, 127.023689f, 153.309662f);
    builder.quadTo(128, 154.285965f, 128, 155.666672f);
    builder.lineTo(128, 163.666672f);
    builder.lineTo(90, 163.666672f);
    builder.lineTo(90, 155.666672f);
    builder.quadTo(90, 154.285965f, 90.9763107f, 153.309662f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(90, 163.666672f);
    builderB.lineTo(90, 155.666672f);
    builderB.quadTo(90, 154.285965f, 90.9763107f, 153.309662f);
    builderB.quadTo(91.9526215f, 152.333344f, 93.3333359f, 152.333344f);
    builderB.lineTo(124.666672f, 152.333344f);
    builderB.quadTo(125.909309f, 152.333344f, 126.787994f, 153.309662f);
    builderB.quadTo(127.666672f, 154.285965f, 127.666672f, 155.666672f);
    builderB.lineTo(127.666672f, 163.666672f);
    builderB.lineTo(127.666672f, 163.666672f);
    builderB.lineTo(127.666672f, 163.666672f);
    builderB.lineTo(90, 163.666672f);
    builderB.lineTo(90, 163.666672f);
    builderB.lineTo(90, 163.666672f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_odia_com_br_26(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(360.740479f, 741.040771f);
    builder.quadTo(360.378967f, 741, 360, 741);
    builder.quadTo(359.159821f, 741, 358.403076f, 741.200745f);
    builder.quadTo(357.649658f, 741.415833f, 356.92746f, 741.846436f);
    builder.quadTo(356.600769f, 742.041199f, 356.310211f, 742.262268f);
    builder.quadTo(356.025513f, 742.489197f, 355.757355f, 742.757385f);
    builder.quadTo(355.16394f, 743.350769f, 354.770874f, 744.027283f);
    builder.quadTo(354.389618f, 744.71283f, 354.183258f, 745.528564f);
    builder.quadTo(354.090027f, 745.897095f, 354.040833f, 746.259277f);
    builder.quadTo(354, 746.621216f, 354, 747);
    builder.quadTo(354, 747.839844f, 354.200653f, 748.596497f);
    builder.quadTo(354.415771f, 749.35022f, 354.846466f, 750.072632f);
    builder.quadTo(355.040741f, 750.398438f, 355.261444f, 750.688721f);
    builder.quadTo(355.488861f, 750.974121f, 355.757355f, 751.242615f);
    builder.quadTo(356.352142f, 751.837402f, 357.030304f, 752.230896f);
    builder.quadTo(357.714539f, 752.610901f, 358.528564f, 752.816833f);
    builder.quadTo(358.895294f, 752.909607f, 359.25528f, 752.95874f);
    builder.quadTo(359.618896f, 753, 360, 753);
    builder.quadTo(360.842285f, 753, 361.600952f, 752.798157f);
    builder.quadTo(362.352386f, 752.583008f, 363.072601f, 752.153625f);
    builder.quadTo(363.397339f, 751.960022f, 363.686829f, 751.740051f);
    builder.quadTo(363.973297f, 751.511963f, 364.242645f, 751.242615f);
    builder.quadTo(364.837799f, 750.647461f, 365.231354f, 749.968933f);
    builder.quadTo(365.610992f, 749.285034f, 365.816803f, 748.471497f);
    builder.quadTo(365.909668f, 748.104431f, 365.958832f, 747.743713f);
    builder.quadTo(366, 747.380371f, 366, 747);
    builder.quadTo(366, 746.158997f, 365.798767f, 745.401367f);
    builder.quadTo(365.583618f, 744.648682f, 365.153595f, 743.927429f);
    builder.quadTo(364.959442f, 743.601807f, 364.738678f, 743.311462f);
    builder.quadTo(364.511108f, 743.025818f, 364.242645f, 742.757385f);
    builder.quadTo(363.649017f, 742.163757f, 362.972168f, 741.770569f);
    builder.quadTo(362.286835f, 741.389526f, 361.471497f, 741.183289f);
    builder.quadTo(361.102509f, 741.089966f, 360.740479f, 741.040771f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(355.654724f, 739.711792f);
    builderB.lineTo(367.288269f, 742.654724f);
    builderB.lineTo(364.345337f, 754.288269f);
    builderB.lineTo(352.711792f, 751.345337f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_evolvehq_com_210(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(172, 972);
    builder.quadTo(170.757355f, 972, 169.878677f, 972.878662f);
    builder.quadTo(169, 973.757385f, 169, 975);
    builder.lineTo(169, 1171);
    builder.quadTo(169, 1172.24268f, 169.878677f, 1173.12134f);
    builder.quadTo(170.757355f, 1174, 172, 1174);
    builder.lineTo(308, 1174);
    builder.quadTo(309.242645f, 1174, 310.121307f, 1173.12134f);
    builder.quadTo(310.337311f, 1172.9054f, 310.5f, 1172.66772f);
    builder.lineTo(310.5f, 973.332336f);
    builder.quadTo(310.337219f, 973.094604f, 310.121307f, 972.878662f);
    builder.quadTo(309.242645f, 972, 308, 972);
    builder.lineTo(172, 972);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(170, 1171);
    builderB.lineTo(170, 975);
    builderB.quadTo(170, 974.17157f, 170.585785f, 973.585815f);
    builderB.quadTo(171.17157f, 973, 172, 973);
    builderB.lineTo(308, 973);
    builderB.quadTo(309.242645f, 973, 310.121307f, 973.585815f);
    builderB.quadTo(311, 974.17157f, 311, 975);
    builderB.lineTo(311, 1171);
    builderB.quadTo(311, 1172.24268f, 310.121307f, 1173.12134f);
    builderB.quadTo(309.242645f, 1174, 308, 1174);
    builderB.lineTo(172, 1174);
    builderB.quadTo(171.17157f, 1174, 170.585785f, 1173.12134f);
    builderB.quadTo(170, 1172.24268f, 170, 1171);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_catingueiraonline_com_352(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(443, 8292);
    builder.lineTo(443, 8140);
    builder.lineTo(444, 8140);
    builder.lineTo(444.01001f, 8292);
    builder.lineTo(443, 8292);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(443, 8140);
    builderB.lineTo(444.01001f, 8140);
    builderB.lineTo(444, 8292);
    builderB.lineTo(443, 8292);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_galaxystwo_com_4(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(10105, 2510);
    builder.lineTo(10123, 2509.98999f);
    builder.lineTo(10123, 2511);
    builder.lineTo(10105, 2511);
    builder.lineTo(10105, 2510);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(10105, 2511);
    builderB.lineTo(10105, 2509.98999f);
    builderB.lineTo(10123, 2510);
    builderB.lineTo(10123, 2511);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_thaienews_blogspot_com_36(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(429.994995f, 6268);
    builder.lineTo(430, 2187);
    builder.lineTo(430.5f, 2187);
    builder.lineTo(430.5f, 6268);
    builder.lineTo(429.994995f, 6268);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(430.5f, 2187);
    builderB.lineTo(429.994995f, 2187);
    builderB.lineTo(430, 6268);
    builderB.lineTo(430.5f, 6268);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_fashionscandal_com_94(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(25.9107456f, 272.577423f);
    builder.quadTo(26.1548233f, 272.333344f, 26.5000019f, 272.333344f);
    builder.lineTo(131.166672f, 272.333344f);
    builder.quadTo(131.511841f, 272.333344f, 131.75592f, 272.577423f);
    builder.quadTo(132, 272.821503f, 132, 273.166687f);
    builder.lineTo(132, 417.166656f);
    builder.quadTo(132, 417.511841f, 131.75592f, 417.75592f);
    builder.quadTo(131.511841f, 418, 131.166672f, 418);
    builder.lineTo(26.5000019f, 418);
    builder.quadTo(26.1548233f, 418, 25.9107456f, 417.75592f);
    builder.quadTo(25.6666679f, 417.511841f, 25.6666679f, 417.166656f);
    builder.lineTo(25.6666679f, 273.166687f);
    builder.quadTo(25.6666679f, 272.821503f, 25.9107456f, 272.577423f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(25.833334f, 417.166656f);
    builderB.lineTo(25.833334f, 273.166656f);
    builderB.quadTo(25.833334f, 272.890533f, 26.0285969f, 272.695251f);
    builderB.quadTo(26.2238579f, 272.5f, 26.5f, 272.5f);
    builderB.lineTo(131.166672f, 272.5f);
    builderB.quadTo(131.442825f, 272.5f, 131.638077f, 272.695251f);
    builderB.quadTo(131.833344f, 272.890533f, 131.833344f, 273.166656f);
    builderB.lineTo(131.833344f, 417.166656f);
    builderB.quadTo(131.833344f, 417.511841f, 131.638077f, 417.75592f);
    builderB.quadTo(131.442825f, 418, 131.166672f, 418);
    builderB.lineTo(26.5f, 418);
    builderB.quadTo(26.2238579f, 418, 26.0285969f, 417.75592f);
    builderB.quadTo(25.833334f, 417.511841f, 25.833334f, 417.166656f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kDifference_SkPathOp, filename);
}

static void skpwww_kenlevine_blogspot_com_28(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(276, 9506);
    builder.lineTo(276, 7531);
    builder.lineTo(277, 7531);
    builder.lineTo(277.01001f, 9506);
    builder.lineTo(276, 9506);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(276, 7531);
    builderB.lineTo(277.01001f, 7531);
    builderB.lineTo(277, 9506);
    builderB.lineTo(276, 9506);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_defense_studies_blogspot_com_64(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(276, 9600);
    builder.lineTo(276, 7703);
    builder.lineTo(277, 7703);
    builder.lineTo(277.01001f, 9600);
    builder.lineTo(276, 9600);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(276, 7703);
    builderB.lineTo(277.01001f, 7703);
    builderB.lineTo(277, 9600);
    builderB.lineTo(276, 9600);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_uniquefx_net_442(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(960, 306);
    builder.lineTo(960, 305);
    builder.lineTo(1000, 305);
    builder.lineTo(1000, 306.708527f);
    builder.lineTo(960, 306);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(960, 305);
    builderB.lineTo(958.997253f, 306.002747f);
    builderB.lineTo(1017, 307);
    builderB.lineTo(1019, 305);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_kitcheninspirations_wordpress_com_32(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(47.1666679f, 19651.334f);
    builder.lineTo(65.8333359f, 19651.332f);
    builder.lineTo(65.8333359f, 19651.5f);
    builder.lineTo(47.1666679f, 19651.5f);
    builder.lineTo(47.1666679f, 19651.334f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(47.1666679f, 19651.5f);
    builderB.lineTo(47.1666679f, 19651.332f);
    builderB.lineTo(65.8333359f, 19651.334f);
    builderB.lineTo(65.8333359f, 19651.5f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_educationalcraft_com_4(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(941, 1494);
    builder.lineTo(941, 1464);
    builder.lineTo(985, 1464);
    builder.lineTo(985, 1494);
    builder.lineTo(941, 1494);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(979.211975f, 1480.45496f);
    builderB.cubicTo(979.211975f, 1480.45496f, 976.348999f, 1479.68506f, 977.495972f, 1475.59497f);
    builderB.cubicTo(977.497009f, 1475.59497f, 981.072021f, 1477.88501f, 979.211975f, 1480.45496f);
    builderB.close();
    builderB.moveTo(977.854004f, 1484.453f);
    builderB.cubicTo(977.854004f, 1484.453f, 975.265991f, 1483.26099f, 976.713989f, 1479.35205f);
    builderB.cubicTo(976.713989f, 1479.35303f, 979.84198f, 1482.23499f, 977.854004f, 1484.453f);
    builderB.close();
    builderB.moveTo(980.226013f, 1476.229f);
    builderB.cubicTo(980.226013f, 1476.229f, 977.078003f, 1476.349f, 977.234985f, 1471.97095f);
    builderB.cubicTo(977.234985f, 1471.97095f, 980.666992f, 1473.12903f, 980.226013f, 1476.229f);
    builderB.close();
    builderB.moveTo(984.546021f, 1478.31494f);
    builderB.cubicTo(984.546021f, 1478.31494f, 983.187988f, 1481.93396f, 980.026001f, 1481.276f);
    builderB.cubicTo(980.026978f, 1481.276f, 979.554993f, 1478.38904f, 984.546021f, 1478.31494f);
    builderB.close();
    builderB.moveTo(978.989014f, 1484.198f);
    builderB.cubicTo(978.989014f, 1484.198f, 979.094971f, 1481.33496f, 983.786011f, 1481.823f);
    builderB.cubicTo(983.786011f, 1481.823f, 982.070007f, 1485.49805f, 978.989014f, 1484.198f);
    builderB.close();
    builderB.moveTo(976.393005f, 1486.86804f);
    builderB.cubicTo(976.393005f, 1486.86804f, 976.719971f, 1484.06494f, 981.679016f, 1485.37f);
    builderB.cubicTo(981.679016f, 1485.37f, 979.169983f, 1488.40796f, 976.393005f, 1486.86804f);
    builderB.close();
    builderB.moveTo(969.156982f, 1490.40002f);
    builderB.cubicTo(969.156982f, 1490.40002f, 971.478027f, 1488.23596f, 974.869995f, 1491.21399f);
    builderB.cubicTo(974.869995f, 1491.21497f, 970.828003f, 1493.026f, 969.156982f, 1490.40002f);
    builderB.close();
    builderB.moveTo(972.825012f, 1483.93701f);
    builderB.cubicTo(972.825012f, 1483.93701f, 973.971985f, 1487.98401f, 971.161987f, 1488.94604f);
    builderB.cubicTo(971.161987f, 1488.94495f, 969.278015f, 1486.37097f, 972.825012f, 1483.93701f);
    builderB.close();
    builderB.moveTo(965.60199f, 1489.98499f);
    builderB.cubicTo(965.60199f, 1489.98499f, 964.879028f, 1487.19202f, 969.864014f, 1486.75f);
    builderB.cubicTo(969.864014f, 1486.75f, 968.749023f, 1490.672f, 965.60199f, 1489.98499f);
    builderB.close();
    builderB.moveTo(970.666992f, 1492.81604f);
    builderB.cubicTo(970.666992f, 1492.81604f, 967.327026f, 1494.49695f, 964.999023f, 1491.56299f);
    builderB.cubicTo(964.999023f, 1491.56299f, 967.304016f, 1489.43896f, 970.666992f, 1492.81604f);
    builderB.close();
    builderB.moveTo(968.343994f, 1481.53796f);
    builderB.cubicTo(971.573975f, 1479.94995f, 971.687988f, 1476.78601f, 971.687988f, 1476.78601f);
    builderB.lineTo(971.393982f, 1466.83398f);
    builderB.lineTo(954.960999f, 1466.83398f);
    builderB.lineTo(954.666016f, 1476.78601f);
    builderB.cubicTo(954.666016f, 1476.78601f, 954.780029f, 1479.94995f, 958.008972f, 1481.53796f);
    builderB.cubicTo(960.781006f, 1482.90295f, 962.166992f, 1484.77698f, 962.166992f, 1484.77698f);
    builderB.cubicTo(962.166992f, 1484.77698f, 962.747986f, 1485.70105f, 963.177979f, 1485.70105f);
    builderB.cubicTo(963.606995f, 1485.70105f, 964.185974f, 1484.77698f, 964.185974f, 1484.77698f);
    builderB.cubicTo(964.185974f, 1484.77698f, 965.573975f, 1482.90295f, 968.343994f, 1481.53796f);
    builderB.close();
    builderB.moveTo(963.215027f, 1486.67004f);
    builderB.cubicTo(962.744995f, 1486.67004f, 962.106995f, 1485.65405f, 962.106995f, 1485.65405f);
    builderB.cubicTo(962.106995f, 1485.65405f, 960.585022f, 1483.59595f, 957.539001f, 1482.09705f);
    builderB.cubicTo(953.991028f, 1480.35205f, 953.867004f, 1476.87598f, 953.867004f, 1476.87598f);
    builderB.lineTo(954.190002f, 1465.94397f);
    builderB.lineTo(972.23999f, 1465.94397f);
    builderB.lineTo(972.565002f, 1476.87695f);
    builderB.cubicTo(972.565002f, 1476.87695f, 972.440979f, 1480.35303f, 968.891968f, 1482.09802f);
    builderB.cubicTo(965.846008f, 1483.59705f, 964.325012f, 1485.65503f, 964.325012f, 1485.65503f);
    builderB.cubicTo(964.325012f, 1485.65503f, 963.687012f, 1486.67004f, 963.215027f, 1486.67004f);
    builderB.close();
    builderB.moveTo(960.68103f, 1489.98499f);
    builderB.cubicTo(957.533997f, 1490.672f, 956.417969f, 1486.75f, 956.417969f, 1486.75f);
    builderB.cubicTo(961.403015f, 1487.19202f, 960.68103f, 1489.98499f, 960.68103f, 1489.98499f);
    builderB.close();
    builderB.moveTo(963.143005f, 1489.59802f);
    builderB.cubicTo(963.763f, 1489.59802f, 964.265015f, 1490.09998f, 964.265015f, 1490.72095f);
    builderB.cubicTo(964.265015f, 1491.34204f, 963.763f, 1491.84399f, 963.143005f, 1491.84399f);
    builderB.cubicTo(962.521973f, 1491.84399f, 962.02002f, 1491.34204f, 962.02002f, 1490.72095f);
    builderB.cubicTo(962.02002f, 1490.09998f, 962.521973f, 1489.59802f, 963.143005f, 1489.59802f);
    builderB.close();
    builderB.moveTo(961.283997f, 1491.56299f);
    builderB.cubicTo(958.953979f, 1494.49695f, 955.61499f, 1492.81604f, 955.61499f, 1492.81604f);
    builderB.cubicTo(958.97699f, 1489.43896f, 961.283997f, 1491.56299f, 961.283997f, 1491.56299f);
    builderB.close();
    builderB.moveTo(957.127014f, 1490.40002f);
    builderB.cubicTo(955.455017f, 1493.026f, 951.414001f, 1491.21399f, 951.414001f, 1491.21399f);
    builderB.cubicTo(954.802979f, 1488.23596f, 957.127014f, 1490.40002f, 957.127014f, 1490.40002f);
    builderB.close();
    builderB.moveTo(949.890991f, 1486.86804f);
    builderB.cubicTo(947.112976f, 1488.40796f, 944.604004f, 1485.37f, 944.604004f, 1485.37f);
    builderB.cubicTo(949.562012f, 1484.06494f, 949.890991f, 1486.86804f, 949.890991f, 1486.86804f);
    builderB.close();
    builderB.moveTo(947.070984f, 1480.45496f);
    builderB.cubicTo(945.211975f, 1477.88501f, 948.786011f, 1475.59497f, 948.786011f, 1475.59497f);
    builderB.cubicTo(949.934021f, 1479.68506f, 947.070984f, 1480.45496f, 947.070984f, 1480.45496f);
    builderB.close();
    builderB.moveTo(946.054016f, 1476.229f);
    builderB.cubicTo(945.61499f, 1473.12903f, 949.046997f, 1471.97095f, 949.046997f, 1471.97095f);
    builderB.cubicTo(949.205994f, 1476.349f, 946.054016f, 1476.229f, 946.054016f, 1476.229f);
    builderB.close();
    builderB.moveTo(948.427002f, 1484.453f);
    builderB.cubicTo(946.440002f, 1482.23499f, 949.567993f, 1479.35205f, 949.567993f, 1479.35205f);
    builderB.cubicTo(951.015991f, 1483.26099f, 948.427002f, 1484.453f, 948.427002f, 1484.453f);
    builderB.close();
    builderB.moveTo(947.294006f, 1484.198f);
    builderB.cubicTo(944.210999f, 1485.49805f, 942.495972f, 1481.823f, 942.495972f, 1481.823f);
    builderB.cubicTo(947.187988f, 1481.33496f, 947.294006f, 1484.198f, 947.294006f, 1484.198f);
    builderB.close();
    builderB.moveTo(946.255005f, 1481.276f);
    builderB.cubicTo(943.094971f, 1481.93396f, 941.736023f, 1478.31494f, 941.736023f, 1478.31494f);
    builderB.cubicTo(946.728027f, 1478.38904f, 946.255005f, 1481.276f, 946.255005f, 1481.276f);
    builderB.close();
    builderB.moveTo(945.312988f, 1478.18005f);
    builderB.cubicTo(942.052979f, 1477.80103f, 942.651001f, 1473.87805f, 942.651001f, 1473.87805f);
    builderB.cubicTo(946.562988f, 1475.66199f, 945.312988f, 1478.18005f, 945.312988f, 1478.18005f);
    builderB.close();
    builderB.moveTo(945.382019f, 1474.328f);
    builderB.cubicTo(942.924011f, 1472.729f, 944.492004f, 1469.48706f, 944.492004f, 1469.48706f);
    builderB.cubicTo(947.388977f, 1471.95703f, 945.382019f, 1474.328f, 945.382019f, 1474.328f);
    builderB.close();
    builderB.moveTo(946.797974f, 1470.27405f);
    builderB.cubicTo(944.664978f, 1467.90198f, 947.083984f, 1465.50598f, 947.083984f, 1465.50598f);
    builderB.cubicTo(949.145996f, 1468.82605f, 946.797974f, 1470.27405f, 946.797974f, 1470.27405f);
    builderB.close();
    builderB.moveTo(947.392029f, 1471.64197f);
    builderB.cubicTo(947.624023f, 1468.56299f, 951.361023f, 1468.29199f, 951.361023f, 1468.29199f);
    builderB.cubicTo(950.554016f, 1471.98499f, 947.392029f, 1471.64197f, 947.392029f, 1471.64197f);
    builderB.close();
    builderB.moveTo(948.64801f, 1468.15002f);
    builderB.cubicTo(948.638977f, 1465.22095f, 952.265991f, 1464.46399f, 952.265991f, 1464.46399f);
    builderB.cubicTo(951.672974f, 1468.53101f, 948.64801f, 1468.15002f, 948.64801f, 1468.15002f);
    builderB.close();
    builderB.moveTo(951.176025f, 1486.97803f);
    builderB.cubicTo(948.963013f, 1484.62f, 951.361023f, 1481.77698f, 951.361023f, 1481.77698f);
    builderB.cubicTo(953.734985f, 1485.48596f, 951.176025f, 1486.97803f, 951.176025f, 1486.97803f);
    builderB.close();
    builderB.moveTo(947.51001f, 1488.53101f);
    builderB.cubicTo(947.51001f, 1488.53101f, 951.596985f, 1486.32202f, 953.234009f, 1489.08997f);
    builderB.cubicTo(953.234009f, 1489.08997f, 951.158997f, 1491.03601f, 947.51001f, 1488.53101f);
    builderB.close();
    builderB.moveTo(955.120972f, 1488.94495f);
    builderB.cubicTo(952.309021f, 1487.98303f, 953.458984f, 1483.93604f, 953.458984f, 1483.93604f);
    builderB.cubicTo(957.004028f, 1486.37097f, 955.120972f, 1488.94495f, 955.120972f, 1488.94495f);
    builderB.close();
    builderB.moveTo(978.770996f, 1488.53101f);
    builderB.cubicTo(975.122986f, 1491.03601f, 973.047974f, 1489.08997f, 973.047974f, 1489.08997f);
    builderB.cubicTo(974.684998f, 1486.32202f, 978.770996f, 1488.53101f, 978.770996f, 1488.53101f);
    builderB.close();
    builderB.moveTo(975.106995f, 1486.97803f);
    builderB.cubicTo(975.106995f, 1486.97803f, 972.546997f, 1485.48706f, 974.919983f, 1481.77698f);
    builderB.cubicTo(974.919983f, 1481.776f, 977.31897f, 1484.61902f, 975.106995f, 1486.97803f);
    builderB.close();
    builderB.moveTo(974.016968f, 1464.46399f);
    builderB.cubicTo(974.016968f, 1464.46399f, 977.643982f, 1465.22095f, 977.633972f, 1468.15002f);
    builderB.cubicTo(977.633972f, 1468.15002f, 974.611023f, 1468.53101f, 974.016968f, 1464.46399f);
    builderB.close();
    builderB.moveTo(974.919983f, 1468.29199f);
    builderB.cubicTo(974.919983f, 1468.29199f, 978.658997f, 1468.56299f, 978.890015f, 1471.64197f);
    builderB.cubicTo(978.890015f, 1471.64197f, 975.72699f, 1471.98499f, 974.919983f, 1468.29199f);
    builderB.close();
    builderB.moveTo(979.197998f, 1465.50598f);
    builderB.cubicTo(979.197998f, 1465.50598f, 981.619019f, 1467.90198f, 979.481995f, 1470.27405f);
    builderB.cubicTo(979.481995f, 1470.27405f, 977.138f, 1468.82605f, 979.197998f, 1465.50598f);
    builderB.close();
    builderB.moveTo(980.900024f, 1474.328f);
    builderB.cubicTo(980.900024f, 1474.328f, 978.893005f, 1471.95703f, 981.791016f, 1469.48706f);
    builderB.cubicTo(981.791016f, 1469.48596f, 983.358032f, 1472.729f, 980.900024f, 1474.328f);
    builderB.close();
    builderB.moveTo(980.968994f, 1478.18005f);
    builderB.cubicTo(980.968994f, 1478.18005f, 979.718018f, 1475.66199f, 983.632019f, 1473.87805f);
    builderB.cubicTo(983.632019f, 1473.87805f, 984.229004f, 1477.80103f, 980.968994f, 1478.18005f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_narayana_publishers_com_194(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1083.34314f, 445.65686f);
    builder.quadTo(1081, 443.313721f, 1081, 440);
    builder.lineTo(1257, 440);
    builder.quadTo(1257, 443.313721f, 1254.65686f, 445.65686f);
    builder.quadTo(1252.31372f, 448, 1249, 448);
    builder.lineTo(1089, 448);
    builder.quadTo(1085.68628f, 448, 1083.34314f, 445.65686f);
    builder.close();
    builder.moveTo(1083, 441);
    builder.lineTo(1255, 441);
    builder.quadTo(1255, 443.071075f, 1253.53552f, 444.535522f);
    builder.quadTo(1252.07104f, 446, 1250, 446);
    builder.lineTo(1088, 446);
    builder.quadTo(1085.92896f, 446, 1084.46448f, 444.535522f);
    builder.quadTo(1083, 443.071075f, 1083, 441);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1081, 440);
    builderB.lineTo(1082, 440);
    builderB.lineTo(1090.01001f, 448);
    builderB.lineTo(1081, 448);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_cooksnaps_com_17(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(170.340179f, 176);
    builder.lineTo(166, 176);
    builder.quadTo(161.964188f, 176, 158.299957f, 176.896912f);
    builder.quadTo(154.678162f, 177.952271f, 151.183014f, 179.9702f);
    builder.lineTo(150.316986f, 180.4702f);
    builder.quadTo(146.175812f, 182.861099f, 143.115921f, 186.081696f);
    builder.quadTo(140.693939f, 188.70134f, 138.99472f, 191.620407f);
    builder.quadTo(137.316833f, 194.550888f, 136.259338f, 197.957367f);
    builder.quadTo(135, 202.217865f, 135, 207);
    builder.lineTo(135, 208);
    builder.quadTo(135, 212.035751f, 135.896912f, 215.699997f);
    builder.quadTo(136.952286f, 219.321869f, 138.9702f, 222.816986f);
    builder.lineTo(139.4702f, 223.683014f);
    builder.quadTo(141.861099f, 227.824188f, 145.081696f, 230.884079f);
    builder.quadTo(147.70134f, 233.306061f, 150.620407f, 235.00528f);
    builder.quadTo(153.550888f, 236.683167f, 156.957367f, 237.740662f);
    builder.quadTo(161.217865f, 239, 166, 239);
    builder.lineTo(170.482162f, 239);
    builder.quadTo(176.307037f, 238.210968f, 181.816986f, 235.0298f);
    builder.lineTo(182.683014f, 234.5298f);
    builder.quadTo(182.686462f, 234.527817f, 182.689896f, 234.525818f);
    builder.quadTo(193.804352f, 228.105652f, 197.126709f, 215.70639f);
    builder.quadTo(200.450104f, 203.303314f, 194.0298f, 192.183014f);
    builder.lineTo(193.5298f, 191.316986f);
    builder.quadTo(187.109497f, 180.196686f, 174.706406f, 176.873276f);
    builder.quadTo(172.503067f, 176.282898f, 170.340179f, 176);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(139.4702f, 223.683014f);
    builderB.lineTo(138.9702f, 222.816986f);
    builderB.quadTo(132.549896f, 211.696686f, 135.873291f, 199.293594f);
    builderB.quadTo(139.196686f, 186.890503f, 150.316986f, 180.4702f);
    builderB.lineTo(151.183014f, 179.9702f);
    builderB.quadTo(162.303314f, 173.549896f, 174.706406f, 176.873276f);
    builderB.quadTo(187.109497f, 180.196686f, 193.5298f, 191.316986f);
    builderB.lineTo(194.0298f, 192.183014f);
    builderB.quadTo(200.450104f, 203.303314f, 197.126709f, 215.70639f);
    builderB.quadTo(193.803314f, 228.109497f, 182.683014f, 234.5298f);
    builderB.lineTo(181.816986f, 235.0298f);
    builderB.quadTo(170.696686f, 241.450104f, 158.293594f, 238.126709f);
    builderB.quadTo(145.890503f, 234.803314f, 139.4702f, 223.683014f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_swapspacesystems_com_5(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(819.050781f, 5539.72412f);
    builder.quadTo(819.651672f, 5539.1543f, 820.479858f, 5539.17578f);
    builder.lineTo(1191.35278f, 5548.8877f);
    builder.quadTo(1192.18091f, 5548.90918f, 1192.7511f, 5549.50977f);
    builder.quadTo(1193.32141f, 5550.11133f, 1193.29968f, 5550.93945f);
    builder.lineTo(1186.57214f, 5807.85107f);
    builder.quadTo(1186.55054f, 5808.6792f, 1185.94958f, 5809.24951f);
    builder.quadTo(1185.34863f, 5809.81982f, 1184.52051f, 5809.79834f);
    builder.lineTo(813.647705f, 5800.08643f);
    builder.quadTo(812.819519f, 5800.06494f, 812.249268f, 5799.46387f);
    builder.quadTo(811.679016f, 5798.86279f, 811.700684f, 5798.03467f);
    builder.lineTo(818.428162f, 5541.12305f);
    builder.quadTo(818.44989f, 5540.29492f, 819.050781f, 5539.72412f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(818.48053f, 5539.12354f);
    builderB.lineTo(1193.35205f, 5548.93994f);
    builderB.lineTo(1186.5199f, 5809.85059f);
    builderB.lineTo(811.648376f, 5800.03418f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_kitcheninspirations_wordpress_com_66(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(47.1666679f, 27820.668f);
    builder.lineTo(60.8333359f, 27820.668f);
    builder.lineTo(60.8333359f, 27820.498f);
    builder.lineTo(47.1666679f, 27820.5f);
    builder.lineTo(47.1666679f, 27820.668f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(47.1666679f, 27820.668f);
    builderB.lineTo(47.1666679f, 27820.498f);
    builderB.lineTo(60.8333359f, 27820.5f);
    builderB.lineTo(60.8333359f, 27820.668f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_etiqadd_com_2464(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(630.378662f, 1293.42896f);
    builder.quadTo(631.257385f, 1292.55029f, 632.5f, 1292.55029f);
    builder.quadTo(633.742615f, 1292.55029f, 634.621338f, 1293.42896f);
    builder.lineTo(639.571045f, 1298.37866f);
    builder.quadTo(640.449768f, 1299.25732f, 640.449707f, 1300.5f);
    builder.quadTo(640.449768f, 1301.74268f, 639.571045f, 1302.62134f);
    builder.lineTo(634.621338f, 1307.57104f);
    builder.quadTo(633.742615f, 1308.44971f, 632.5f, 1308.44971f);
    builder.quadTo(631.257385f, 1308.44971f, 630.378662f, 1307.57104f);
    builder.lineTo(625.428955f, 1302.62134f);
    builder.quadTo(624.550232f, 1301.74268f, 624.550293f, 1300.5f);
    builder.quadTo(624.550232f, 1299.25732f, 625.428955f, 1298.37866f);
    builder.lineTo(630.378662f, 1293.42896f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(632.5f, 1291.30762f);
    builderB.lineTo(641.692383f, 1300.5f);
    builderB.lineTo(632.5f, 1309.69238f);
    builderB.lineTo(623.307617f, 1300.5f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_narayana_verlag_de_194(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1083.34314f, 513.65686f);
    builder.quadTo(1081, 511.313721f, 1081, 508);
    builder.lineTo(1257, 508);
    builder.quadTo(1257, 511.313721f, 1254.65686f, 513.65686f);
    builder.quadTo(1252.31372f, 516, 1249, 516);
    builder.lineTo(1089, 516);
    builder.quadTo(1085.68628f, 516, 1083.34314f, 513.65686f);
    builder.close();
    builder.moveTo(1083, 509);
    builder.lineTo(1255, 509);
    builder.quadTo(1255, 511.071075f, 1253.53552f, 512.535522f);
    builder.quadTo(1252.07104f, 514, 1250, 514);
    builder.lineTo(1088, 514);
    builder.quadTo(1085.92896f, 514, 1084.46448f, 512.535522f);
    builder.quadTo(1083, 511.071075f, 1083, 509);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(1081, 508);
    builderB.lineTo(1082, 508);
    builderB.lineTo(1090.01001f, 516);
    builderB.lineTo(1081, 516);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_americascup_com_108(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(999.454102f, 689.17157f);
    builder.quadTo(1001.172f, 688, 1002.82886f, 688);
    builder.lineTo(1013.82886f, 688);
    builder.lineTo(1002.17114f, 713);
    builder.lineTo(991.171143f, 713);
    builder.quadTo(989.514282f, 713, 988.889038f, 711.82843f);
    builder.quadTo(988.263794f, 710.65686f, 989.036377f, 709);
    builder.lineTo(996.963623f, 692);
    builder.quadTo(997.736206f, 690.34314f, 999.454102f, 689.17157f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(998.828857f, 688);
    builderB.lineTo(1013.82886f, 688);
    builderB.lineTo(1002.17114f, 713);
    builderB.lineTo(987.171143f, 713);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_vantageproduction_com_109(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(794.514709f, 759.485291f);
    builder.quadTo(791, 755.970581f, 791, 751);
    builder.lineTo(1133, 751);
    builder.quadTo(1133, 755.970581f, 1129.48523f, 759.485291f);
    builder.quadTo(1125.97058f, 763, 1121, 763);
    builder.lineTo(803, 763);
    builder.quadTo(798.029419f, 763, 794.514709f, 759.485291f);
    builder.close();
    builder.moveTo(793, 752);
    builder.lineTo(1131, 752);
    builder.quadTo(1131, 755.727905f, 1128.36401f, 758.363953f);
    builder.quadTo(1125.72791f, 761, 1122, 761);
    builder.lineTo(802, 761);
    builder.quadTo(798.272095f, 761, 795.636047f, 758.363953f);
    builder.quadTo(793, 755.727905f, 793, 752);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(791, 751);
    builderB.lineTo(792, 751);
    builderB.lineTo(804.01001f, 763);
    builderB.lineTo(791, 763);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_aceinfographics_com_106(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(166.878677f, 7638.87891f);
    builder.quadTo(166, 7639.75732f, 166, 7641);
    builder.lineTo(166, 11577);
    builder.quadTo(166, 11578.2422f, 166.878677f, 11579.1211f);
    builder.quadTo(167.388f, 11579.6309f, 168.019989f, 11579.8447f);
    builder.lineTo(168.019974f, 11576.2979f);
    builder.quadTo(168, 11576.1533f, 168, 11576);
    builder.lineTo(168, 7642);
    builder.lineTo(168.000015f, 7641.99316f);
    builder.lineTo(168, 7640);
    builder.lineTo(166.878677f, 7638.87891f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(166, 7638);
    builderB.lineTo(168.020004f, 7635.97998f);
    builderB.lineTo(168, 11578);
    builderB.lineTo(166, 11580);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_tcmevents_org_13(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(465.951904f, 547.960144f);
    builder.quadTo(465.66571f, 546.867371f, 465.404938f, 546);
    builder.lineTo(465.504089f, 546);
    builder.quadTo(465.670349f, 546.601257f, 465.84668f, 547.288391f);
    builder.quadTo(467.274506f, 552.852356f, 468.506836f, 560.718567f);
    builder.quadTo(467.336121f, 553.24585f, 465.951904f, 547.960144f);
    builder.close();
    builder.moveTo(470.591064f, 574.024353f);
    builder.quadTo(474.844055f, 601.176025f, 471.728271f, 620.364502f);
    builder.quadTo(470.567017f, 627.515991f, 468.635742f, 632);
    builder.lineTo(469.106812f, 632);
    builder.quadTo(470.791504f, 627.638672f, 471.833496f, 621.036255f);
    builder.quadTo(474.905701f, 601.569519f, 470.591064f, 574.024353f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(322.992462f, 541.475708f);
    builderB.lineTo(465.531616f, 541.724426f);
    builderB.lineTo(468.507751f, 560.724426f);
    builderB.lineTo(325.968597f, 560.475708f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_paseoitaigara_com_br_56(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(633.147217f, 1247);
    builder.lineTo(718, 1162.14722f);
    builder.lineTo(802.852783f, 1247);
    builder.lineTo(718, 1331.85278f);
    builder.lineTo(633.147217f, 1247);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(635.268494f, 1244.87866f);
    builderB.lineTo(715.878662f, 1164.26855f);
    builderB.quadTo(716.757385f, 1163.38989f, 718, 1163.38989f);
    builderB.quadTo(719.242615f, 1163.38989f, 720.121338f, 1164.26855f);
    builderB.lineTo(800.731506f, 1244.87866f);
    builderB.quadTo(801.610168f, 1245.75732f, 801.610168f, 1247);
    builderB.quadTo(801.610229f, 1248.24268f, 800.731445f, 1249.12134f);
    builderB.lineTo(720.121338f, 1329.73145f);
    builderB.quadTo(719.242676f, 1330.61011f, 718, 1330.61011f);
    builderB.quadTo(716.757385f, 1330.61011f, 715.878723f, 1329.73145f);
    builderB.lineTo(635.268555f, 1249.12134f);
    builderB.quadTo(634.389832f, 1248.24268f, 634.389832f, 1247);
    builderB.quadTo(634.389832f, 1245.75732f, 635.268494f, 1244.87866f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_mortgagemarketguide_com_109(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(816.514709f, 781.485291f);
    builder.quadTo(813, 777.970581f, 813, 773);
    builder.lineTo(1133, 773);
    builder.quadTo(1133, 777.970581f, 1129.48523f, 781.485291f);
    builder.quadTo(1125.97058f, 785, 1121, 785);
    builder.lineTo(825, 785);
    builder.quadTo(820.029419f, 785, 816.514709f, 781.485291f);
    builder.close();
    builder.moveTo(815, 774);
    builder.lineTo(1131, 774);
    builder.quadTo(1131, 777.727905f, 1128.36401f, 780.363953f);
    builder.quadTo(1125.72791f, 783, 1122, 783);
    builder.lineTo(824, 783);
    builder.quadTo(820.272095f, 783, 817.636047f, 780.363953f);
    builder.quadTo(815, 777.727905f, 815, 774);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(813, 773);
    builderB.lineTo(814, 773);
    builderB.lineTo(826.01001f, 785);
    builderB.lineTo(813, 785);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_9to5mac_com_64(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(365, 5101);
    builder.lineTo(365, 5082);
    builder.lineTo(366, 5083);
    builder.lineTo(367, 5092.96631f);
    builder.lineTo(367, 5100);
    builder.quadTo(367, 5101.50537f, 367.967712f, 5102.61084f);
    builder.lineTo(368.278717f, 5105.71045f);
    builder.quadTo(367.277618f, 5105.34863f, 366.464478f, 5104.53564f);
    builder.quadTo(365, 5103.07129f, 365, 5101);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(365, 5082);
    builderB.lineTo(365.848175f, 5081.15186f);
    builderB.lineTo(368, 5103);
    builderB.lineTo(365, 5106);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_googleventures_com_32(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(725.911682f, 898.767456f);
    builder.lineTo(741.232544f, 885.911682f);
    builder.lineTo(754.088318f, 901.232544f);
    builder.lineTo(738.767456f, 914.088318f);
    builder.lineTo(725.911682f, 898.767456f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(728.37677f, 870.59082f);
    builderB.lineTo(754.088257f, 901.232605f);
    builderB.lineTo(738.767395f, 914.088379f);
    builderB.lineTo(713.055908f, 883.446594f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_devbridge_com_22(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(4915, 1523);
    builder.quadTo(4887.24756f, 1523, 4867.62402f, 1542.6239f);
    builder.quadTo(4848, 1562.24768f, 4848, 1590);
    builder.quadTo(4848, 1617.75232f, 4867.62402f, 1637.3761f);
    builder.quadTo(4887.24756f, 1657, 4915, 1657);
    builder.quadTo(4942.75244f, 1657, 4962.37598f, 1637.3761f);
    builder.quadTo(4982, 1617.75232f, 4982, 1590);
    builder.quadTo(4982, 1562.24768f, 4962.37598f, 1542.6239f);
    builder.quadTo(4942.75244f, 1523, 4915, 1523);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(4981.99902f, 1590);
    builderB.quadTo(4981.99902f, 1617.75232f, 4962.375f, 1637.3761f);
    builderB.quadTo(4942.75146f, 1657, 4914.99902f, 1657);
    builderB.quadTo(4887.24658f, 1657, 4867.62305f, 1637.3761f);
    builderB.quadTo(4847.99902f, 1617.75232f, 4847.99902f, 1590);
    builderB.quadTo(4847.99902f, 1562.24768f, 4867.62305f, 1542.6239f);
    builderB.quadTo(4887.24658f, 1523, 4914.99902f, 1523);
    builderB.quadTo(4942.75146f, 1523, 4962.375f, 1542.6239f);
    builderB.quadTo(4981.99902f, 1562.24768f, 4981.99902f, 1590);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_alamdi_com_3(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(10210.8789f, 5315.87891f);
    builder.quadTo(10211.7578f, 5315, 10213, 5315);
    builder.lineTo(10230, 5315);
    builder.quadTo(10231.2422f, 5315, 10232.1211f, 5315.87891f);
    builder.quadTo(10233, 5316.75732f, 10233, 5318);
    builder.lineTo(10233, 5338);
    builder.quadTo(10233, 5339.24268f, 10232.1211f, 5340.12109f);
    builder.quadTo(10231.2422f, 5341, 10230, 5341);
    builder.lineTo(10213, 5341);
    builder.quadTo(10211.7578f, 5341, 10210.8789f, 5340.12109f);
    builder.quadTo(10210, 5339.24268f, 10210, 5338);
    builder.lineTo(10210, 5318);
    builder.quadTo(10210, 5316.75732f, 10210.8789f, 5315.87891f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kEvenOdd);
    builderB.moveTo(10213, 5315);
    builderB.lineTo(10230, 5315);
    builderB.cubicTo(10231.6572f, 5315, 10233, 5316.34326f, 10233, 5318);
    builderB.lineTo(10233, 5338);
    builderB.cubicTo(10233, 5339.10449f, 10231.6572f, 5340, 10230, 5340);
    builderB.lineTo(10213, 5340);
    builderB.cubicTo(10211.3428f, 5340, 10210, 5339.10449f, 10210, 5338);
    builderB.lineTo(10210, 5318);
    builderB.cubicTo(10210, 5316.34326f, 10211.3428f, 5315, 10213, 5315);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_familysurvivalprotocol_wordpress_com_61(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(143, 14557);
    builder.lineTo(165, 14557);
    builder.lineTo(165, 14555.9902f);
    builder.lineTo(143, 14556);
    builder.lineTo(143, 14557);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(143, 14557);
    builderB.lineTo(143, 14555.9902f);
    builderB.lineTo(165, 14556);
    builderB.lineTo(165, 14557);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_firstunitedbank_com_19(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(808.585815f, 11673.5859f);
    builder.quadTo(809.17157f, 11673, 810, 11673);
    builder.lineTo(1032, 11673);
    builder.quadTo(1038.21326f, 11673, 1042.60657f, 11677.3936f);
    builder.quadTo(1047, 11681.7871f, 1047, 11688);
    builder.quadTo(1047, 11682.2012f, 1042.60657f, 11678.1006f);
    builder.quadTo(1038.21326f, 11674, 1032, 11674);
    builder.lineTo(810, 11674);
    builder.quadTo(809.585815f, 11674, 809.292908f, 11674.293f);
    builder.quadTo(809, 11674.5859f, 809, 11675);
    builder.lineTo(809, 11701);
    builder.quadTo(809, 11701.4141f, 809.292908f, 11701.707f);
    builder.quadTo(809.585815f, 11702, 810, 11702);
    builder.lineTo(1032, 11702);
    builder.quadTo(1038.21326f, 11702, 1042.60657f, 11697.8994f);
    builder.quadTo(1047, 11693.7988f, 1047, 11688);
    builder.quadTo(1047, 11694.2129f, 1042.60657f, 11698.6064f);
    builder.quadTo(1038.21326f, 11703, 1032, 11703);
    builder.lineTo(810, 11703);
    builder.quadTo(809.17157f, 11703, 808.585815f, 11702.4141f);
    builder.quadTo(808, 11701.8281f, 808, 11701);
    builder.lineTo(808, 11675);
    builder.quadTo(808, 11674.1719f, 808.585815f, 11673.5859f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(808, 11703);
    builderB.lineTo(809.5f, 11701.5f);
    builderB.lineTo(1062.91907f, 11687.0811f);
    builderB.lineTo(1047, 11703);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_shinydemos_com_5(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(205.884888f, 648.203857f);
    builder.lineTo(771.570374f, 82.5183716f);
    builder.lineTo(1110.98169f, 421.929626f);
    builder.lineTo(545.296143f, 987.615112f);
    builder.lineTo(205.884888f, 648.203857f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(771.570374f, 82.5183716f);
    builderB.lineTo(1110.98169f, 421.929626f);
    builderB.lineTo(545.296204f, 987.615051f);
    builderB.lineTo(205.884949f, 648.203796f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_lptemp_com_3(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(78.6429825f, 1394.30969f);
    builder.quadTo(79.6192932f, 1393.33337f, 81.0000076f, 1393.33337f);
    builder.lineTo(341, 1393.33337f);
    builder.quadTo(342.380707f, 1393.33337f, 343.357025f, 1394.30969f);
    builder.quadTo(344.333344f, 1395.28601f, 344.333344f, 1396.66675f);
    builder.lineTo(344.333344f, 1465.66663f);
    builder.quadTo(344.333344f, 1467.04736f, 343.357025f, 1468.02368f);
    builder.quadTo(342.380707f, 1469, 341, 1469);
    builder.lineTo(81.0000076f, 1469);
    builder.quadTo(79.6192932f, 1469, 78.6429825f, 1468.02368f);
    builder.quadTo(77.6666718f, 1467.04736f, 77.6666718f, 1465.66663f);
    builder.lineTo(77.6666718f, 1396.66675f);
    builder.quadTo(77.6666718f, 1395.28601f, 78.6429825f, 1394.30969f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kEvenOdd);
    builderB.moveTo(81, 1393.33337f);
    builderB.lineTo(341, 1393.33337f);
    builderB.cubicTo(342.840942f, 1393.33337f, 344.333344f, 1394.82568f, 344.333344f, 1396.66675f);
    builderB.lineTo(344.333344f, 1465.66675f);
    builderB.cubicTo(344.333344f, 1467.32361f, 342.840942f, 1468.66675f, 341, 1468.66675f);
    builderB.lineTo(81, 1468.66675f);
    builderB.cubicTo(79.15905f, 1468.66675f, 77.6666718f, 1467.32361f, 77.6666718f, 1465.66675f);
    builderB.lineTo(77.6666718f, 1396.66675f);
    builderB.cubicTo(77.6666718f, 1394.82568f, 79.15905f, 1393.33337f, 81, 1393.33337f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_shinydemos_com_15(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 310.947968f);
    builder.lineTo(771.570374f, 82.5183716f);
    builder.lineTo(205.884888f, 648.203857f);
    builder.lineTo(448.68103f, 891);
    builder.lineTo(641.911255f, 891);
    builder.lineTo(1000, 532.911316f);
    builder.lineTo(1000, 310.947968f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);
    builderB.moveTo(771.570374f, 82.5183716f);
    builderB.lineTo(1110.98169f, 421.929626f);
    builderB.lineTo(545.296204f, 987.615051f);
    builderB.lineTo(205.884949f, 648.203796f);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_lptemp_com_5(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(78.6429825f, 3150.97632f);
    builder.quadTo(79.6192932f, 3150, 81.0000076f, 3150);
    builder.lineTo(341, 3150);
    builder.quadTo(342.380707f, 3150, 343.357025f, 3150.97632f);
    builder.quadTo(344.333344f, 3151.95264f, 344.333344f, 3153.33325f);
    builder.lineTo(344.333344f, 5205.3335f);
    builder.quadTo(344.333344f, 5206.71436f, 343.357025f, 5207.69092f);
    builder.quadTo(342.380707f, 5208.66699f, 341, 5208.66699f);
    builder.lineTo(81.0000076f, 5208.66699f);
    builder.quadTo(79.6192932f, 5208.66699f, 78.6429825f, 5207.69092f);
    builder.quadTo(77.6666718f, 5206.71436f, 77.6666718f, 5205.3335f);
    builder.lineTo(77.6666718f, 3153.33325f);
    builder.quadTo(77.6666718f, 3151.95264f, 78.6429825f, 3150.97632f);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kEvenOdd);
    builderB.moveTo(81, 3150);
    builderB.lineTo(341, 3150);
    builderB.cubicTo(342.840942f, 3150, 344.333344f, 3151.49268f, 344.333344f, 3153.3335f);
    builderB.lineTo(344.333344f, 5205.3335f);
    builderB.cubicTo(344.333344f, 5206.99023f, 342.840942f, 5208.3335f, 341, 5208.3335f);
    builderB.lineTo(81, 5208.3335f);
    builderB.cubicTo(79.15905f, 5208.3335f, 77.6666718f, 5206.99023f, 77.6666718f, 5205.3335f);
    builderB.lineTo(77.6666718f, 3153.3335f);
    builderB.cubicTo(77.6666718f, 3151.49268f, 79.15905f, 3150, 81, 3150);
    builderB.close();
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);
}

static void skpwww_educationalcraft_com_4a(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(941, 1494);
    builder.lineTo(941, 1464);
    builder.lineTo(985, 1464);
    builder.lineTo(985, 1494);
    builder.lineTo(941, 1494);
    builder.close();
    SkPathBuilder builderB;
    builderB.setFillType(SkPathFillType::kWinding);

    builderB.moveTo(984.546021f, 1478.31494f);
    builderB.cubicTo(984.546021f, 1478.31494f, 984.543213f, 1478.32239f, 984.537598f, 1478.33655f);
    builderB.cubicTo(984.419006f, 1478.63477f, 983.044373f, 1481.90405f, 980.026001f, 1481.276f);
    builderB.cubicTo(980.026001f, 1481.276f, 980.02594f, 1481.27576f, 980.025879f, 1481.27527f);
    builderB.cubicTo(980.018494f, 1481.22131f, 979.602478f, 1478.38831f, 984.546021f, 1478.31494f);
    testPathOp(reporter, builder.detach(), builderB.detach(), kIntersect_SkPathOp, filename);

}

static void skpwww_woothemes_com_1(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType((SkPathFillType) 1);
    builder.moveTo(SkBits2Float(0x44472795), SkBits2Float(0x455cdb8d));  // 796.618f, 3533.72f
    builder.lineTo(SkBits2Float(0x44467c27), SkBits2Float(0x455cdb8d));  // 793.94f, 3533.72f
    builder.lineTo(SkBits2Float(0x44467c27), SkBits2Float(0x455d055d));  // 793.94f, 3536.34f
    builder.lineTo(SkBits2Float(0x44472795), SkBits2Float(0x455d055d));  // 796.618f, 3536.34f
    builder.lineTo(SkBits2Float(0x44472795), SkBits2Float(0x455cdb8d));  // 796.618f, 3533.72f
    SkPath path1(builder.detach());
    builder.setFillType((SkPathFillType) 0);
    builder.moveTo(SkBits2Float(0x4446861c), SkBits2Float(0x455cdb8d));  // 794.095f, 3533.72f
    builder.cubicTo(SkBits2Float(0x4446a0d8), SkBits2Float(0x455cefbb), SkBits2Float(0x444727a5), SkBits2Float(0x455d055d), SkBits2Float(0x444727a5), SkBits2Float(0x455d055d));  // 794.513f, 3534.98f, 796.619f, 3536.34f, 796.619f, 3536.34f
    builder.cubicTo(SkBits2Float(0x4446c5b0), SkBits2Float(0x455cf8a4), SkBits2Float(0x444693af), SkBits2Float(0x455cedad), SkBits2Float(0x44467c1b), SkBits2Float(0x455ce4b8));  // 795.089f, 3535.54f, 794.308f, 3534.85f, 793.939f, 3534.29f
    builder.lineTo(SkBits2Float(0x44467d70), SkBits2Float(0x455ce016));  // 793.96f, 3534.01f
    builder.cubicTo(SkBits2Float(0x44467fa9), SkBits2Float(0x455cde82), SkBits2Float(0x444682b5), SkBits2Float(0x455cdd03), SkBits2Float(0x4446861c), SkBits2Float(0x455cdb8d));  // 793.995f, 3533.91f, 794.042f, 3533.81f, 794.095f, 3533.72f
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, (SkPathOp) 1, filename);
}

static void skpwww_gorcraft_ru_1(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType((SkPathFillType) 1);
    builder.moveTo(SkBits2Float(0x44924000), SkBits2Float(0x458e7800));  // 1170, 4559
    builder.conicTo(SkBits2Float(0x44930000), SkBits2Float(0x458e7800), SkBits2Float(0x44930000), SkBits2Float(0x458ea800), SkBits2Float(0x3f3504f3));  // 1176, 4559, 1176, 4565, 0.707107f
    builder.lineTo(SkBits2Float(0x44930000), SkBits2Float(0x458f7000));  // 1176, 4590
    builder.conicTo(SkBits2Float(0x44930000), SkBits2Float(0x458f9800), SkBits2Float(0x44926000), SkBits2Float(0x458f9800), SkBits2Float(0x3f3504f3));  // 1176, 4595, 1171, 4595, 0.707107f
    builder.lineTo(SkBits2Float(0x42a60000), SkBits2Float(0x458f9800));  // 83, 4595
    builder.conicTo(SkBits2Float(0x429c0471), SkBits2Float(0x458f9800), SkBits2Float(0x429c0000), SkBits2Float(0x458f700c), SkBits2Float(0x3f352d2d));  // 78.0087f, 4595, 78, 4590.01f, 0.707721f
    builder.lineTo(SkBits2Float(0x429c0000), SkBits2Float(0x458ea800));  // 78, 4565
    builder.conicTo(SkBits2Float(0x429c0000), SkBits2Float(0x458e7800), SkBits2Float(0x42a80000), SkBits2Float(0x458e7800), SkBits2Float(0x3f3504f3));  // 78, 4559, 84, 4559, 0.707107f
    builder.lineTo(SkBits2Float(0x44924000), SkBits2Float(0x458e7800));  // 1170, 4559
    builder.close();
    SkPath path1(builder.detach());
    builder.setFillType((SkPathFillType) 0);
    builder.moveTo(SkBits2Float(0x429c0000), SkBits2Float(0x458f7000));  // 78, 4590
    builder.lineTo(SkBits2Float(0x429c0000), SkBits2Float(0x458ea800));  // 78, 4565
    builder.conicTo(SkBits2Float(0x429c0000), SkBits2Float(0x458e7800), SkBits2Float(0x42a80000), SkBits2Float(0x458e7800), SkBits2Float(0x3f3504f3));  // 78, 4559, 84, 4559, 0.707107f
    builder.lineTo(SkBits2Float(0x431e0000), SkBits2Float(0x458e7800));  // 158, 4559
    builder.conicTo(SkBits2Float(0x431e0000), SkBits2Float(0x458e7800), SkBits2Float(0x431e0000), SkBits2Float(0x458e7800), SkBits2Float(0x3f3504f3));  // 158, 4559, 158, 4559, 0.707107f
    builder.lineTo(SkBits2Float(0x431e0000), SkBits2Float(0x458fa000));  // 158, 4596
    builder.conicTo(SkBits2Float(0x431e0000), SkBits2Float(0x458fa000), SkBits2Float(0x431e0000), SkBits2Float(0x458fa000), SkBits2Float(0x3f3504f3));  // 158, 4596, 158, 4596, 0.707107f
    builder.lineTo(SkBits2Float(0x42a80000), SkBits2Float(0x458fa000));  // 84, 4596
    builder.conicTo(SkBits2Float(0x429c0000), SkBits2Float(0x458fa000), SkBits2Float(0x429c0000), SkBits2Float(0x458f7000), SkBits2Float(0x3f3504f3));  // 78, 4596, 78, 4590, 0.707107f
    builder.close();

    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, (SkPathOp) 2, filename);
}

static void skpwww_neda_net_1(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType((SkPathFillType) 1);
    builder.moveTo(SkBits2Float(0x447a0000), SkBits2Float(0x00000000));  // 1000, 0
    builder.lineTo(SkBits2Float(0x00000000), SkBits2Float(0x00000000));  // 0, 0
    builder.lineTo(SkBits2Float(0x00000000), SkBits2Float(0x44b6e000));  // 0, 1463
    builder.lineTo(SkBits2Float(0x447a0000), SkBits2Float(0x44b6e000));  // 1000, 1463
    builder.lineTo(SkBits2Float(0x447a0000), SkBits2Float(0x00000000));  // 1000, 0
    builder.close();
    SkPath path1(builder.detach());
    builder.setFillType((SkPathFillType) 0);
    builder.moveTo(SkBits2Float(0x366a410f), SkBits2Float(0x43a38000));  // 3.49066e-06f, 327
    builder.lineTo(SkBits2Float(0x447a0000), SkBits2Float(0x43a38001));  // 1000, 327
    builder.lineTo(SkBits2Float(0x447a0000), SkBits2Float(0x4435c000));  // 1000, 727
    builder.lineTo(SkBits2Float(0xb66a410d), SkBits2Float(0x4435c000));  // -3.49066e-06f, 727
    builder.lineTo(SkBits2Float(0x366a410f), SkBits2Float(0x43a38000));  // 3.49066e-06f, 327
    builder.close();
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, (SkPathOp) 1, filename);
}

// "http___www_neda_net.skp" dir=87
static void skpwww_neda_net_2(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType((SkPathFillType) 1);
    builder.moveTo(SkBits2Float(0x442fc000), SkBits2Float(0x4546a000));  // 703, 3178
    builder.lineTo(SkBits2Float(0x441f4000), SkBits2Float(0x4546a000));  // 637, 3178
    builder.lineTo(SkBits2Float(0x441f4000), SkBits2Float(0x454ab000));  // 637, 3243
    builder.lineTo(SkBits2Float(0x442fc000), SkBits2Float(0x454ab000));  // 703, 3243
    builder.lineTo(SkBits2Float(0x442fc000), SkBits2Float(0x4546a000));  // 703, 3178
    builder.close();
    SkPath path1(builder.detach());
    builder.setFillType((SkPathFillType) 0);
    builder.moveTo(SkBits2Float(0x44220e6e), SkBits2Float(0x45469c4c));  // 648.225f, 3177.77f
    builder.lineTo(SkBits2Float(0x442fc01c), SkBits2Float(0x45475696));  // 703.002f, 3189.41f
    builder.lineTo(SkBits2Float(0x442cf191), SkBits2Float(0x454aa3b5));  // 691.774f, 3242.23f
    builder.lineTo(SkBits2Float(0x441f3fe3), SkBits2Float(0x4549e96b));  // 636.998f, 3230.59f
    builder.lineTo(SkBits2Float(0x44220e6e), SkBits2Float(0x45469c4c));  // 648.225f, 3177.77f
    builder.close();
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, (SkPathOp) 1, filename);
}

static void skpwww_mybuilder_com_1(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(1000, 659);
    builder.lineTo(1000, 377);
    builder.lineTo(455, 377);
    builder.lineTo(455, 659);
    builder.lineTo(1000, 659);
    builder.close();
    SkPath path1(builder.detach());
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(921.472f, 414.086f);
    builder.lineTo(968.815f, 386.754f);
    builder.lineTo(993.069f, 428.761f);
    builder.lineTo(945.726f, 456.096f);
    builder.lineTo(921.471f, 414.086f);
    builder.lineTo(921.472f, 414.086f);
    builder.close();
    builder.moveTo(971.151f, 422.889f);
    builder.cubicTo(966.509f, 414.848f, 957.649f, 411.727f, 950.181f, 416.038f);
    builder.lineTo(947.224f, 417.746f);
    builder.lineTo(946.979f, 417.887f);
    builder.lineTo(947.838f, 419.371f);
    builder.lineTo(947.844f, 419.367f);
    builder.lineTo(947.868f, 419.353f);
    builder.lineTo(947.945f, 419.309f);
    builder.cubicTo(947.988f, 419.285f, 947.988f, 419.285f, 948.023f, 419.263f);
    builder.cubicTo(948.039f, 419.255f, 948.039f, 419.255f, 948.047f, 419.25f);
    builder.lineTo(948.052f, 419.247f);
    builder.lineTo(947.196f, 417.762f);
    builder.lineTo(947.195f, 417.762f);
    builder.lineTo(946.888f, 417.939f);
    builder.lineTo(943.39f, 419.959f);
    builder.lineTo(944.249f, 421.443f);
    builder.lineTo(947.745f, 419.424f);
    builder.lineTo(948.05f, 419.247f);
    builder.lineTo(948.052f, 419.247f);
    builder.lineTo(947.195f, 417.763f);
    builder.cubicTo(947.193f, 417.763f, 947.193f, 417.763f, 947.19f, 417.766f);
    builder.lineTo(947.166f, 417.779f);
    builder.lineTo(947.087f, 417.825f);
    builder.lineTo(947.011f, 417.868f);
    builder.lineTo(946.987f, 417.883f);
    builder.lineTo(946.982f, 417.886f);
    builder.lineTo(946.98f, 417.886f);
    builder.lineTo(947.839f, 419.37f);
    builder.lineTo(948.083f, 419.229f);
    builder.lineTo(951.039f, 417.522f);
    builder.cubicTo(957.631f, 413.716f, 965.471f, 416.477f, 969.669f, 423.746f);
    builder.lineTo(971.153f, 422.889f);
    builder.lineTo(971.151f, 422.889f);
    builder.close();
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, kIntersect_SkPathOp, filename);
}

static void skpwww_nimble_com_au_1(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(188.6f, 1988.8f);
    builder.lineTo(188.6f, 2041.6f);
    builder.cubicTo(188.6f, 2065.4f, 208, 2084.8f, 231.8f, 2084.8f);
    builder.cubicTo(255.6f, 2084.8f, 275, 2065.4f, 275, 2041.6f);
    builder.lineTo(275.2f, 2041.6f);
    builder.lineTo(275.2f, 1988.8f);
    builder.lineTo(188.6f, 1988.8f);
    builder.close();
    SkPath path1(builder.detach());
    builder.setFillType(SkPathFillType::kWinding);
    builder.moveTo(275, 2041.6f);
    builder.conicTo(275, 2084.8f, 231.8f, 2084.8f, 0.707107f);
    builder.conicTo(188.6f, 2084.8f, 188.6f, 2041.6f, 0.707107f);
    builder.conicTo(188.6f, 1998.4f, 231.8f, 1998.4f, 0.707107f);
    builder.conicTo(275, 1998.4f, 275, 2041.6f, 0.707107f);
    builder.close();
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, kIntersect_SkPathOp, filename);
}

static void skpwww_tinytots_com_1(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(75.96f, 26.318f);
    builder.lineTo(70.337f, 26.318f);
    builder.lineTo(70.337f, 32.376f);
    builder.lineTo(75.96f, 32.376f);
    builder.lineTo(75.96f, 26.318f);
    builder.close();
    SkPath path1(builder.detach());
    builder.setFillType(SkPathFillType::kWinding);
    builder.moveTo(75.88f, 27.873f);
    builder.cubicTo(75.929f, 28.138f, 75.956f, 29.196f, 75.96f, 31.046f);
    builder.lineTo(72.766f, 32.376f);
    builder.cubicTo(72.763f, 30.525f, 72.735f, 29.468f, 72.686f, 29.203f);
    builder.cubicTo(72.636f, 28.94f, 72.519f, 28.722f, 72.335f, 28.552f);
    builder.cubicTo(72.248f, 28.472f, 72.058f, 28.364f, 71.763f, 28.228f);
    builder.cubicTo(72.425f, 27.933f, 72.425f, 27.933f, 73.395f, 27.498f);
    builder.cubicTo(72.425f, 27.933f, 72.425f, 27.933f, 71.763f, 28.228f);
    builder.cubicTo(71.425f, 28.072f, 70.95f, 27.878f, 70.337f, 27.647f);
    builder.lineTo(73.531f, 26.317f);
    builder.cubicTo(74.144f, 26.547f, 74.619f, 26.741f, 74.957f, 26.898f);
    builder.cubicTo(74.475f, 27.113f, 73.993f, 27.329f, 73.511f, 27.544f);
    builder.cubicTo(73.993f, 27.329f, 74.475f, 27.114f, 74.957f, 26.898f);
    builder.cubicTo(75.252f, 27.034f, 75.442f, 27.142f, 75.529f, 27.222f);
    builder.cubicTo(75.713f, 27.393f, 75.83f, 27.61f, 75.88f, 27.873f);
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, kIntersect_SkPathOp, filename);
}

static void http___www_emuleteca_cl_26(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType((SkPathFillType) 1);
    builder.moveTo(SkBits2Float(0x3f800000), SkBits2Float(0x44370000));  // 1, 732
    builder.conicTo(SkBits2Float(0x3f800000), SkBits2Float(0x4428c000), SkBits2Float(0x42680000), SkBits2Float(0x4428c000), SkBits2Float(0x3f3504f3));  // 1, 675, 58, 675, 0.707107f
    builder.conicTo(SkBits2Float(0x40400000), SkBits2Float(0x4428c000), SkBits2Float(0x40400000), SkBits2Float(0x44370000), SkBits2Float(0x3f3504f3));  // 3, 675, 3, 732, 0.707107f
    builder.conicTo(SkBits2Float(0x40400000), SkBits2Float(0x44444000), SkBits2Float(0x42680000), SkBits2Float(0x44444000), SkBits2Float(0x3f3504f3));  // 3, 785, 58, 785, 0.707107f
    builder.lineTo(SkBits2Float(0x446d0000), SkBits2Float(0x44444000));  // 948, 785
    builder.conicTo(SkBits2Float(0x447ac000), SkBits2Float(0x44444000), SkBits2Float(0x447ac000), SkBits2Float(0x44370000), SkBits2Float(0x3f3504f3));  // 1003, 785, 1003, 732, 0.707107f
    builder.conicTo(SkBits2Float(0x447ac000), SkBits2Float(0x4428c000), SkBits2Float(0x446d0000), SkBits2Float(0x4428c000), SkBits2Float(0x3f3504f3));  // 1003, 675, 948, 675, 0.707107f
    builder.conicTo(SkBits2Float(0x447b4000), SkBits2Float(0x4428c000), SkBits2Float(0x447b4000), SkBits2Float(0x44370000), SkBits2Float(0x3f3504f3));  // 1005, 675, 1005, 732, 0.707107f
    builder.conicTo(SkBits2Float(0x447b4000), SkBits2Float(0x44454000), SkBits2Float(0x446d0000), SkBits2Float(0x44454000), SkBits2Float(0x3f3504f3));  // 1005, 789, 948, 789, 0.707107f
    builder.lineTo(SkBits2Float(0x42680000), SkBits2Float(0x44454000));  // 58, 789
    builder.conicTo(SkBits2Float(0x3f800000), SkBits2Float(0x44454000), SkBits2Float(0x3f800000), SkBits2Float(0x44370000), SkBits2Float(0x3f3504f3));  // 1, 789, 1, 732, 0.707107f
    builder.close();

    SkPath path1(builder.detach());
    builder.setFillType((SkPathFillType) 0);
    builder.moveTo(SkBits2Float(0x3f800000), SkBits2Float(0x4428c000));  // 1, 675
    builder.lineTo(SkBits2Float(0x42680000), SkBits2Float(0x4428c000));  // 58, 675
    builder.lineTo(SkBits2Float(0x3fc8f676), SkBits2Float(0x44454000));  // 1.57002f, 789
    builder.lineTo(SkBits2Float(0x3f800000), SkBits2Float(0x44454000));  // 1, 789

    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, (SkPathOp) 1, filename);
}

static void http___www_emuleteca_cl_27(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType((SkPathFillType) 1);
    builder.moveTo(SkBits2Float(0x42680000), SkBits2Float(0x4428c000));  // 58, 675
    builder.conicTo(SkBits2Float(0x3f800000), SkBits2Float(0x4428c000), SkBits2Float(0x3f800000), SkBits2Float(0x44370000), SkBits2Float(0x3f3504f3));  // 1, 675, 1, 732, 0.707107f
    builder.conicTo(SkBits2Float(0x3f800000), SkBits2Float(0x443bd045), SkBits2Float(0x414acf56), SkBits2Float(0x443fa420), SkBits2Float(0x3f778612));  // 1, 751.254f, 12.6756f, 766.564f, 0.96689f
    builder.lineTo(SkBits2Float(0x41606e3d), SkBits2Float(0x443ef569));  // 14.0269f, 763.835f
    builder.conicTo(SkBits2Float(0x40400000), SkBits2Float(0x443b6c34), SkBits2Float(0x40400000), SkBits2Float(0x44370000), SkBits2Float(0x3f77ac46));  // 3, 749.691f, 3, 732, 0.967472f
    builder.conicTo(SkBits2Float(0x40400000), SkBits2Float(0x4428c000), SkBits2Float(0x42680000), SkBits2Float(0x4428c000), SkBits2Float(0x3f3504f3));  // 3, 675, 58, 675, 0.707107f
    builder.close();

    SkPath path1(builder.detach());
    builder.setFillType((SkPathFillType) 0);
    builder.moveTo(SkBits2Float(0x3f800000), SkBits2Float(0x4428c000));  // 1, 675
    builder.lineTo(SkBits2Float(0x4c4a3de6), SkBits2Float(0xccca3d89));  // 5.30165e+07f, -1.06032e+08f
    builder.lineTo(SkBits2Float(0x41a71147), SkBits2Float(0x443b4eec));  // 20.8834f, 749.233f
    builder.lineTo(SkBits2Float(0x3f800000), SkBits2Float(0x44454000));  // 1, 789

    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, (SkPathOp) 1, filename);
}

static void http___www_emuleteca_cl_28(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);

    SkPath path1(builder.detach());
    builder.setFillType(SkPathFillType::kWinding);
    builder.moveTo(SkBits2Float(0x3f800000), SkBits2Float(0x4428c000));  // 1, 675
    builder.lineTo(SkBits2Float(0x4c4a3de6), SkBits2Float(0xccca3d89));  // 5.30165e+07f, -1.06032e+08f
    builder.lineTo(SkBits2Float(0x41a71147), SkBits2Float(0x443b4eec));  // 20.8834f, 749.233f
    builder.lineTo(SkBits2Float(0x3f800000), SkBits2Float(0x44454000));  // 1, 789
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, kIntersect_SkPathOp, filename);
}

static void http___www_project2061_org(skiatest::Reporter* reporter, const char* filename) {
    SkPathBuilder builder;
    builder.setFillType(SkPathFillType::kEvenOdd);
    builder.moveTo(751, 62);
    builder.lineTo(497, 62);
    builder.lineTo(497, 138);
    builder.lineTo(751, 138);
    builder.lineTo(751, 62);
    builder.close();
    SkPath path1(builder.detach());
    builder.setFillType(SkPathFillType::kWinding);
    builder.moveTo(699.889f, 115.29f);
    builder.cubicTo(699.889f, 114.913f, 699.627f, 114.723f, 699.111f, 114.723f);
    builder.cubicTo(698.604f, 114.723f, 697.843f, 114.671f, 697.096f, 114.423f);
    builder.cubicTo(695.94f, 114.094f, 694.53f, 113.168f, 692.746f, 108.775f);
    builder.cubicTo(690.469f, 103.12f, 685.644f, 90.563f, 682.761f, 83.061f);
    builder.lineTo(680.541f, 77.301f);
    builder.cubicTo(679.927f, 75.721f, 679.67f, 75.261f, 679.151f, 75.261f);
    builder.cubicTo(678.636f, 75.261f, 678.392f, 75.73f, 677.759f, 77.464f);
    builder.lineTo(665.868f, 109.881f);
    builder.cubicTo(664.861f, 112.669f, 663.852f, 114.339f, 661.675f, 114.622f);
    builder.cubicTo(661.675f, 114.622f, 661.551f, 114.631f, 661.378f, 114.642f);
    builder.cubicTo(661.072f, 114.597f, 660.75f, 114.531f, 660.427f, 114.424f);
    builder.cubicTo(659.272f, 114.095f, 657.861f, 113.169f, 656.078f, 108.776f);
    builder.cubicTo(653.797f, 103.112f, 648.967f, 90.541f, 646.08f, 83.029f);
    builder.lineTo(643.873f, 77.302f);
    builder.cubicTo(643.259f, 75.722f, 643.002f, 75.262f, 642.484f, 75.262f);
    builder.cubicTo(641.968f, 75.262f, 641.724f, 75.731f, 641.092f, 77.465f);
    builder.lineTo(629.2f, 109.879f);
    builder.cubicTo(628.193f, 112.667f, 627.184f, 114.337f, 625.007f, 114.62f);
    builder.cubicTo(625.007f, 114.62f, 624.884f, 114.629f, 624.71f, 114.64f);
    builder.cubicTo(624.404f, 114.595f, 624.081f, 114.529f, 623.759f, 114.422f);
    builder.cubicTo(622.603f, 114.093f, 621.193f, 113.167f, 619.409f, 108.774f);
    builder.cubicTo(617.132f, 103.119f, 612.307f, 90.562f, 609.424f, 83.06f);
    builder.lineTo(607.204f, 77.3f);
    builder.cubicTo(606.59f, 75.72f, 606.333f, 75.26f, 605.815f, 75.26f);
    builder.cubicTo(605.3f, 75.26f, 605.055f, 75.729f, 604.423f, 77.463f);
    builder.lineTo(592.531f, 109.879f);
    builder.cubicTo(591.524f, 112.667f, 590.514f, 114.337f, 588.338f, 114.62f);
    builder.cubicTo(588.337f, 114.62f, 586.852f, 114.722f, 586.852f, 114.722f);
    builder.cubicTo(586.418f, 114.722f, 586.126f, 114.95f, 586.126f, 115.289f);
    builder.cubicTo(586.126f, 115.96f, 586.97f, 115.96f, 587.376f, 115.96f);
    builder.lineTo(592.101f, 115.843f);
    builder.lineTo(593.295f, 115.804f);
    builder.lineTo(594.624f, 115.86f);
    builder.lineTo(597.381f, 115.961f);
    builder.cubicTo(598.241f, 115.961f, 598.422f, 115.596f, 598.422f, 115.29f);
    builder.cubicTo(598.422f, 115.078f, 598.321f, 114.723f, 597.643f, 114.723f);
    builder.lineTo(597.119f, 114.723f);
    builder.cubicTo(596.448f, 114.723f, 595.383f, 114.381f, 595.383f, 113.463f);
    builder.cubicTo(595.383f, 112.545f, 595.638f, 111.334f, 596.101f, 110.052f);
    builder.cubicTo(596.103f, 110.048f, 599.246f, 100.809f, 599.246f, 100.809f);
    builder.cubicTo(599.337f, 100.583f, 599.435f, 100.564f, 599.528f, 100.564f);
    builder.lineTo(610.791f, 100.564f);
    builder.cubicTo(610.929f, 100.564f, 610.958f, 100.585f, 611.035f, 100.737f);
    builder.cubicTo(611.035f, 100.741f, 615.896f, 113.554f, 615.896f, 113.554f);
    builder.cubicTo(615.972f, 113.754f, 616.01f, 113.942f, 616.01f, 114.105f);
    builder.cubicTo(616.01f, 114.228f, 615.988f, 114.338f, 615.945f, 114.429f);
    builder.cubicTo(615.876f, 114.573f, 615.779f, 114.619f, 615.741f, 114.631f);
    builder.cubicTo(615.272f, 114.748f, 615.2f, 115.061f, 615.2f, 115.237f);
    builder.cubicTo(615.2f, 115.766f, 615.792f, 115.796f, 616.772f, 115.844f);
    builder.lineTo(617.012f, 115.857f);
    builder.cubicTo(618.978f, 115.913f, 621.359f, 115.948f, 623.835f, 115.958f);
    builder.cubicTo(623.912f, 115.961f, 623.984f, 115.961f, 624.045f, 115.961f);
    builder.lineTo(624.118f, 115.959f);
    builder.cubicTo(624.494f, 115.961f, 624.871f, 115.961f, 625.25f, 115.961f);
    builder.cubicTo(625.47f, 115.961f, 625.662f, 115.946f, 625.827f, 115.917f);
    builder.lineTo(628.77f, 115.844f);
    builder.lineTo(629.965f, 115.805f);
    builder.lineTo(631.293f, 115.861f);
    builder.lineTo(634.051f, 115.962f);
    builder.cubicTo(634.911f, 115.962f, 635.092f, 115.597f, 635.092f, 115.291f);
    builder.cubicTo(635.092f, 115.079f, 634.991f, 114.724f, 634.313f, 114.724f);
    builder.lineTo(633.789f, 114.724f);
    builder.cubicTo(633.118f, 114.724f, 632.053f, 114.382f, 632.053f, 113.464f);
    builder.cubicTo(632.053f, 112.546f, 632.308f, 111.335f, 632.771f, 110.053f);
    builder.cubicTo(632.773f, 110.049f, 635.916f, 100.81f, 635.916f, 100.81f);
    builder.cubicTo(636.007f, 100.584f, 636.105f, 100.565f, 636.198f, 100.565f);
    builder.lineTo(647.46f, 100.565f);
    builder.cubicTo(647.598f, 100.565f, 647.627f, 100.586f, 647.704f, 100.737f);
    builder.cubicTo(647.704f, 100.741f, 652.565f, 113.554f, 652.565f, 113.554f);
    builder.cubicTo(652.641f, 113.754f, 652.679f, 113.942f, 652.679f, 114.105f);
    builder.cubicTo(652.679f, 114.228f, 652.657f, 114.338f, 652.613f, 114.43f);
    builder.cubicTo(652.544f, 114.574f, 652.447f, 114.619f, 652.409f, 114.632f);
    builder.cubicTo(651.94f, 114.749f, 651.868f, 115.062f, 651.868f, 115.238f);
    builder.cubicTo(651.868f, 115.767f, 652.46f, 115.797f, 653.44f, 115.845f);
    builder.lineTo(653.681f, 115.858f);
    builder.cubicTo(655.647f, 115.914f, 658.028f, 115.949f, 660.503f, 115.959f);
    builder.cubicTo(660.58f, 115.962f, 660.652f, 115.962f, 660.713f, 115.962f);
    builder.lineTo(660.787f, 115.96f);
    builder.cubicTo(661.162f, 115.962f, 661.54f, 115.962f, 661.918f, 115.962f);
    builder.cubicTo(662.139f, 115.962f, 662.33f, 115.947f, 662.496f, 115.918f);
    builder.lineTo(665.439f, 115.845f);
    builder.lineTo(666.633f, 115.806f);
    builder.lineTo(667.962f, 115.862f);
    builder.lineTo(670.719f, 115.963f);
    builder.cubicTo(671.579f, 115.963f, 671.76f, 115.598f, 671.76f, 115.292f);
    builder.cubicTo(671.76f, 115.08f, 671.659f, 114.725f, 670.981f, 114.725f);
    builder.lineTo(670.457f, 114.725f);
    builder.cubicTo(669.786f, 114.725f, 668.721f, 114.383f, 668.721f, 113.465f);
    builder.cubicTo(668.721f, 112.547f, 668.976f, 111.336f, 669.439f, 110.054f);
    builder.cubicTo(669.441f, 110.05f, 672.584f, 100.811f, 672.584f, 100.811f);
    builder.cubicTo(672.675f, 100.585f, 672.773f, 100.566f, 672.866f, 100.566f);
    builder.lineTo(684.128f, 100.566f);
    builder.cubicTo(684.266f, 100.566f, 684.295f, 100.587f, 684.372f, 100.739f);
    builder.cubicTo(684.372f, 100.743f, 689.233f, 113.556f, 689.233f, 113.556f);
    builder.cubicTo(689.309f, 113.756f, 689.347f, 113.944f, 689.347f, 114.107f);
    builder.cubicTo(689.347f, 114.23f, 689.325f, 114.34f, 689.281f, 114.431f);
    builder.cubicTo(689.212f, 114.575f, 689.115f, 114.621f, 689.077f, 114.633f);
    builder.cubicTo(688.608f, 114.75f, 688.536f, 115.063f, 688.536f, 115.239f);
    builder.cubicTo(688.536f, 115.768f, 689.128f, 115.798f, 690.108f, 115.846f);
    builder.lineTo(690.348f, 115.859f);
    builder.cubicTo(692.687f, 115.926f, 695.611f, 115.963f, 698.586f, 115.963f);
    builder.cubicTo(699.451f, 115.961f, 699.889f, 115.735f, 699.889f, 115.29f);
    builder.close();
    builder.moveTo(600.18f, 98.176f);
    builder.cubicTo(600.181f, 98.171f, 600.185f, 98.158f, 600.185f, 98.158f);
    builder.cubicTo(600.191f, 98.142f, 604.801f, 84.049f, 604.801f, 84.049f);
    builder.cubicTo(604.865f, 83.857f, 604.915f, 83.756f, 604.951f, 83.697f);
    builder.cubicTo(604.987f, 83.756f, 605.037f, 83.858f, 605.102f, 84.051f);
    builder.cubicTo(605.103f, 84.054f, 610.08f, 98.149f, 610.08f, 98.149f);
    builder.cubicTo(610.079f, 98.145f, 610.079f, 98.145f, 610.079f, 98.147f);
    builder.cubicTo(610.079f, 98.149f, 610.081f, 98.164f, 610.083f, 98.176f);
    builder.lineTo(600.18f, 98.176f);
    builder.close();
    builder.moveTo(636.849f, 98.176f);
    builder.cubicTo(636.851f, 98.171f, 636.854f, 98.158f, 636.854f, 98.158f);
    builder.cubicTo(636.859f, 98.142f, 641.469f, 84.049f, 641.469f, 84.049f);
    builder.cubicTo(641.533f, 83.857f, 641.584f, 83.756f, 641.62f, 83.697f);
    builder.cubicTo(641.656f, 83.756f, 641.706f, 83.857f, 641.771f, 84.051f);
    builder.cubicTo(641.773f, 84.054f, 646.749f, 98.149f, 646.749f, 98.149f);
    builder.cubicTo(646.749f, 98.145f, 646.748f, 98.145f, 646.748f, 98.147f);
    builder.cubicTo(646.748f, 98.15f, 646.75f, 98.165f, 646.751f, 98.176f);
    builder.lineTo(636.849f, 98.176f);
    builder.close();
    builder.moveTo(673.517f, 98.176f);
    builder.cubicTo(673.519f, 98.171f, 673.522f, 98.158f, 673.522f, 98.158f);
    builder.cubicTo(673.528f, 98.142f, 678.138f, 84.049f, 678.138f, 84.049f);
    builder.cubicTo(678.202f, 83.857f, 678.252f, 83.756f, 678.288f, 83.697f);
    builder.cubicTo(678.324f, 83.756f, 678.375f, 83.858f, 678.439f, 84.051f);
    builder.cubicTo(678.44f, 84.054f, 683.417f, 98.149f, 683.417f, 98.149f);
    builder.cubicTo(683.416f, 98.145f, 683.416f, 98.145f, 683.416f, 98.147f);
    builder.cubicTo(683.416f, 98.149f, 683.418f, 98.164f, 683.42f, 98.176f);
    builder.lineTo(673.517f, 98.176f);
    builder.close();
    builder.moveTo(702.086f, 115.256f);
    builder.lineTo(702.089f, 115.257f);
    builder.cubicTo(704.075f, 116.223f, 706.408f, 116.692f, 709.22f, 116.692f);
    builder.cubicTo(712.384f, 116.692f, 715.17f, 115.918f, 717.275f, 114.454f);
    builder.cubicTo(720.639f, 112.074f, 721.837f, 108.31f, 721.837f, 105.581f);
    builder.cubicTo(721.837f, 101.538f, 720.57f, 98.203f, 714.092f, 93.115f);
    builder.lineTo(712.625f, 91.966f);
    builder.cubicTo(707.567f, 87.838f, 706.331f, 86.155f, 706.331f, 83.396f);
    builder.cubicTo(706.331f, 79.927f, 708.819f, 77.595f, 712.519f, 77.595f);
    builder.cubicTo(716.925f, 77.595f, 718.41f, 79.437f, 718.843f, 80.229f);
    builder.cubicTo(719.131f, 80.754f, 719.442f, 82.122f, 719.494f, 82.739f);
    builder.cubicTo(719.543f, 83.13f, 719.608f, 83.65f, 720.167f, 83.65f);
    builder.cubicTo(720.789f, 83.65f, 720.789f, 82.704f, 720.789f, 82.195f);
    builder.cubicTo(720.789f, 79.413f, 720.918f, 77.758f, 720.973f, 77.052f);
    builder.lineTo(720.998f, 76.662f);
    builder.cubicTo(720.998f, 76.113f, 720.581f, 76.043f, 720.219f, 76.043f);
    builder.cubicTo(719.847f, 76.043f, 719.469f, 76.003f, 718.438f, 75.788f);
    builder.cubicTo(716.936f, 75.428f, 715.369f, 75.26f, 713.514f, 75.26f);
    builder.cubicTo(706.771f, 75.26f, 702.415f, 79.048f, 702.415f, 84.91f);
    builder.cubicTo(702.415f, 88.438f, 703.589f, 91.748f, 709.319f, 96.434f);
    builder.lineTo(711.676f, 98.365f);
    builder.cubicTo(716.332f, 102.196f, 717.607f, 104.172f, 717.607f, 107.564f);
    builder.cubicTo(717.607f, 110.888f, 715.121f, 114.253f, 710.371f, 114.253f);
    builder.cubicTo(708.428f, 114.253f, 703.808f, 113.754f, 702.868f, 109.132f);
    builder.cubicTo(702.716f, 108.424f, 702.716f, 107.718f, 702.716f, 107.25f);
    builder.cubicTo(702.716f, 106.94f, 702.716f, 106.422f, 702.094f, 106.422f);
    builder.cubicTo(701.519f, 106.422f, 701.455f, 107.116f, 701.421f, 107.488f);
    builder.cubicTo(701.421f, 107.495f, 701.375f, 108.117f, 701.375f, 108.117f);
    builder.cubicTo(701.293f, 109.171f, 701.158f, 110.933f, 701.158f, 113.044f);
    builder.cubicTo(701.16f, 114.432f, 701.197f, 114.813f, 702.086f, 115.256f);
    builder.close();
    builder.moveTo(501.274f, 129.973f);
    builder.lineTo(498.058f, 136.963f);
    builder.lineTo(498.62f, 136.963f);
    builder.lineTo(499.723f, 134.561f);
    builder.lineTo(503.124f, 134.561f);
    builder.lineTo(504.227f, 136.963f);
    builder.lineTo(504.788f, 136.963f);
    builder.lineTo(501.571f, 129.973f);
    builder.lineTo(501.274f, 129.973f);
    builder.close();
    builder.moveTo(499.926f, 134.114f);
    builder.lineTo(501.417f, 130.848f);
    builder.lineTo(502.918f, 134.114f);
    builder.lineTo(499.926f, 134.114f);
    builder.close();
    builder.moveTo(510.117f, 130.023f);
    builder.lineTo(507.677f, 130.023f);
    builder.lineTo(507.677f, 136.963f);
    builder.lineTo(510.209f, 136.963f);
    builder.cubicTo(512.966f, 136.963f, 513.916f, 135.101f, 513.916f, 133.493f);
    builder.cubicTo(513.916f, 131.967f, 513.078f, 130.023f, 510.117f, 130.023f);
    builder.close();
    builder.moveTo(510.178f, 136.515f);
    builder.lineTo(508.217f, 136.515f);
    builder.lineTo(508.217f, 130.471f);
    builder.lineTo(510.147f, 130.471f);
    builder.cubicTo(512.036f, 130.471f, 513.333f, 131.712f, 513.333f, 133.493f);
    builder.cubicTo(513.333f, 135.447f, 511.853f, 136.515f, 510.178f, 136.515f);
    builder.close();
    builder.moveTo(519.105f, 135.894f);
    builder.lineTo(516.634f, 130.023f);
    builder.lineTo(516.093f, 130.023f);
    builder.lineTo(519.024f, 137.034f);
    builder.lineTo(519.177f, 137.034f);
    builder.lineTo(522.098f, 130.023f);
    builder.lineTo(521.557f, 130.023f);
    builder.lineTo(519.105f, 135.894f);
    builder.close();
    builder.moveTo(526.817f, 129.973f);
    builder.lineTo(523.601f, 136.963f);
    builder.lineTo(524.162f, 136.963f);
    builder.lineTo(525.265f, 134.561f);
    builder.lineTo(528.665f, 134.561f);
    builder.lineTo(529.768f, 136.963f);
    builder.lineTo(530.33f, 136.963f);
    builder.lineTo(527.113f, 129.973f);
    builder.lineTo(526.817f, 129.973f);
    builder.close();
    builder.moveTo(525.469f, 134.114f);
    builder.lineTo(526.96f, 130.848f);
    builder.lineTo(528.461f, 134.114f);
    builder.lineTo(525.469f, 134.114f);
    builder.close();
    builder.moveTo(538.947f, 136.088f);
    builder.lineTo(533.668f, 130.024f);
    builder.lineTo(533.208f, 130.024f);
    builder.lineTo(533.208f, 136.964f);
    builder.lineTo(533.749f, 136.964f);
    builder.lineTo(533.749f, 130.899f);
    builder.lineTo(539.038f, 136.964f);
    builder.lineTo(539.487f, 136.964f);
    builder.lineTo(539.487f, 130.024f);
    builder.lineTo(538.946f, 130.024f);
    builder.lineTo(538.946f, 136.088f);
    builder.lineTo(538.947f, 136.088f);
    builder.close();
    builder.moveTo(543.41f, 133.503f);
    builder.cubicTo(543.41f, 131.743f, 544.717f, 130.43f, 546.453f, 130.43f);
    builder.cubicTo(547.28f, 130.43f, 548.067f, 130.644f, 548.934f, 131.102f);
    builder.lineTo(548.934f, 130.512f);
    builder.cubicTo(548.087f, 130.125f, 547.26f, 129.932f, 546.483f, 129.932f);
    builder.cubicTo(544.574f, 129.932f, 542.828f, 131.377f, 542.828f, 133.503f);
    builder.cubicTo(542.828f, 135.538f, 544.411f, 137.054f, 546.534f, 137.054f);
    builder.cubicTo(547.341f, 137.054f, 548.198f, 136.83f, 549.005f, 136.402f);
    builder.lineTo(549.005f, 135.843f);
    builder.cubicTo(548.055f, 136.341f, 547.31f, 136.555f, 546.523f, 136.555f);
    builder.cubicTo(544.707f, 136.556f, 543.41f, 135.294f, 543.41f, 133.503f);
    builder.close();
    builder.moveTo(552.079f, 136.963f);
    builder.lineTo(552.62f, 136.963f);
    builder.lineTo(552.62f, 130.023f);
    builder.lineTo(552.079f, 130.023f);
    builder.lineTo(552.079f, 136.963f);
    builder.close();
    builder.moveTo(561.984f, 136.088f);
    builder.lineTo(556.705f, 130.024f);
    builder.lineTo(556.245f, 130.024f);
    builder.lineTo(556.245f, 136.964f);
    builder.lineTo(556.786f, 136.964f);
    builder.lineTo(556.786f, 130.899f);
    builder.lineTo(562.075f, 136.964f);
    builder.lineTo(562.524f, 136.964f);
    builder.lineTo(562.524f, 130.024f);
    builder.lineTo(561.983f, 130.024f);
    builder.lineTo(561.983f, 136.088f);
    builder.lineTo(561.984f, 136.088f);
    builder.close();
    builder.moveTo(570.122f, 134.257f);
    builder.lineTo(571.592f, 134.257f);
    builder.lineTo(571.592f, 136.129f);
    builder.cubicTo(571.041f, 136.403f, 570.489f, 136.556f, 569.683f, 136.556f);
    builder.cubicTo(567.488f, 136.556f, 566.456f, 135.05f, 566.456f, 133.493f);
    builder.cubicTo(566.456f, 131.733f, 567.763f, 130.43f, 569.529f, 130.43f);
    builder.cubicTo(570.366f, 130.43f, 571.153f, 130.654f, 572, 131.132f);
    builder.lineTo(572, 130.522f);
    builder.cubicTo(571.02f, 130.084f, 570.397f, 129.932f, 569.61f, 129.932f);
    builder.cubicTo(567.455f, 129.932f, 565.873f, 131.438f, 565.873f, 133.473f);
    builder.cubicTo(565.873f, 135.529f, 567.496f, 137.055f, 569.661f, 137.055f);
    builder.cubicTo(570.468f, 137.055f, 571.305f, 136.862f, 572.132f, 136.465f);
    builder.lineTo(572.132f, 133.809f);
    builder.lineTo(570.121f, 133.809f);
    builder.lineTo(570.121f, 134.257f);
    builder.lineTo(570.122f, 134.257f);
    builder.close();
    builder.moveTo(580.681f, 131.753f);
    builder.cubicTo(580.681f, 131.001f, 581.314f, 130.43f, 582.151f, 130.43f);
    builder.cubicTo(582.631f, 130.43f, 582.998f, 130.552f, 583.713f, 130.959f);
    builder.lineTo(583.713f, 130.37f);
    builder.cubicTo(583.172f, 130.075f, 582.641f, 129.933f, 582.099f, 129.933f);
    builder.cubicTo(580.996f, 129.933f, 580.098f, 130.747f, 580.098f, 131.775f);
    builder.cubicTo(580.098f, 134.065f, 583.417f, 133.2f, 583.417f, 135.173f);
    builder.cubicTo(583.417f, 135.956f, 582.774f, 136.557f, 581.947f, 136.557f);
    builder.cubicTo(581.406f, 136.557f, 580.966f, 136.374f, 580.191f, 135.814f);
    builder.lineTo(580.191f, 136.445f);
    builder.cubicTo(580.804f, 136.852f, 581.406f, 137.055f, 581.978f, 137.055f);
    builder.cubicTo(583.111f, 137.055f, 584, 136.221f, 584, 135.152f);
    builder.cubicTo(584, 132.72f, 580.681f, 133.605f, 580.681f, 131.753f);
    builder.close();
    builder.moveTo(587.543f, 133.503f);
    builder.cubicTo(587.543f, 131.743f, 588.85f, 130.43f, 590.586f, 130.43f);
    builder.cubicTo(591.413f, 130.43f, 592.199f, 130.644f, 593.067f, 131.102f);
    builder.lineTo(593.067f, 130.512f);
    builder.cubicTo(592.22f, 130.125f, 591.393f, 129.932f, 590.616f, 129.932f);
    builder.cubicTo(588.707f, 129.932f, 586.96f, 131.377f, 586.96f, 133.503f);
    builder.cubicTo(586.96f, 135.538f, 588.543f, 137.054f, 590.667f, 137.054f);
    builder.cubicTo(591.473f, 137.054f, 592.331f, 136.83f, 593.138f, 136.402f);
    builder.lineTo(593.138f, 135.843f);
    builder.cubicTo(592.188f, 136.341f, 591.443f, 136.555f, 590.657f, 136.555f);
    builder.cubicTo(588.84f, 136.556f, 587.543f, 135.294f, 587.543f, 133.503f);
    builder.close();
    builder.moveTo(596.212f, 136.963f);
    builder.lineTo(596.753f, 136.963f);
    builder.lineTo(596.753f, 130.023f);
    builder.lineTo(596.212f, 130.023f);
    builder.lineTo(596.212f, 136.963f);
    builder.close();
    builder.moveTo(600.94f, 133.697f);
    builder.lineTo(604.116f, 133.697f);
    builder.lineTo(604.116f, 133.25f);
    builder.lineTo(600.94f, 133.25f);
    builder.lineTo(600.94f, 130.472f);
    builder.lineTo(604.198f, 130.472f);
    builder.lineTo(604.198f, 130.024f);
    builder.lineTo(600.399f, 130.024f);
    builder.lineTo(600.399f, 136.964f);
    builder.lineTo(604.279f, 136.964f);
    builder.lineTo(604.279f, 136.516f);
    builder.lineTo(600.94f, 136.516f);
    builder.lineTo(600.94f, 133.697f);
    builder.close();
    builder.moveTo(613.163f, 136.088f);
    builder.lineTo(607.884f, 130.024f);
    builder.lineTo(607.424f, 130.024f);
    builder.lineTo(607.424f, 136.964f);
    builder.lineTo(607.965f, 136.964f);
    builder.lineTo(607.965f, 130.899f);
    builder.lineTo(613.254f, 136.964f);
    builder.lineTo(613.703f, 136.964f);
    builder.lineTo(613.703f, 130.024f);
    builder.lineTo(613.162f, 130.024f);
    builder.lineTo(613.162f, 136.088f);
    builder.lineTo(613.163f, 136.088f);
    builder.close();
    builder.moveTo(617.625f, 133.503f);
    builder.cubicTo(617.625f, 131.743f, 618.932f, 130.43f, 620.668f, 130.43f);
    builder.cubicTo(621.495f, 130.43f, 622.281f, 130.644f, 623.149f, 131.102f);
    builder.lineTo(623.149f, 130.512f);
    builder.cubicTo(622.301f, 130.125f, 621.474f, 129.932f, 620.698f, 129.932f);
    builder.cubicTo(618.789f, 129.932f, 617.042f, 131.377f, 617.042f, 133.503f);
    builder.cubicTo(617.042f, 135.538f, 618.625f, 137.054f, 620.749f, 137.054f);
    builder.cubicTo(621.556f, 137.054f, 622.413f, 136.83f, 623.22f, 136.402f);
    builder.lineTo(623.22f, 135.843f);
    builder.cubicTo(622.27f, 136.341f, 621.525f, 136.555f, 620.739f, 136.555f);
    builder.cubicTo(618.922f, 136.556f, 617.625f, 135.294f, 617.625f, 133.503f);
    builder.close();
    builder.moveTo(626.856f, 133.697f);
    builder.lineTo(630.032f, 133.697f);
    builder.lineTo(630.032f, 133.25f);
    builder.lineTo(626.856f, 133.25f);
    builder.lineTo(626.856f, 130.472f);
    builder.lineTo(630.114f, 130.472f);
    builder.lineTo(630.114f, 130.024f);
    builder.lineTo(626.316f, 130.024f);
    builder.lineTo(626.316f, 136.964f);
    builder.lineTo(630.196f, 136.964f);
    builder.lineTo(630.196f, 136.516f);
    builder.lineTo(626.857f, 136.516f);
    builder.lineTo(626.857f, 133.697f);
    builder.lineTo(626.856f, 133.697f);
    builder.close();
    builder.moveTo(633.115f, 136.963f);
    builder.lineTo(633.33f, 136.963f);
    builder.cubicTo(633.33f, 137.309f, 633.299f, 137.523f, 633.115f, 137.797f);
    builder.lineTo(633.115f, 138.154f);
    builder.cubicTo(633.565f, 137.828f, 633.779f, 137.269f, 633.779f, 136.75f);
    builder.lineTo(633.779f, 135.976f);
    builder.lineTo(633.115f, 135.976f);
    builder.lineTo(633.115f, 136.963f);
    builder.close();
    builder.moveTo(641.511f, 131.753f);
    builder.cubicTo(641.511f, 131.001f, 642.144f, 130.43f, 642.981f, 130.43f);
    builder.cubicTo(643.461f, 130.43f, 643.828f, 130.552f, 644.544f, 130.959f);
    builder.lineTo(644.544f, 130.37f);
    builder.cubicTo(644.003f, 130.075f, 643.472f, 129.933f, 642.931f, 129.933f);
    builder.cubicTo(641.828f, 129.933f, 640.929f, 130.747f, 640.929f, 131.775f);
    builder.cubicTo(640.929f, 134.065f, 644.247f, 133.2f, 644.247f, 135.173f);
    builder.cubicTo(644.247f, 135.956f, 643.604f, 136.557f, 642.777f, 136.557f);
    builder.cubicTo(642.236f, 136.557f, 641.797f, 136.374f, 641.02f, 135.814f);
    builder.lineTo(641.02f, 136.445f);
    builder.cubicTo(641.633f, 136.852f, 642.235f, 137.055f, 642.807f, 137.055f);
    builder.cubicTo(643.941f, 137.055f, 644.829f, 136.221f, 644.829f, 135.152f);
    builder.cubicTo(644.829f, 132.72f, 641.511f, 133.605f, 641.511f, 131.753f);
    builder.close();
    builder.moveTo(648.649f, 133.697f);
    builder.lineTo(651.824f, 133.697f);
    builder.lineTo(651.824f, 133.25f);
    builder.lineTo(648.649f, 133.25f);
    builder.lineTo(648.649f, 130.472f);
    builder.lineTo(651.906f, 130.472f);
    builder.lineTo(651.906f, 130.024f);
    builder.lineTo(648.107f, 130.024f);
    builder.lineTo(648.107f, 136.964f);
    builder.lineTo(651.988f, 136.964f);
    builder.lineTo(651.988f, 136.516f);
    builder.lineTo(648.649f, 136.516f);
    builder.lineTo(648.649f, 133.697f);
    builder.close();
    builder.moveTo(657.91f, 133.503f);
    builder.cubicTo(658.799f, 133.177f, 659.237f, 132.618f, 659.237f, 131.814f);
    builder.cubicTo(659.237f, 130.888f, 658.635f, 130.023f, 656.929f, 130.023f);
    builder.lineTo(655.142f, 130.023f);
    builder.lineTo(655.142f, 136.963f);
    builder.lineTo(655.683f, 136.963f);
    builder.lineTo(655.683f, 133.635f);
    builder.lineTo(656.623f, 133.635f);
    builder.cubicTo(657.46f, 133.635f, 657.726f, 133.747f, 658.563f, 135.06f);
    builder.lineTo(659.778f, 136.963f);
    builder.lineTo(660.411f, 136.963f);
    builder.lineTo(658.838f, 134.561f);
    builder.cubicTo(658.513f, 134.073f, 658.237f, 133.676f, 657.91f, 133.503f);
    builder.close();
    builder.moveTo(656.838f, 133.188f);
    builder.lineTo(655.684f, 133.188f);
    builder.lineTo(655.684f, 130.472f);
    builder.lineTo(656.817f, 130.472f);
    builder.cubicTo(658.094f, 130.472f, 658.655f, 131.041f, 658.655f, 131.825f);
    builder.cubicTo(658.655f, 132.659f, 658.063f, 133.188f, 656.838f, 133.188f);
    builder.close();
    builder.moveTo(664.968f, 135.894f);
    builder.lineTo(662.497f, 130.023f);
    builder.lineTo(661.956f, 130.023f);
    builder.lineTo(664.887f, 137.034f);
    builder.lineTo(665.04f, 137.034f);
    builder.lineTo(667.961f, 130.023f);
    builder.lineTo(667.42f, 130.023f);
    builder.lineTo(664.968f, 135.894f);
    builder.close();
    builder.moveTo(670.829f, 136.963f);
    builder.lineTo(671.37f, 136.963f);
    builder.lineTo(671.37f, 130.023f);
    builder.lineTo(670.829f, 130.023f);
    builder.lineTo(670.829f, 136.963f);
    builder.close();
    builder.moveTo(680.734f, 136.088f);
    builder.lineTo(675.455f, 130.024f);
    builder.lineTo(674.995f, 130.024f);
    builder.lineTo(674.995f, 136.964f);
    builder.lineTo(675.536f, 136.964f);
    builder.lineTo(675.536f, 130.899f);
    builder.lineTo(680.826f, 136.964f);
    builder.lineTo(681.275f, 136.964f);
    builder.lineTo(681.275f, 130.024f);
    builder.lineTo(680.733f, 130.024f);
    builder.lineTo(680.733f, 136.088f);
    builder.lineTo(680.734f, 136.088f);
    builder.close();
    builder.moveTo(688.873f, 134.257f);
    builder.lineTo(690.343f, 134.257f);
    builder.lineTo(690.343f, 136.129f);
    builder.cubicTo(689.791f, 136.403f, 689.24f, 136.556f, 688.433f, 136.556f);
    builder.cubicTo(686.238f, 136.556f, 685.206f, 135.05f, 685.206f, 133.493f);
    builder.cubicTo(685.206f, 131.733f, 686.514f, 130.43f, 688.28f, 130.43f);
    builder.cubicTo(689.117f, 130.43f, 689.903f, 130.654f, 690.751f, 131.132f);
    builder.lineTo(690.751f, 130.522f);
    builder.cubicTo(689.771f, 130.084f, 689.148f, 129.932f, 688.362f, 129.932f);
    builder.cubicTo(686.207f, 129.932f, 684.624f, 131.438f, 684.624f, 133.473f);
    builder.cubicTo(684.624f, 135.529f, 686.247f, 137.055f, 688.413f, 137.055f);
    builder.cubicTo(689.219f, 137.055f, 690.057f, 136.862f, 690.884f, 136.465f);
    builder.lineTo(690.884f, 133.809f);
    builder.lineTo(688.873f, 133.809f);
    builder.lineTo(688.873f, 134.257f);
    builder.close();
    builder.moveTo(699.432f, 131.753f);
    builder.cubicTo(699.432f, 131.001f, 700.065f, 130.43f, 700.902f, 130.43f);
    builder.cubicTo(701.381f, 130.43f, 701.749f, 130.552f, 702.464f, 130.959f);
    builder.lineTo(702.464f, 130.37f);
    builder.cubicTo(701.923f, 130.075f, 701.391f, 129.933f, 700.85f, 129.933f);
    builder.cubicTo(699.747f, 129.933f, 698.849f, 130.747f, 698.849f, 131.775f);
    builder.cubicTo(698.849f, 134.065f, 702.168f, 133.2f, 702.168f, 135.173f);
    builder.cubicTo(702.168f, 135.956f, 701.525f, 136.557f, 700.698f, 136.557f);
    builder.cubicTo(700.156f, 136.557f, 699.718f, 136.374f, 698.941f, 135.814f);
    builder.lineTo(698.941f, 136.445f);
    builder.cubicTo(699.553f, 136.852f, 700.156f, 137.055f, 700.728f, 137.055f);
    builder.cubicTo(701.862f, 137.055f, 702.75f, 136.221f, 702.75f, 135.152f);
    builder.cubicTo(702.75f, 132.72f, 699.432f, 133.605f, 699.432f, 131.753f);
    builder.close();
    builder.moveTo(709.407f, 129.932f);
    builder.cubicTo(707.345f, 129.932f, 705.731f, 131.499f, 705.731f, 133.493f);
    builder.cubicTo(705.731f, 135.488f, 707.345f, 137.054f, 709.407f, 137.054f);
    builder.cubicTo(711.48f, 137.054f, 713.104f, 135.487f, 713.104f, 133.493f);
    builder.cubicTo(713.104f, 131.499f, 711.481f, 129.932f, 709.407f, 129.932f);
    builder.close();
    builder.moveTo(709.428f, 136.556f);
    builder.cubicTo(707.683f, 136.556f, 706.314f, 135.223f, 706.314f, 133.493f);
    builder.cubicTo(706.314f, 131.763f, 707.682f, 130.43f, 709.428f, 130.43f);
    builder.cubicTo(711.175f, 130.43f, 712.523f, 131.763f, 712.523f, 133.493f);
    builder.cubicTo(712.522f, 135.223f, 711.175f, 136.556f, 709.428f, 136.556f);
    builder.close();
    builder.moveTo(716.739f, 133.503f);
    builder.cubicTo(716.739f, 131.743f, 718.046f, 130.43f, 719.782f, 130.43f);
    builder.cubicTo(720.609f, 130.43f, 721.395f, 130.644f, 722.264f, 131.102f);
    builder.lineTo(722.264f, 130.512f);
    builder.cubicTo(721.416f, 130.125f, 720.589f, 129.932f, 719.813f, 129.932f);
    builder.cubicTo(717.903f, 129.932f, 716.157f, 131.377f, 716.157f, 133.503f);
    builder.cubicTo(716.157f, 135.538f, 717.74f, 137.054f, 719.863f, 137.054f);
    builder.cubicTo(720.67f, 137.054f, 721.528f, 136.83f, 722.335f, 136.402f);
    builder.lineTo(722.335f, 135.843f);
    builder.cubicTo(721.385f, 136.341f, 720.64f, 136.555f, 719.854f, 136.555f);
    builder.cubicTo(718.037f, 136.556f, 716.739f, 135.294f, 716.739f, 133.503f);
    builder.close();
    builder.moveTo(725.409f, 136.963f);
    builder.lineTo(725.95f, 136.963f);
    builder.lineTo(725.95f, 130.023f);
    builder.lineTo(725.409f, 130.023f);
    builder.lineTo(725.409f, 136.963f);
    builder.close();
    builder.moveTo(730.136f, 133.697f);
    builder.lineTo(733.312f, 133.697f);
    builder.lineTo(733.312f, 133.25f);
    builder.lineTo(730.136f, 133.25f);
    builder.lineTo(730.136f, 130.472f);
    builder.lineTo(733.393f, 130.472f);
    builder.lineTo(733.393f, 130.024f);
    builder.lineTo(729.595f, 130.024f);
    builder.lineTo(729.595f, 136.964f);
    builder.lineTo(733.475f, 136.964f);
    builder.lineTo(733.475f, 136.516f);
    builder.lineTo(730.136f, 136.516f);
    builder.lineTo(730.136f, 133.697f);
    builder.close();
    builder.moveTo(735.865f, 130.472f);
    builder.lineTo(738.479f, 130.472f);
    builder.lineTo(738.479f, 136.964f);
    builder.lineTo(739.02f, 136.964f);
    builder.lineTo(739.02f, 130.472f);
    builder.lineTo(741.634f, 130.472f);
    builder.lineTo(741.634f, 130.024f);
    builder.lineTo(735.865f, 130.024f);
    builder.lineTo(735.865f, 130.472f);
    builder.close();
    builder.moveTo(749.017f, 130.023f);
    builder.lineTo(746.699f, 132.771f);
    builder.lineTo(744.371f, 130.023f);
    builder.lineTo(743.717f, 130.023f);
    builder.lineTo(746.423f, 133.239f);
    builder.lineTo(746.423f, 136.963f);
    builder.lineTo(746.964f, 136.963f);
    builder.lineTo(746.964f, 133.239f);
    builder.lineTo(749.67f, 130.023f);
    builder.lineTo(749.017f, 130.023f);
    builder.close();
    builder.moveTo(578.773f, 115.549f);
    builder.lineTo(578.773f, 62.773f);
    builder.lineTo(557.571f, 62.773f);
    builder.cubicTo(562.752f, 67.658f, 575.797f, 106.652f, 578.773f, 115.549f);
    builder.close();
    builder.moveTo(544.754f, 62.861f);
    builder.lineTo(524.496f, 62.861f);
    builder.lineTo(524.496f, 115.55f);
    builder.lineTo(524.934f, 115.55f);
    builder.lineTo(544.544f, 64.169f);
    builder.lineTo(528.157f, 115.549f);
    builder.lineTo(528.682f, 115.549f);
    builder.lineTo(546.557f, 67.658f);
    builder.lineTo(531.675f, 115.548f);
    builder.lineTo(532.376f, 115.548f);
    builder.lineTo(548.57f, 71.846f);
    builder.lineTo(535.293f, 115.507f);
    builder.lineTo(535.906f, 115.507f);
    builder.lineTo(544.281f, 97.58f);
    builder.lineTo(542.267f, 97.58f);
    builder.lineTo(550.409f, 76.033f);
    builder.lineTo(544.281f, 97.578f);
    builder.lineTo(546.119f, 97.578f);
    builder.lineTo(538.678f, 115.551f);
    builder.lineTo(565.029f, 115.551f);
    builder.cubicTo(562.052f, 106.477f, 550.759f, 67.92f, 544.754f, 62.861f);
    builder.close();
    SkPath path2(builder.detach());
    testPathOp(reporter, path1, path2, kIntersect_SkPathOp, filename);
}

static void (*skipTest)(skiatest::Reporter* , const char* filename) = nullptr;
static void (*firstTest)(skiatest::Reporter* , const char* filename) = nullptr;
static void (*stopTest)(skiatest::Reporter* , const char* filename) = nullptr;

static struct TestDesc tests[] = {
    TEST(skpwww_gorcraft_ru_1),
    TEST(http___www_project2061_org),
    TEST(http___www_emuleteca_cl_27),
    TEST(http___www_emuleteca_cl_26),
    TEST(http___www_emuleteca_cl_28),
    TEST(skpwww_nimble_com_au_1),
    TEST(skpwww_mybuilder_com_1),
    TEST(skpwww_neda_net_2),
    TEST(skpwww_woothemes_com_1),
    TEST(skpwww_neda_net_1),
    TEST(skpwww_tinytots_com_1),
    TEST(skpwww_educationalcraft_com_4a),
    TEST(skpwww_lptemp_com_3),
    TEST(skpwww_shinydemos_com_5),
    TEST(skpwww_lptemp_com_5),
    TEST(skpwww_shinydemos_com_15),
    TEST(skpwww_familysurvivalprotocol_wordpress_com_61),
    TEST(skpwww_alamdi_com_3),
    TEST(skpwww_devbridge_com_22),
    TEST(skpwww_firstunitedbank_com_19),
    TEST(skpwww_googleventures_com_32),
    TEST(skpwww_9to5mac_com_64),
    TEST(skpwww_wartepop_blogspot_com_br_6),
    TEST(skpwww_wartepop_blogspot_com_br_6a),
    TEST(skpwww_cooksnaps_com_32a),
    TEST(skpwww_argus_presse_fr_41),
    TEST(skpwww_cooksnaps_com_17),
    TEST(skpwww_cooksnaps_com_32),
    TEST(skpwww_kitcheninspirations_wordpress_com_66),
    TEST(skpwww_tcmevents_org_13),
    TEST(skpwww_narayana_publishers_com_194),
    TEST(skpwww_swapspacesystems_com_5),
    TEST(skpwww_vantageproduction_com_109),
    TEST(skpwww_americascup_com_108),
    TEST(skpwww_narayana_verlag_de_194),
    TEST(skpwww_etiqadd_com_2464),
    TEST(skpwww_paseoitaigara_com_br_56),
    TEST(skpwww_mortgagemarketguide_com_109),
    TEST(skpwww_aceinfographics_com_106),
    TEST(skpwww_educationalcraft_com_4),
    TEST(skpwww_kitcheninspirations_wordpress_com_32),
    TEST(skpwww_artblart_com_8),
    TEST(skpwww_docgelo_com_66),
    TEST(skpwww_uniquefx_net_442),
    TEST(skpwww_defense_studies_blogspot_com_64),
    TEST(skpwww_kenlevine_blogspot_com_28),
    TEST(skpwww_fashionscandal_com_94),
    TEST(skpwww_thaienews_blogspot_com_36),
    TEST(skpwww_galaxystwo_com_4),
    TEST(skpwww_catingueiraonline_com_352),
    TEST(skpwww_evolvehq_com_210),
    TEST(skpwww_odia_com_br_26),
    TEST(skpwww_lokado_de_173),
    TEST(skpwww_seopack_blogspot_com_2153),
    TEST(skpwww_partsdata_de_53),
    TEST(skpwww_simplysaru_com_40),
    TEST(skpwww_jessicaslens_wordpress_com_222),
    TEST(skpwww_kpopexplorer_net_22),
    TEST(skpwww_tunero_de_24),
    TEST(skpwww_karnivool_com_au_11),
    TEST(skpwww_pindosiya_com_99),
    TEST(skpwww_contextualnewsfeeds_com_346),
    TEST(skpwww_helha_be_109),
    TEST(skpwww_phototransferapp_com_24),
    TEST(skpwww_phototransferapp_com_24x),
    TEST(skpwww_gruposejaumdivulgador_com_br_4),
    TEST(skpwww_hubbyscook_com_22),
    TEST(skpwww_maturesupertube_com_21),
    TEST(skpwww_getgold_jp_731),
    TEST(skpwww_trashness_com_36),
    TEST(skpwww_exystence_net_61),
    TEST(skpwww_320kbps_net_2231),
    TEST(skpwww_heartiste_wordpress_com_86),
    TEST(skpwww_hairjobsearch_com_31),
    TEST(skpwww_alucinados_net_101),
    TEST(skpnamecheap_com_405),
    TEST(skpelpais_com_18),
    TEST(skpwww_cityads_ru_249),
    TEST(skpwww_alrakoba_net_62),
    TEST(skpwww_dealnews_com_315),
    TEST(skpwww_inmotionhosting_com_9),
    TEST(skpskpicture14),
    TEST(skpskpicture15),
    TEST(skpwww_meb_gov_tr_6),
    TEST(skpwww_sciality_com_101),
    TEST(skpwww_booking_com_68),
    TEST(skpwww_despegar_com_mx_272),
    TEST(skpwww_lavoixdunord_fr_11),
    TEST(skppptv_com_62),
    TEST(skppchappy_com_au102),
    TEST(skpsciality_com161),
    TEST(skpi_gino_com16),
    TEST(skpnaoxrane_ru23),
    TEST(skptcmevents_org23),
    TEST(skpredbullskatearcade_es16),
    TEST(skpfinanzasdigital_com9),
    TEST(skpgithub_io_26),
    TEST(skpgithub_io_25),
    TEST(skpwww_meb_gov_tr_5),
    TEST(skpwww_sciality_com_100),
    TEST(skpwww_joomla_org_23),
    TEST(skpwww_macrumors_com_131),
    TEST(skpwww_briian_com_34),
    TEST(skpwww_leadpages_net_84),
    TEST(skpwww_fj_p_com_22),
    TEST(skppartainasdemo250_org56),
    TEST(skpsd_graphic_net104),
    TEST(skpbreakmystyle_com10),
    TEST(skpnational_com_au81),
    TEST(skprentacheat_com30),
    TEST(skptracksflow_com9),
    TEST(skpautobutler_dk29),
    TEST(skponlinecollege_org144),
    TEST(skphostloco_com11),
    TEST(skpsergeychunkevich_com8),
    TEST(skpmlk_com326),
    TEST(skpcyclist_friends_gr52),
    TEST(skpfrauen_magazin_com83),
    TEST(skpthesuburbanite_com213),
    TEST(skpsudoestenegocios_com186),
    TEST(skpmtrk_uz27),
    TEST(skpilkoora_com37),
    TEST(skpmm4everfriends_com43),
    TEST(skpflite_com41),
    TEST(skpcheeseandburger_com225),
    TEST(skpeverytechpro_blogspot_com100),
};

static const size_t testCount = std::size(tests);

static bool runReverse = false;

DEF_TEST(PathOpsSkp, reporter) {
    RunTestSet(reporter, tests, testCount, firstTest, skipTest, stopTest, runReverse);
}
