// Copyright limiting-factor <limiting-factor@posteo.com>
// SPDX-License-Identifier: MIT

package f3

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

type s struct {
	v int
}

func (o s) Equal(other s) bool {
	return o.v == other.v
}

func TestNilOrEqual(t *testing.T) {
	s1 := &s{1}
	s2 := &s{1}
	s3 := &s{2}
	assert.True(t, nilOrEqual[s](nil, nil))
	assert.False(t, nilOrEqual(s1, nil))
	assert.False(t, nilOrEqual(nil, s2))
	assert.True(t, nilOrEqual(s1, s2))
	assert.False(t, nilOrEqual(s1, s3))
}

func TestArrayEqual(t *testing.T) {
	s1 := []*s{{1}, {2}}
	s2 := []*s{{1}, {2}}
	s3 := []*s{{1}, {2}, {3}}
	assert.True(t, arrayEqual(s1, s2))
	assert.False(t, arrayEqual(s1, s3))
}

func TestNilOrEqualTimeToDate(t *testing.T) {
	t1, err := time.Parse(time.RFC3339, "2006-01-02T15:04:05Z")
	require.NoError(t, err)
	t2, err := time.Parse(time.RFC3339, "2006-01-02T00:01:00Z")
	require.NoError(t, err)
	t3, err := time.Parse(time.RFC3339, "2026-01-02T11:01:00Z")
	require.NoError(t, err)
	assert.True(t, nilOrEqualTimeToDate(nil, nil))
	assert.False(t, nilOrEqualTimeToDate(&t1, nil))
	assert.False(t, nilOrEqualTimeToDate(nil, &t2))
	assert.True(t, nilOrEqualTimeToDate(&t1, &t2))
	assert.False(t, nilOrEqualTimeToDate(&t1, &t3))
}
