// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file primitives.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__PRIMITIVES_HPP
#define FAST_DDS_GENERATED__PRIMITIVES_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(PRIMITIVES_SOURCE)
#define PRIMITIVES_DllAPI __declspec( dllexport )
#else
#define PRIMITIVES_DllAPI __declspec( dllimport )
#endif // PRIMITIVES_SOURCE
#else
#define PRIMITIVES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define PRIMITIVES_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure ShortStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class ShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ShortStruct that will be copied.
     */
    eProsima_user_DllExport ShortStruct(
            const ShortStruct& x)
    {
                    m_var_short = x.m_var_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ShortStruct that will be copied.
     */
    eProsima_user_DllExport ShortStruct(
            ShortStruct&& x) noexcept
    {
        m_var_short = x.m_var_short;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ShortStruct that will be copied.
     */
    eProsima_user_DllExport ShortStruct& operator =(
            const ShortStruct& x)
    {

                    m_var_short = x.m_var_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ShortStruct that will be copied.
     */
    eProsima_user_DllExport ShortStruct& operator =(
            ShortStruct&& x) noexcept
    {

        m_var_short = x.m_var_short;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ShortStruct& x) const
    {
        return (m_var_short == x.m_var_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x ShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }



private:

    int16_t m_var_short{0};

};
/*!
 * @brief This class represents the structure UShortStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class UShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UShortStruct that will be copied.
     */
    eProsima_user_DllExport UShortStruct(
            const UShortStruct& x)
    {
                    m_var_ushort = x.m_var_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UShortStruct that will be copied.
     */
    eProsima_user_DllExport UShortStruct(
            UShortStruct&& x) noexcept
    {
        m_var_ushort = x.m_var_ushort;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UShortStruct that will be copied.
     */
    eProsima_user_DllExport UShortStruct& operator =(
            const UShortStruct& x)
    {

                    m_var_ushort = x.m_var_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UShortStruct that will be copied.
     */
    eProsima_user_DllExport UShortStruct& operator =(
            UShortStruct&& x) noexcept
    {

        m_var_ushort = x.m_var_ushort;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UShortStruct& x) const
    {
        return (m_var_ushort == x.m_var_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x UShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ushort
     * @param _var_ushort New value for member var_ushort
     */
    eProsima_user_DllExport void var_ushort(
            uint16_t _var_ushort)
    {
        m_var_ushort = _var_ushort;
    }

    /*!
     * @brief This function returns the value of member var_ushort
     * @return Value of member var_ushort
     */
    eProsima_user_DllExport uint16_t var_ushort() const
    {
        return m_var_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_ushort
     * @return Reference to member var_ushort
     */
    eProsima_user_DllExport uint16_t& var_ushort()
    {
        return m_var_ushort;
    }



private:

    uint16_t m_var_ushort{0};

};
/*!
 * @brief This class represents the structure LongStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class LongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport LongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~LongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object LongStruct that will be copied.
     */
    eProsima_user_DllExport LongStruct(
            const LongStruct& x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object LongStruct that will be copied.
     */
    eProsima_user_DllExport LongStruct(
            LongStruct&& x) noexcept
    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object LongStruct that will be copied.
     */
    eProsima_user_DllExport LongStruct& operator =(
            const LongStruct& x)
    {

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object LongStruct that will be copied.
     */
    eProsima_user_DllExport LongStruct& operator =(
            LongStruct&& x) noexcept
    {

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x LongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const LongStruct& x) const
    {
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x LongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const LongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};
/*!
 * @brief This class represents the structure ULongStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class ULongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ULongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ULongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ULongStruct that will be copied.
     */
    eProsima_user_DllExport ULongStruct(
            const ULongStruct& x)
    {
                    m_var_ulong = x.m_var_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ULongStruct that will be copied.
     */
    eProsima_user_DllExport ULongStruct(
            ULongStruct&& x) noexcept
    {
        m_var_ulong = x.m_var_ulong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ULongStruct that will be copied.
     */
    eProsima_user_DllExport ULongStruct& operator =(
            const ULongStruct& x)
    {

                    m_var_ulong = x.m_var_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ULongStruct that will be copied.
     */
    eProsima_user_DllExport ULongStruct& operator =(
            ULongStruct&& x) noexcept
    {

        m_var_ulong = x.m_var_ulong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ULongStruct& x) const
    {
        return (m_var_ulong == x.m_var_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ULongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulong
     * @param _var_ulong New value for member var_ulong
     */
    eProsima_user_DllExport void var_ulong(
            uint32_t _var_ulong)
    {
        m_var_ulong = _var_ulong;
    }

    /*!
     * @brief This function returns the value of member var_ulong
     * @return Value of member var_ulong
     */
    eProsima_user_DllExport uint32_t var_ulong() const
    {
        return m_var_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_ulong
     * @return Reference to member var_ulong
     */
    eProsima_user_DllExport uint32_t& var_ulong()
    {
        return m_var_ulong;
    }



private:

    uint32_t m_var_ulong{0};

};
/*!
 * @brief This class represents the structure LongLongStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class LongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport LongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~LongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object LongLongStruct that will be copied.
     */
    eProsima_user_DllExport LongLongStruct(
            const LongLongStruct& x)
    {
                    m_var_longlong = x.m_var_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object LongLongStruct that will be copied.
     */
    eProsima_user_DllExport LongLongStruct(
            LongLongStruct&& x) noexcept
    {
        m_var_longlong = x.m_var_longlong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object LongLongStruct that will be copied.
     */
    eProsima_user_DllExport LongLongStruct& operator =(
            const LongLongStruct& x)
    {

                    m_var_longlong = x.m_var_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object LongLongStruct that will be copied.
     */
    eProsima_user_DllExport LongLongStruct& operator =(
            LongLongStruct&& x) noexcept
    {

        m_var_longlong = x.m_var_longlong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x LongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const LongLongStruct& x) const
    {
        return (m_var_longlong == x.m_var_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x LongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const LongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longlong
     * @param _var_longlong New value for member var_longlong
     */
    eProsima_user_DllExport void var_longlong(
            int64_t _var_longlong)
    {
        m_var_longlong = _var_longlong;
    }

    /*!
     * @brief This function returns the value of member var_longlong
     * @return Value of member var_longlong
     */
    eProsima_user_DllExport int64_t var_longlong() const
    {
        return m_var_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_longlong
     * @return Reference to member var_longlong
     */
    eProsima_user_DllExport int64_t& var_longlong()
    {
        return m_var_longlong;
    }



private:

    int64_t m_var_longlong{0};

};
/*!
 * @brief This class represents the structure ULongLongStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class ULongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ULongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ULongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ULongLongStruct that will be copied.
     */
    eProsima_user_DllExport ULongLongStruct(
            const ULongLongStruct& x)
    {
                    m_var_ulonglong = x.m_var_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ULongLongStruct that will be copied.
     */
    eProsima_user_DllExport ULongLongStruct(
            ULongLongStruct&& x) noexcept
    {
        m_var_ulonglong = x.m_var_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ULongLongStruct that will be copied.
     */
    eProsima_user_DllExport ULongLongStruct& operator =(
            const ULongLongStruct& x)
    {

                    m_var_ulonglong = x.m_var_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ULongLongStruct that will be copied.
     */
    eProsima_user_DllExport ULongLongStruct& operator =(
            ULongLongStruct&& x) noexcept
    {

        m_var_ulonglong = x.m_var_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ULongLongStruct& x) const
    {
        return (m_var_ulonglong == x.m_var_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ULongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulonglong
     * @param _var_ulonglong New value for member var_ulonglong
     */
    eProsima_user_DllExport void var_ulonglong(
            uint64_t _var_ulonglong)
    {
        m_var_ulonglong = _var_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_ulonglong
     * @return Value of member var_ulonglong
     */
    eProsima_user_DllExport uint64_t var_ulonglong() const
    {
        return m_var_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_ulonglong
     * @return Reference to member var_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_ulonglong()
    {
        return m_var_ulonglong;
    }



private:

    uint64_t m_var_ulonglong{0};

};
/*!
 * @brief This class represents the structure FloatStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class FloatStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FloatStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FloatStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FloatStruct that will be copied.
     */
    eProsima_user_DllExport FloatStruct(
            const FloatStruct& x)
    {
                    m_var_float = x.m_var_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FloatStruct that will be copied.
     */
    eProsima_user_DllExport FloatStruct(
            FloatStruct&& x) noexcept
    {
        m_var_float = x.m_var_float;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FloatStruct that will be copied.
     */
    eProsima_user_DllExport FloatStruct& operator =(
            const FloatStruct& x)
    {

                    m_var_float = x.m_var_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FloatStruct that will be copied.
     */
    eProsima_user_DllExport FloatStruct& operator =(
            FloatStruct&& x) noexcept
    {

        m_var_float = x.m_var_float;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FloatStruct& x) const
    {
        return (m_var_float == x.m_var_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x FloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FloatStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_float
     * @param _var_float New value for member var_float
     */
    eProsima_user_DllExport void var_float(
            float _var_float)
    {
        m_var_float = _var_float;
    }

    /*!
     * @brief This function returns the value of member var_float
     * @return Value of member var_float
     */
    eProsima_user_DllExport float var_float() const
    {
        return m_var_float;
    }

    /*!
     * @brief This function returns a reference to member var_float
     * @return Reference to member var_float
     */
    eProsima_user_DllExport float& var_float()
    {
        return m_var_float;
    }



private:

    float m_var_float{0.0};

};
/*!
 * @brief This class represents the structure DoubleStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class DoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DoubleStruct that will be copied.
     */
    eProsima_user_DllExport DoubleStruct(
            const DoubleStruct& x)
    {
                    m_var_double = x.m_var_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DoubleStruct that will be copied.
     */
    eProsima_user_DllExport DoubleStruct(
            DoubleStruct&& x) noexcept
    {
        m_var_double = x.m_var_double;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DoubleStruct that will be copied.
     */
    eProsima_user_DllExport DoubleStruct& operator =(
            const DoubleStruct& x)
    {

                    m_var_double = x.m_var_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DoubleStruct that will be copied.
     */
    eProsima_user_DllExport DoubleStruct& operator =(
            DoubleStruct&& x) noexcept
    {

        m_var_double = x.m_var_double;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DoubleStruct& x) const
    {
        return (m_var_double == x.m_var_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x DoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_double
     * @param _var_double New value for member var_double
     */
    eProsima_user_DllExport void var_double(
            double _var_double)
    {
        m_var_double = _var_double;
    }

    /*!
     * @brief This function returns the value of member var_double
     * @return Value of member var_double
     */
    eProsima_user_DllExport double var_double() const
    {
        return m_var_double;
    }

    /*!
     * @brief This function returns a reference to member var_double
     * @return Reference to member var_double
     */
    eProsima_user_DllExport double& var_double()
    {
        return m_var_double;
    }



private:

    double m_var_double{0.0};

};
/*!
 * @brief This class represents the structure LongDoubleStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class LongDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport LongDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~LongDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object LongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport LongDoubleStruct(
            const LongDoubleStruct& x)
    {
                    m_var_longdouble = x.m_var_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object LongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport LongDoubleStruct(
            LongDoubleStruct&& x) noexcept
    {
        m_var_longdouble = x.m_var_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object LongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport LongDoubleStruct& operator =(
            const LongDoubleStruct& x)
    {

                    m_var_longdouble = x.m_var_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object LongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport LongDoubleStruct& operator =(
            LongDoubleStruct&& x) noexcept
    {

        m_var_longdouble = x.m_var_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x LongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const LongDoubleStruct& x) const
    {
        return (m_var_longdouble == x.m_var_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x LongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const LongDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longdouble
     * @param _var_longdouble New value for member var_longdouble
     */
    eProsima_user_DllExport void var_longdouble(
            long double _var_longdouble)
    {
        m_var_longdouble = _var_longdouble;
    }

    /*!
     * @brief This function returns the value of member var_longdouble
     * @return Value of member var_longdouble
     */
    eProsima_user_DllExport long double var_longdouble() const
    {
        return m_var_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_longdouble
     * @return Reference to member var_longdouble
     */
    eProsima_user_DllExport long double& var_longdouble()
    {
        return m_var_longdouble;
    }



private:

    long double m_var_longdouble{0.0};

};
/*!
 * @brief This class represents the structure BooleanStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class BooleanStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BooleanStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BooleanStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BooleanStruct that will be copied.
     */
    eProsima_user_DllExport BooleanStruct(
            const BooleanStruct& x)
    {
                    m_var_boolean = x.m_var_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BooleanStruct that will be copied.
     */
    eProsima_user_DllExport BooleanStruct(
            BooleanStruct&& x) noexcept
    {
        m_var_boolean = x.m_var_boolean;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BooleanStruct that will be copied.
     */
    eProsima_user_DllExport BooleanStruct& operator =(
            const BooleanStruct& x)
    {

                    m_var_boolean = x.m_var_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BooleanStruct that will be copied.
     */
    eProsima_user_DllExport BooleanStruct& operator =(
            BooleanStruct&& x) noexcept
    {

        m_var_boolean = x.m_var_boolean;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BooleanStruct& x) const
    {
        return (m_var_boolean == x.m_var_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x BooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BooleanStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_boolean
     * @param _var_boolean New value for member var_boolean
     */
    eProsima_user_DllExport void var_boolean(
            bool _var_boolean)
    {
        m_var_boolean = _var_boolean;
    }

    /*!
     * @brief This function returns the value of member var_boolean
     * @return Value of member var_boolean
     */
    eProsima_user_DllExport bool var_boolean() const
    {
        return m_var_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_boolean
     * @return Reference to member var_boolean
     */
    eProsima_user_DllExport bool& var_boolean()
    {
        return m_var_boolean;
    }



private:

    bool m_var_boolean{false};

};
/*!
 * @brief This class represents the structure OctetStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class OctetStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport OctetStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~OctetStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OctetStruct that will be copied.
     */
    eProsima_user_DllExport OctetStruct(
            const OctetStruct& x)
    {
                    m_var_octet = x.m_var_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object OctetStruct that will be copied.
     */
    eProsima_user_DllExport OctetStruct(
            OctetStruct&& x) noexcept
    {
        m_var_octet = x.m_var_octet;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OctetStruct that will be copied.
     */
    eProsima_user_DllExport OctetStruct& operator =(
            const OctetStruct& x)
    {

                    m_var_octet = x.m_var_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object OctetStruct that will be copied.
     */
    eProsima_user_DllExport OctetStruct& operator =(
            OctetStruct&& x) noexcept
    {

        m_var_octet = x.m_var_octet;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x OctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const OctetStruct& x) const
    {
        return (m_var_octet == x.m_var_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x OctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const OctetStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_octet
     * @param _var_octet New value for member var_octet
     */
    eProsima_user_DllExport void var_octet(
            uint8_t _var_octet)
    {
        m_var_octet = _var_octet;
    }

    /*!
     * @brief This function returns the value of member var_octet
     * @return Value of member var_octet
     */
    eProsima_user_DllExport uint8_t var_octet() const
    {
        return m_var_octet;
    }

    /*!
     * @brief This function returns a reference to member var_octet
     * @return Reference to member var_octet
     */
    eProsima_user_DllExport uint8_t& var_octet()
    {
        return m_var_octet;
    }



private:

    uint8_t m_var_octet{0};

};
/*!
 * @brief This class represents the structure CharStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class CharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CharStruct that will be copied.
     */
    eProsima_user_DllExport CharStruct(
            const CharStruct& x)
    {
                    m_var_char8 = x.m_var_char8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CharStruct that will be copied.
     */
    eProsima_user_DllExport CharStruct(
            CharStruct&& x) noexcept
    {
        m_var_char8 = x.m_var_char8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CharStruct that will be copied.
     */
    eProsima_user_DllExport CharStruct& operator =(
            const CharStruct& x)
    {

                    m_var_char8 = x.m_var_char8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CharStruct that will be copied.
     */
    eProsima_user_DllExport CharStruct& operator =(
            CharStruct&& x) noexcept
    {

        m_var_char8 = x.m_var_char8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CharStruct& x) const
    {
        return (m_var_char8 == x.m_var_char8);
    }

    /*!
     * @brief Comparison operator.
     * @param x CharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char8
     * @param _var_char8 New value for member var_char8
     */
    eProsima_user_DllExport void var_char8(
            char _var_char8)
    {
        m_var_char8 = _var_char8;
    }

    /*!
     * @brief This function returns the value of member var_char8
     * @return Value of member var_char8
     */
    eProsima_user_DllExport char var_char8() const
    {
        return m_var_char8;
    }

    /*!
     * @brief This function returns a reference to member var_char8
     * @return Reference to member var_char8
     */
    eProsima_user_DllExport char& var_char8()
    {
        return m_var_char8;
    }



private:

    char m_var_char8{0};

};
/*!
 * @brief This class represents the structure WCharStruct defined by the user in the IDL file.
 * @ingroup primitives
 */
class WCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport WCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~WCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WCharStruct that will be copied.
     */
    eProsima_user_DllExport WCharStruct(
            const WCharStruct& x)
    {
                    m_var_char16 = x.m_var_char16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object WCharStruct that will be copied.
     */
    eProsima_user_DllExport WCharStruct(
            WCharStruct&& x) noexcept
    {
        m_var_char16 = x.m_var_char16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WCharStruct that will be copied.
     */
    eProsima_user_DllExport WCharStruct& operator =(
            const WCharStruct& x)
    {

                    m_var_char16 = x.m_var_char16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object WCharStruct that will be copied.
     */
    eProsima_user_DllExport WCharStruct& operator =(
            WCharStruct&& x) noexcept
    {

        m_var_char16 = x.m_var_char16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x WCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const WCharStruct& x) const
    {
        return (m_var_char16 == x.m_var_char16);
    }

    /*!
     * @brief Comparison operator.
     * @param x WCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const WCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char16
     * @param _var_char16 New value for member var_char16
     */
    eProsima_user_DllExport void var_char16(
            wchar_t _var_char16)
    {
        m_var_char16 = _var_char16;
    }

    /*!
     * @brief This function returns the value of member var_char16
     * @return Value of member var_char16
     */
    eProsima_user_DllExport wchar_t var_char16() const
    {
        return m_var_char16;
    }

    /*!
     * @brief This function returns a reference to member var_char16
     * @return Reference to member var_char16
     */
    eProsima_user_DllExport wchar_t& var_char16()
    {
        return m_var_char16;
    }



private:

    wchar_t m_var_char16{0};

};
/*!
 * @brief This class represents the structure Int8Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Int8Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Int8Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Int8Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Int8Struct that will be copied.
     */
    eProsima_user_DllExport Int8Struct(
            const Int8Struct& x)
    {
                    m_var_int8 = x.m_var_int8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Int8Struct that will be copied.
     */
    eProsima_user_DllExport Int8Struct(
            Int8Struct&& x) noexcept
    {
        m_var_int8 = x.m_var_int8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Int8Struct that will be copied.
     */
    eProsima_user_DllExport Int8Struct& operator =(
            const Int8Struct& x)
    {

                    m_var_int8 = x.m_var_int8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Int8Struct that will be copied.
     */
    eProsima_user_DllExport Int8Struct& operator =(
            Int8Struct&& x) noexcept
    {

        m_var_int8 = x.m_var_int8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Int8Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Int8Struct& x) const
    {
        return (m_var_int8 == x.m_var_int8);
    }

    /*!
     * @brief Comparison operator.
     * @param x Int8Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Int8Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_int8
     * @param _var_int8 New value for member var_int8
     */
    eProsima_user_DllExport void var_int8(
            int8_t _var_int8)
    {
        m_var_int8 = _var_int8;
    }

    /*!
     * @brief This function returns the value of member var_int8
     * @return Value of member var_int8
     */
    eProsima_user_DllExport int8_t var_int8() const
    {
        return m_var_int8;
    }

    /*!
     * @brief This function returns a reference to member var_int8
     * @return Reference to member var_int8
     */
    eProsima_user_DllExport int8_t& var_int8()
    {
        return m_var_int8;
    }



private:

    int8_t m_var_int8{0};

};
/*!
 * @brief This class represents the structure Uint8Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Uint8Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Uint8Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Uint8Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Uint8Struct that will be copied.
     */
    eProsima_user_DllExport Uint8Struct(
            const Uint8Struct& x)
    {
                    m_var_uint8 = x.m_var_uint8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Uint8Struct that will be copied.
     */
    eProsima_user_DllExport Uint8Struct(
            Uint8Struct&& x) noexcept
    {
        m_var_uint8 = x.m_var_uint8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Uint8Struct that will be copied.
     */
    eProsima_user_DllExport Uint8Struct& operator =(
            const Uint8Struct& x)
    {

                    m_var_uint8 = x.m_var_uint8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Uint8Struct that will be copied.
     */
    eProsima_user_DllExport Uint8Struct& operator =(
            Uint8Struct&& x) noexcept
    {

        m_var_uint8 = x.m_var_uint8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint8Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Uint8Struct& x) const
    {
        return (m_var_uint8 == x.m_var_uint8);
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint8Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Uint8Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_uint8
     * @param _var_uint8 New value for member var_uint8
     */
    eProsima_user_DllExport void var_uint8(
            uint8_t _var_uint8)
    {
        m_var_uint8 = _var_uint8;
    }

    /*!
     * @brief This function returns the value of member var_uint8
     * @return Value of member var_uint8
     */
    eProsima_user_DllExport uint8_t var_uint8() const
    {
        return m_var_uint8;
    }

    /*!
     * @brief This function returns a reference to member var_uint8
     * @return Reference to member var_uint8
     */
    eProsima_user_DllExport uint8_t& var_uint8()
    {
        return m_var_uint8;
    }



private:

    uint8_t m_var_uint8{0};

};
/*!
 * @brief This class represents the structure Int16Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Int16Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Int16Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Int16Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Int16Struct that will be copied.
     */
    eProsima_user_DllExport Int16Struct(
            const Int16Struct& x)
    {
                    m_var_int16 = x.m_var_int16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Int16Struct that will be copied.
     */
    eProsima_user_DllExport Int16Struct(
            Int16Struct&& x) noexcept
    {
        m_var_int16 = x.m_var_int16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Int16Struct that will be copied.
     */
    eProsima_user_DllExport Int16Struct& operator =(
            const Int16Struct& x)
    {

                    m_var_int16 = x.m_var_int16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Int16Struct that will be copied.
     */
    eProsima_user_DllExport Int16Struct& operator =(
            Int16Struct&& x) noexcept
    {

        m_var_int16 = x.m_var_int16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Int16Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Int16Struct& x) const
    {
        return (m_var_int16 == x.m_var_int16);
    }

    /*!
     * @brief Comparison operator.
     * @param x Int16Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Int16Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_int16
     * @param _var_int16 New value for member var_int16
     */
    eProsima_user_DllExport void var_int16(
            int16_t _var_int16)
    {
        m_var_int16 = _var_int16;
    }

    /*!
     * @brief This function returns the value of member var_int16
     * @return Value of member var_int16
     */
    eProsima_user_DllExport int16_t var_int16() const
    {
        return m_var_int16;
    }

    /*!
     * @brief This function returns a reference to member var_int16
     * @return Reference to member var_int16
     */
    eProsima_user_DllExport int16_t& var_int16()
    {
        return m_var_int16;
    }



private:

    int16_t m_var_int16{0};

};
/*!
 * @brief This class represents the structure Uint16Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Uint16Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Uint16Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Uint16Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Uint16Struct that will be copied.
     */
    eProsima_user_DllExport Uint16Struct(
            const Uint16Struct& x)
    {
                    m_var_uint16 = x.m_var_uint16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Uint16Struct that will be copied.
     */
    eProsima_user_DllExport Uint16Struct(
            Uint16Struct&& x) noexcept
    {
        m_var_uint16 = x.m_var_uint16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Uint16Struct that will be copied.
     */
    eProsima_user_DllExport Uint16Struct& operator =(
            const Uint16Struct& x)
    {

                    m_var_uint16 = x.m_var_uint16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Uint16Struct that will be copied.
     */
    eProsima_user_DllExport Uint16Struct& operator =(
            Uint16Struct&& x) noexcept
    {

        m_var_uint16 = x.m_var_uint16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint16Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Uint16Struct& x) const
    {
        return (m_var_uint16 == x.m_var_uint16);
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint16Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Uint16Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_uint16
     * @param _var_uint16 New value for member var_uint16
     */
    eProsima_user_DllExport void var_uint16(
            uint16_t _var_uint16)
    {
        m_var_uint16 = _var_uint16;
    }

    /*!
     * @brief This function returns the value of member var_uint16
     * @return Value of member var_uint16
     */
    eProsima_user_DllExport uint16_t var_uint16() const
    {
        return m_var_uint16;
    }

    /*!
     * @brief This function returns a reference to member var_uint16
     * @return Reference to member var_uint16
     */
    eProsima_user_DllExport uint16_t& var_uint16()
    {
        return m_var_uint16;
    }



private:

    uint16_t m_var_uint16{0};

};
/*!
 * @brief This class represents the structure Int32Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Int32Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Int32Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Int32Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Int32Struct that will be copied.
     */
    eProsima_user_DllExport Int32Struct(
            const Int32Struct& x)
    {
                    m_var_int32 = x.m_var_int32;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Int32Struct that will be copied.
     */
    eProsima_user_DllExport Int32Struct(
            Int32Struct&& x) noexcept
    {
        m_var_int32 = x.m_var_int32;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Int32Struct that will be copied.
     */
    eProsima_user_DllExport Int32Struct& operator =(
            const Int32Struct& x)
    {

                    m_var_int32 = x.m_var_int32;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Int32Struct that will be copied.
     */
    eProsima_user_DllExport Int32Struct& operator =(
            Int32Struct&& x) noexcept
    {

        m_var_int32 = x.m_var_int32;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Int32Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Int32Struct& x) const
    {
        return (m_var_int32 == x.m_var_int32);
    }

    /*!
     * @brief Comparison operator.
     * @param x Int32Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Int32Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_int32
     * @param _var_int32 New value for member var_int32
     */
    eProsima_user_DllExport void var_int32(
            int32_t _var_int32)
    {
        m_var_int32 = _var_int32;
    }

    /*!
     * @brief This function returns the value of member var_int32
     * @return Value of member var_int32
     */
    eProsima_user_DllExport int32_t var_int32() const
    {
        return m_var_int32;
    }

    /*!
     * @brief This function returns a reference to member var_int32
     * @return Reference to member var_int32
     */
    eProsima_user_DllExport int32_t& var_int32()
    {
        return m_var_int32;
    }



private:

    int32_t m_var_int32{0};

};
/*!
 * @brief This class represents the structure Uint32Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Uint32Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Uint32Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Uint32Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Uint32Struct that will be copied.
     */
    eProsima_user_DllExport Uint32Struct(
            const Uint32Struct& x)
    {
                    m_var_uint32 = x.m_var_uint32;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Uint32Struct that will be copied.
     */
    eProsima_user_DllExport Uint32Struct(
            Uint32Struct&& x) noexcept
    {
        m_var_uint32 = x.m_var_uint32;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Uint32Struct that will be copied.
     */
    eProsima_user_DllExport Uint32Struct& operator =(
            const Uint32Struct& x)
    {

                    m_var_uint32 = x.m_var_uint32;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Uint32Struct that will be copied.
     */
    eProsima_user_DllExport Uint32Struct& operator =(
            Uint32Struct&& x) noexcept
    {

        m_var_uint32 = x.m_var_uint32;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint32Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Uint32Struct& x) const
    {
        return (m_var_uint32 == x.m_var_uint32);
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint32Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Uint32Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_uint32
     * @param _var_uint32 New value for member var_uint32
     */
    eProsima_user_DllExport void var_uint32(
            uint32_t _var_uint32)
    {
        m_var_uint32 = _var_uint32;
    }

    /*!
     * @brief This function returns the value of member var_uint32
     * @return Value of member var_uint32
     */
    eProsima_user_DllExport uint32_t var_uint32() const
    {
        return m_var_uint32;
    }

    /*!
     * @brief This function returns a reference to member var_uint32
     * @return Reference to member var_uint32
     */
    eProsima_user_DllExport uint32_t& var_uint32()
    {
        return m_var_uint32;
    }



private:

    uint32_t m_var_uint32{0};

};
/*!
 * @brief This class represents the structure Int64Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Int64Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Int64Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Int64Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Int64Struct that will be copied.
     */
    eProsima_user_DllExport Int64Struct(
            const Int64Struct& x)
    {
                    m_var_int64 = x.m_var_int64;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Int64Struct that will be copied.
     */
    eProsima_user_DllExport Int64Struct(
            Int64Struct&& x) noexcept
    {
        m_var_int64 = x.m_var_int64;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Int64Struct that will be copied.
     */
    eProsima_user_DllExport Int64Struct& operator =(
            const Int64Struct& x)
    {

                    m_var_int64 = x.m_var_int64;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Int64Struct that will be copied.
     */
    eProsima_user_DllExport Int64Struct& operator =(
            Int64Struct&& x) noexcept
    {

        m_var_int64 = x.m_var_int64;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Int64Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Int64Struct& x) const
    {
        return (m_var_int64 == x.m_var_int64);
    }

    /*!
     * @brief Comparison operator.
     * @param x Int64Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Int64Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_int64
     * @param _var_int64 New value for member var_int64
     */
    eProsima_user_DllExport void var_int64(
            int64_t _var_int64)
    {
        m_var_int64 = _var_int64;
    }

    /*!
     * @brief This function returns the value of member var_int64
     * @return Value of member var_int64
     */
    eProsima_user_DllExport int64_t var_int64() const
    {
        return m_var_int64;
    }

    /*!
     * @brief This function returns a reference to member var_int64
     * @return Reference to member var_int64
     */
    eProsima_user_DllExport int64_t& var_int64()
    {
        return m_var_int64;
    }



private:

    int64_t m_var_int64{0};

};
/*!
 * @brief This class represents the structure Uint64Struct defined by the user in the IDL file.
 * @ingroup primitives
 */
class Uint64Struct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Uint64Struct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Uint64Struct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Uint64Struct that will be copied.
     */
    eProsima_user_DllExport Uint64Struct(
            const Uint64Struct& x)
    {
                    m_var_uint64 = x.m_var_uint64;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Uint64Struct that will be copied.
     */
    eProsima_user_DllExport Uint64Struct(
            Uint64Struct&& x) noexcept
    {
        m_var_uint64 = x.m_var_uint64;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Uint64Struct that will be copied.
     */
    eProsima_user_DllExport Uint64Struct& operator =(
            const Uint64Struct& x)
    {

                    m_var_uint64 = x.m_var_uint64;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Uint64Struct that will be copied.
     */
    eProsima_user_DllExport Uint64Struct& operator =(
            Uint64Struct&& x) noexcept
    {

        m_var_uint64 = x.m_var_uint64;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint64Struct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Uint64Struct& x) const
    {
        return (m_var_uint64 == x.m_var_uint64);
    }

    /*!
     * @brief Comparison operator.
     * @param x Uint64Struct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Uint64Struct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_uint64
     * @param _var_uint64 New value for member var_uint64
     */
    eProsima_user_DllExport void var_uint64(
            uint64_t _var_uint64)
    {
        m_var_uint64 = _var_uint64;
    }

    /*!
     * @brief This function returns the value of member var_uint64
     * @return Value of member var_uint64
     */
    eProsima_user_DllExport uint64_t var_uint64() const
    {
        return m_var_uint64;
    }

    /*!
     * @brief This function returns a reference to member var_uint64
     * @return Reference to member var_uint64
     */
    eProsima_user_DllExport uint64_t& var_uint64()
    {
        return m_var_uint64;
    }



private:

    uint64_t m_var_uint64{0};

};

#endif // _FAST_DDS_GENERATED_PRIMITIVES_HPP_


