#!/bin/sh
################################################################
# This script used by FAR to move files to Trash
################################################################
# For per user customization - create:
#~/.config/far2l/trash.sh
# note that per-user script must do 'exit 0' at the end if
# no need to continue default implementation of main trash.sh
################################################################

set -e

if [ -x ~/.config/far2l/trash.sh ]; then
. ~/.config/far2l/trash.sh
fi

if command -v kioclient >/dev/null 2>&1; then
	kioclient move "$1" trash:/ 2>"$2"

elif command -v trash-put >/dev/null 2>&1; then
	trash-put "$1" 2>"$2"

elif command -v trash >/dev/null 2>&1; then
	trash put "$1" 2>"$2"

elif command -v trashу >/dev/null 2>&1; then
	trashу put "$1" 2>"$2" 

elif command -v gio >/dev/null 2>&1; then
	gio trash -f -- "$1" 2>"$2"

elif command -v gvfs-trash >/dev/null 2>&1; then
	gvfs-trash -f -- "$1" 2>"$2"

elif command -v osascript >/dev/null 2>&1; then
	osascript -e "tell application \"Finder\" to delete POSIX file \"$1\"" 2>"$2"

else
	echo 'No command-line trash tool available (see supported tools in the $FARHOME/trash.sh)' >"$2"
	exit 1
fi
