/*
 * $Id$
 */

#include <stdio.h>
#include "ruby.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

#ifndef NARRAY_BIGMEM
typedef int    na_shape_t;
#endif

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, na_shape_t, int, na_shape_t *);
extern VALUE dcl_crealary2obj(real *, na_shape_t, int, na_shape_t *);
/* extern VALUE dcl_ccomplexary2obj(complex *, int, char *); */
extern VALUE dcl_clogicalary2obj(logical *, na_shape_t, int, na_shape_t *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_lchreq(obj, ch1, ch2)
    VALUE obj, ch1, ch2;
{
    char *i_ch1;
    char *i_ch2;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(ch1) != T_STRING) {
      ch1 = rb_funcall(ch1, rb_intern("to_str"), 0);
    }
    if (TYPE(ch2) != T_STRING) {
      ch2 = rb_funcall(ch2, rb_intern("to_str"), 0);
    }

    i_ch1 = StringValuePtr(ch1);
    i_ch2 = StringValuePtr(ch2);


    o_rtn_val = lchreq__(i_ch1, i_ch2, (ftnlen)strlen(i_ch1), (ftnlen)strlen(i_ch2));

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_msgdmp(obj, clev, csub, cmsg)
    VALUE obj, clev, csub, cmsg;
{
    char *i_clev;
    char *i_csub;
    char *i_cmsg;

    if (TYPE(clev) != T_STRING) {
      clev = rb_funcall(clev, rb_intern("to_str"), 0);
    }
    if (TYPE(csub) != T_STRING) {
      csub = rb_funcall(csub, rb_intern("to_str"), 0);
    }
    if (TYPE(cmsg) != T_STRING) {
      cmsg = rb_funcall(cmsg, rb_intern("to_str"), 0);
    }

    i_clev = StringValuePtr(clev);
    i_csub = StringValuePtr(csub);
    i_cmsg = StringValuePtr(cmsg);


    msgdmp__(i_clev, i_csub, i_cmsg, (ftnlen)strlen(i_clev), (ftnlen)strlen(i_csub), (ftnlen)strlen(i_cmsg));

    return Qnil;

}

static VALUE
dcl_mszdmp(obj, cmsg, iunit, lnsize)
    VALUE obj, cmsg, iunit, lnsize;
{
    char *i_cmsg;
    integer i_iunit;
    integer i_lnsize;

    if (TYPE(cmsg) != T_STRING) {
      cmsg = rb_funcall(cmsg, rb_intern("to_str"), 0);
    }
    if ((TYPE(iunit) != T_BIGNUM) || (TYPE(iunit) != T_FIXNUM)) {
      iunit = rb_funcall(iunit, rb_intern("to_i"), 0);
    }
    if ((TYPE(lnsize) != T_BIGNUM) || (TYPE(lnsize) != T_FIXNUM)) {
      lnsize = rb_funcall(lnsize, rb_intern("to_i"), 0);
    }

    i_cmsg = StringValuePtr(cmsg);
    i_iunit = NUM2INT(iunit);
    i_lnsize = NUM2INT(lnsize);


    mszdmp__(i_cmsg, &i_iunit, &i_lnsize, (ftnlen)strlen(i_cmsg));

    return Qnil;

}

static VALUE
dcl_glcget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    char *o_cpara;
    VALUE cpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);

    o_cpara= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cpara, '\0', DFLT_SIZE+1);

    glcget__(i_cp, o_cpara, (ftnlen)strlen(i_cp), (ftnlen)DFLT_SIZE);

    cpara = rb_str_new2(o_cpara);


    return cpara;

}

static VALUE
dcl_glcset(obj, cp, cpara)
    VALUE obj, cp, cpara;
{
    char *i_cp;
    char *i_cpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(cpara) != T_STRING) {
      cpara = rb_funcall(cpara, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_cpara = StringValuePtr(cpara);


    glcset__(i_cp, i_cpara, (ftnlen)strlen(i_cp), (ftnlen)strlen(i_cpara));

    return Qnil;

}

static VALUE
dcl_glcstx(obj, cp, cpara)
    VALUE obj, cp, cpara;
{
    char *i_cp;
    char *i_cpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(cpara) != T_STRING) {
      cpara = rb_funcall(cpara, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_cpara = StringValuePtr(cpara);


    glcstx__(i_cp, i_cpara, (ftnlen)strlen(i_cp), (ftnlen)strlen(i_cpara));

    return Qnil;

}

static VALUE
dcl_glqfnm(obj, cpara)
    VALUE obj, cpara;
{
    char *i_cpara;
    char *o_cfname;
    VALUE cfname;

    if (TYPE(cpara) != T_STRING) {
      cpara = rb_funcall(cpara, rb_intern("to_str"), 0);
    }

    i_cpara = StringValuePtr(cpara);

    o_cfname= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cfname, '\0', DFLT_SIZE+1);

    glqfnm__(i_cpara, o_cfname, (ftnlen)strlen(i_cpara), (ftnlen)DFLT_SIZE);

    cfname = rb_str_new2(o_cfname);


    return cfname;

}

static VALUE
dcl_iufopn(obj)
    VALUE obj;
{
    integer o_rtn_val;
    VALUE rtn_val;

    o_rtn_val = iufopn__();

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_cfsrch(obj, cplist, np, cflist, nf)
    VALUE obj, cplist, np, cflist, nf;
{
    char *i_cplist;
    integer i_np;
    char *i_cflist;
    integer i_nf;
    char *o_cfname;
    VALUE cfname;

    if (TYPE(cplist) == T_STRING) {
      cplist = rb_Array(cplist);
    }
    if (TYPE(cplist) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(np) != T_BIGNUM) || (TYPE(np) != T_FIXNUM)) {
      np = rb_funcall(np, rb_intern("to_i"), 0);
    }
    if (TYPE(cflist) == T_STRING) {
      cflist = rb_Array(cflist);
    }
    if (TYPE(cflist) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(nf) != T_BIGNUM) || (TYPE(nf) != T_FIXNUM)) {
      nf = rb_funcall(nf, rb_intern("to_i"), 0);
    }

    i_np = NUM2INT(np);
    i_nf = NUM2INT(nf);
    i_cplist = dcl_obj2ccharary(cplist, (i_np*80), 80);
    i_cflist = dcl_obj2ccharary(cflist, (i_np*80), 80);

    o_cfname= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cfname, '\0', DFLT_SIZE+1);

    cfsrch__(i_cplist, &i_np, i_cflist, &i_nf, o_cfname, (ftnlen)80, (ftnlen)80, (ftnlen)DFLT_SIZE);

    cfname = rb_str_new2(o_cfname);

    dcl_freeccharary(i_cplist);
    dcl_freeccharary(i_cflist);

    return cfname;

}

static VALUE
dcl_glpqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    glpqnp__(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_glpqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    glpqid__(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_glpqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    glpqcp__(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_glpqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    glpqcl__(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_glpqit(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    integer o_itp;
    VALUE itp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    glpqit__(&i_idx, &o_itp);

    itp = INT2NUM(o_itp);


    return itp;

}

static VALUE
dcl_glpqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    integer o_ipara;
    VALUE ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    glpqvl__(&i_idx, &o_ipara);

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_glpsvl(obj, idx, ipara)
    VALUE obj, idx, ipara;
{
    integer i_idx;
    integer i_ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);
    i_ipara = NUM2INT(ipara);


    glpsvl__(&i_idx, &i_ipara);

    return Qnil;

}

static VALUE
dcl_glpqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    glpqin__(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_gliget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    gliget__(i_cp, &o_ipara, (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_gliset(obj, cp, ipara)
    VALUE obj, cp, ipara;
{
    char *i_cp;
    integer i_ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_ipara = NUM2INT(ipara);


    gliset__(i_cp, &i_ipara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_glistx(obj, cp, ipara)
    VALUE obj, cp, ipara;
{
    char *i_cp;
    integer i_ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_ipara = NUM2INT(ipara);


    glistx__(i_cp, &i_ipara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_gllget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    gllget__(i_cp, &o_lpara, (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_gllset(obj, cp, lpara)
    VALUE obj, cp, lpara;
{
    char *i_cp;
    logical i_lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    gllset__(i_cp, &i_lpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_gllstx(obj, cp, lpara)
    VALUE obj, cp, lpara;
{
    char *i_cp;
    logical i_lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    gllstx__(i_cp, &i_lpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_rpnenv(obj)
    VALUE obj;
{
    rpnenv__();

    return Qnil;

}

static VALUE
dcl_rtienv(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtienv__(i_cpfix, i_cp, &o_ipara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_rtlenv(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtlenv__(i_cpfix, i_cp, &o_lpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_rtrenv(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtrenv__(i_cpfix, i_cp, &o_rpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_rtcenv(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    char *o_cpara;
    VALUE cpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);

    o_cpara= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cpara, '\0', DFLT_SIZE+1);

    rtcenv__(i_cpfix, i_cp, o_cpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp), (ftnlen)DFLT_SIZE);

    cpara = rb_str_new2(o_cpara);


    return cpara;

}

static VALUE
dcl_rlienv(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rlienv__(i_cp, &o_ipara, (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_rllenv(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rllenv__(i_cp, &o_lpara, (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_rlrenv(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rlrenv__(i_cp, &o_rpara, (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_rlcenv(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    char *o_cpara;
    VALUE cpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);

    o_cpara= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cpara, '\0', DFLT_SIZE+1);

    rlcenv__(i_cp, o_cpara, (ftnlen)strlen(i_cp), (ftnlen)DFLT_SIZE);

    cpara = rb_str_new2(o_cpara);


    return cpara;

}

static VALUE
dcl_glrget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    glrget__(i_cp, &o_rpara, (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_glrset(obj, cp, rpara)
    VALUE obj, cp, rpara;
{
    char *i_cp;
    real i_rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_rpara = (real)NUM2DBL(rpara);


    glrset__(i_cp, &i_rpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_glrstx(obj, cp, rpara)
    VALUE obj, cp, rpara;
{
    char *i_cp;
    real i_rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_rpara = (real)NUM2DBL(rpara);


    glrstx__(i_cp, &i_rpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_gllqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    gllqnp__(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_gllqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    gllqid__(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_gllqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    gllqcp__(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_gllqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    gllqcl__(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_gllqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    logical o_lpara;
    VALUE lpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    gllqvl__(&i_idx, &o_lpara);

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_gllsvl(obj, idx, lpara)
    VALUE obj, idx, lpara;
{
    integer i_idx;
    logical i_lpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    gllsvl__(&i_idx, &i_lpara);

    return Qnil;

}

static VALUE
dcl_gllqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    gllqin__(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_rpnget(obj)
    VALUE obj;
{
    rpnget__();

    return Qnil;

}

static VALUE
dcl_rtiget(obj, cpfix, cps, max)
    VALUE obj, cpfix, cps, max;
{
    char *i_cpfix;
    char *i_cps;
    integer *o_ipara;
    integer i_max;
    VALUE ipara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cps) == T_STRING) {
      cps = rb_Array(cps);
    }
    if (TYPE(cps) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_max = NUM2INT(max);
    i_cps = dcl_obj2ccharary(cps, (i_max*8), 8);

    o_ipara= ALLOCA_N(integer, (i_max));

    rtiget__(i_cpfix, i_cps, o_ipara, &i_max, (ftnlen)strlen(i_cpfix), (ftnlen)8);

    {int array_shape[1] = {i_max};
     ipara = dcl_cintegerary2obj(o_ipara, (i_max), 1, array_shape);
    }

    dcl_freeccharary(i_cps);

    return ipara;

}

static VALUE
dcl_rtlget(obj, cpfix, cps, max)
    VALUE obj, cpfix, cps, max;
{
    char *i_cpfix;
    char *i_cps;
    logical *o_lpara;
    integer i_max;
    VALUE lpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cps) == T_STRING) {
      cps = rb_Array(cps);
    }
    if (TYPE(cps) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_max = NUM2INT(max);
    i_cps = dcl_obj2ccharary(cps, (i_max*8), 8);

    o_lpara= ALLOCA_N(logical, (i_max));

    rtlget__(i_cpfix, i_cps, o_lpara, &i_max, (ftnlen)strlen(i_cpfix), (ftnlen)8);

    {int array_shape[1] = {i_max};
     lpara = dcl_clogicalary2obj(o_lpara, (i_max), 1, array_shape);
    }

    dcl_freeccharary(i_cps);

    return lpara;

}

static VALUE
dcl_rtrget(obj, cpfix, cps, max)
    VALUE obj, cpfix, cps, max;
{
    char *i_cpfix;
    char *i_cps;
    real *o_rpara;
    integer i_max;
    VALUE rpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cps) == T_STRING) {
      cps = rb_Array(cps);
    }
    if (TYPE(cps) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_max = NUM2INT(max);
    i_cps = dcl_obj2ccharary(cps, (i_max*8), 8);

    o_rpara= ALLOCA_N(real, (i_max));

    rtrget__(i_cpfix, i_cps, o_rpara, &i_max, (ftnlen)strlen(i_cpfix), (ftnlen)8);

    {int array_shape[1] = {i_max};
     rpara = dcl_crealary2obj(o_rpara, (i_max), 1, array_shape);
    }

    dcl_freeccharary(i_cps);

    return rpara;

}

static VALUE
dcl_rtcget(obj, cpfix, cps, max)
    VALUE obj, cpfix, cps, max;
{
    char *i_cpfix;
    char *i_cps;
    char *o_cpara;
    integer i_max;
    VALUE cpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cps) == T_STRING) {
      cps = rb_Array(cps);
    }
    if (TYPE(cps) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_max = NUM2INT(max);
    i_cps = dcl_obj2ccharary(cps, (i_max*8), 8);

    o_cpara= ALLOCA_N(char, (i_max*80));
    memset(o_cpara, '\0', (i_max*80));

    rtcget__(i_cpfix, i_cps, o_cpara, &i_max, (ftnlen)strlen(i_cpfix), (ftnlen)8, (ftnlen)80);

    cpara = dcl_ccharary2obj(o_cpara, (i_max*80), 80);

    dcl_freeccharary(i_cps);

    return cpara;

}

static VALUE
dcl_rliget(obj, cpl, max)
    VALUE obj, cpl, max;
{
    char *i_cpl;
    integer *o_ipara;
    integer i_max;
    VALUE ipara;

    if (TYPE(cpl) == T_STRING) {
      cpl = rb_Array(cpl);
    }
    if (TYPE(cpl) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_max = NUM2INT(max);
    i_cpl = dcl_obj2ccharary(cpl, (i_max*40), 40);

    o_ipara= ALLOCA_N(integer, (i_max));

    rliget__(i_cpl, o_ipara, &i_max, (ftnlen)40);

    {int array_shape[1] = {i_max};
     ipara = dcl_cintegerary2obj(o_ipara, (i_max), 1, array_shape);
    }

    dcl_freeccharary(i_cpl);

    return ipara;

}

static VALUE
dcl_rllget(obj, cpl, max)
    VALUE obj, cpl, max;
{
    char *i_cpl;
    logical *o_lpara;
    integer i_max;
    VALUE lpara;

    if (TYPE(cpl) == T_STRING) {
      cpl = rb_Array(cpl);
    }
    if (TYPE(cpl) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_max = NUM2INT(max);
    i_cpl = dcl_obj2ccharary(cpl, (i_max*40), 40);

    o_lpara= ALLOCA_N(logical, (i_max));

    rllget__(i_cpl, o_lpara, &i_max, (ftnlen)40);

    {int array_shape[1] = {i_max};
     lpara = dcl_clogicalary2obj(o_lpara, (i_max), 1, array_shape);
    }

    dcl_freeccharary(i_cpl);

    return lpara;

}

static VALUE
dcl_rlrget(obj, cpl, max)
    VALUE obj, cpl, max;
{
    char *i_cpl;
    real *o_rpara;
    integer i_max;
    VALUE rpara;

    if (TYPE(cpl) == T_STRING) {
      cpl = rb_Array(cpl);
    }
    if (TYPE(cpl) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_max = NUM2INT(max);
    i_cpl = dcl_obj2ccharary(cpl, (i_max*40), 40);

    o_rpara= ALLOCA_N(real, (i_max));

    rlrget__(i_cpl, o_rpara, &i_max, (ftnlen)40);

    {int array_shape[1] = {i_max};
     rpara = dcl_crealary2obj(o_rpara, (i_max), 1, array_shape);
    }

    dcl_freeccharary(i_cpl);

    return rpara;

}

static VALUE
dcl_rlcget(obj, cpl, max)
    VALUE obj, cpl, max;
{
    char *i_cpl;
    char *o_cpara;
    integer i_max;
    VALUE cpara;

    if (TYPE(cpl) == T_STRING) {
      cpl = rb_Array(cpl);
    }
    if (TYPE(cpl) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(max) != T_BIGNUM) || (TYPE(max) != T_FIXNUM)) {
      max = rb_funcall(max, rb_intern("to_i"), 0);
    }

    i_max = NUM2INT(max);
    i_cpl = dcl_obj2ccharary(cpl, (i_max*40), 40);

    o_cpara= ALLOCA_N(char, (i_max*80));
    memset(o_cpara, '\0', (i_max*80));

    rlcget__(i_cpl, o_cpara, &i_max, (ftnlen)40, (ftnlen)80);

    cpara = dcl_ccharary2obj(o_cpara, (i_max*80), 80);

    dcl_freeccharary(i_cpl);

    return cpara;

}

static VALUE
dcl_rpnopt(obj)
    VALUE obj;
{
    rpnopt__();

    return Qnil;

}

static VALUE
dcl_rtiopt(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtiopt__(i_cpfix, i_cp, &o_ipara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_rtlopt(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtlopt__(i_cpfix, i_cp, &o_lpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_rtropt(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtropt__(i_cpfix, i_cp, &o_rpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_rtcopt(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    char *o_cpara;
    VALUE cpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);

    o_cpara= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cpara, '\0', DFLT_SIZE+1);

    rtcopt__(i_cpfix, i_cp, o_cpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp), (ftnlen)DFLT_SIZE);

    cpara = rb_str_new2(o_cpara);


    return cpara;

}

static VALUE
dcl_rliopt(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rliopt__(i_cp, &o_ipara, (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_rllopt(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rllopt__(i_cp, &o_lpara, (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_rlropt(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rlropt__(i_cp, &o_rpara, (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_rlcopt(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    char *o_cpara;
    VALUE cpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);

    o_cpara= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cpara, '\0', DFLT_SIZE+1);

    rlcopt__(i_cp, o_cpara, (ftnlen)strlen(i_cp), (ftnlen)DFLT_SIZE);

    cpara = rb_str_new2(o_cpara);


    return cpara;

}

static VALUE
dcl_rpnxfl(obj)
    VALUE obj;
{
    rpnxfl__();

    return Qnil;

}

static VALUE
dcl_rtixfl(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtixfl__(i_cpfix, i_cp, &o_ipara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_rtlxfl(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtlxfl__(i_cpfix, i_cp, &o_lpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_rtrxfl(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);


    rtrxfl__(i_cpfix, i_cp, &o_rpara, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_rtcxfl(obj, cpfix, cp)
    VALUE obj, cpfix, cp;
{
    char *i_cpfix;
    char *i_cp;
    char *o_cval;
    VALUE cval;

    if (TYPE(cpfix) != T_STRING) {
      cpfix = rb_funcall(cpfix, rb_intern("to_str"), 0);
    }
    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cpfix = StringValuePtr(cpfix);
    i_cp = StringValuePtr(cp);

    o_cval= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cval, '\0', DFLT_SIZE+1);

    rtcxfl__(i_cpfix, i_cp, o_cval, (ftnlen)strlen(i_cpfix), (ftnlen)strlen(i_cp), (ftnlen)DFLT_SIZE);

    cval = rb_str_new2(o_cval);


    return cval;

}

static VALUE
dcl_rlixfl(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rlixfl__(i_cp, &o_ipara, (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_rllxfl(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rllxfl__(i_cp, &o_lpara, (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_rlrxfl(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    rlrxfl__(i_cp, &o_rpara, (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_rlcxfl(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    char *o_cval;
    VALUE cval;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);

    o_cval= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cval, '\0', DFLT_SIZE+1);

    rlcxfl__(i_cp, o_cval, (ftnlen)strlen(i_cp), (ftnlen)DFLT_SIZE);

    cval = rb_str_new2(o_cval);


    return cval;

}

static VALUE
dcl_prcopn(obj, cproc)
    VALUE obj, cproc;
{
    char *i_cproc;

    if (TYPE(cproc) != T_STRING) {
      cproc = rb_funcall(cproc, rb_intern("to_str"), 0);
    }

    i_cproc = StringValuePtr(cproc);


    prcopn__(i_cproc, (ftnlen)strlen(i_cproc));

    return Qnil;

}

static VALUE
dcl_prccls(obj, cproc)
    VALUE obj, cproc;
{
    char *i_cproc;

    if (TYPE(cproc) != T_STRING) {
      cproc = rb_funcall(cproc, rb_intern("to_str"), 0);
    }

    i_cproc = StringValuePtr(cproc);


    prccls__(i_cproc, (ftnlen)strlen(i_cproc));

    return Qnil;

}

static VALUE
dcl_prclvl(obj)
    VALUE obj;
{
    integer o_nlev;
    VALUE nlev;

    prclvl__(&o_nlev);

    nlev = INT2NUM(o_nlev);


    return nlev;

}

static VALUE
dcl_prcnam(obj, nlev)
    VALUE obj, nlev;
{
    integer i_nlev;
    char *o_cproc;
    VALUE cproc;

    if ((TYPE(nlev) != T_BIGNUM) || (TYPE(nlev) != T_FIXNUM)) {
      nlev = rb_funcall(nlev, rb_intern("to_i"), 0);
    }

    i_nlev = NUM2INT(nlev);

    o_cproc= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cproc, '\0', DFLT_SIZE+1);

    prcnam__(&i_nlev, o_cproc, (ftnlen)DFLT_SIZE);

    cproc = rb_str_new2(o_cproc);


    return cproc;

}
void
init_math1_syslib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "lchreq", dcl_lchreq, 2);
    rb_define_module_function(mDCL, "msgdmp", dcl_msgdmp, 3);
    rb_define_module_function(mDCL, "mszdmp", dcl_mszdmp, 3);
    rb_define_module_function(mDCL, "glcget", dcl_glcget, 1);
    rb_define_module_function(mDCL, "glcset", dcl_glcset, 2);
    rb_define_module_function(mDCL, "glcstx", dcl_glcstx, 2);
    rb_define_module_function(mDCL, "glqfnm", dcl_glqfnm, 1);
    rb_define_module_function(mDCL, "iufopn", dcl_iufopn, 0);
    rb_define_module_function(mDCL, "cfsrch", dcl_cfsrch, 4);
    rb_define_module_function(mDCL, "glpqnp", dcl_glpqnp, 0);
    rb_define_module_function(mDCL, "glpqid", dcl_glpqid, 1);
    rb_define_module_function(mDCL, "glpqcp", dcl_glpqcp, 1);
    rb_define_module_function(mDCL, "glpqcl", dcl_glpqcl, 1);
    rb_define_module_function(mDCL, "glpqit", dcl_glpqit, 1);
    rb_define_module_function(mDCL, "glpqvl", dcl_glpqvl, 1);
    rb_define_module_function(mDCL, "glpsvl", dcl_glpsvl, 2);
    rb_define_module_function(mDCL, "glpqin", dcl_glpqin, 1);
    rb_define_module_function(mDCL, "gliget", dcl_gliget, 1);
    rb_define_module_function(mDCL, "gliset", dcl_gliset, 2);
    rb_define_module_function(mDCL, "glistx", dcl_glistx, 2);
    rb_define_module_function(mDCL, "gllget", dcl_gllget, 1);
    rb_define_module_function(mDCL, "gllset", dcl_gllset, 2);
    rb_define_module_function(mDCL, "gllstx", dcl_gllstx, 2);
    rb_define_module_function(mDCL, "rpnenv", dcl_rpnenv, 0);
    rb_define_module_function(mDCL, "rtienv", dcl_rtienv, 2);
    rb_define_module_function(mDCL, "rtlenv", dcl_rtlenv, 2);
    rb_define_module_function(mDCL, "rtrenv", dcl_rtrenv, 2);
    rb_define_module_function(mDCL, "rtcenv", dcl_rtcenv, 2);
    rb_define_module_function(mDCL, "rlienv", dcl_rlienv, 1);
    rb_define_module_function(mDCL, "rllenv", dcl_rllenv, 1);
    rb_define_module_function(mDCL, "rlrenv", dcl_rlrenv, 1);
    rb_define_module_function(mDCL, "rlcenv", dcl_rlcenv, 1);
    rb_define_module_function(mDCL, "glrget", dcl_glrget, 1);
    rb_define_module_function(mDCL, "glrset", dcl_glrset, 2);
    rb_define_module_function(mDCL, "glrstx", dcl_glrstx, 2);
    rb_define_module_function(mDCL, "gllqnp", dcl_gllqnp, 0);
    rb_define_module_function(mDCL, "gllqid", dcl_gllqid, 1);
    rb_define_module_function(mDCL, "gllqcp", dcl_gllqcp, 1);
    rb_define_module_function(mDCL, "gllqcl", dcl_gllqcl, 1);
    rb_define_module_function(mDCL, "gllqvl", dcl_gllqvl, 1);
    rb_define_module_function(mDCL, "gllsvl", dcl_gllsvl, 2);
    rb_define_module_function(mDCL, "gllqin", dcl_gllqin, 1);
    rb_define_module_function(mDCL, "rpnget", dcl_rpnget, 0);
    rb_define_module_function(mDCL, "rtiget", dcl_rtiget, 3);
    rb_define_module_function(mDCL, "rtlget", dcl_rtlget, 3);
    rb_define_module_function(mDCL, "rtrget", dcl_rtrget, 3);
    rb_define_module_function(mDCL, "rtcget", dcl_rtcget, 3);
    rb_define_module_function(mDCL, "rliget", dcl_rliget, 2);
    rb_define_module_function(mDCL, "rllget", dcl_rllget, 2);
    rb_define_module_function(mDCL, "rlrget", dcl_rlrget, 2);
    rb_define_module_function(mDCL, "rlcget", dcl_rlcget, 2);
    rb_define_module_function(mDCL, "rpnopt", dcl_rpnopt, 0);
    rb_define_module_function(mDCL, "rtiopt", dcl_rtiopt, 2);
    rb_define_module_function(mDCL, "rtlopt", dcl_rtlopt, 2);
    rb_define_module_function(mDCL, "rtropt", dcl_rtropt, 2);
    rb_define_module_function(mDCL, "rtcopt", dcl_rtcopt, 2);
    rb_define_module_function(mDCL, "rliopt", dcl_rliopt, 1);
    rb_define_module_function(mDCL, "rllopt", dcl_rllopt, 1);
    rb_define_module_function(mDCL, "rlropt", dcl_rlropt, 1);
    rb_define_module_function(mDCL, "rlcopt", dcl_rlcopt, 1);
    rb_define_module_function(mDCL, "rpnxfl", dcl_rpnxfl, 0);
    rb_define_module_function(mDCL, "rtixfl", dcl_rtixfl, 2);
    rb_define_module_function(mDCL, "rtlxfl", dcl_rtlxfl, 2);
    rb_define_module_function(mDCL, "rtrxfl", dcl_rtrxfl, 2);
    rb_define_module_function(mDCL, "rtcxfl", dcl_rtcxfl, 2);
    rb_define_module_function(mDCL, "rlixfl", dcl_rlixfl, 1);
    rb_define_module_function(mDCL, "rllxfl", dcl_rllxfl, 1);
    rb_define_module_function(mDCL, "rlrxfl", dcl_rlrxfl, 1);
    rb_define_module_function(mDCL, "rlcxfl", dcl_rlcxfl, 1);
    rb_define_module_function(mDCL, "prcopn", dcl_prcopn, 1);
    rb_define_module_function(mDCL, "prccls", dcl_prccls, 1);
    rb_define_module_function(mDCL, "prclvl", dcl_prclvl, 0);
    rb_define_module_function(mDCL, "prcnam", dcl_prcnam, 1);
}
