/*
 * $Id$
 */

#include <stdio.h>
#include "ruby.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

#ifndef NARRAY_BIGMEM
typedef int    na_shape_t;
#endif

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, na_shape_t, int, na_shape_t *);
extern VALUE dcl_crealary2obj(real *, na_shape_t, int, na_shape_t *);
/* extern VALUE dcl_ccomplexary2obj(complex *, int, char *); */
extern VALUE dcl_clogicalary2obj(logical *, na_shape_t, int, na_shape_t *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_mpscon(obj, ylat0)
    VALUE obj, ylat0;
{
    real i_ylat0;

    if (TYPE(ylat0) != T_FLOAT) {
      ylat0 = rb_funcall(ylat0, rb_intern("to_f"), 0);
    }

    i_ylat0 = (real)NUM2DBL(ylat0);


    mpscon__(&i_ylat0);

    return Qnil;

}

static VALUE
dcl_mpscoa(obj, ylat1)
    VALUE obj, ylat1;
{
    real i_ylat1;

    if (TYPE(ylat1) != T_FLOAT) {
      ylat1 = rb_funcall(ylat1, rb_intern("to_f"), 0);
    }

    i_ylat1 = (real)NUM2DBL(ylat1);


    mpscoa__(&i_ylat1);

    return Qnil;

}

static VALUE
dcl_mpscoc(obj, ylat1, ylat2)
    VALUE obj, ylat1, ylat2;
{
    real i_ylat1;
    real i_ylat2;

    if (TYPE(ylat1) != T_FLOAT) {
      ylat1 = rb_funcall(ylat1, rb_intern("to_f"), 0);
    }
    if (TYPE(ylat2) != T_FLOAT) {
      ylat2 = rb_funcall(ylat2, rb_intern("to_f"), 0);
    }

    i_ylat1 = (real)NUM2DBL(ylat1);
    i_ylat2 = (real)NUM2DBL(ylat2);


    mpscoc__(&i_ylat1, &i_ylat2);

    return Qnil;

}

static VALUE
dcl_mpsbon(obj, ylat1)
    VALUE obj, ylat1;
{
    real i_ylat1;

    if (TYPE(ylat1) != T_FLOAT) {
      ylat1 = rb_funcall(ylat1, rb_intern("to_f"), 0);
    }

    i_ylat1 = (real)NUM2DBL(ylat1);


    mpsbon__(&i_ylat1);

    return Qnil;

}

static VALUE
dcl_mpsotg(obj, rsat)
    VALUE obj, rsat;
{
    real i_rsat;

    if (TYPE(rsat) != T_FLOAT) {
      rsat = rb_funcall(rsat, rb_intern("to_f"), 0);
    }

    i_rsat = (real)NUM2DBL(rsat);


    mpsotg__(&i_rsat);

    return Qnil;

}
void
init_math1_maplib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "mpscon", dcl_mpscon, 1);
    rb_define_module_function(mDCL, "mpscoa", dcl_mpscoa, 1);
    rb_define_module_function(mDCL, "mpscoc", dcl_mpscoc, 2);
    rb_define_module_function(mDCL, "mpsbon", dcl_mpsbon, 1);
    rb_define_module_function(mDCL, "mpsotg", dcl_mpsotg, 1);
}
