!----------------------------------------------------------------------
! Copyright (c) 2012--2013 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_base_mpi_module_sjpack
!
!  spml/w_base_mpi_module_sjpack ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
!  ⥸塼 w_mpi_module_sjpack β⥸塼Ǥ, ڥȥ׻
!  Ū Fortran90 ؿ󶡤. 
!
!   ISPACK  SJPACK-MPI  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK-MPI Υޥ˥奢򻲾Ȥ줿.
!
!
!  2012/03/31  ݹ  w_base_mpi_module  sjpack 
!      2012/04/02  ݹ  ʻ private ѿ
!      2013/02/12  ݹ  w_StreamPotential2VectorMPI,  
!                            w_Vector2VorDivMPI Ƴ
!      2013/02/15  ݹ  w_VectorCosLat2VorDivMPI Ƴ
!      2013/02/23  ݹ  w_base_mpi_Finalize Ƴ
!
module w_base_mpi_module_sjpack
  !
  ! w_base_mpi_module_sjpack
  !
  !  spml/w_base_mpi_module_sjpack ⥸塼ϵ̾Ǥ 2 ήαư
  !  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
  !  ⥸塼 w_mpi_module_sjpack β⥸塼Ǥ, ڥȥˡ
  !  Ūʤ Fortran90 ؿ󶡤. 
  !
  !   ISPACK  SJPACK-MPI  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use dc_message
  use w_base_module_sjpack, only : im, jm, nn, nm, mm, openmp, np, x_Lon

  implicit none

  real(8), allocatable  :: p(:), r(:)       ! Ѵ
  integer               :: it(4)            ! Ѵ
  real(8), allocatable  :: t(:)             ! Ѵ

  real(8), allocatable  :: c(:)             ! 

  integer               :: jc               ! ʬѿ

  real(8), allocatable  :: y(:,:)           ! 

  real(8), allocatable  :: v_Lat(:),v_Lat_Weight(:)      ! ٷ
  real(8), allocatable  :: xv_Lon(:,:), xv_Lat(:,:)

  logical               :: w_base_initialize=.false.   ! եå

  private
  private im, jm, nn, mm, nm                  ! ʻ, ȿ

  public it, t, p, r                          ! ѴѺ
  public openmp, np                           ! OPENMP ѿ
  public jc                                   ! ʬѿ

  public w_base_mpi_Initial                   ! ֥롼
  public w_base_mpi_Finalize                  ! λ֥롼

  public v_Lat                                ! ʻҺɸ
  public v_Lat_Weight                         ! ʻҺɸŤ
  public xv_Lon, xv_Lat                       ! ʻҺɸ(im,jm)
  public xv_w, w_xv                           ! Ѵؿ
  public w_StreamPotential2VectorMPI          ! ήݥƥ󥷥뤫®پ׻
  public w_Vector2VorDivMPI                   ! ®پ줫鱲ȯ׻
  public w_VectorCosLat2VorDivMPI             ! ®پ줫鱲ȯ׻

  save it, t, p, r                            ! Ѵ򵭲
  save c                                      ! Ѵ礭
  save jc                                     ! ʬʻ礭
  save w_base_initialize                      ! ե饰


  contains
  !---------------  -----------------
    subroutine w_base_mpi_Initial
      !
      ! ڥȥѴγʻ, ȿ OPENMP ѻ
      ! 祹åɿꤹ.
      !
      ! ºݤλѤˤϾ̥֥롼 w_Initial Ѥ뤳.
      !
      integer :: i, j

      allocate(p(jm/2*(mm+4)))                ! Ѵ
      allocate(r((mm+1)*(2*nm-mm-1)+1))       ! Ѵ
      allocate(t(im*6))                       ! Ѵ

      allocate(c((mm+1)*(mm+1)))              ! ѴѺ

      !  : ̥롼ˤä w_base_Initial ƤǤ뤳Ȥ
      call sjpini(mm,nm,jm,jc,im,p,r,it,t)
      call sjinic(mm,c)

      allocate(v_Lat(jc),v_Lat_Weight(jc))             ! ʻɸǼ

      allocate(xv_Lon(0:im-1,jc),xv_Lat(0:im-1,jc))   ! ʻɸǼ

      allocate(y(jc/2,mm+4))
      y = reshape(p(1:jc/2*(mm+4)),(/jc/2,mm+4/))

      do j=1,jc/2
         v_Lat(jc/2+j)   =  asin(y(j,1))        ! ٺɸ
         v_Lat(jc/2-j+1) = -asin(y(j,1))        ! ٺɸ
         v_Lat_Weight(jc/2+j)   = 2*y(j,2)      ! ٽŤ(Gauss grid)
         v_Lat_Weight(jc/2-j+1) = 2*y(j,2)      ! ٽŤ(Gauss grid)
      enddo
  
      do j=1,jc
         xv_Lon(:,j) = x_Lon
      enddo

      do i=0,im-1
         xv_Lat(i,:) = v_Lat
      enddo

      w_base_initialize = .true.

      call MessageNotify('M','w_base_mpi_initial',&
                         'w_base_mpi_module_sjpack (2013/02/23) is initialized')
    end subroutine w_base_mpi_Initial

  !--------------- Ѵ(ʻʬ) -----------------

    function xv_w(w_data,ipow,iflag)
      !
      ! ڥȥǡʻҥǡѴ(1 ).
      !
      real(8)               :: xv_w(0:im-1,1:jc)
      !(out) ʻǡ

      real(8), intent(in)   :: w_data((mm+1)*(mm+1))
      !(in) ڥȥǡ

      integer, intent(in), optional  :: ipow      
      !(in) Ѥ 1/cos μ. ά 0. 

      integer, intent(in), optional  :: iflag
      !(in) Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ
      !    1 : ʬ cosա/ߦ ѤѴ
      !    2 : sinդѤѴ
      !    ά 0.
      !
      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval

      real(8)             :: w_Rdata((2*nn+1-mm)*mm+nn+1)
      ! ѥڥȥǡ(SJTS2G )
      real(8)             :: w_Xdata((mm+1)*(mm+1))
      ! ѥڥȥǡ(SJCS2X )
      real(8)             :: w_Ydata((mm+4)*mm+2)
      ! ѥڥȥǡ(SJCS2Y )

      real(8)  :: q(jm/2*7*np)               ! ѴѺ
      real(8)  :: ws(2*(nn+1)*np)            ! ѴѺ
      real(8)  :: ws2(2*(nm+1)*np)           ! ѴѺ
      real(8)  :: wg((im+2)*jm)              ! ѴѺ
      real(8)  :: w((jm+1)*im)               ! ѴѺ

      logical :: first=.true.                    ! Ƚꥹå
      save first

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','xv_w',&
              'w_base_mpi_module_sjpack not initialize yet.')
      endif

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      if ( openmp .and. first ) then
         call MessageNotify('M','xy_w', &
              'OpenMP routine SJTSOG/SJPACK-MPI is used for spherical harmonic transformation.')
      endif

      if ( ifval==0 ) then
         call sjcrup(mm,nn,w_data,w_Rdata)
         if ( openmp ) then
            call sjtsog(mm,nm,nn,im,jc,w_Rdata,xv_w,&
                        it,t,p,q,r,ws,wg,w,ipval)
         else
            call sjts2g(mm,nm,nn,im,jc,w_Rdata,xv_w,&
                        it,t,p,q,r,ws,wg,w,ipval)
         endif
      else if( ifval==-1 ) then
         call sjcs2x(mm,w_data,w_Xdata)
         call sjcrup(mm,nn,w_Xdata,w_Rdata)
         if ( openmp ) then
            call sjtsog(mm,nm,nn,im,jc,w_Rdata,xv_w,&
                        it,t,p,q,r,ws,wg,w,ipval)
         else
            call sjts2g(mm,nm,nn,im,jc,w_Rdata,xv_w,&
                        it,t,p,q,r,ws,wg,w,ipval)
         endif
      else if( ifval==1 ) then
         call sjcs2y(mm,w_data,w_Ydata,c)
         if ( openmp ) then
            call sjtsog(mm,nm,nm,im,jc,w_Ydata,xv_w,&
                        it,t,p,q,r,ws2,wg,w,ipval)
         else
            call sjts2g(mm,nm,nm,im,jc,w_Ydata,xv_w,&
                        it,t,p,q,r,ws2,wg,w,ipval)
         endif
      else if( ifval==2 ) then
         call sjcrup(mm,nn,w_data,w_Rdata)
         if ( openmp ) then
            call sjtsog(mm,nm,nn,im,jc,w_Rdata,xv_w,&
                        it,t,p,q,r,ws,wg,w,ipval)
         else
            call sjts2g(mm,nm,nn,im,jc,w_Rdata,xv_w,&
                        it,t,p,q,r,ws,wg,w,ipval)
         endif
         xv_w = xv_w * sin(xv_Lat)
      else
         call MessageNotify('E','xv_w','invalid value of iflag')
      endif

      first = .false.

    end function xv_w

    function w_xv(xv_data,ipow,iflag)
      !
      ! ʻҥǡ饹ڥȥǡ()Ѵ(1 ).
      !
      real(8)               :: w_xv((mm+1)*(mm+1))
      !(out) ڥȥǡ

      real(8), intent(in)   :: xv_data(0:im-1,1:jc)
      !(in) ʻǡ

      integer, intent(in), optional  :: ipow
      !(in) ѴƱ˺Ѥ 1/cos μ. ά 0.

      integer, intent(in), optional  :: iflag
      ! Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ 
      !    1 : ʬ 1/cosա(f cos^2)/ߦ ѤѴ
      !    2 : sinդѤѴ
      !  ά 0.


      integer, parameter  :: ipow_default  = 0    ! åǥե
      integer, parameter  :: iflag_default = 0    ! åǥե

      integer ipval, ifval

      real(8)             :: w_Rdata((2*nn+1-mm)*mm+nn+1)
      ! ѥڥȥǡ(SJTS2G )
      real(8)             :: w_Xdata((mm+1)*(mm+1))
      ! ѥڥȥǡ(SJCS2X )
      real(8)             :: w_Ydata((mm+4)*nm+2)
      ! ѥڥȥǡ(SJCY2S )

      real(8)  :: q(jm/2*7*np)               ! ѴѺ
      real(8)  :: ws(2*(nn+1)*np+(2*NN+1-MM)*MM+NN+1)  ! ѴѺ
      real(8)  :: ws2(2*(nm+1)*np+(2*NM+1-MM)*MM+NM+1) ! ѴѺ
      real(8)  :: wg((im+2)*jm)              ! ѴѺ
      real(8)  :: w((jm+1)*im)               ! ѴѺ

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','xv_w',&
              'w_base_mpi_module_sjpack not initialize yet.')
      endif

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif
      
      if ( openmp .and. first ) then
         call MessageNotify('M','w_xv', &
              'OpenMP routine SJPGOS/SJPACK-MPI is used for spherical harmonic transformation.')
      endif

      if ( ifval == 0 ) then
         if ( openmp ) then
            call sjpgos(mm,nm,nn,im,jc,w_Rdata,xv_data,&
                        it,t,p,q,r,ws,wg,w,ipval)
         else
            call sjpg2s(mm,nm,nn,im,jc,w_Rdata,xv_data,&
                        it,t,p,q,r,ws,wg,w,ipval)
         endif
         call sjcrdn(mm,nn,w_Rdata,w_xv)
      else if ( ifval == -1 ) then
         if ( openmp ) then
            call sjpgos(mm,nm,nn,im,jc,w_Rdata,xv_data,&
                        it,t,p,q,r,ws,wg,w,ipval)
         else
            call sjpg2s(mm,nm,nn,im,jc,w_Rdata,xv_data,&
                        it,t,p,q,r,ws,wg,w,ipval)
         endif
         call sjcrdn(mm,nn,w_Rdata,w_Xdata)
         call sjcs2x(mm,w_Xdata,w_xv)
      else if ( ifval == 1 ) then
         if ( openmp ) then
            call sjpgos(mm,nm,nm,im,jc,w_Ydata,xv_data,&
                        it,t,p,q,r,ws2,wg,w,ipval)
         else
            call sjpg2s(mm,nm,nm,im,jc,w_Ydata,xv_data,&
                        it,t,p,q,r,ws2,wg,w,ipval)
         endif
         call sjcy2s(mm,w_Ydata,w_xv,c)
      else if ( ifval == 2 ) then
         if ( openmp ) then
            call sjpgos(mm,nm,nn,im,jc,w_Rdata,xv_data*sin(xv_Lat),&
                        it,t,p,q,r,ws,wg,w,ipval)
         else
            call sjpg2s(mm,nm,nn,im,jc,w_Rdata,xv_data*sin(xv_Lat),&
                        it,t,p,q,r,ws,wg,w,ipval)
         endif
         call sjcrdn(mm,nn,w_Rdata,w_xv)
      end if

      first = .false.

    end function w_xv

  !----------- ®, ١ȯ, ήݥƥ󥷥׻ -------------

    subroutine w_StreamPotential2VectorMPI(w_Psi, w_Chi, xv_U, xv_V)
      !
      ! ήݥƥ󥷥(ڥȥǡ)®پ(ʻҥǡ)
      ! ()Ѵ(1 , MPI)
      !
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !   u cos =      ߦ/ߦ - cosբߦ/ߦ, 
      !   v cos = cosբߦ/ߦ +      ߦ/ߦ 
      !
      real(8), intent(in)   :: w_Psi((mm+1)*(mm+1))
      !(in) ήؿ
      real(8), intent(in)   :: w_Chi((mm+1)*(mm+1))
      !(in) ®٥ݥƥ󥷥

      real(8), intent(out)   :: xv_U(0:im-1,1:jc)
      !(out) ®ٷʬ
      real(8), intent(out)   :: xv_V(0:im-1,1:jc)
      !(out) ®ٰʬ

      real(8)             :: w_Rdata((mm+4)*mm+2)
      ! ѥڥȥǡ(SJTS2G )
      real(8)             :: w_Xdata((mm+1)*(mm+1))
      ! ѥڥȥǡ(SJCS2X )
      real(8)             :: w_Ydata((mm+4)*mm+2)
      ! ѥڥȥǡ(SJCS2Y )

      real(8)  :: q(jm/2*7*np)               ! ѴѺ
      real(8)  :: ws2(2*(nm+1)*np)           ! ѴѺ
      real(8)  :: wg((im+2)*jm)              ! ѴѺ
      real(8)  :: w((jm+1)*im)               ! ѴѺ

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_StreamPotential2VectorMPI',&
              'w_base_module not initialize yet.')
      endif

      if ( openmp .and. first ) then
         call MessageNotify('M','w_StreamPotential2Vector', &
              'OpenMP routine SJTSOG/SNPACK-MPI is used for spherical harmonic transformation.')
      endif
      first = .false.

      !
      !   u cos = ߦ/ߦ - cosբߦ/ߦ η׻
      !
      call sjcs2x(mm,w_Chi,w_Xdata)
      call sjcs2y(mm,w_Psi,w_Ydata,c)
      call sjcrup(mm,nm,w_Xdata,w_Rdata)
      w_Rdata = w_Rdata - w_Ydata
      !
      !   u η׻
      !
      if ( openmp ) then
         call sjtsog(mm,nm,nm,im,jc,w_Rdata,xv_U,&
                        it,t,p,q,r,ws2,wg,w,1)
      else
         call sjts2g(mm,nm,nm,im,jc,w_Rdata,xv_U,&
              it,t,p,q,r,ws2,wg,w,1)
      endif
      !
      !   v cos = cosբߦ/ߦ + ߦ/ߦ η׻
      !
      call sjcs2y(mm,w_Chi,w_Ydata,c)
      call sjcs2x(mm,w_Psi,w_Xdata)
      call sjcrup(mm,nm,w_Xdata,w_Rdata)
      w_Rdata= w_Rdata + w_Ydata
      !
      !   v η׻
      !
      if ( openmp ) then
         call sjtsog(mm,nm,nm,im,jc,w_Rdata,xv_V,&
                        it,t,p,q,r,ws2,wg,w,1)
      else
         call sjts2g(mm,nm,nm,im,jc,w_Rdata,xv_V,&
              it,t,p,q,r,ws2,wg,w,1)
      endif

    end subroutine w_StreamPotential2VectorMPI

    subroutine w_Vector2VorDivMPI(xv_U, xv_V, w_Vor, w_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(1 , MPI)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xv_U(0:im-1,1:jc)
      !(in) ®ٷʬ
      real(8), intent(in)   :: xv_V(0:im-1,1:jc)
      !(in) ®ٰʬ

      real(8), intent(out)   :: w_Vor((mm+1)*(mm+1))
      !(out) ήؿ
      real(8), intent(out)   :: w_Div((mm+1)*(mm+1))
      !(out) ®٥ݥƥ󥷥

      real(8)             :: w_Xdata((mm+1)*(mm+1))
      ! ѥڥȥǡ(SJCS2X )
      real(8)             :: w_Ydata((mm+4)*nm+2)
      ! ѥڥȥǡ(SJCY2S )

      real(8)  :: w_Data1((mm+1)*(mm+1))
      real(8)  :: w_Data2((mm+1)*(mm+1))

      real(8)  :: q(jm/2*7*np)               ! ѴѺ
      real(8)  :: ws2(2*(nm+1)*np+(2*NM+1-MM)*MM+NM+1) ! ѴѺ
      real(8)  :: wg((im+2)*jm)              ! ѴѺ
      real(8)  :: w((jm+1)*im)               ! ѴѺ

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_Vector2VorDivMPI',&
              'w_base_module not initialize yet.')
      endif

      if ( openmp .and. first ) then
         call MessageNotify('M','w_Vector2VorDiv', &
              'OpenMP routine SJPGOS/SNPACK-MPI is used for spherical harmonic transformation.')
      endif
      first = .false.

      !
      ! 1/cosբu/ߦ, 1/cos (u cos)/ߦ η׻
      !
      if ( openmp ) then
         call sjpgos(mm,nm,nm,im,jc,w_Ydata,xv_U,&
              it,t,p,q,r,ws2,wg,w,1)
      else
         call sjpg2s(mm,nm,nm,im,jc,w_Ydata,xv_U,&
              it,t,p,q,r,ws2,wg,w,1)
      endif
      call sjcrdn(mm,nm,w_Ydata,w_Xdata)
      call sjcs2x(mm,w_Xdata,w_Div)
      call sjcy2s(mm,w_Ydata,w_Data1,c)
      !
      ! 1/cosբv/ߦ, 1/cos (v cos)/ߦ η׻
      !
      if ( openmp ) then
         call sjpgos(mm,nm,nm,im,jc,w_Ydata,xv_V,&
              it,t,p,q,r,ws2,wg,w,1)
      else
         call sjpg2s(mm,nm,nm,im,jc,w_Ydata,xv_V,&
              it,t,p,q,r,ws2,wg,w,1)
      endif
      call sjcrdn(mm,nm,w_Ydata,w_Xdata)
      call sjcs2x(mm,w_Xdata,w_Vor)
      call sjcy2s(mm,w_Ydata,w_Data2,c)
      !
      !  ١ȯη׻
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      w_Vor = w_Vor - w_Data1
      w_Div = w_Div + w_Data2

    end subroutine w_Vector2VorDivMPI

    subroutine w_VectorCosLat2VorDivMPI(xv_UCosLat, xv_VCosLat, w_Vor, w_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(1 , MPI)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xv_UCosLat(0:im-1,1:jc)
      !(in) ®ٷʬ * cos(lat)
      real(8), intent(in)   :: xv_VCosLat(0:im-1,1:jc)
      !(in) ®ٰʬ * cos(lat)

      real(8), intent(out)   :: w_Vor((mm+1)*(mm+1))
      !(out) ήؿ
      real(8), intent(out)   :: w_Div((mm+1)*(mm+1))
      !(out) ®٥ݥƥ󥷥

      real(8)             :: w_Xdata((mm+1)*(mm+1))
      ! ѥڥȥǡ(SJCS2X )
      real(8)             :: w_Ydata((mm+4)*nm+2)
      ! ѥڥȥǡ(SJCY2S )

      real(8)  :: w_Data1((mm+1)*(mm+1))
      real(8)  :: w_Data2((mm+1)*(mm+1))

      real(8)  :: q(jm/2*7*np)               ! ѴѺ
      real(8)  :: ws2(2*(nm+1)*np+(2*NM+1-MM)*MM+NM+1) ! ѴѺ
      real(8)  :: wg((im+2)*jm)              ! ѴѺ
      real(8)  :: w((jm+1)*im)               ! ѴѺ

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_VectorCosLat2VorDivMPI',&
              'w_base_module not initialize yet.')
      endif

      if ( openmp .and. first ) then
         call MessageNotify('M','w_VectorCosLat2VorDiv', &
              'OpenMP routine SJPGOS/SNPACK-MPI is used for spherical harmonic transformation.')
      endif
      first = .false.

      !
      ! 1/cosբu/ߦ, 1/cos (u cos)/ߦ η׻
      !
      if ( openmp ) then
         call sjpgos(mm,nm,nm,im,jc,w_Ydata,xv_UCosLat,&
              it,t,p,q,r,ws2,wg,w,2)
      else
         call sjpg2s(mm,nm,nm,im,jc,w_Ydata,xv_UCosLat,&
              it,t,p,q,r,ws2,wg,w,2)
      endif
      call sjcrdn(mm,nm,w_Ydata,w_Xdata)
      call sjcs2x(mm,w_Xdata,w_Div)
      call sjcy2s(mm,w_Ydata,w_Data1,c)
      !
      ! 1/cosբv/ߦ, 1/cos (v cos)/ߦ η׻
      !
      if ( openmp ) then
         call sjpgos(mm,nm,nm,im,jc,w_Ydata,xv_VCosLat,&
              it,t,p,q,r,ws2,wg,w,2)
      else
         call sjpg2s(mm,nm,nm,im,jc,w_Ydata,xv_VCosLat,&
              it,t,p,q,r,ws2,wg,w,2)
      endif
      call sjcrdn(mm,nm,w_Ydata,w_Xdata)
      call sjcs2x(mm,w_Xdata,w_Vor)
      call sjcy2s(mm,w_Ydata,w_Data2,c)
      !
      !  ١ȯη׻
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      w_Vor = w_Vor - w_Data1
      w_Div = w_Div + w_Data2

    end subroutine w_VectorCosLat2VorDivMPI

  !--------------- λ -----------------
    subroutine w_base_mpi_Finalize
      !
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! ºݤλѤˤϾ̥֥롼 w_Finalize Ѥ뤳.
      !
      if ( .not. w_base_initialize ) then
         call MessageNotify('W','w_base_mpi_Finalize',&
              'w_base_mpi_module_sjpack not initialized yet')
         return
      endif

      deallocate(p)              ! Ѵ
      deallocate(r)              ! Ѵ
      deallocate(t)              ! Ѵ
      deallocate(c)              ! ѴѺ

      deallocate(v_Lat,v_Lat_Weight)   ! ʻɸǼ
      deallocate(xv_Lon,xv_Lat)        ! ʻɸǼ
      deallocate(y)

      w_base_initialize = .false.

      call MessageNotify('M','w_base_mpi_Finalize',&
           'w_base_mpi_module_sjpack (2013/02/23) is finalized')

    end subroutine w_base_mpi_Finalize

end module w_base_mpi_module_sjpack
