!------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  eea_module_fftj ƥȥץ (ѥڥȥ׻)
!
!  2011/12/10  ݹ
!
!
program eea_module_fftj_spectrum_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use eea_module_fftj
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32              ! ʻ(X,Y)
  integer, parameter :: km=10, lm=10              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yxa_Data(0:jm-1,0:im-1,2)    ! ʻҥǡ
  real(8)            :: eea_Data(-lm:lm,-km:km,2)    ! ڥȥǡ
  real(8)            :: a_Data(2)                    ! ʻҥǡ

  integer            :: k=2, l=3

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','eea_module_fftj_spectrum_test', &
       'eea_module_fftj spectrum function tests')

 !---------------- ɸͤ ---------------------
  call eea_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  yxa_Data(:,:,1) = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yxa_Data(:,:,2) = cos(k*pi*yx_X) * cos(l*pi*yx_Y)

  eea_Data = 0.0d0
  eea_Data(l,k,1) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2
  eea_Data(-l,k,1) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2
  eea_Data(l,-k,1) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2
  eea_Data(-l,-k,1) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2

  eea_Data(l,k,2) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2
  eea_Data(-l,k,2) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2
  eea_Data(l,-k,2) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2
  eea_Data(-l,-k,2) = ((k*pi)**2 + (l*pi)**2)*0.25**2/2

  call AssertEqual(                                      &
    message = 'Energy spectrum sin(k*pi*X)*sin(l*pi*Y)', &
    answer = eea_Data,                                    &
    check = eea_EnergyFromStreamfunc_eea(eea_yxa(yxa_Data)),  &
    significant_digits = check_digits, ignore_digits = ignore     )

  a_Data = sum(sum(eea_EnergyFromStreamfunc_eea(eea_yxa(yxa_Data)),1),1) &
              *(xmax-xmin)*(ymax-ymin)

  call AssertEqual(                                         &
    message = 'total energy sin(k*pi*X)*sin(l*pi*Y)',       &
    answer = (/((k*pi)**2 + (l*pi)**2)/2,((k*pi)**2 + (l*pi)**2)/2/), &
    check = a_Data, &
    significant_digits = check_digits, ignore_digits = ignore     )


  eea_Data(l,k,1) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2
  eea_Data(-l,k,1) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2
  eea_Data(l,-k,1) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2
  eea_Data(-l,-k,1) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2

  eea_Data(l,k,2) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2
  eea_Data(-l,k,2) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2
  eea_Data(l,-k,2) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2
  eea_Data(-l,-k,2) = ((k*pi)**2 + (l*pi)**2)**2*0.25**2/2

  call AssertEqual(                                         &
    message = 'Enstrophy spectrum sin(k*pi*X)*sin(l*pi*Y)', &
    answer = eea_Data,                                       &
    check = eea_EnstrophyFromStreamfunc_eea(eea_yxa(yxa_Data)),  &
    significant_digits = check_digits, ignore_digits = ignore     )

  a_Data = sum(sum(eea_EnstrophyFromStreamfunc_eea(eea_yxa(yxa_Data)),1),1) &
              *(xmax-xmin)*(ymax-ymin)
  call AssertEqual(                                            &
    message = 'total enstrophy sin(k*pi*X)*sin(l*pi*Y)',       &
    answer = (/((k*pi)**2 + (l*pi)**2)**2/2,((k*pi)**2 + (l*pi)**2)**2/2/),&
    check = a_Data, &
    significant_digits = check_digits, ignore_digits = ignore     )

  call MessageNotify('M','eea_module_fftj_spectrum_test', &
       'eea_module_fftj spectrum function tests succeeded!')

end program eea_module_fftj_spectrum_test
