!------------------------------------------------------------------------
! Copyright (c) 2005-2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  ee_module ƥȥץ (ʬ׻)
!
!  2005/07/19  ݹ
!      2007/11/09  ݹ  顼åɲ
!      2008/05/10  ݹ  ʣå
!      2011/02/15  ʿ dc_test Ȥ褦ѹ
!
program ee_test_derivative

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use ee_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32              ! ʻ(X,Y)
  integer, parameter :: km=10, lm=10              ! ȿ(X,Y)

  integer, parameter :: im2=64, jm2=64            ! ʻ(X,Y)
  integer, parameter :: km2=21, lm2=21            ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yx_Data(0:jm-1,0:im-1)    ! ʻҥǡ
  real(8)            :: yx_Deriv(0:jm-1,0:im-1)   ! ʻҥǡ

  real(8)            :: yx_Data2(0:jm2-1,0:im2-1)  ! ʻҥǡ
  real(8)            :: yx_Deriv2(0:jm2-1,0:im2-1) ! ʻҥǡ

  integer            :: k=2, l=3

  integer            :: id1, id2

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11
  real(8), parameter :: pi=3.1415926535897932385D0

  call MessageNotify('M','ee_test_derivative', &
       'ee_module derivative function tests')

 !---------------- ɸͤ ---------------------
  call ee_initial(im,jm,km,lm,xmin,xmax,ymin,ymax,id1)        ! ڥȥ
  call ee_initial(im2,jm2,km2,lm2,xmin,xmax,ymin,ymax,id2)    ! ڥȥ

 !-------------------  ----------------------

!!$  write(6,*) '  Input wavenumbers of the grid data, k and l :'
!!$  read(5,*) k,l
!!$  write(6,*) '  k,l = ', k,l

  ! id1
  write(*,*) 'for id1'
  call ee_ChangeResolutionDomain(id1)

  yx_Data = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yx_Deriv = k*pi*cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dx(sin(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv = l*pi*sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dy(sin(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv = -((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Lapla(sin(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv = -1.0/((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data))),yx_Deriv, &
    'LaplaInv(sin(k*pi*X)*sin(l*pi*Y))')

  yx_Data = cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  yx_Deriv = -k*pi*sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dx(cos(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv = -l*pi*cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dy(cos(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv = -((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Lapla(cos(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv = -1.0/((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data))),yx_Deriv, &
    'LaplaInv(cos(k*pi*X)*cos(l*pi*Y))')

  yx_Data = sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  yx_Deriv = k*pi*cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dx(sin(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv = -l*pi*sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dy(sin(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv = -((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Lapla(sin(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv = -1.0/((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data))),yx_Deriv, &
    'LaplaInv(sin(k*pi*X)*cos(l*pi*Y))')

  yx_Data = cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  yx_Deriv = -k*pi*sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dx(cos(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv = l*pi*cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Dy(cos(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv = -((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data))),yx_Deriv, &
    'Lapla(cos(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv = -1.0/((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data))),yx_Deriv, &
    'LaplaInv(cos(k*pi*X)*sin(l*pi*Y))')

  ! id2
  write(*,*) 'for id2'
  call ee_ChangeResolutionDomain(id2)

  yx_Data2 = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yx_Deriv2 = k*pi*cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dx(sin(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv2 = l*pi*sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dy(sin(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv2 = -((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Lapla(sin(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv2 = -1.0/((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'LaplaInv(sin(k*pi*X)*sin(l*pi*Y))')

  yx_Data2 = cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  yx_Deriv2 = -k*pi*sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dx(cos(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv2 = -l*pi*cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dy(cos(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv2 = -((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Lapla(cos(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv2 = -1.0/((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'LaplaInv(cos(k*pi*X)*cos(l*pi*Y))')

  yx_Data2 = sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  yx_Deriv2 = k*pi*cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dx(sin(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv2 = -l*pi*sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dy(sin(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv2 = -((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Lapla(sin(k*pi*X)*cos(l*pi*Y))')
  yx_Deriv2 = -1.0/((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'LaplaInv(sin(k*pi*X)*cos(l*pi*Y))')

  yx_Data2 = cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  yx_Deriv2 = -k*pi*sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dx_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dx(cos(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv2 = l*pi*cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check2d(yx_ee(ee_Dy_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Dy(cos(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv2 = -((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_Lapla_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'Lapla(cos(k*pi*X)*sin(l*pi*Y))')
  yx_Deriv2 = -1.0/((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check2d(yx_ee(ee_LaplaInv_ee(ee_yx(yx_Data2))),yx_Deriv2, &
    'LaplaInv(cos(k*pi*X)*sin(l*pi*Y))')

  call MessageNotify('M','ee_test_derivative', &
    'ee_module derivative function tests succeeded!')

contains

  subroutine check2d(var,sol,funcname)
    real(8) :: var(:,:)                ! Ƚꤹ
    real(8) :: sol(:,:)                ! ϲ
    character(len=*) :: funcname       ! ؿ̾

    call AssertEqual(     &
      message = funcname, &
      answer = sol,       &
      check = var,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check2d

end program ee_test_derivative
