!----------------------------------------------------------------------
! Copyright (c) 2008-2009 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_integral_mpi_module
!
!  spml/w_integral_mpi_module ⥸塼ϵ̾Ǥ 2 ήαư
!  Ĵȡ MPI 饤֥Ѥڥȥˡˤän
!  ͷ׻뤿 ⥸塼 w_mpi_module β⥸塼Ǥ, 
!  ʬʿѷ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2002/05/25  ݹ 
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2008/06/06  ݹ  MPI 
!      2010/01/07  ʿ  RDoc ѤΥɥȽ, 
!                              include 'mpif.h' -> use mpi
!
module w_integral_mpi_module
  !
  ! w_integral_mpi_module
  !
  !  spml/w_integral_mpi_module ⥸塼ϵ̾Ǥ 2 ήαư
  !  Ĵȡ MPI 饤֥Ѥڥȥˡˤän
  !  ͷ׻뤿 ⥸塼 w_mpi_module β⥸塼Ǥ, 
  !  ʬʿѷ׻Τ Fortran90 ؿ󶡤. 
  !
  !   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use w_base_module, only : im, x_Lon_Weight, y_Lat_Weight
  use w_base_mpi_module, only : jc, v_Lat_Weight
  use w_integral_module, only : IntLon_x, AvrLon_x
  use mpi

  implicit none
  integer :: ierr

  private
  private im
 
  public IntLonLat_xv                      ! ٷʬ
  public v_IntLon_xv                       ! ʬ    
  public x_IntLat_xv, IntLat_v             ! ʬ    
  public AvrLonLat_xv                      ! ٷʿ
  public v_AvrLon_xv                       ! ʿ    
  public x_AvrLat_xv, AvrLat_v             ! ʿ    

  contains

  !--------------- ʬ׻ -----------------
    function IntLonLat_xv(xv_data)
      !
      ! 2 ٷٳʻǡΰʬ(1 ). 
      !
      ! ºݤˤϳʻǡ x_X_Weight, v_V_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), intent(in)   :: xv_data(0:im-1,jc)         
      !(in) 2 ٰٳʻǡ(0:im-1,jc)

      real(8) :: IntLonLat_xv                         
      !(out) ʬ

      IntLonLat_xv = IntLon_x(x_IntLat_xv(xv_data))
    end function IntLonLat_xv

    function x_IntLat_xv(xv_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʬ(1 ).
      !
      ! ºݤˤϳʻǡ v_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xv_data(0:im-1,jc)           
      !(in) 2 ٰٳʻǡ(0:im-1,jc)

      real(8)             :: x_IntLat_xv(0:im-1) 
      !(out) ʬ줿 1 (X)ʻǡ

      real(8)             :: x_IntLatTmp(0:im-1) 
      integer :: j

      x_IntLat_xv = 0
      do j=1,jc
         x_IntLat_xv = x_IntLat_xv + xv_data(:,j) * v_Lat_weight(j)
      enddo

      x_IntLatTmp=x_IntLat_xv
      CALL MPI_ALLREDUCE(x_IntLatTMP,x_IntLat_xv,im,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)
    end function x_IntLat_xv

    function v_IntLon_xv(xv_data)
      !
      ! 2 ٷٳʻǡη(X)ʬ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xv_data(0:im-1,jc)
      !(in) 2 ٰٳʻǡ(0:im-1,jc)

      real(8)             :: v_IntLon_xv(jc)
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i

      v_IntLon_xv = 0
      do i=0,im-1
         v_IntLon_xv = v_IntLon_xv + xv_data(i,:) * x_Lon_weight(i)
      enddo

    end function v_IntLon_xv

    function IntLat_v(v_data)
      !
      ! 1 (Y)ʻǡ Y ʬ(1 ).
      !
      ! ºݤˤϳʻǡ v_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: v_data(jc)      !(in)  1 (Y)ʻǡ
      real(8)             :: IntLat_v        !(out) ʬ

      real(8)             :: IntLatTmp

      IntLat_v = sum(v_data * v_Lat_weight)
      IntLatTmp=IntLat_v
      CALL MPI_ALLREDUCE(IntLatTMP,IntLat_v,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntLat_v

  !--------------- ʿѷ׻ -----------------
    function AvrLonLat_xv(xv_data)
      !
      ! 2 ٷٳʻǡΰʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight, v_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*v_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in)   :: xv_data(0:im-1,jc)
      !(in) 2 ٰٳʻǡ(0:im-1,jc)

      real(8) :: AvrLonLat_xv
      !(out) ʿ

      AvrLonLat_xv = AvrLon_x(x_AvrLat_xv(xv_data))
    end function AvrLonLat_xv

    function x_AvrLat_xv(xv_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ v_Lat_Weight 򤫤¤׻,
      ! y_Lat_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xv_data(0:im-1,jc)          ! ʻ(0:im-1,jc)
      !(in) 2 ٰٳʻǡ(0:im-1,jc)

      real(8)             :: x_AvrLat_xv(im)
      !(out) ʿѤ줿 1 (X)ʻǡ

      x_AvrLat_xv = x_IntLat_xv(xv_data)/sum(y_Lat_weight)

    end function x_AvrLat_xv

    function v_AvrLon_xv(xv_data)
      !
      ! 2 ٷٳʻǡη(X)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xv_data(0:im-1,jc)
      !(in) 2 ٰٳʻǡ(0:im-1,jc)

      real(8)             :: v_AvrLon_xv(jc)
      !(out) ʿѤ줿 1 (Y)ʻ

      v_AvrLon_xv = v_IntLon_xv(xv_data)/sum(x_Lon_weight)

    end function v_AvrLon_xv

    function AvrLat_v(v_data)
      !
      ! 1 (Y)ʻǡΰ(Y)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ v_Y_Weight 򤫤¤׻, 
      ! v_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: v_data(jc)          !(in)  1 ٳʻǡ
      real(8)             :: AvrLat_v            !(out) ʿ

      AvrLat_v = IntLat_v(v_data)/sum(y_Lat_weight)

    end function AvrLat_v

  end module w_integral_mpi_module
