!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_mpi_module ƥȥץ
!      ʬʿѷ׻
!
!  2011/09/09  ݹ  wq_module_integral_test.f90  MPI Ѥ˲¤
!      2011/09/12  ݹ  xr_Data Ϳ
!
program wq_mpi_module_integral_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wq_mpi_module
  use mpi
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=31         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.5D0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)       :: xyr_Data
  real(8), dimension(0:im-1,1:jm)          :: xy_Data
  real(8), dimension(1:jm,km)              :: yr_Data
  real(8), dimension(0:im-1,km)            :: xr_Data
  real(8), dimension(0:im-1)               :: x_Data
  real(8), dimension(1:jm)                 :: y_Data
  real(8), dimension(km)                   :: r_Data

  real(8), allocatable :: xvr_Data(:,:,:)
  real(8), allocatable :: xv_Data(:,:)
  real(8), allocatable :: vr_Data(:,:)
  real(8), allocatable :: v_Data(:)

  real(8), parameter  :: pi=3.1415926535897932385D0

  ! Ƚ
  integer, parameter :: check_digits = 4
  integer, parameter :: ignore = -5

  integer :: iproc, np, ierr

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  call MessageNotify('M','wq_mpi_module_integral_test', &
       'wq_mpi_module integration functions tests')

  call wq_mpi_Initial(im,jm,km,nm,lm,ra)

  allocate(xvr_Data(0:im-1,1:jc,km))
  allocate(xv_Data(0:im-1,1:jc))
  allocate(vr_Data(1:jc,km))
  allocate(v_Data(1:jc))

 !============================ ʬ(xyr,xvr) =============================
 ! 
  xyr_Data = 1.0D0
  xvr_Data = 1.0D0

  yr_Data = 2*pi
  call AssertEqual(&
       message='yr_IntLon_xyr with constant field',                &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = 2*pi
  call AssertEqual(&
       message='vr_IntLon_xvr with constant field',                &
       answer = vr_Data,                                           &
       check = vr_IntLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0
  call AssertEqual(&
       message='xr_IntLat_xyr with constant field',                &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_IntLat_xvr with constant field',                &
       answer = xr_Data,                                           &
       check = xr_IntLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*ra**3
  call AssertEqual(&
       message='xy_IntRad_xyr with constant field',                &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = 1/3.0D0*ra**3
  call AssertEqual(&
       message='xv_IntRad_xvr with constant field',                &
       answer = xv_Data,                                           &
       check = xv_IntRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 4*pi
  call AssertEqual(&
       message='r_IntLonLat_xyr with constant field',              &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_IntLonLat_xvr with constant field',              &
       answer = r_Data,                                            &
       check = r_IntLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/3.0D0*ra**3
  call AssertEqual(&
       message='x_IntLatRad_xyr with constant field',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_IntLatRad_xvr with constant field',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/3.0D0*ra**3
  call AssertEqual(&
       message='y_IntLonRad_xyr with constant field',              &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 2*pi/3.0D0*ra**3
  call AssertEqual(&
       message='v_IntLonRad_xvr with constant field',              &
       answer = v_Data,                                            &
       check = v_IntLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with constant field',             &
       answer = 4*pi/3*ra**3,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLonLatRad_xvr with constant field',             &
       answer = 4*pi/3*ra**3,                                      &
       check = IntLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 ! r^2 
  xyr_Data = xyr_Rad**2
  xvr_Data = xvr_Rad**2

  yr_Data = 2*pi* xyr_Rad(1,:,:)**2
  call AssertEqual(&
       message='yr_IntLon_xyr with r^2',                           &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = 2*pi* xvr_Rad(1,:,:)**2
  call AssertEqual(&
       message='vr_IntLon_xvr with r^2',                           &
       answer = vr_Data,                                           &
       check = vr_IntLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0 * xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_IntLat_xyr with r^2',                           &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_IntLat_xvr with r^2',                           &
       answer = xr_Data,                                           &
       check = xr_IntLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/5.0D0*ra**5
  call AssertEqual(&
       message='xy_IntRad_xyr with r^2',                           &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = 1/5.0D0*ra**5
  call AssertEqual(&
       message='xv_IntRad_xvr with r^2',                           &
       answer = xv_Data,                                           &
       check = xv_IntRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 4*pi * xyr_Data(1,1,:)
  call AssertEqual(&
       message='r_IntLonLat_xyr with r^2',                         &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_IntLonLat_xvr with r^2',                         &
       answer = r_Data,                                            &
       check = r_IntLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/5.0D0*ra**5
  call AssertEqual(&
       message='x_IntLatRad_xyr with r^2',                         &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_IntLatRad_xvr with r^2',                         &
       answer = x_Data,                                            &
       check = x_IntLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/5.0D0*ra**5
  call AssertEqual(&
       message='y_IntLonRad_xyr with r^2',                         &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 2*pi/5.0D0*ra**5
  call AssertEqual(&
       message='v_IntLonRad_xvr with r^2',                         &
       answer = v_Data,                                            &
       check = v_IntLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with r^2',                        &
       answer = 4*pi/5*ra**5,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLonLatRad_xvr with r^2',                        &
       answer = 4*pi/5*ra**5,                                      &
       check = IntLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xyr_Data = sin(xyr_Lat)**2
  xvr_Data = sin(xvr_Lat)**2

  yr_Data = 2*pi* xyr_Data(1,:,:)
  call AssertEqual(&
       message='yr_IntLon_xyr with sin(phi)**2',                   &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = 2*pi* xvr_Data(1,:,:)
  call AssertEqual(&
       message='vr_IntLon_xvr with sin(phi)**2',                   &
       answer = vr_Data,                                           &
       check = vr_IntLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='xr_IntLat_xyr with sin(phi)**2',                   &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_IntLat_xvr with sin(phi)**2',                   &
       answer = xr_Data,                                           &
       check = xr_IntLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*ra**3 * xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_IntRad_xyr with sin(phi)**2',                   &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = 1/3.0D0*ra**3 * xvr_Data(:,:,1)
  call AssertEqual(&
       message='xv_IntRad_xvr with sin(phi)**2',                   &
       answer = xv_Data,                                           &
       check = xv_IntRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 4*pi/3.0
  call AssertEqual(&
       message='r_IntLonLat_xyr with sin(phi)**2',                 &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_IntLonLat_xvr with sin(phi)**2',                 &
       answer = r_Data,                                            &
       check = r_IntLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/9.0D0*ra**3
  call AssertEqual(&
       message='x_IntLatRad_xyr with sin(phi)**2',                 &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_IntLatRad_xvr with sin(phi)**2',                 &
       answer = x_Data,                                            &
       check = x_IntLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/3.0D0*ra**3 * xyr_Data(1,:,1)
  call AssertEqual(&
       message='y_IntLonRad_xyr with sin(phi)**2',                 &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 2*pi/3.0D0*ra**3 * xvr_Data(1,:,1)
  call AssertEqual(&
       message='v_IntLonRad_xvr with sin(phi)**2',                 &
       answer = v_Data,                                            &
       check = v_IntLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with sin(phi)**2',                &
       answer = 4*pi/9*ra**3,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLonLatRad_xvr with sin(phi)**2',                &
       answer = 4*pi/9*ra**3,                                      &
       check = IntLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xyr_Data = sin(xyr_Lon)**2
  xvr_Data = sin(xvr_Lon)**2

  yr_Data = pi
  call AssertEqual(&
       message='yr_IntLon_xyr with sin(lambda)**2',                &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = pi
  call AssertEqual(&
       message='vr_IntLon_xvr with sin(lambda)**2',                &
       answer = vr_Data,                                           &
       check = vr_IntLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0 * xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_IntLat_xyr with sin(lambda)**2',                &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_IntLat_xvr with sin(lambda)**2',                &
       answer = xr_Data,                                           &
       check = xr_IntLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*ra**3 * xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_IntRad_xyr with sin(lambda)**2',                &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = 1/3.0D0*ra**3 * xvr_Data(:,:,1)
  call AssertEqual(&
       message='xv_IntRad_xvr with sin(lambda)**2',                &
       answer = xv_Data,                                           &
       check = xv_IntRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 2*pi
  call AssertEqual(&
       message='r_IntLonLat_xyr with sin(lambda)**2',              &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_IntLonLat_xvr with sin(lambda)**2',              &
       answer = r_Data,                                            &
       check = r_IntLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0/3.0D0*ra**3 * xyr_Data(:,1,1)
  call AssertEqual(&
       message='x_IntLatRad_xyr with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_IntLatRad_xvr with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = pi/3.0D0*ra**3
  call AssertEqual(&
       message='y_IntLonRad_xyr with sin(lambda)**2',              &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = pi/3.0D0*ra**3
  call AssertEqual(&
       message='v_IntLonRad_xvr with sin(lambda)**2',              &
       answer = v_Data,                                            &
       check = v_IntLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with sin(lambda)**2',             &
       answer = 2*pi/3*ra**3,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLonLatRad_xvr with sin(lambda)**2',             &
       answer = 2*pi/3*ra**3,                                      &
       check = IntLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(xy,xv) =============================
  ! 
  xy_Data = 1.0D0
  xv_Data = 1.0D0

  y_Data = 2*pi
  call AssertEqual(&
       message='y_IntLon_xy with constant field',                  &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 2*pi
  call AssertEqual(&
       message='v_IntLon_xv with constant field',                  &
       answer = v_Data,                                            &
       check = v_IntLon_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0
  call AssertEqual(&
       message='x_IntLat_xy with constant field',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_IntLat_xv with constant field',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with constant field',                 &
       answer = 4*pi,                                              &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLonLat_xv with constant field',                 &
       answer = 4*pi,                                              &
       check = IntLonLat_xv(xv_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xy_Data = sin(xy_Lon)**2
  xv_Data = sin(xv_Lon)**2

  y_Data = pi 
  call AssertEqual(&
       message='y_IntLon_xy with sin(lambda)**2',                  &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = pi
  call AssertEqual(&
       message='v_IntLon_xv with sin(lambda)**2',                  &
       answer = v_Data,                                            &
       check = v_IntLon_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0d0 * xy_Data(:,1)
  call AssertEqual(&
       message='x_IntLat_xy with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_IntLat_xv with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with sin(lambda)**2',                 &
       answer = 2*pi,                                              &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLonLat_xv with sin(lambda)**2',                 &
       answer = 2*pi,                                              &
       check = IntLonLat_xv(xv_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xy_Data = sin(xy_Lat)**2
  xv_Data = sin(xv_Lat)**2

  y_Data = 2*pi* xy_Data(1,:)
  call AssertEqual(&
       message='y_IntLon_xy with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 2*pi* xv_Data(1,:)
  call AssertEqual(&
       message='v_IntLon_xv with sin(phi)**2',                     &
       answer = v_Data,                                            &
       check = v_IntLon_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='x_IntLat_xy with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_IntLat_xv with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_IntLat_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with sin(phi)**2',                    &
       answer = 4*pi/3.0,                                          &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLonLat_xv with sin(phi)**2',                    &
       answer = 4*pi/3.0,                                          &
       check = IntLonLat_xv(xv_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(yr,vr) =============================
  ! 
  yr_Data = 1.0D0
  vr_Data = 1.0D0

  r_Data = 2.0D0
  call AssertEqual(&
       message='r_IntLat_yr with constant field',                  &
       answer = r_Data,                                            &
       check = r_IntLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_IntLat_vr with constant field',                  &
       answer = r_Data,                                            &
       check = r_IntLat_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/3.0D0*ra**3
  call AssertEqual(&
       message='y_IntRad_yr with constant field',                  &
       answer = y_Data,                                            &
       check = y_IntRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 1/3.0D0*ra**3
  call AssertEqual(&
       message='v_IntRad_vr with constant field',                  &
       answer = v_Data,                                            &
       check = v_IntRad_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yr with constant field',                 &
       answer = 2/3.0D0*ra**3,                                     &
       check = IntLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLatRad_vr with constant field',                 &
       answer = 2/3.0D0*ra**3,                                     &
       check = IntLatRad_vr(vr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  yr_Data = xyr_Rad(0,:,:)**2
  vr_Data = xvr_Rad(0,:,:)**2

  r_Data = 2.0D0 * yr_Data(1,:)
  call AssertEqual(&
       message='r_IntLat_yr with r^2',                             &
       answer = r_Data,                                            &
       check = r_IntLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_IntLat_vr with r^2',                             &
       answer = r_Data,                                            &
       check = r_IntLat_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/5.0D0*ra**5
  call AssertEqual(&
       message='y_IntRad_yr with r^2',                             &
       answer = y_Data,                                            &
       check = y_IntRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 1/5.0D0*ra**5
  call AssertEqual(&
       message='v_IntRad_vr with r^2',                             &
       answer = v_Data,                                            &
       check = v_IntRad_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yr with r^2',                            &
       answer = 2/5.0D0*ra**5,                                     &
       check = IntLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLatRad_vr with r^2',                            &
       answer = 2/5.0D0*ra**5,                                     &
       check = IntLatRad_vr(vr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  yr_Data = sin(xyr_Lat(0,:,:))**2
  vr_Data = sin(xvr_Lat(0,:,:))**2

  r_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='r_IntLat_yr with sin(phi)**2',                     &
       answer = r_Data,                                            &
       check = r_IntLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_IntLat_vr with sin(phi)**2',                     &
       answer = r_Data,                                            &
       check = r_IntLat_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/3.0D0*ra**3 * yr_Data(:,1)
  call AssertEqual(&
       message='y_IntRad_yr with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_IntRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 1/3.0D0*ra**3 * vr_Data(:,1)
  call AssertEqual(&
       message='v_IntRad_vr with sin(phi)**2',                     &
       answer = v_Data,                                            &
       check = v_IntRad_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yr with sin(phi)**2',                    &
       answer = 2/9.0D0*ra**3,                                     &
       check = IntLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLatRad_vr with sin(phi)**2',                    &
       answer = 2/9.0D0*ra**3,                                     &
       check = IntLatRad_vr(vr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(xr) =============================
  ! 
  xr_Data = 1.0D0

  r_Data = 2*pi
  call AssertEqual(&
       message='r_IntLon_xr with constant field',                  &
       answer = r_Data,                                            &
       check = r_IntLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/3.0D0*ra**3
  call AssertEqual(&
       message='x_IntRad_xr with constant field',                  &
       answer = x_Data,                                            &
       check = x_IntRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xr with constant field',                 &
       answer = 2*pi/3.0D0*ra**3,                                  &
       check = IntLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xr_Data = sin(xyr_Lon(:,1,:))**2

  r_Data = pi
  call AssertEqual(&
       message='r_IntLon_xr with sin(lambda)**2',                  &
       answer = r_Data,                                            &
       check = r_IntLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/3.0D0*ra**3 * xr_Data(:,1)
  call AssertEqual(&
       message='x_IntRad_xr with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_IntRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xr with sin(lambda)**2',                 &
       answer = pi/3.0D0*ra**3 ,                                   &
       check = IntLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  xr_Data = spread(r_Rad**2,1,im)

  r_Data = 2*pi* r_Rad**2
  call AssertEqual(&
       message='r_IntLon_xr with r^2',                             &
       answer = r_Data,                                            &
       check = r_IntLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/5.0D0*ra**5
  call AssertEqual(&
       message='x_IntRad_xr with r^2',                             &
       answer = x_Data,                                            &
       check = x_IntRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xr with r^2',                            &
       answer = 2*pi/5.0D0*ra**5,                                  &
       check = IntLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(x) =============================
  ! 
  x_Data = 1.0D0

  call AssertEqual(&
       message='IntLon_x with constant field',                     &
       answer = 2*pi,                                              &
       check = IntLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  x_Data = sin(x_Lon)**2

  call AssertEqual(&
       message='IntLon_x with sin(lambda)**2',                     &
       answer = pi,                                                &
       check = IntLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(y,v) =============================
  ! 
  y_Data = 1.0D0
  v_Data = 1.0D0

  call AssertEqual(&
       message='IntLat_y with constant field',                     &
       answer = 2.0D0,                                             &
       check = IntLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLat_v with constant field',                     &
       answer = 2.0D0,                                             &
       check = IntLat_v(v_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  y_Data = sin(y_Lat)**2
  v_Data = sin(v_Lat)**2

  call AssertEqual(&
       message='IntLat_y with sin(phi)**2',                        &
       answer = 2.0D0/3.0D0,                                       &
       check = IntLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='IntLat_v with sin(phi)**2',                        &
       answer = 2.0D0/3.0D0,                                       &
       check = IntLat_v(v_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(r) =============================
  ! 
  r_Data = 1.0D0

  call AssertEqual(&
       message='IntRad_r with constant field',                     &
       answer = 1/3.0D0*ra**3,                                     &
       check = IntRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  r_Data = r_Rad**2

  call AssertEqual(&
       message='IntRad_r with r^2',                                &
       answer = 1/5.0D0*ra**5,                                     &
       check = IntRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !=========================== ʿ(xyr,xvr) =============================

  call MessageNotify('M','wq_mpi_module_integral_test', &
       'wq_mpi_module averaging functions tests')

 ! 
  xyr_Data = 1.0
  xvr_Data = 1.0

  yr_Data = 1.0D0
  call AssertEqual(&
       message='yr_AvrLon_xyr with constant field',                &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = 1.0D0
  call AssertEqual(&
       message='vr_AvrLon_xvr with constant field',                &
       answer = vr_Data,                                           &
       check = vr_AvrLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 1.0D0
  call AssertEqual(&
       message='xr_AvrLat_xyr with constant field',                &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_AvrLat_xvr with constant field',                &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1.0D0
  call AssertEqual(&
       message='xy_AvrRad_xyr with constant field',                &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = 1.0D0
  call AssertEqual(&
       message='xv_AvrRad_xvr with constant field',                &
       answer = xv_Data,                                           &
       check = xv_AvrRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = r_AvrLonLat_xyr(xyr_Data)
  call AssertEqual(&
       message='r_AvrLonLat_xyr with constant field',              &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_AvrLonLat_xvr with constant field',              &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrLatRad_xyr with constant field',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_AvrLatRad_xvr with constant field',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrLonRad_xyr with constant field',              &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 1.0D0
  call AssertEqual(&
       message='v_AvrLonRad_xvr with constant field',              &
       answer = v_Data,                                            &
       check = v_AvrLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with constant field',             &
       answer = 1.0D0,                                             &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLonLatRad_xvr with constant field',             &
       answer = 1.0D0,                                             &
       check = AvrLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 ! r 
  xyr_Data = xyr_Rad 
  xvr_Data = xvr_Rad 

  yr_Data = xyr_Data(1,:,:)
  call AssertEqual(&
       message='yr_AvrLon_xyr with r',                             &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = xvr_Data(1,:,:)
  call AssertEqual(&
       message='vr_AvrLon_xvr with r',                             &
       answer = vr_Data,                                           &
       check = vr_AvrLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_AvrLat_xyr with r',                             &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_AvrLat_xvr with r',                             &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1.0D0/4.0D0*ra**4/(1.0D0/3.0D0*ra**3)
  call AssertEqual(&
       message='xy_AvrRad_xyr with r',                             &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = 1.0D0/4.0D0*ra**4/(1.0D0/3.0D0*ra**3)
  call AssertEqual(&
       message='xv_AvrRad_xvr with r',                             &
       answer = xv_Data,                                           &
       check = xv_AvrRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = xyr_Data(1,1,:)
  call AssertEqual(&
       message='r_AvrLonLat_xyr with r',                           &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_AvrLonLat_xvr with r',                           &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/2.0D0*ra**4/(2/3.0D0*ra**3)
  call AssertEqual(&
       message='x_AvrLatRad_xyr with r',                           &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_AvrLatRad_xvr with r',                           &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = pi/2.0D0*ra**4/(2*pi/3.0D0*ra**3)
  call AssertEqual(&
       message='y_AvrLonRad_xyr with r',                           &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = pi/2.0D0*ra**4/(2*pi/3.0D0*ra**3)
  call AssertEqual(&
       message='v_AvrLonRad_xvr with r',                           &
       answer = v_Data,                                            &
       check = v_AvrLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with r',                          &
       answer = pi*ra**4/(4*pi/3*ra**3),                           &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLonLatRad_xvr with r',                          &
       answer = pi*ra**4/(4*pi/3*ra**3),                           &
       check = AvrLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2
  xyr_Data = sin(xyr_Lat)**2
  xvr_Data = sin(xvr_Lat)**2

  yr_Data = xyr_Data(1,:,:)
  call AssertEqual(&
       message='yr_AvrLon_xyr with sin(phi)**2',                   &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = xvr_Data(1,:,:)
  call AssertEqual(&
       message='vr_AvrLon_xvr with sin(phi)**2',                   &
       answer = vr_Data,                                           &
       check = vr_AvrLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='xr_AvrLat_xyr with sin(phi)**2',                   &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_AvrLat_xvr with sin(phi)**2',                   &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_AvrRad_xyr with sin(phi)**2',                   &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = xvr_Data(:,:,1)
  call AssertEqual(&
       message='xv_AvrRad_xvr with sin(phi)**2',                   &
       answer = xv_Data,                                           &
       check = xv_AvrRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='r_AvrLonLat_xyr with sin(phi)**2',                 &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_AvrLonLat_xvr with sin(phi)**2',                 &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='x_AvrLatRad_xyr with sin(phi)**2',                 &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_AvrLatRad_xvr with sin(phi)**2',                 &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = xyr_Data(1,:,1)
  call AssertEqual(&
       message='y_AvrLonRad_xyr with sin(phi)**2',                 &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = xvr_Data(1,:,1)
  call AssertEqual(&
       message='v_AvrLonRad_xvr with sin(phi)**2',                 &
       answer = v_Data,                                            &
       check = v_AvrLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with sin(phi)**2',                &
       answer = 1.0D0/3D0,                                         &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLonLatRad_xvr with sin(phi)**2',                &
       answer = 1.0D0/3D0,                                         &
       check = AvrLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xyr_Data = sin(xyr_Lon)**2
  xvr_Data = sin(xvr_Lon)**2

  yr_Data = 0.5D0
  call AssertEqual(&
       message='yr_AvrLon_xyr with sin(lambda)**2',                &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  vr_Data = 0.5D0
  call AssertEqual(&
       message='vr_AvrLon_xvr with sin(lambda)**2',                &
       answer = vr_Data,                                           &
       check = vr_AvrLon_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_AvrLat_xyr with sin(lambda)**2',                &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='xr_AvrLat_xvr with sin(lambda)**2',                &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_AvrRad_xyr with sin(lambda)**2',                &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  xv_Data = xvr_Data(:,:,1)
  call AssertEqual(&
       message='xv_AvrRad_xvr with sin(lambda)**2',                &
       answer = xv_Data,                                           &
       check = xv_AvrRad_xvr(xvr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 0.5D0
  call AssertEqual(&
       message='r_AvrLonLat_xyr with sin(lambda)**2',              &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_AvrLonLat_xvr with sin(lambda)**2',              &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xyr_Data(:,1,1)
  call AssertEqual(&
       message='x_AvrLatRad_xyr with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_AvrLatRad_xvr with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 0.5D0
  call AssertEqual(&
       message='y_AvrLonRad_xyr with sin(lambda)**2',              &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 0.5D0
  call AssertEqual(&
       message='v_AvrLonRad_xvr with sin(lambda)**2',              &
       answer = v_Data,                                            &
       check = v_AvrLonRad_xvr(xvr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with sin(lambda)**2',             &
       answer = 0.5D0,                                             &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLonLatRad_xvr with sin(lambda)**2',             &
       answer = 0.5D0,                                             &
       check = AvrLonLatRad_xvr(xvr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(xy,xv) =============================
  ! 
  xy_Data = 1.0D0
  xv_Data = 1.0D0

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrLon_xy with constant field',                  &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 1.0D0
  call AssertEqual(&
       message='v_AvrLon_xv with constant field',                  &
       answer = v_Data,                                            &
       check = v_AvrLon_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrLat_xy with constant field',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_AvrLat_xv with constant field',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLonLat_xv with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLonLat_xv(xv_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xy_Data = sin(xy_Lon)**2
  xv_Data = sin(xv_Lon)**2

  y_Data = 0.5D0
  call AssertEqual(&
       message='y_AvrLon_xy with sin(lambda)**2',                  &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 0.5D0
  call AssertEqual(&
       message='v_AvrLon_xv with sin(lambda)**2',                  &
       answer = v_Data,                                            &
       check = v_AvrLon_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xy_Data(:,1)
  call AssertEqual(&
       message='x_AvrLat_xy with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_AvrLat_xv with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with sin(lambda)**2',                 &
       answer = 0.5D0,                                             &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLonLat_xv with sin(lambda)**2',                 &
       answer = 0.5D0,                                             &
       check = AvrLonLat_xv(xv_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xy_Data = sin(xy_Lat)**2
  xv_Data = sin(xv_Lat)**2

  y_Data = xy_Data(1,:)
  call AssertEqual(&
       message='y_AvrLon_xy with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = xv_Data(1,:)
  call AssertEqual(&
       message='v_AvrLon_xv with sin(phi)**2',                     &
       answer = v_Data,                                            &
       check = v_AvrLon_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='x_AvrLat_xy with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='x_AvrLat_xv with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_AvrLat_xv(xv_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLonLat_xv with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLonLat_xv(xv_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(yr,vr) =============================
  ! 
  yr_Data = 1.0D0
  vr_Data = 1.0D0

  r_Data = 1.0D0
  call AssertEqual(&
       message='r_AvrLat_yr with constant field',                  &
       answer = r_Data,                                            &
       check = r_AvrLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_AvrLat_vr with constant field',                  &
       answer = r_Data,                                            &
       check = r_AvrLat_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrRad_yr with constant field',                  &
       answer = y_Data,                                            &
       check = y_AvrRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 1.0D0
  call AssertEqual(&
       message='v_AvrRad_vr with constant field',                  &
       answer = v_Data,                                            &
       check = v_AvrRad_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yr with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLatRad_vr with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLatRad_vr(vr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  yr_Data = xyr_Rad(0,:,:)**2
  vr_Data = xvr_Rad(0,:,:)**2

  r_Data = yr_Data(1,:)
  call AssertEqual(&
       message='r_AvrLat_yr with r^2',                             &
       answer = r_Data,                                            &
       check = r_AvrLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_AvrLat_vr with r^2',                             &
       answer = r_Data,                                            &
       check = r_AvrLat_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 3.0D0/5.0D0*ra**2
  call AssertEqual(&
       message='y_AvrRad_yr with r^2',                             &
       answer = y_Data,                                            &
       check = y_AvrRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = 3.0D0/5.0D0*ra**2
  call AssertEqual(&
       message='v_AvrRad_vr with r^2',                             &
       answer = v_Data,                                            &
       check = v_AvrRad_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yr with r^2',                            &
       answer = 3.0D0/5.0D0*ra**2,                                 &
       check = AvrLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLatRad_vr with r^2',                            &
       answer = 3.0D0/5.0D0*ra**2,                                 &
       check = AvrLatRad_vr(vr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  yr_Data = sin(xyr_Lat(0,:,:))**2
  vr_Data = sin(xvr_Lat(0,:,:))**2

  r_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='r_AvrLat_yr with sin(phi)**2',                     &
       answer = r_Data,                                            &
       check = r_AvrLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='r_AvrLat_vr with sin(phi)**2',                     &
       answer = r_Data,                                            &
       check = r_AvrLat_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = yr_Data(:,1)
  call AssertEqual(&
       message='y_AvrRad_yr with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_AvrRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  v_Data = vr_Data(:,1)
  call AssertEqual(&
       message='v_AvrRad_vr with sin(phi)**2',                     &
       answer = v_Data,                                            &
       check = v_AvrRad_vr(vr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yr with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLatRad_vr with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLatRad_vr(vr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(xr) =============================
  ! 
  xr_Data = 1.0D0

  r_Data = 1.0D0
  call AssertEqual(&
       message='r_AvrLon_xr with constant field',                  &
       answer = r_Data,                                            &
       check = r_AvrLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrRad_xr with constant field',                  &
       answer = x_Data,                                            &
       check = x_AvrRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xr with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xr_Data = sin(xyr_Lon(:,1,:))**2

  r_Data = 0.5D0
  call AssertEqual(&
       message='r_AvrLon_xr with sin(lambda)**2',                  &
       answer = r_Data,                                            &
       check = r_AvrLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xr_Data(:,1)
  call AssertEqual(&
       message='x_AvrRad_xr with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_AvrRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xr with sin(lambda)**2',                 &
       answer = 0.5D0,                                             &
       check = AvrLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  xr_Data = spread(r_Rad**2,1,im)

  r_Data = r_Rad**2
  call AssertEqual(&
       message='r_AvrLon_xr with r^2',                             &
       answer = r_Data,                                            &
       check = r_AvrLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 3.0D0/5.0D0*ra**2
  call AssertEqual(&
       message='x_AvrRad_xr with r^2',                             &
       answer = x_Data,                                            &
       check = x_AvrRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xr with r^2',                            &
       answer = 3.0D0/5.0D0*ra**2,                                 &
       check = AvrLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(x) =============================
  ! 
  x_Data = 1.0D0

  call AssertEqual(&
       message='AvrLon_x with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  x_Data = sin(x_Lon)**2

  call AssertEqual(&
       message='AvrLon_x with sin(lambda)**2',                     &
       answer = 0.5D0,                                             &
       check = AvrLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(y,v) =============================
  ! 
  y_Data = 1.0D0
  v_Data = 1.0D0

  xr_Data = 1.0D0
  call AssertEqual(&
       message='AvrLat_y with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLat_v with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrLat_v(v_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  y_Data = sin(y_Lat)**2
  v_Data = sin(v_Lat)**2

  call AssertEqual(&
       message='AvrLat_y with sin(phi)**2',                        &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )
  call AssertEqual(&
       message='AvrLat_v with sin(phi)**2',                        &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLat_v(v_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(r) =============================
  ! 
  r_Data = 1.0D0

  call AssertEqual(&
       message='AvrRad_r with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  r_Data = r_Rad**2

  call AssertEqual(&
       message='AvrRad_r with r^2',                                &
       answer = 3.0D0/5.0D0*ra**2,                                 &
       check = AvrRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call MessageNotify('M','wq_mpi_module_integral_test', &
       'wq_mpi_module integration/averaging function tests succeeded!')

  call MPI_FINALIZE(IERR)

end program wq_mpi_module_integral_test

