*"ɽ ϳ  GCM5(DGDYN)
*
*" 90/05/19 ¸  
*"      90/08/31 ¸  
*" 90/12/06 ¸   virtual temperature
*
*
*********************************************************************
*"             << ʻǤϳع >>
*********************************************************************
      SUBROUTINE GRDDYN
     M         ( GTUA  , GTVA  , GTH   , GTR   ,
     O           GTKE  , GTUT  , GTVT  , GTPI  , GTUQ  , GTVQ  ,
     O           GSIGD , GPID  ,
     I           GAU   , GAV   , GAT   , GAQ   ,
     I           GAVOR , GADIV , GAPIX , GAPIY ,
     C           CORIOL, UVFACT, SIGM  , DSIG  ,
     C           SALPHA, SBETA , SKAPPA,
     C           ATF   , BTF   , TBAR  , TBARM                  )
*
*"                 Arakawa & Suarez ľʬ Һɸ
*"                    semi implicit scheme
*"                    virtual temperature
*
#if   HITAC
      INCLUDE   (ZCDIM)                      !" ʻȿ
      INCLUDE   (ZCCOM)                      !" ɸʪ
#elif SX3
      INCLUDE   "zcdim.F"                    !" ʻȿ
      INCLUDE   "zccom.F"                    !" ɸʪ
#else
#include        "zcdim.F"                    !" ʻȿ
#include        "zccom.F"                    !" ɸʪ
#endif
*
      REAL       GTUA  ( IDIM*JDIM, KMAX )   !" ư̰ήգ
      REAL       GTVA  ( IDIM*JDIM, KMAX )   !" ̱ư̰ή֣
      REAL       GTH   ( IDIM*JDIM, KMAX )   !" ٻѲ  
      REAL       GTR   ( IDIM*JDIM, KMAX )   !" 漾Ѳ  
*
      REAL       GTKE  ( IDIM*JDIM, KMAX )   !" ưͥ륮ˣ
      REAL       GTUT  ( IDIM*JDIM, KMAX )   !" ή  գ
      REAL       GTVT  ( IDIM*JDIM, KMAX )   !" ̰ή  ֣
      REAL       GTPI  ( IDIM*JDIM       )   !" Ѳ  
      REAL       GTUQ  ( IDIM*JDIM, KMAX )   !" 漾ή  գ
      REAL       GTVQ  ( IDIM*JDIM, KMAX )   !" 漾̰ή  ֣
      REAL       GSIGD ( IDIM*JDIM, KMAX+1 ) !" ҤλѲ
      REAL       GPID  ( IDIM*JDIM       )   !" ФλѲ
*
      REAL       GAU   ( IDIM*JDIM, KMAX )   !"   (t)
      REAL       GAV   ( IDIM*JDIM, KMAX )   !"   (t)
      REAL       GAT   ( IDIM*JDIM, KMAX )   !"   (t)
      REAL       GAQ   ( IDIM*JDIM, KMAX )   !" 漾  (t)
      REAL       GAVOR ( IDIM*JDIM, KMAX )   !"   (t)
      REAL       GADIV ( IDIM*JDIM, KMAX )   !" ȯ  (t)
      REAL       GAPIX ( IDIM*JDIM       )   !" Фʬ
      REAL       GAPIY ( IDIM*JDIM       )   !" Фʬ
*
      REAL       CORIOL( IDIM*JDIM )         !" ꥪ그 
      REAL       UVFACT( IDIM*JDIM )         !" uU Υե
*
      REAL       SIGM  ( KMAX+1 )            !" ҥ٥(Ⱦ)
      REAL       DSIG  ( KMAX )              !" 
*
      REAL       SALPHA( KMAX )              !" ſ尵μη 
      REAL       SBETA ( KMAX )              !" ſ尵μη 
      REAL       SKAPPA( KMAX )              !" ٱľ֤η
      REAL       ATF   ( KMAX )              !" ٱľ֤η
      REAL       BTF   ( KMAX )              !" ٱľ֤η
      REAL       TBAR  ( KMAX )              !" ܲ١٥
      REAL       TBARM ( KMAX )              !" ܲ١Ⱦ
*
      COMMON    /COMWRK/
     &           GSIGDA, GAPADV, GSUMPD,
     &           GSUMPA, GATED , GATEDM,
     &           GATV  , GATVED, GATVDF
      REAL       GSIGDA( IDIM*JDIM, KMAX+1 ) !" ҤλѲ
      REAL       GAPADV( IDIM*JDIM, KMAX )   !" Фΰή
      REAL       GSUMPD( IDIM*JDIM, KMAX )   !" Ĥαľѻ
      REAL       GSUMPA( IDIM*JDIM, KMAX )   !" Фΰήαľѻ
      REAL       GATED ( IDIM*JDIM, KMAX )   !" '٥
      REAL       GATEDM( IDIM*JDIM, KMAX )   !" 'Ⱦ٥
      REAL       GATV  ( IDIM*JDIM, KMAX )   !" v
      REAL       GATVED( IDIM*JDIM, KMAX )   !" v'
      REAL       GATVDF( IDIM*JDIM, KMAX )   !" v-
*
      LOGICAL    OFIRST
      DATA       OFIRST / .TRUE. /
      SAVE       OFIRST
      IF ( OFIRST ) THEN
         WRITE ( 6,* ) ' DYNAMICS: VIRTUAL TEMP. EFFECT DATE=90/12/06'
         OFIRST = .FALSE.
      ENDIF
*
*"         < 1. 徺ήη׻ >
*
      CALL PSDOT
     O        ( GSIGD , GSIGDA, GAPADV, GSUMPD, GSUMPA,
     I          GAU   , GAV   , GADIV , GAPIX , GAPIY ,
     C          DSIG  , SIGM  , UVFACT, ER               )
*
      DO 1100 IJ = 1, IDIM*JDIM
         GTPI  ( IJ ) = - GSUMPA ( IJ,1 )
         GPID  ( IJ ) = - GSUMPD ( IJ,1 )
 1100 CONTINUE
*
*"         < 2.1 ١٤δܾ줫Τ ԡ>
*
      DO 2100 K = 1, KMAX
         DO 2100 IJ = 1, IDIM*JDIM
            GATED ( IJ,K ) =  GAT ( IJ,K ) - TBAR ( K )
            GATV  ( IJ,K ) =  GAT ( IJ,K ) * ( 1.+ EPSVT*GAQ( IJ,K ) )
            GATVED( IJ,K ) =  GATV( IJ,K ) - TBAR ( K )
 2100 CONTINUE
*
*"         < 2.2 Ⱦ٥β >
*
      DO 2200 K = 2, KMAX
         DO 2200 IJ = 1, IDIM*JDIM
            GATEDM( IJ,K ) =  ATF ( K )   * GAT ( IJ,K   )
     &                      + BTF ( K-1 ) * GAT ( IJ,K-1 )
     &                      - TBARM ( K )
 2200 CONTINUE
*
*"         < 3.  գ֦ơܦҰή֣զơܦҰή >
*
*
      DO 3100 K = 1, KMAX
         DO 3100 IJ = 1, IDIM*JDIM
            GTUA( IJ,K ) =  GTUA( IJ,K )   * UVFACT ( IJ )
     &                    +  GAV  ( IJ,K ) * UVFACT ( IJ )
     &                      * ( GAVOR( IJ,K ) + CORIOL ( IJ )    )
     &                    -  CP * SKAPPA(K) / ER
     &                          * GATVED( IJ,K ) * GAPIX( IJ )
*
            GTVA( IJ,K ) =  GTVA( IJ,K )   * UVFACT ( IJ )
     &                    -  GAU  ( IJ,K ) * UVFACT ( IJ )
     &                      * ( GAVOR( IJ,K ) + CORIOL ( IJ )    )
     &                    -  CP * SKAPPA(K) / ER
     &                          * GATVED( IJ,K ) * GAPIY( IJ )
*
 3100 CONTINUE
*
      DO 3200 K = 2, KMAX
         DO 3200 IJ = 1, IDIM*JDIM
            GTUA( IJ,K ) =  GTUA( IJ,K )
     &                    -  GSIGD( IJ,K ) / ( DSIG (K) * 2. )
     &                     * ( GAU  ( IJ,K-1 ) - GAU  ( IJ,K   ) )
     &                     * UVFACT ( IJ )
*
            GTVA( IJ,K ) =  GTVA( IJ,K )
     &                    -  GSIGD( IJ,K ) / ( DSIG (K) * 2.  )
     &                     * ( GAV  ( IJ,K-1 ) - GAV  ( IJ,K   ) )
     &                     * UVFACT ( IJ )
*
 3200 CONTINUE
*
      DO 3300 K = 1, KMAX-1
         DO 3300 IJ = 1, IDIM*JDIM
            GTUA( IJ,K ) =  GTUA( IJ,K )
     &                    -  GSIGD( IJ,K+1 ) / ( DSIG (K) * 2. )
     &                     * ( GAU  ( IJ,K   ) - GAU  ( IJ,K+1 ) )
     &                     * UVFACT ( IJ )
*
            GTVA( IJ,K ) =  GTVA( IJ,K )
     &                    -  GSIGD( IJ,K+1 ) / ( DSIG (K) * 2.  )
     &                     * ( GAV  ( IJ,K   ) - GAV  ( IJ,K+1 ) )
     &                     * UVFACT ( IJ )
*
 3300 CONTINUE
*
*"         < 4. =**2+**2 +  >
*
      DO 4100 K = 1, KMAX
         DO 4100 IJ = 1, IDIM*JDIM
            GATVDF( IJ,K ) = GATV ( IJ,K ) - GAT ( IJ,K )
 4100 CONTINUE
*
      CALL GHYDRO
     O     ( GTKE  ,
     I       GATVDF  )
*
      DO 4300 K = 1, KMAX
         DO 4300 IJ = 1, IDIM*JDIM
            GTKE( IJ,K ) = GTKE( IJ,K )
     &                   + (  GAU( IJ,K )**2 + GAV( IJ,K )**2  ) / 2.
 4300 CONTINUE
*
*"         < 5.  գ'  ֣' >
*
      DO 5100 K = 1, KMAX
         DO 5100 IJ = 1, IDIM*JDIM
            GTUT( IJ,K ) =  GAU ( IJ,K ) * GATED ( IJ,K )
     &                                   * UVFACT ( IJ )
            GTVT( IJ,K ) =  GAV ( IJ,K ) * GATED ( IJ,K )
     &                                   * UVFACT ( IJ )
 5100 CONTINUE
*
*"         < 6.  ȡ'ġܦʣԦءܦҰή >
*
      DO 6100 K = 1, KMAX
        DO 6100 IJ = 1, IDIM*JDIM
            GTH ( IJ,K )
     &       =  GTH ( IJ,K )
*
     &        +  GATED ( IJ,K ) * GADIV( IJ,K )
*
     &        +  SKAPPA( K ) * GATV ( IJ,K ) * GAPADV( IJ,K )
*
     &        -  SALPHA( K ) / DSIG ( K )
     &           * (     GATV  ( IJ,K ) * GSUMPA( IJ,K )
     &                +  GATVED( IJ,K ) * GSUMPD( IJ,K )   )
*
 6100 CONTINUE
*
      DO 6200 K = 2, KMAX
        DO 6200 IJ = 1, IDIM*JDIM
            GTH ( IJ,K )
     &       =  GTH ( IJ,K )
*
     &        -  GSIGD ( IJ,K )    / DSIG ( K )
     &            * (    GATEDM( IJ,K ) - GATED ( IJ,K   )   )
*
     &        -  GSIGDA ( IJ,K )   / DSIG ( K )
     &            * (    TBARM( K ) - TBAR ( K   )    )
*
 6200 CONTINUE
*
      DO 6300 K = 1, KMAX-1
        DO 6300 IJ = 1, IDIM*JDIM
            GTH ( IJ,K )
     &       =  GTH ( IJ,K )
*
     &        -  GSIGD ( IJ,K+1 )  / DSIG ( K )
     &            * (    GATED ( IJ,K ) - GATEDM( IJ,K+1 )   )
*
     &        -  GSIGDA ( IJ,K+1 ) / DSIG ( K )
     &            * (    TBAR ( K ) - TBARM( K+1 )    )
*
     &        -  SBETA ( K ) / DSIG ( K )
     &           * (     GATV  ( IJ,K ) * GSUMPA( IJ,K+1 )
     &                +  GATVED( IJ,K ) * GSUMPD( IJ,K+1 )   )
*
 6300 CONTINUE
*
*"         < 7.  գ  ֣ >
*
      DO 7100 K = 1, KMAX
         DO 7100 IJ = 1, IDIM*JDIM
            GTUQ( IJ,K ) =  GAU ( IJ,K ) * GAQ    ( IJ,K )
     &                                   * UVFACT ( IJ )
            GTVQ( IJ,K ) =  GAV ( IJ,K ) * GAQ    ( IJ,K )
     &                                   * UVFACT ( IJ )
 7100 CONTINUE
*
*"         < 8.  ҡġܦҰή >
*
      DO 8100 K = 1, KMAX
        DO 8100 IJ = 1, IDIM*JDIM
            GTR ( IJ,K )
     &       =  GTR ( IJ,K ) + GAQ ( IJ,K ) * GADIV( IJ,K )
 8100 CONTINUE
*
      DO 8200 K = 2, KMAX
        DO 8200 IJ = 1, IDIM*JDIM
            GTR ( IJ,K )
     &       =  GTR ( IJ,K )
*
     &        -  GSIGD ( IJ,K )    / ( 2.* DSIG ( K ) )
     &            * (    GAQ ( IJ,K-1 ) - GAQ ( IJ,K   )   )
 8200 CONTINUE
*
      DO 8300 K = 1, KMAX-1
        DO 8300 IJ = 1, IDIM*JDIM
            GTR ( IJ,K )
     &       =  GTR ( IJ,K )
*
     &        -  GSIGD ( IJ,K+1 )  / ( 2.* DSIG ( K ) )
     &            * (    GAQ ( IJ,K ) - GAQ  ( IJ,K+1 )   )
 8300 CONTINUE
*
      RETURN
      END
**********************************************************************
*"       << ɽѲľ® >>
**********************************************************************
      SUBROUTINE PSDOT
     O        ( GSIGD , GSIGDA, GAPADV, GSUMPD, GSUMPA,
     I          GAU   , GAV   , GADIV , GAPIX , GAPIY ,
     C          DSIG  , SIGM  , UVFACT, ER               )
*
*"                 Arakawa & Suarez ľʬ Һɸ
*"                 << semi implicit scheme >>
*
#if   HITAC
      INCLUDE   (ZCDIM)                      !" ʻȿ
#elif SX3
      INCLUDE   "zcdim.F"                    !" ʻȿ
#else
#include        "zcdim.F"                    !" ʻȿ
#endif
*
      REAL       GSIGD ( IDIM*JDIM, KMAX+1 ) !" ҤλѲ
      REAL       GSIGDA( IDIM*JDIM, KMAX+1 ) !" ҤλѲ
      REAL       GAPADV( IDIM*JDIM, KMAX )   !" Фΰή
      REAL       GSUMPD( IDIM*JDIM, KMAX )   !" Ĥαľѻ
      REAL       GSUMPA( IDIM*JDIM, KMAX )   !" Фΰήαľѻ
*
      REAL       GAU   ( IDIM*JDIM, KMAX )   !"   (t)
      REAL       GAV   ( IDIM*JDIM, KMAX )   !"   (t)
      REAL       GADIV ( IDIM*JDIM, KMAX )   !" ȯ  (t)
      REAL       GAPIX ( IDIM*JDIM       )   !" Фʬ
      REAL       GAPIY ( IDIM*JDIM       )   !" Фʬ
*
      REAL       SIGM  ( KMAX+1 )            !" ҥ٥(Ⱦ)
      REAL       DSIG  ( KMAX )              !" 
      REAL       UVFACT( IDIM*JDIM )         !" uU Υե
      REAL       ER                          !" ϵȾ
*
*"         < 1. ή >
*
      DO 1100 K = 1, KMAX
         DO 1100 IJ = 1, IDIM*JDIM
            GAPADV( IJ,K ) =  (   GAU( IJ,K ) * GAPIX( IJ )
     &                          + GAV( IJ,K ) * GAPIY( IJ )  )
     &                         / UVFACT ( IJ ) / ER
 1100 CONTINUE
*
*"         < 2. ήѤ߲ >
*
      DO 2100 IJ = 1, IDIM*JDIM
            GSUMPA ( IJ,KMAX ) = GAPADV( IJ,KMAX ) * DSIG  ( KMAX )
 2100 CONTINUE
*
      DO 2200 K = KMAX-1, 1, -1
         DO 2200 IJ = 1, IDIM*JDIM
            GSUMPA ( IJ,K   ) = GSUMPA( IJ,K+1  )
     &                        + GAPADV( IJ,K    ) * DSIG  ( K )
 2200 CONTINUE
*
*"         < 3. ȯѤ߲ >
*
      DO 3100 IJ = 1, IDIM*JDIM
            GSUMPD( IJ,KMAX ) =  GADIV ( IJ,KMAX ) * DSIG  ( KMAX )
 3100 CONTINUE
*
      DO 3200 K = KMAX-1, 1, -1
         DO 3200 IJ = 1, IDIM*JDIM
            GSUMPD ( IJ,K   ) =  GSUMPD ( IJ,K+1 )
     &                        +  GADIV  ( IJ,K )    * DSIG  ( K )
 3200 CONTINUE
*
*"         < 4. ľ® 
*
      DO 4100 K = 2, KMAX
         DO 4100 IJ = 1, IDIM*JDIM
            GSIGDA( IJ,K ) =  SIGM( K ) * GSUMPA( IJ,1 )
     &                       - GSUMPA( IJ,K )
            GSIGD ( IJ,K ) =  SIGM( K )
     &                        *( GSUMPA( IJ,1 ) + GSUMPD( IJ,1 ) )
     &                       - ( GSUMPA( IJ,K ) + GSUMPD( IJ,K ) )
 4100 CONTINUE
*
      DO 4200 IJ = 1, IDIM*JDIM
            GSIGDA( IJ,1 )      = 0.
            GSIGD ( IJ,1 )      = 0.
            GSIGDA( IJ,KMAX+1 ) = 0.
            GSIGD ( IJ,KMAX+1 ) = 0.
 4200 CONTINUE
*
      RETURN
      END
