*
*"     CRSST   sst(Y)
*
      PROGRAM CRSST
*
#if   HITAC
      INCLUDE   (ZCDIM)
#elif SX3
      INCLUDE   "zcdim.F"
#else
#include        "zcdim.F"
#endif
*
      REAL        GSST  ( IDIM , JDIM  )
      REAL        ALON  ( IDIM )
      REAL        ALAT  ( IDIM )
      REAL        SIG   ( KDIM )
      REAL        SIGM  ( KDIM+1 )
      REAL        DLON  ( IDIM )
      REAL        DLAT  ( IDIM )
      REAL        DSIG  ( KDIM )
      REAL        DSIGM ( KDIM+1 )
*
      CHARACTER HITEM*16,HTITL*32,HUNIT*16
      INTEGER   IT
      INTEGER   IDATE(6)
      INTEGER   ISTEP
*
      CHARACTER DDSET*16
*
*
*"----------< 1. ǡɤ߹ >------------------------------------
*
      WRITE ( 6,*     ) ' DATASET NAME ? '
      READ  ( 5,'(A)' ) DDSET
      WRITE ( 6,*     ) ' Tmin, Tmax, lat0 lat1?'
      READ  ( 5,*     ) TMIN, TMAX, ALAT0, ALAT1
*
*"----------< 3. ǡ񤭹 >------------------------------------
*
      HITEM  = 'GRSST'
      HTITL  = 'Sea Surface Temp.'
      HUNIT  = 'K'
*
      IT       = 0
      IDATE(1) = 1990
      IDATE(2) = 1
      IDATE(3) = 1
      IDATE(4) = 0
      IDATE(5) = 0
      IDATE(6) = 0
      ISTEP    = 0
      ITDUR    = 1
      IOMODE   = 1
      NOEND    = 0
*
      CALL       PCONST
      CALL       GFWOPN
     O         ( JFILE , DDSET )
      CALL       GTCSET( 'DDSET' , DDSET    )
      CALL       GTCSET( 'MYSIGN', 'takepiro'  )
*
      CALL       SETCOR
     O         ( ALON  , DLON  ,
     O           ALAT  , DLAT  ,
     O           SIG   , DSIG  ,
     O           SIGM  , DSIGM  )
*
*"       < 2. ǡ >
*
      CALL       CALSST
     O         ( GSST  ,
     I           ALAT  ,
     I           TMIN  , TMAX ,  ALAT0 , ALAT1, 
     I           IDIM  , JDIM                   )
*
*"       < 3. ǡ񤭹 >
*
      CALL GDWRIT
     O         ( GSST  ,
     I           HITEM , HTITL , HUNIT ,
     I           IT    , IDATE , ISTEP , ITDUR ,
     I           JFILE , IOMODE, NOEND , 'ASFC'  )
*
*
      STOP
      END
***********************************************************************
      SUBROUTINE CALSST
     O         ( GSST  ,
     I           ALAT  ,
     I           TMIN  , TMAX ,  ALAT0 , ALAT1, 
     I           IDIM  , JDIM                  )
*
      REAL        GSST  ( IDIM, JDIM )
      REAL        ALAT  ( JDIM )
*
      PI   = ATAN( 1. ) * 4.
*
      DO 2100 J = 1, JDIM
*
         PHI   = ABS( ALAT( J ) - ALAT0 * PI/180. )
         PHI0  = ABS( ALAT1 * PI/180. )
         GSSTP = TMIN
     &         + ( TMAX - TMIN )
     &           * EXP( - ( PHI/PHI0 )**2 )
*
         DO 2110 I = 1, IDIM
            GSST( I,J ) = GSSTP
 2110    CONTINUE
*
 2100 CONTINUE
*
      RETURN
      END
