#! /usr/bin/python3
import os
import sys
import generator_utils as gen

template = """// @{generatedby}@
/* ///////////////////////// The MPI Bugs Initiative ////////////////////////

  Origin: MBI

  Description: @{shortdesc}@
    @{longdesc}@

  Version of MPI: Conforms to MPI 1.1, does not require MPI 2 implementation

BEGIN_MPI_FEATURES
  P2P!basic: @{p2pfeature}@
  P2P!nonblocking: @{ip2pfeature}@
  P2P!persistent: Lacking
  COLL!basic: Lacking
  COLL!nonblocking: Lacking
  COLL!persistent: Lacking
  COLL!tools: Lacking
  RMA: Lacking
END_MPI_FEATURES

BEGIN_MBI_TESTS
  $ mpirun -np 4 ${EXE}
  | @{outcome}@
  | @{errormsg}@
END_MBI_TESTS
//////////////////////       End of MBI headers        /////////////////// */

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv) {
  int nprocs = -1;
  int rank = -1;
  int src=MPI_ANY_SOURCE, dest=0;
  int stag = 42, rtag = MPI_ANY_TAG;
  int buff_size = 1;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  printf("Hello from rank %d \\n", rank);

  if (nprocs < 2)
    printf("MBI ERROR: This test needs at least 2 processes to produce a bug!\\n");

  int send_buffer=rank;

  MPI_Datatype type = MPI_INT;
  MPI_Comm newcom = MPI_COMM_WORLD;

  @{init1}@
  @{init2}@

  if (rank == 0) {
    for (int i = 0; i < nprocs - 1; i++) {
      @{operation1}@ /* MBIERROR */
      @{fini1}@
    }
  if (@{cond}@ != 3) {
      printf("MBI_MSG_RACE: The last received message is not 3 but %d!\\n", buf1);
      fflush(stdout);
      abort();
    }
  }else{
    @{operation2}@
    @{fini2}@
  }


  MPI_Finalize();
  printf("Rank %d finished normally\\n", rank);
  return 0;
}
"""


for s in gen.send + gen.isend:
    for r in gen.recv + gen.irecv:
        patterns = {}
        patterns = {'s': s, 'r': r}
        patterns['generatedby'] = f'DO NOT EDIT: this file was generated by {os.path.basename(sys.argv[0])}. DO NOT EDIT.'
        patterns['p2pfeature'] = 'Yes' if s in gen.send or r in gen.recv else 'Lacking'
        patterns['ip2pfeature'] = 'Yes' if s in gen.isend or r in gen.irecv else 'Lacking'
        patterns['s'] = s
        patterns['r'] = r
        patterns['cond'] = 'buf1'
        patterns['init2'] = gen.init[s]("2")
        patterns['init1'] = gen.init[r]("1")
        patterns['fini2'] = gen.fini[s]("2")
        patterns['fini1'] = gen.fini[r]("1")
        patterns['operation2'] = gen.operation[s]("2")
        patterns['operation1'] = gen.operation[r]("1")

        # Generate the incorrect matching
        replace = patterns.copy()
        replace['shortdesc'] = 'The message ordering is non-deterministic.'
        replace['longdesc'] = 'The code assumes a fixed order in the reception of messages while the message ordering is non-deterministic.'
        replace['outcome'] = 'ERROR: MessageRace'
        replace['errormsg'] = 'P2P message race which can cause a deadlock. @{r}@ at @{filename}@:@{line:MBIERROR}@ is called with ANY_SRC.'
        gen.make_file(template, f'MessageRace_{r}_{s}_nok.c', replace)
