//! Examples / test cases for identifier pasting.
//!
//! Refer to `idpaste.expanded.rs` to see what this generates.
#![allow(dead_code, unused_variables)]
use derive_deftly::{derive_deftly_adhoc, Deftly};
type FieldType = ();
#[derive_deftly_adhoc]
struct TypeNames {
    /// We use std::slice::Chunks here because that way we can test
    /// identifier pasting with a whole path.  The macro `TypeNames`
    /// will generate a field with type `RChunksMut.
    error: std::slice::Chunks<'static, ()>,
    #[allow(unused_parens)]
    parens: (std::slice::Chunks<'static, ()>),
}
struct PreTypeNamesPost {
    error: std::slice::RChunksMut<'static, ()>,
    parens: (std::slice::RChunksMut<'static, ()>),
}
#[derive_deftly_adhoc]
struct TopName<F> {
    top_name_field: F,
}
#[allow(non_snake_case)]
struct PreTopNamePost<F> {
    TopNameField: F,
}
impl<F> ::std::panic::RefUnwindSafe for PreTopNamePost<F> {}
#[derive_deftly_adhoc]
#[deftly(t_frag = "TFrag")]
struct ExpandName {
    #[deftly(prefix = "attr", suffix = "24")]
    f: FieldType,
    k: String,
    #[deftly(prefix_i = "pub", suffix = "await")]
    p: u32,
    #[deftly(prefix_i = "r#pub", suffix = "")]
    r: u32,
}
struct PreExpandNamePost {
    attr_f_24: FieldType,
    k: String,
    pub_p_await: u32,
    pub_r_: u32,
}
struct WomExpandNameBat;
struct ViaDefineTFrag;
const HUMAN_STR: &str = "$ttype = ExpandName.";
const COMPUTER_STR: &str = "TFrag";
#[derive_deftly_adhoc]
enum EdgeCases {
    Tuple(u32),
    Struct { r#for: u32, unneeded: u32 },
}
impl EdgeCases {
    fn edge_0_end() {}
    fn edge_0forunneeded() {}
    fn r#enum() {}
    fn binding_0_end() {}
    fn binding_for_end() {}
    fn binding_unneeded_end() {}
    fn body() {
        let r#for = ();
        let r#for = ();
        let unneeded = ();
        let unneeded = ();
    }
}
fn main() {}
