/***************************************************************************
  qgstextwidgetwrapper.h

 ---------------------
 begin                : 28.12.2022
 copyright            : (C) 2022 by Alessandro Pasotti
 email                : elpaso at itopen dot it
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QGSTEXTWIDGETWRAPPER_H
#define QGSTEXTWIDGETWRAPPER_H

#include "qgswidgetwrapper.h"
#include "qgis_gui.h"
#include <QLabel>

/**
 * \ingroup gui
 * \brief Wraps a label widget to display text
 * \since QGIS 3.30
 */
class GUI_EXPORT QgsTextWidgetWrapper : public QgsWidgetWrapper
{
    Q_OBJECT

  public:
    /**
     * Create a text widget wrapper
     *
     * \param layer     The layer on which the feature is
     * \param editor    An editor widget. Can be NULLPTR if one should be autogenerated.
     * \param parent    A parent widget
     */
    QgsTextWidgetWrapper( QgsVectorLayer *layer, QWidget *editor, QWidget *parent );

    bool valid() const override;

    QWidget *createWidget( QWidget *parent ) override;

    void initWidget( QWidget *editor ) override;

    //! Clears the content and makes new initialization
    void reinitWidget();

    //! Sets the text code to \a htmlCode
    void setText( const QString &text );

    /**
     * Returns true if the widget needs feature geometry
     */
    bool needsGeometry() const;

  private slots:

    //! sets the context with the current values
    void updateTextContext();

  public slots:
    void setFeature( const QgsFeature &feature ) override;

  private:
    QString mText;
    QLabel *mWidget = nullptr;
    QgsFeature mFeature;
    QgsFeature mFormFeature;
    bool mRequiresFormScope = false;
    QgsExpressionContext mTextContext;
    bool mNeedsGeometry = false;

    friend class TestQgsTextWidgetWrapper;
};


#endif // QGSTEXTWIDGETWRAPPER_H
