# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class ActionDetail(_serialization.Model):
    """The action detail.

    :ivar mechanism_type: The mechanism type.
    :vartype mechanism_type: str
    :ivar name: The name of the action.
    :vartype name: str
    :ivar status: The status of the action.
    :vartype status: str
    :ivar sub_state: The substatus of the action.
    :vartype sub_state: str
    :ivar send_time: The send time.
    :vartype send_time: str
    :ivar detail: The detail of the friendly error message.
    :vartype detail: str
    """

    _attribute_map = {
        "mechanism_type": {"key": "MechanismType", "type": "str"},
        "name": {"key": "Name", "type": "str"},
        "status": {"key": "Status", "type": "str"},
        "sub_state": {"key": "SubState", "type": "str"},
        "send_time": {"key": "SendTime", "type": "str"},
        "detail": {"key": "Detail", "type": "str"},
    }

    def __init__(
        self,
        *,
        mechanism_type: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
        sub_state: Optional[str] = None,
        send_time: Optional[str] = None,
        detail: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mechanism_type: The mechanism type.
        :paramtype mechanism_type: str
        :keyword name: The name of the action.
        :paramtype name: str
        :keyword status: The status of the action.
        :paramtype status: str
        :keyword sub_state: The substatus of the action.
        :paramtype sub_state: str
        :keyword send_time: The send time.
        :paramtype send_time: str
        :keyword detail: The detail of the friendly error message.
        :paramtype detail: str
        """
        super().__init__(**kwargs)
        self.mechanism_type = mechanism_type
        self.name = name
        self.status = status
        self.sub_state = sub_state
        self.send_time = send_time
        self.detail = detail


class ActionGroup(_serialization.Model):
    """A pointer to an Azure Action Group.

    All required parameters must be populated in order to send to server.

    :ivar action_group_id: The resource ID of the Action Group. This cannot be null or empty.
     Required.
    :vartype action_group_id: str
    :ivar webhook_properties: the dictionary of custom properties to include with the post
     operation. These data are appended to the webhook payload.
    :vartype webhook_properties: dict[str, str]
    """

    _validation = {
        "action_group_id": {"required": True},
    }

    _attribute_map = {
        "action_group_id": {"key": "actionGroupId", "type": "str"},
        "webhook_properties": {"key": "webhookProperties", "type": "{str}"},
    }

    def __init__(
        self, *, action_group_id: str, webhook_properties: Optional[dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword action_group_id: The resource ID of the Action Group. This cannot be null or empty.
         Required.
        :paramtype action_group_id: str
        :keyword webhook_properties: the dictionary of custom properties to include with the post
         operation. These data are appended to the webhook payload.
        :paramtype webhook_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.action_group_id = action_group_id
        self.webhook_properties = webhook_properties


class ActionGroupList(_serialization.Model):
    """A list of action groups.

    :ivar value: The list of action groups.
    :vartype value: list[~azure.mgmt.monitor.models.ActionGroupResource]
    :ivar next_link: Provides the link to retrieve the next set of elements.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActionGroupResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ActionGroupResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of action groups.
        :paramtype value: list[~azure.mgmt.monitor.models.ActionGroupResource]
        :keyword next_link: Provides the link to retrieve the next set of elements.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ActionGroupPatchBody(_serialization.Model):
    """An action group object for the body of patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar enabled: Indicates whether this action group is enabled. If an action group is not
     enabled, then none of its actions will be activated.
    :vartype enabled: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, enabled: bool = True, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword enabled: Indicates whether this action group is enabled. If an action group is not
         enabled, then none of its actions will be activated.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.enabled = enabled


class AzureResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class ActionGroupResource(AzureResource):
    """An action group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar group_short_name: The short name of the action group. This will be used in SMS messages.
    :vartype group_short_name: str
    :ivar enabled: Indicates whether this action group is enabled. If an action group is not
     enabled, then none of its receivers will receive communications.
    :vartype enabled: bool
    :ivar email_receivers: The list of email receivers that are part of this action group.
    :vartype email_receivers: list[~azure.mgmt.monitor.models.EmailReceiver]
    :ivar sms_receivers: The list of SMS receivers that are part of this action group.
    :vartype sms_receivers: list[~azure.mgmt.monitor.models.SmsReceiver]
    :ivar webhook_receivers: The list of webhook receivers that are part of this action group.
    :vartype webhook_receivers: list[~azure.mgmt.monitor.models.WebhookReceiver]
    :ivar itsm_receivers: The list of ITSM receivers that are part of this action group.
    :vartype itsm_receivers: list[~azure.mgmt.monitor.models.ItsmReceiver]
    :ivar azure_app_push_receivers: The list of AzureAppPush receivers that are part of this action
     group.
    :vartype azure_app_push_receivers: list[~azure.mgmt.monitor.models.AzureAppPushReceiver]
    :ivar automation_runbook_receivers: The list of AutomationRunbook receivers that are part of
     this action group.
    :vartype automation_runbook_receivers:
     list[~azure.mgmt.monitor.models.AutomationRunbookReceiver]
    :ivar voice_receivers: The list of voice receivers that are part of this action group.
    :vartype voice_receivers: list[~azure.mgmt.monitor.models.VoiceReceiver]
    :ivar logic_app_receivers: The list of logic app receivers that are part of this action group.
    :vartype logic_app_receivers: list[~azure.mgmt.monitor.models.LogicAppReceiver]
    :ivar azure_function_receivers: The list of azure function receivers that are part of this
     action group.
    :vartype azure_function_receivers: list[~azure.mgmt.monitor.models.AzureFunctionReceiver]
    :ivar arm_role_receivers: The list of ARM role receivers that are part of this action group.
     Roles are Azure RBAC roles and only built-in roles are supported.
    :vartype arm_role_receivers: list[~azure.mgmt.monitor.models.ArmRoleReceiver]
    :ivar event_hub_receivers: The list of event hub receivers that are part of this action group.
    :vartype event_hub_receivers: list[~azure.mgmt.monitor.models.EventHubReceiver]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "group_short_name": {"max_length": 12},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "group_short_name": {"key": "properties.groupShortName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "email_receivers": {"key": "properties.emailReceivers", "type": "[EmailReceiver]"},
        "sms_receivers": {"key": "properties.smsReceivers", "type": "[SmsReceiver]"},
        "webhook_receivers": {"key": "properties.webhookReceivers", "type": "[WebhookReceiver]"},
        "itsm_receivers": {"key": "properties.itsmReceivers", "type": "[ItsmReceiver]"},
        "azure_app_push_receivers": {"key": "properties.azureAppPushReceivers", "type": "[AzureAppPushReceiver]"},
        "automation_runbook_receivers": {
            "key": "properties.automationRunbookReceivers",
            "type": "[AutomationRunbookReceiver]",
        },
        "voice_receivers": {"key": "properties.voiceReceivers", "type": "[VoiceReceiver]"},
        "logic_app_receivers": {"key": "properties.logicAppReceivers", "type": "[LogicAppReceiver]"},
        "azure_function_receivers": {"key": "properties.azureFunctionReceivers", "type": "[AzureFunctionReceiver]"},
        "arm_role_receivers": {"key": "properties.armRoleReceivers", "type": "[ArmRoleReceiver]"},
        "event_hub_receivers": {"key": "properties.eventHubReceivers", "type": "[EventHubReceiver]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        group_short_name: Optional[str] = None,
        enabled: bool = True,
        email_receivers: Optional[list["_models.EmailReceiver"]] = None,
        sms_receivers: Optional[list["_models.SmsReceiver"]] = None,
        webhook_receivers: Optional[list["_models.WebhookReceiver"]] = None,
        itsm_receivers: Optional[list["_models.ItsmReceiver"]] = None,
        azure_app_push_receivers: Optional[list["_models.AzureAppPushReceiver"]] = None,
        automation_runbook_receivers: Optional[list["_models.AutomationRunbookReceiver"]] = None,
        voice_receivers: Optional[list["_models.VoiceReceiver"]] = None,
        logic_app_receivers: Optional[list["_models.LogicAppReceiver"]] = None,
        azure_function_receivers: Optional[list["_models.AzureFunctionReceiver"]] = None,
        arm_role_receivers: Optional[list["_models.ArmRoleReceiver"]] = None,
        event_hub_receivers: Optional[list["_models.EventHubReceiver"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword group_short_name: The short name of the action group. This will be used in SMS
         messages.
        :paramtype group_short_name: str
        :keyword enabled: Indicates whether this action group is enabled. If an action group is not
         enabled, then none of its receivers will receive communications.
        :paramtype enabled: bool
        :keyword email_receivers: The list of email receivers that are part of this action group.
        :paramtype email_receivers: list[~azure.mgmt.monitor.models.EmailReceiver]
        :keyword sms_receivers: The list of SMS receivers that are part of this action group.
        :paramtype sms_receivers: list[~azure.mgmt.monitor.models.SmsReceiver]
        :keyword webhook_receivers: The list of webhook receivers that are part of this action group.
        :paramtype webhook_receivers: list[~azure.mgmt.monitor.models.WebhookReceiver]
        :keyword itsm_receivers: The list of ITSM receivers that are part of this action group.
        :paramtype itsm_receivers: list[~azure.mgmt.monitor.models.ItsmReceiver]
        :keyword azure_app_push_receivers: The list of AzureAppPush receivers that are part of this
         action group.
        :paramtype azure_app_push_receivers: list[~azure.mgmt.monitor.models.AzureAppPushReceiver]
        :keyword automation_runbook_receivers: The list of AutomationRunbook receivers that are part of
         this action group.
        :paramtype automation_runbook_receivers:
         list[~azure.mgmt.monitor.models.AutomationRunbookReceiver]
        :keyword voice_receivers: The list of voice receivers that are part of this action group.
        :paramtype voice_receivers: list[~azure.mgmt.monitor.models.VoiceReceiver]
        :keyword logic_app_receivers: The list of logic app receivers that are part of this action
         group.
        :paramtype logic_app_receivers: list[~azure.mgmt.monitor.models.LogicAppReceiver]
        :keyword azure_function_receivers: The list of azure function receivers that are part of this
         action group.
        :paramtype azure_function_receivers: list[~azure.mgmt.monitor.models.AzureFunctionReceiver]
        :keyword arm_role_receivers: The list of ARM role receivers that are part of this action group.
         Roles are Azure RBAC roles and only built-in roles are supported.
        :paramtype arm_role_receivers: list[~azure.mgmt.monitor.models.ArmRoleReceiver]
        :keyword event_hub_receivers: The list of event hub receivers that are part of this action
         group.
        :paramtype event_hub_receivers: list[~azure.mgmt.monitor.models.EventHubReceiver]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.group_short_name = group_short_name
        self.enabled = enabled
        self.email_receivers = email_receivers
        self.sms_receivers = sms_receivers
        self.webhook_receivers = webhook_receivers
        self.itsm_receivers = itsm_receivers
        self.azure_app_push_receivers = azure_app_push_receivers
        self.automation_runbook_receivers = automation_runbook_receivers
        self.voice_receivers = voice_receivers
        self.logic_app_receivers = logic_app_receivers
        self.azure_function_receivers = azure_function_receivers
        self.arm_role_receivers = arm_role_receivers
        self.event_hub_receivers = event_hub_receivers


class ActionList(_serialization.Model):
    """A list of Activity Log Alert rule actions.

    :ivar action_groups: The list of the Action Groups.
    :vartype action_groups: list[~azure.mgmt.monitor.models.ActionGroup]
    """

    _attribute_map = {
        "action_groups": {"key": "actionGroups", "type": "[ActionGroup]"},
    }

    def __init__(self, *, action_groups: Optional[list["_models.ActionGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword action_groups: The list of the Action Groups.
        :paramtype action_groups: list[~azure.mgmt.monitor.models.ActionGroup]
        """
        super().__init__(**kwargs)
        self.action_groups = action_groups


class Actions(_serialization.Model):
    """Actions to invoke when the alert fires.

    :ivar action_groups: Action Group resource Ids to invoke when the alert fires.
    :vartype action_groups: list[str]
    :ivar custom_properties: The properties of an alert payload.
    :vartype custom_properties: dict[str, str]
    :ivar action_properties: The properties of an action properties.
    :vartype action_properties: dict[str, str]
    """

    _attribute_map = {
        "action_groups": {"key": "actionGroups", "type": "[str]"},
        "custom_properties": {"key": "customProperties", "type": "{str}"},
        "action_properties": {"key": "actionProperties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        action_groups: Optional[list[str]] = None,
        custom_properties: Optional[dict[str, str]] = None,
        action_properties: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_groups: Action Group resource Ids to invoke when the alert fires.
        :paramtype action_groups: list[str]
        :keyword custom_properties: The properties of an alert payload.
        :paramtype custom_properties: dict[str, str]
        :keyword action_properties: The properties of an action properties.
        :paramtype action_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.action_groups = action_groups
        self.custom_properties = custom_properties
        self.action_properties = action_properties


class AzureResourceAutoGenerated(_serialization.Model):
    """An Azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource Id.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. Azure Activity Log Alert rules are supported on
     Global, West Europe and North Europe regions.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str = "global", tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource. Azure Activity Log Alert rules are supported
         on Global, West Europe and North Europe regions.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class ActivityLogAlertResource(AzureResourceAutoGenerated):
    """An Activity Log Alert rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource Id.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. Azure Activity Log Alert rules are supported on
     Global, West Europe and North Europe regions.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar scopes: A list of resource IDs that will be used as prefixes. The alert will only apply
     to Activity Log events with resource IDs that fall under one of these prefixes. This list must
     include at least one item.
    :vartype scopes: list[str]
    :ivar condition: The condition that will cause this alert to activate.
    :vartype condition: ~azure.mgmt.monitor.models.AlertRuleAllOfCondition
    :ivar actions: The actions that will activate when the condition is met.
    :vartype actions: ~azure.mgmt.monitor.models.ActionList
    :ivar enabled: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log
     Alert rule is not enabled, then none of its actions will be activated.
    :vartype enabled: bool
    :ivar description: A description of this Activity Log Alert rule.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "condition": {"key": "properties.condition", "type": "AlertRuleAllOfCondition"},
        "actions": {"key": "properties.actions", "type": "ActionList"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str = "global",
        tags: Optional[dict[str, str]] = None,
        scopes: Optional[list[str]] = None,
        condition: Optional["_models.AlertRuleAllOfCondition"] = None,
        actions: Optional["_models.ActionList"] = None,
        enabled: bool = True,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. Azure Activity Log Alert rules are supported
         on Global, West Europe and North Europe regions.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword scopes: A list of resource IDs that will be used as prefixes. The alert will only
         apply to Activity Log events with resource IDs that fall under one of these prefixes. This list
         must include at least one item.
        :paramtype scopes: list[str]
        :keyword condition: The condition that will cause this alert to activate.
        :paramtype condition: ~azure.mgmt.monitor.models.AlertRuleAllOfCondition
        :keyword actions: The actions that will activate when the condition is met.
        :paramtype actions: ~azure.mgmt.monitor.models.ActionList
        :keyword enabled: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log
         Alert rule is not enabled, then none of its actions will be activated.
        :paramtype enabled: bool
        :keyword description: A description of this Activity Log Alert rule.
        :paramtype description: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.scopes = scopes
        self.condition = condition
        self.actions = actions
        self.enabled = enabled
        self.description = description


class AdxDestination(_serialization.Model):
    """Azure Data Explorer (Adx) destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: The ARM resource id of the Adx resource.
    :vartype resource_id: str
    :ivar database_name: The name of the database to which data will be ingested.
    :vartype database_name: str
    :ivar ingestion_uri: The ingestion uri of the Adx resource.
    :vartype ingestion_uri: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "ingestion_uri": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "ingestion_uri": {"key": "ingestionUri", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        database_name: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The ARM resource id of the Adx resource.
        :paramtype resource_id: str
        :keyword database_name: The name of the database to which data will be ingested.
        :paramtype database_name: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.database_name = database_name
        self.ingestion_uri: Optional[str] = None
        self.name = name


class AgentSetting(_serialization.Model):
    """A setting used to control an agent behavior on a host machine.

    :ivar name: The name of the setting.
     Must be part of the list of supported settings. Known values are: "MaxDiskQuotaInMB" and
     "UseTimeReceivedForForwardedEvents".
    :vartype name: str or ~azure.mgmt.monitor.models.KnownAgentSettingName
    :ivar value: The value of the setting.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.KnownAgentSettingName"]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the setting.
         Must be part of the list of supported settings. Known values are: "MaxDiskQuotaInMB" and
         "UseTimeReceivedForForwardedEvents".
        :paramtype name: str or ~azure.mgmt.monitor.models.KnownAgentSettingName
        :keyword value: The value of the setting.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class AgentSettingsSpec(_serialization.Model):
    """An agent setting.

    :ivar logs: All the settings that are applicable to the logs agent (AMA).
    :vartype logs: list[~azure.mgmt.monitor.models.AgentSetting]
    """

    _attribute_map = {
        "logs": {"key": "logs", "type": "[AgentSetting]"},
    }

    def __init__(self, *, logs: Optional[list["_models.AgentSetting"]] = None, **kwargs: Any) -> None:
        """
        :keyword logs: All the settings that are applicable to the logs agent (AMA).
        :paramtype logs: list[~azure.mgmt.monitor.models.AgentSetting]
        """
        super().__init__(**kwargs)
        self.logs = logs


class AlertRuleAllOfCondition(_serialization.Model):
    """An Activity Log Alert rule condition that is met when all its member conditions are met.

    All required parameters must be populated in order to send to server.

    :ivar all_of: The list of Activity Log Alert rule conditions. Required.
    :vartype all_of: list[~azure.mgmt.monitor.models.AlertRuleAnyOfOrLeafCondition]
    """

    _validation = {
        "all_of": {"required": True},
    }

    _attribute_map = {
        "all_of": {"key": "allOf", "type": "[AlertRuleAnyOfOrLeafCondition]"},
    }

    def __init__(self, *, all_of: list["_models.AlertRuleAnyOfOrLeafCondition"], **kwargs: Any) -> None:
        """
        :keyword all_of: The list of Activity Log Alert rule conditions. Required.
        :paramtype all_of: list[~azure.mgmt.monitor.models.AlertRuleAnyOfOrLeafCondition]
        """
        super().__init__(**kwargs)
        self.all_of = all_of


class AlertRuleLeafCondition(_serialization.Model):
    """An Activity Log Alert rule condition that is met by comparing the field and value of an
    Activity Log event.
    This condition must contain 'field' and either 'equals' or 'containsAny'.

    :ivar field: The name of the Activity Log event's field that this condition will examine.
     The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller',
     'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus',
     'resourceType', or anything beginning with 'properties'.
    :vartype field: str
    :ivar equals: The value of the event's field will be compared to this value (case-insensitive)
     to determine if the condition is met.
    :vartype equals: str
    :ivar contains_any: The value of the event's field will be compared to the values in this array
     (case-insensitive) to determine if the condition is met.
    :vartype contains_any: list[str]
    """

    _attribute_map = {
        "field": {"key": "field", "type": "str"},
        "equals": {"key": "equals", "type": "str"},
        "contains_any": {"key": "containsAny", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        field: Optional[str] = None,
        equals: Optional[str] = None,
        contains_any: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword field: The name of the Activity Log event's field that this condition will examine.
         The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller',
         'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus',
         'resourceType', or anything beginning with 'properties'.
        :paramtype field: str
        :keyword equals: The value of the event's field will be compared to this value
         (case-insensitive) to determine if the condition is met.
        :paramtype equals: str
        :keyword contains_any: The value of the event's field will be compared to the values in this
         array (case-insensitive) to determine if the condition is met.
        :paramtype contains_any: list[str]
        """
        super().__init__(**kwargs)
        self.field = field
        self.equals = equals
        self.contains_any = contains_any


class AlertRuleAnyOfOrLeafCondition(AlertRuleLeafCondition):
    """An Activity Log Alert rule condition that is met when all its member conditions are met.
    Each condition can be of one of the following types:
    **Important**\\ : Each type has its unique subset of properties. Properties from different
    types CANNOT exist in one condition.


    * **Leaf Condition -** must contain 'field' and either 'equals' or 'containsAny'.
      *Please note, 'anyOf' should **not** be set in a Leaf Condition.*

      * **AnyOf Condition -** must contain **only** 'anyOf' (which is an array of Leaf Conditions).
        *Please note, 'field', 'equals' and 'containsAny' should **not** be set in an AnyOf
    Condition.*.

    :ivar field: The name of the Activity Log event's field that this condition will examine.
     The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller',
     'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus',
     'resourceType', or anything beginning with 'properties'.
    :vartype field: str
    :ivar equals: The value of the event's field will be compared to this value (case-insensitive)
     to determine if the condition is met.
    :vartype equals: str
    :ivar contains_any: The value of the event's field will be compared to the values in this array
     (case-insensitive) to determine if the condition is met.
    :vartype contains_any: list[str]
    :ivar any_of: An Activity Log Alert rule condition that is met when at least one of its member
     leaf conditions are met.
    :vartype any_of: list[~azure.mgmt.monitor.models.AlertRuleLeafCondition]
    """

    _attribute_map = {
        "field": {"key": "field", "type": "str"},
        "equals": {"key": "equals", "type": "str"},
        "contains_any": {"key": "containsAny", "type": "[str]"},
        "any_of": {"key": "anyOf", "type": "[AlertRuleLeafCondition]"},
    }

    def __init__(
        self,
        *,
        field: Optional[str] = None,
        equals: Optional[str] = None,
        contains_any: Optional[list[str]] = None,
        any_of: Optional[list["_models.AlertRuleLeafCondition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword field: The name of the Activity Log event's field that this condition will examine.
         The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller',
         'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus',
         'resourceType', or anything beginning with 'properties'.
        :paramtype field: str
        :keyword equals: The value of the event's field will be compared to this value
         (case-insensitive) to determine if the condition is met.
        :paramtype equals: str
        :keyword contains_any: The value of the event's field will be compared to the values in this
         array (case-insensitive) to determine if the condition is met.
        :paramtype contains_any: list[str]
        :keyword any_of: An Activity Log Alert rule condition that is met when at least one of its
         member leaf conditions are met.
        :paramtype any_of: list[~azure.mgmt.monitor.models.AlertRuleLeafCondition]
        """
        super().__init__(field=field, equals=equals, contains_any=contains_any, **kwargs)
        self.any_of = any_of


class AlertRuleList(_serialization.Model):
    """A list of Activity Log Alert rules.

    :ivar value: The list of Activity Log Alert rules.
    :vartype value: list[~azure.mgmt.monitor.models.ActivityLogAlertResource]
    :ivar next_link: Provides the link to retrieve the next set of elements.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActivityLogAlertResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ActivityLogAlertResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of Activity Log Alert rules.
        :paramtype value: list[~azure.mgmt.monitor.models.ActivityLogAlertResource]
        :keyword next_link: Provides the link to retrieve the next set of elements.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertRulePatchObject(_serialization.Model):
    """An Activity Log Alert rule object for the body of patch operations.

    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar enabled: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log
     Alert rule is not enabled, then none of its actions will be activated.
    :vartype enabled: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, enabled: bool = True, **kwargs: Any) -> None:
        """
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword enabled: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log
         Alert rule is not enabled, then none of its actions will be activated.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.enabled = enabled


class ArmRoleReceiver(_serialization.Model):
    """An arm role receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the arm role receiver. Names must be unique across all receivers within
     an action group. Required.
    :vartype name: str
    :ivar role_id: The arm role id. Required.
    :vartype role_id: str
    :ivar use_common_alert_schema: Indicates whether to use common alert schema.
    :vartype use_common_alert_schema: bool
    """

    _validation = {
        "name": {"required": True},
        "role_id": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "role_id": {"key": "roleId", "type": "str"},
        "use_common_alert_schema": {"key": "useCommonAlertSchema", "type": "bool"},
    }

    def __init__(self, *, name: str, role_id: str, use_common_alert_schema: bool = False, **kwargs: Any) -> None:
        """
        :keyword name: The name of the arm role receiver. Names must be unique across all receivers
         within an action group. Required.
        :paramtype name: str
        :keyword role_id: The arm role id. Required.
        :paramtype role_id: str
        :keyword use_common_alert_schema: Indicates whether to use common alert schema.
        :paramtype use_common_alert_schema: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.role_id = role_id
        self.use_common_alert_schema = use_common_alert_schema


class AutomationRunbookReceiver(_serialization.Model):
    """The Azure Automation Runbook notification receiver.

    All required parameters must be populated in order to send to server.

    :ivar automation_account_id: The Azure automation account Id which holds this runbook and
     authenticate to Azure resource. Required.
    :vartype automation_account_id: str
    :ivar runbook_name: The name for this runbook. Required.
    :vartype runbook_name: str
    :ivar webhook_resource_id: The resource id for webhook linked to this runbook. Required.
    :vartype webhook_resource_id: str
    :ivar is_global_runbook: Indicates whether this instance is global runbook. Required.
    :vartype is_global_runbook: bool
    :ivar name: Indicates name of the webhook.
    :vartype name: str
    :ivar service_uri: The URI where webhooks should be sent.
    :vartype service_uri: str
    :ivar use_common_alert_schema: Indicates whether to use common alert schema.
    :vartype use_common_alert_schema: bool
    """

    _validation = {
        "automation_account_id": {"required": True},
        "runbook_name": {"required": True},
        "webhook_resource_id": {"required": True},
        "is_global_runbook": {"required": True},
    }

    _attribute_map = {
        "automation_account_id": {"key": "automationAccountId", "type": "str"},
        "runbook_name": {"key": "runbookName", "type": "str"},
        "webhook_resource_id": {"key": "webhookResourceId", "type": "str"},
        "is_global_runbook": {"key": "isGlobalRunbook", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "service_uri": {"key": "serviceUri", "type": "str"},
        "use_common_alert_schema": {"key": "useCommonAlertSchema", "type": "bool"},
    }

    def __init__(
        self,
        *,
        automation_account_id: str,
        runbook_name: str,
        webhook_resource_id: str,
        is_global_runbook: bool,
        name: Optional[str] = None,
        service_uri: Optional[str] = None,
        use_common_alert_schema: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword automation_account_id: The Azure automation account Id which holds this runbook and
         authenticate to Azure resource. Required.
        :paramtype automation_account_id: str
        :keyword runbook_name: The name for this runbook. Required.
        :paramtype runbook_name: str
        :keyword webhook_resource_id: The resource id for webhook linked to this runbook. Required.
        :paramtype webhook_resource_id: str
        :keyword is_global_runbook: Indicates whether this instance is global runbook. Required.
        :paramtype is_global_runbook: bool
        :keyword name: Indicates name of the webhook.
        :paramtype name: str
        :keyword service_uri: The URI where webhooks should be sent.
        :paramtype service_uri: str
        :keyword use_common_alert_schema: Indicates whether to use common alert schema.
        :paramtype use_common_alert_schema: bool
        """
        super().__init__(**kwargs)
        self.automation_account_id = automation_account_id
        self.runbook_name = runbook_name
        self.webhook_resource_id = webhook_resource_id
        self.is_global_runbook = is_global_runbook
        self.name = name
        self.service_uri = service_uri
        self.use_common_alert_schema = use_common_alert_schema


class AutoscaleErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.monitor.models.AutoscaleErrorResponseError
    :ivar system_data: The system metadata related to the response.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    """

    _validation = {
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "AutoscaleErrorResponseError"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, error: Optional["_models.AutoscaleErrorResponseError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.monitor.models.AutoscaleErrorResponseError
        """
        super().__init__(**kwargs)
        self.error = error
        self.system_data: Optional["_models.SystemData"] = None


class AutoscaleErrorResponseError(_serialization.Model):
    """The error object.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar message: A human-readable representation of the error.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar details: A human-readable representation of the error's details.
    :vartype details: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: One of a server-defined set of error codes.
        :paramtype code: str
        :keyword message: A human-readable representation of the error.
        :paramtype message: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword details: A human-readable representation of the error's details.
        :paramtype details: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class AutoscaleNotification(_serialization.Model):
    """Autoscale notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar operation: the operation associated with the notification and its value must be "scale".
     Required. Default value is "Scale".
    :vartype operation: str
    :ivar email: the email notification.
    :vartype email: ~azure.mgmt.monitor.models.EmailNotification
    :ivar webhooks: the collection of webhook notifications.
    :vartype webhooks: list[~azure.mgmt.monitor.models.WebhookNotification]
    """

    _validation = {
        "operation": {"required": True, "constant": True},
    }

    _attribute_map = {
        "operation": {"key": "operation", "type": "str"},
        "email": {"key": "email", "type": "EmailNotification"},
        "webhooks": {"key": "webhooks", "type": "[WebhookNotification]"},
    }

    operation = "Scale"

    def __init__(
        self,
        *,
        email: Optional["_models.EmailNotification"] = None,
        webhooks: Optional[list["_models.WebhookNotification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword email: the email notification.
        :paramtype email: ~azure.mgmt.monitor.models.EmailNotification
        :keyword webhooks: the collection of webhook notifications.
        :paramtype webhooks: list[~azure.mgmt.monitor.models.WebhookNotification]
        """
        super().__init__(**kwargs)
        self.email = email
        self.webhooks = webhooks


class AutoscaleProfile(_serialization.Model):
    """Autoscale profile.

    All required parameters must be populated in order to send to server.

    :ivar name: the name of the profile. Required.
    :vartype name: str
    :ivar capacity: the number of instances that can be used during this profile. Required.
    :vartype capacity: ~azure.mgmt.monitor.models.ScaleCapacity
    :ivar rules: the collection of rules that provide the triggers and parameters for the scaling
     action. A maximum of 10 rules can be specified. Required.
    :vartype rules: list[~azure.mgmt.monitor.models.ScaleRule]
    :ivar fixed_date: the specific date-time for the profile. This element is not used if the
     Recurrence element is used.
    :vartype fixed_date: ~azure.mgmt.monitor.models.TimeWindow
    :ivar recurrence: the repeating times at which this profile begins. This element is not used if
     the FixedDate element is used.
    :vartype recurrence: ~azure.mgmt.monitor.models.Recurrence
    """

    _validation = {
        "name": {"required": True},
        "capacity": {"required": True},
        "rules": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "ScaleCapacity"},
        "rules": {"key": "rules", "type": "[ScaleRule]"},
        "fixed_date": {"key": "fixedDate", "type": "TimeWindow"},
        "recurrence": {"key": "recurrence", "type": "Recurrence"},
    }

    def __init__(
        self,
        *,
        name: str,
        capacity: "_models.ScaleCapacity",
        rules: list["_models.ScaleRule"],
        fixed_date: Optional["_models.TimeWindow"] = None,
        recurrence: Optional["_models.Recurrence"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: the name of the profile. Required.
        :paramtype name: str
        :keyword capacity: the number of instances that can be used during this profile. Required.
        :paramtype capacity: ~azure.mgmt.monitor.models.ScaleCapacity
        :keyword rules: the collection of rules that provide the triggers and parameters for the
         scaling action. A maximum of 10 rules can be specified. Required.
        :paramtype rules: list[~azure.mgmt.monitor.models.ScaleRule]
        :keyword fixed_date: the specific date-time for the profile. This element is not used if the
         Recurrence element is used.
        :paramtype fixed_date: ~azure.mgmt.monitor.models.TimeWindow
        :keyword recurrence: the repeating times at which this profile begins. This element is not used
         if the FixedDate element is used.
        :paramtype recurrence: ~azure.mgmt.monitor.models.Recurrence
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity
        self.rules = rules
        self.fixed_date = fixed_date
        self.recurrence = recurrence


class Resource(_serialization.Model):
    """The autoscale setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key no greater in length than 128
     characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar system_data: The system metadata related to the response.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Gets or sets a list of key value pairs that describe the resource. These tags
         can be used in viewing and grouping this resource (across resource groups). A maximum of 15
         tags can be provided for a resource. Each tag must have a key no greater in length than 128
         characters and a value no greater in length than 256 characters.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags
        self.system_data: Optional["_models.SystemData"] = None


class AutoscaleSettingResource(Resource):
    """The autoscale setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key no greater in length than 128
     characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar system_data: The system metadata related to the response.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    :ivar profiles: the collection of automatic scaling profiles that specify different scaling
     parameters for different time periods. A maximum of 20 profiles can be specified. Required.
    :vartype profiles: list[~azure.mgmt.monitor.models.AutoscaleProfile]
    :ivar notifications: the collection of notifications.
    :vartype notifications: list[~azure.mgmt.monitor.models.AutoscaleNotification]
    :ivar enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'false'.
    :vartype enabled: bool
    :ivar predictive_autoscale_policy: the predictive autoscale policy mode.
    :vartype predictive_autoscale_policy: ~azure.mgmt.monitor.models.PredictiveAutoscalePolicy
    :ivar name_properties_name: the name of the autoscale setting.
    :vartype name_properties_name: str
    :ivar target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :vartype target_resource_uri: str
    :ivar target_resource_location: the location of the resource that the autoscale setting should
     be added to.
    :vartype target_resource_location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "profiles": {"required": True, "max_items": 20, "min_items": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "profiles": {"key": "properties.profiles", "type": "[AutoscaleProfile]"},
        "notifications": {"key": "properties.notifications", "type": "[AutoscaleNotification]"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "predictive_autoscale_policy": {
            "key": "properties.predictiveAutoscalePolicy",
            "type": "PredictiveAutoscalePolicy",
        },
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "target_resource_uri": {"key": "properties.targetResourceUri", "type": "str"},
        "target_resource_location": {"key": "properties.targetResourceLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        profiles: list["_models.AutoscaleProfile"],
        tags: Optional[dict[str, str]] = None,
        notifications: Optional[list["_models.AutoscaleNotification"]] = None,
        enabled: bool = False,
        predictive_autoscale_policy: Optional["_models.PredictiveAutoscalePolicy"] = None,
        name_properties_name: Optional[str] = None,
        target_resource_uri: Optional[str] = None,
        target_resource_location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Gets or sets a list of key value pairs that describe the resource. These tags
         can be used in viewing and grouping this resource (across resource groups). A maximum of 15
         tags can be provided for a resource. Each tag must have a key no greater in length than 128
         characters and a value no greater in length than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword profiles: the collection of automatic scaling profiles that specify different scaling
         parameters for different time periods. A maximum of 20 profiles can be specified. Required.
        :paramtype profiles: list[~azure.mgmt.monitor.models.AutoscaleProfile]
        :keyword notifications: the collection of notifications.
        :paramtype notifications: list[~azure.mgmt.monitor.models.AutoscaleNotification]
        :keyword enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
         resource. The default value is 'false'.
        :paramtype enabled: bool
        :keyword predictive_autoscale_policy: the predictive autoscale policy mode.
        :paramtype predictive_autoscale_policy: ~azure.mgmt.monitor.models.PredictiveAutoscalePolicy
        :keyword name_properties_name: the name of the autoscale setting.
        :paramtype name_properties_name: str
        :keyword target_resource_uri: the resource identifier of the resource that the autoscale
         setting should be added to.
        :paramtype target_resource_uri: str
        :keyword target_resource_location: the location of the resource that the autoscale setting
         should be added to.
        :paramtype target_resource_location: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.profiles = profiles
        self.notifications = notifications
        self.enabled = enabled
        self.predictive_autoscale_policy = predictive_autoscale_policy
        self.name_properties_name = name_properties_name
        self.target_resource_uri = target_resource_uri
        self.target_resource_location = target_resource_location


class AutoscaleSettingResourceCollection(_serialization.Model):
    """Represents a collection of autoscale setting resources.

    All required parameters must be populated in order to send to server.

    :ivar value: the values for the autoscale setting resources. Required.
    :vartype value: list[~azure.mgmt.monitor.models.AutoscaleSettingResource]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutoscaleSettingResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.AutoscaleSettingResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: the values for the autoscale setting resources. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.AutoscaleSettingResource]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutoscaleSettingResourcePatch(_serialization.Model):
    """The autoscale setting object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar profiles: the collection of automatic scaling profiles that specify different scaling
     parameters for different time periods. A maximum of 20 profiles can be specified.
    :vartype profiles: list[~azure.mgmt.monitor.models.AutoscaleProfile]
    :ivar notifications: the collection of notifications.
    :vartype notifications: list[~azure.mgmt.monitor.models.AutoscaleNotification]
    :ivar enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'false'.
    :vartype enabled: bool
    :ivar predictive_autoscale_policy: the predictive autoscale policy mode.
    :vartype predictive_autoscale_policy: ~azure.mgmt.monitor.models.PredictiveAutoscalePolicy
    :ivar name: the name of the autoscale setting.
    :vartype name: str
    :ivar target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :vartype target_resource_uri: str
    :ivar target_resource_location: the location of the resource that the autoscale setting should
     be added to.
    :vartype target_resource_location: str
    """

    _validation = {
        "profiles": {"max_items": 20, "min_items": 0},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "profiles": {"key": "properties.profiles", "type": "[AutoscaleProfile]"},
        "notifications": {"key": "properties.notifications", "type": "[AutoscaleNotification]"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "predictive_autoscale_policy": {
            "key": "properties.predictiveAutoscalePolicy",
            "type": "PredictiveAutoscalePolicy",
        },
        "name": {"key": "properties.name", "type": "str"},
        "target_resource_uri": {"key": "properties.targetResourceUri", "type": "str"},
        "target_resource_location": {"key": "properties.targetResourceLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        profiles: Optional[list["_models.AutoscaleProfile"]] = None,
        notifications: Optional[list["_models.AutoscaleNotification"]] = None,
        enabled: bool = False,
        predictive_autoscale_policy: Optional["_models.PredictiveAutoscalePolicy"] = None,
        name: Optional[str] = None,
        target_resource_uri: Optional[str] = None,
        target_resource_location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword profiles: the collection of automatic scaling profiles that specify different scaling
         parameters for different time periods. A maximum of 20 profiles can be specified.
        :paramtype profiles: list[~azure.mgmt.monitor.models.AutoscaleProfile]
        :keyword notifications: the collection of notifications.
        :paramtype notifications: list[~azure.mgmt.monitor.models.AutoscaleNotification]
        :keyword enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
         resource. The default value is 'false'.
        :paramtype enabled: bool
        :keyword predictive_autoscale_policy: the predictive autoscale policy mode.
        :paramtype predictive_autoscale_policy: ~azure.mgmt.monitor.models.PredictiveAutoscalePolicy
        :keyword name: the name of the autoscale setting.
        :paramtype name: str
        :keyword target_resource_uri: the resource identifier of the resource that the autoscale
         setting should be added to.
        :paramtype target_resource_uri: str
        :keyword target_resource_location: the location of the resource that the autoscale setting
         should be added to.
        :paramtype target_resource_location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.profiles = profiles
        self.notifications = notifications
        self.enabled = enabled
        self.predictive_autoscale_policy = predictive_autoscale_policy
        self.name = name
        self.target_resource_uri = target_resource_uri
        self.target_resource_location = target_resource_location


class AzureAppPushReceiver(_serialization.Model):
    """The Azure mobile App push notification receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the Azure mobile app push receiver. Names must be unique across all
     receivers within an action group. Required.
    :vartype name: str
    :ivar email_address: The email address registered for the Azure mobile app. Required.
    :vartype email_address: str
    """

    _validation = {
        "name": {"required": True},
        "email_address": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
    }

    def __init__(self, *, name: str, email_address: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the Azure mobile app push receiver. Names must be unique across all
         receivers within an action group. Required.
        :paramtype name: str
        :keyword email_address: The email address registered for the Azure mobile app. Required.
        :paramtype email_address: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.email_address = email_address


class AzureFunctionReceiver(_serialization.Model):
    """An azure function receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the azure function receiver. Names must be unique across all receivers
     within an action group. Required.
    :vartype name: str
    :ivar function_app_resource_id: The azure resource id of the function app. Required.
    :vartype function_app_resource_id: str
    :ivar function_name: The function name in the function app. Required.
    :vartype function_name: str
    :ivar http_trigger_url: The http trigger url where http request sent to. Required.
    :vartype http_trigger_url: str
    :ivar use_common_alert_schema: Indicates whether to use common alert schema.
    :vartype use_common_alert_schema: bool
    """

    _validation = {
        "name": {"required": True},
        "function_app_resource_id": {"required": True},
        "function_name": {"required": True},
        "http_trigger_url": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "function_app_resource_id": {"key": "functionAppResourceId", "type": "str"},
        "function_name": {"key": "functionName", "type": "str"},
        "http_trigger_url": {"key": "httpTriggerUrl", "type": "str"},
        "use_common_alert_schema": {"key": "useCommonAlertSchema", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        function_app_resource_id: str,
        function_name: str,
        http_trigger_url: str,
        use_common_alert_schema: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the azure function receiver. Names must be unique across all
         receivers within an action group. Required.
        :paramtype name: str
        :keyword function_app_resource_id: The azure resource id of the function app. Required.
        :paramtype function_app_resource_id: str
        :keyword function_name: The function name in the function app. Required.
        :paramtype function_name: str
        :keyword http_trigger_url: The http trigger url where http request sent to. Required.
        :paramtype http_trigger_url: str
        :keyword use_common_alert_schema: Indicates whether to use common alert schema.
        :paramtype use_common_alert_schema: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.function_app_resource_id = function_app_resource_id
        self.function_name = function_name
        self.http_trigger_url = http_trigger_url
        self.use_common_alert_schema = use_common_alert_schema


class AzureMonitorMetricsDestination(_serialization.Model):
    """Azure Monitor Metrics destination.

    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class PrivateLinkScopesResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class AzureMonitorPrivateLinkScope(PrivateLinkScopesResource):
    """An Azure Monitor PrivateLinkScope definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: Current state of this PrivateLinkScope: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
    :vartype provisioning_state: str
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.monitor.models.PrivateEndpointConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state: Optional[str] = None
        self.private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = None


class AzureMonitorPrivateLinkScopeListResult(_serialization.Model):
    """Describes the list of Azure Monitor PrivateLinkScope resources.

    All required parameters must be populated in order to send to server.

    :ivar value: List of Azure Monitor PrivateLinkScope definitions. Required.
    :vartype value: list[~azure.mgmt.monitor.models.AzureMonitorPrivateLinkScope]
    :ivar next_link: The URI to get the next set of Azure Monitor PrivateLinkScope definitions if
     too many PrivateLinkScopes where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureMonitorPrivateLinkScope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.AzureMonitorPrivateLinkScope"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Monitor PrivateLinkScope definitions. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.AzureMonitorPrivateLinkScope]
        :keyword next_link: The URI to get the next set of Azure Monitor PrivateLinkScope definitions
         if too many PrivateLinkScopes where returned in the result set.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureMonitorWorkspace(_serialization.Model):
    """Properties of an Azure Monitor Workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_id: The immutable Id of the Azure Monitor Workspace. This property is read-only.
    :vartype account_id: str
    :ivar metrics: Properties related to the metrics container in the Azure Monitor Workspace.
    :vartype metrics: ~azure.mgmt.monitor.models.AzureMonitorWorkspaceMetrics
    :ivar provisioning_state: The provisioning state of the Azure Monitor Workspace. Set to
     Succeeded if everything is healthy. Known values are: "Creating", "Succeeded", "Deleting",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.monitor.models.ProvisioningState
    :ivar default_ingestion_settings: The Data Collection Rule and Endpoint used for ingestion by
     default.
    :vartype default_ingestion_settings:
     ~azure.mgmt.monitor.models.AzureMonitorWorkspaceDefaultIngestionSettings
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.monitor.models.PrivateEndpointConnectionAutoGenerated]
    :ivar public_network_access: Gets or sets allow or disallow public network access to Azure
     Monitor Workspace. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.monitor.models.PublicNetworkAccess
    """

    _validation = {
        "account_id": {"readonly": True},
        "metrics": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "default_ingestion_settings": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "account_id": {"key": "accountId", "type": "str"},
        "metrics": {"key": "metrics", "type": "AzureMonitorWorkspaceMetrics"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "default_ingestion_settings": {
            "key": "defaultIngestionSettings",
            "type": "AzureMonitorWorkspaceDefaultIngestionSettings",
        },
        "private_endpoint_connections": {
            "key": "privateEndpointConnections",
            "type": "[PrivateEndpointConnectionAutoGenerated]",
        },
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self, *, public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_network_access: Gets or sets allow or disallow public network access to Azure
         Monitor Workspace. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.monitor.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.account_id: Optional[str] = None
        self.metrics: Optional["_models.AzureMonitorWorkspaceMetrics"] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.default_ingestion_settings: Optional["_models.AzureMonitorWorkspaceDefaultIngestionSettings"] = None
        self.private_endpoint_connections: Optional[list["_models.PrivateEndpointConnectionAutoGenerated"]] = None
        self.public_network_access = public_network_access


class IngestionSettings(_serialization.Model):
    """Settings for data ingestion.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_collection_rule_resource_id: The Azure resource Id of the default data collection
     rule for this Azure Monitor Workspace.
    :vartype data_collection_rule_resource_id: str
    :ivar data_collection_endpoint_resource_id: The Azure resource Id of the default data
     collection endpoint for this Azure Monitor Workspace.
    :vartype data_collection_endpoint_resource_id: str
    """

    _validation = {
        "data_collection_rule_resource_id": {"readonly": True},
        "data_collection_endpoint_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "data_collection_rule_resource_id": {"key": "dataCollectionRuleResourceId", "type": "str"},
        "data_collection_endpoint_resource_id": {"key": "dataCollectionEndpointResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.data_collection_rule_resource_id: Optional[str] = None
        self.data_collection_endpoint_resource_id: Optional[str] = None


class AzureMonitorWorkspaceDefaultIngestionSettings(IngestionSettings):  # pylint: disable=name-too-long
    """The Data Collection Rule and Endpoint used for ingestion by default.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_collection_rule_resource_id: The Azure resource Id of the default data collection
     rule for this Azure Monitor Workspace.
    :vartype data_collection_rule_resource_id: str
    :ivar data_collection_endpoint_resource_id: The Azure resource Id of the default data
     collection endpoint for this Azure Monitor Workspace.
    :vartype data_collection_endpoint_resource_id: str
    """


class Metrics(_serialization.Model):
    """Properties related to the metrics container in the Azure Monitor Workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar prometheus_query_endpoint: The Prometheus query endpoint for the Azure Monitor Workspace.
    :vartype prometheus_query_endpoint: str
    :ivar internal_id: An internal identifier for the metrics container. Only to be used by the
     system.
    :vartype internal_id: str
    """

    _validation = {
        "prometheus_query_endpoint": {"readonly": True},
        "internal_id": {"readonly": True},
    }

    _attribute_map = {
        "prometheus_query_endpoint": {"key": "prometheusQueryEndpoint", "type": "str"},
        "internal_id": {"key": "internalId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.prometheus_query_endpoint: Optional[str] = None
        self.internal_id: Optional[str] = None


class AzureMonitorWorkspaceMetrics(Metrics):
    """Properties related to the metrics container in the Azure Monitor Workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar prometheus_query_endpoint: The Prometheus query endpoint for the Azure Monitor Workspace.
    :vartype prometheus_query_endpoint: str
    :ivar internal_id: An internal identifier for the metrics container. Only to be used by the
     system.
    :vartype internal_id: str
    """


class ResourceAutoGenerated8(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class TrackedResource(ResourceAutoGenerated8):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AzureMonitorWorkspaceResource(TrackedResource):
    """An Azure Monitor Workspace definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar account_id: The immutable Id of the Azure Monitor Workspace. This property is read-only.
    :vartype account_id: str
    :ivar metrics: Properties related to the metrics container in the Azure Monitor Workspace.
    :vartype metrics: ~azure.mgmt.monitor.models.AzureMonitorWorkspaceMetrics
    :ivar provisioning_state: The provisioning state of the Azure Monitor Workspace. Set to
     Succeeded if everything is healthy. Known values are: "Creating", "Succeeded", "Deleting",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.monitor.models.ProvisioningState
    :ivar default_ingestion_settings: The Data Collection Rule and Endpoint used for ingestion by
     default.
    :vartype default_ingestion_settings:
     ~azure.mgmt.monitor.models.AzureMonitorWorkspaceDefaultIngestionSettings
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.monitor.models.PrivateEndpointConnectionAutoGenerated]
    :ivar public_network_access: Gets or sets allow or disallow public network access to Azure
     Monitor Workspace. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.monitor.models.PublicNetworkAccess
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "etag": {"readonly": True},
        "account_id": {"readonly": True},
        "metrics": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "default_ingestion_settings": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "account_id": {"key": "properties.accountId", "type": "str"},
        "metrics": {"key": "properties.metrics", "type": "AzureMonitorWorkspaceMetrics"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "default_ingestion_settings": {
            "key": "properties.defaultIngestionSettings",
            "type": "AzureMonitorWorkspaceDefaultIngestionSettings",
        },
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnectionAutoGenerated]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword public_network_access: Gets or sets allow or disallow public network access to Azure
         Monitor Workspace. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.monitor.models.PublicNetworkAccess
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.etag: Optional[str] = None
        self.account_id: Optional[str] = None
        self.metrics: Optional["_models.AzureMonitorWorkspaceMetrics"] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.default_ingestion_settings: Optional["_models.AzureMonitorWorkspaceDefaultIngestionSettings"] = None
        self.private_endpoint_connections: Optional[list["_models.PrivateEndpointConnectionAutoGenerated"]] = None
        self.public_network_access = public_network_access


class AzureMonitorWorkspaceResourceForUpdate(_serialization.Model):
    """Definition of ARM tracked top level resource properties for the Update operation.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class AzureMonitorWorkspaceResourceListResult(_serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of resources. Required.
    :vartype value: list[~azure.mgmt.monitor.models.AzureMonitorWorkspaceResource]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureMonitorWorkspaceResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.AzureMonitorWorkspaceResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of resources. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.AzureMonitorWorkspaceResource]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureMonitorWorkspaceResourceProperties(AzureMonitorWorkspace):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_id: The immutable Id of the Azure Monitor Workspace. This property is read-only.
    :vartype account_id: str
    :ivar metrics: Properties related to the metrics container in the Azure Monitor Workspace.
    :vartype metrics: ~azure.mgmt.monitor.models.AzureMonitorWorkspaceMetrics
    :ivar provisioning_state: The provisioning state of the Azure Monitor Workspace. Set to
     Succeeded if everything is healthy. Known values are: "Creating", "Succeeded", "Deleting",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.monitor.models.ProvisioningState
    :ivar default_ingestion_settings: The Data Collection Rule and Endpoint used for ingestion by
     default.
    :vartype default_ingestion_settings:
     ~azure.mgmt.monitor.models.AzureMonitorWorkspaceDefaultIngestionSettings
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.monitor.models.PrivateEndpointConnectionAutoGenerated]
    :ivar public_network_access: Gets or sets allow or disallow public network access to Azure
     Monitor Workspace. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.monitor.models.PublicNetworkAccess
    """


class BaselineMetadata(_serialization.Model):
    """Represents a baseline metadata value.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the baseline metadata. Required.
    :vartype name: str
    :ivar value: Value of the baseline metadata. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the baseline metadata. Required.
        :paramtype name: str
        :keyword value: Value of the baseline metadata. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ColumnDefinition(_serialization.Model):
    """Definition of custom data column.

    :ivar name: The name of the column.
    :vartype name: str
    :ivar type: The type of the column data. Known values are: "string", "int", "long", "real",
     "boolean", "datetime", "dynamic", and "int".
    :vartype type: str or ~azure.mgmt.monitor.models.KnownColumnDefinitionType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.KnownColumnDefinitionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the column.
        :paramtype name: str
        :keyword type: The type of the column data. Known values are: "string", "int", "long", "real",
         "boolean", "datetime", "dynamic", and "int".
        :paramtype type: str or ~azure.mgmt.monitor.models.KnownColumnDefinitionType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Condition(_serialization.Model):
    """A condition of the scheduled query rule.

    :ivar query: Log query alert.
    :vartype query: str
    :ivar time_aggregation: Aggregation type. Relevant and required only for rules of the kind
     LogAlert. Known values are: "Count", "Average", "Minimum", "Maximum", and "Total".
    :vartype time_aggregation: str or ~azure.mgmt.monitor.models.TimeAggregation
    :ivar metric_measure_column: The column containing the metric measure number. Relevant only for
     rules of the kind LogAlert.
    :vartype metric_measure_column: str
    :ivar resource_id_column: The column containing the resource id. The content of the column must
     be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
    :vartype resource_id_column: str
    :ivar dimensions: List of Dimensions conditions.
    :vartype dimensions: list[~azure.mgmt.monitor.models.Dimension]
    :ivar operator: The criteria operator. Relevant and required only for rules of the kind
     LogAlert. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqual", "LessThan", and
     "LessThanOrEqual".
    :vartype operator: str or ~azure.mgmt.monitor.models.ConditionOperator
    :ivar threshold: the criteria threshold value that activates the alert. Relevant and required
     only for rules of the kind LogAlert.
    :vartype threshold: float
    :ivar failing_periods: The minimum number of violations required within the selected lookback
     time window required to raise an alert. Relevant only for rules of the kind LogAlert.
    :vartype failing_periods: ~azure.mgmt.monitor.models.ConditionFailingPeriods
    :ivar metric_name: The name of the metric to be sent. Relevant and required only for rules of
     the kind LogToMetric.
    :vartype metric_name: str
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "metric_measure_column": {"key": "metricMeasureColumn", "type": "str"},
        "resource_id_column": {"key": "resourceIdColumn", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
        "failing_periods": {"key": "failingPeriods", "type": "ConditionFailingPeriods"},
        "metric_name": {"key": "metricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        time_aggregation: Optional[Union[str, "_models.TimeAggregation"]] = None,
        metric_measure_column: Optional[str] = None,
        resource_id_column: Optional[str] = None,
        dimensions: Optional[list["_models.Dimension"]] = None,
        operator: Optional[Union[str, "_models.ConditionOperator"]] = None,
        threshold: Optional[float] = None,
        failing_periods: Optional["_models.ConditionFailingPeriods"] = None,
        metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query: Log query alert.
        :paramtype query: str
        :keyword time_aggregation: Aggregation type. Relevant and required only for rules of the kind
         LogAlert. Known values are: "Count", "Average", "Minimum", "Maximum", and "Total".
        :paramtype time_aggregation: str or ~azure.mgmt.monitor.models.TimeAggregation
        :keyword metric_measure_column: The column containing the metric measure number. Relevant only
         for rules of the kind LogAlert.
        :paramtype metric_measure_column: str
        :keyword resource_id_column: The column containing the resource id. The content of the column
         must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
        :paramtype resource_id_column: str
        :keyword dimensions: List of Dimensions conditions.
        :paramtype dimensions: list[~azure.mgmt.monitor.models.Dimension]
        :keyword operator: The criteria operator. Relevant and required only for rules of the kind
         LogAlert. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqual", "LessThan", and
         "LessThanOrEqual".
        :paramtype operator: str or ~azure.mgmt.monitor.models.ConditionOperator
        :keyword threshold: the criteria threshold value that activates the alert. Relevant and
         required only for rules of the kind LogAlert.
        :paramtype threshold: float
        :keyword failing_periods: The minimum number of violations required within the selected
         lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
        :paramtype failing_periods: ~azure.mgmt.monitor.models.ConditionFailingPeriods
        :keyword metric_name: The name of the metric to be sent. Relevant and required only for rules
         of the kind LogToMetric.
        :paramtype metric_name: str
        """
        super().__init__(**kwargs)
        self.query = query
        self.time_aggregation = time_aggregation
        self.metric_measure_column = metric_measure_column
        self.resource_id_column = resource_id_column
        self.dimensions = dimensions
        self.operator = operator
        self.threshold = threshold
        self.failing_periods = failing_periods
        self.metric_name = metric_name


class ConditionFailingPeriods(_serialization.Model):
    """The minimum number of violations required within the selected lookback time window required to
    raise an alert. Relevant only for rules of the kind LogAlert.

    :ivar number_of_evaluation_periods: The number of aggregated lookback points. The lookback time
     window is calculated based on the aggregation granularity (windowSize) and the selected number
     of aggregated points. Default value is 1.
    :vartype number_of_evaluation_periods: int
    :ivar min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
     smaller or equal to numberOfEvaluationPeriods. Default value is 1.
    :vartype min_failing_periods_to_alert: int
    """

    _attribute_map = {
        "number_of_evaluation_periods": {"key": "numberOfEvaluationPeriods", "type": "int"},
        "min_failing_periods_to_alert": {"key": "minFailingPeriodsToAlert", "type": "int"},
    }

    def __init__(
        self, *, number_of_evaluation_periods: int = 1, min_failing_periods_to_alert: int = 1, **kwargs: Any
    ) -> None:
        """
        :keyword number_of_evaluation_periods: The number of aggregated lookback points. The lookback
         time window is calculated based on the aggregation granularity (windowSize) and the selected
         number of aggregated points. Default value is 1.
        :paramtype number_of_evaluation_periods: int
        :keyword min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
         smaller or equal to numberOfEvaluationPeriods. Default value is 1.
        :paramtype min_failing_periods_to_alert: int
        """
        super().__init__(**kwargs)
        self.number_of_evaluation_periods = number_of_evaluation_periods
        self.min_failing_periods_to_alert = min_failing_periods_to_alert


class ConfigurationAccessEndpointSpec(_serialization.Model):
    """Definition of the endpoint used for accessing configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """

    _validation = {
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.endpoint: Optional[str] = None


class Context(_serialization.Model):
    """The context info.

    :ivar notification_source: The source of the notification request.
    :vartype notification_source: str
    :ivar context_type: The context id type.
    :vartype context_type: str
    """

    _attribute_map = {
        "notification_source": {"key": "notificationSource", "type": "str"},
        "context_type": {"key": "contextType", "type": "str"},
    }

    def __init__(
        self, *, notification_source: Optional[str] = None, context_type: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword notification_source: The source of the notification request.
        :paramtype notification_source: str
        :keyword context_type: The context id type.
        :paramtype context_type: str
        """
        super().__init__(**kwargs)
        self.notification_source = notification_source
        self.context_type = context_type


class DataCollectionEndpoint(_serialization.Model):
    """Definition of data collection endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the data collection endpoint.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection endpoint resource. This property
     is READ-ONLY.
    :vartype immutable_id: str
    :ivar configuration_access: The endpoint used by clients to access their configuration.
    :vartype configuration_access:
     ~azure.mgmt.monitor.models.DataCollectionEndpointConfigurationAccess
    :ivar logs_ingestion: The endpoint used by clients to ingest logs.
    :vartype logs_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointLogsIngestion
    :ivar metrics_ingestion: The endpoint used by clients to ingest metrics.
    :vartype metrics_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointMetricsIngestion
    :ivar network_acls: Network access control rules for the endpoints.
    :vartype network_acls: ~azure.mgmt.monitor.models.DataCollectionEndpointNetworkAcls
    :ivar provisioning_state: The resource provisioning state. This property is READ-ONLY. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionEndpointProvisioningState
    :ivar private_link_scoped_resources: List of Azure Monitor Private Link Scope Resources to
     which this data collection endpoint resource is associated. This property is READ-ONLY.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.monitor.models.PrivateLinkScopedResource]
    :ivar failover_configuration: Failover configuration on this endpoint. This property is
     READ-ONLY.
    :vartype failover_configuration:
     ~azure.mgmt.monitor.models.DataCollectionEndpointFailoverConfiguration
    :ivar metadata: Metadata for the resource. This property is READ-ONLY.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionEndpointMetadata
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "private_link_scoped_resources": {"readonly": True},
        "failover_configuration": {"readonly": True},
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "immutable_id": {"key": "immutableId", "type": "str"},
        "configuration_access": {"key": "configurationAccess", "type": "DataCollectionEndpointConfigurationAccess"},
        "logs_ingestion": {"key": "logsIngestion", "type": "DataCollectionEndpointLogsIngestion"},
        "metrics_ingestion": {"key": "metricsIngestion", "type": "DataCollectionEndpointMetricsIngestion"},
        "network_acls": {"key": "networkAcls", "type": "DataCollectionEndpointNetworkAcls"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_link_scoped_resources": {"key": "privateLinkScopedResources", "type": "[PrivateLinkScopedResource]"},
        "failover_configuration": {
            "key": "failoverConfiguration",
            "type": "DataCollectionEndpointFailoverConfiguration",
        },
        "metadata": {"key": "metadata", "type": "DataCollectionEndpointMetadata"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        immutable_id: Optional[str] = None,
        configuration_access: Optional["_models.DataCollectionEndpointConfigurationAccess"] = None,
        logs_ingestion: Optional["_models.DataCollectionEndpointLogsIngestion"] = None,
        metrics_ingestion: Optional["_models.DataCollectionEndpointMetricsIngestion"] = None,
        network_acls: Optional["_models.DataCollectionEndpointNetworkAcls"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the data collection endpoint.
        :paramtype description: str
        :keyword immutable_id: The immutable ID of this data collection endpoint resource. This
         property is READ-ONLY.
        :paramtype immutable_id: str
        :keyword configuration_access: The endpoint used by clients to access their configuration.
        :paramtype configuration_access:
         ~azure.mgmt.monitor.models.DataCollectionEndpointConfigurationAccess
        :keyword logs_ingestion: The endpoint used by clients to ingest logs.
        :paramtype logs_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointLogsIngestion
        :keyword metrics_ingestion: The endpoint used by clients to ingest metrics.
        :paramtype metrics_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointMetricsIngestion
        :keyword network_acls: Network access control rules for the endpoints.
        :paramtype network_acls: ~azure.mgmt.monitor.models.DataCollectionEndpointNetworkAcls
        """
        super().__init__(**kwargs)
        self.description = description
        self.immutable_id = immutable_id
        self.configuration_access = configuration_access
        self.logs_ingestion = logs_ingestion
        self.metrics_ingestion = metrics_ingestion
        self.network_acls = network_acls
        self.provisioning_state: Optional[Union[str, "_models.KnownDataCollectionEndpointProvisioningState"]] = None
        self.private_link_scoped_resources: Optional[list["_models.PrivateLinkScopedResource"]] = None
        self.failover_configuration: Optional["_models.DataCollectionEndpointFailoverConfiguration"] = None
        self.metadata: Optional["_models.DataCollectionEndpointMetadata"] = None


class DataCollectionEndpointConfigurationAccess(ConfigurationAccessEndpointSpec):  # pylint: disable=name-too-long
    """The endpoint used by clients to access their configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """


class FailoverConfigurationSpec(_serialization.Model):
    """FailoverConfigurationSpec.

    :ivar active_location: Active location where data flow will occur.
    :vartype active_location: str
    :ivar locations: Locations that are configured for failover.
    :vartype locations: list[~azure.mgmt.monitor.models.LocationSpec]
    """

    _attribute_map = {
        "active_location": {"key": "activeLocation", "type": "str"},
        "locations": {"key": "locations", "type": "[LocationSpec]"},
    }

    def __init__(
        self,
        *,
        active_location: Optional[str] = None,
        locations: Optional[list["_models.LocationSpec"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword active_location: Active location where data flow will occur.
        :paramtype active_location: str
        :keyword locations: Locations that are configured for failover.
        :paramtype locations: list[~azure.mgmt.monitor.models.LocationSpec]
        """
        super().__init__(**kwargs)
        self.active_location = active_location
        self.locations = locations


class DataCollectionEndpointFailoverConfiguration(FailoverConfigurationSpec):  # pylint: disable=name-too-long
    """Failover configuration on this endpoint. This property is READ-ONLY.

    :ivar active_location: Active location where data flow will occur.
    :vartype active_location: str
    :ivar locations: Locations that are configured for failover.
    :vartype locations: list[~azure.mgmt.monitor.models.LocationSpec]
    """


class LogsIngestionEndpointSpec(_serialization.Model):
    """Definition of the endpoint used for ingesting logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """

    _validation = {
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.endpoint: Optional[str] = None


class DataCollectionEndpointLogsIngestion(LogsIngestionEndpointSpec):
    """The endpoint used by clients to ingest logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """


class Metadata(_serialization.Model):
    """Metadata about the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioned_by: Azure offering managing this resource on-behalf-of customer.
    :vartype provisioned_by: str
    :ivar provisioned_by_resource_id: Resource Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_resource_id: str
    :ivar provisioned_by_immutable_id: Immutable Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_immutable_id: str
    """

    _validation = {
        "provisioned_by": {"readonly": True},
        "provisioned_by_resource_id": {"readonly": True},
        "provisioned_by_immutable_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioned_by": {"key": "provisionedBy", "type": "str"},
        "provisioned_by_resource_id": {"key": "provisionedByResourceId", "type": "str"},
        "provisioned_by_immutable_id": {"key": "provisionedByImmutableId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioned_by: Optional[str] = None
        self.provisioned_by_resource_id: Optional[str] = None
        self.provisioned_by_immutable_id: Optional[str] = None


class DataCollectionEndpointMetadata(Metadata):
    """Metadata for the resource. This property is READ-ONLY.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioned_by: Azure offering managing this resource on-behalf-of customer.
    :vartype provisioned_by: str
    :ivar provisioned_by_resource_id: Resource Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_resource_id: str
    :ivar provisioned_by_immutable_id: Immutable Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_immutable_id: str
    """


class MetricsIngestionEndpointSpec(_serialization.Model):
    """Definition of the endpoint used for ingesting metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """

    _validation = {
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.endpoint: Optional[str] = None


class DataCollectionEndpointMetricsIngestion(MetricsIngestionEndpointSpec):
    """The endpoint used by clients to ingest metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """


class NetworkRuleSet(_serialization.Model):
    """Definition of the network rules.

    :ivar public_network_access: The configuration to set whether network access from public
     internet to the endpoints are allowed. Known values are: "Enabled", "Disabled", and
     "SecuredByPerimeter".
    :vartype public_network_access: str or
     ~azure.mgmt.monitor.models.KnownPublicNetworkAccessOptions
    """

    _attribute_map = {
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "_models.KnownPublicNetworkAccessOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_network_access: The configuration to set whether network access from public
         internet to the endpoints are allowed. Known values are: "Enabled", "Disabled", and
         "SecuredByPerimeter".
        :paramtype public_network_access: str or
         ~azure.mgmt.monitor.models.KnownPublicNetworkAccessOptions
        """
        super().__init__(**kwargs)
        self.public_network_access = public_network_access


class DataCollectionEndpointNetworkAcls(NetworkRuleSet):
    """Network access control rules for the endpoints.

    :ivar public_network_access: The configuration to set whether network access from public
     internet to the endpoints are allowed. Known values are: "Enabled", "Disabled", and
     "SecuredByPerimeter".
    :vartype public_network_access: str or
     ~azure.mgmt.monitor.models.KnownPublicNetworkAccessOptions
    """


class DataCollectionEndpointResource(_serialization.Model):
    """Definition of ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of the resource. Known values are: "Linux" and "Windows".
    :vartype kind: str or ~azure.mgmt.monitor.models.KnownDataCollectionEndpointResourceKind
    :ivar identity: Managed service identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.models.DataCollectionEndpointResourceIdentity
    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.monitor.models.DataCollectionEndpointResourceSystemData
    :ivar description: Description of the data collection endpoint.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection endpoint resource. This property
     is READ-ONLY.
    :vartype immutable_id: str
    :ivar configuration_access: The endpoint used by clients to access their configuration.
    :vartype configuration_access:
     ~azure.mgmt.monitor.models.DataCollectionEndpointConfigurationAccess
    :ivar logs_ingestion: The endpoint used by clients to ingest logs.
    :vartype logs_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointLogsIngestion
    :ivar metrics_ingestion: The endpoint used by clients to ingest metrics.
    :vartype metrics_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointMetricsIngestion
    :ivar network_acls: Network access control rules for the endpoints.
    :vartype network_acls: ~azure.mgmt.monitor.models.DataCollectionEndpointNetworkAcls
    :ivar provisioning_state: The resource provisioning state. This property is READ-ONLY. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionEndpointProvisioningState
    :ivar private_link_scoped_resources: List of Azure Monitor Private Link Scope Resources to
     which this data collection endpoint resource is associated. This property is READ-ONLY.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.monitor.models.PrivateLinkScopedResource]
    :ivar failover_configuration: Failover configuration on this endpoint. This property is
     READ-ONLY.
    :vartype failover_configuration:
     ~azure.mgmt.monitor.models.DataCollectionEndpointFailoverConfiguration
    :ivar metadata: Metadata for the resource. This property is READ-ONLY.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionEndpointMetadata
    """

    _validation = {
        "location": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_link_scoped_resources": {"readonly": True},
        "failover_configuration": {"readonly": True},
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "DataCollectionEndpointResourceIdentity"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "DataCollectionEndpointResourceSystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "immutable_id": {"key": "properties.immutableId", "type": "str"},
        "configuration_access": {
            "key": "properties.configurationAccess",
            "type": "DataCollectionEndpointConfigurationAccess",
        },
        "logs_ingestion": {"key": "properties.logsIngestion", "type": "DataCollectionEndpointLogsIngestion"},
        "metrics_ingestion": {"key": "properties.metricsIngestion", "type": "DataCollectionEndpointMetricsIngestion"},
        "network_acls": {"key": "properties.networkAcls", "type": "DataCollectionEndpointNetworkAcls"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_link_scoped_resources": {
            "key": "properties.privateLinkScopedResources",
            "type": "[PrivateLinkScopedResource]",
        },
        "failover_configuration": {
            "key": "properties.failoverConfiguration",
            "type": "DataCollectionEndpointFailoverConfiguration",
        },
        "metadata": {"key": "properties.metadata", "type": "DataCollectionEndpointMetadata"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        kind: Optional[Union[str, "_models.KnownDataCollectionEndpointResourceKind"]] = None,
        identity: Optional["_models.DataCollectionEndpointResourceIdentity"] = None,
        description: Optional[str] = None,
        immutable_id: Optional[str] = None,
        configuration_access: Optional["_models.DataCollectionEndpointConfigurationAccess"] = None,
        logs_ingestion: Optional["_models.DataCollectionEndpointLogsIngestion"] = None,
        metrics_ingestion: Optional["_models.DataCollectionEndpointMetricsIngestion"] = None,
        network_acls: Optional["_models.DataCollectionEndpointNetworkAcls"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of the resource. Known values are: "Linux" and "Windows".
        :paramtype kind: str or ~azure.mgmt.monitor.models.KnownDataCollectionEndpointResourceKind
        :keyword identity: Managed service identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.models.DataCollectionEndpointResourceIdentity
        :keyword description: Description of the data collection endpoint.
        :paramtype description: str
        :keyword immutable_id: The immutable ID of this data collection endpoint resource. This
         property is READ-ONLY.
        :paramtype immutable_id: str
        :keyword configuration_access: The endpoint used by clients to access their configuration.
        :paramtype configuration_access:
         ~azure.mgmt.monitor.models.DataCollectionEndpointConfigurationAccess
        :keyword logs_ingestion: The endpoint used by clients to ingest logs.
        :paramtype logs_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointLogsIngestion
        :keyword metrics_ingestion: The endpoint used by clients to ingest metrics.
        :paramtype metrics_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointMetricsIngestion
        :keyword network_acls: Network access control rules for the endpoints.
        :paramtype network_acls: ~azure.mgmt.monitor.models.DataCollectionEndpointNetworkAcls
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.kind = kind
        self.identity = identity
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.system_data: Optional["_models.DataCollectionEndpointResourceSystemData"] = None
        self.description = description
        self.immutable_id = immutable_id
        self.configuration_access = configuration_access
        self.logs_ingestion = logs_ingestion
        self.metrics_ingestion = metrics_ingestion
        self.network_acls = network_acls
        self.provisioning_state: Optional[Union[str, "_models.KnownDataCollectionEndpointProvisioningState"]] = None
        self.private_link_scoped_resources: Optional[list["_models.PrivateLinkScopedResource"]] = None
        self.failover_configuration: Optional["_models.DataCollectionEndpointFailoverConfiguration"] = None
        self.metadata: Optional["_models.DataCollectionEndpointMetadata"] = None


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.monitor.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.monitor.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.monitor.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.monitor.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class DataCollectionEndpointResourceIdentity(ManagedServiceIdentity):
    """Managed service identity of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.monitor.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.monitor.models.UserAssignedIdentity]
    """


class DataCollectionEndpointResourceListResult(_serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of resources. Required.
    :vartype value: list[~azure.mgmt.monitor.models.DataCollectionEndpointResource]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataCollectionEndpointResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.DataCollectionEndpointResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of resources. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.DataCollectionEndpointResource]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionEndpointResourceProperties(DataCollectionEndpoint):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the data collection endpoint.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection endpoint resource. This property
     is READ-ONLY.
    :vartype immutable_id: str
    :ivar configuration_access: The endpoint used by clients to access their configuration.
    :vartype configuration_access:
     ~azure.mgmt.monitor.models.DataCollectionEndpointConfigurationAccess
    :ivar logs_ingestion: The endpoint used by clients to ingest logs.
    :vartype logs_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointLogsIngestion
    :ivar metrics_ingestion: The endpoint used by clients to ingest metrics.
    :vartype metrics_ingestion: ~azure.mgmt.monitor.models.DataCollectionEndpointMetricsIngestion
    :ivar network_acls: Network access control rules for the endpoints.
    :vartype network_acls: ~azure.mgmt.monitor.models.DataCollectionEndpointNetworkAcls
    :ivar provisioning_state: The resource provisioning state. This property is READ-ONLY. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionEndpointProvisioningState
    :ivar private_link_scoped_resources: List of Azure Monitor Private Link Scope Resources to
     which this data collection endpoint resource is associated. This property is READ-ONLY.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.monitor.models.PrivateLinkScopedResource]
    :ivar failover_configuration: Failover configuration on this endpoint. This property is
     READ-ONLY.
    :vartype failover_configuration:
     ~azure.mgmt.monitor.models.DataCollectionEndpointFailoverConfiguration
    :ivar metadata: Metadata for the resource. This property is READ-ONLY.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionEndpointMetadata
    """


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class DataCollectionEndpointResourceSystemData(SystemData):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """


class DataCollectionRule(_serialization.Model):
    """Definition of what monitoring data to collect and where that data should be sent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the data collection rule.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :ivar data_collection_endpoint_id: The resource ID of the data collection endpoint that this
     rule can be used with.
    :vartype data_collection_endpoint_id: str
    :ivar metadata: Metadata about the resource.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionRuleMetadata
    :ivar endpoints: Defines the ingestion endpoints to send data to via this rule.
    :vartype endpoints: ~azure.mgmt.monitor.models.DataCollectionRuleEndpoints
    :ivar references: Defines all the references that may be used in other sections of the DCR.
    :vartype references: ~azure.mgmt.monitor.models.DataCollectionRuleReferences
    :ivar agent_settings: Agent settings used to modify agent behavior on a given host.
    :vartype agent_settings: ~azure.mgmt.monitor.models.DataCollectionRuleAgentSettings
    :ivar stream_declarations: Declaration of custom streams used in this rule.
    :vartype stream_declarations: dict[str, ~azure.mgmt.monitor.models.StreamDeclaration]
    :ivar data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :vartype data_sources: ~azure.mgmt.monitor.models.DataCollectionRuleDataSources
    :ivar destinations: The specification of destinations.
    :vartype destinations: ~azure.mgmt.monitor.models.DataCollectionRuleDestinations
    :ivar data_flows: The specification of data flows.
    :vartype data_flows: list[~azure.mgmt.monitor.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        "immutable_id": {"readonly": True},
        "metadata": {"readonly": True},
        "endpoints": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "immutable_id": {"key": "immutableId", "type": "str"},
        "data_collection_endpoint_id": {"key": "dataCollectionEndpointId", "type": "str"},
        "metadata": {"key": "metadata", "type": "DataCollectionRuleMetadata"},
        "endpoints": {"key": "endpoints", "type": "DataCollectionRuleEndpoints"},
        "references": {"key": "references", "type": "DataCollectionRuleReferences"},
        "agent_settings": {"key": "agentSettings", "type": "DataCollectionRuleAgentSettings"},
        "stream_declarations": {"key": "streamDeclarations", "type": "{StreamDeclaration}"},
        "data_sources": {"key": "dataSources", "type": "DataCollectionRuleDataSources"},
        "destinations": {"key": "destinations", "type": "DataCollectionRuleDestinations"},
        "data_flows": {"key": "dataFlows", "type": "[DataFlow]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_collection_endpoint_id: Optional[str] = None,
        references: Optional["_models.DataCollectionRuleReferences"] = None,
        agent_settings: Optional["_models.DataCollectionRuleAgentSettings"] = None,
        stream_declarations: Optional[dict[str, "_models.StreamDeclaration"]] = None,
        data_sources: Optional["_models.DataCollectionRuleDataSources"] = None,
        destinations: Optional["_models.DataCollectionRuleDestinations"] = None,
        data_flows: Optional[list["_models.DataFlow"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the data collection rule.
        :paramtype description: str
        :keyword data_collection_endpoint_id: The resource ID of the data collection endpoint that this
         rule can be used with.
        :paramtype data_collection_endpoint_id: str
        :keyword references: Defines all the references that may be used in other sections of the DCR.
        :paramtype references: ~azure.mgmt.monitor.models.DataCollectionRuleReferences
        :keyword agent_settings: Agent settings used to modify agent behavior on a given host.
        :paramtype agent_settings: ~azure.mgmt.monitor.models.DataCollectionRuleAgentSettings
        :keyword stream_declarations: Declaration of custom streams used in this rule.
        :paramtype stream_declarations: dict[str, ~azure.mgmt.monitor.models.StreamDeclaration]
        :keyword data_sources: The specification of data sources.
         This property is optional and can be omitted if the rule is meant to be used via direct calls
         to the provisioned endpoint.
        :paramtype data_sources: ~azure.mgmt.monitor.models.DataCollectionRuleDataSources
        :keyword destinations: The specification of destinations.
        :paramtype destinations: ~azure.mgmt.monitor.models.DataCollectionRuleDestinations
        :keyword data_flows: The specification of data flows.
        :paramtype data_flows: list[~azure.mgmt.monitor.models.DataFlow]
        """
        super().__init__(**kwargs)
        self.description = description
        self.immutable_id: Optional[str] = None
        self.data_collection_endpoint_id = data_collection_endpoint_id
        self.metadata: Optional["_models.DataCollectionRuleMetadata"] = None
        self.endpoints: Optional["_models.DataCollectionRuleEndpoints"] = None
        self.references = references
        self.agent_settings = agent_settings
        self.stream_declarations = stream_declarations
        self.data_sources = data_sources
        self.destinations = destinations
        self.data_flows = data_flows
        self.provisioning_state: Optional[Union[str, "_models.KnownDataCollectionRuleProvisioningState"]] = None


class DataCollectionRuleAgentSettings(AgentSettingsSpec):
    """Agent settings used to modify agent behavior on a given host.

    :ivar logs: All the settings that are applicable to the logs agent (AMA).
    :vartype logs: list[~azure.mgmt.monitor.models.AgentSetting]
    """


class DataCollectionRuleAssociation(_serialization.Model):
    """Definition of association of a data collection rule with a monitored Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the association.
    :vartype description: str
    :ivar data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :vartype data_collection_rule_id: str
    :ivar data_collection_endpoint_id: The resource ID of the data collection endpoint that is to
     be associated.
    :vartype data_collection_endpoint_id: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionRuleAssociationProvisioningState
    :ivar metadata: Metadata about the resource.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionRuleAssociationMetadata
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "data_collection_rule_id": {"key": "dataCollectionRuleId", "type": "str"},
        "data_collection_endpoint_id": {"key": "dataCollectionEndpointId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "metadata": {"key": "metadata", "type": "DataCollectionRuleAssociationMetadata"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_collection_rule_id: Optional[str] = None,
        data_collection_endpoint_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the association.
        :paramtype description: str
        :keyword data_collection_rule_id: The resource ID of the data collection rule that is to be
         associated.
        :paramtype data_collection_rule_id: str
        :keyword data_collection_endpoint_id: The resource ID of the data collection endpoint that is
         to be associated.
        :paramtype data_collection_endpoint_id: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.data_collection_rule_id = data_collection_rule_id
        self.data_collection_endpoint_id = data_collection_endpoint_id
        self.provisioning_state: Optional[Union[str, "_models.KnownDataCollectionRuleAssociationProvisioningState"]] = (
            None
        )
        self.metadata: Optional["_models.DataCollectionRuleAssociationMetadata"] = None


class DataCollectionRuleAssociationMetadata(Metadata):
    """Metadata about the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioned_by: Azure offering managing this resource on-behalf-of customer.
    :vartype provisioned_by: str
    :ivar provisioned_by_resource_id: Resource Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_resource_id: str
    :ivar provisioned_by_immutable_id: Immutable Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_immutable_id: str
    """


class DataCollectionRuleAssociationProxyOnlyResource(_serialization.Model):  # pylint: disable=name-too-long
    """Definition of generic ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data:
     ~azure.mgmt.monitor.models.DataCollectionRuleAssociationProxyOnlyResourceSystemData
    :ivar description: Description of the association.
    :vartype description: str
    :ivar data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :vartype data_collection_rule_id: str
    :ivar data_collection_endpoint_id: The resource ID of the data collection endpoint that is to
     be associated.
    :vartype data_collection_endpoint_id: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionRuleAssociationProvisioningState
    :ivar metadata: Metadata about the resource.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionRuleAssociationMetadata
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "DataCollectionRuleAssociationProxyOnlyResourceSystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "data_collection_rule_id": {"key": "properties.dataCollectionRuleId", "type": "str"},
        "data_collection_endpoint_id": {"key": "properties.dataCollectionEndpointId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "DataCollectionRuleAssociationMetadata"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_collection_rule_id: Optional[str] = None,
        data_collection_endpoint_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the association.
        :paramtype description: str
        :keyword data_collection_rule_id: The resource ID of the data collection rule that is to be
         associated.
        :paramtype data_collection_rule_id: str
        :keyword data_collection_endpoint_id: The resource ID of the data collection endpoint that is
         to be associated.
        :paramtype data_collection_endpoint_id: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.system_data: Optional["_models.DataCollectionRuleAssociationProxyOnlyResourceSystemData"] = None
        self.description = description
        self.data_collection_rule_id = data_collection_rule_id
        self.data_collection_endpoint_id = data_collection_endpoint_id
        self.provisioning_state: Optional[Union[str, "_models.KnownDataCollectionRuleAssociationProvisioningState"]] = (
            None
        )
        self.metadata: Optional["_models.DataCollectionRuleAssociationMetadata"] = None


class DataCollectionRuleAssociationProxyOnlyResourceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A pageable list of resources.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of resources. Required.
    :vartype value: list[~azure.mgmt.monitor.models.DataCollectionRuleAssociationProxyOnlyResource]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataCollectionRuleAssociationProxyOnlyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: list["_models.DataCollectionRuleAssociationProxyOnlyResource"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of resources. Required.
        :paramtype value:
         list[~azure.mgmt.monitor.models.DataCollectionRuleAssociationProxyOnlyResource]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionRuleAssociationProxyOnlyResourceProperties(
    DataCollectionRuleAssociation
):  # pylint: disable=name-too-long
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the association.
    :vartype description: str
    :ivar data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :vartype data_collection_rule_id: str
    :ivar data_collection_endpoint_id: The resource ID of the data collection endpoint that is to
     be associated.
    :vartype data_collection_endpoint_id: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionRuleAssociationProvisioningState
    :ivar metadata: Metadata about the resource.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionRuleAssociationMetadata
    """


class DataCollectionRuleAssociationProxyOnlyResourceSystemData(SystemData):  # pylint: disable=name-too-long
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """


class DataSourcesSpec(_serialization.Model):
    """Specification of data sources that will be collected.

    :ivar performance_counters: The list of performance counter data source configurations.
    :vartype performance_counters: list[~azure.mgmt.monitor.models.PerfCounterDataSource]
    :ivar windows_event_logs: The list of Windows Event Log data source configurations.
    :vartype windows_event_logs: list[~azure.mgmt.monitor.models.WindowsEventLogDataSource]
    :ivar syslog: The list of Syslog data source configurations.
    :vartype syslog: list[~azure.mgmt.monitor.models.SyslogDataSource]
    :ivar extensions: The list of Azure VM extension data source configurations.
    :vartype extensions: list[~azure.mgmt.monitor.models.ExtensionDataSource]
    :ivar log_files: The list of Log files source configurations.
    :vartype log_files: list[~azure.mgmt.monitor.models.LogFilesDataSource]
    :ivar iis_logs: The list of IIS logs source configurations.
    :vartype iis_logs: list[~azure.mgmt.monitor.models.IisLogsDataSource]
    :ivar windows_firewall_logs: The list of Windows Firewall logs source configurations.
    :vartype windows_firewall_logs: list[~azure.mgmt.monitor.models.WindowsFirewallLogsDataSource]
    :ivar prometheus_forwarder: The list of Prometheus forwarder data source configurations.
    :vartype prometheus_forwarder: list[~azure.mgmt.monitor.models.PrometheusForwarderDataSource]
    :ivar platform_telemetry: The list of platform telemetry configurations.
    :vartype platform_telemetry: list[~azure.mgmt.monitor.models.PlatformTelemetryDataSource]
    :ivar data_imports: Specifications of pull based data sources.
    :vartype data_imports: ~azure.mgmt.monitor.models.DataSourcesSpecDataImports
    """

    _attribute_map = {
        "performance_counters": {"key": "performanceCounters", "type": "[PerfCounterDataSource]"},
        "windows_event_logs": {"key": "windowsEventLogs", "type": "[WindowsEventLogDataSource]"},
        "syslog": {"key": "syslog", "type": "[SyslogDataSource]"},
        "extensions": {"key": "extensions", "type": "[ExtensionDataSource]"},
        "log_files": {"key": "logFiles", "type": "[LogFilesDataSource]"},
        "iis_logs": {"key": "iisLogs", "type": "[IisLogsDataSource]"},
        "windows_firewall_logs": {"key": "windowsFirewallLogs", "type": "[WindowsFirewallLogsDataSource]"},
        "prometheus_forwarder": {"key": "prometheusForwarder", "type": "[PrometheusForwarderDataSource]"},
        "platform_telemetry": {"key": "platformTelemetry", "type": "[PlatformTelemetryDataSource]"},
        "data_imports": {"key": "dataImports", "type": "DataSourcesSpecDataImports"},
    }

    def __init__(
        self,
        *,
        performance_counters: Optional[list["_models.PerfCounterDataSource"]] = None,
        windows_event_logs: Optional[list["_models.WindowsEventLogDataSource"]] = None,
        syslog: Optional[list["_models.SyslogDataSource"]] = None,
        extensions: Optional[list["_models.ExtensionDataSource"]] = None,
        log_files: Optional[list["_models.LogFilesDataSource"]] = None,
        iis_logs: Optional[list["_models.IisLogsDataSource"]] = None,
        windows_firewall_logs: Optional[list["_models.WindowsFirewallLogsDataSource"]] = None,
        prometheus_forwarder: Optional[list["_models.PrometheusForwarderDataSource"]] = None,
        platform_telemetry: Optional[list["_models.PlatformTelemetryDataSource"]] = None,
        data_imports: Optional["_models.DataSourcesSpecDataImports"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword performance_counters: The list of performance counter data source configurations.
        :paramtype performance_counters: list[~azure.mgmt.monitor.models.PerfCounterDataSource]
        :keyword windows_event_logs: The list of Windows Event Log data source configurations.
        :paramtype windows_event_logs: list[~azure.mgmt.monitor.models.WindowsEventLogDataSource]
        :keyword syslog: The list of Syslog data source configurations.
        :paramtype syslog: list[~azure.mgmt.monitor.models.SyslogDataSource]
        :keyword extensions: The list of Azure VM extension data source configurations.
        :paramtype extensions: list[~azure.mgmt.monitor.models.ExtensionDataSource]
        :keyword log_files: The list of Log files source configurations.
        :paramtype log_files: list[~azure.mgmt.monitor.models.LogFilesDataSource]
        :keyword iis_logs: The list of IIS logs source configurations.
        :paramtype iis_logs: list[~azure.mgmt.monitor.models.IisLogsDataSource]
        :keyword windows_firewall_logs: The list of Windows Firewall logs source configurations.
        :paramtype windows_firewall_logs:
         list[~azure.mgmt.monitor.models.WindowsFirewallLogsDataSource]
        :keyword prometheus_forwarder: The list of Prometheus forwarder data source configurations.
        :paramtype prometheus_forwarder: list[~azure.mgmt.monitor.models.PrometheusForwarderDataSource]
        :keyword platform_telemetry: The list of platform telemetry configurations.
        :paramtype platform_telemetry: list[~azure.mgmt.monitor.models.PlatformTelemetryDataSource]
        :keyword data_imports: Specifications of pull based data sources.
        :paramtype data_imports: ~azure.mgmt.monitor.models.DataSourcesSpecDataImports
        """
        super().__init__(**kwargs)
        self.performance_counters = performance_counters
        self.windows_event_logs = windows_event_logs
        self.syslog = syslog
        self.extensions = extensions
        self.log_files = log_files
        self.iis_logs = iis_logs
        self.windows_firewall_logs = windows_firewall_logs
        self.prometheus_forwarder = prometheus_forwarder
        self.platform_telemetry = platform_telemetry
        self.data_imports = data_imports


class DataCollectionRuleDataSources(DataSourcesSpec):
    """The specification of data sources.
    This property is optional and can be omitted if the rule is meant to be used via direct calls
    to the provisioned endpoint.

    :ivar performance_counters: The list of performance counter data source configurations.
    :vartype performance_counters: list[~azure.mgmt.monitor.models.PerfCounterDataSource]
    :ivar windows_event_logs: The list of Windows Event Log data source configurations.
    :vartype windows_event_logs: list[~azure.mgmt.monitor.models.WindowsEventLogDataSource]
    :ivar syslog: The list of Syslog data source configurations.
    :vartype syslog: list[~azure.mgmt.monitor.models.SyslogDataSource]
    :ivar extensions: The list of Azure VM extension data source configurations.
    :vartype extensions: list[~azure.mgmt.monitor.models.ExtensionDataSource]
    :ivar log_files: The list of Log files source configurations.
    :vartype log_files: list[~azure.mgmt.monitor.models.LogFilesDataSource]
    :ivar iis_logs: The list of IIS logs source configurations.
    :vartype iis_logs: list[~azure.mgmt.monitor.models.IisLogsDataSource]
    :ivar windows_firewall_logs: The list of Windows Firewall logs source configurations.
    :vartype windows_firewall_logs: list[~azure.mgmt.monitor.models.WindowsFirewallLogsDataSource]
    :ivar prometheus_forwarder: The list of Prometheus forwarder data source configurations.
    :vartype prometheus_forwarder: list[~azure.mgmt.monitor.models.PrometheusForwarderDataSource]
    :ivar platform_telemetry: The list of platform telemetry configurations.
    :vartype platform_telemetry: list[~azure.mgmt.monitor.models.PlatformTelemetryDataSource]
    :ivar data_imports: Specifications of pull based data sources.
    :vartype data_imports: ~azure.mgmt.monitor.models.DataSourcesSpecDataImports
    """


class DestinationsSpec(_serialization.Model):
    """Specification of destinations that can be used in data flows.

    :ivar log_analytics: List of Log Analytics destinations.
    :vartype log_analytics: list[~azure.mgmt.monitor.models.LogAnalyticsDestination]
    :ivar monitoring_accounts: List of monitoring account destinations.
    :vartype monitoring_accounts: list[~azure.mgmt.monitor.models.MonitoringAccountDestination]
    :ivar azure_monitor_metrics: Azure Monitor Metrics destination.
    :vartype azure_monitor_metrics: ~azure.mgmt.monitor.models.DestinationsSpecAzureMonitorMetrics
    :ivar event_hubs: List of Event Hubs destinations.
    :vartype event_hubs: list[~azure.mgmt.monitor.models.EventHubDestination]
    :ivar event_hubs_direct: List of Event Hubs Direct destinations.
    :vartype event_hubs_direct: list[~azure.mgmt.monitor.models.EventHubDirectDestination]
    :ivar storage_blobs_direct: List of Storage Blob Direct destinations. To be used only for
     sending data directly to store from the agent.
    :vartype storage_blobs_direct: list[~azure.mgmt.monitor.models.StorageBlobDestination]
    :ivar storage_tables_direct: List of Storage Table Direct destinations.
    :vartype storage_tables_direct: list[~azure.mgmt.monitor.models.StorageTableDestination]
    :ivar storage_accounts: List of storage accounts destinations.
    :vartype storage_accounts: list[~azure.mgmt.monitor.models.StorageBlobDestination]
    :ivar microsoft_fabric: List of Microsoft Fabric destinations.
    :vartype microsoft_fabric: list[~azure.mgmt.monitor.models.MicrosoftFabricDestination]
    :ivar azure_data_explorer: List of Azure Data Explorer destinations.
    :vartype azure_data_explorer: list[~azure.mgmt.monitor.models.AdxDestination]
    """

    _attribute_map = {
        "log_analytics": {"key": "logAnalytics", "type": "[LogAnalyticsDestination]"},
        "monitoring_accounts": {"key": "monitoringAccounts", "type": "[MonitoringAccountDestination]"},
        "azure_monitor_metrics": {"key": "azureMonitorMetrics", "type": "DestinationsSpecAzureMonitorMetrics"},
        "event_hubs": {"key": "eventHubs", "type": "[EventHubDestination]"},
        "event_hubs_direct": {"key": "eventHubsDirect", "type": "[EventHubDirectDestination]"},
        "storage_blobs_direct": {"key": "storageBlobsDirect", "type": "[StorageBlobDestination]"},
        "storage_tables_direct": {"key": "storageTablesDirect", "type": "[StorageTableDestination]"},
        "storage_accounts": {"key": "storageAccounts", "type": "[StorageBlobDestination]"},
        "microsoft_fabric": {"key": "microsoftFabric", "type": "[MicrosoftFabricDestination]"},
        "azure_data_explorer": {"key": "azureDataExplorer", "type": "[AdxDestination]"},
    }

    def __init__(
        self,
        *,
        log_analytics: Optional[list["_models.LogAnalyticsDestination"]] = None,
        monitoring_accounts: Optional[list["_models.MonitoringAccountDestination"]] = None,
        azure_monitor_metrics: Optional["_models.DestinationsSpecAzureMonitorMetrics"] = None,
        event_hubs: Optional[list["_models.EventHubDestination"]] = None,
        event_hubs_direct: Optional[list["_models.EventHubDirectDestination"]] = None,
        storage_blobs_direct: Optional[list["_models.StorageBlobDestination"]] = None,
        storage_tables_direct: Optional[list["_models.StorageTableDestination"]] = None,
        storage_accounts: Optional[list["_models.StorageBlobDestination"]] = None,
        microsoft_fabric: Optional[list["_models.MicrosoftFabricDestination"]] = None,
        azure_data_explorer: Optional[list["_models.AdxDestination"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_analytics: List of Log Analytics destinations.
        :paramtype log_analytics: list[~azure.mgmt.monitor.models.LogAnalyticsDestination]
        :keyword monitoring_accounts: List of monitoring account destinations.
        :paramtype monitoring_accounts: list[~azure.mgmt.monitor.models.MonitoringAccountDestination]
        :keyword azure_monitor_metrics: Azure Monitor Metrics destination.
        :paramtype azure_monitor_metrics:
         ~azure.mgmt.monitor.models.DestinationsSpecAzureMonitorMetrics
        :keyword event_hubs: List of Event Hubs destinations.
        :paramtype event_hubs: list[~azure.mgmt.monitor.models.EventHubDestination]
        :keyword event_hubs_direct: List of Event Hubs Direct destinations.
        :paramtype event_hubs_direct: list[~azure.mgmt.monitor.models.EventHubDirectDestination]
        :keyword storage_blobs_direct: List of Storage Blob Direct destinations. To be used only for
         sending data directly to store from the agent.
        :paramtype storage_blobs_direct: list[~azure.mgmt.monitor.models.StorageBlobDestination]
        :keyword storage_tables_direct: List of Storage Table Direct destinations.
        :paramtype storage_tables_direct: list[~azure.mgmt.monitor.models.StorageTableDestination]
        :keyword storage_accounts: List of storage accounts destinations.
        :paramtype storage_accounts: list[~azure.mgmt.monitor.models.StorageBlobDestination]
        :keyword microsoft_fabric: List of Microsoft Fabric destinations.
        :paramtype microsoft_fabric: list[~azure.mgmt.monitor.models.MicrosoftFabricDestination]
        :keyword azure_data_explorer: List of Azure Data Explorer destinations.
        :paramtype azure_data_explorer: list[~azure.mgmt.monitor.models.AdxDestination]
        """
        super().__init__(**kwargs)
        self.log_analytics = log_analytics
        self.monitoring_accounts = monitoring_accounts
        self.azure_monitor_metrics = azure_monitor_metrics
        self.event_hubs = event_hubs
        self.event_hubs_direct = event_hubs_direct
        self.storage_blobs_direct = storage_blobs_direct
        self.storage_tables_direct = storage_tables_direct
        self.storage_accounts = storage_accounts
        self.microsoft_fabric = microsoft_fabric
        self.azure_data_explorer = azure_data_explorer


class DataCollectionRuleDestinations(DestinationsSpec):
    """The specification of destinations.

    :ivar log_analytics: List of Log Analytics destinations.
    :vartype log_analytics: list[~azure.mgmt.monitor.models.LogAnalyticsDestination]
    :ivar monitoring_accounts: List of monitoring account destinations.
    :vartype monitoring_accounts: list[~azure.mgmt.monitor.models.MonitoringAccountDestination]
    :ivar azure_monitor_metrics: Azure Monitor Metrics destination.
    :vartype azure_monitor_metrics: ~azure.mgmt.monitor.models.DestinationsSpecAzureMonitorMetrics
    :ivar event_hubs: List of Event Hubs destinations.
    :vartype event_hubs: list[~azure.mgmt.monitor.models.EventHubDestination]
    :ivar event_hubs_direct: List of Event Hubs Direct destinations.
    :vartype event_hubs_direct: list[~azure.mgmt.monitor.models.EventHubDirectDestination]
    :ivar storage_blobs_direct: List of Storage Blob Direct destinations. To be used only for
     sending data directly to store from the agent.
    :vartype storage_blobs_direct: list[~azure.mgmt.monitor.models.StorageBlobDestination]
    :ivar storage_tables_direct: List of Storage Table Direct destinations.
    :vartype storage_tables_direct: list[~azure.mgmt.monitor.models.StorageTableDestination]
    :ivar storage_accounts: List of storage accounts destinations.
    :vartype storage_accounts: list[~azure.mgmt.monitor.models.StorageBlobDestination]
    :ivar microsoft_fabric: List of Microsoft Fabric destinations.
    :vartype microsoft_fabric: list[~azure.mgmt.monitor.models.MicrosoftFabricDestination]
    :ivar azure_data_explorer: List of Azure Data Explorer destinations.
    :vartype azure_data_explorer: list[~azure.mgmt.monitor.models.AdxDestination]
    """


class EndpointsSpec(_serialization.Model):
    """This defines all the ingestion endpoints that can be used by this rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar logs_ingestion: The ingestion endpoint for logs.
    :vartype logs_ingestion: str
    :ivar metrics_ingestion: The ingestion endpoint for metrics.
    :vartype metrics_ingestion: str
    """

    _validation = {
        "logs_ingestion": {"readonly": True},
        "metrics_ingestion": {"readonly": True},
    }

    _attribute_map = {
        "logs_ingestion": {"key": "logsIngestion", "type": "str"},
        "metrics_ingestion": {"key": "metricsIngestion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.logs_ingestion: Optional[str] = None
        self.metrics_ingestion: Optional[str] = None


class DataCollectionRuleEndpoints(EndpointsSpec):
    """Defines the ingestion endpoints to send data to via this rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar logs_ingestion: The ingestion endpoint for logs.
    :vartype logs_ingestion: str
    :ivar metrics_ingestion: The ingestion endpoint for metrics.
    :vartype metrics_ingestion: str
    """


class DataCollectionRuleMetadata(Metadata):
    """Metadata about the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioned_by: Azure offering managing this resource on-behalf-of customer.
    :vartype provisioned_by: str
    :ivar provisioned_by_resource_id: Resource Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_resource_id: str
    :ivar provisioned_by_immutable_id: Immutable Id of azure offering managing this resource
     on-behalf-of customer.
    :vartype provisioned_by_immutable_id: str
    """


class ReferencesSpec(_serialization.Model):
    """This section defines all the references that may be used in other sections of the DCR.

    :ivar enrichment_data: All the enrichment data sources referenced in data flows.
    :vartype enrichment_data: ~azure.mgmt.monitor.models.ReferencesSpecEnrichmentData
    """

    _attribute_map = {
        "enrichment_data": {"key": "enrichmentData", "type": "ReferencesSpecEnrichmentData"},
    }

    def __init__(
        self, *, enrichment_data: Optional["_models.ReferencesSpecEnrichmentData"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword enrichment_data: All the enrichment data sources referenced in data flows.
        :paramtype enrichment_data: ~azure.mgmt.monitor.models.ReferencesSpecEnrichmentData
        """
        super().__init__(**kwargs)
        self.enrichment_data = enrichment_data


class DataCollectionRuleReferences(ReferencesSpec):
    """Defines all the references that may be used in other sections of the DCR.

    :ivar enrichment_data: All the enrichment data sources referenced in data flows.
    :vartype enrichment_data: ~azure.mgmt.monitor.models.ReferencesSpecEnrichmentData
    """


class DataCollectionRuleResource(_serialization.Model):
    """Definition of ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of the resource. Known values are: "Linux" and "Windows".
    :vartype kind: str or ~azure.mgmt.monitor.models.KnownDataCollectionRuleResourceKind
    :ivar identity: Managed service identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.models.DataCollectionRuleResourceIdentity
    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.monitor.models.DataCollectionRuleResourceSystemData
    :ivar description: Description of the data collection rule.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :ivar data_collection_endpoint_id: The resource ID of the data collection endpoint that this
     rule can be used with.
    :vartype data_collection_endpoint_id: str
    :ivar metadata: Metadata about the resource.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionRuleMetadata
    :ivar endpoints: Defines the ingestion endpoints to send data to via this rule.
    :vartype endpoints: ~azure.mgmt.monitor.models.DataCollectionRuleEndpoints
    :ivar references: Defines all the references that may be used in other sections of the DCR.
    :vartype references: ~azure.mgmt.monitor.models.DataCollectionRuleReferences
    :ivar agent_settings: Agent settings used to modify agent behavior on a given host.
    :vartype agent_settings: ~azure.mgmt.monitor.models.DataCollectionRuleAgentSettings
    :ivar stream_declarations: Declaration of custom streams used in this rule.
    :vartype stream_declarations: dict[str, ~azure.mgmt.monitor.models.StreamDeclaration]
    :ivar data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :vartype data_sources: ~azure.mgmt.monitor.models.DataCollectionRuleDataSources
    :ivar destinations: The specification of destinations.
    :vartype destinations: ~azure.mgmt.monitor.models.DataCollectionRuleDestinations
    :ivar data_flows: The specification of data flows.
    :vartype data_flows: list[~azure.mgmt.monitor.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "immutable_id": {"readonly": True},
        "metadata": {"readonly": True},
        "endpoints": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "DataCollectionRuleResourceIdentity"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "DataCollectionRuleResourceSystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "immutable_id": {"key": "properties.immutableId", "type": "str"},
        "data_collection_endpoint_id": {"key": "properties.dataCollectionEndpointId", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "DataCollectionRuleMetadata"},
        "endpoints": {"key": "properties.endpoints", "type": "DataCollectionRuleEndpoints"},
        "references": {"key": "properties.references", "type": "DataCollectionRuleReferences"},
        "agent_settings": {"key": "properties.agentSettings", "type": "DataCollectionRuleAgentSettings"},
        "stream_declarations": {"key": "properties.streamDeclarations", "type": "{StreamDeclaration}"},
        "data_sources": {"key": "properties.dataSources", "type": "DataCollectionRuleDataSources"},
        "destinations": {"key": "properties.destinations", "type": "DataCollectionRuleDestinations"},
        "data_flows": {"key": "properties.dataFlows", "type": "[DataFlow]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        kind: Optional[Union[str, "_models.KnownDataCollectionRuleResourceKind"]] = None,
        identity: Optional["_models.DataCollectionRuleResourceIdentity"] = None,
        description: Optional[str] = None,
        data_collection_endpoint_id: Optional[str] = None,
        references: Optional["_models.DataCollectionRuleReferences"] = None,
        agent_settings: Optional["_models.DataCollectionRuleAgentSettings"] = None,
        stream_declarations: Optional[dict[str, "_models.StreamDeclaration"]] = None,
        data_sources: Optional["_models.DataCollectionRuleDataSources"] = None,
        destinations: Optional["_models.DataCollectionRuleDestinations"] = None,
        data_flows: Optional[list["_models.DataFlow"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of the resource. Known values are: "Linux" and "Windows".
        :paramtype kind: str or ~azure.mgmt.monitor.models.KnownDataCollectionRuleResourceKind
        :keyword identity: Managed service identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.models.DataCollectionRuleResourceIdentity
        :keyword description: Description of the data collection rule.
        :paramtype description: str
        :keyword data_collection_endpoint_id: The resource ID of the data collection endpoint that this
         rule can be used with.
        :paramtype data_collection_endpoint_id: str
        :keyword references: Defines all the references that may be used in other sections of the DCR.
        :paramtype references: ~azure.mgmt.monitor.models.DataCollectionRuleReferences
        :keyword agent_settings: Agent settings used to modify agent behavior on a given host.
        :paramtype agent_settings: ~azure.mgmt.monitor.models.DataCollectionRuleAgentSettings
        :keyword stream_declarations: Declaration of custom streams used in this rule.
        :paramtype stream_declarations: dict[str, ~azure.mgmt.monitor.models.StreamDeclaration]
        :keyword data_sources: The specification of data sources.
         This property is optional and can be omitted if the rule is meant to be used via direct calls
         to the provisioned endpoint.
        :paramtype data_sources: ~azure.mgmt.monitor.models.DataCollectionRuleDataSources
        :keyword destinations: The specification of destinations.
        :paramtype destinations: ~azure.mgmt.monitor.models.DataCollectionRuleDestinations
        :keyword data_flows: The specification of data flows.
        :paramtype data_flows: list[~azure.mgmt.monitor.models.DataFlow]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.kind = kind
        self.identity = identity
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.system_data: Optional["_models.DataCollectionRuleResourceSystemData"] = None
        self.description = description
        self.immutable_id: Optional[str] = None
        self.data_collection_endpoint_id = data_collection_endpoint_id
        self.metadata: Optional["_models.DataCollectionRuleMetadata"] = None
        self.endpoints: Optional["_models.DataCollectionRuleEndpoints"] = None
        self.references = references
        self.agent_settings = agent_settings
        self.stream_declarations = stream_declarations
        self.data_sources = data_sources
        self.destinations = destinations
        self.data_flows = data_flows
        self.provisioning_state: Optional[Union[str, "_models.KnownDataCollectionRuleProvisioningState"]] = None


class DataCollectionRuleResourceIdentity(ManagedServiceIdentity):
    """Managed service identity of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.monitor.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.monitor.models.UserAssignedIdentity]
    """


class DataCollectionRuleResourceListResult(_serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of resources. Required.
    :vartype value: list[~azure.mgmt.monitor.models.DataCollectionRuleResource]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataCollectionRuleResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.DataCollectionRuleResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of resources. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.DataCollectionRuleResource]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionRuleResourceProperties(DataCollectionRule):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the data collection rule.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :ivar data_collection_endpoint_id: The resource ID of the data collection endpoint that this
     rule can be used with.
    :vartype data_collection_endpoint_id: str
    :ivar metadata: Metadata about the resource.
    :vartype metadata: ~azure.mgmt.monitor.models.DataCollectionRuleMetadata
    :ivar endpoints: Defines the ingestion endpoints to send data to via this rule.
    :vartype endpoints: ~azure.mgmt.monitor.models.DataCollectionRuleEndpoints
    :ivar references: Defines all the references that may be used in other sections of the DCR.
    :vartype references: ~azure.mgmt.monitor.models.DataCollectionRuleReferences
    :ivar agent_settings: Agent settings used to modify agent behavior on a given host.
    :vartype agent_settings: ~azure.mgmt.monitor.models.DataCollectionRuleAgentSettings
    :ivar stream_declarations: Declaration of custom streams used in this rule.
    :vartype stream_declarations: dict[str, ~azure.mgmt.monitor.models.StreamDeclaration]
    :ivar data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :vartype data_sources: ~azure.mgmt.monitor.models.DataCollectionRuleDataSources
    :ivar destinations: The specification of destinations.
    :vartype destinations: ~azure.mgmt.monitor.models.DataCollectionRuleDestinations
    :ivar data_flows: The specification of data flows.
    :vartype data_flows: list[~azure.mgmt.monitor.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.KnownDataCollectionRuleProvisioningState
    """


class DataCollectionRuleResourceSystemData(SystemData):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.monitor.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """


class DataContainer(_serialization.Model):
    """Information about a container with data for a given resource.

    All required parameters must be populated in order to send to server.

    :ivar workspace: Log Analytics workspace information. Required.
    :vartype workspace: ~azure.mgmt.monitor.models.WorkspaceInfo
    """

    _validation = {
        "workspace": {"required": True},
    }

    _attribute_map = {
        "workspace": {"key": "workspace", "type": "WorkspaceInfo"},
    }

    def __init__(self, *, workspace: "_models.WorkspaceInfo", **kwargs: Any) -> None:
        """
        :keyword workspace: Log Analytics workspace information. Required.
        :paramtype workspace: ~azure.mgmt.monitor.models.WorkspaceInfo
        """
        super().__init__(**kwargs)
        self.workspace = workspace


class DataFlow(_serialization.Model):
    """Definition of which streams are sent to which destinations.

    :ivar streams: List of streams for this data flow.
    :vartype streams: list[str or ~azure.mgmt.monitor.models.KnownDataFlowStreams]
    :ivar destinations: List of destinations for this data flow.
    :vartype destinations: list[str]
    :ivar transform_kql: The KQL query to transform stream data.
    :vartype transform_kql: str
    :ivar output_stream: The output stream of the transform. Only required if the transform changes
     data to a different stream.
    :vartype output_stream: str
    :ivar built_in_transform: The builtIn transform to transform stream data.
    :vartype built_in_transform: str
    :ivar capture_overflow: Flag to enable overflow column in LA destinations.
    :vartype capture_overflow: bool
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "destinations": {"key": "destinations", "type": "[str]"},
        "transform_kql": {"key": "transformKql", "type": "str"},
        "output_stream": {"key": "outputStream", "type": "str"},
        "built_in_transform": {"key": "builtInTransform", "type": "str"},
        "capture_overflow": {"key": "captureOverflow", "type": "bool"},
    }

    def __init__(
        self,
        *,
        streams: Optional[list[Union[str, "_models.KnownDataFlowStreams"]]] = None,
        destinations: Optional[list[str]] = None,
        transform_kql: Optional[str] = None,
        output_stream: Optional[str] = None,
        built_in_transform: Optional[str] = None,
        capture_overflow: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams for this data flow.
        :paramtype streams: list[str or ~azure.mgmt.monitor.models.KnownDataFlowStreams]
        :keyword destinations: List of destinations for this data flow.
        :paramtype destinations: list[str]
        :keyword transform_kql: The KQL query to transform stream data.
        :paramtype transform_kql: str
        :keyword output_stream: The output stream of the transform. Only required if the transform
         changes data to a different stream.
        :paramtype output_stream: str
        :keyword built_in_transform: The builtIn transform to transform stream data.
        :paramtype built_in_transform: str
        :keyword capture_overflow: Flag to enable overflow column in LA destinations.
        :paramtype capture_overflow: bool
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.destinations = destinations
        self.transform_kql = transform_kql
        self.output_stream = output_stream
        self.built_in_transform = built_in_transform
        self.capture_overflow = capture_overflow


class DataImportSources(_serialization.Model):
    """DataImportSources.

    :ivar event_hub: Definition of Event Hub configuration.
    :vartype event_hub: ~azure.mgmt.monitor.models.DataImportSourcesEventHub
    """

    _attribute_map = {
        "event_hub": {"key": "eventHub", "type": "DataImportSourcesEventHub"},
    }

    def __init__(self, *, event_hub: Optional["_models.DataImportSourcesEventHub"] = None, **kwargs: Any) -> None:
        """
        :keyword event_hub: Definition of Event Hub configuration.
        :paramtype event_hub: ~azure.mgmt.monitor.models.DataImportSourcesEventHub
        """
        super().__init__(**kwargs)
        self.event_hub = event_hub


class EventHubDataSource(_serialization.Model):
    """EventHubDataSource.

    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    :ivar consumer_group: Event Hub consumer group name.
    :vartype consumer_group: str
    :ivar stream: The stream to collect from EventHub.
    :vartype stream: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "consumer_group": {"key": "consumerGroup", "type": "str"},
        "stream": {"key": "stream", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        consumer_group: Optional[str] = None,
        stream: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        :keyword consumer_group: Event Hub consumer group name.
        :paramtype consumer_group: str
        :keyword stream: The stream to collect from EventHub.
        :paramtype stream: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.consumer_group = consumer_group
        self.stream = stream


class DataImportSourcesEventHub(EventHubDataSource):
    """Definition of Event Hub configuration.

    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    :ivar consumer_group: Event Hub consumer group name.
    :vartype consumer_group: str
    :ivar stream: The stream to collect from EventHub.
    :vartype stream: str
    """


class DataSource(_serialization.Model):
    """Data source object contains configuration to collect telemetry and one or more sinks to send
    that telemetry data to.

    All required parameters must be populated in order to send to server.

    :ivar kind: Datasource kind. Required. Known values are: "PerformanceCounter", "ETWProviders",
     and "WindowsEventLogs".
    :vartype kind: str or ~azure.mgmt.monitor.models.DataSourceKind
    :ivar configuration: Required.
    :vartype configuration: ~azure.mgmt.monitor.models.DataSourceConfiguration
    :ivar sinks: Required.
    :vartype sinks: list[~azure.mgmt.monitor.models.SinkConfiguration]
    """

    _validation = {
        "kind": {"required": True},
        "configuration": {"required": True},
        "sinks": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "configuration": {"key": "configuration", "type": "DataSourceConfiguration"},
        "sinks": {"key": "sinks", "type": "[SinkConfiguration]"},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "_models.DataSourceKind"],
        configuration: "_models.DataSourceConfiguration",
        sinks: list["_models.SinkConfiguration"],
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Datasource kind. Required. Known values are: "PerformanceCounter",
         "ETWProviders", and "WindowsEventLogs".
        :paramtype kind: str or ~azure.mgmt.monitor.models.DataSourceKind
        :keyword configuration: Required.
        :paramtype configuration: ~azure.mgmt.monitor.models.DataSourceConfiguration
        :keyword sinks: Required.
        :paramtype sinks: list[~azure.mgmt.monitor.models.SinkConfiguration]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.configuration = configuration
        self.sinks = sinks


class DataSourceConfiguration(_serialization.Model):
    """DataSourceConfiguration.

    :ivar providers: ETW providers configuration.
    :vartype providers: list[~azure.mgmt.monitor.models.EtwProviderConfiguration]
    :ivar perf_counters: Performance counter configuration.
    :vartype perf_counters: list[~azure.mgmt.monitor.models.PerformanceCounterConfiguration]
    :ivar event_logs: Windows event logs configuration.
    :vartype event_logs: list[~azure.mgmt.monitor.models.EventLogConfiguration]
    """

    _attribute_map = {
        "providers": {"key": "providers", "type": "[EtwProviderConfiguration]"},
        "perf_counters": {"key": "perfCounters", "type": "[PerformanceCounterConfiguration]"},
        "event_logs": {"key": "eventLogs", "type": "[EventLogConfiguration]"},
    }

    def __init__(
        self,
        *,
        providers: Optional[list["_models.EtwProviderConfiguration"]] = None,
        perf_counters: Optional[list["_models.PerformanceCounterConfiguration"]] = None,
        event_logs: Optional[list["_models.EventLogConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword providers: ETW providers configuration.
        :paramtype providers: list[~azure.mgmt.monitor.models.EtwProviderConfiguration]
        :keyword perf_counters: Performance counter configuration.
        :paramtype perf_counters: list[~azure.mgmt.monitor.models.PerformanceCounterConfiguration]
        :keyword event_logs: Windows event logs configuration.
        :paramtype event_logs: list[~azure.mgmt.monitor.models.EventLogConfiguration]
        """
        super().__init__(**kwargs)
        self.providers = providers
        self.perf_counters = perf_counters
        self.event_logs = event_logs


class DataSourcesSpecDataImports(DataImportSources):
    """Specifications of pull based data sources.

    :ivar event_hub: Definition of Event Hub configuration.
    :vartype event_hub: ~azure.mgmt.monitor.models.DataImportSourcesEventHub
    """


class DestinationsSpecAzureMonitorMetrics(AzureMonitorMetricsDestination):
    """Azure Monitor Metrics destination.

    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """


class ProxyOnlyResource(_serialization.Model):
    """A proxy only azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class DiagnosticSettingsCategoryResource(ProxyOnlyResource):
    """The diagnostic settings category resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar category_type: The type of the diagnostic settings category. Known values are: "Metrics"
     and "Logs".
    :vartype category_type: str or ~azure.mgmt.monitor.models.CategoryType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "category_type": {"key": "properties.categoryType", "type": "str"},
    }

    def __init__(self, *, category_type: Optional[Union[str, "_models.CategoryType"]] = None, **kwargs: Any) -> None:
        """
        :keyword category_type: The type of the diagnostic settings category. Known values are:
         "Metrics" and "Logs".
        :paramtype category_type: str or ~azure.mgmt.monitor.models.CategoryType
        """
        super().__init__(**kwargs)
        self.category_type = category_type


class DiagnosticSettingsCategoryResourceCollection(_serialization.Model):  # pylint: disable=name-too-long
    """Represents a collection of diagnostic setting category resources.

    :ivar value: The collection of diagnostic settings category resources.
    :vartype value: list[~azure.mgmt.monitor.models.DiagnosticSettingsCategoryResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DiagnosticSettingsCategoryResource]"},
    }

    def __init__(
        self, *, value: Optional[list["_models.DiagnosticSettingsCategoryResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection of diagnostic settings category resources.
        :paramtype value: list[~azure.mgmt.monitor.models.DiagnosticSettingsCategoryResource]
        """
        super().__init__(**kwargs)
        self.value = value


class ResourceAutoGenerated(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class DiagnosticSettingsResource(ResourceAutoGenerated):
    """The diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :vartype service_bus_rule_id: str
    :ivar event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :vartype event_hub_authorization_rule_id: str
    :ivar event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :vartype event_hub_name: str
    :ivar metrics: The list of metric settings.
    :vartype metrics: list[~azure.mgmt.monitor.models.MetricSettings]
    :ivar logs: The list of logs settings.
    :vartype logs: list[~azure.mgmt.monitor.models.LogSettings]
    :ivar workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    :ivar marketplace_partner_id: The full ARM resource ID of the Marketplace resource to which you
     would like to send Diagnostic Logs.
    :vartype marketplace_partner_id: str
    :ivar log_analytics_destination_type: A string indicating whether the export to Log Analytics
     should use the default destination type, i.e. AzureDiagnostics, or use a destination type
     constructed as follows: :code:`<normalized service identity>`_\\ :code:`<normalized category
     name>`. Possible values are: Dedicated and null (null is default.).
    :vartype log_analytics_destination_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "service_bus_rule_id": {"key": "properties.serviceBusRuleId", "type": "str"},
        "event_hub_authorization_rule_id": {"key": "properties.eventHubAuthorizationRuleId", "type": "str"},
        "event_hub_name": {"key": "properties.eventHubName", "type": "str"},
        "metrics": {"key": "properties.metrics", "type": "[MetricSettings]"},
        "logs": {"key": "properties.logs", "type": "[LogSettings]"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
        "marketplace_partner_id": {"key": "properties.marketplacePartnerId", "type": "str"},
        "log_analytics_destination_type": {"key": "properties.logAnalyticsDestinationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        event_hub_authorization_rule_id: Optional[str] = None,
        event_hub_name: Optional[str] = None,
        metrics: Optional[list["_models.MetricSettings"]] = None,
        logs: Optional[list["_models.LogSettings"]] = None,
        workspace_id: Optional[str] = None,
        marketplace_partner_id: Optional[str] = None,
        log_analytics_destination_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here
         to maintain backwards compatibility.
        :paramtype service_bus_rule_id: str
        :keyword event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
        :paramtype event_hub_authorization_rule_id: str
        :keyword event_hub_name: The name of the event hub. If none is specified, the default event hub
         will be selected.
        :paramtype event_hub_name: str
        :keyword metrics: The list of metric settings.
        :paramtype metrics: list[~azure.mgmt.monitor.models.MetricSettings]
        :keyword logs: The list of logs settings.
        :paramtype logs: list[~azure.mgmt.monitor.models.LogSettings]
        :keyword workspace_id: The full ARM resource ID of the Log Analytics workspace to which you
         would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        :keyword marketplace_partner_id: The full ARM resource ID of the Marketplace resource to which
         you would like to send Diagnostic Logs.
        :paramtype marketplace_partner_id: str
        :keyword log_analytics_destination_type: A string indicating whether the export to Log
         Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination
         type constructed as follows: :code:`<normalized service identity>`_\\ :code:`<normalized
         category name>`. Possible values are: Dedicated and null (null is default.).
        :paramtype log_analytics_destination_type: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.event_hub_authorization_rule_id = event_hub_authorization_rule_id
        self.event_hub_name = event_hub_name
        self.metrics = metrics
        self.logs = logs
        self.workspace_id = workspace_id
        self.marketplace_partner_id = marketplace_partner_id
        self.log_analytics_destination_type = log_analytics_destination_type


class DiagnosticSettingsResourceCollection(_serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: The collection of diagnostic settings resources;.
    :vartype value: list[~azure.mgmt.monitor.models.DiagnosticSettingsResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DiagnosticSettingsResource]"},
    }

    def __init__(self, *, value: Optional[list["_models.DiagnosticSettingsResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The collection of diagnostic settings resources;.
        :paramtype value: list[~azure.mgmt.monitor.models.DiagnosticSettingsResource]
        """
        super().__init__(**kwargs)
        self.value = value


class Dimension(_serialization.Model):
    """Dimension splitting and filtering definition.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the dimension. Required.
    :vartype name: str
    :ivar operator: Operator for dimension values. Required. Known values are: "Include" and
     "Exclude".
    :vartype operator: str or ~azure.mgmt.monitor.models.DimensionOperator
    :ivar values: List of dimension values. Required.
    :vartype values: list[str]
    """

    _validation = {
        "name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(
        self, *, name: str, operator: Union[str, "_models.DimensionOperator"], values: list[str], **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the dimension. Required.
        :paramtype name: str
        :keyword operator: Operator for dimension values. Required. Known values are: "Include" and
         "Exclude".
        :paramtype operator: str or ~azure.mgmt.monitor.models.DimensionOperator
        :keyword values: List of dimension values. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class MultiMetricCriteria(_serialization.Model):
    """The types of conditions for a multi resource alert.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DynamicMetricCriteria, MetricCriteria

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar criterion_type: Specifies the type of threshold criteria. Previously undocumented values
     might be returned. Required. Known values are: "StaticThresholdCriterion" and
     "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~azure.mgmt.monitor.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar metric_name: Name of the metric. Required.
    :vartype metric_name: str
    :ivar metric_namespace: Namespace of the metric.
    :vartype metric_namespace: str
    :ivar time_aggregation: The criteria time aggregation types. Previously undocumented values
     might be returned. Required. Known values are: "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype time_aggregation: str or ~azure.mgmt.monitor.models.AggregationTypeEnum
    :ivar dimensions: List of dimension conditions.
    :vartype dimensions: list[~azure.mgmt.monitor.models.MetricDimension]
    :ivar skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :vartype skip_metric_validation: bool
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "metric_name": {"required": True},
        "time_aggregation": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "skip_metric_validation": {"key": "skipMetricValidation", "type": "bool"},
    }

    _subtype_map = {
        "criterion_type": {
            "DynamicThresholdCriterion": "DynamicMetricCriteria",
            "StaticThresholdCriterion": "MetricCriteria",
        }
    }

    def __init__(
        self,
        *,
        name: str,
        metric_name: str,
        time_aggregation: Union[str, "_models.AggregationTypeEnum"],
        additional_properties: Optional[dict[str, JSON]] = None,
        metric_namespace: Optional[str] = None,
        dimensions: Optional[list["_models.MetricDimension"]] = None,
        skip_metric_validation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword metric_name: Name of the metric. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Namespace of the metric.
        :paramtype metric_namespace: str
        :keyword time_aggregation: The criteria time aggregation types. Previously undocumented values
         might be returned. Required. Known values are: "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype time_aggregation: str or ~azure.mgmt.monitor.models.AggregationTypeEnum
        :keyword dimensions: List of dimension conditions.
        :paramtype dimensions: list[~azure.mgmt.monitor.models.MetricDimension]
        :keyword skip_metric_validation: Allows creating an alert rule on a custom metric that isn't
         yet emitted, by causing the metric validation to be skipped.
        :paramtype skip_metric_validation: bool
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.criterion_type: Optional[str] = None
        self.name = name
        self.metric_name = metric_name
        self.metric_namespace = metric_namespace
        self.time_aggregation = time_aggregation
        self.dimensions = dimensions
        self.skip_metric_validation = skip_metric_validation


class DynamicMetricCriteria(MultiMetricCriteria):
    """Criterion for dynamic threshold.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar criterion_type: Specifies the type of threshold criteria. Previously undocumented values
     might be returned. Required. Known values are: "StaticThresholdCriterion" and
     "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~azure.mgmt.monitor.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar metric_name: Name of the metric. Required.
    :vartype metric_name: str
    :ivar metric_namespace: Namespace of the metric.
    :vartype metric_namespace: str
    :ivar time_aggregation: The criteria time aggregation types. Previously undocumented values
     might be returned. Required. Known values are: "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype time_aggregation: str or ~azure.mgmt.monitor.models.AggregationTypeEnum
    :ivar dimensions: List of dimension conditions.
    :vartype dimensions: list[~azure.mgmt.monitor.models.MetricDimension]
    :ivar skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :vartype skip_metric_validation: bool
    :ivar operator: The operator used to compare the metric value against the threshold. Previously
     undocumented values might be returned. Required. Known values are: "GreaterThan", "LessThan",
     and "GreaterOrLessThan".
    :vartype operator: str or ~azure.mgmt.monitor.models.DynamicThresholdOperator
    :ivar alert_sensitivity: The extent of deviation required to trigger an alert. This will affect
     how tight the threshold is to the metric series pattern. Previously undocumented values might
     be returned. Required. Known values are: "Low", "Medium", and "High".
    :vartype alert_sensitivity: str or ~azure.mgmt.monitor.models.DynamicThresholdSensitivity
    :ivar failing_periods: The minimum number of violations required within the selected lookback
     time window required to raise an alert. Required.
    :vartype failing_periods: ~azure.mgmt.monitor.models.DynamicThresholdFailingPeriods
    :ivar ignore_data_before: Use this option to set the date from which to start learning the
     metric historical data and calculate the dynamic thresholds (in ISO8601 format).
    :vartype ignore_data_before: ~datetime.datetime
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "metric_name": {"required": True},
        "time_aggregation": {"required": True},
        "operator": {"required": True},
        "alert_sensitivity": {"required": True},
        "failing_periods": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "skip_metric_validation": {"key": "skipMetricValidation", "type": "bool"},
        "operator": {"key": "operator", "type": "str"},
        "alert_sensitivity": {"key": "alertSensitivity", "type": "str"},
        "failing_periods": {"key": "failingPeriods", "type": "DynamicThresholdFailingPeriods"},
        "ignore_data_before": {"key": "ignoreDataBefore", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        name: str,
        metric_name: str,
        time_aggregation: Union[str, "_models.AggregationTypeEnum"],
        operator: Union[str, "_models.DynamicThresholdOperator"],
        alert_sensitivity: Union[str, "_models.DynamicThresholdSensitivity"],
        failing_periods: "_models.DynamicThresholdFailingPeriods",
        additional_properties: Optional[dict[str, JSON]] = None,
        metric_namespace: Optional[str] = None,
        dimensions: Optional[list["_models.MetricDimension"]] = None,
        skip_metric_validation: Optional[bool] = None,
        ignore_data_before: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword metric_name: Name of the metric. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Namespace of the metric.
        :paramtype metric_namespace: str
        :keyword time_aggregation: The criteria time aggregation types. Previously undocumented values
         might be returned. Required. Known values are: "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype time_aggregation: str or ~azure.mgmt.monitor.models.AggregationTypeEnum
        :keyword dimensions: List of dimension conditions.
        :paramtype dimensions: list[~azure.mgmt.monitor.models.MetricDimension]
        :keyword skip_metric_validation: Allows creating an alert rule on a custom metric that isn't
         yet emitted, by causing the metric validation to be skipped.
        :paramtype skip_metric_validation: bool
        :keyword operator: The operator used to compare the metric value against the threshold.
         Previously undocumented values might be returned. Required. Known values are: "GreaterThan",
         "LessThan", and "GreaterOrLessThan".
        :paramtype operator: str or ~azure.mgmt.monitor.models.DynamicThresholdOperator
        :keyword alert_sensitivity: The extent of deviation required to trigger an alert. This will
         affect how tight the threshold is to the metric series pattern. Previously undocumented values
         might be returned. Required. Known values are: "Low", "Medium", and "High".
        :paramtype alert_sensitivity: str or ~azure.mgmt.monitor.models.DynamicThresholdSensitivity
        :keyword failing_periods: The minimum number of violations required within the selected
         lookback time window required to raise an alert. Required.
        :paramtype failing_periods: ~azure.mgmt.monitor.models.DynamicThresholdFailingPeriods
        :keyword ignore_data_before: Use this option to set the date from which to start learning the
         metric historical data and calculate the dynamic thresholds (in ISO8601 format).
        :paramtype ignore_data_before: ~datetime.datetime
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            metric_name=metric_name,
            metric_namespace=metric_namespace,
            time_aggregation=time_aggregation,
            dimensions=dimensions,
            skip_metric_validation=skip_metric_validation,
            **kwargs
        )
        self.criterion_type: str = "DynamicThresholdCriterion"
        self.operator = operator
        self.alert_sensitivity = alert_sensitivity
        self.failing_periods = failing_periods
        self.ignore_data_before = ignore_data_before


class MultiPromQLCriteria(_serialization.Model):
    """The types of conditions for a multi query metric alert.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DynamicPromQLCriteria, StaticPromQLCriteria

    All required parameters must be populated in order to send to server.

    :ivar criterion_type: Specifies the type of threshold criteria. Previously undocumented values
     might be returned. Required. Known values are: "StaticThresholdCriterion" and
     "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~azure.mgmt.monitor.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar query: The query used to evaluate the alert rule. Required.
    :vartype query: str
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "query": {"required": True},
    }

    _attribute_map = {
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    _subtype_map = {
        "criterion_type": {
            "DynamicThresholdCriterion": "DynamicPromQLCriteria",
            "StaticThresholdCriterion": "StaticPromQLCriteria",
        }
    }

    def __init__(self, *, name: str, query: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword query: The query used to evaluate the alert rule. Required.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.criterion_type: Optional[str] = None
        self.name = name
        self.query = query


class DynamicPromQLCriteria(MultiPromQLCriteria):
    """The criterion for dynamic prom query.

    All required parameters must be populated in order to send to server.

    :ivar criterion_type: Specifies the type of threshold criteria. Previously undocumented values
     might be returned. Required. Known values are: "StaticThresholdCriterion" and
     "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~azure.mgmt.monitor.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar query: The query used to evaluate the alert rule. Required.
    :vartype query: str
    :ivar operator: The operator used to compare the metric value against the threshold. Previously
     undocumented values might be returned. Required. Known values are: "GreaterThan", "LessThan",
     and "GreaterOrLessThan".
    :vartype operator: str or ~azure.mgmt.monitor.models.DynamicThresholdOperator
    :ivar alert_sensitivity: The extent of deviation required to trigger an alert. This will affect
     how tight the threshold is to the metric series pattern. Previously undocumented values might
     be returned. Required. Known values are: "Low", "Medium", and "High".
    :vartype alert_sensitivity: str or ~azure.mgmt.monitor.models.DynamicThresholdSensitivity
    :ivar ignore_data_before: Use this option to set the date from which to start learning the
     metric historical data and calculate the dynamic thresholds (in ISO8601 format).
    :vartype ignore_data_before: ~datetime.datetime
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "query": {"required": True},
        "operator": {"required": True},
        "alert_sensitivity": {"required": True},
    }

    _attribute_map = {
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "query": {"key": "query", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "alert_sensitivity": {"key": "alertSensitivity", "type": "str"},
        "ignore_data_before": {"key": "ignoreDataBefore", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        name: str,
        query: str,
        operator: Union[str, "_models.DynamicThresholdOperator"],
        alert_sensitivity: Union[str, "_models.DynamicThresholdSensitivity"],
        ignore_data_before: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword query: The query used to evaluate the alert rule. Required.
        :paramtype query: str
        :keyword operator: The operator used to compare the metric value against the threshold.
         Previously undocumented values might be returned. Required. Known values are: "GreaterThan",
         "LessThan", and "GreaterOrLessThan".
        :paramtype operator: str or ~azure.mgmt.monitor.models.DynamicThresholdOperator
        :keyword alert_sensitivity: The extent of deviation required to trigger an alert. This will
         affect how tight the threshold is to the metric series pattern. Previously undocumented values
         might be returned. Required. Known values are: "Low", "Medium", and "High".
        :paramtype alert_sensitivity: str or ~azure.mgmt.monitor.models.DynamicThresholdSensitivity
        :keyword ignore_data_before: Use this option to set the date from which to start learning the
         metric historical data and calculate the dynamic thresholds (in ISO8601 format).
        :paramtype ignore_data_before: ~datetime.datetime
        """
        super().__init__(name=name, query=query, **kwargs)
        self.criterion_type: str = "DynamicThresholdCriterion"
        self.operator = operator
        self.alert_sensitivity = alert_sensitivity
        self.ignore_data_before = ignore_data_before


class DynamicThresholdFailingPeriods(_serialization.Model):
    """The minimum number of violations required within the selected lookback time window required to
    raise an alert.

    All required parameters must be populated in order to send to server.

    :ivar number_of_evaluation_periods: The number of aggregated lookback points. The lookback time
     window is calculated based on the aggregation granularity (windowSize) and the selected number
     of aggregated points. Required.
    :vartype number_of_evaluation_periods: float
    :ivar min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
     smaller or equal to numberOfEvaluationPeriods. Required.
    :vartype min_failing_periods_to_alert: float
    """

    _validation = {
        "number_of_evaluation_periods": {"required": True},
        "min_failing_periods_to_alert": {"required": True},
    }

    _attribute_map = {
        "number_of_evaluation_periods": {"key": "numberOfEvaluationPeriods", "type": "float"},
        "min_failing_periods_to_alert": {"key": "minFailingPeriodsToAlert", "type": "float"},
    }

    def __init__(
        self, *, number_of_evaluation_periods: float, min_failing_periods_to_alert: float, **kwargs: Any
    ) -> None:
        """
        :keyword number_of_evaluation_periods: The number of aggregated lookback points. The lookback
         time window is calculated based on the aggregation granularity (windowSize) and the selected
         number of aggregated points. Required.
        :paramtype number_of_evaluation_periods: float
        :keyword min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
         smaller or equal to numberOfEvaluationPeriods. Required.
        :paramtype min_failing_periods_to_alert: float
        """
        super().__init__(**kwargs)
        self.number_of_evaluation_periods = number_of_evaluation_periods
        self.min_failing_periods_to_alert = min_failing_periods_to_alert


class EmailNotification(_serialization.Model):
    """Email notification of an autoscale event.

    :ivar send_to_subscription_administrator: a value indicating whether to send email to
     subscription administrator.
    :vartype send_to_subscription_administrator: bool
    :ivar send_to_subscription_co_administrators: a value indicating whether to send email to
     subscription co-administrators.
    :vartype send_to_subscription_co_administrators: bool
    :ivar custom_emails: the custom e-mails list. This value can be null or empty, in which case
     this attribute will be ignored.
    :vartype custom_emails: list[str]
    """

    _attribute_map = {
        "send_to_subscription_administrator": {"key": "sendToSubscriptionAdministrator", "type": "bool"},
        "send_to_subscription_co_administrators": {"key": "sendToSubscriptionCoAdministrators", "type": "bool"},
        "custom_emails": {"key": "customEmails", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        send_to_subscription_administrator: bool = False,
        send_to_subscription_co_administrators: bool = False,
        custom_emails: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword send_to_subscription_administrator: a value indicating whether to send email to
         subscription administrator.
        :paramtype send_to_subscription_administrator: bool
        :keyword send_to_subscription_co_administrators: a value indicating whether to send email to
         subscription co-administrators.
        :paramtype send_to_subscription_co_administrators: bool
        :keyword custom_emails: the custom e-mails list. This value can be null or empty, in which case
         this attribute will be ignored.
        :paramtype custom_emails: list[str]
        """
        super().__init__(**kwargs)
        self.send_to_subscription_administrator = send_to_subscription_administrator
        self.send_to_subscription_co_administrators = send_to_subscription_co_administrators
        self.custom_emails = custom_emails


class EmailReceiver(_serialization.Model):
    """An email receiver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the email receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar email_address: The email address of this receiver. Required.
    :vartype email_address: str
    :ivar use_common_alert_schema: Indicates whether to use common alert schema.
    :vartype use_common_alert_schema: bool
    :ivar status: The receiver status of the e-mail. Known values are: "NotSpecified", "Enabled",
     and "Disabled".
    :vartype status: str or ~azure.mgmt.monitor.models.ReceiverStatus
    """

    _validation = {
        "name": {"required": True},
        "email_address": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "use_common_alert_schema": {"key": "useCommonAlertSchema", "type": "bool"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, name: str, email_address: str, use_common_alert_schema: bool = False, **kwargs: Any) -> None:
        """
        :keyword name: The name of the email receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword email_address: The email address of this receiver. Required.
        :paramtype email_address: str
        :keyword use_common_alert_schema: Indicates whether to use common alert schema.
        :paramtype use_common_alert_schema: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.email_address = email_address
        self.use_common_alert_schema = use_common_alert_schema
        self.status: Optional[Union[str, "_models.ReceiverStatus"]] = None


class EnableRequest(_serialization.Model):
    """Describes a receiver that should be resubscribed.

    All required parameters must be populated in order to send to server.

    :ivar receiver_name: The name of the receiver to resubscribe. Required.
    :vartype receiver_name: str
    """

    _validation = {
        "receiver_name": {"required": True},
    }

    _attribute_map = {
        "receiver_name": {"key": "receiverName", "type": "str"},
    }

    def __init__(self, *, receiver_name: str, **kwargs: Any) -> None:
        """
        :keyword receiver_name: The name of the receiver to resubscribe. Required.
        :paramtype receiver_name: str
        """
        super().__init__(**kwargs)
        self.receiver_name = receiver_name


class EnrichmentData(_serialization.Model):
    """All the enrichment data sources referenced in data flows.

    :ivar storage_blobs: All the storage blobs used as enrichment data sources.
    :vartype storage_blobs: list[~azure.mgmt.monitor.models.StorageBlob]
    """

    _attribute_map = {
        "storage_blobs": {"key": "storageBlobs", "type": "[StorageBlob]"},
    }

    def __init__(self, *, storage_blobs: Optional[list["_models.StorageBlob"]] = None, **kwargs: Any) -> None:
        """
        :keyword storage_blobs: All the storage blobs used as enrichment data sources.
        :paramtype storage_blobs: list[~azure.mgmt.monitor.models.StorageBlob]
        """
        super().__init__(**kwargs)
        self.storage_blobs = storage_blobs


class Error(_serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to server.

    :ivar code: Error code identifying the specific error. Required.
    :vartype code: str
    :ivar message: Error message in the caller's locale.
    :vartype message: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: str, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code identifying the specific error. Required.
        :paramtype code: str
        :keyword message: Error message in the caller's locale.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorContract(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.monitor.models.ErrorResponseAutoGenerated4
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseAutoGenerated4"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseAutoGenerated4"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.monitor.models.ErrorResponseAutoGenerated4
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorDetail(_serialization.Model):
    """Describes details of an error response.

    :ivar code: Unlocalized string which can be used to programmatically identify the error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging information.
    :vartype message: str
    :ivar target: The target of the particular error (for example, the name of the property in
     error).
    :vartype target: str
    :ivar additional_info: An array of objects with 'type' and 'info' properties. The schema of
     'info' is service-specific and dependent on the 'type' string.
    :vartype additional_info: list[~azure.mgmt.monitor.models.ErrorDetailAdditionalInfoItem]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorDetailAdditionalInfoItem]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        additional_info: Optional[list["_models.ErrorDetailAdditionalInfoItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Unlocalized string which can be used to programmatically identify the error.
        :paramtype code: str
        :keyword message: Describes the error in detail and provides debugging information.
        :paramtype message: str
        :keyword target: The target of the particular error (for example, the name of the property in
         error).
        :paramtype target: str
        :keyword additional_info: An array of objects with 'type' and 'info' properties. The schema of
         'info' is service-specific and dependent on the 'type' string.
        :paramtype additional_info: list[~azure.mgmt.monitor.models.ErrorDetailAdditionalInfoItem]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.additional_info = additional_info


class ErrorDetailAdditionalInfoItem(_serialization.Model):
    """ErrorDetailAdditionalInfoItem.

    :ivar type: The type of additional information.
    :vartype type: str
    :ivar info: The additional information specific to the type.
    :vartype info: dict[str, any]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "{object}"},
    }

    def __init__(self, *, type: Optional[str] = None, info: Optional[dict[str, Any]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of additional information.
        :paramtype type: str
        :keyword info: The additional information specific to the type.
        :paramtype info: dict[str, any]
        """
        super().__init__(**kwargs)
        self.type = type
        self.info = info


class ErrorDetailAdditionalInfoItemAutoGenerated(_serialization.Model):  # pylint: disable=name-too-long
    """ErrorDetailAdditionalInfoItemAutoGenerated.

    :ivar type: The type of additional information.
    :vartype type: str
    :ivar info: The additional information specific to the type.
    :vartype info: dict[str, any]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "{object}"},
    }

    def __init__(self, *, type: Optional[str] = None, info: Optional[dict[str, Any]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of additional information.
        :paramtype type: str
        :keyword info: The additional information specific to the type.
        :paramtype info: dict[str, any]
        """
        super().__init__(**kwargs)
        self.type = type
        self.info = info


class ErrorDetailAutoGenerated(_serialization.Model):
    """Describes details of an error response.

    :ivar code: Unlocalized string which can be used to programmatically identify the error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging information.
    :vartype message: str
    :ivar target: The target of the particular error (for example, the name of the property in
     error).
    :vartype target: str
    :ivar additional_info: An array of objects with 'type' and 'info' properties. The schema of
     'info' is service-specific and dependent on the 'type' string.
    :vartype additional_info:
     list[~azure.mgmt.monitor.models.ErrorDetailAdditionalInfoItemAutoGenerated]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorDetailAdditionalInfoItemAutoGenerated]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        additional_info: Optional[list["_models.ErrorDetailAdditionalInfoItemAutoGenerated"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Unlocalized string which can be used to programmatically identify the error.
        :paramtype code: str
        :keyword message: Describes the error in detail and provides debugging information.
        :paramtype message: str
        :keyword target: The target of the particular error (for example, the name of the property in
         error).
        :paramtype target: str
        :keyword additional_info: An array of objects with 'type' and 'info' properties. The schema of
         'info' is service-specific and dependent on the 'type' string.
        :paramtype additional_info:
         list[~azure.mgmt.monitor.models.ErrorDetailAdditionalInfoItemAutoGenerated]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.additional_info = additional_info


class ErrorDetailAutoGenerated2(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.monitor.models.ErrorDetailAutoGenerated2]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.monitor.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailAutoGenerated2]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetailAutoGenerated2"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorDetailAutoGenerated3(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.monitor.models.ErrorDetailAutoGenerated3]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.monitor.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailAutoGenerated3]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetailAutoGenerated3"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseAutoGenerated(_serialization.Model):
    """The error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None


class ErrorResponseAutoGenerated2(_serialization.Model):
    """Describes the format of Error response.

    :ivar error:
    :vartype error: ~azure.mgmt.monitor.models.ErrorResponseError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseError"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseError"] = None, **kwargs: Any) -> None:
        """
        :keyword error:
        :paramtype error: ~azure.mgmt.monitor.models.ErrorResponseError
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated3(_serialization.Model):
    """Describes the format of Error response.

    :ivar error:
    :vartype error: ~azure.mgmt.monitor.models.ErrorResponseErrorAutoGenerated
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseErrorAutoGenerated"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseErrorAutoGenerated"] = None, **kwargs: Any) -> None:
        """
        :keyword error:
        :paramtype error: ~azure.mgmt.monitor.models.ErrorResponseErrorAutoGenerated
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated4(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.monitor.models.ErrorResponseAutoGenerated4]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.monitor.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseAutoGenerated4]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorResponseAutoGenerated4"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponseAutoGenerated5(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.monitor.models.ErrorDetailAutoGenerated2
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated2"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetailAutoGenerated2"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.monitor.models.ErrorDetailAutoGenerated2
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseCommon(ErrorResponse):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.monitor.models.ErrorResponseCommon]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.monitor.models.ErrorAdditionalInfo]
    """

    _validation = {
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseCommon]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(code=code, message=message, **kwargs)
        self.details: Optional[list["_models.ErrorResponseCommon"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponseCommonV2(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.monitor.models.ErrorDetailAutoGenerated3
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated3"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetailAutoGenerated3"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.monitor.models.ErrorDetailAutoGenerated3
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseError(_serialization.Model):
    """ErrorResponseError.

    :ivar code: Unlocalized string which can be used to programmatically identify the error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging information. If
     Accept-Language is set in the request, it must be localized to that language.
    :vartype message: str
    :ivar target: The target of the particular error (for example, the name of the property in
     error).
    :vartype target: str
    :ivar details: An array of additional nested error response info objects, as described by this
     contract.
    :vartype details: list[~azure.mgmt.monitor.models.ErrorDetail]
    :ivar additional_info: An array of objects with 'type' and 'info' properties. The schema of
     'info' is service-specific and dependent on the 'type' string.
    :vartype additional_info: list[~azure.mgmt.monitor.models.ErrorResponseErrorAdditionalInfoItem]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorResponseErrorAdditionalInfoItem]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.ErrorDetail"]] = None,
        additional_info: Optional[list["_models.ErrorResponseErrorAdditionalInfoItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Unlocalized string which can be used to programmatically identify the error.
        :paramtype code: str
        :keyword message: Describes the error in detail and provides debugging information. If
         Accept-Language is set in the request, it must be localized to that language.
        :paramtype message: str
        :keyword target: The target of the particular error (for example, the name of the property in
         error).
        :paramtype target: str
        :keyword details: An array of additional nested error response info objects, as described by
         this contract.
        :paramtype details: list[~azure.mgmt.monitor.models.ErrorDetail]
        :keyword additional_info: An array of objects with 'type' and 'info' properties. The schema of
         'info' is service-specific and dependent on the 'type' string.
        :paramtype additional_info:
         list[~azure.mgmt.monitor.models.ErrorResponseErrorAdditionalInfoItem]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.additional_info = additional_info


class ErrorResponseErrorAdditionalInfoItem(_serialization.Model):
    """ErrorResponseErrorAdditionalInfoItem.

    :ivar type: The type of additional information.
    :vartype type: str
    :ivar info: The additional information specific to the type.
    :vartype info: dict[str, any]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "{object}"},
    }

    def __init__(self, *, type: Optional[str] = None, info: Optional[dict[str, Any]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of additional information.
        :paramtype type: str
        :keyword info: The additional information specific to the type.
        :paramtype info: dict[str, any]
        """
        super().__init__(**kwargs)
        self.type = type
        self.info = info


class ErrorResponseErrorAdditionalInfoItemAutoGenerated(_serialization.Model):  # pylint: disable=name-too-long
    """ErrorResponseErrorAdditionalInfoItemAutoGenerated.

    :ivar type: The type of additional information.
    :vartype type: str
    :ivar info: The additional information specific to the type.
    :vartype info: dict[str, any]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "{object}"},
    }

    def __init__(self, *, type: Optional[str] = None, info: Optional[dict[str, Any]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of additional information.
        :paramtype type: str
        :keyword info: The additional information specific to the type.
        :paramtype info: dict[str, any]
        """
        super().__init__(**kwargs)
        self.type = type
        self.info = info


class ErrorResponseErrorAutoGenerated(_serialization.Model):
    """ErrorResponseErrorAutoGenerated.

    :ivar code: Unlocalized string which can be used to programmatically identify the error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging information. If
     Accept-Language is set in the request, it must be localized to that language.
    :vartype message: str
    :ivar target: The target of the particular error (for example, the name of the property in
     error).
    :vartype target: str
    :ivar details: An array of additional nested error response info objects, as described by this
     contract.
    :vartype details: list[~azure.mgmt.monitor.models.ErrorDetailAutoGenerated]
    :ivar additional_info: An array of objects with 'type' and 'info' properties. The schema of
     'info' is service-specific and dependent on the 'type' string.
    :vartype additional_info:
     list[~azure.mgmt.monitor.models.ErrorResponseErrorAdditionalInfoItemAutoGenerated]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailAutoGenerated]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorResponseErrorAdditionalInfoItemAutoGenerated]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.ErrorDetailAutoGenerated"]] = None,
        additional_info: Optional[list["_models.ErrorResponseErrorAdditionalInfoItemAutoGenerated"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Unlocalized string which can be used to programmatically identify the error.
        :paramtype code: str
        :keyword message: Describes the error in detail and provides debugging information. If
         Accept-Language is set in the request, it must be localized to that language.
        :paramtype message: str
        :keyword target: The target of the particular error (for example, the name of the property in
         error).
        :paramtype target: str
        :keyword details: An array of additional nested error response info objects, as described by
         this contract.
        :paramtype details: list[~azure.mgmt.monitor.models.ErrorDetailAutoGenerated]
        :keyword additional_info: An array of objects with 'type' and 'info' properties. The schema of
         'info' is service-specific and dependent on the 'type' string.
        :paramtype additional_info:
         list[~azure.mgmt.monitor.models.ErrorResponseErrorAdditionalInfoItemAutoGenerated]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.additional_info = additional_info


class EtwEventConfiguration(_serialization.Model):
    """EtwEventConfiguration.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar id: Required.
    :vartype id: int
    :ivar filter:
    :vartype filter: str
    """

    _validation = {
        "name": {"required": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "int"},
        "filter": {"key": "filter", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: int,  # pylint: disable=redefined-builtin
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword id: Required.
        :paramtype id: int
        :keyword filter:
        :paramtype filter: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.filter = filter


class EtwProviderConfiguration(_serialization.Model):
    """EtwProviderConfiguration.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar events: Required.
    :vartype events: list[~azure.mgmt.monitor.models.EtwEventConfiguration]
    """

    _validation = {
        "id": {"required": True},
        "events": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "events": {"key": "events", "type": "[EtwEventConfiguration]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        events: list["_models.EtwEventConfiguration"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword events: Required.
        :paramtype events: list[~azure.mgmt.monitor.models.EtwEventConfiguration]
        """
        super().__init__(**kwargs)
        self.id = id
        self.events = events


class EventCategoryCollection(_serialization.Model):
    """A collection of event categories. Currently possible values are: Administrative, Security,
    ServiceHealth, Alert, Recommendation, Policy.

    All required parameters must be populated in order to send to server.

    :ivar value: the list that includes the Azure event categories. Required.
    :vartype value: list[~azure.mgmt.monitor.models.LocalizableString]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalizableString]"},
    }

    def __init__(self, *, value: list["_models.LocalizableString"], **kwargs: Any) -> None:
        """
        :keyword value: the list that includes the Azure event categories. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.LocalizableString]
        """
        super().__init__(**kwargs)
        self.value = value


class EventData(_serialization.Model):
    """The Azure event log entries are of type EventData.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar authorization: The sender authorization information.
    :vartype authorization: ~azure.mgmt.monitor.models.SenderAuthorization
    :ivar claims: key value pairs to identify ARM permissions.
    :vartype claims: dict[str, str]
    :ivar caller: the email address of the user who has performed the operation, the UPN claim or
     SPN claim based on availability.
    :vartype caller: str
    :ivar description: the description of the event.
    :vartype description: str
    :ivar id: the Id of this event as required by ARM for RBAC. It contains the EventDataID and a
     timestamp information.
    :vartype id: str
    :ivar event_data_id: the event data Id. This is a unique identifier for an event.
    :vartype event_data_id: str
    :ivar correlation_id: the correlation Id, usually a GUID in the string format. The correlation
     Id is shared among the events that belong to the same uber operation.
    :vartype correlation_id: str
    :ivar event_name: the event name. This value should not be confused with OperationName. For
     practical purposes, OperationName might be more appealing to end users.
    :vartype event_name: ~azure.mgmt.monitor.models.LocalizableString
    :ivar category: the event category.
    :vartype category: ~azure.mgmt.monitor.models.LocalizableString
    :ivar http_request: the HTTP request info. Usually includes the 'clientRequestId',
     'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method
     e.g. PUT).
    :vartype http_request: ~azure.mgmt.monitor.models.HttpRequestInfo
    :ivar level: the event level. Known values are: "Critical", "Error", "Warning",
     "Informational", and "Verbose".
    :vartype level: str or ~azure.mgmt.monitor.models.EventLevel
    :ivar resource_group_name: the resource group name of the impacted resource.
    :vartype resource_group_name: str
    :ivar resource_provider_name: the resource provider name of the impacted resource.
    :vartype resource_provider_name: ~azure.mgmt.monitor.models.LocalizableString
    :ivar resource_id: the resource uri that uniquely identifies the resource that caused this
     event.
    :vartype resource_id: str
    :ivar resource_type: the resource type.
    :vartype resource_type: ~azure.mgmt.monitor.models.LocalizableString
    :ivar operation_id: It is usually a GUID shared among the events corresponding to single
     operation. This value should not be confused with EventName.
    :vartype operation_id: str
    :ivar operation_name: the operation name.
    :vartype operation_name: ~azure.mgmt.monitor.models.LocalizableString
    :ivar properties: the set of <Key, Value> pairs (usually a Dictionary<String, String>) that
     includes details about the event.
    :vartype properties: dict[str, str]
    :ivar status: a string describing the status of the operation. Some typical values are:
     Started, In progress, Succeeded, Failed, Resolved.
    :vartype status: ~azure.mgmt.monitor.models.LocalizableString
    :ivar sub_status: the event sub status. Most of the time, when included, this captures the HTTP
     status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP
     Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad
     Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code:
     409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status
     Code:503), Gateway Timeout (HTTP Status Code: 504).
    :vartype sub_status: ~azure.mgmt.monitor.models.LocalizableString
    :ivar event_timestamp: the timestamp of when the event was generated by the Azure service
     processing the request corresponding the event. It in ISO 8601 format.
    :vartype event_timestamp: ~datetime.datetime
    :ivar submission_timestamp: the timestamp of when the event became available for querying via
     this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there
     might be a delay between the occurrence time of the event, and the time that the event is
     submitted to the Azure logging infrastructure.
    :vartype submission_timestamp: ~datetime.datetime
    :ivar subscription_id: the Azure subscription Id usually a GUID.
    :vartype subscription_id: str
    :ivar tenant_id: the Azure tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        "authorization": {"readonly": True},
        "claims": {"readonly": True},
        "caller": {"readonly": True},
        "description": {"readonly": True},
        "id": {"readonly": True},
        "event_data_id": {"readonly": True},
        "correlation_id": {"readonly": True},
        "event_name": {"readonly": True},
        "category": {"readonly": True},
        "http_request": {"readonly": True},
        "level": {"readonly": True},
        "resource_group_name": {"readonly": True},
        "resource_provider_name": {"readonly": True},
        "resource_id": {"readonly": True},
        "resource_type": {"readonly": True},
        "operation_id": {"readonly": True},
        "operation_name": {"readonly": True},
        "properties": {"readonly": True},
        "status": {"readonly": True},
        "sub_status": {"readonly": True},
        "event_timestamp": {"readonly": True},
        "submission_timestamp": {"readonly": True},
        "subscription_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "authorization": {"key": "authorization", "type": "SenderAuthorization"},
        "claims": {"key": "claims", "type": "{str}"},
        "caller": {"key": "caller", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "event_data_id": {"key": "eventDataId", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "event_name": {"key": "eventName", "type": "LocalizableString"},
        "category": {"key": "category", "type": "LocalizableString"},
        "http_request": {"key": "httpRequest", "type": "HttpRequestInfo"},
        "level": {"key": "level", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "resource_provider_name": {"key": "resourceProviderName", "type": "LocalizableString"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "LocalizableString"},
        "operation_id": {"key": "operationId", "type": "str"},
        "operation_name": {"key": "operationName", "type": "LocalizableString"},
        "properties": {"key": "properties", "type": "{str}"},
        "status": {"key": "status", "type": "LocalizableString"},
        "sub_status": {"key": "subStatus", "type": "LocalizableString"},
        "event_timestamp": {"key": "eventTimestamp", "type": "iso-8601"},
        "submission_timestamp": {"key": "submissionTimestamp", "type": "iso-8601"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:  # pylint: disable=too-many-locals
        """ """
        super().__init__(**kwargs)
        self.authorization: Optional["_models.SenderAuthorization"] = None
        self.claims: Optional[dict[str, str]] = None
        self.caller: Optional[str] = None
        self.description: Optional[str] = None
        self.id: Optional[str] = None
        self.event_data_id: Optional[str] = None
        self.correlation_id: Optional[str] = None
        self.event_name: Optional["_models.LocalizableString"] = None
        self.category: Optional["_models.LocalizableString"] = None
        self.http_request: Optional["_models.HttpRequestInfo"] = None
        self.level: Optional[Union[str, "_models.EventLevel"]] = None
        self.resource_group_name: Optional[str] = None
        self.resource_provider_name: Optional["_models.LocalizableString"] = None
        self.resource_id: Optional[str] = None
        self.resource_type: Optional["_models.LocalizableString"] = None
        self.operation_id: Optional[str] = None
        self.operation_name: Optional["_models.LocalizableString"] = None
        self.properties: Optional[dict[str, str]] = None
        self.status: Optional["_models.LocalizableString"] = None
        self.sub_status: Optional["_models.LocalizableString"] = None
        self.event_timestamp: Optional[datetime.datetime] = None
        self.submission_timestamp: Optional[datetime.datetime] = None
        self.subscription_id: Optional[str] = None
        self.tenant_id: Optional[str] = None


class EventDataCollection(_serialization.Model):
    """Represents collection of events.

    All required parameters must be populated in order to send to server.

    :ivar value: this list that includes the Azure audit logs. Required.
    :vartype value: list[~azure.mgmt.monitor.models.EventData]
    :ivar next_link: Provides the link to retrieve the next set of events.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EventData]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.EventData"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: this list that includes the Azure audit logs. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.EventData]
        :keyword next_link: Provides the link to retrieve the next set of events.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventHubDestination(_serialization.Model):
    """EventHubDestination.

    :ivar event_hub_resource_id: The resource ID of the event hub.
    :vartype event_hub_resource_id: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "event_hub_resource_id": {"key": "eventHubResourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, event_hub_resource_id: Optional[str] = None, name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword event_hub_resource_id: The resource ID of the event hub.
        :paramtype event_hub_resource_id: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.event_hub_resource_id = event_hub_resource_id
        self.name = name


class EventHubDirectDestination(_serialization.Model):
    """EventHubDirectDestination.

    :ivar event_hub_resource_id: The resource ID of the event hub.
    :vartype event_hub_resource_id: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "event_hub_resource_id": {"key": "eventHubResourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, event_hub_resource_id: Optional[str] = None, name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword event_hub_resource_id: The resource ID of the event hub.
        :paramtype event_hub_resource_id: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.event_hub_resource_id = event_hub_resource_id
        self.name = name


class EventHubReceiver(_serialization.Model):
    """An Event hub receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the Event hub receiver. Names must be unique across all receivers
     within an action group. Required.
    :vartype name: str
    :ivar event_hub_name_space: The Event Hub namespace. Required.
    :vartype event_hub_name_space: str
    :ivar event_hub_name: The name of the specific Event Hub queue. Required.
    :vartype event_hub_name: str
    :ivar use_common_alert_schema: Indicates whether to use common alert schema.
    :vartype use_common_alert_schema: bool
    :ivar tenant_id: The tenant Id for the subscription containing this event hub.
    :vartype tenant_id: str
    :ivar subscription_id: The Id for the subscription containing this event hub. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "name": {"required": True},
        "event_hub_name_space": {"required": True},
        "event_hub_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "event_hub_name_space": {"key": "eventHubNameSpace", "type": "str"},
        "event_hub_name": {"key": "eventHubName", "type": "str"},
        "use_common_alert_schema": {"key": "useCommonAlertSchema", "type": "bool"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        event_hub_name_space: str,
        event_hub_name: str,
        subscription_id: str,
        use_common_alert_schema: bool = False,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the Event hub receiver. Names must be unique across all receivers
         within an action group. Required.
        :paramtype name: str
        :keyword event_hub_name_space: The Event Hub namespace. Required.
        :paramtype event_hub_name_space: str
        :keyword event_hub_name: The name of the specific Event Hub queue. Required.
        :paramtype event_hub_name: str
        :keyword use_common_alert_schema: Indicates whether to use common alert schema.
        :paramtype use_common_alert_schema: bool
        :keyword tenant_id: The tenant Id for the subscription containing this event hub.
        :paramtype tenant_id: str
        :keyword subscription_id: The Id for the subscription containing this event hub. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.event_hub_name_space = event_hub_name_space
        self.event_hub_name = event_hub_name
        self.use_common_alert_schema = use_common_alert_schema
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id


class EventLogConfiguration(_serialization.Model):
    """EventLogConfiguration.

    All required parameters must be populated in order to send to server.

    :ivar log_name: Required.
    :vartype log_name: str
    :ivar filter:
    :vartype filter: str
    """

    _validation = {
        "log_name": {"required": True},
    }

    _attribute_map = {
        "log_name": {"key": "logName", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
    }

    def __init__(
        self, *, log_name: str, filter: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword log_name: Required.
        :paramtype log_name: str
        :keyword filter:
        :paramtype filter: str
        """
        super().__init__(**kwargs)
        self.log_name = log_name
        self.filter = filter


class ExtensionDataSource(_serialization.Model):
    """Definition of which data will be collected from a separate VM extension that integrates with
    the Azure Monitor Agent.
    Collected from either Windows and Linux machines, depending on which extension is defined.

    All required parameters must be populated in order to send to server.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or ~azure.mgmt.monitor.models.KnownExtensionDataSourceStreams]
    :ivar extension_name: The name of the VM extension. Required.
    :vartype extension_name: str
    :ivar extension_settings: The extension settings. The format is specific for particular
     extension.
    :vartype extension_settings: JSON
    :ivar input_data_sources: The list of data sources this extension needs data from.
    :vartype input_data_sources: list[str]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "extension_name": {"required": True},
    }

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "extension_name": {"key": "extensionName", "type": "str"},
        "extension_settings": {"key": "extensionSettings", "type": "object"},
        "input_data_sources": {"key": "inputDataSources", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        extension_name: str,
        streams: Optional[list[Union[str, "_models.KnownExtensionDataSourceStreams"]]] = None,
        extension_settings: Optional[JSON] = None,
        input_data_sources: Optional[list[str]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or ~azure.mgmt.monitor.models.KnownExtensionDataSourceStreams]
        :keyword extension_name: The name of the VM extension. Required.
        :paramtype extension_name: str
        :keyword extension_settings: The extension settings. The format is specific for particular
         extension.
        :paramtype extension_settings: JSON
        :keyword input_data_sources: The list of data sources this extension needs data from.
        :paramtype input_data_sources: list[str]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.extension_name = extension_name
        self.extension_settings = extension_settings
        self.input_data_sources = input_data_sources
        self.name = name


class GuestDiagnosticSettingsAssociationList(_serialization.Model):
    """A list of guest diagnostic settings association.

    :ivar value: The list of guest diagnostic settings association.
    :vartype value: list[~azure.mgmt.monitor.models.GuestDiagnosticSettingsAssociationResource]
    :ivar next_link: Provides the link to retrieve the next set of elements.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GuestDiagnosticSettingsAssociationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.GuestDiagnosticSettingsAssociationResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of guest diagnostic settings association.
        :paramtype value: list[~azure.mgmt.monitor.models.GuestDiagnosticSettingsAssociationResource]
        :keyword next_link: Provides the link to retrieve the next set of elements.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceAutoGenerated3(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class GuestDiagnosticSettingsAssociationResource(ResourceAutoGenerated3):  # pylint: disable=name-too-long
    """Virtual machine guest diagnostic settings resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar guest_diagnostic_settings_name: The guest diagnostic settings name. Required.
    :vartype guest_diagnostic_settings_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "guest_diagnostic_settings_name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "guest_diagnostic_settings_name": {"key": "properties.guestDiagnosticSettingsName", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        guest_diagnostic_settings_name: str,
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword guest_diagnostic_settings_name: The guest diagnostic settings name. Required.
        :paramtype guest_diagnostic_settings_name: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.guest_diagnostic_settings_name = guest_diagnostic_settings_name


class GuestDiagnosticSettingsAssociationResourcePatch(_serialization.Model):  # pylint: disable=name-too-long
    """Guest diagnostic setting resource for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar guest_diagnostic_settings_name: The guest diagnostic settings name.
    :vartype guest_diagnostic_settings_name: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "guest_diagnostic_settings_name": {"key": "properties.guestDiagnosticSettingsName", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        guest_diagnostic_settings_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword guest_diagnostic_settings_name: The guest diagnostic settings name.
        :paramtype guest_diagnostic_settings_name: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.guest_diagnostic_settings_name = guest_diagnostic_settings_name


class GuestDiagnosticSettingsList(_serialization.Model):
    """A list of guest diagnostic settings.

    :ivar value: The list of guest diagnostic settings.
    :vartype value: list[~azure.mgmt.monitor.models.GuestDiagnosticSettingsResource]
    :ivar next_link: Provides the link to retrieve the next set of elements.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GuestDiagnosticSettingsResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.GuestDiagnosticSettingsResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of guest diagnostic settings.
        :paramtype value: list[~azure.mgmt.monitor.models.GuestDiagnosticSettingsResource]
        :keyword next_link: Provides the link to retrieve the next set of elements.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GuestDiagnosticSettingsPatchResource(_serialization.Model):
    """An diagnostic settings object for the body of patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar os_type: Operating system type for the configuration. Known values are: "Windows" and
     "Linux".
    :vartype os_type: str or ~azure.mgmt.monitor.models.GuestDiagnosticSettingsOsType
    :ivar data_sources: the array of data source object which are configured to collect and send
     data.
    :vartype data_sources: list[~azure.mgmt.monitor.models.DataSource]
    :ivar proxy_setting:
    :vartype proxy_setting: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "data_sources": {"key": "properties.dataSources", "type": "[DataSource]"},
        "proxy_setting": {"key": "properties.proxySetting", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        os_type: Optional[Union[str, "_models.GuestDiagnosticSettingsOsType"]] = None,
        data_sources: Optional[list["_models.DataSource"]] = None,
        proxy_setting: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword os_type: Operating system type for the configuration. Known values are: "Windows" and
         "Linux".
        :paramtype os_type: str or ~azure.mgmt.monitor.models.GuestDiagnosticSettingsOsType
        :keyword data_sources: the array of data source object which are configured to collect and send
         data.
        :paramtype data_sources: list[~azure.mgmt.monitor.models.DataSource]
        :keyword proxy_setting:
        :paramtype proxy_setting: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.os_type = os_type
        self.data_sources = data_sources
        self.proxy_setting = proxy_setting


class ResourceAutoGenerated2(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class GuestDiagnosticSettingsResource(ResourceAutoGenerated2):
    """Virtual machine guest diagnostics settings resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar os_type: Operating system type for the configuration. Known values are: "Windows" and
     "Linux".
    :vartype os_type: str or ~azure.mgmt.monitor.models.GuestDiagnosticSettingsOsType
    :ivar data_sources: the array of data source object which are configured to collect and send
     data.
    :vartype data_sources: list[~azure.mgmt.monitor.models.DataSource]
    :ivar proxy_setting:
    :vartype proxy_setting: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "data_sources": {"key": "properties.dataSources", "type": "[DataSource]"},
        "proxy_setting": {"key": "properties.proxySetting", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        os_type: Optional[Union[str, "_models.GuestDiagnosticSettingsOsType"]] = None,
        data_sources: Optional[list["_models.DataSource"]] = None,
        proxy_setting: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword os_type: Operating system type for the configuration. Known values are: "Windows" and
         "Linux".
        :paramtype os_type: str or ~azure.mgmt.monitor.models.GuestDiagnosticSettingsOsType
        :keyword data_sources: the array of data source object which are configured to collect and send
         data.
        :paramtype data_sources: list[~azure.mgmt.monitor.models.DataSource]
        :keyword proxy_setting:
        :paramtype proxy_setting: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.os_type = os_type
        self.data_sources = data_sources
        self.proxy_setting = proxy_setting


class HttpRequestInfo(_serialization.Model):
    """The Http request info.

    :ivar client_request_id: the client request id.
    :vartype client_request_id: str
    :ivar client_ip_address: the client Ip Address.
    :vartype client_ip_address: str
    :ivar method: the Http request method.
    :vartype method: str
    :ivar uri: the Uri.
    :vartype uri: str
    """

    _attribute_map = {
        "client_request_id": {"key": "clientRequestId", "type": "str"},
        "client_ip_address": {"key": "clientIpAddress", "type": "str"},
        "method": {"key": "method", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_request_id: Optional[str] = None,
        client_ip_address: Optional[str] = None,
        method: Optional[str] = None,
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_request_id: the client request id.
        :paramtype client_request_id: str
        :keyword client_ip_address: the client Ip Address.
        :paramtype client_ip_address: str
        :keyword method: the Http request method.
        :paramtype method: str
        :keyword uri: the Uri.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.client_request_id = client_request_id
        self.client_ip_address = client_ip_address
        self.method = method
        self.uri = uri


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity. Previously undocumented values might be returned.
     Required. Known values are: "SystemAssigned", "UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.monitor.models.IdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be Azure resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.monitor.models.UserIdentityProperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityProperties}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserIdentityProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Previously undocumented values might be
         returned. Required. Known values are: "SystemAssigned", "UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.monitor.models.IdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be Azure resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.monitor.models.UserIdentityProperties]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class IdentityAutoGenerated(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity. Required. Known values are: "SystemAssigned",
     "UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.monitor.models.IdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.monitor.models.UserIdentityPropertiesAutoGenerated]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityPropertiesAutoGenerated}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserIdentityPropertiesAutoGenerated"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Required. Known values are: "SystemAssigned",
         "UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.monitor.models.IdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.monitor.models.UserIdentityPropertiesAutoGenerated]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class IisLogsDataSource(_serialization.Model):
    """Enables IIS logs to be collected by this data collection rule.

    All required parameters must be populated in order to send to server.

    :ivar streams: IIS streams. Required.
    :vartype streams: list[str]
    :ivar log_directories: Absolute paths file location.
    :vartype log_directories: list[str]
    :ivar transform_kql: The KQL query to transform the data source.
    :vartype transform_kql: str
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "streams": {"required": True},
    }

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "log_directories": {"key": "logDirectories", "type": "[str]"},
        "transform_kql": {"key": "transformKql", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: list[str],
        log_directories: Optional[list[str]] = None,
        transform_kql: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: IIS streams. Required.
        :paramtype streams: list[str]
        :keyword log_directories: Absolute paths file location.
        :paramtype log_directories: list[str]
        :keyword transform_kql: The KQL query to transform the data source.
        :paramtype transform_kql: str
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.log_directories = log_directories
        self.transform_kql = transform_kql
        self.name = name


class Incident(_serialization.Model):
    """An alert incident indicates the activation status of an alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Incident name.
    :vartype name: str
    :ivar rule_name: Rule name that is associated with the incident.
    :vartype rule_name: str
    :ivar is_active: A boolean to indicate whether the incident is active or resolved.
    :vartype is_active: bool
    :ivar activated_time: The time at which the incident was activated in ISO8601 format.
    :vartype activated_time: ~datetime.datetime
    :ivar resolved_time: The time at which the incident was resolved in ISO8601 format. If null, it
     means the incident is still active.
    :vartype resolved_time: ~datetime.datetime
    """

    _validation = {
        "name": {"readonly": True},
        "rule_name": {"readonly": True},
        "is_active": {"readonly": True},
        "activated_time": {"readonly": True},
        "resolved_time": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "rule_name": {"key": "ruleName", "type": "str"},
        "is_active": {"key": "isActive", "type": "bool"},
        "activated_time": {"key": "activatedTime", "type": "iso-8601"},
        "resolved_time": {"key": "resolvedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.rule_name: Optional[str] = None
        self.is_active: Optional[bool] = None
        self.activated_time: Optional[datetime.datetime] = None
        self.resolved_time: Optional[datetime.datetime] = None


class IncidentListResult(_serialization.Model):
    """The List incidents operation response.

    :ivar value: the incident collection.
    :vartype value: list[~azure.mgmt.monitor.models.Incident]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Incident]"},
    }

    def __init__(self, *, value: Optional[list["_models.Incident"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: the incident collection.
        :paramtype value: list[~azure.mgmt.monitor.models.Incident]
        """
        super().__init__(**kwargs)
        self.value = value


class ItsmReceiver(_serialization.Model):
    """An Itsm receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the Itsm receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar workspace_id: OMS LA instance identifier. Required.
    :vartype workspace_id: str
    :ivar connection_id: Unique identification of ITSM connection among multiple defined in above
     workspace. Required.
    :vartype connection_id: str
    :ivar ticket_configuration: JSON blob for the configurations of the ITSM action.
     CreateMultipleWorkItems option will be part of this blob as well. Required.
    :vartype ticket_configuration: str
    :ivar region: Region in which workspace resides. Supported
     values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
     Required.
    :vartype region: str
    """

    _validation = {
        "name": {"required": True},
        "workspace_id": {"required": True},
        "connection_id": {"required": True},
        "ticket_configuration": {"required": True},
        "region": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "connection_id": {"key": "connectionId", "type": "str"},
        "ticket_configuration": {"key": "ticketConfiguration", "type": "str"},
        "region": {"key": "region", "type": "str"},
    }

    def __init__(
        self, *, name: str, workspace_id: str, connection_id: str, ticket_configuration: str, region: str, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the Itsm receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword workspace_id: OMS LA instance identifier. Required.
        :paramtype workspace_id: str
        :keyword connection_id: Unique identification of ITSM connection among multiple defined in
         above workspace. Required.
        :paramtype connection_id: str
        :keyword ticket_configuration: JSON blob for the configurations of the ITSM action.
         CreateMultipleWorkItems option will be part of this blob as well. Required.
        :paramtype ticket_configuration: str
        :keyword region: Region in which workspace resides. Supported
         values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
         Required.
        :paramtype region: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.workspace_id = workspace_id
        self.connection_id = connection_id
        self.ticket_configuration = ticket_configuration
        self.region = region


class LocalizableString(_serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to server.

    :ivar value: the invariant value. Required.
    :vartype value: str
    :ivar localized_value: the locale specific value.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: str, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: the invariant value. Required.
        :paramtype value: str
        :keyword localized_value: the locale specific value.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LocalizableStringAutoGenerated(_serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to server.

    :ivar value: The invariant value. Required.
    :vartype value: str
    :ivar localized_value: The display name.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: str, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The invariant value. Required.
        :paramtype value: str
        :keyword localized_value: The display name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LocationSpec(_serialization.Model):
    """LocationSpec.

    :ivar location: Name of location.
    :vartype location: str
    :ivar provisioning_status: The resource provisioning state in this location. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_status: str or
     ~azure.mgmt.monitor.models.KnownLocationSpecProvisioningStatus
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        provisioning_status: Optional[Union[str, "_models.KnownLocationSpecProvisioningStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Name of location.
        :paramtype location: str
        :keyword provisioning_status: The resource provisioning state in this location. Known values
         are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_status: str or
         ~azure.mgmt.monitor.models.KnownLocationSpecProvisioningStatus
        """
        super().__init__(**kwargs)
        self.location = location
        self.provisioning_status = provisioning_status


class LogAnalyticsDestination(_serialization.Model):
    """Log Analytics destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar workspace_resource_id: The resource ID of the Log Analytics workspace.
    :vartype workspace_resource_id: str
    :ivar workspace_id: The Customer ID of the Log Analytics workspace.
    :vartype workspace_id: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "workspace_id": {"readonly": True},
    }

    _attribute_map = {
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, workspace_resource_id: Optional[str] = None, name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword workspace_resource_id: The resource ID of the Log Analytics workspace.
        :paramtype workspace_resource_id: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.workspace_resource_id = workspace_resource_id
        self.workspace_id: Optional[str] = None
        self.name = name


class LogFilesDataSource(_serialization.Model):
    """Definition of which custom log files will be collected by this data collection rule.

    All required parameters must be populated in order to send to server.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data source. Required.
    :vartype streams: list[str]
    :ivar file_patterns: File Patterns where the log files are located. Required.
    :vartype file_patterns: list[str]
    :ivar format: The data format of the log files. Required. Known values are: "json" and "text".
    :vartype format: str or ~azure.mgmt.monitor.models.KnownLogFilesDataSourceFormat
    :ivar settings: The log files specific settings.
    :vartype settings: ~azure.mgmt.monitor.models.LogFilesDataSourceSettings
    :ivar transform_kql: The KQL query to transform the data source.
    :vartype transform_kql: str
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "streams": {"required": True},
        "file_patterns": {"required": True},
        "format": {"required": True},
    }

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "file_patterns": {"key": "filePatterns", "type": "[str]"},
        "format": {"key": "format", "type": "str"},
        "settings": {"key": "settings", "type": "LogFilesDataSourceSettings"},
        "transform_kql": {"key": "transformKql", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: list[str],
        file_patterns: list[str],
        format: Union[str, "_models.KnownLogFilesDataSourceFormat"],
        settings: Optional["_models.LogFilesDataSourceSettings"] = None,
        transform_kql: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data source. Required.
        :paramtype streams: list[str]
        :keyword file_patterns: File Patterns where the log files are located. Required.
        :paramtype file_patterns: list[str]
        :keyword format: The data format of the log files. Required. Known values are: "json" and
         "text".
        :paramtype format: str or ~azure.mgmt.monitor.models.KnownLogFilesDataSourceFormat
        :keyword settings: The log files specific settings.
        :paramtype settings: ~azure.mgmt.monitor.models.LogFilesDataSourceSettings
        :keyword transform_kql: The KQL query to transform the data source.
        :paramtype transform_kql: str
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.file_patterns = file_patterns
        self.format = format
        self.settings = settings
        self.transform_kql = transform_kql
        self.name = name


class LogFileSettings(_serialization.Model):
    """Settings for different log file formats.

    :ivar text: Text settings.
    :vartype text: ~azure.mgmt.monitor.models.LogFileSettingsText
    """

    _attribute_map = {
        "text": {"key": "text", "type": "LogFileSettingsText"},
    }

    def __init__(self, *, text: Optional["_models.LogFileSettingsText"] = None, **kwargs: Any) -> None:
        """
        :keyword text: Text settings.
        :paramtype text: ~azure.mgmt.monitor.models.LogFileSettingsText
        """
        super().__init__(**kwargs)
        self.text = text


class LogFilesDataSourceSettings(LogFileSettings):
    """The log files specific settings.

    :ivar text: Text settings.
    :vartype text: ~azure.mgmt.monitor.models.LogFileSettingsText
    """


class LogFileTextSettings(_serialization.Model):
    """Settings for text log files.

    All required parameters must be populated in order to send to server.

    :ivar record_start_timestamp_format: One of the supported timestamp formats. Required. Known
     values are: "ISO 8601", "YYYY-MM-DD HH:MM:SS", "M/D/YYYY HH:MM:SS AM/PM", "Mon DD, YYYY
     HH:MM:SS", "yyMMdd HH:mm:ss", "ddMMyy HH:mm:ss", "MMM d hh:mm:ss", "dd/MMM/yyyy:HH:mm:ss zzz",
     and "yyyy-MM-ddTHH:mm:ssK".
    :vartype record_start_timestamp_format: str or
     ~azure.mgmt.monitor.models.KnownLogFileTextSettingsRecordStartTimestampFormat
    """

    _validation = {
        "record_start_timestamp_format": {"required": True},
    }

    _attribute_map = {
        "record_start_timestamp_format": {"key": "recordStartTimestampFormat", "type": "str"},
    }

    def __init__(
        self,
        *,
        record_start_timestamp_format: Union[str, "_models.KnownLogFileTextSettingsRecordStartTimestampFormat"],
        **kwargs: Any
    ) -> None:
        """
        :keyword record_start_timestamp_format: One of the supported timestamp formats. Required. Known
         values are: "ISO 8601", "YYYY-MM-DD HH:MM:SS", "M/D/YYYY HH:MM:SS AM/PM", "Mon DD, YYYY
         HH:MM:SS", "yyMMdd HH:mm:ss", "ddMMyy HH:mm:ss", "MMM d hh:mm:ss", "dd/MMM/yyyy:HH:mm:ss zzz",
         and "yyyy-MM-ddTHH:mm:ssK".
        :paramtype record_start_timestamp_format: str or
         ~azure.mgmt.monitor.models.KnownLogFileTextSettingsRecordStartTimestampFormat
        """
        super().__init__(**kwargs)
        self.record_start_timestamp_format = record_start_timestamp_format


class LogFileSettingsText(LogFileTextSettings):
    """Text settings.

    All required parameters must be populated in order to send to server.

    :ivar record_start_timestamp_format: One of the supported timestamp formats. Required. Known
     values are: "ISO 8601", "YYYY-MM-DD HH:MM:SS", "M/D/YYYY HH:MM:SS AM/PM", "Mon DD, YYYY
     HH:MM:SS", "yyMMdd HH:mm:ss", "ddMMyy HH:mm:ss", "MMM d hh:mm:ss", "dd/MMM/yyyy:HH:mm:ss zzz",
     and "yyyy-MM-ddTHH:mm:ssK".
    :vartype record_start_timestamp_format: str or
     ~azure.mgmt.monitor.models.KnownLogFileTextSettingsRecordStartTimestampFormat
    """


class LogicAppReceiver(_serialization.Model):
    """A logic app receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the logic app receiver. Names must be unique across all receivers
     within an action group. Required.
    :vartype name: str
    :ivar resource_id: The azure resource id of the logic app receiver. Required.
    :vartype resource_id: str
    :ivar callback_url: The callback url where http request sent to. Required.
    :vartype callback_url: str
    :ivar use_common_alert_schema: Indicates whether to use common alert schema.
    :vartype use_common_alert_schema: bool
    """

    _validation = {
        "name": {"required": True},
        "resource_id": {"required": True},
        "callback_url": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "callback_url": {"key": "callbackUrl", "type": "str"},
        "use_common_alert_schema": {"key": "useCommonAlertSchema", "type": "bool"},
    }

    def __init__(
        self, *, name: str, resource_id: str, callback_url: str, use_common_alert_schema: bool = False, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the logic app receiver. Names must be unique across all receivers
         within an action group. Required.
        :paramtype name: str
        :keyword resource_id: The azure resource id of the logic app receiver. Required.
        :paramtype resource_id: str
        :keyword callback_url: The callback url where http request sent to. Required.
        :paramtype callback_url: str
        :keyword use_common_alert_schema: Indicates whether to use common alert schema.
        :paramtype use_common_alert_schema: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.resource_id = resource_id
        self.callback_url = callback_url
        self.use_common_alert_schema = use_common_alert_schema


class LogProfileCollection(_serialization.Model):
    """Represents a collection of log profiles.

    All required parameters must be populated in order to send to server.

    :ivar value: the values of the log profiles. Required.
    :vartype value: list[~azure.mgmt.monitor.models.LogProfileResource]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LogProfileResource]"},
    }

    def __init__(self, *, value: list["_models.LogProfileResource"], **kwargs: Any) -> None:
        """
        :keyword value: the values of the log profiles. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.LogProfileResource]
        """
        super().__init__(**kwargs)
        self.value = value


class ResourceAutoGenerated4(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class LogProfileResource(ResourceAutoGenerated4):
    """The log profile resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar storage_account_id: the resource id of the storage account to which you would like to
     send the Activity Log.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
     would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the
     format: '{service bus resource ID}/authorizationrules/{key name}'.
    :vartype service_bus_rule_id: str
    :ivar locations: List of regions for which Activity Log events should be stored or streamed. It
     is a comma separated list of valid ARM locations including the 'global' location. Required.
    :vartype locations: list[str]
    :ivar categories: the categories of the logs. These categories are created as is convenient to
     the user. Some values are: 'Write', 'Delete', and/or 'Action.'. Required.
    :vartype categories: list[str]
    :ivar retention_policy: the retention policy for the events in the log. Required.
    :vartype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "locations": {"required": True},
        "categories": {"required": True},
        "retention_policy": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "service_bus_rule_id": {"key": "properties.serviceBusRuleId", "type": "str"},
        "locations": {"key": "properties.locations", "type": "[str]"},
        "categories": {"key": "properties.categories", "type": "[str]"},
        "retention_policy": {"key": "properties.retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        location: str,
        locations: list[str],
        categories: list[str],
        retention_policy: "_models.RetentionPolicy",
        tags: Optional[dict[str, str]] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword storage_account_id: the resource id of the storage account to which you would like to
         send the Activity Log.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
         would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the
         format: '{service bus resource ID}/authorizationrules/{key name}'.
        :paramtype service_bus_rule_id: str
        :keyword locations: List of regions for which Activity Log events should be stored or streamed.
         It is a comma separated list of valid ARM locations including the 'global' location. Required.
        :paramtype locations: list[str]
        :keyword categories: the categories of the logs. These categories are created as is convenient
         to the user. Some values are: 'Write', 'Delete', and/or 'Action.'. Required.
        :paramtype categories: list[str]
        :keyword retention_policy: the retention policy for the events in the log. Required.
        :paramtype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.locations = locations
        self.categories = categories
        self.retention_policy = retention_policy


class LogProfileResourcePatch(_serialization.Model):
    """The log profile resource for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar storage_account_id: the resource id of the storage account to which you would like to
     send the Activity Log.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
     would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the
     format: '{service bus resource ID}/authorizationrules/{key name}'.
    :vartype service_bus_rule_id: str
    :ivar locations: List of regions for which Activity Log events should be stored or streamed. It
     is a comma separated list of valid ARM locations including the 'global' location.
    :vartype locations: list[str]
    :ivar categories: the categories of the logs. These categories are created as is convenient to
     the user. Some values are: 'Write', 'Delete', and/or 'Action.'.
    :vartype categories: list[str]
    :ivar retention_policy: the retention policy for the events in the log.
    :vartype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "service_bus_rule_id": {"key": "properties.serviceBusRuleId", "type": "str"},
        "locations": {"key": "properties.locations", "type": "[str]"},
        "categories": {"key": "properties.categories", "type": "[str]"},
        "retention_policy": {"key": "properties.retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        locations: Optional[list[str]] = None,
        categories: Optional[list[str]] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword storage_account_id: the resource id of the storage account to which you would like to
         send the Activity Log.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
         would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the
         format: '{service bus resource ID}/authorizationrules/{key name}'.
        :paramtype service_bus_rule_id: str
        :keyword locations: List of regions for which Activity Log events should be stored or streamed.
         It is a comma separated list of valid ARM locations including the 'global' location.
        :paramtype locations: list[str]
        :keyword categories: the categories of the logs. These categories are created as is convenient
         to the user. Some values are: 'Write', 'Delete', and/or 'Action.'.
        :paramtype categories: list[str]
        :keyword retention_policy: the retention policy for the events in the log.
        :paramtype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.locations = locations
        self.categories = categories
        self.retention_policy = retention_policy


class LogSettings(_serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to server.

    :ivar category: Name of a Diagnostic Log category for a resource type this setting is applied
     to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
     diagnostic settings operation.
    :vartype category: str
    :ivar category_group: Name of a Diagnostic Log category group for a resource type this setting
     is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a
     GET diagnostic settings operation.
    :vartype category_group: str
    :ivar enabled: a value indicating whether this log is enabled. Required.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this log.
    :vartype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "category_group": {"key": "categoryGroup", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        category: Optional[str] = None,
        category_group: Optional[str] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Name of a Diagnostic Log category for a resource type this setting is
         applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
         diagnostic settings operation.
        :paramtype category: str
        :keyword category_group: Name of a Diagnostic Log category group for a resource type this
         setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first
         perform a GET diagnostic settings operation.
        :paramtype category_group: str
        :keyword enabled: a value indicating whether this log is enabled. Required.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this log.
        :paramtype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.category = category
        self.category_group = category_group
        self.enabled = enabled
        self.retention_policy = retention_policy


class LogSettingsAutoGenerated(_serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to server.

    :ivar category: Name of a Diagnostic Log category for a resource type this setting is applied
     to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
     diagnostic settings operation.
    :vartype category: str
    :ivar enabled: a value indicating whether this log is enabled. Required.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this log.
    :vartype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        category: Optional[str] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Name of a Diagnostic Log category for a resource type this setting is
         applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
         diagnostic settings operation.
        :paramtype category: str
        :keyword enabled: a value indicating whether this log is enabled. Required.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this log.
        :paramtype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.category = category
        self.enabled = enabled
        self.retention_policy = retention_policy


class MetadataValue(_serialization.Model):
    """Represents a metric metadata value.

    :ivar name: The name of the metadata.
    :vartype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
    :ivar value: The value of the metadata.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "LocalizableStringAutoGenerated"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional["_models.LocalizableStringAutoGenerated"] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the metadata.
        :paramtype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
        :keyword value: The value of the metadata.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class Metric(_serialization.Model):
    """The result data of a query.

    All required parameters must be populated in order to send to server.

    :ivar id: The metric Id. Required.
    :vartype id: str
    :ivar type: The resource type of the metric resource. Required.
    :vartype type: str
    :ivar name: The name and the display name of the metric, i.e. it is localizable string.
     Required.
    :vartype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar error_code: 'Success' or the error details on query failures for this metric.
    :vartype error_code: str
    :ivar error_message: Error message encountered querying this specific metric.
    :vartype error_message: str
    :ivar unit: The unit of the metric. Required. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.mgmt.monitor.models.MetricUnit
    :ivar timeseries: The time series returned when a data query is performed. Required.
    :vartype timeseries: list[~azure.mgmt.monitor.models.TimeSeriesElement]
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "name": {"required": True},
        "unit": {"required": True},
        "timeseries": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "LocalizableStringAutoGenerated"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "timeseries": {"key": "timeseries", "type": "[TimeSeriesElement]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: str,
        name: "_models.LocalizableStringAutoGenerated",
        unit: Union[str, "_models.MetricUnit"],
        timeseries: list["_models.TimeSeriesElement"],
        display_description: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The metric Id. Required.
        :paramtype id: str
        :keyword type: The resource type of the metric resource. Required.
        :paramtype type: str
        :keyword name: The name and the display name of the metric, i.e. it is localizable string.
         Required.
        :paramtype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword error_code: 'Success' or the error details on query failures for this metric.
        :paramtype error_code: str
        :keyword error_message: Error message encountered querying this specific metric.
        :paramtype error_message: str
        :keyword unit: The unit of the metric. Required. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
        :paramtype unit: str or ~azure.mgmt.monitor.models.MetricUnit
        :keyword timeseries: The time series returned when a data query is performed. Required.
        :paramtype timeseries: list[~azure.mgmt.monitor.models.TimeSeriesElement]
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.display_description = display_description
        self.error_code = error_code
        self.error_message = error_message
        self.unit = unit
        self.timeseries = timeseries


class MetricAlertAction(_serialization.Model):
    """An alert action.

    :ivar action_group_id: The id of the action group to use.
    :vartype action_group_id: str
    :ivar web_hook_properties: This field allows specifying custom properties, which would be
     appended to the alert payload sent as input to the webhook.
    :vartype web_hook_properties: dict[str, str]
    """

    _attribute_map = {
        "action_group_id": {"key": "actionGroupId", "type": "str"},
        "web_hook_properties": {"key": "webHookProperties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        action_group_id: Optional[str] = None,
        web_hook_properties: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_group_id: The id of the action group to use.
        :paramtype action_group_id: str
        :keyword web_hook_properties: This field allows specifying custom properties, which would be
         appended to the alert payload sent as input to the webhook.
        :paramtype web_hook_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.action_group_id = action_group_id
        self.web_hook_properties = web_hook_properties


class MetricAlertCriteria(_serialization.Model):
    """The rule criteria that defines the conditions of the alert rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MetricAlertMultipleResourceMultipleMetricCriteria, PromQLCriteria,
    MetricAlertSingleResourceMultipleMetricCriteria, WebtestLocationAvailabilityCriteria

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: Specifies the type of the alert criteria. Previously undocumented values
     might be returned. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria", and
     "Microsoft.Azure.Monitor.PromQLCriteria".
    :vartype odata_type: str or ~azure.mgmt.monitor.models.Odatatype
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria": "MetricAlertMultipleResourceMultipleMetricCriteria",
            "Microsoft.Azure.Monitor.PromQLCriteria": "PromQLCriteria",
            "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria": "MetricAlertSingleResourceMultipleMetricCriteria",
            "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria": "WebtestLocationAvailabilityCriteria",
        }
    }

    def __init__(self, *, additional_properties: Optional[dict[str, JSON]] = None, **kwargs: Any) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.odata_type: Optional[str] = None


class MetricAlertMultipleResourceMultipleMetricCriteria(MetricAlertCriteria):  # pylint: disable=name-too-long
    """Specifies the metric alert criteria for multiple resource that has multiple metric criteria.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: Specifies the type of the alert criteria. Previously undocumented values
     might be returned. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria", and
     "Microsoft.Azure.Monitor.PromQLCriteria".
    :vartype odata_type: str or ~azure.mgmt.monitor.models.Odatatype
    :ivar all_of: The list of multiple metric criteria for this 'all of' operation.
    :vartype all_of: list[~azure.mgmt.monitor.models.MultiMetricCriteria]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "all_of": {"key": "allOf", "type": "[MultiMetricCriteria]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[dict[str, JSON]] = None,
        all_of: Optional[list["_models.MultiMetricCriteria"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword all_of: The list of multiple metric criteria for this 'all of' operation.
        :paramtype all_of: list[~azure.mgmt.monitor.models.MultiMetricCriteria]
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria"
        self.all_of = all_of


class ResourceAutoGenerated5(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.models.Identity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.models.Identity
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags
        self.identity = identity


class MetricAlertResource(ResourceAutoGenerated5):
    """The metric alert resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.models.Identity
    :ivar description: The description of the metric alert that will be included in the alert
     email.
    :vartype description: str
    :ivar severity: Alert severity {0, 1, 2, 3, 4}. Required.
    :vartype severity: int
    :ivar enabled: The flag that indicates whether the metric alert is enabled. Required.
    :vartype enabled: bool
    :ivar scopes: The list of resource id's that this metric alert is scoped to. You cannot change
     the scope of a metric rule based on logs. Required.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: How often the metric alert is evaluated represented in ISO 8601
     duration format. Required.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: The period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold.
    :vartype window_size: ~datetime.timedelta
    :ivar target_resource_type: The resource type of the target resource(s) on which the alert is
     created/updated. Mandatory if the scope contains a subscription, resource group, or more than
     one resource.
    :vartype target_resource_type: str
    :ivar target_resource_region: The region of the target resource(s) on which the alert is
     created/updated. Mandatory if the scope contains a subscription, resource group, or more than
     one resource.
    :vartype target_resource_region: str
    :ivar criteria: Defines the specific alert criteria information. Required.
    :vartype criteria: ~azure.mgmt.monitor.models.MetricAlertCriteria
    :ivar auto_mitigate: The flag that indicates whether the alert should be auto resolved or not.
     The default is true.
    :vartype auto_mitigate: bool
    :ivar resolve_configuration: The configuration for how the alert is resolved. Applicable for
     PromQLCriteria.
    :vartype resolve_configuration: ~azure.mgmt.monitor.models.ResolveConfiguration
    :ivar actions: The array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~azure.mgmt.monitor.models.MetricAlertAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    :ivar is_migrated: The value indicating whether this alert rule is migrated.
    :vartype is_migrated: bool
    :ivar custom_properties: The properties of an alert payload.
    :vartype custom_properties: dict[str, str]
    :ivar action_properties: The properties of an action properties.
    :vartype action_properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "severity": {"required": True},
        "enabled": {"required": True},
        "scopes": {"required": True},
        "evaluation_frequency": {"required": True},
        "criteria": {"required": True},
        "last_updated_time": {"readonly": True},
        "is_migrated": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "description": {"key": "properties.description", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "target_resource_type": {"key": "properties.targetResourceType", "type": "str"},
        "target_resource_region": {"key": "properties.targetResourceRegion", "type": "str"},
        "criteria": {"key": "properties.criteria", "type": "MetricAlertCriteria"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "resolve_configuration": {"key": "properties.resolveConfiguration", "type": "ResolveConfiguration"},
        "actions": {"key": "properties.actions", "type": "[MetricAlertAction]"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "is_migrated": {"key": "properties.isMigrated", "type": "bool"},
        "custom_properties": {"key": "properties.customProperties", "type": "{str}"},
        "action_properties": {"key": "properties.actionProperties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: str,
        severity: int,
        enabled: bool,
        scopes: list[str],
        evaluation_frequency: datetime.timedelta,
        criteria: "_models.MetricAlertCriteria",
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        description: Optional[str] = None,
        window_size: Optional[datetime.timedelta] = None,
        target_resource_type: Optional[str] = None,
        target_resource_region: Optional[str] = None,
        auto_mitigate: Optional[bool] = None,
        resolve_configuration: Optional["_models.ResolveConfiguration"] = None,
        actions: Optional[list["_models.MetricAlertAction"]] = None,
        custom_properties: Optional[dict[str, str]] = None,
        action_properties: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.models.Identity
        :keyword description: The description of the metric alert that will be included in the alert
         email.
        :paramtype description: str
        :keyword severity: Alert severity {0, 1, 2, 3, 4}. Required.
        :paramtype severity: int
        :keyword enabled: The flag that indicates whether the metric alert is enabled. Required.
        :paramtype enabled: bool
        :keyword scopes: The list of resource id's that this metric alert is scoped to. You cannot
         change the scope of a metric rule based on logs. Required.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: How often the metric alert is evaluated represented in ISO 8601
         duration format. Required.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: The period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold.
        :paramtype window_size: ~datetime.timedelta
        :keyword target_resource_type: The resource type of the target resource(s) on which the alert
         is created/updated. Mandatory if the scope contains a subscription, resource group, or more
         than one resource.
        :paramtype target_resource_type: str
        :keyword target_resource_region: The region of the target resource(s) on which the alert is
         created/updated. Mandatory if the scope contains a subscription, resource group, or more than
         one resource.
        :paramtype target_resource_region: str
        :keyword criteria: Defines the specific alert criteria information. Required.
        :paramtype criteria: ~azure.mgmt.monitor.models.MetricAlertCriteria
        :keyword auto_mitigate: The flag that indicates whether the alert should be auto resolved or
         not. The default is true.
        :paramtype auto_mitigate: bool
        :keyword resolve_configuration: The configuration for how the alert is resolved. Applicable for
         PromQLCriteria.
        :paramtype resolve_configuration: ~azure.mgmt.monitor.models.ResolveConfiguration
        :keyword actions: The array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~azure.mgmt.monitor.models.MetricAlertAction]
        :keyword custom_properties: The properties of an alert payload.
        :paramtype custom_properties: dict[str, str]
        :keyword action_properties: The properties of an action properties.
        :paramtype action_properties: dict[str, str]
        """
        super().__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.description = description
        self.severity = severity
        self.enabled = enabled
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.target_resource_type = target_resource_type
        self.target_resource_region = target_resource_region
        self.criteria = criteria
        self.auto_mitigate = auto_mitigate
        self.resolve_configuration = resolve_configuration
        self.actions = actions
        self.last_updated_time: Optional[datetime.datetime] = None
        self.is_migrated: Optional[bool] = None
        self.custom_properties = custom_properties
        self.action_properties = action_properties


class MetricAlertResourceCollection(_serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: The values for the alert rule resources.
    :vartype value: list[~azure.mgmt.monitor.models.MetricAlertResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricAlertResource]"},
    }

    def __init__(self, *, value: Optional[list["_models.MetricAlertResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The values for the alert rule resources.
        :paramtype value: list[~azure.mgmt.monitor.models.MetricAlertResource]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricAlertResourcePatch(_serialization.Model):
    """The metric alert resource for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.models.Identity
    :ivar description: The description of the metric alert that will be included in the alert
     email.
    :vartype description: str
    :ivar severity: Alert severity {0, 1, 2, 3, 4}.
    :vartype severity: int
    :ivar enabled: The flag that indicates whether the metric alert is enabled.
    :vartype enabled: bool
    :ivar scopes: The list of resource id's that this metric alert is scoped to.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: How often the metric alert is evaluated represented in ISO 8601
     duration format.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: The period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold.
    :vartype window_size: ~datetime.timedelta
    :ivar target_resource_type: The resource type of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :vartype target_resource_type: str
    :ivar target_resource_region: The region of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :vartype target_resource_region: str
    :ivar criteria: Defines the specific alert criteria information.
    :vartype criteria: ~azure.mgmt.monitor.models.MetricAlertCriteria
    :ivar auto_mitigate: The flag that indicates whether the alert should be auto resolved or not.
     The default is true.
    :vartype auto_mitigate: bool
    :ivar resolve_configuration: The configuration for how the alert is resolved. Applicable for
     PromQLCriteria.
    :vartype resolve_configuration: ~azure.mgmt.monitor.models.ResolveConfiguration
    :ivar actions: The array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~azure.mgmt.monitor.models.MetricAlertAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    :ivar is_migrated: The value indicating whether this alert rule is migrated.
    :vartype is_migrated: bool
    :ivar custom_properties: The properties of an alert payload.
    :vartype custom_properties: dict[str, str]
    :ivar action_properties: The properties of an action properties.
    :vartype action_properties: dict[str, str]
    """

    _validation = {
        "last_updated_time": {"readonly": True},
        "is_migrated": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "description": {"key": "properties.description", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "target_resource_type": {"key": "properties.targetResourceType", "type": "str"},
        "target_resource_region": {"key": "properties.targetResourceRegion", "type": "str"},
        "criteria": {"key": "properties.criteria", "type": "MetricAlertCriteria"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "resolve_configuration": {"key": "properties.resolveConfiguration", "type": "ResolveConfiguration"},
        "actions": {"key": "properties.actions", "type": "[MetricAlertAction]"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "is_migrated": {"key": "properties.isMigrated", "type": "bool"},
        "custom_properties": {"key": "properties.customProperties", "type": "{str}"},
        "action_properties": {"key": "properties.actionProperties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        description: Optional[str] = None,
        severity: Optional[int] = None,
        enabled: Optional[bool] = None,
        scopes: Optional[list[str]] = None,
        evaluation_frequency: Optional[datetime.timedelta] = None,
        window_size: Optional[datetime.timedelta] = None,
        target_resource_type: Optional[str] = None,
        target_resource_region: Optional[str] = None,
        criteria: Optional["_models.MetricAlertCriteria"] = None,
        auto_mitigate: Optional[bool] = None,
        resolve_configuration: Optional["_models.ResolveConfiguration"] = None,
        actions: Optional[list["_models.MetricAlertAction"]] = None,
        custom_properties: Optional[dict[str, str]] = None,
        action_properties: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.models.Identity
        :keyword description: The description of the metric alert that will be included in the alert
         email.
        :paramtype description: str
        :keyword severity: Alert severity {0, 1, 2, 3, 4}.
        :paramtype severity: int
        :keyword enabled: The flag that indicates whether the metric alert is enabled.
        :paramtype enabled: bool
        :keyword scopes: The list of resource id's that this metric alert is scoped to.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: How often the metric alert is evaluated represented in ISO 8601
         duration format.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: The period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold.
        :paramtype window_size: ~datetime.timedelta
        :keyword target_resource_type: The resource type of the target resource(s) on which the alert
         is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
        :paramtype target_resource_type: str
        :keyword target_resource_region: The region of the target resource(s) on which the alert is
         created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
        :paramtype target_resource_region: str
        :keyword criteria: Defines the specific alert criteria information.
        :paramtype criteria: ~azure.mgmt.monitor.models.MetricAlertCriteria
        :keyword auto_mitigate: The flag that indicates whether the alert should be auto resolved or
         not. The default is true.
        :paramtype auto_mitigate: bool
        :keyword resolve_configuration: The configuration for how the alert is resolved. Applicable for
         PromQLCriteria.
        :paramtype resolve_configuration: ~azure.mgmt.monitor.models.ResolveConfiguration
        :keyword actions: The array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~azure.mgmt.monitor.models.MetricAlertAction]
        :keyword custom_properties: The properties of an alert payload.
        :paramtype custom_properties: dict[str, str]
        :keyword action_properties: The properties of an action properties.
        :paramtype action_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.description = description
        self.severity = severity
        self.enabled = enabled
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.target_resource_type = target_resource_type
        self.target_resource_region = target_resource_region
        self.criteria = criteria
        self.auto_mitigate = auto_mitigate
        self.resolve_configuration = resolve_configuration
        self.actions = actions
        self.last_updated_time: Optional[datetime.datetime] = None
        self.is_migrated: Optional[bool] = None
        self.custom_properties = custom_properties
        self.action_properties = action_properties


class MetricAlertSingleResourceMultipleMetricCriteria(MetricAlertCriteria):  # pylint: disable=name-too-long
    """Specifies the metric alert criteria for a single resource that has multiple metric criteria.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: Specifies the type of the alert criteria. Previously undocumented values
     might be returned. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria", and
     "Microsoft.Azure.Monitor.PromQLCriteria".
    :vartype odata_type: str or ~azure.mgmt.monitor.models.Odatatype
    :ivar all_of: The list of metric criteria for this 'all of' operation.
    :vartype all_of: list[~azure.mgmt.monitor.models.MetricCriteria]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "all_of": {"key": "allOf", "type": "[MetricCriteria]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[dict[str, JSON]] = None,
        all_of: Optional[list["_models.MetricCriteria"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword all_of: The list of metric criteria for this 'all of' operation.
        :paramtype all_of: list[~azure.mgmt.monitor.models.MetricCriteria]
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria"
        self.all_of = all_of


class MetricAlertStatus(_serialization.Model):
    """An alert status.

    :ivar name: The status name.
    :vartype name: str
    :ivar id: The alert rule arm id.
    :vartype id: str
    :ivar type: The extended resource type name.
    :vartype type: str
    :ivar properties: The alert status properties of the metric alert status.
    :vartype properties: ~azure.mgmt.monitor.models.MetricAlertStatusProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "MetricAlertStatusProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        properties: Optional["_models.MetricAlertStatusProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The status name.
        :paramtype name: str
        :keyword id: The alert rule arm id.
        :paramtype id: str
        :keyword type: The extended resource type name.
        :paramtype type: str
        :keyword properties: The alert status properties of the metric alert status.
        :paramtype properties: ~azure.mgmt.monitor.models.MetricAlertStatusProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.properties = properties


class MetricAlertStatusCollection(_serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: The values for the alert rule resources.
    :vartype value: list[~azure.mgmt.monitor.models.MetricAlertStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricAlertStatus]"},
    }

    def __init__(self, *, value: Optional[list["_models.MetricAlertStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The values for the alert rule resources.
        :paramtype value: list[~azure.mgmt.monitor.models.MetricAlertStatus]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricAlertStatusProperties(_serialization.Model):
    """An alert status properties.

    :ivar dimensions: An object describing the type of the dimensions.
    :vartype dimensions: dict[str, str]
    :ivar status: Status value.
    :vartype status: str
    :ivar timestamp: UTC time when the status was checked.
    :vartype timestamp: ~datetime.datetime
    """

    _attribute_map = {
        "dimensions": {"key": "dimensions", "type": "{str}"},
        "status": {"key": "status", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        dimensions: Optional[dict[str, str]] = None,
        status: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dimensions: An object describing the type of the dimensions.
        :paramtype dimensions: dict[str, str]
        :keyword status: Status value.
        :paramtype status: str
        :keyword timestamp: UTC time when the status was checked.
        :paramtype timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.dimensions = dimensions
        self.status = status
        self.timestamp = timestamp


class MetricAvailability(_serialization.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency) and the
    retention period for that time grain.

    :ivar time_grain: The time grain specifies a supported aggregation interval for the metric.
     Expressed as a duration 'PT1M', 'P1D', etc.
    :vartype time_grain: ~datetime.timedelta
    :ivar retention: The retention period for the metric at the specified timegrain.  Expressed as
     a duration 'PT1M', 'P1D', etc.
    :vartype retention: ~datetime.timedelta
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "duration"},
        "retention": {"key": "retention", "type": "duration"},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[datetime.timedelta] = None,
        retention: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: The time grain specifies a supported aggregation interval for the metric.
         Expressed as a duration 'PT1M', 'P1D', etc.
        :paramtype time_grain: ~datetime.timedelta
        :keyword retention: The retention period for the metric at the specified timegrain.  Expressed
         as a duration 'PT1M', 'P1D', etc.
        :paramtype retention: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricBaselinesResponse(_serialization.Model):
    """A list of metric baselines.

    :ivar value: The list of metric baselines.
    :vartype value: list[~azure.mgmt.monitor.models.SingleMetricBaseline]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SingleMetricBaseline]"},
    }

    def __init__(self, *, value: Optional[list["_models.SingleMetricBaseline"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of metric baselines.
        :paramtype value: list[~azure.mgmt.monitor.models.SingleMetricBaseline]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricCriteria(MultiMetricCriteria):
    """Criterion to filter metrics.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar criterion_type: Specifies the type of threshold criteria. Previously undocumented values
     might be returned. Required. Known values are: "StaticThresholdCriterion" and
     "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~azure.mgmt.monitor.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar metric_name: Name of the metric. Required.
    :vartype metric_name: str
    :ivar metric_namespace: Namespace of the metric.
    :vartype metric_namespace: str
    :ivar time_aggregation: The criteria time aggregation types. Previously undocumented values
     might be returned. Required. Known values are: "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype time_aggregation: str or ~azure.mgmt.monitor.models.AggregationTypeEnum
    :ivar dimensions: List of dimension conditions.
    :vartype dimensions: list[~azure.mgmt.monitor.models.MetricDimension]
    :ivar skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :vartype skip_metric_validation: bool
    :ivar operator: The criteria operator. Previously undocumented values might be returned.
     Required. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqual", "LessThan", and
     "LessThanOrEqual".
    :vartype operator: str or ~azure.mgmt.monitor.models.Operator
    :ivar threshold: The criteria threshold value that activates the alert. Required.
    :vartype threshold: float
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "metric_name": {"required": True},
        "time_aggregation": {"required": True},
        "operator": {"required": True},
        "threshold": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "skip_metric_validation": {"key": "skipMetricValidation", "type": "bool"},
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
    }

    def __init__(
        self,
        *,
        name: str,
        metric_name: str,
        time_aggregation: Union[str, "_models.AggregationTypeEnum"],
        operator: Union[str, "_models.Operator"],
        threshold: float,
        additional_properties: Optional[dict[str, JSON]] = None,
        metric_namespace: Optional[str] = None,
        dimensions: Optional[list["_models.MetricDimension"]] = None,
        skip_metric_validation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword metric_name: Name of the metric. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Namespace of the metric.
        :paramtype metric_namespace: str
        :keyword time_aggregation: The criteria time aggregation types. Previously undocumented values
         might be returned. Required. Known values are: "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype time_aggregation: str or ~azure.mgmt.monitor.models.AggregationTypeEnum
        :keyword dimensions: List of dimension conditions.
        :paramtype dimensions: list[~azure.mgmt.monitor.models.MetricDimension]
        :keyword skip_metric_validation: Allows creating an alert rule on a custom metric that isn't
         yet emitted, by causing the metric validation to be skipped.
        :paramtype skip_metric_validation: bool
        :keyword operator: The criteria operator. Previously undocumented values might be returned.
         Required. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqual", "LessThan", and
         "LessThanOrEqual".
        :paramtype operator: str or ~azure.mgmt.monitor.models.Operator
        :keyword threshold: The criteria threshold value that activates the alert. Required.
        :paramtype threshold: float
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            metric_name=metric_name,
            metric_namespace=metric_namespace,
            time_aggregation=time_aggregation,
            dimensions=dimensions,
            skip_metric_validation=skip_metric_validation,
            **kwargs
        )
        self.criterion_type: str = "StaticThresholdCriterion"
        self.operator = operator
        self.threshold = threshold


class MetricDefinition(_serialization.Model):
    """Metric definition class specifies the metadata for a metric.

    :ivar is_dimension_required: Flag to indicate whether the dimension is required.
    :vartype is_dimension_required: bool
    :ivar resource_id: The resource identifier of the resource that emitted the metric.
    :vartype resource_id: str
    :ivar namespace: The namespace the metric belongs to.
    :vartype namespace: str
    :ivar name: The name and the display name of the metric, i.e. it is a localizable string.
    :vartype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar category: Custom category name for this metric.
    :vartype category: str
    :ivar metric_class: The class of the metric. Known values are: "Availability", "Transactions",
     "Errors", "Latency", and "Saturation".
    :vartype metric_class: str or ~azure.mgmt.monitor.models.MetricClass
    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.mgmt.monitor.models.MetricUnit
    :ivar primary_aggregation_type: The primary aggregation type value defining how to use the
     values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype primary_aggregation_type: str or ~azure.mgmt.monitor.models.AggregationType
    :ivar supported_aggregation_types: The collection of what aggregation types are supported.
    :vartype supported_aggregation_types: list[str or ~azure.mgmt.monitor.models.AggregationType]
    :ivar metric_availabilities: The collection of what aggregation intervals are available to be
     queried.
    :vartype metric_availabilities: list[~azure.mgmt.monitor.models.MetricAvailability]
    :ivar id: The resource identifier of the metric definition.
    :vartype id: str
    :ivar dimensions: The name and the display name of the dimension, i.e. it is a localizable
     string.
    :vartype dimensions: list[~azure.mgmt.monitor.models.LocalizableStringAutoGenerated]
    """

    _attribute_map = {
        "is_dimension_required": {"key": "isDimensionRequired", "type": "bool"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "name": {"key": "name", "type": "LocalizableStringAutoGenerated"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "metric_class": {"key": "metricClass", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "primary_aggregation_type": {"key": "primaryAggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "metric_availabilities": {"key": "metricAvailabilities", "type": "[MetricAvailability]"},
        "id": {"key": "id", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[LocalizableStringAutoGenerated]"},
    }

    def __init__(
        self,
        *,
        is_dimension_required: Optional[bool] = None,
        resource_id: Optional[str] = None,
        namespace: Optional[str] = None,
        name: Optional["_models.LocalizableStringAutoGenerated"] = None,
        display_description: Optional[str] = None,
        category: Optional[str] = None,
        metric_class: Optional[Union[str, "_models.MetricClass"]] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        primary_aggregation_type: Optional[Union[str, "_models.AggregationType"]] = None,
        supported_aggregation_types: Optional[list[Union[str, "_models.AggregationType"]]] = None,
        metric_availabilities: Optional[list["_models.MetricAvailability"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        dimensions: Optional[list["_models.LocalizableStringAutoGenerated"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_dimension_required: Flag to indicate whether the dimension is required.
        :paramtype is_dimension_required: bool
        :keyword resource_id: The resource identifier of the resource that emitted the metric.
        :paramtype resource_id: str
        :keyword namespace: The namespace the metric belongs to.
        :paramtype namespace: str
        :keyword name: The name and the display name of the metric, i.e. it is a localizable string.
        :paramtype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword category: Custom category name for this metric.
        :paramtype category: str
        :keyword metric_class: The class of the metric. Known values are: "Availability",
         "Transactions", "Errors", "Latency", and "Saturation".
        :paramtype metric_class: str or ~azure.mgmt.monitor.models.MetricClass
        :keyword unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
        :paramtype unit: str or ~azure.mgmt.monitor.models.MetricUnit
        :keyword primary_aggregation_type: The primary aggregation type value defining how to use the
         values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype primary_aggregation_type: str or ~azure.mgmt.monitor.models.AggregationType
        :keyword supported_aggregation_types: The collection of what aggregation types are supported.
        :paramtype supported_aggregation_types: list[str or ~azure.mgmt.monitor.models.AggregationType]
        :keyword metric_availabilities: The collection of what aggregation intervals are available to
         be queried.
        :paramtype metric_availabilities: list[~azure.mgmt.monitor.models.MetricAvailability]
        :keyword id: The resource identifier of the metric definition.
        :paramtype id: str
        :keyword dimensions: The name and the display name of the dimension, i.e. it is a localizable
         string.
        :paramtype dimensions: list[~azure.mgmt.monitor.models.LocalizableStringAutoGenerated]
        """
        super().__init__(**kwargs)
        self.is_dimension_required = is_dimension_required
        self.resource_id = resource_id
        self.namespace = namespace
        self.name = name
        self.display_description = display_description
        self.category = category
        self.metric_class = metric_class
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_availabilities = metric_availabilities
        self.id = id
        self.dimensions = dimensions


class MetricDefinitionCollection(_serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to server.

    :ivar value: The values for the metric definitions. Required.
    :vartype value: list[~azure.mgmt.monitor.models.MetricDefinition]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricDefinition]"},
    }

    def __init__(self, *, value: list["_models.MetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: The values for the metric definitions. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.MetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricDimension(_serialization.Model):
    """Specifies a metric dimension.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the dimension. Required.
    :vartype name: str
    :ivar operator: The dimension operator. Only 'Include' and 'Exclude' are supported. Required.
    :vartype operator: str
    :ivar values: List of dimension values. Required.
    :vartype values: list[str]
    """

    _validation = {
        "name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, name: str, operator: str, values: list[str], **kwargs: Any) -> None:
        """
        :keyword name: Name of the dimension. Required.
        :paramtype name: str
        :keyword operator: The dimension operator. Only 'Include' and 'Exclude' are supported.
         Required.
        :paramtype operator: str
        :keyword values: List of dimension values. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class MetricNamespace(_serialization.Model):
    """Metric namespace class specifies the metadata for a metric namespace.

    :ivar id: The ID of the metric namespace.
    :vartype id: str
    :ivar type: The type of the namespace.
    :vartype type: str
    :ivar name: The escaped name of the namespace.
    :vartype name: str
    :ivar classification: Kind of namespace. Known values are: "Platform", "Custom", and "Qos".
    :vartype classification: str or ~azure.mgmt.monitor.models.NamespaceClassification
    :ivar properties: Properties which include the fully qualified namespace name.
    :vartype properties: ~azure.mgmt.monitor.models.MetricNamespaceName
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "classification": {"key": "classification", "type": "str"},
        "properties": {"key": "properties", "type": "MetricNamespaceName"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        name: Optional[str] = None,
        classification: Optional[Union[str, "_models.NamespaceClassification"]] = None,
        properties: Optional["_models.MetricNamespaceName"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the metric namespace.
        :paramtype id: str
        :keyword type: The type of the namespace.
        :paramtype type: str
        :keyword name: The escaped name of the namespace.
        :paramtype name: str
        :keyword classification: Kind of namespace. Known values are: "Platform", "Custom", and "Qos".
        :paramtype classification: str or ~azure.mgmt.monitor.models.NamespaceClassification
        :keyword properties: Properties which include the fully qualified namespace name.
        :paramtype properties: ~azure.mgmt.monitor.models.MetricNamespaceName
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.classification = classification
        self.properties = properties


class MetricNamespaceCollection(_serialization.Model):
    """Represents collection of metric namespaces.

    All required parameters must be populated in order to send to server.

    :ivar value: The values for the metric namespaces. Required.
    :vartype value: list[~azure.mgmt.monitor.models.MetricNamespace]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricNamespace]"},
    }

    def __init__(self, *, value: list["_models.MetricNamespace"], **kwargs: Any) -> None:
        """
        :keyword value: The values for the metric namespaces. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.MetricNamespace]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricNamespaceName(_serialization.Model):
    """The fully qualified metric namespace name.

    :ivar metric_namespace_name: The metric namespace name.
    :vartype metric_namespace_name: str
    """

    _attribute_map = {
        "metric_namespace_name": {"key": "metricNamespaceName", "type": "str"},
    }

    def __init__(self, *, metric_namespace_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword metric_namespace_name: The metric namespace name.
        :paramtype metric_namespace_name: str
        """
        super().__init__(**kwargs)
        self.metric_namespace_name = metric_namespace_name


class MetricSettings(_serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.

    All required parameters must be populated in order to send to server.

    :ivar time_grain: the timegrain of the metric in ISO8601 format.
    :vartype time_grain: ~datetime.timedelta
    :ivar category: Name of a Diagnostic Metric category for a resource type this setting is
     applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a
     GET diagnostic settings operation.
    :vartype category: str
    :ivar enabled: a value indicating whether this category is enabled. Required.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this category.
    :vartype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "duration"},
        "category": {"key": "category", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        time_grain: Optional[datetime.timedelta] = None,
        category: Optional[str] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: the timegrain of the metric in ISO8601 format.
        :paramtype time_grain: ~datetime.timedelta
        :keyword category: Name of a Diagnostic Metric category for a resource type this setting is
         applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a
         GET diagnostic settings operation.
        :paramtype category: str
        :keyword enabled: a value indicating whether this category is enabled. Required.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this category.
        :paramtype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.category = category
        self.enabled = enabled
        self.retention_policy = retention_policy


class MetricSettingsAutoGenerated(_serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.

    All required parameters must be populated in order to send to server.

    :ivar time_grain: the timegrain of the metric in ISO8601 format. Required.
    :vartype time_grain: ~datetime.timedelta
    :ivar enabled: a value indicating whether this timegrain is enabled. Required.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this timegrain.
    :vartype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
    """

    _validation = {
        "time_grain": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "duration"},
        "enabled": {"key": "enabled", "type": "bool"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        time_grain: datetime.timedelta,
        enabled: bool,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: the timegrain of the metric in ISO8601 format. Required.
        :paramtype time_grain: ~datetime.timedelta
        :keyword enabled: a value indicating whether this timegrain is enabled. Required.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this timegrain.
        :paramtype retention_policy: ~azure.mgmt.monitor.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.enabled = enabled
        self.retention_policy = retention_policy


class MetricSingleDimension(_serialization.Model):
    """The metric dimension name and value.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the dimension. Required.
    :vartype name: str
    :ivar value: Value of the dimension. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the dimension. Required.
        :paramtype name: str
        :keyword value: Value of the dimension. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class MetricTrigger(_serialization.Model):
    """The trigger that results in a scaling action.

    All required parameters must be populated in order to send to server.

    :ivar metric_name: the name of the metric that defines what the rule monitors. Required.
    :vartype metric_name: str
    :ivar metric_namespace: the namespace of the metric that defines what the rule monitors.
    :vartype metric_namespace: str
    :ivar metric_resource_uri: the resource identifier of the resource the rule monitors. Required.
    :vartype metric_resource_uri: str
    :ivar metric_resource_location: the location of the resource the rule monitors.
    :vartype metric_resource_location: str
    :ivar time_grain: the granularity of metrics the rule monitors. Must be one of the predefined
     values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
     Required.
    :vartype time_grain: ~datetime.timedelta
    :ivar statistic: the metric statistic type. How the metrics from multiple instances are
     combined. Required. Known values are: "Average", "Min", "Max", "Sum", and "Count".
    :vartype statistic: str or ~azure.mgmt.monitor.models.MetricStatisticType
    :ivar time_window: the range of time in which instance data is collected. This value must be
     greater than the delay in metric collection, which can vary from resource-to-resource. Must be
     between 12 hours and 5 minutes. Required.
    :vartype time_window: ~datetime.timedelta
    :ivar time_aggregation: time aggregation type. How the data that is collected should be
     combined over time. The default value is Average. Required. Known values are: "Average",
     "Minimum", "Maximum", "Total", "Count", and "Last".
    :vartype time_aggregation: str or ~azure.mgmt.monitor.models.TimeAggregationType
    :ivar operator: the operator that is used to compare the metric data and the threshold.
     Required. Known values are: "Equals", "NotEquals", "GreaterThan", "GreaterThanOrEqual",
     "LessThan", and "LessThanOrEqual".
    :vartype operator: str or ~azure.mgmt.monitor.models.ComparisonOperationType
    :ivar threshold: the threshold of the metric that triggers the scale action. Required.
    :vartype threshold: float
    :ivar dimensions: List of dimension conditions. For example:
     [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
    :vartype dimensions: list[~azure.mgmt.monitor.models.ScaleRuleMetricDimension]
    :ivar divide_per_instance: a value indicating whether metric should divide per instance.
    :vartype divide_per_instance: bool
    """

    _validation = {
        "metric_name": {"required": True},
        "metric_resource_uri": {"required": True},
        "time_grain": {"required": True},
        "statistic": {"required": True},
        "time_window": {"required": True},
        "time_aggregation": {"required": True},
        "operator": {"required": True},
        "threshold": {"required": True},
    }

    _attribute_map = {
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "metric_resource_uri": {"key": "metricResourceUri", "type": "str"},
        "metric_resource_location": {"key": "metricResourceLocation", "type": "str"},
        "time_grain": {"key": "timeGrain", "type": "duration"},
        "statistic": {"key": "statistic", "type": "str"},
        "time_window": {"key": "timeWindow", "type": "duration"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
        "dimensions": {"key": "dimensions", "type": "[ScaleRuleMetricDimension]"},
        "divide_per_instance": {"key": "dividePerInstance", "type": "bool"},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        metric_resource_uri: str,
        time_grain: datetime.timedelta,
        statistic: Union[str, "_models.MetricStatisticType"],
        time_window: datetime.timedelta,
        time_aggregation: Union[str, "_models.TimeAggregationType"],
        operator: Union[str, "_models.ComparisonOperationType"],
        threshold: float,
        metric_namespace: Optional[str] = None,
        metric_resource_location: Optional[str] = None,
        dimensions: Optional[list["_models.ScaleRuleMetricDimension"]] = None,
        divide_per_instance: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_name: the name of the metric that defines what the rule monitors. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: the namespace of the metric that defines what the rule monitors.
        :paramtype metric_namespace: str
        :keyword metric_resource_uri: the resource identifier of the resource the rule monitors.
         Required.
        :paramtype metric_resource_uri: str
        :keyword metric_resource_location: the location of the resource the rule monitors.
        :paramtype metric_resource_location: str
        :keyword time_grain: the granularity of metrics the rule monitors. Must be one of the
         predefined values returned from metric definitions for the metric. Must be between 12 hours and
         1 minute. Required.
        :paramtype time_grain: ~datetime.timedelta
        :keyword statistic: the metric statistic type. How the metrics from multiple instances are
         combined. Required. Known values are: "Average", "Min", "Max", "Sum", and "Count".
        :paramtype statistic: str or ~azure.mgmt.monitor.models.MetricStatisticType
        :keyword time_window: the range of time in which instance data is collected. This value must be
         greater than the delay in metric collection, which can vary from resource-to-resource. Must be
         between 12 hours and 5 minutes. Required.
        :paramtype time_window: ~datetime.timedelta
        :keyword time_aggregation: time aggregation type. How the data that is collected should be
         combined over time. The default value is Average. Required. Known values are: "Average",
         "Minimum", "Maximum", "Total", "Count", and "Last".
        :paramtype time_aggregation: str or ~azure.mgmt.monitor.models.TimeAggregationType
        :keyword operator: the operator that is used to compare the metric data and the threshold.
         Required. Known values are: "Equals", "NotEquals", "GreaterThan", "GreaterThanOrEqual",
         "LessThan", and "LessThanOrEqual".
        :paramtype operator: str or ~azure.mgmt.monitor.models.ComparisonOperationType
        :keyword threshold: the threshold of the metric that triggers the scale action. Required.
        :paramtype threshold: float
        :keyword dimensions: List of dimension conditions. For example:
         [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        :paramtype dimensions: list[~azure.mgmt.monitor.models.ScaleRuleMetricDimension]
        :keyword divide_per_instance: a value indicating whether metric should divide per instance.
        :paramtype divide_per_instance: bool
        """
        super().__init__(**kwargs)
        self.metric_name = metric_name
        self.metric_namespace = metric_namespace
        self.metric_resource_uri = metric_resource_uri
        self.metric_resource_location = metric_resource_location
        self.time_grain = time_grain
        self.statistic = statistic
        self.time_window = time_window
        self.time_aggregation = time_aggregation
        self.operator = operator
        self.threshold = threshold
        self.dimensions = dimensions
        self.divide_per_instance = divide_per_instance


class MetricValue(_serialization.Model):
    """Represents a metric value.

    All required parameters must be populated in order to send to server.

    :ivar time_stamp: The timestamp for the metric value in ISO 8601 format. Required.
    :vartype time_stamp: ~datetime.datetime
    :ivar average: The average value in the time range.
    :vartype average: float
    :ivar minimum: The least value in the time range.
    :vartype minimum: float
    :ivar maximum: The greatest value in the time range.
    :vartype maximum: float
    :ivar total: The sum of all of the values in the time range.
    :vartype total: float
    :ivar count: The number of samples in the time range. Can be used to determine the number of
     values that contributed to the average value.
    :vartype count: float
    """

    _validation = {
        "time_stamp": {"required": True},
    }

    _attribute_map = {
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "average": {"key": "average", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "total": {"key": "total", "type": "float"},
        "count": {"key": "count", "type": "float"},
    }

    def __init__(
        self,
        *,
        time_stamp: datetime.datetime,
        average: Optional[float] = None,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        total: Optional[float] = None,
        count: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_stamp: The timestamp for the metric value in ISO 8601 format. Required.
        :paramtype time_stamp: ~datetime.datetime
        :keyword average: The average value in the time range.
        :paramtype average: float
        :keyword minimum: The least value in the time range.
        :paramtype minimum: float
        :keyword maximum: The greatest value in the time range.
        :paramtype maximum: float
        :keyword total: The sum of all of the values in the time range.
        :paramtype total: float
        :keyword count: The number of samples in the time range. Can be used to determine the number of
         values that contributed to the average value.
        :paramtype count: float
        """
        super().__init__(**kwargs)
        self.time_stamp = time_stamp
        self.average = average
        self.minimum = minimum
        self.maximum = maximum
        self.total = total
        self.count = count


class MicrosoftFabricDestination(_serialization.Model):
    """Microsoft Fabric destination (non-Azure).

    :ivar tenant_id: The tenant id of the Microsoft Fabric resource.
    :vartype tenant_id: str
    :ivar artifact_id: The artifact id of the Microsoft Fabric resource.
    :vartype artifact_id: str
    :ivar database_name: The name of the database to which data will be ingested.
    :vartype database_name: str
    :ivar ingestion_uri: The ingestion uri of the Microsoft Fabric resource.
    :vartype ingestion_uri: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "artifact_id": {"key": "artifactId", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "ingestion_uri": {"key": "ingestionUri", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        artifact_id: Optional[str] = None,
        database_name: Optional[str] = None,
        ingestion_uri: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The tenant id of the Microsoft Fabric resource.
        :paramtype tenant_id: str
        :keyword artifact_id: The artifact id of the Microsoft Fabric resource.
        :paramtype artifact_id: str
        :keyword database_name: The name of the database to which data will be ingested.
        :paramtype database_name: str
        :keyword ingestion_uri: The ingestion uri of the Microsoft Fabric resource.
        :paramtype ingestion_uri: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.artifact_id = artifact_id
        self.database_name = database_name
        self.ingestion_uri = ingestion_uri
        self.name = name


class MonitoringAccountDestination(_serialization.Model):
    """Monitoring account destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_resource_id: The resource ID of the monitoring account.
    :vartype account_resource_id: str
    :ivar account_id: The immutable ID  of the account.
    :vartype account_id: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "account_id": {"readonly": True},
    }

    _attribute_map = {
        "account_resource_id": {"key": "accountResourceId", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, account_resource_id: Optional[str] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword account_resource_id: The resource ID of the monitoring account.
        :paramtype account_resource_id: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.account_resource_id = account_resource_id
        self.account_id: Optional[str] = None
        self.name = name


class NotificationRequestBody(_serialization.Model):
    """The request body which contain contact detail metadata.

    All required parameters must be populated in order to send to server.

    :ivar alert_type: The value of the supported alert type. Supported alert type values are:
     servicehealth, metricstaticthreshold, metricsdynamicthreshold, logalertv2, smartalert,
     webtestalert, logalertv1numresult, logalertv1metricmeasurement, resourcehealth, activitylog,
     actualcostbudget, forecastedbudget. Required.
    :vartype alert_type: str
    :ivar email_receivers: The list of email receivers that are part of this action group.
    :vartype email_receivers: list[~azure.mgmt.monitor.models.EmailReceiver]
    :ivar sms_receivers: The list of SMS receivers that are part of this action group.
    :vartype sms_receivers: list[~azure.mgmt.monitor.models.SmsReceiver]
    :ivar webhook_receivers: The list of webhook receivers that are part of this action group.
    :vartype webhook_receivers: list[~azure.mgmt.monitor.models.WebhookReceiver]
    :ivar itsm_receivers: The list of ITSM receivers that are part of this action group.
    :vartype itsm_receivers: list[~azure.mgmt.monitor.models.ItsmReceiver]
    :ivar azure_app_push_receivers: The list of AzureAppPush receivers that are part of this action
     group.
    :vartype azure_app_push_receivers: list[~azure.mgmt.monitor.models.AzureAppPushReceiver]
    :ivar automation_runbook_receivers: The list of AutomationRunbook receivers that are part of
     this action group.
    :vartype automation_runbook_receivers:
     list[~azure.mgmt.monitor.models.AutomationRunbookReceiver]
    :ivar voice_receivers: The list of voice receivers that are part of this action group.
    :vartype voice_receivers: list[~azure.mgmt.monitor.models.VoiceReceiver]
    :ivar logic_app_receivers: The list of logic app receivers that are part of this action group.
    :vartype logic_app_receivers: list[~azure.mgmt.monitor.models.LogicAppReceiver]
    :ivar azure_function_receivers: The list of azure function receivers that are part of this
     action group.
    :vartype azure_function_receivers: list[~azure.mgmt.monitor.models.AzureFunctionReceiver]
    :ivar arm_role_receivers: The list of ARM role receivers that are part of this action group.
     Roles are Azure RBAC roles and only built-in roles are supported.
    :vartype arm_role_receivers: list[~azure.mgmt.monitor.models.ArmRoleReceiver]
    :ivar event_hub_receivers: The list of event hub receivers that are part of this action group.
    :vartype event_hub_receivers: list[~azure.mgmt.monitor.models.EventHubReceiver]
    """

    _validation = {
        "alert_type": {"required": True, "max_length": 30},
    }

    _attribute_map = {
        "alert_type": {"key": "alertType", "type": "str"},
        "email_receivers": {"key": "emailReceivers", "type": "[EmailReceiver]"},
        "sms_receivers": {"key": "smsReceivers", "type": "[SmsReceiver]"},
        "webhook_receivers": {"key": "webhookReceivers", "type": "[WebhookReceiver]"},
        "itsm_receivers": {"key": "itsmReceivers", "type": "[ItsmReceiver]"},
        "azure_app_push_receivers": {"key": "azureAppPushReceivers", "type": "[AzureAppPushReceiver]"},
        "automation_runbook_receivers": {"key": "automationRunbookReceivers", "type": "[AutomationRunbookReceiver]"},
        "voice_receivers": {"key": "voiceReceivers", "type": "[VoiceReceiver]"},
        "logic_app_receivers": {"key": "logicAppReceivers", "type": "[LogicAppReceiver]"},
        "azure_function_receivers": {"key": "azureFunctionReceivers", "type": "[AzureFunctionReceiver]"},
        "arm_role_receivers": {"key": "armRoleReceivers", "type": "[ArmRoleReceiver]"},
        "event_hub_receivers": {"key": "eventHubReceivers", "type": "[EventHubReceiver]"},
    }

    def __init__(
        self,
        *,
        alert_type: str,
        email_receivers: Optional[list["_models.EmailReceiver"]] = None,
        sms_receivers: Optional[list["_models.SmsReceiver"]] = None,
        webhook_receivers: Optional[list["_models.WebhookReceiver"]] = None,
        itsm_receivers: Optional[list["_models.ItsmReceiver"]] = None,
        azure_app_push_receivers: Optional[list["_models.AzureAppPushReceiver"]] = None,
        automation_runbook_receivers: Optional[list["_models.AutomationRunbookReceiver"]] = None,
        voice_receivers: Optional[list["_models.VoiceReceiver"]] = None,
        logic_app_receivers: Optional[list["_models.LogicAppReceiver"]] = None,
        azure_function_receivers: Optional[list["_models.AzureFunctionReceiver"]] = None,
        arm_role_receivers: Optional[list["_models.ArmRoleReceiver"]] = None,
        event_hub_receivers: Optional[list["_models.EventHubReceiver"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword alert_type: The value of the supported alert type. Supported alert type values are:
         servicehealth, metricstaticthreshold, metricsdynamicthreshold, logalertv2, smartalert,
         webtestalert, logalertv1numresult, logalertv1metricmeasurement, resourcehealth, activitylog,
         actualcostbudget, forecastedbudget. Required.
        :paramtype alert_type: str
        :keyword email_receivers: The list of email receivers that are part of this action group.
        :paramtype email_receivers: list[~azure.mgmt.monitor.models.EmailReceiver]
        :keyword sms_receivers: The list of SMS receivers that are part of this action group.
        :paramtype sms_receivers: list[~azure.mgmt.monitor.models.SmsReceiver]
        :keyword webhook_receivers: The list of webhook receivers that are part of this action group.
        :paramtype webhook_receivers: list[~azure.mgmt.monitor.models.WebhookReceiver]
        :keyword itsm_receivers: The list of ITSM receivers that are part of this action group.
        :paramtype itsm_receivers: list[~azure.mgmt.monitor.models.ItsmReceiver]
        :keyword azure_app_push_receivers: The list of AzureAppPush receivers that are part of this
         action group.
        :paramtype azure_app_push_receivers: list[~azure.mgmt.monitor.models.AzureAppPushReceiver]
        :keyword automation_runbook_receivers: The list of AutomationRunbook receivers that are part of
         this action group.
        :paramtype automation_runbook_receivers:
         list[~azure.mgmt.monitor.models.AutomationRunbookReceiver]
        :keyword voice_receivers: The list of voice receivers that are part of this action group.
        :paramtype voice_receivers: list[~azure.mgmt.monitor.models.VoiceReceiver]
        :keyword logic_app_receivers: The list of logic app receivers that are part of this action
         group.
        :paramtype logic_app_receivers: list[~azure.mgmt.monitor.models.LogicAppReceiver]
        :keyword azure_function_receivers: The list of azure function receivers that are part of this
         action group.
        :paramtype azure_function_receivers: list[~azure.mgmt.monitor.models.AzureFunctionReceiver]
        :keyword arm_role_receivers: The list of ARM role receivers that are part of this action group.
         Roles are Azure RBAC roles and only built-in roles are supported.
        :paramtype arm_role_receivers: list[~azure.mgmt.monitor.models.ArmRoleReceiver]
        :keyword event_hub_receivers: The list of event hub receivers that are part of this action
         group.
        :paramtype event_hub_receivers: list[~azure.mgmt.monitor.models.EventHubReceiver]
        """
        super().__init__(**kwargs)
        self.alert_type = alert_type
        self.email_receivers = email_receivers
        self.sms_receivers = sms_receivers
        self.webhook_receivers = webhook_receivers
        self.itsm_receivers = itsm_receivers
        self.azure_app_push_receivers = azure_app_push_receivers
        self.automation_runbook_receivers = automation_runbook_receivers
        self.voice_receivers = voice_receivers
        self.logic_app_receivers = logic_app_receivers
        self.azure_function_receivers = azure_function_receivers
        self.arm_role_receivers = arm_role_receivers
        self.event_hub_receivers = event_hub_receivers


class Operation(_serialization.Model):
    """Microsoft Insights API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.monitor.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.monitor.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationAutoGenerated(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.monitor.models.OperationDisplayAutoGenerated
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.monitor.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.monitor.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplayAutoGenerated"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplayAutoGenerated"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.monitor.models.OperationDisplayAutoGenerated
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft.Insights.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Insights.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationDisplayAutoGenerated(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Insights operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar value: List of operations supported by the Microsoft.Insights provider.
    :vartype value: list[~azure.mgmt.monitor.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the Microsoft.Insights provider.
        :paramtype value: list[~azure.mgmt.monitor.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationListResultAutoGenerated(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.monitor.models.OperationAutoGenerated]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationAutoGenerated]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[list["_models.OperationAutoGenerated"]] = None
        self.next_link: Optional[str] = None


class OperationStatus(_serialization.Model):
    """The status of operation.

    :ivar id: The operation Id.
    :vartype id: str
    :ivar name: The operation name.
    :vartype name: str
    :ivar start_time: Start time of the job in standard ISO8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the job in standard ISO8601 format.
    :vartype end_time: ~datetime.datetime
    :ivar status: The status of the operation.
    :vartype status: str
    :ivar error: The error detail of the operation if any.
    :vartype error: ~azure.mgmt.monitor.models.ErrorResponseCommon
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorResponseCommon"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        error: Optional["_models.ErrorResponseCommon"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The operation Id.
        :paramtype id: str
        :keyword name: The operation name.
        :paramtype name: str
        :keyword start_time: Start time of the job in standard ISO8601 format.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the job in standard ISO8601 format.
        :paramtype end_time: ~datetime.datetime
        :keyword status: The status of the operation.
        :paramtype status: str
        :keyword error: The error detail of the operation if any.
        :paramtype error: ~azure.mgmt.monitor.models.ErrorResponseCommon
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error


class PerfCounterDataSource(_serialization.Model):
    """Definition of which performance counters will be collected and how they will be collected by
    this data collection rule.
    Collected from both Windows and Linux machines where the counter is present.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or ~azure.mgmt.monitor.models.KnownPerfCounterDataSourceStreams]
    :ivar sampling_frequency_in_seconds: The number of seconds between consecutive counter
     measurements (samples).
    :vartype sampling_frequency_in_seconds: int
    :ivar counter_specifiers: A list of specifier names of the performance counters you want to
     collect.
     Use a wildcard (*) to collect a counter for all instances.
     To get a list of performance counters on Windows, run the command 'typeperf'.
    :vartype counter_specifiers: list[str]
    :ivar transform_kql: The KQL query to transform the data source.
    :vartype transform_kql: str
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "sampling_frequency_in_seconds": {"key": "samplingFrequencyInSeconds", "type": "int"},
        "counter_specifiers": {"key": "counterSpecifiers", "type": "[str]"},
        "transform_kql": {"key": "transformKql", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: Optional[list[Union[str, "_models.KnownPerfCounterDataSourceStreams"]]] = None,
        sampling_frequency_in_seconds: Optional[int] = None,
        counter_specifiers: Optional[list[str]] = None,
        transform_kql: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or ~azure.mgmt.monitor.models.KnownPerfCounterDataSourceStreams]
        :keyword sampling_frequency_in_seconds: The number of seconds between consecutive counter
         measurements (samples).
        :paramtype sampling_frequency_in_seconds: int
        :keyword counter_specifiers: A list of specifier names of the performance counters you want to
         collect.
         Use a wildcard (*) to collect a counter for all instances.
         To get a list of performance counters on Windows, run the command 'typeperf'.
        :paramtype counter_specifiers: list[str]
        :keyword transform_kql: The KQL query to transform the data source.
        :paramtype transform_kql: str
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.sampling_frequency_in_seconds = sampling_frequency_in_seconds
        self.counter_specifiers = counter_specifiers
        self.transform_kql = transform_kql
        self.name = name


class PerformanceCounterConfiguration(_serialization.Model):
    """PerformanceCounterConfiguration.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar sampling_period: Required.
    :vartype sampling_period: str
    :ivar instance:
    :vartype instance: str
    """

    _validation = {
        "name": {"required": True},
        "sampling_period": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sampling_period": {"key": "samplingPeriod", "type": "str"},
        "instance": {"key": "instance", "type": "str"},
    }

    def __init__(self, *, name: str, sampling_period: str, instance: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword sampling_period: Required.
        :paramtype sampling_period: str
        :keyword instance:
        :paramtype instance: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.sampling_period = sampling_period
        self.instance = instance


class PlatformTelemetryDataSource(_serialization.Model):
    """Definition of platform telemetry data source configuration.

    All required parameters must be populated in order to send to server.

    :ivar streams: List of platform telemetry streams to collect. Required.
    :vartype streams: list[str]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "streams": {"required": True},
    }

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, streams: list[str], name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword streams: List of platform telemetry streams to collect. Required.
        :paramtype streams: list[str]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.name = name


class PredictiveAutoscalePolicy(_serialization.Model):
    """The parameters for enabling predictive autoscale.

    All required parameters must be populated in order to send to server.

    :ivar scale_mode: the predictive autoscale mode. Required. Known values are: "Disabled",
     "ForecastOnly", and "Enabled".
    :vartype scale_mode: str or ~azure.mgmt.monitor.models.PredictiveAutoscalePolicyScaleMode
    :ivar scale_look_ahead_time: the amount of time to specify by which instances are launched in
     advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
    :vartype scale_look_ahead_time: ~datetime.timedelta
    """

    _validation = {
        "scale_mode": {"required": True},
    }

    _attribute_map = {
        "scale_mode": {"key": "scaleMode", "type": "str"},
        "scale_look_ahead_time": {"key": "scaleLookAheadTime", "type": "duration"},
    }

    def __init__(
        self,
        *,
        scale_mode: Union[str, "_models.PredictiveAutoscalePolicyScaleMode"],
        scale_look_ahead_time: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scale_mode: the predictive autoscale mode. Required. Known values are: "Disabled",
         "ForecastOnly", and "Enabled".
        :paramtype scale_mode: str or ~azure.mgmt.monitor.models.PredictiveAutoscalePolicyScaleMode
        :keyword scale_look_ahead_time: the amount of time to specify by which instances are launched
         in advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
        :paramtype scale_look_ahead_time: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.scale_mode = scale_mode
        self.scale_look_ahead_time = scale_look_ahead_time


class PredictiveResponse(_serialization.Model):
    """The response to a metrics query.

    :ivar timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in.  This may
     be adjusted in the future and returned back from what was originally requested.  This is not
     present if a metadata request was made.
    :vartype interval: ~datetime.timedelta
    :ivar metric_name: The metrics being queried.
    :vartype metric_name: str
    :ivar target_resource_id: resource of the predictive metric.
    :vartype target_resource_id: str
    :ivar data: the value of the collection.
    :vartype data: list[~azure.mgmt.monitor.models.PredictiveValue]
    """

    _attribute_map = {
        "timespan": {"key": "timespan", "type": "str"},
        "interval": {"key": "interval", "type": "duration"},
        "metric_name": {"key": "metricName", "type": "str"},
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "data": {"key": "data", "type": "[PredictiveValue]"},
    }

    def __init__(
        self,
        *,
        timespan: Optional[str] = None,
        interval: Optional[datetime.timedelta] = None,
        metric_name: Optional[str] = None,
        target_resource_id: Optional[str] = None,
        data: Optional[list["_models.PredictiveValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timespan: The timespan for which the data was retrieved. Its value consists of two
         datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
         from what was originally requested.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in.  This
         may be adjusted in the future and returned back from what was originally requested.  This is
         not present if a metadata request was made.
        :paramtype interval: ~datetime.timedelta
        :keyword metric_name: The metrics being queried.
        :paramtype metric_name: str
        :keyword target_resource_id: resource of the predictive metric.
        :paramtype target_resource_id: str
        :keyword data: the value of the collection.
        :paramtype data: list[~azure.mgmt.monitor.models.PredictiveValue]
        """
        super().__init__(**kwargs)
        self.timespan = timespan
        self.interval = interval
        self.metric_name = metric_name
        self.target_resource_id = target_resource_id
        self.data = data


class PredictiveValue(_serialization.Model):
    """Represents a predictive metric value in the given bucket.

    All required parameters must be populated in order to send to server.

    :ivar time_stamp: the timestamp for the metric value in ISO 8601 format. Required.
    :vartype time_stamp: ~datetime.datetime
    :ivar value: Predictive value in this time bucket. Required.
    :vartype value: float
    """

    _validation = {
        "time_stamp": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, time_stamp: datetime.datetime, value: float, **kwargs: Any) -> None:
        """
        :keyword time_stamp: the timestamp for the metric value in ISO 8601 format. Required.
        :paramtype time_stamp: ~datetime.datetime
        :keyword value: Predictive value in this time bucket. Required.
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.time_stamp = time_stamp
        self.value = value


class PrivateEndpoint(_serialization.Model):
    """The private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for private endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class ProxyResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.monitor.models.PrivateEndpointProperty
    :ivar private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.monitor.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpointProperty"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionStateProperty",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.monitor.models.PrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection state of the private endpoint
         connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.monitor.models.PrivateLinkServiceConnectionStateProperty
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[str] = None


class ResourceAutoGenerated7(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class PrivateEndpointConnectionAutoGenerated(ResourceAutoGenerated7):
    """The private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.monitor.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.monitor.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint resource.
        :paramtype private_endpoint: ~azure.mgmt.monitor.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.monitor.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.group_ids: Optional[list[str]] = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.monitor.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[list["_models.PrivateEndpointConnection"]] = None
        self.next_link: Optional[str] = None


class PrivateEndpointProperty(_serialization.Model):
    """Private endpoint which the connection belongs to.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource id of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.group_id: Optional[str] = None
        self.required_members: Optional[list[str]] = None


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.monitor.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[list["_models.PrivateLinkResource"]] = None
        self.next_link: Optional[str] = None


class PrivateLinkScopedResource(_serialization.Model):
    """PrivateLinkScopedResource.

    :ivar resource_id: The resourceId of the Azure Monitor Private Link Scope Scoped Resource
     through which this DCE is associated with a Azure Monitor Private Link Scope.
    :vartype resource_id: str
    :ivar scope_id: The immutableId of the Azure Monitor Private Link Scope Resource to which the
     association is.
    :vartype scope_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "scope_id": {"key": "scopeId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, scope_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The resourceId of the Azure Monitor Private Link Scope Scoped Resource
         through which this DCE is associated with a Azure Monitor Private Link Scope.
        :paramtype resource_id: str
        :keyword scope_id: The immutableId of the Azure Monitor Private Link Scope Resource to which
         the association is.
        :paramtype scope_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.scope_id = scope_id


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.monitor.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.monitor.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinkServiceConnectionStateProperty(_serialization.Model):  # pylint: disable=name-too-long
    """State of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar status: The private link service connection status. Required.
    :vartype status: str
    :ivar description: The private link service connection description. Required.
    :vartype description: str
    :ivar actions_required: The actions required for private link service connection.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
        "actions_required": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(self, *, status: str, description: str, **kwargs: Any) -> None:
        """
        :keyword status: The private link service connection status. Required.
        :paramtype status: str
        :keyword description: The private link service connection description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required: Optional[str] = None


class PrometheusForwarderDataSource(_serialization.Model):
    """Definition of Prometheus metrics forwarding configuration.

    :ivar streams: List of streams that this data source will be sent to.
    :vartype streams: list[str or
     ~azure.mgmt.monitor.models.KnownPrometheusForwarderDataSourceStreams]
    :ivar label_include_filter: The list of label inclusion filters in the form of label
     "name-value" pairs.
     Currently only one label is supported: 'microsoft_metrics_include_label'.
     Label values are matched case-insensitively.
    :vartype label_include_filter: dict[str, str]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "label_include_filter": {"key": "labelIncludeFilter", "type": "{str}"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: Optional[list[Union[str, "_models.KnownPrometheusForwarderDataSourceStreams"]]] = None,
        label_include_filter: Optional[dict[str, str]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
        :paramtype streams: list[str or
         ~azure.mgmt.monitor.models.KnownPrometheusForwarderDataSourceStreams]
        :keyword label_include_filter: The list of label inclusion filters in the form of label
         "name-value" pairs.
         Currently only one label is supported: 'microsoft_metrics_include_label'.
         Label values are matched case-insensitively.
        :paramtype label_include_filter: dict[str, str]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.label_include_filter = label_include_filter
        self.name = name


class PromQLCriteria(MetricAlertCriteria):
    """Specifies the PromQL criteria for the metric alert resource.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: Specifies the type of the alert criteria. Previously undocumented values
     might be returned. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria", and
     "Microsoft.Azure.Monitor.PromQLCriteria".
    :vartype odata_type: str or ~azure.mgmt.monitor.models.Odatatype
    :ivar failing_periods: Configuration for failing periods in query-based alerts.
    :vartype failing_periods: ~azure.mgmt.monitor.models.QueryFailingPeriods
    :ivar all_of: The list of promQL criteria. Alert will be raised when all conditions are met.
    :vartype all_of: list[~azure.mgmt.monitor.models.MultiPromQLCriteria]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "failing_periods": {"key": "failingPeriods", "type": "QueryFailingPeriods"},
        "all_of": {"key": "allOf", "type": "[MultiPromQLCriteria]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[dict[str, JSON]] = None,
        failing_periods: Optional["_models.QueryFailingPeriods"] = None,
        all_of: Optional[list["_models.MultiPromQLCriteria"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword failing_periods: Configuration for failing periods in query-based alerts.
        :paramtype failing_periods: ~azure.mgmt.monitor.models.QueryFailingPeriods
        :keyword all_of: The list of promQL criteria. Alert will be raised when all conditions are met.
        :paramtype all_of: list[~azure.mgmt.monitor.models.MultiPromQLCriteria]
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Monitor.PromQLCriteria"
        self.failing_periods = failing_periods
        self.all_of = all_of


class QueryFailingPeriods(_serialization.Model):
    """Configuration for failing periods in query-based alerts.

    All required parameters must be populated in order to send to server.

    :ivar for_property: The amount of time (in ISO 8601 duration format) alert must be active
     before firing. Required.
    :vartype for_property: ~datetime.timedelta
    """

    _validation = {
        "for_property": {"required": True},
    }

    _attribute_map = {
        "for_property": {"key": "for", "type": "duration"},
    }

    def __init__(self, *, for_property: datetime.timedelta, **kwargs: Any) -> None:
        """
        :keyword for_property: The amount of time (in ISO 8601 duration format) alert must be active
         before firing. Required.
        :paramtype for_property: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.for_property = for_property


class Recurrence(_serialization.Model):
    """The repeating times at which this profile begins. This element is not used if the FixedDate
    element is used.

    All required parameters must be populated in order to send to server.

    :ivar frequency: the recurrence frequency. How often the schedule profile should take effect.
     This value must be Week, meaning each week will have the same set of profiles. For example, to
     set a daily schedule, set **schedule** to every day of the week. The frequency property
     specifies that the schedule is repeated weekly. Required. Known values are: "None", "Second",
     "Minute", "Hour", "Day", "Week", "Month", and "Year".
    :vartype frequency: str or ~azure.mgmt.monitor.models.RecurrenceFrequency
    :ivar schedule: the scheduling constraints for when the profile begins. Required.
    :vartype schedule: ~azure.mgmt.monitor.models.RecurrentSchedule
    """

    _validation = {
        "frequency": {"required": True},
        "schedule": {"required": True},
    }

    _attribute_map = {
        "frequency": {"key": "frequency", "type": "str"},
        "schedule": {"key": "schedule", "type": "RecurrentSchedule"},
    }

    def __init__(
        self,
        *,
        frequency: Union[str, "_models.RecurrenceFrequency"],
        schedule: "_models.RecurrentSchedule",
        **kwargs: Any
    ) -> None:
        """
        :keyword frequency: the recurrence frequency. How often the schedule profile should take
         effect. This value must be Week, meaning each week will have the same set of profiles. For
         example, to set a daily schedule, set **schedule** to every day of the week. The frequency
         property specifies that the schedule is repeated weekly. Required. Known values are: "None",
         "Second", "Minute", "Hour", "Day", "Week", "Month", and "Year".
        :paramtype frequency: str or ~azure.mgmt.monitor.models.RecurrenceFrequency
        :keyword schedule: the scheduling constraints for when the profile begins. Required.
        :paramtype schedule: ~azure.mgmt.monitor.models.RecurrentSchedule
        """
        super().__init__(**kwargs)
        self.frequency = frequency
        self.schedule = schedule


class RecurrentSchedule(_serialization.Model):
    """The scheduling constraints for when the profile begins.

    All required parameters must be populated in order to send to server.

    :ivar time_zone: the timezone for the hours of the profile. Some examples of valid time zones
     are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific
     Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard
     Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time,
     Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern
     Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time,
     Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA
     Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard
     Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia
     Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard
     Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe
     Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard
     Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB
     Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe
     Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel
     Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab
     Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time. Required.
    :vartype time_zone: str
    :ivar days: the collection of days that the profile takes effect on. Possible values are Sunday
     through Saturday. Required.
    :vartype days: list[str]
    :ivar hours: A collection of hours that the profile takes effect on. Values supported are 0 to
     23 on the 24-hour clock (AM/PM times are not supported). Required.
    :vartype hours: list[int]
    :ivar minutes: A collection of minutes at which the profile takes effect at. Required.
    :vartype minutes: list[int]
    """

    _validation = {
        "time_zone": {"required": True},
        "days": {"required": True},
        "hours": {"required": True},
        "minutes": {"required": True},
    }

    _attribute_map = {
        "time_zone": {"key": "timeZone", "type": "str"},
        "days": {"key": "days", "type": "[str]"},
        "hours": {"key": "hours", "type": "[int]"},
        "minutes": {"key": "minutes", "type": "[int]"},
    }

    def __init__(self, *, time_zone: str, days: list[str], hours: list[int], minutes: list[int], **kwargs: Any) -> None:
        """
        :keyword time_zone: the timezone for the hours of the profile. Some examples of valid time
         zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time,
         Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain
         Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard
         Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time,
         Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard
         Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time,
         Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
         Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time,
         Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde
         Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
         Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
         Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time,
         GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E.
         Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
         Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
         Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
         Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
         Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
         Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
         Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
         Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
         Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
         Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
         Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
         Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
         Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
         Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
         Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
         Standard Time. Required.
        :paramtype time_zone: str
        :keyword days: the collection of days that the profile takes effect on. Possible values are
         Sunday through Saturday. Required.
        :paramtype days: list[str]
        :keyword hours: A collection of hours that the profile takes effect on. Values supported are 0
         to 23 on the 24-hour clock (AM/PM times are not supported). Required.
        :paramtype hours: list[int]
        :keyword minutes: A collection of minutes at which the profile takes effect at. Required.
        :paramtype minutes: list[int]
        """
        super().__init__(**kwargs)
        self.time_zone = time_zone
        self.days = days
        self.hours = hours
        self.minutes = minutes


class ReferencesSpecEnrichmentData(EnrichmentData):
    """All the enrichment data sources referenced in data flows.

    :ivar storage_blobs: All the storage blobs used as enrichment data sources.
    :vartype storage_blobs: list[~azure.mgmt.monitor.models.StorageBlob]
    """


class ResolveConfiguration(_serialization.Model):
    """ResolveConfiguration.

    All required parameters must be populated in order to send to server.

    :ivar auto_resolved: Indicates whether the alert should be auto resolved. Required.
    :vartype auto_resolved: bool
    :ivar time_to_resolve: The time (in ISO 8601 duration format) after which the alert should be
     auto resolved.
    :vartype time_to_resolve: ~datetime.timedelta
    """

    _validation = {
        "auto_resolved": {"required": True},
    }

    _attribute_map = {
        "auto_resolved": {"key": "autoResolved", "type": "bool"},
        "time_to_resolve": {"key": "timeToResolve", "type": "duration"},
    }

    def __init__(
        self, *, auto_resolved: bool, time_to_resolve: Optional[datetime.timedelta] = None, **kwargs: Any
    ) -> None:
        """
        :keyword auto_resolved: Indicates whether the alert should be auto resolved. Required.
        :paramtype auto_resolved: bool
        :keyword time_to_resolve: The time (in ISO 8601 duration format) after which the alert should
         be auto resolved.
        :paramtype time_to_resolve: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.auto_resolved = auto_resolved
        self.time_to_resolve = time_to_resolve


class ResourceAutoGenerated6(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class ResourceForUpdate(_serialization.Model):
    """Definition of ARM tracked top level resource properties for update operation.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed Service Identity.
    :vartype identity: ~azure.mgmt.monitor.models.ResourceForUpdateIdentity
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ResourceForUpdateIdentity"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ResourceForUpdateIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed Service Identity.
        :paramtype identity: ~azure.mgmt.monitor.models.ResourceForUpdateIdentity
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class ResourceForUpdateIdentity(ManagedServiceIdentity):
    """Managed Service Identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.monitor.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.monitor.models.UserAssignedIdentity]
    """


class Response(_serialization.Model):
    """The response to a metrics query.

    All required parameters must be populated in order to send to server.

    :ivar cost: The integer value representing the relative cost of the query.
    :vartype cost: int
    :ivar timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested. Required.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in ISO 8601
     duration format with a special case for 'FULL' value that returns single datapoint for entire
     time span requested (\\ *Examples: PT15M, PT1H, P1D, FULL*\\ ).
     This may be adjusted and different from what was originally requested if
     AutoAdjustTimegrain=true is specified. This is not present if a metadata request was made.
    :vartype interval: str
    :ivar namespace: The namespace of the metrics being queried.
    :vartype namespace: str
    :ivar resourceregion: The region of the resource being queried for metrics.
    :vartype resourceregion: str
    :ivar value: The value of the collection. Required.
    :vartype value: list[~azure.mgmt.monitor.models.Metric]
    """

    _validation = {
        "cost": {"minimum": 0},
        "timespan": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "cost": {"key": "cost", "type": "int"},
        "timespan": {"key": "timespan", "type": "str"},
        "interval": {"key": "interval", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "resourceregion": {"key": "resourceregion", "type": "str"},
        "value": {"key": "value", "type": "[Metric]"},
    }

    def __init__(
        self,
        *,
        timespan: str,
        value: list["_models.Metric"],
        cost: Optional[int] = None,
        interval: Optional[str] = None,
        namespace: Optional[str] = None,
        resourceregion: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cost: The integer value representing the relative cost of the query.
        :paramtype cost: int
        :keyword timespan: The timespan for which the data was retrieved. Its value consists of two
         datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
         from what was originally requested. Required.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in ISO
         8601 duration format with a special case for 'FULL' value that returns single datapoint for
         entire time span requested (\\ *Examples: PT15M, PT1H, P1D, FULL*\\ ).
         This may be adjusted and different from what was originally requested if
         AutoAdjustTimegrain=true is specified. This is not present if a metadata request was made.
        :paramtype interval: str
        :keyword namespace: The namespace of the metrics being queried.
        :paramtype namespace: str
        :keyword resourceregion: The region of the resource being queried for metrics.
        :paramtype resourceregion: str
        :keyword value: The value of the collection. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.Metric]
        """
        super().__init__(**kwargs)
        self.cost = cost
        self.timespan = timespan
        self.interval = interval
        self.namespace = namespace
        self.resourceregion = resourceregion
        self.value = value


class ResponseWithError(_serialization.Model):
    """An error response from the API.

    All required parameters must be populated in order to send to server.

    :ivar error: Error information. Required.
    :vartype error: ~azure.mgmt.monitor.models.Error
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, *, error: "_models.Error", **kwargs: Any) -> None:
        """
        :keyword error: Error information. Required.
        :paramtype error: ~azure.mgmt.monitor.models.Error
        """
        super().__init__(**kwargs)
        self.error = error


class RetentionPolicy(_serialization.Model):
    """Specifies the retention policy for the log.

    All required parameters must be populated in order to send to server.

    :ivar enabled: a value indicating whether the retention policy is enabled. Required.
    :vartype enabled: bool
    :ivar days: the number of days for the retention in days. A value of 0 will retain the events
     indefinitely. Required.
    :vartype days: int
    """

    _validation = {
        "enabled": {"required": True},
        "days": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "days": {"key": "days", "type": "int"},
    }

    def __init__(self, *, enabled: bool, days: int, **kwargs: Any) -> None:
        """
        :keyword enabled: a value indicating whether the retention policy is enabled. Required.
        :paramtype enabled: bool
        :keyword days: the number of days for the retention in days. A value of 0 will retain the
         events indefinitely. Required.
        :paramtype days: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class RuleResolveConfiguration(_serialization.Model):
    """TBD. Relevant only for rules of the kind LogAlert.

    :ivar auto_resolved: The flag that indicates whether or not to auto resolve a fired alert.
    :vartype auto_resolved: bool
    :ivar time_to_resolve: The duration a rule must evaluate as healthy before the fired alert is
     automatically resolved represented in ISO 8601 duration format.
    :vartype time_to_resolve: ~datetime.timedelta
    """

    _attribute_map = {
        "auto_resolved": {"key": "autoResolved", "type": "bool"},
        "time_to_resolve": {"key": "timeToResolve", "type": "duration"},
    }

    def __init__(
        self,
        *,
        auto_resolved: Optional[bool] = None,
        time_to_resolve: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_resolved: The flag that indicates whether or not to auto resolve a fired alert.
        :paramtype auto_resolved: bool
        :keyword time_to_resolve: The duration a rule must evaluate as healthy before the fired alert
         is automatically resolved represented in ISO 8601 duration format.
        :paramtype time_to_resolve: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.auto_resolved = auto_resolved
        self.time_to_resolve = time_to_resolve


class ScaleAction(_serialization.Model):
    """The parameters for the scaling action.

    All required parameters must be populated in order to send to server.

    :ivar direction: the scale direction. Whether the scaling action increases or decreases the
     number of instances. Required. Known values are: "None", "Increase", and "Decrease".
    :vartype direction: str or ~azure.mgmt.monitor.models.ScaleDirection
    :ivar type: the type of action that should occur when the scale rule fires. Required. Known
     values are: "ChangeCount", "PercentChangeCount", "ExactCount", and "ServiceAllowedNextValue".
    :vartype type: str or ~azure.mgmt.monitor.models.ScaleType
    :ivar value: the number of instances that are involved in the scaling action. This value must
     be 1 or greater. The default value is 1.
    :vartype value: str
    :ivar cooldown: the amount of time to wait since the last scaling action before this action
     occurs. It must be between 1 week and 1 minute in ISO 8601 format. Required.
    :vartype cooldown: ~datetime.timedelta
    """

    _validation = {
        "direction": {"required": True},
        "type": {"required": True},
        "cooldown": {"required": True},
    }

    _attribute_map = {
        "direction": {"key": "direction", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "cooldown": {"key": "cooldown", "type": "duration"},
    }

    def __init__(
        self,
        *,
        direction: Union[str, "_models.ScaleDirection"],
        type: Union[str, "_models.ScaleType"],
        cooldown: datetime.timedelta,
        value: str = "1",
        **kwargs: Any
    ) -> None:
        """
        :keyword direction: the scale direction. Whether the scaling action increases or decreases the
         number of instances. Required. Known values are: "None", "Increase", and "Decrease".
        :paramtype direction: str or ~azure.mgmt.monitor.models.ScaleDirection
        :keyword type: the type of action that should occur when the scale rule fires. Required. Known
         values are: "ChangeCount", "PercentChangeCount", "ExactCount", and "ServiceAllowedNextValue".
        :paramtype type: str or ~azure.mgmt.monitor.models.ScaleType
        :keyword value: the number of instances that are involved in the scaling action. This value
         must be 1 or greater. The default value is 1.
        :paramtype value: str
        :keyword cooldown: the amount of time to wait since the last scaling action before this action
         occurs. It must be between 1 week and 1 minute in ISO 8601 format. Required.
        :paramtype cooldown: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.direction = direction
        self.type = type
        self.value = value
        self.cooldown = cooldown


class ScaleCapacity(_serialization.Model):
    """The number of instances that can be used during this profile.

    All required parameters must be populated in order to send to server.

    :ivar minimum: the minimum number of instances for the resource. Required.
    :vartype minimum: str
    :ivar maximum: the maximum number of instances for the resource. The actual maximum number of
     instances is limited by the cores that are available in the subscription. Required.
    :vartype maximum: str
    :ivar default: the number of instances that will be set if metrics are not available for
     evaluation. The default is only used if the current instance count is lower than the default.
     Required.
    :vartype default: str
    """

    _validation = {
        "minimum": {"required": True},
        "maximum": {"required": True},
        "default": {"required": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "str"},
        "maximum": {"key": "maximum", "type": "str"},
        "default": {"key": "default", "type": "str"},
    }

    def __init__(self, *, minimum: str, maximum: str, default: str, **kwargs: Any) -> None:
        """
        :keyword minimum: the minimum number of instances for the resource. Required.
        :paramtype minimum: str
        :keyword maximum: the maximum number of instances for the resource. The actual maximum number
         of instances is limited by the cores that are available in the subscription. Required.
        :paramtype maximum: str
        :keyword default: the number of instances that will be set if metrics are not available for
         evaluation. The default is only used if the current instance count is lower than the default.
         Required.
        :paramtype default: str
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default


class ScaleRule(_serialization.Model):
    """A rule that provide the triggers and parameters for the scaling action.

    All required parameters must be populated in order to send to server.

    :ivar metric_trigger: the trigger that results in a scaling action. Required.
    :vartype metric_trigger: ~azure.mgmt.monitor.models.MetricTrigger
    :ivar scale_action: the parameters for the scaling action. Required.
    :vartype scale_action: ~azure.mgmt.monitor.models.ScaleAction
    """

    _validation = {
        "metric_trigger": {"required": True},
        "scale_action": {"required": True},
    }

    _attribute_map = {
        "metric_trigger": {"key": "metricTrigger", "type": "MetricTrigger"},
        "scale_action": {"key": "scaleAction", "type": "ScaleAction"},
    }

    def __init__(
        self, *, metric_trigger: "_models.MetricTrigger", scale_action: "_models.ScaleAction", **kwargs: Any
    ) -> None:
        """
        :keyword metric_trigger: the trigger that results in a scaling action. Required.
        :paramtype metric_trigger: ~azure.mgmt.monitor.models.MetricTrigger
        :keyword scale_action: the parameters for the scaling action. Required.
        :paramtype scale_action: ~azure.mgmt.monitor.models.ScaleAction
        """
        super().__init__(**kwargs)
        self.metric_trigger = metric_trigger
        self.scale_action = scale_action


class ScaleRuleMetricDimension(_serialization.Model):
    """Specifies an auto scale rule metric dimension.

    All required parameters must be populated in order to send to server.

    :ivar dimension_name: Name of the dimension. Required.
    :vartype dimension_name: str
    :ivar operator: the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals'
     being equal to any of the values. 'NotEquals' being not equal to all of the values. Required.
     Known values are: "Equals" and "NotEquals".
    :vartype operator: str or ~azure.mgmt.monitor.models.ScaleRuleMetricDimensionOperationType
    :ivar values: list of dimension values. For example: ["App1","App2"]. Required.
    :vartype values: list[str]
    """

    _validation = {
        "dimension_name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "dimension_name": {"key": "DimensionName", "type": "str"},
        "operator": {"key": "Operator", "type": "str"},
        "values": {"key": "Values", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        dimension_name: str,
        operator: Union[str, "_models.ScaleRuleMetricDimensionOperationType"],
        values: list[str],
        **kwargs: Any
    ) -> None:
        """
        :keyword dimension_name: Name of the dimension. Required.
        :paramtype dimension_name: str
        :keyword operator: the dimension operator. Only 'Equals' and 'NotEquals' are supported.
         'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values.
         Required. Known values are: "Equals" and "NotEquals".
        :paramtype operator: str or ~azure.mgmt.monitor.models.ScaleRuleMetricDimensionOperationType
        :keyword values: list of dimension values. For example: ["App1","App2"]. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.dimension_name = dimension_name
        self.operator = operator
        self.values = values


class ScheduledQueryRuleCriteria(_serialization.Model):
    """The rule criteria that defines the conditions of the scheduled query rule.

    :ivar all_of: A list of conditions to evaluate against the specified scopes.
    :vartype all_of: list[~azure.mgmt.monitor.models.Condition]
    """

    _attribute_map = {
        "all_of": {"key": "allOf", "type": "[Condition]"},
    }

    def __init__(self, *, all_of: Optional[list["_models.Condition"]] = None, **kwargs: Any) -> None:
        """
        :keyword all_of: A list of conditions to evaluate against the specified scopes.
        :paramtype all_of: list[~azure.mgmt.monitor.models.Condition]
        """
        super().__init__(**kwargs)
        self.all_of = all_of


class ScheduledQueryRuleResource(_serialization.Model):
    """The scheduled query rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.models.IdentityAutoGenerated
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar kind: Indicates the type of scheduled query rule. The default is LogAlert. Known values
     are: "LogAlert" and "LogToMetric".
    :vartype kind: str or ~azure.mgmt.monitor.models.Kind
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :ivar system_data: SystemData of ScheduledQueryRule.
    :vartype system_data: ~azure.mgmt.monitor.models.SystemData
    :ivar created_with_api_version: The api-version used when creating this alert rule.
    :vartype created_with_api_version: str
    :ivar is_legacy_log_analytics_rule: True if alert rule is legacy Log Analytic rule.
    :vartype is_legacy_log_analytics_rule: bool
    :ivar description: The description of the scheduled query rule.
    :vartype description: str
    :ivar display_name: The display name of the alert rule.
    :vartype display_name: str
    :ivar severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
     severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
     3, and 4.
    :vartype severity: int or ~azure.mgmt.monitor.models.AlertSeverity
    :ivar enabled: The flag which indicates whether this scheduled query rule is enabled. Value
     should be true or false.
    :vartype enabled: bool
    :ivar scopes: The list of resource id's that this scheduled query rule is scoped to.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: How often the scheduled query rule is evaluated represented in ISO
     8601 duration format. Relevant and required only for rules of the kind LogAlert.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: The period of time (in ISO 8601 duration format) on which the Alert query
     will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
    :vartype window_size: ~datetime.timedelta
    :ivar override_query_time_range: If specified then overrides the query time range (default is
     WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
    :vartype override_query_time_range: ~datetime.timedelta
    :ivar target_resource_types: List of resource type of the target resource(s) on which the alert
     is created/updated. For example if the scope is a resource group and targetResourceTypes is
     Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
     machine in the resource group which meet the alert criteria. Relevant only for rules of the
     kind LogAlert.
    :vartype target_resource_types: list[str]
    :ivar criteria: The rule criteria that defines the conditions of the scheduled query rule.
    :vartype criteria: ~azure.mgmt.monitor.models.ScheduledQueryRuleCriteria
    :ivar mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601 duration
     format) after the alert is fired. Relevant only for rules of the kind LogAlert.
    :vartype mute_actions_duration: ~datetime.timedelta
    :ivar actions: Actions to invoke when the alert fires.
    :vartype actions: ~azure.mgmt.monitor.models.Actions
    :ivar is_workspace_alerts_storage_configured: The flag which indicates whether this scheduled
     query rule has been configured to be stored in the customer's storage. The default is false.
    :vartype is_workspace_alerts_storage_configured: bool
    :ivar check_workspace_alerts_storage_configured: The flag which indicates whether this
     scheduled query rule should be stored in the customer's storage. The default is false. Relevant
     only for rules of the kind LogAlert.
    :vartype check_workspace_alerts_storage_configured: bool
    :ivar skip_query_validation: The flag which indicates whether the provided query should be
     validated or not. The default is false. Relevant only for rules of the kind LogAlert.
    :vartype skip_query_validation: bool
    :ivar auto_mitigate: The flag that indicates whether the alert should be automatically resolved
     or not. The default is true. Relevant only for rules of the kind LogAlert.
    :vartype auto_mitigate: bool
    :ivar resolve_configuration: Defines the configuration for resolving fired alerts. Relevant
     only for rules of the kind LogAlert.
    :vartype resolve_configuration: ~azure.mgmt.monitor.models.RuleResolveConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "created_with_api_version": {"readonly": True},
        "is_legacy_log_analytics_rule": {"readonly": True},
        "is_workspace_alerts_storage_configured": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityAutoGenerated"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_with_api_version": {"key": "properties.createdWithApiVersion", "type": "str"},
        "is_legacy_log_analytics_rule": {"key": "properties.isLegacyLogAnalyticsRule", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "override_query_time_range": {"key": "properties.overrideQueryTimeRange", "type": "duration"},
        "target_resource_types": {"key": "properties.targetResourceTypes", "type": "[str]"},
        "criteria": {"key": "properties.criteria", "type": "ScheduledQueryRuleCriteria"},
        "mute_actions_duration": {"key": "properties.muteActionsDuration", "type": "duration"},
        "actions": {"key": "properties.actions", "type": "Actions"},
        "is_workspace_alerts_storage_configured": {
            "key": "properties.isWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "check_workspace_alerts_storage_configured": {
            "key": "properties.checkWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "skip_query_validation": {"key": "properties.skipQueryValidation", "type": "bool"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "resolve_configuration": {"key": "properties.resolveConfiguration", "type": "RuleResolveConfiguration"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        identity: Optional["_models.IdentityAutoGenerated"] = None,
        tags: Optional[dict[str, str]] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        severity: Optional[Union[int, "_models.AlertSeverity"]] = None,
        enabled: Optional[bool] = None,
        scopes: Optional[list[str]] = None,
        evaluation_frequency: Optional[datetime.timedelta] = None,
        window_size: Optional[datetime.timedelta] = None,
        override_query_time_range: Optional[datetime.timedelta] = None,
        target_resource_types: Optional[list[str]] = None,
        criteria: Optional["_models.ScheduledQueryRuleCriteria"] = None,
        mute_actions_duration: Optional[datetime.timedelta] = None,
        actions: Optional["_models.Actions"] = None,
        check_workspace_alerts_storage_configured: Optional[bool] = None,
        skip_query_validation: Optional[bool] = None,
        auto_mitigate: Optional[bool] = None,
        resolve_configuration: Optional["_models.RuleResolveConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.models.IdentityAutoGenerated
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword kind: Indicates the type of scheduled query rule. The default is LogAlert. Known
         values are: "LogAlert" and "LogToMetric".
        :paramtype kind: str or ~azure.mgmt.monitor.models.Kind
        :keyword description: The description of the scheduled query rule.
        :paramtype description: str
        :keyword display_name: The display name of the alert rule.
        :paramtype display_name: str
        :keyword severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
         severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
         3, and 4.
        :paramtype severity: int or ~azure.mgmt.monitor.models.AlertSeverity
        :keyword enabled: The flag which indicates whether this scheduled query rule is enabled. Value
         should be true or false.
        :paramtype enabled: bool
        :keyword scopes: The list of resource id's that this scheduled query rule is scoped to.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: How often the scheduled query rule is evaluated represented in
         ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: The period of time (in ISO 8601 duration format) on which the Alert query
         will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
        :paramtype window_size: ~datetime.timedelta
        :keyword override_query_time_range: If specified then overrides the query time range (default
         is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
        :paramtype override_query_time_range: ~datetime.timedelta
        :keyword target_resource_types: List of resource type of the target resource(s) on which the
         alert is created/updated. For example if the scope is a resource group and targetResourceTypes
         is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
         machine in the resource group which meet the alert criteria. Relevant only for rules of the
         kind LogAlert.
        :paramtype target_resource_types: list[str]
        :keyword criteria: The rule criteria that defines the conditions of the scheduled query rule.
        :paramtype criteria: ~azure.mgmt.monitor.models.ScheduledQueryRuleCriteria
        :keyword mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601
         duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
        :paramtype mute_actions_duration: ~datetime.timedelta
        :keyword actions: Actions to invoke when the alert fires.
        :paramtype actions: ~azure.mgmt.monitor.models.Actions
        :keyword check_workspace_alerts_storage_configured: The flag which indicates whether this
         scheduled query rule should be stored in the customer's storage. The default is false. Relevant
         only for rules of the kind LogAlert.
        :paramtype check_workspace_alerts_storage_configured: bool
        :keyword skip_query_validation: The flag which indicates whether the provided query should be
         validated or not. The default is false. Relevant only for rules of the kind LogAlert.
        :paramtype skip_query_validation: bool
        :keyword auto_mitigate: The flag that indicates whether the alert should be automatically
         resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
        :paramtype auto_mitigate: bool
        :keyword resolve_configuration: Defines the configuration for resolving fired alerts. Relevant
         only for rules of the kind LogAlert.
        :paramtype resolve_configuration: ~azure.mgmt.monitor.models.RuleResolveConfiguration
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.identity = identity
        self.tags = tags
        self.location = location
        self.kind = kind
        self.etag: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.created_with_api_version: Optional[str] = None
        self.is_legacy_log_analytics_rule: Optional[bool] = None
        self.description = description
        self.display_name = display_name
        self.severity = severity
        self.enabled = enabled
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.override_query_time_range = override_query_time_range
        self.target_resource_types = target_resource_types
        self.criteria = criteria
        self.mute_actions_duration = mute_actions_duration
        self.actions = actions
        self.is_workspace_alerts_storage_configured: Optional[bool] = None
        self.check_workspace_alerts_storage_configured = check_workspace_alerts_storage_configured
        self.skip_query_validation = skip_query_validation
        self.auto_mitigate = auto_mitigate
        self.resolve_configuration = resolve_configuration


class ScheduledQueryRuleResourceCollection(_serialization.Model):
    """Represents a collection of scheduled query rule resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The values for the scheduled query rule resources.
    :vartype value: list[~azure.mgmt.monitor.models.ScheduledQueryRuleResource]
    :ivar next_link: Provides the link to retrieve the next set of elements.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScheduledQueryRuleResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.ScheduledQueryRuleResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The values for the scheduled query rule resources.
        :paramtype value: list[~azure.mgmt.monitor.models.ScheduledQueryRuleResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ScheduledQueryRuleResourcePatch(_serialization.Model):
    """The scheduled query rule resource for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.models.IdentityAutoGenerated
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar created_with_api_version: The api-version used when creating this alert rule.
    :vartype created_with_api_version: str
    :ivar is_legacy_log_analytics_rule: True if alert rule is legacy Log Analytic rule.
    :vartype is_legacy_log_analytics_rule: bool
    :ivar description: The description of the scheduled query rule.
    :vartype description: str
    :ivar display_name: The display name of the alert rule.
    :vartype display_name: str
    :ivar severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
     severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
     3, and 4.
    :vartype severity: int or ~azure.mgmt.monitor.models.AlertSeverity
    :ivar enabled: The flag which indicates whether this scheduled query rule is enabled. Value
     should be true or false.
    :vartype enabled: bool
    :ivar scopes: The list of resource id's that this scheduled query rule is scoped to.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: How often the scheduled query rule is evaluated represented in ISO
     8601 duration format. Relevant and required only for rules of the kind LogAlert.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: The period of time (in ISO 8601 duration format) on which the Alert query
     will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
    :vartype window_size: ~datetime.timedelta
    :ivar override_query_time_range: If specified then overrides the query time range (default is
     WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
    :vartype override_query_time_range: ~datetime.timedelta
    :ivar target_resource_types: List of resource type of the target resource(s) on which the alert
     is created/updated. For example if the scope is a resource group and targetResourceTypes is
     Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
     machine in the resource group which meet the alert criteria. Relevant only for rules of the
     kind LogAlert.
    :vartype target_resource_types: list[str]
    :ivar criteria: The rule criteria that defines the conditions of the scheduled query rule.
    :vartype criteria: ~azure.mgmt.monitor.models.ScheduledQueryRuleCriteria
    :ivar mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601 duration
     format) after the alert is fired. Relevant only for rules of the kind LogAlert.
    :vartype mute_actions_duration: ~datetime.timedelta
    :ivar actions: Actions to invoke when the alert fires.
    :vartype actions: ~azure.mgmt.monitor.models.Actions
    :ivar is_workspace_alerts_storage_configured: The flag which indicates whether this scheduled
     query rule has been configured to be stored in the customer's storage. The default is false.
    :vartype is_workspace_alerts_storage_configured: bool
    :ivar check_workspace_alerts_storage_configured: The flag which indicates whether this
     scheduled query rule should be stored in the customer's storage. The default is false. Relevant
     only for rules of the kind LogAlert.
    :vartype check_workspace_alerts_storage_configured: bool
    :ivar skip_query_validation: The flag which indicates whether the provided query should be
     validated or not. The default is false. Relevant only for rules of the kind LogAlert.
    :vartype skip_query_validation: bool
    :ivar auto_mitigate: The flag that indicates whether the alert should be automatically resolved
     or not. The default is true. Relevant only for rules of the kind LogAlert.
    :vartype auto_mitigate: bool
    :ivar resolve_configuration: Defines the configuration for resolving fired alerts. Relevant
     only for rules of the kind LogAlert.
    :vartype resolve_configuration: ~azure.mgmt.monitor.models.RuleResolveConfiguration
    """

    _validation = {
        "created_with_api_version": {"readonly": True},
        "is_legacy_log_analytics_rule": {"readonly": True},
        "is_workspace_alerts_storage_configured": {"readonly": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityAutoGenerated"},
        "tags": {"key": "tags", "type": "{str}"},
        "created_with_api_version": {"key": "properties.createdWithApiVersion", "type": "str"},
        "is_legacy_log_analytics_rule": {"key": "properties.isLegacyLogAnalyticsRule", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "override_query_time_range": {"key": "properties.overrideQueryTimeRange", "type": "duration"},
        "target_resource_types": {"key": "properties.targetResourceTypes", "type": "[str]"},
        "criteria": {"key": "properties.criteria", "type": "ScheduledQueryRuleCriteria"},
        "mute_actions_duration": {"key": "properties.muteActionsDuration", "type": "duration"},
        "actions": {"key": "properties.actions", "type": "Actions"},
        "is_workspace_alerts_storage_configured": {
            "key": "properties.isWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "check_workspace_alerts_storage_configured": {
            "key": "properties.checkWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "skip_query_validation": {"key": "properties.skipQueryValidation", "type": "bool"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "resolve_configuration": {"key": "properties.resolveConfiguration", "type": "RuleResolveConfiguration"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityAutoGenerated"] = None,
        tags: Optional[dict[str, str]] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        severity: Optional[Union[int, "_models.AlertSeverity"]] = None,
        enabled: Optional[bool] = None,
        scopes: Optional[list[str]] = None,
        evaluation_frequency: Optional[datetime.timedelta] = None,
        window_size: Optional[datetime.timedelta] = None,
        override_query_time_range: Optional[datetime.timedelta] = None,
        target_resource_types: Optional[list[str]] = None,
        criteria: Optional["_models.ScheduledQueryRuleCriteria"] = None,
        mute_actions_duration: Optional[datetime.timedelta] = None,
        actions: Optional["_models.Actions"] = None,
        check_workspace_alerts_storage_configured: Optional[bool] = None,
        skip_query_validation: Optional[bool] = None,
        auto_mitigate: Optional[bool] = None,
        resolve_configuration: Optional["_models.RuleResolveConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.models.IdentityAutoGenerated
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of the scheduled query rule.
        :paramtype description: str
        :keyword display_name: The display name of the alert rule.
        :paramtype display_name: str
        :keyword severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
         severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
         3, and 4.
        :paramtype severity: int or ~azure.mgmt.monitor.models.AlertSeverity
        :keyword enabled: The flag which indicates whether this scheduled query rule is enabled. Value
         should be true or false.
        :paramtype enabled: bool
        :keyword scopes: The list of resource id's that this scheduled query rule is scoped to.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: How often the scheduled query rule is evaluated represented in
         ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: The period of time (in ISO 8601 duration format) on which the Alert query
         will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
        :paramtype window_size: ~datetime.timedelta
        :keyword override_query_time_range: If specified then overrides the query time range (default
         is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
        :paramtype override_query_time_range: ~datetime.timedelta
        :keyword target_resource_types: List of resource type of the target resource(s) on which the
         alert is created/updated. For example if the scope is a resource group and targetResourceTypes
         is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
         machine in the resource group which meet the alert criteria. Relevant only for rules of the
         kind LogAlert.
        :paramtype target_resource_types: list[str]
        :keyword criteria: The rule criteria that defines the conditions of the scheduled query rule.
        :paramtype criteria: ~azure.mgmt.monitor.models.ScheduledQueryRuleCriteria
        :keyword mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601
         duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
        :paramtype mute_actions_duration: ~datetime.timedelta
        :keyword actions: Actions to invoke when the alert fires.
        :paramtype actions: ~azure.mgmt.monitor.models.Actions
        :keyword check_workspace_alerts_storage_configured: The flag which indicates whether this
         scheduled query rule should be stored in the customer's storage. The default is false. Relevant
         only for rules of the kind LogAlert.
        :paramtype check_workspace_alerts_storage_configured: bool
        :keyword skip_query_validation: The flag which indicates whether the provided query should be
         validated or not. The default is false. Relevant only for rules of the kind LogAlert.
        :paramtype skip_query_validation: bool
        :keyword auto_mitigate: The flag that indicates whether the alert should be automatically
         resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
        :paramtype auto_mitigate: bool
        :keyword resolve_configuration: Defines the configuration for resolving fired alerts. Relevant
         only for rules of the kind LogAlert.
        :paramtype resolve_configuration: ~azure.mgmt.monitor.models.RuleResolveConfiguration
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.created_with_api_version: Optional[str] = None
        self.is_legacy_log_analytics_rule: Optional[bool] = None
        self.description = description
        self.display_name = display_name
        self.severity = severity
        self.enabled = enabled
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.override_query_time_range = override_query_time_range
        self.target_resource_types = target_resource_types
        self.criteria = criteria
        self.mute_actions_duration = mute_actions_duration
        self.actions = actions
        self.is_workspace_alerts_storage_configured: Optional[bool] = None
        self.check_workspace_alerts_storage_configured = check_workspace_alerts_storage_configured
        self.skip_query_validation = skip_query_validation
        self.auto_mitigate = auto_mitigate
        self.resolve_configuration = resolve_configuration


class ScopedResource(ProxyResource):
    """A private link scoped resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar linked_resource_id: The resource id of the scoped Azure monitor resource.
    :vartype linked_resource_id: str
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "linked_resource_id": {"key": "properties.linkedResourceId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, linked_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword linked_resource_id: The resource id of the scoped Azure monitor resource.
        :paramtype linked_resource_id: str
        """
        super().__init__(**kwargs)
        self.linked_resource_id = linked_resource_id
        self.provisioning_state: Optional[str] = None


class ScopedResourceListResult(_serialization.Model):
    """A list of scoped resources in a private link scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.monitor.models.ScopedResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScopedResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[list["_models.ScopedResource"]] = None
        self.next_link: Optional[str] = None


class SenderAuthorization(_serialization.Model):
    """the authorization used by the user who has performed the operation that led to this event. This
    captures the RBAC properties of the event. These usually include the 'action', 'role' and the
    'scope'.

    :ivar action: the permissible actions. For instance: microsoft.support/supporttickets/write.
    :vartype action: str
    :ivar role: the role of the user. For instance: Subscription Admin.
    :vartype role: str
    :ivar scope: the scope.
    :vartype scope: str
    """

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self, *, action: Optional[str] = None, role: Optional[str] = None, scope: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword action: the permissible actions. For instance: microsoft.support/supporttickets/write.
        :paramtype action: str
        :keyword role: the role of the user. For instance: Subscription Admin.
        :paramtype role: str
        :keyword scope: the scope.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.role = role
        self.scope = scope


class ServiceDiagnosticSettingsResource(ResourceAutoGenerated6):
    """Description of a service diagnostic setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
     would like to have Event Hubs created for streaming Diagnostic Logs. The rule ID is of the
     format: '{service bus resource ID}/authorizationrules/{key name}'.
    :vartype service_bus_rule_id: str
    :ivar event_hub_authorization_rule_id: The resource Id for the event hub namespace
     authorization rule.
    :vartype event_hub_authorization_rule_id: str
    :ivar metrics: the list of metric settings.
    :vartype metrics: list[~azure.mgmt.monitor.models.MetricSettingsAutoGenerated]
    :ivar logs: the list of logs settings.
    :vartype logs: list[~azure.mgmt.monitor.models.LogSettingsAutoGenerated]
    :ivar workspace_id: The workspace ID (resource ID of a Log Analytics workspace) for a Log
     Analytics workspace to which you would like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "service_bus_rule_id": {"key": "properties.serviceBusRuleId", "type": "str"},
        "event_hub_authorization_rule_id": {"key": "properties.eventHubAuthorizationRuleId", "type": "str"},
        "metrics": {"key": "properties.metrics", "type": "[MetricSettingsAutoGenerated]"},
        "logs": {"key": "properties.logs", "type": "[LogSettingsAutoGenerated]"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        event_hub_authorization_rule_id: Optional[str] = None,
        metrics: Optional[list["_models.MetricSettingsAutoGenerated"]] = None,
        logs: Optional[list["_models.LogSettingsAutoGenerated"]] = None,
        workspace_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
         would like to have Event Hubs created for streaming Diagnostic Logs. The rule ID is of the
         format: '{service bus resource ID}/authorizationrules/{key name}'.
        :paramtype service_bus_rule_id: str
        :keyword event_hub_authorization_rule_id: The resource Id for the event hub namespace
         authorization rule.
        :paramtype event_hub_authorization_rule_id: str
        :keyword metrics: the list of metric settings.
        :paramtype metrics: list[~azure.mgmt.monitor.models.MetricSettingsAutoGenerated]
        :keyword logs: the list of logs settings.
        :paramtype logs: list[~azure.mgmt.monitor.models.LogSettingsAutoGenerated]
        :keyword workspace_id: The workspace ID (resource ID of a Log Analytics workspace) for a Log
         Analytics workspace to which you would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.event_hub_authorization_rule_id = event_hub_authorization_rule_id
        self.metrics = metrics
        self.logs = logs
        self.workspace_id = workspace_id


class ServiceDiagnosticSettingsResourcePatch(_serialization.Model):
    """Service diagnostic setting resource for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
     would like to have Event Hubs created for streaming Diagnostic Logs. The rule ID is of the
     format: '{service bus resource ID}/authorizationrules/{key name}'.
    :vartype service_bus_rule_id: str
    :ivar event_hub_authorization_rule_id: The resource Id for the event hub namespace
     authorization rule.
    :vartype event_hub_authorization_rule_id: str
    :ivar metrics: the list of metric settings.
    :vartype metrics: list[~azure.mgmt.monitor.models.MetricSettingsAutoGenerated]
    :ivar logs: the list of logs settings.
    :vartype logs: list[~azure.mgmt.monitor.models.LogSettingsAutoGenerated]
    :ivar workspace_id: The workspace ID (resource ID of a Log Analytics workspace) for a Log
     Analytics workspace to which you would like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "service_bus_rule_id": {"key": "properties.serviceBusRuleId", "type": "str"},
        "event_hub_authorization_rule_id": {"key": "properties.eventHubAuthorizationRuleId", "type": "str"},
        "metrics": {"key": "properties.metrics", "type": "[MetricSettingsAutoGenerated]"},
        "logs": {"key": "properties.logs", "type": "[LogSettingsAutoGenerated]"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        event_hub_authorization_rule_id: Optional[str] = None,
        metrics: Optional[list["_models.MetricSettingsAutoGenerated"]] = None,
        logs: Optional[list["_models.LogSettingsAutoGenerated"]] = None,
        workspace_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
         would like to have Event Hubs created for streaming Diagnostic Logs. The rule ID is of the
         format: '{service bus resource ID}/authorizationrules/{key name}'.
        :paramtype service_bus_rule_id: str
        :keyword event_hub_authorization_rule_id: The resource Id for the event hub namespace
         authorization rule.
        :paramtype event_hub_authorization_rule_id: str
        :keyword metrics: the list of metric settings.
        :paramtype metrics: list[~azure.mgmt.monitor.models.MetricSettingsAutoGenerated]
        :keyword logs: the list of logs settings.
        :paramtype logs: list[~azure.mgmt.monitor.models.LogSettingsAutoGenerated]
        :keyword workspace_id: The workspace ID (resource ID of a Log Analytics workspace) for a Log
         Analytics workspace to which you would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.event_hub_authorization_rule_id = event_hub_authorization_rule_id
        self.metrics = metrics
        self.logs = logs
        self.workspace_id = workspace_id


class SingleBaseline(_serialization.Model):
    """The baseline values for a single sensitivity value.

    All required parameters must be populated in order to send to server.

    :ivar sensitivity: the sensitivity of the baseline. Required. Known values are: "Low",
     "Medium", and "High".
    :vartype sensitivity: str or ~azure.mgmt.monitor.models.BaselineSensitivity
    :ivar low_thresholds: The low thresholds of the baseline. Required.
    :vartype low_thresholds: list[float]
    :ivar high_thresholds: The high thresholds of the baseline. Required.
    :vartype high_thresholds: list[float]
    """

    _validation = {
        "sensitivity": {"required": True},
        "low_thresholds": {"required": True},
        "high_thresholds": {"required": True},
    }

    _attribute_map = {
        "sensitivity": {"key": "sensitivity", "type": "str"},
        "low_thresholds": {"key": "lowThresholds", "type": "[float]"},
        "high_thresholds": {"key": "highThresholds", "type": "[float]"},
    }

    def __init__(
        self,
        *,
        sensitivity: Union[str, "_models.BaselineSensitivity"],
        low_thresholds: list[float],
        high_thresholds: list[float],
        **kwargs: Any
    ) -> None:
        """
        :keyword sensitivity: the sensitivity of the baseline. Required. Known values are: "Low",
         "Medium", and "High".
        :paramtype sensitivity: str or ~azure.mgmt.monitor.models.BaselineSensitivity
        :keyword low_thresholds: The low thresholds of the baseline. Required.
        :paramtype low_thresholds: list[float]
        :keyword high_thresholds: The high thresholds of the baseline. Required.
        :paramtype high_thresholds: list[float]
        """
        super().__init__(**kwargs)
        self.sensitivity = sensitivity
        self.low_thresholds = low_thresholds
        self.high_thresholds = high_thresholds


class SingleMetricBaseline(_serialization.Model):
    """The baseline results of a single metric.

    All required parameters must be populated in order to send to server.

    :ivar id: The metric baseline Id. Required.
    :vartype id: str
    :ivar type: The resource type of the metric baseline resource. Required.
    :vartype type: str
    :ivar name: The name of the metric for which the baselines were retrieved. Required.
    :vartype name: str
    :ivar timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested. Required.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in.  This may
     be adjusted in the future and returned back from what was originally requested.  This is not
     present if a metadata request was made. Required.
    :vartype interval: ~datetime.timedelta
    :ivar namespace: The namespace of the metrics been queried.
    :vartype namespace: str
    :ivar baselines: The baseline for each time series that was queried. Required.
    :vartype baselines: list[~azure.mgmt.monitor.models.TimeSeriesBaseline]
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "name": {"required": True},
        "timespan": {"required": True},
        "interval": {"required": True},
        "baselines": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "timespan": {"key": "properties.timespan", "type": "str"},
        "interval": {"key": "properties.interval", "type": "duration"},
        "namespace": {"key": "properties.namespace", "type": "str"},
        "baselines": {"key": "properties.baselines", "type": "[TimeSeriesBaseline]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: str,
        name: str,
        timespan: str,
        interval: datetime.timedelta,
        baselines: list["_models.TimeSeriesBaseline"],
        namespace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The metric baseline Id. Required.
        :paramtype id: str
        :keyword type: The resource type of the metric baseline resource. Required.
        :paramtype type: str
        :keyword name: The name of the metric for which the baselines were retrieved. Required.
        :paramtype name: str
        :keyword timespan: The timespan for which the data was retrieved. Its value consists of two
         datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
         from what was originally requested. Required.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in.  This
         may be adjusted in the future and returned back from what was originally requested.  This is
         not present if a metadata request was made. Required.
        :paramtype interval: ~datetime.timedelta
        :keyword namespace: The namespace of the metrics been queried.
        :paramtype namespace: str
        :keyword baselines: The baseline for each time series that was queried. Required.
        :paramtype baselines: list[~azure.mgmt.monitor.models.TimeSeriesBaseline]
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.timespan = timespan
        self.interval = interval
        self.namespace = namespace
        self.baselines = baselines


class SinkConfiguration(_serialization.Model):
    """SinkConfiguration.

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Known values are: "EventHub", "ApplicationInsights", and "LogAnalytics".
    :vartype kind: str or ~azure.mgmt.monitor.models.SinkConfigurationKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Union[str, "_models.SinkConfigurationKind"], **kwargs: Any) -> None:
        """
        :keyword kind: Required. Known values are: "EventHub", "ApplicationInsights", and
         "LogAnalytics".
        :paramtype kind: str or ~azure.mgmt.monitor.models.SinkConfigurationKind
        """
        super().__init__(**kwargs)
        self.kind = kind


class SmsReceiver(_serialization.Model):
    """An SMS receiver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the SMS receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar country_code: The country code of the SMS receiver. Required.
    :vartype country_code: str
    :ivar phone_number: The phone number of the SMS receiver. Required.
    :vartype phone_number: str
    :ivar status: The status of the receiver. Known values are: "NotSpecified", "Enabled", and
     "Disabled".
    :vartype status: str or ~azure.mgmt.monitor.models.ReceiverStatus
    """

    _validation = {
        "name": {"required": True},
        "country_code": {"required": True},
        "phone_number": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, name: str, country_code: str, phone_number: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the SMS receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword country_code: The country code of the SMS receiver. Required.
        :paramtype country_code: str
        :keyword phone_number: The phone number of the SMS receiver. Required.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.country_code = country_code
        self.phone_number = phone_number
        self.status: Optional[Union[str, "_models.ReceiverStatus"]] = None


class StaticPromQLCriteria(MultiPromQLCriteria):
    """The criterion for static prom query.

    All required parameters must be populated in order to send to server.

    :ivar criterion_type: Specifies the type of threshold criteria. Previously undocumented values
     might be returned. Required. Known values are: "StaticThresholdCriterion" and
     "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~azure.mgmt.monitor.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar query: The query used to evaluate the alert rule. Required.
    :vartype query: str
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "query": {"required": True},
    }

    _attribute_map = {
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, name: str, query: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword query: The query used to evaluate the alert rule. Required.
        :paramtype query: str
        """
        super().__init__(name=name, query=query, **kwargs)
        self.criterion_type: str = "StaticThresholdCriterion"


class StorageBlob(_serialization.Model):
    """StorageBlob.

    :ivar resource_id: Resource Id of the storage account that hosts the blob.
    :vartype resource_id: str
    :ivar blob_url: Url of the storage blob.
    :vartype blob_url: str
    :ivar lookup_type: The type of lookup to perform on the blob. Known values are: "String" and
     "Cidr".
    :vartype lookup_type: str or ~azure.mgmt.monitor.models.KnownStorageBlobLookupType
    :ivar name: The name of the enrichment data source used as an alias when referencing this data
     source in data flows.
    :vartype name: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "blob_url": {"key": "blobUrl", "type": "str"},
        "lookup_type": {"key": "lookupType", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        blob_url: Optional[str] = None,
        lookup_type: Optional[Union[str, "_models.KnownStorageBlobLookupType"]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Resource Id of the storage account that hosts the blob.
        :paramtype resource_id: str
        :keyword blob_url: Url of the storage blob.
        :paramtype blob_url: str
        :keyword lookup_type: The type of lookup to perform on the blob. Known values are: "String" and
         "Cidr".
        :paramtype lookup_type: str or ~azure.mgmt.monitor.models.KnownStorageBlobLookupType
        :keyword name: The name of the enrichment data source used as an alias when referencing this
         data source in data flows.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.blob_url = blob_url
        self.lookup_type = lookup_type
        self.name = name


class StorageBlobDestination(_serialization.Model):
    """StorageBlobDestination.

    :ivar container_name: The container name of the Storage Blob.
    :vartype container_name: str
    :ivar storage_account_resource_id: The resource ID of the storage account.
    :vartype storage_account_resource_id: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "container_name": {"key": "containerName", "type": "str"},
        "storage_account_resource_id": {"key": "storageAccountResourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        storage_account_resource_id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: The container name of the Storage Blob.
        :paramtype container_name: str
        :keyword storage_account_resource_id: The resource ID of the storage account.
        :paramtype storage_account_resource_id: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.container_name = container_name
        self.storage_account_resource_id = storage_account_resource_id
        self.name = name


class StorageTableDestination(_serialization.Model):
    """StorageTableDestination.

    :ivar table_name: The name of the Storage Table.
    :vartype table_name: str
    :ivar storage_account_resource_id: The resource ID of the storage account.
    :vartype storage_account_resource_id: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "storage_account_resource_id": {"key": "storageAccountResourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        storage_account_resource_id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: The name of the Storage Table.
        :paramtype table_name: str
        :keyword storage_account_resource_id: The resource ID of the storage account.
        :paramtype storage_account_resource_id: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.storage_account_resource_id = storage_account_resource_id
        self.name = name


class StreamDeclaration(_serialization.Model):
    """Declaration of a custom stream.

    :ivar columns: List of columns used by data in this stream.
    :vartype columns: list[~azure.mgmt.monitor.models.ColumnDefinition]
    """

    _attribute_map = {
        "columns": {"key": "columns", "type": "[ColumnDefinition]"},
    }

    def __init__(self, *, columns: Optional[list["_models.ColumnDefinition"]] = None, **kwargs: Any) -> None:
        """
        :keyword columns: List of columns used by data in this stream.
        :paramtype columns: list[~azure.mgmt.monitor.models.ColumnDefinition]
        """
        super().__init__(**kwargs)
        self.columns = columns


class SubscriptionProxyOnlyResource(_serialization.Model):
    """A proxy only azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location


class SubscriptionDiagnosticSettingsResource(SubscriptionProxyOnlyResource):
    """The subscription diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :vartype service_bus_rule_id: str
    :ivar event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :vartype event_hub_authorization_rule_id: str
    :ivar event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :vartype event_hub_name: str
    :ivar logs: The list of logs settings.
    :vartype logs: list[~azure.mgmt.monitor.models.SubscriptionLogSettings]
    :ivar workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "service_bus_rule_id": {"key": "properties.serviceBusRuleId", "type": "str"},
        "event_hub_authorization_rule_id": {"key": "properties.eventHubAuthorizationRuleId", "type": "str"},
        "event_hub_name": {"key": "properties.eventHubName", "type": "str"},
        "logs": {"key": "properties.logs", "type": "[SubscriptionLogSettings]"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        event_hub_authorization_rule_id: Optional[str] = None,
        event_hub_name: Optional[str] = None,
        logs: Optional[list["_models.SubscriptionLogSettings"]] = None,
        workspace_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here
         to maintain backwards compatibility.
        :paramtype service_bus_rule_id: str
        :keyword event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
        :paramtype event_hub_authorization_rule_id: str
        :keyword event_hub_name: The name of the event hub. If none is specified, the default event hub
         will be selected.
        :paramtype event_hub_name: str
        :keyword logs: The list of logs settings.
        :paramtype logs: list[~azure.mgmt.monitor.models.SubscriptionLogSettings]
        :keyword workspace_id: The full ARM resource ID of the Log Analytics workspace to which you
         would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        """
        super().__init__(location=location, **kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.event_hub_authorization_rule_id = event_hub_authorization_rule_id
        self.event_hub_name = event_hub_name
        self.logs = logs
        self.workspace_id = workspace_id


class SubscriptionDiagnosticSettingsResourceCollection(_serialization.Model):  # pylint: disable=name-too-long
    """Represents a collection of subscription diagnostic settings resources.

    :ivar value: The collection of subscription diagnostic settings resources.
    :vartype value: list[~azure.mgmt.monitor.models.SubscriptionDiagnosticSettingsResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SubscriptionDiagnosticSettingsResource]"},
    }

    def __init__(
        self, *, value: Optional[list["_models.SubscriptionDiagnosticSettingsResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection of subscription diagnostic settings resources.
        :paramtype value: list[~azure.mgmt.monitor.models.SubscriptionDiagnosticSettingsResource]
        """
        super().__init__(**kwargs)
        self.value = value


class SubscriptionLogSettings(_serialization.Model):
    """Part of Subscription diagnostic setting. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to server.

    :ivar category: Name of a Subscription Diagnostic Log category for a resource type this setting
     is applied to.
    :vartype category: str
    :ivar enabled: a value indicating whether this log is enabled. Required.
    :vartype enabled: bool
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: bool, category: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword category: Name of a Subscription Diagnostic Log category for a resource type this
         setting is applied to.
        :paramtype category: str
        :keyword enabled: a value indicating whether this log is enabled. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.category = category
        self.enabled = enabled


class SubscriptionScopeMetricDefinition(_serialization.Model):
    """Metric definition class specifies the metadata for a metric.

    :ivar is_dimension_required: Flag to indicate whether the dimension is required.
    :vartype is_dimension_required: bool
    :ivar resource_id: The resource identifier of the resource that emitted the metric.
    :vartype resource_id: str
    :ivar namespace: The namespace the metric belongs to.
    :vartype namespace: str
    :ivar name: The name and the display name of the metric, i.e. it is a localizable string.
    :vartype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar category: Custom category name for this metric.
    :vartype category: str
    :ivar metric_class: The class of the metric. Known values are: "Availability", "Transactions",
     "Errors", "Latency", and "Saturation".
    :vartype metric_class: str or ~azure.mgmt.monitor.models.MetricClass
    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.mgmt.monitor.models.MetricUnit
    :ivar primary_aggregation_type: The primary aggregation type value defining how to use the
     values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype primary_aggregation_type: str or ~azure.mgmt.monitor.models.MetricAggregationType
    :ivar supported_aggregation_types: The collection of what aggregation types are supported.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.monitor.models.MetricAggregationType]
    :ivar metric_availabilities: The collection of what aggregation intervals are available to be
     queried.
    :vartype metric_availabilities: list[~azure.mgmt.monitor.models.MetricAvailability]
    :ivar id: The resource identifier of the metric definition.
    :vartype id: str
    :ivar dimensions: The name and the display name of the dimension, i.e. it is a localizable
     string.
    :vartype dimensions: list[~azure.mgmt.monitor.models.LocalizableStringAutoGenerated]
    """

    _attribute_map = {
        "is_dimension_required": {"key": "isDimensionRequired", "type": "bool"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "name": {"key": "name", "type": "LocalizableStringAutoGenerated"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "metric_class": {"key": "metricClass", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "primary_aggregation_type": {"key": "primaryAggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "metric_availabilities": {"key": "metricAvailabilities", "type": "[MetricAvailability]"},
        "id": {"key": "id", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[LocalizableStringAutoGenerated]"},
    }

    def __init__(
        self,
        *,
        is_dimension_required: Optional[bool] = None,
        resource_id: Optional[str] = None,
        namespace: Optional[str] = None,
        name: Optional["_models.LocalizableStringAutoGenerated"] = None,
        display_description: Optional[str] = None,
        category: Optional[str] = None,
        metric_class: Optional[Union[str, "_models.MetricClass"]] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        primary_aggregation_type: Optional[Union[str, "_models.MetricAggregationType"]] = None,
        supported_aggregation_types: Optional[list[Union[str, "_models.MetricAggregationType"]]] = None,
        metric_availabilities: Optional[list["_models.MetricAvailability"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        dimensions: Optional[list["_models.LocalizableStringAutoGenerated"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_dimension_required: Flag to indicate whether the dimension is required.
        :paramtype is_dimension_required: bool
        :keyword resource_id: The resource identifier of the resource that emitted the metric.
        :paramtype resource_id: str
        :keyword namespace: The namespace the metric belongs to.
        :paramtype namespace: str
        :keyword name: The name and the display name of the metric, i.e. it is a localizable string.
        :paramtype name: ~azure.mgmt.monitor.models.LocalizableStringAutoGenerated
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword category: Custom category name for this metric.
        :paramtype category: str
        :keyword metric_class: The class of the metric. Known values are: "Availability",
         "Transactions", "Errors", "Latency", and "Saturation".
        :paramtype metric_class: str or ~azure.mgmt.monitor.models.MetricClass
        :keyword unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
        :paramtype unit: str or ~azure.mgmt.monitor.models.MetricUnit
        :keyword primary_aggregation_type: The primary aggregation type value defining how to use the
         values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype primary_aggregation_type: str or ~azure.mgmt.monitor.models.MetricAggregationType
        :keyword supported_aggregation_types: The collection of what aggregation types are supported.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.monitor.models.MetricAggregationType]
        :keyword metric_availabilities: The collection of what aggregation intervals are available to
         be queried.
        :paramtype metric_availabilities: list[~azure.mgmt.monitor.models.MetricAvailability]
        :keyword id: The resource identifier of the metric definition.
        :paramtype id: str
        :keyword dimensions: The name and the display name of the dimension, i.e. it is a localizable
         string.
        :paramtype dimensions: list[~azure.mgmt.monitor.models.LocalizableStringAutoGenerated]
        """
        super().__init__(**kwargs)
        self.is_dimension_required = is_dimension_required
        self.resource_id = resource_id
        self.namespace = namespace
        self.name = name
        self.display_description = display_description
        self.category = category
        self.metric_class = metric_class
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_availabilities = metric_availabilities
        self.id = id
        self.dimensions = dimensions


class SubscriptionScopeMetricDefinitionCollection(_serialization.Model):  # pylint: disable=name-too-long
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to server.

    :ivar value: The values for the metric definitions. Required.
    :vartype value: list[~azure.mgmt.monitor.models.SubscriptionScopeMetricDefinition]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SubscriptionScopeMetricDefinition]"},
    }

    def __init__(self, *, value: list["_models.SubscriptionScopeMetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: The values for the metric definitions. Required.
        :paramtype value: list[~azure.mgmt.monitor.models.SubscriptionScopeMetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value


class SubscriptionScopeMetricsRequestBodyParameters(_serialization.Model):  # pylint: disable=name-too-long
    """Query parameters can also be specified in the body, specifying the same parameter in both the
    body and query parameters will result in an error.

    :ivar timespan: The timespan of the query. It is a string with the following format
     'startDateTime_ISO/endDateTime_ISO'.
    :vartype timespan: str
    :ivar interval: The interval (i.e. timegrain) of the query in ISO 8601 duration format.
     Defaults to PT1M. Special case for 'FULL' value that returns single datapoint for entire time
     span requested.
     *Examples: PT15M, PT1H, P1D, FULL*.
    :vartype interval: str
    :ivar metric_names: The names of the metrics (comma separated) to retrieve.
    :vartype metric_names: str
    :ivar aggregation: The list of aggregation types (comma separated) to retrieve.
    :vartype aggregation: str
    :ivar filter: The **$filter** is used to reduce the set of metric data returned.\\
     :code:`<br>`Example:\\ :code:`<br>`Metric contains metadata A, B and C.\\ :code:`<br>`- Return
     all time series of C where A = a1 and B = b1 or b2\\ :code:`<br>`\\ **$filter=A eq ‘a1’ and B
     eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**\\ :code:`<br>`- Invalid variant:\\ :code:`<br>`\\
     **$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**\\ :code:`<br>`This is invalid
     because the logical or operator cannot separate two different metadata names.\\ :code:`<br>`-
     Return all time series where A = a1, B = b1 and C = c1:\\ :code:`<br>`\\ **$filter=A eq ‘a1’
     and B eq ‘b1’ and C eq ‘c1’**\\ :code:`<br>`- Return all time series where A = a1\\
     :code:`<br>`\\ **$filter=A eq ‘a1’ and B eq ‘\\ *’ and C eq ‘*\\ ’**.
    :vartype filter: str
    :ivar top: The maximum number of records to retrieve.
     Valid only if $filter is specified.
     Defaults to 10.
    :vartype top: int
    :ivar order_by: The aggregation to use for sorting results and the direction of the sort.
     Only one order can be specified.
     Examples: sum asc.
    :vartype order_by: str
    :ivar roll_up_by: Dimension name(s) to rollup results by. For example if you only want to see
     metric values with a filter like 'City eq Seattle or City eq Tacoma' but don't want to see
     separate values for each city, you can specify 'RollUpBy=City' to see the results for Seattle
     and Tacoma rolled up into one timeseries.
    :vartype roll_up_by: str
    :ivar result_type: Reduces the set of data collected. The syntax allowed depends on the
     operation. See the operation's description for details. Known values are: "Data" and
     "Metadata".
    :vartype result_type: str or ~azure.mgmt.monitor.models.MetricResultType
    :ivar metric_namespace: Metric namespace where the metrics you want reside.
    :vartype metric_namespace: str
    :ivar auto_adjust_timegrain: When set to true, if the timespan passed in is not supported by
     this metric, the API will return the result using the closest supported timespan. When set to
     false, an error is returned for invalid timespan parameters. Defaults to false.
    :vartype auto_adjust_timegrain: bool
    :ivar validate_dimensions: When set to false, invalid filter parameter values will be ignored.
     When set to true, an error is returned for invalid filter parameters. Defaults to true.
    :vartype validate_dimensions: bool
    """

    _attribute_map = {
        "timespan": {"key": "timespan", "type": "str"},
        "interval": {"key": "interval", "type": "str"},
        "metric_names": {"key": "metricNames", "type": "str"},
        "aggregation": {"key": "aggregation", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
        "top": {"key": "top", "type": "int"},
        "order_by": {"key": "orderBy", "type": "str"},
        "roll_up_by": {"key": "rollUpBy", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "auto_adjust_timegrain": {"key": "autoAdjustTimegrain", "type": "bool"},
        "validate_dimensions": {"key": "validateDimensions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        timespan: Optional[str] = None,
        interval: Optional[str] = None,
        metric_names: Optional[str] = None,
        aggregation: Optional[str] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        top: Optional[int] = None,
        order_by: Optional[str] = None,
        roll_up_by: Optional[str] = None,
        result_type: Optional[Union[str, "_models.MetricResultType"]] = None,
        metric_namespace: Optional[str] = None,
        auto_adjust_timegrain: Optional[bool] = None,
        validate_dimensions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timespan: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'.
        :paramtype timespan: str
        :keyword interval: The interval (i.e. timegrain) of the query in ISO 8601 duration format.
         Defaults to PT1M. Special case for 'FULL' value that returns single datapoint for entire time
         span requested.
         *Examples: PT15M, PT1H, P1D, FULL*.
        :paramtype interval: str
        :keyword metric_names: The names of the metrics (comma separated) to retrieve.
        :paramtype metric_names: str
        :keyword aggregation: The list of aggregation types (comma separated) to retrieve.
        :paramtype aggregation: str
        :keyword filter: The **$filter** is used to reduce the set of metric data returned.\\
         :code:`<br>`Example:\\ :code:`<br>`Metric contains metadata A, B and C.\\ :code:`<br>`- Return
         all time series of C where A = a1 and B = b1 or b2\\ :code:`<br>`\\ **$filter=A eq ‘a1’ and B
         eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**\\ :code:`<br>`- Invalid variant:\\ :code:`<br>`\\
         **$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**\\ :code:`<br>`This is invalid
         because the logical or operator cannot separate two different metadata names.\\ :code:`<br>`-
         Return all time series where A = a1, B = b1 and C = c1:\\ :code:`<br>`\\ **$filter=A eq ‘a1’
         and B eq ‘b1’ and C eq ‘c1’**\\ :code:`<br>`- Return all time series where A = a1\\
         :code:`<br>`\\ **$filter=A eq ‘a1’ and B eq ‘\\ *’ and C eq ‘*\\ ’**.
        :paramtype filter: str
        :keyword top: The maximum number of records to retrieve.
         Valid only if $filter is specified.
         Defaults to 10.
        :paramtype top: int
        :keyword order_by: The aggregation to use for sorting results and the direction of the sort.
         Only one order can be specified.
         Examples: sum asc.
        :paramtype order_by: str
        :keyword roll_up_by: Dimension name(s) to rollup results by. For example if you only want to
         see metric values with a filter like 'City eq Seattle or City eq Tacoma' but don't want to see
         separate values for each city, you can specify 'RollUpBy=City' to see the results for Seattle
         and Tacoma rolled up into one timeseries.
        :paramtype roll_up_by: str
        :keyword result_type: Reduces the set of data collected. The syntax allowed depends on the
         operation. See the operation's description for details. Known values are: "Data" and
         "Metadata".
        :paramtype result_type: str or ~azure.mgmt.monitor.models.MetricResultType
        :keyword metric_namespace: Metric namespace where the metrics you want reside.
        :paramtype metric_namespace: str
        :keyword auto_adjust_timegrain: When set to true, if the timespan passed in is not supported by
         this metric, the API will return the result using the closest supported timespan. When set to
         false, an error is returned for invalid timespan parameters. Defaults to false.
        :paramtype auto_adjust_timegrain: bool
        :keyword validate_dimensions: When set to false, invalid filter parameter values will be
         ignored. When set to true, an error is returned for invalid filter parameters. Defaults to
         true.
        :paramtype validate_dimensions: bool
        """
        super().__init__(**kwargs)
        self.timespan = timespan
        self.interval = interval
        self.metric_names = metric_names
        self.aggregation = aggregation
        self.filter = filter
        self.top = top
        self.order_by = order_by
        self.roll_up_by = roll_up_by
        self.result_type = result_type
        self.metric_namespace = metric_namespace
        self.auto_adjust_timegrain = auto_adjust_timegrain
        self.validate_dimensions = validate_dimensions


class SyslogDataSource(_serialization.Model):
    """Definition of which syslog data will be collected and how it will be collected.
    Only collected from Linux machines.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or ~azure.mgmt.monitor.models.KnownSyslogDataSourceStreams]
    :ivar facility_names: The list of facility names.
    :vartype facility_names: list[str or
     ~azure.mgmt.monitor.models.KnownSyslogDataSourceFacilityNames]
    :ivar log_levels: The log levels to collect.
    :vartype log_levels: list[str or ~azure.mgmt.monitor.models.KnownSyslogDataSourceLogLevels]
    :ivar transform_kql: The KQL query to transform the data source.
    :vartype transform_kql: str
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "facility_names": {"key": "facilityNames", "type": "[str]"},
        "log_levels": {"key": "logLevels", "type": "[str]"},
        "transform_kql": {"key": "transformKql", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: Optional[list[Union[str, "_models.KnownSyslogDataSourceStreams"]]] = None,
        facility_names: Optional[list[Union[str, "_models.KnownSyslogDataSourceFacilityNames"]]] = None,
        log_levels: Optional[list[Union[str, "_models.KnownSyslogDataSourceLogLevels"]]] = None,
        transform_kql: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or ~azure.mgmt.monitor.models.KnownSyslogDataSourceStreams]
        :keyword facility_names: The list of facility names.
        :paramtype facility_names: list[str or
         ~azure.mgmt.monitor.models.KnownSyslogDataSourceFacilityNames]
        :keyword log_levels: The log levels to collect.
        :paramtype log_levels: list[str or ~azure.mgmt.monitor.models.KnownSyslogDataSourceLogLevels]
        :keyword transform_kql: The KQL query to transform the data source.
        :paramtype transform_kql: str
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.facility_names = facility_names
        self.log_levels = log_levels
        self.transform_kql = transform_kql
        self.name = name


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a
    PrivateLinkScope instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TestNotificationDetailsResponse(_serialization.Model):
    """The details of the test notification results.

    All required parameters must be populated in order to send to server.

    :ivar context: The context info.
    :vartype context: ~azure.mgmt.monitor.models.Context
    :ivar state: The overall state. Required.
    :vartype state: str
    :ivar completed_time: The completed time.
    :vartype completed_time: str
    :ivar created_time: The created time.
    :vartype created_time: str
    :ivar action_details: The list of action detail.
    :vartype action_details: list[~azure.mgmt.monitor.models.ActionDetail]
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "context": {"key": "context", "type": "Context"},
        "state": {"key": "state", "type": "str"},
        "completed_time": {"key": "completedTime", "type": "str"},
        "created_time": {"key": "createdTime", "type": "str"},
        "action_details": {"key": "actionDetails", "type": "[ActionDetail]"},
    }

    def __init__(
        self,
        *,
        state: str,
        context: Optional["_models.Context"] = None,
        completed_time: Optional[str] = None,
        created_time: Optional[str] = None,
        action_details: Optional[list["_models.ActionDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword context: The context info.
        :paramtype context: ~azure.mgmt.monitor.models.Context
        :keyword state: The overall state. Required.
        :paramtype state: str
        :keyword completed_time: The completed time.
        :paramtype completed_time: str
        :keyword created_time: The created time.
        :paramtype created_time: str
        :keyword action_details: The list of action detail.
        :paramtype action_details: list[~azure.mgmt.monitor.models.ActionDetail]
        """
        super().__init__(**kwargs)
        self.context = context
        self.state = state
        self.completed_time = completed_time
        self.created_time = created_time
        self.action_details = action_details


class TimeSeriesBaseline(_serialization.Model):
    """The baseline values for a single time series.

    All required parameters must be populated in order to send to server.

    :ivar aggregation: The aggregation type of the metric. Required.
    :vartype aggregation: str
    :ivar dimensions: The dimensions of this time series.
    :vartype dimensions: list[~azure.mgmt.monitor.models.MetricSingleDimension]
    :ivar timestamps: The list of timestamps of the baselines. Required.
    :vartype timestamps: list[~datetime.datetime]
    :ivar data: The baseline values for each sensitivity. Required.
    :vartype data: list[~azure.mgmt.monitor.models.SingleBaseline]
    :ivar metadata_values: The baseline metadata values.
    :vartype metadata_values: list[~azure.mgmt.monitor.models.BaselineMetadata]
    """

    _validation = {
        "aggregation": {"required": True},
        "timestamps": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "aggregation": {"key": "aggregation", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricSingleDimension]"},
        "timestamps": {"key": "timestamps", "type": "[iso-8601]"},
        "data": {"key": "data", "type": "[SingleBaseline]"},
        "metadata_values": {"key": "metadataValues", "type": "[BaselineMetadata]"},
    }

    def __init__(
        self,
        *,
        aggregation: str,
        timestamps: list[datetime.datetime],
        data: list["_models.SingleBaseline"],
        dimensions: Optional[list["_models.MetricSingleDimension"]] = None,
        metadata_values: Optional[list["_models.BaselineMetadata"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword aggregation: The aggregation type of the metric. Required.
        :paramtype aggregation: str
        :keyword dimensions: The dimensions of this time series.
        :paramtype dimensions: list[~azure.mgmt.monitor.models.MetricSingleDimension]
        :keyword timestamps: The list of timestamps of the baselines. Required.
        :paramtype timestamps: list[~datetime.datetime]
        :keyword data: The baseline values for each sensitivity. Required.
        :paramtype data: list[~azure.mgmt.monitor.models.SingleBaseline]
        :keyword metadata_values: The baseline metadata values.
        :paramtype metadata_values: list[~azure.mgmt.monitor.models.BaselineMetadata]
        """
        super().__init__(**kwargs)
        self.aggregation = aggregation
        self.dimensions = dimensions
        self.timestamps = timestamps
        self.data = data
        self.metadata_values = metadata_values


class TimeSeriesElement(_serialization.Model):
    """A time series result type. The discriminator value is always TimeSeries in this case.

    :ivar metadatavalues: The metadata values returned if $filter was specified in the call.
    :vartype metadatavalues: list[~azure.mgmt.monitor.models.MetadataValue]
    :ivar data: An array of data points representing the metric values.  This is only returned if a
     result type of data is specified.
    :vartype data: list[~azure.mgmt.monitor.models.MetricValue]
    """

    _attribute_map = {
        "metadatavalues": {"key": "metadatavalues", "type": "[MetadataValue]"},
        "data": {"key": "data", "type": "[MetricValue]"},
    }

    def __init__(
        self,
        *,
        metadatavalues: Optional[list["_models.MetadataValue"]] = None,
        data: Optional[list["_models.MetricValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadatavalues: The metadata values returned if $filter was specified in the call.
        :paramtype metadatavalues: list[~azure.mgmt.monitor.models.MetadataValue]
        :keyword data: An array of data points representing the metric values.  This is only returned
         if a result type of data is specified.
        :paramtype data: list[~azure.mgmt.monitor.models.MetricValue]
        """
        super().__init__(**kwargs)
        self.metadatavalues = metadatavalues
        self.data = data


class TimeWindow(_serialization.Model):
    """A specific date-time for the profile.

    All required parameters must be populated in order to send to server.

    :ivar time_zone: the timezone of the start and end times for the profile. Some examples of
     valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard
     Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time,
     Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central
     Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific
     Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time,
     Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western
     Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard
     Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
     Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
     Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard
     Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central
     European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard
     Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time,
     E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :vartype time_zone: str
    :ivar start: the start time for the profile in ISO 8601 format. Required.
    :vartype start: ~datetime.datetime
    :ivar end: the end time for the profile in ISO 8601 format. Required.
    :vartype end: ~datetime.datetime
    """

    _validation = {
        "start": {"required": True},
        "end": {"required": True},
    }

    _attribute_map = {
        "time_zone": {"key": "timeZone", "type": "str"},
        "start": {"key": "start", "type": "iso-8601"},
        "end": {"key": "end", "type": "iso-8601"},
    }

    def __init__(
        self, *, start: datetime.datetime, end: datetime.datetime, time_zone: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword time_zone: the timezone of the start and end times for the profile. Some examples of
         valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard
         Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time,
         Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central
         Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific
         Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time,
         Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western
         Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard
         Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
         Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
         Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard
         Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central
         European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard
         Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time,
         E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
         Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
         Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
         Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
         Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
         Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
         Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
         Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
         Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
         Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
         Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
         Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
         Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
         Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
         Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
         Standard Time.
        :paramtype time_zone: str
        :keyword start: the start time for the profile in ISO 8601 format. Required.
        :paramtype start: ~datetime.datetime
        :keyword end: the end time for the profile in ISO 8601 format. Required.
        :paramtype end: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.time_zone = time_zone
        self.start = start
        self.end = end


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class UserIdentityProperties(_serialization.Model):
    """Properties of the user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of resource identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class UserIdentityPropertiesAutoGenerated(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class VMInsightsOnboardingStatus(ProxyResource):
    """VM Insights onboarding status for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar resource_id: Azure Resource Manager identifier of the resource whose onboarding status is
     being represented.
    :vartype resource_id: str
    :ivar onboarding_status: The onboarding status for the resource. Note that, a higher level
     scope, e.g., resource group or subscription, is considered onboarded if at least one resource
     under it is onboarded. Known values are: "onboarded", "notOnboarded", and "unknown".
    :vartype onboarding_status: str or ~azure.mgmt.monitor.models.OnboardingStatus
    :ivar data_status: The status of VM Insights data from the resource. When reported as
     ``present`` the data array will contain information about the data containers to which data for
     the specified resource is being routed. Known values are: "present" and "notPresent".
    :vartype data_status: str or ~azure.mgmt.monitor.models.DataStatus
    :ivar data: Containers that currently store VM Insights data for the specified resource.
    :vartype data: list[~azure.mgmt.monitor.models.DataContainer]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "onboarding_status": {"key": "properties.onboardingStatus", "type": "str"},
        "data_status": {"key": "properties.dataStatus", "type": "str"},
        "data": {"key": "properties.data", "type": "[DataContainer]"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        onboarding_status: Optional[Union[str, "_models.OnboardingStatus"]] = None,
        data_status: Optional[Union[str, "_models.DataStatus"]] = None,
        data: Optional[list["_models.DataContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Azure Resource Manager identifier of the resource whose onboarding status
         is being represented.
        :paramtype resource_id: str
        :keyword onboarding_status: The onboarding status for the resource. Note that, a higher level
         scope, e.g., resource group or subscription, is considered onboarded if at least one resource
         under it is onboarded. Known values are: "onboarded", "notOnboarded", and "unknown".
        :paramtype onboarding_status: str or ~azure.mgmt.monitor.models.OnboardingStatus
        :keyword data_status: The status of VM Insights data from the resource. When reported as
         ``present`` the data array will contain information about the data containers to which data for
         the specified resource is being routed. Known values are: "present" and "notPresent".
        :paramtype data_status: str or ~azure.mgmt.monitor.models.DataStatus
        :keyword data: Containers that currently store VM Insights data for the specified resource.
        :paramtype data: list[~azure.mgmt.monitor.models.DataContainer]
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.onboarding_status = onboarding_status
        self.data_status = data_status
        self.data = data


class VoiceReceiver(_serialization.Model):
    """A voice receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the voice receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar country_code: The country code of the voice receiver. Required.
    :vartype country_code: str
    :ivar phone_number: The phone number of the voice receiver. Required.
    :vartype phone_number: str
    """

    _validation = {
        "name": {"required": True},
        "country_code": {"required": True},
        "phone_number": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
    }

    def __init__(self, *, name: str, country_code: str, phone_number: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the voice receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword country_code: The country code of the voice receiver. Required.
        :paramtype country_code: str
        :keyword phone_number: The phone number of the voice receiver. Required.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.country_code = country_code
        self.phone_number = phone_number


class WebhookNotification(_serialization.Model):
    """Webhook notification of an autoscale event.

    :ivar service_uri: the service address to receive the notification.
    :vartype service_uri: str
    :ivar properties: a property bag of settings. This value can be empty.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        "service_uri": {"key": "serviceUri", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self, *, service_uri: Optional[str] = None, properties: Optional[dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_uri: the service address to receive the notification.
        :paramtype service_uri: str
        :keyword properties: a property bag of settings. This value can be empty.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.service_uri = service_uri
        self.properties = properties


class WebhookReceiver(_serialization.Model):
    """A webhook receiver.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the webhook receiver. Names must be unique across all receivers within
     an action group. Required.
    :vartype name: str
    :ivar service_uri: The URI where webhooks should be sent. Required.
    :vartype service_uri: str
    :ivar use_common_alert_schema: Indicates whether to use common alert schema.
    :vartype use_common_alert_schema: bool
    :ivar use_aad_auth: Indicates whether or not use AAD authentication.
    :vartype use_aad_auth: bool
    :ivar object_id: Indicates the webhook app object Id for aad auth.
    :vartype object_id: str
    :ivar identifier_uri: Indicates the identifier uri for aad auth.
    :vartype identifier_uri: str
    :ivar tenant_id: Indicates the tenant id for aad auth.
    :vartype tenant_id: str
    """

    _validation = {
        "name": {"required": True},
        "service_uri": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "service_uri": {"key": "serviceUri", "type": "str"},
        "use_common_alert_schema": {"key": "useCommonAlertSchema", "type": "bool"},
        "use_aad_auth": {"key": "useAadAuth", "type": "bool"},
        "object_id": {"key": "objectId", "type": "str"},
        "identifier_uri": {"key": "identifierUri", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        service_uri: str,
        use_common_alert_schema: bool = False,
        use_aad_auth: bool = False,
        object_id: Optional[str] = None,
        identifier_uri: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the webhook receiver. Names must be unique across all receivers
         within an action group. Required.
        :paramtype name: str
        :keyword service_uri: The URI where webhooks should be sent. Required.
        :paramtype service_uri: str
        :keyword use_common_alert_schema: Indicates whether to use common alert schema.
        :paramtype use_common_alert_schema: bool
        :keyword use_aad_auth: Indicates whether or not use AAD authentication.
        :paramtype use_aad_auth: bool
        :keyword object_id: Indicates the webhook app object Id for aad auth.
        :paramtype object_id: str
        :keyword identifier_uri: Indicates the identifier uri for aad auth.
        :paramtype identifier_uri: str
        :keyword tenant_id: Indicates the tenant id for aad auth.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.service_uri = service_uri
        self.use_common_alert_schema = use_common_alert_schema
        self.use_aad_auth = use_aad_auth
        self.object_id = object_id
        self.identifier_uri = identifier_uri
        self.tenant_id = tenant_id


class WebtestLocationAvailabilityCriteria(MetricAlertCriteria):
    """Specifies the metric alert rule criteria for a web test resource.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: Specifies the type of the alert criteria. Previously undocumented values
     might be returned. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria", and
     "Microsoft.Azure.Monitor.PromQLCriteria".
    :vartype odata_type: str or ~azure.mgmt.monitor.models.Odatatype
    :ivar web_test_id: The Application Insights web test Id. Required.
    :vartype web_test_id: str
    :ivar component_id: The Application Insights resource Id. Required.
    :vartype component_id: str
    :ivar failed_location_count: The number of failed locations. Required.
    :vartype failed_location_count: float
    """

    _validation = {
        "odata_type": {"required": True},
        "web_test_id": {"required": True},
        "component_id": {"required": True},
        "failed_location_count": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "web_test_id": {"key": "webTestId", "type": "str"},
        "component_id": {"key": "componentId", "type": "str"},
        "failed_location_count": {"key": "failedLocationCount", "type": "float"},
    }

    def __init__(
        self,
        *,
        web_test_id: str,
        component_id: str,
        failed_location_count: float,
        additional_properties: Optional[dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword web_test_id: The Application Insights web test Id. Required.
        :paramtype web_test_id: str
        :keyword component_id: The Application Insights resource Id. Required.
        :paramtype component_id: str
        :keyword failed_location_count: The number of failed locations. Required.
        :paramtype failed_location_count: float
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"
        self.web_test_id = web_test_id
        self.component_id = component_id
        self.failed_location_count = failed_location_count


class WindowsEventLogDataSource(_serialization.Model):
    """Definition of which Windows Event Log events will be collected and how they will be collected.
    Only collected from Windows machines.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or ~azure.mgmt.monitor.models.KnownWindowsEventLogDataSourceStreams]
    :ivar x_path_queries: A list of Windows Event Log queries in XPATH format.
    :vartype x_path_queries: list[str]
    :ivar transform_kql: The KQL query to transform the data source.
    :vartype transform_kql: str
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "x_path_queries": {"key": "xPathQueries", "type": "[str]"},
        "transform_kql": {"key": "transformKql", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: Optional[list[Union[str, "_models.KnownWindowsEventLogDataSourceStreams"]]] = None,
        x_path_queries: Optional[list[str]] = None,
        transform_kql: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or
         ~azure.mgmt.monitor.models.KnownWindowsEventLogDataSourceStreams]
        :keyword x_path_queries: A list of Windows Event Log queries in XPATH format.
        :paramtype x_path_queries: list[str]
        :keyword transform_kql: The KQL query to transform the data source.
        :paramtype transform_kql: str
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.x_path_queries = x_path_queries
        self.transform_kql = transform_kql
        self.name = name


class WindowsFirewallLogsDataSource(_serialization.Model):
    """Enables Firewall logs to be collected by this data collection rule.

    All required parameters must be populated in order to send to server.

    :ivar streams: Firewall logs streams. Required.
    :vartype streams: list[str]
    :ivar profile_filter: Firewall logs profile filter.
    :vartype profile_filter: list[str or
     ~azure.mgmt.monitor.models.KnownWindowsFirewallLogsDataSourceProfileFilter]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "streams": {"required": True},
    }

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "profile_filter": {"key": "profileFilter", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: list[str],
        profile_filter: Optional[list[Union[str, "_models.KnownWindowsFirewallLogsDataSourceProfileFilter"]]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: Firewall logs streams. Required.
        :paramtype streams: list[str]
        :keyword profile_filter: Firewall logs profile filter.
        :paramtype profile_filter: list[str or
         ~azure.mgmt.monitor.models.KnownWindowsFirewallLogsDataSourceProfileFilter]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.profile_filter = profile_filter
        self.name = name


class WorkspaceInfo(_serialization.Model):
    """Information about a Log Analytics Workspace.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure Resource Manager identifier of the Log Analytics Workspace. Required.
    :vartype id: str
    :ivar location: Location of the Log Analytics workspace. Required.
    :vartype location: str
    :ivar customer_id: Log Analytics workspace identifier. Required.
    :vartype customer_id: str
    """

    _validation = {
        "id": {"required": True},
        "location": {"required": True},
        "customer_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "customer_id": {"key": "properties.customerId", "type": "str"},
    }

    def __init__(
        self, *, id: str, location: str, customer_id: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Azure Resource Manager identifier of the Log Analytics Workspace. Required.
        :paramtype id: str
        :keyword location: Location of the Log Analytics workspace. Required.
        :paramtype location: str
        :keyword customer_id: Log Analytics workspace identifier. Required.
        :paramtype customer_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.location = location
        self.customer_id = customer_id
