.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XChangeKeyboardMapping __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XChangeKeyboardMapping, XGetKeyboardMapping, XDisplayKeycodes, XSetModifierMapping, XGetModifierMapping, XNewModifiermap, XInsertModifiermapEntry, XDeleteModifiermapEntry, XFreeModifiermap, XModifierKeymap \- manipulate keyboard encoding and keyboard encoding structure
.SH SYNTAX
.HP
int XChangeKeyboardMapping(\^Display *\fIdisplay\fP, int \fIfirst_keycode\fP,
int \fIkeysyms_per_keycode\fP, KeySym *\fIkeysyms\fP, int \fInum_codes\fP\^);
.HP
KeySym *XGetKeyboardMapping(\^Display *\fIdisplay\fP, KeyCode
\fIfirst_keycode\fP, int \fIkeycode_count\fP, int
*\fIkeysyms_per_keycode_return\fP\^);
.HP
int XDisplayKeycodes\^(\^Display *\fIdisplay\fP\^, int
*\fImin_keycodes_return\fP\^, int *\fImax_keycodes_return\fP\^);
.HP
int XSetModifierMapping(\^Display *\fIdisplay\fP, XModifierKeymap
*\fImodmap\fP\^);
.HP
XModifierKeymap *XGetModifierMapping(\^Display *\fIdisplay\fP\^);
.HP
XModifierKeymap *XNewModifiermap(\^int \fImax_keys_per_mod\fP\^);
.HP
XModifierKeymap *XInsertModifiermapEntry\^(\^XModifierKeymap *\fImodmap\fP,
KeyCode \fIkeycode_entry\fP, int \fImodifier\fP\^);
.HP
XModifierKeymap *XDeleteModifiermapEntry\^(\^XModifierKeymap *\fImodmap\fP,
KeyCode \fIkeycode_entry\fP, int \fImodifier\fP\^);
.HP
int XFreeModifiermap(\^XModifierKeymap *\fImodmap\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIfirst_keycode\fP 1i
Specifies the first KeyCode that is to be changed or returned.
.IP \fIkeycode_count\fP 1i
Specifies the number of KeyCodes that are to be returned.
.IP \fIkeycode_entry\fP 1i
Specifies the KeyCode.
.IP \fIkeysyms\fP 1i
Specifies an array of KeySyms.
.IP \fIkeysyms_per_keycode\fP 1i
Specifies the number of KeySyms per KeyCode.
.IP \fIkeysyms_per_keycode_return\fP 1i
Returns the number of KeySyms per KeyCode.
.IP \fImax_keys_per_mod\fP 1i
Specifies the number of KeyCode entries preallocated to the modifiers
in the map.
.IP \fImax_keycodes_return\fP 1i
Returns the maximum number of KeyCodes.
.IP \fImin_keycodes_return\fP 1i
Returns the minimum number of KeyCodes.
.IP \fImodifier\fP 1i
Specifies the modifier.
.IP \fImodmap\fP 1i
Specifies the
.B XModifierKeymap
structure.
.IP \fInum_codes\fP 1i
Specifies the number of KeyCodes that are to be changed.
.SH DESCRIPTION
The
.B XChangeKeyboardMapping
function defines the symbols for the specified number of KeyCodes
starting with first_keycode.
The symbols for KeyCodes outside this range remain unchanged.
The number of elements in keysyms must be:
.LP
.EX
num_codes * keysyms_per_keycode
.EE
.LP
The specified first_keycode must be greater than or equal to min_keycode
returned by
.BR XDisplayKeycodes ,
or a
.B BadValue
error results.
In addition, the following expression must be less than or equal to
max_keycode as returned by
.BR XDisplayKeycodes ,
or a
.B BadValue
error results:
.LP
.EX
first_keycode + num_codes \- 1
.EE
.LP
KeySym number N, counting from zero, for KeyCode K has the following index
in keysyms, counting from zero:
.LP
.EX
(K \- first_keycode) * keysyms_per_keycode + N
.EE
.LP
The specified keysyms_per_keycode can be chosen arbitrarily by the client
to be large enough to hold all desired symbols.
A special KeySym value of
.B NoSymbol
should be used to fill in unused elements
for individual KeyCodes.
It is legal for
.B NoSymbol
to appear in nontrailing positions
of the effective list for a KeyCode.
.B XChangeKeyboardMapping
generates a
.B MappingNotify
event.
.LP
There is no requirement that the X server interpret this mapping.
It is merely stored for reading and writing by clients.
.LP
.B XChangeKeyboardMapping
can generate
.B BadAlloc
and
.B BadValue
errors.
.LP
The
.B XGetKeyboardMapping
function returns the symbols for the specified number of KeyCodes
starting with first_keycode.
The value specified in first_keycode must be greater than
or equal to min_keycode as returned by
.BR XDisplayKeycodes ,
or a
.B BadValue
error results.
In addition, the following expression must be less than or equal
to max_keycode as returned by
.BR XDisplayKeycodes :
.LP
.EX
first_keycode + keycode_count \- 1
.EE
.LP
If this is not the case, a
.B BadValue
error results.
The number of elements in the KeySyms list is:
.LP
.EX
keycode_count * keysyms_per_keycode_return
.EE
.LP
KeySym number N, counting from zero, for KeyCode K has the following index
in the list, counting from zero:
.EX
(K \- first_code) * keysyms_per_code_return + N
.EE
.LP
The X server arbitrarily chooses the keysyms_per_keycode_return value
to be large enough to report all requested symbols.
A special KeySym value of
.B NoSymbol
is used to fill in unused elements for
individual KeyCodes.
To free the storage returned by
.BR XGetKeyboardMapping ,
use
.BR XFree .
.LP
.B XGetKeyboardMapping
can generate a
.B BadValue
error.
.LP
The
.B XDisplayKeycodes
function returns the min-keycodes and max-keycodes supported by the
specified display.
The minimum number of KeyCodes returned is never less than 8,
and the maximum number of KeyCodes returned is never greater than 255.
Not all KeyCodes in this range are required to have corresponding keys.
.LP
The
.B XSetModifierMapping
function specifies the KeyCodes of the keys (if any) that are to be used
as modifiers.
If it succeeds,
the X server generates a
.B MappingNotify
event, and
.B XSetModifierMapping
returns
.BR MappingSuccess .
X permits at most 8 modifier keys.
If more than 8 are specified in the
.B XModifierKeymap
structure, a
.B BadLength
error results.
.LP
The modifiermap member of the
.B XModifierKeymap
structure contains 8 sets of max_keypermod KeyCodes,
one for each modifier in the order
.BR Shift ,
.BR Lock ,
.BR Control ,
.BR Mod1 ,
.BR Mod2 ,
.BR Mod3 ,
.BR Mod4 ,
and
.BR Mod5 .
Only nonzero KeyCodes have meaning in each set,
and zero KeyCodes are ignored.
In addition, all of the nonzero KeyCodes must be in the range specified by
min_keycode and max_keycode in the
.B Display
structure,
or a
.B BadValue
error results.
.LP
An X server can impose restrictions on how modifiers can be changed,
for example,
if certain keys do not generate up transitions in hardware,
if auto-repeat cannot be disabled on certain keys,
or if multiple modifier keys are not supported.
If some such restriction is violated,
the status reply is
.BR MappingFailed ,
and none of the modifiers are changed.
If the new KeyCodes specified for a modifier differ from those
currently defined and any (current or new) keys for that modifier are
in the logically down state,
.B XSetModifierMapping
returns
.BR MappingBusy ,
and none of the modifiers is changed.
.LP
.B XSetModifierMapping
can generate
.B BadAlloc
and
.B BadValue
errors.
.LP
The
.B XGetModifierMapping
function returns a pointer to a newly created
.B XModifierKeymap
structure that contains the keys being used as modifiers.
The structure should be freed after use by calling
.BR XFreeModifiermap .
If only zero values appear in the set for any modifier,
that modifier is disabled.
.LP
The
.B XNewModifiermap
function returns a pointer to
.B XModifierKeymap
structure for later use.
.LP
The
.B XInsertModifiermapEntry
function adds the specified KeyCode to the set that controls the specified
modifier and returns the resulting
.B XModifierKeymap
structure (expanded as needed).
.LP
The
.B XDeleteModifiermapEntry
function deletes the specified KeyCode from the set that controls the
specified modifier and returns a pointer to the resulting
.B XModifierKeymap
structure.
.LP
The
.B XFreeModifiermap
function frees the specified
.B XModifierKeymap
structure.
.SH STRUCTURES
The
.B XModifierKeymap
structure contains:
.LP
.EX
typedef struct {
        int max_keypermod;      /\&* This server's max number of keys per modifier */
        KeyCode *modifiermap;   /\&* An 8 by max_keypermod array of the modifiers */
} XModifierKeymap;
.EE
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
.BR XFree (__libmansuffix__),
.BR XkbGetMap (__libmansuffix__),
.BR XSetPointerMapping (__libmansuffix__)
.br
\fI\*(xL\fP
