// SPDX-License-Identifier: GPL-2.0-or-later
/*
 *  (c) 1999 Andreas Gal		<gal@cs.uni-magdeburg.de>
 *  (c) 2000-2001 Vojtech Pavlik	<vojtech@ucw.cz>
 *  (c) 2007-2009 Jiri Kosina
 *
 *  HID debugging support
 */

/*
 *
 * Should you need to contact me, the author, you can do so either by
 * e-mail - mail your message to <vojtech@ucw.cz>, or by paper mail:
 * Vojtech Pavlik, Simunkova 1594, Prague 8, 182 00 Czech Republic
 */

#define pr_fmt(fmt) KBUILD_MODNAME ": " fmt

#include <linux/debugfs.h>
#include <linux/seq_file.h>
#include <linux/kfifo.h>
#include <linux/sched/signal.h>
#include <linux/export.h>
#include <linux/slab.h>
#include <linux/uaccess.h>
#include <linux/poll.h>

#include <linux/hid.h>
#include <linux/hid-debug.h>

static struct dentry *hid_debug_root;

struct hid_usage_entry {
	unsigned  page;
	unsigned  usage;
	const char     *description;
};

static const struct hid_usage_entry hid_usage_table[] = {
	{ 0x00, 0, "Undefined" },
	{ 0x01, 0, "GenericDesktop" },
		{ 0x01, 0x0001, "Pointer" },
		{ 0x01, 0x0002, "Mouse" },
		{ 0x01, 0x0004, "Joystick" },
		{ 0x01, 0x0005, "Gamepad" },
		{ 0x01, 0x0006, "Keyboard" },
		{ 0x01, 0x0007, "Keypad" },
		{ 0x01, 0x0008, "MultiaxisController" },
		{ 0x01, 0x0009, "TabletPCSystemControls" },
		{ 0x01, 0x000a, "WaterCoolingDevice" },
		{ 0x01, 0x000b, "ComputerChassisDevice" },
		{ 0x01, 0x000c, "WirelessRadioControls" },
		{ 0x01, 0x000d, "PortableDeviceControl" },
		{ 0x01, 0x000e, "SystemMultiAxisController" },
		{ 0x01, 0x000f, "SpatialController" },
		{ 0x01, 0x0010, "AssistiveControl" },
		{ 0x01, 0x0011, "DeviceDock" },
		{ 0x01, 0x0012, "DockableDevice" },
		{ 0x01, 0x0013, "CallStateManagementControl" },
		{ 0x01, 0x0030, "X" },
		{ 0x01, 0x0031, "Y" },
		{ 0x01, 0x0032, "Z" },
		{ 0x01, 0x0033, "Rx" },
		{ 0x01, 0x0034, "Ry" },
		{ 0x01, 0x0035, "Rz" },
		{ 0x01, 0x0036, "Slider" },
		{ 0x01, 0x0037, "Dial" },
		{ 0x01, 0x0038, "Wheel" },
		{ 0x01, 0x0039, "HatSwitch" },
		{ 0x01, 0x003a, "CountedBuffer" },
		{ 0x01, 0x003b, "ByteCount" },
		{ 0x01, 0x003c, "MotionWakeup" },
		{ 0x01, 0x003d, "Start" },
		{ 0x01, 0x003e, "Select" },
		{ 0x01, 0x0040, "Vx" },
		{ 0x01, 0x0041, "Vy" },
		{ 0x01, 0x0042, "Vz" },
		{ 0x01, 0x0043, "Vbrx" },
		{ 0x01, 0x0044, "Vbry" },
		{ 0x01, 0x0045, "Vbrz" },
		{ 0x01, 0x0046, "Vno" },
		{ 0x01, 0x0047, "FeatureNotification" },
		{ 0x01, 0x0048, "ResolutionMultiplier" },
		{ 0x01, 0x0049, "Qx" },
		{ 0x01, 0x004a, "Qy" },
		{ 0x01, 0x004b, "Qz" },
		{ 0x01, 0x004c, "Qw" },
		{ 0x01, 0x0080, "SystemControl" },
		{ 0x01, 0x0081, "SystemPowerDown" },
		{ 0x01, 0x0082, "SystemSleep" },
		{ 0x01, 0x0083, "SystemWakeUp" },
		{ 0x01, 0x0084, "SystemContextMenu" },
		{ 0x01, 0x0085, "SystemMainMenu" },
		{ 0x01, 0x0086, "SystemAppMenu" },
		{ 0x01, 0x0087, "SystemMenuHelp" },
		{ 0x01, 0x0088, "SystemMenuExit" },
		{ 0x01, 0x0089, "SystemMenuSelect" },
		{ 0x01, 0x008a, "SystemMenuRight" },
		{ 0x01, 0x008b, "SystemMenuLeft" },
		{ 0x01, 0x008c, "SystemMenuUp" },
		{ 0x01, 0x008d, "SystemMenuDown" },
		{ 0x01, 0x008e, "SystemColdRestart" },
		{ 0x01, 0x008f, "SystemWarmRestart" },
		{ 0x01, 0x0090, "DpadUp" },
		{ 0x01, 0x0091, "DpadDown" },
		{ 0x01, 0x0092, "DpadRight" },
		{ 0x01, 0x0093, "DpadLeft" },
		{ 0x01, 0x0094, "IndexTrigger" },
		{ 0x01, 0x0095, "PalmTrigger" },
		{ 0x01, 0x0096, "Thumbstick" },
		{ 0x01, 0x0097, "SystemFunctionShift" },
		{ 0x01, 0x0098, "SystemFunctionShiftLock" },
		{ 0x01, 0x0099, "SystemFunctionShiftLockIndicator" },
		{ 0x01, 0x009a, "SystemDismissNotification" },
		{ 0x01, 0x009b, "SystemDoNotDisturb" },
		{ 0x01, 0x00a0, "SystemDock" },
		{ 0x01, 0x00a1, "SystemUndock" },
		{ 0x01, 0x00a2, "SystemSetup" },
		{ 0x01, 0x00a3, "SystemBreak" },
		{ 0x01, 0x00a4, "SystemDebuggerBreak" },
		{ 0x01, 0x00a5, "ApplicationBreak" },
		{ 0x01, 0x00a6, "ApplicationDebuggerBreak" },
		{ 0x01, 0x00a7, "SystemSpeakerMute" },
		{ 0x01, 0x00a8, "SystemHibernate" },
		{ 0x01, 0x00a9, "SystemMicrophoneMute" },
		{ 0x01, 0x00b0, "SystemDisplayInvert" },
		{ 0x01, 0x00b1, "SystemDisplayInternal" },
		{ 0x01, 0x00b2, "SystemDisplayExternal" },
		{ 0x01, 0x00b3, "SystemDisplayBoth" },
		{ 0x01, 0x00b4, "SystemDisplayDual" },
		{ 0x01, 0x00b5, "SystemDisplayToggleIntExtMode" },
		{ 0x01, 0x00b6, "SystemDisplaySwapPrimarySecondary" },
		{ 0x01, 0x00b7, "SystemDisplayToggleLCDAutoscale" },
		{ 0x01, 0x00c0, "SensorZone" },
		{ 0x01, 0x00c1, "RPM" },
		{ 0x01, 0x00c2, "CoolantLevel" },
		{ 0x01, 0x00c3, "CoolantCriticalLevel" },
		{ 0x01, 0x00c4, "CoolantPump" },
		{ 0x01, 0x00c5, "ChassisEnclosure" },
		{ 0x01, 0x00c6, "WirelessRadioButton" },
		{ 0x01, 0x00c7, "WirelessRadioLED" },
		{ 0x01, 0x00c8, "WirelessRadioSliderSwitch" },
		{ 0x01, 0x00c9, "SystemDisplayRotationLockButton" },
		{ 0x01, 0x00ca, "SystemDisplayRotationLockSliderSwitch" },
		{ 0x01, 0x00cb, "ControlEnable" },
		{ 0x01, 0x00d0, "DockableDeviceUniqueID" },
		{ 0x01, 0x00d1, "DockableDeviceVendorID" },
		{ 0x01, 0x00d2, "DockableDevicePrimaryUsagePage" },
		{ 0x01, 0x00d3, "DockableDevicePrimaryUsageID" },
		{ 0x01, 0x00d4, "DockableDeviceDockingState" },
		{ 0x01, 0x00d5, "DockableDeviceDisplayOcclusion" },
		{ 0x01, 0x00d6, "DockableDeviceObjectType" },
		{ 0x01, 0x00e0, "CallActiveLED" },
		{ 0x01, 0x00e1, "CallMuteToggle" },
		{ 0x01, 0x00e2, "CallMuteLED" },
	{ 0x02, 0, "SimulationControls" },
		{ 0x02, 0x0001, "FlightSimulationDevice" },
		{ 0x02, 0x0002, "AutomobileSimulationDevice" },
		{ 0x02, 0x0003, "TankSimulationDevice" },
		{ 0x02, 0x0004, "SpaceshipSimulationDevice" },
		{ 0x02, 0x0005, "SubmarineSimulationDevice" },
		{ 0x02, 0x0006, "SailingSimulationDevice" },
		{ 0x02, 0x0007, "MotorcycleSimulationDevice" },
		{ 0x02, 0x0008, "SportsSimulationDevice" },
		{ 0x02, 0x0009, "AirplaneSimulationDevice" },
		{ 0x02, 0x000a, "HelicopterSimulationDevice" },
		{ 0x02, 0x000b, "MagicCarpetSimulationDevice" },
		{ 0x02, 0x000c, "BicycleSimulationDevice" },
		{ 0x02, 0x0020, "FlightControlStick" },
		{ 0x02, 0x0021, "FlightStick" },
		{ 0x02, 0x0022, "CyclicControl" },
		{ 0x02, 0x0023, "CyclicTrim" },
		{ 0x02, 0x0024, "FlightYoke" },
		{ 0x02, 0x0025, "TrackControl" },
		{ 0x02, 0x00b0, "Aileron" },
		{ 0x02, 0x00b1, "AileronTrim" },
		{ 0x02, 0x00b2, "AntiTorqueControl" },
		{ 0x02, 0x00b3, "AutopilotEnable" },
		{ 0x02, 0x00b4, "ChaffRelease" },
		{ 0x02, 0x00b5, "CollectiveControl" },
		{ 0x02, 0x00b6, "DiveBrake" },
		{ 0x02, 0x00b7, "ElectronicCountermeasures" },
		{ 0x02, 0x00b8, "Elevator" },
		{ 0x02, 0x00b9, "ElevatorTrim" },
		{ 0x02, 0x00ba, "Rudder" },
		{ 0x02, 0x00bb, "Throttle" },
		{ 0x02, 0x00bc, "FlightCommunications" },
		{ 0x02, 0x00bd, "FlareRelease" },
		{ 0x02, 0x00be, "LandingGear" },
		{ 0x02, 0x00bf, "ToeBrake" },
		{ 0x02, 0x00c0, "Trigger" },
		{ 0x02, 0x00c1, "WeaponsArm" },
		{ 0x02, 0x00c2, "WeaponsSelect" },
		{ 0x02, 0x00c3, "WingFlaps" },
		{ 0x02, 0x00c4, "Accelerator" },
		{ 0x02, 0x00c5, "Brake" },
		{ 0x02, 0x00c6, "Clutch" },
		{ 0x02, 0x00c7, "Shifter" },
		{ 0x02, 0x00c8, "Steering" },
		{ 0x02, 0x00c9, "TurretDirection" },
		{ 0x02, 0x00ca, "BarrelElevation" },
		{ 0x02, 0x00cb, "DivePlane" },
		{ 0x02, 0x00cc, "Ballast" },
		{ 0x02, 0x00cd, "BicycleCrank" },
		{ 0x02, 0x00ce, "HandleBars" },
		{ 0x02, 0x00cf, "FrontBrake" },
		{ 0x02, 0x00d0, "RearBrake" },
	{ 0x03, 0, "VRControls" },
		{ 0x03, 0x0001, "Belt" },
		{ 0x03, 0x0002, "BodySuit" },
		{ 0x03, 0x0003, "Flexor" },
		{ 0x03, 0x0004, "Glove" },
		{ 0x03, 0x0005, "HeadTracker" },
		{ 0x03, 0x0006, "HeadMountedDisplay" },
		{ 0x03, 0x0007, "HandTracker" },
		{ 0x03, 0x0008, "Oculometer" },
		{ 0x03, 0x0009, "Vest" },
		{ 0x03, 0x000a, "AnimatronicDevice" },
		{ 0x03, 0x0020, "StereoEnable" },
		{ 0x03, 0x0021, "DisplayEnable" },
	{ 0x04, 0, "SportControls" },
		{ 0x04, 0x0001, "BaseballBat" },
		{ 0x04, 0x0002, "GolfClub" },
		{ 0x04, 0x0003, "RowingMachine" },
		{ 0x04, 0x0004, "Treadmill" },
		{ 0x04, 0x0030, "Oar" },
		{ 0x04, 0x0031, "Slope" },
		{ 0x04, 0x0032, "Rate" },
		{ 0x04, 0x0033, "StickSpeed" },
		{ 0x04, 0x0034, "StickFaceAngle" },
		{ 0x04, 0x0035, "StickHeelToe" },
		{ 0x04, 0x0036, "StickFollowThrough" },
		{ 0x04, 0x0037, "StickTempo" },
		{ 0x04, 0x0038, "StickType" },
		{ 0x04, 0x0039, "StickHeight" },
		{ 0x04, 0x0050, "Putter" },
		{ 0x04, 0x0051, "1Iron" },
		{ 0x04, 0x0052, "2Iron" },
		{ 0x04, 0x0053, "3Iron" },
		{ 0x04, 0x0054, "4Iron" },
		{ 0x04, 0x0055, "5Iron" },
		{ 0x04, 0x0056, "6Iron" },
		{ 0x04, 0x0057, "7Iron" },
		{ 0x04, 0x0058, "8Iron" },
		{ 0x04, 0x0059, "9Iron" },
		{ 0x04, 0x005a, "10Iron" },
		{ 0x04, 0x005b, "11Iron" },
		{ 0x04, 0x005c, "SandWedge" },
		{ 0x04, 0x005d, "LoftWedge" },
		{ 0x04, 0x005e, "PowerWedge" },
		{ 0x04, 0x005f, "1Wood" },
		{ 0x04, 0x0060, "3Wood" },
		{ 0x04, 0x0061, "5Wood" },
		{ 0x04, 0x0062, "7Wood" },
		{ 0x04, 0x0063, "9Wood" },
	{ 0x05, 0, "GameControls" },
		{ 0x05, 0x0001, "3DGameController" },
		{ 0x05, 0x0002, "PinballDevice" },
		{ 0x05, 0x0003, "GunDevice" },
		{ 0x05, 0x0020, "PointofView" },
		{ 0x05, 0x0021, "TurnRightLeft" },
		{ 0x05, 0x0022, "PitchForwardBackward" },
		{ 0x05, 0x0023, "RollRightLeft" },
		{ 0x05, 0x0024, "MoveRightLeft" },
		{ 0x05, 0x0025, "MoveForwardBackward" },
		{ 0x05, 0x0026, "MoveUpDown" },
		{ 0x05, 0x0027, "LeanRightLeft" },
		{ 0x05, 0x0028, "LeanForwardBackward" },
		{ 0x05, 0x0029, "HeightofPOV" },
		{ 0x05, 0x002a, "Flipper" },
		{ 0x05, 0x002b, "SecondaryFlipper" },
		{ 0x05, 0x002c, "Bump" },
		{ 0x05, 0x002d, "NewGame" },
		{ 0x05, 0x002e, "ShootBall" },
		{ 0x05, 0x002f, "Player" },
		{ 0x05, 0x0030, "GunBolt" },
		{ 0x05, 0x0031, "GunClip" },
		{ 0x05, 0x0032, "GunSelector" },
		{ 0x05, 0x0033, "GunSingleShot" },
		{ 0x05, 0x0034, "GunBurst" },
		{ 0x05, 0x0035, "GunAutomatic" },
		{ 0x05, 0x0036, "GunSafety" },
		{ 0x05, 0x0037, "GamepadFireJump" },
		{ 0x05, 0x0039, "GamepadTrigger" },
		{ 0x05, 0x003a, "FormfittingGamepad" },
	{ 0x06, 0, "GenericDeviceControls" },
		{ 0x06, 0x0001, "BackgroundNonuserControls" },
		{ 0x06, 0x0020, "BatteryStrength" },
		{ 0x06, 0x0021, "WirelessChannel" },
		{ 0x06, 0x0022, "WirelessID" },
		{ 0x06, 0x0023, "DiscoverWirelessControl" },
		{ 0x06, 0x0024, "SecurityCodeCharacterEntered" },
		{ 0x06, 0x0025, "SecurityCodeCharacterErased" },
		{ 0x06, 0x0026, "SecurityCodeCleared" },
		{ 0x06, 0x0027, "SequenceID" },
		{ 0x06, 0x0028, "SequenceIDReset" },
		{ 0x06, 0x0029, "RFSignalStrength" },
		{ 0x06, 0x002a, "SoftwareVersion" },
		{ 0x06, 0x002b, "ProtocolVersion" },
		{ 0x06, 0x002c, "HardwareVersion" },
		{ 0x06, 0x002d, "Major" },
		{ 0x06, 0x002e, "Minor" },
		{ 0x06, 0x002f, "Revision" },
		{ 0x06, 0x0030, "Handedness" },
		{ 0x06, 0x0031, "EitherHand" },
		{ 0x06, 0x0032, "LeftHand" },
		{ 0x06, 0x0033, "RightHand" },
		{ 0x06, 0x0034, "BothHands" },
		{ 0x06, 0x0040, "GripPoseOffset" },
		{ 0x06, 0x0041, "PointerPoseOffset" },
	{ 0x07, 0, "KeyboardKeypad" },
		{ 0x07, 0x0001, "ErrorRollOver" },
		{ 0x07, 0x0002, "POSTFail" },
		{ 0x07, 0x0003, "ErrorUndefined" },
		{ 0x07, 0x0004, "KeyboardA" },
		{ 0x07, 0x0005, "KeyboardB" },
		{ 0x07, 0x0006, "KeyboardC" },
		{ 0x07, 0x0007, "KeyboardD" },
		{ 0x07, 0x0008, "KeyboardE" },
		{ 0x07, 0x0009, "KeyboardF" },
		{ 0x07, 0x000a, "KeyboardG" },
		{ 0x07, 0x000b, "KeyboardH" },
		{ 0x07, 0x000c, "KeyboardI" },
		{ 0x07, 0x000d, "KeyboardJ" },
		{ 0x07, 0x000e, "KeyboardK" },
		{ 0x07, 0x000f, "KeyboardL" },
		{ 0x07, 0x0010, "KeyboardM" },
		{ 0x07, 0x0011, "KeyboardN" },
		{ 0x07, 0x0012, "KeyboardO" },
		{ 0x07, 0x0013, "KeyboardP" },
		{ 0x07, 0x0014, "KeyboardQ" },
		{ 0x07, 0x0015, "KeyboardR" },
		{ 0x07, 0x0016, "KeyboardS" },
		{ 0x07, 0x0017, "KeyboardT" },
		{ 0x07, 0x0018, "KeyboardU" },
		{ 0x07, 0x0019, "KeyboardV" },
		{ 0x07, 0x001a, "KeyboardW" },
		{ 0x07, 0x001b, "KeyboardX" },
		{ 0x07, 0x001c, "KeyboardY" },
		{ 0x07, 0x001d, "KeyboardZ" },
		{ 0x07, 0x001e, "Keyboard1andBang" },
		{ 0x07, 0x001f, "Keyboard2andAt" },
		{ 0x07, 0x0020, "Keyboard3andHash" },
		{ 0x07, 0x0021, "Keyboard4andDollar" },
		{ 0x07, 0x0022, "Keyboard5andPercent" },
		{ 0x07, 0x0023, "Keyboard6andCaret" },
		{ 0x07, 0x0024, "Keyboard7andAmpersand" },
		{ 0x07, 0x0025, "Keyboard8andStar" },
		{ 0x07, 0x0026, "Keyboard9andLeftBracket" },
		{ 0x07, 0x0027, "Keyboard0andRightBracket" },
		{ 0x07, 0x0028, "KeyboardReturnEnter" },
		{ 0x07, 0x0029, "KeyboardEscape" },
		{ 0x07, 0x002a, "KeyboardDelete" },
		{ 0x07, 0x002b, "KeyboardTab" },
		{ 0x07, 0x002c, "KeyboardSpacebar" },
		{ 0x07, 0x002d, "KeyboardDashandUnderscore" },
		{ 0x07, 0x002e, "KeyboardEqualsandPlus" },
		{ 0x07, 0x002f, "KeyboardLeftBrace" },
		{ 0x07, 0x0030, "KeyboardRightBrace" },
		{ 0x07, 0x0031, "KeyboardBackslashandPipe" },
		{ 0x07, 0x0032, "KeyboardNonUSHashandTilde" },
		{ 0x07, 0x0033, "KeyboardSemiColonandColon" },
		{ 0x07, 0x0034, "KeyboardLeftAposandDouble" },
		{ 0x07, 0x0035, "KeyboardGraveAccentandTilde" },
		{ 0x07, 0x0036, "KeyboardCommaandLessThan" },
		{ 0x07, 0x0037, "KeyboardPeriodandGreaterThan" },
		{ 0x07, 0x0038, "KeyboardForwardSlashandQuestionMark" },
		{ 0x07, 0x0039, "KeyboardCapsLock" },
		{ 0x07, 0x003a, "KeyboardF1" },
		{ 0x07, 0x003b, "KeyboardF2" },
		{ 0x07, 0x003c, "KeyboardF3" },
		{ 0x07, 0x003d, "KeyboardF4" },
		{ 0x07, 0x003e, "KeyboardF5" },
		{ 0x07, 0x003f, "KeyboardF6" },
		{ 0x07, 0x0040, "KeyboardF7" },
		{ 0x07, 0x0041, "KeyboardF8" },
		{ 0x07, 0x0042, "KeyboardF9" },
		{ 0x07, 0x0043, "KeyboardF10" },
		{ 0x07, 0x0044, "KeyboardF11" },
		{ 0x07, 0x0045, "KeyboardF12" },
		{ 0x07, 0x0046, "KeyboardPrintScreen" },
		{ 0x07, 0x0047, "KeyboardScrollLock" },
		{ 0x07, 0x0048, "KeyboardPause" },
		{ 0x07, 0x0049, "KeyboardInsert" },
		{ 0x07, 0x004a, "KeyboardHome" },
		{ 0x07, 0x004b, "KeyboardPageUp" },
		{ 0x07, 0x004c, "KeyboardDeleteForward" },
		{ 0x07, 0x004d, "KeyboardEnd" },
		{ 0x07, 0x004e, "KeyboardPageDown" },
		{ 0x07, 0x004f, "KeyboardRightArrow" },
		{ 0x07, 0x0050, "KeyboardLeftArrow" },
		{ 0x07, 0x0051, "KeyboardDownArrow" },
		{ 0x07, 0x0052, "KeyboardUpArrow" },
		{ 0x07, 0x0053, "KeypadNumLockandClear" },
		{ 0x07, 0x0054, "KeypadForwardSlash" },
		{ 0x07, 0x0055, "KeypadStar" },
		{ 0x07, 0x0056, "KeypadDash" },
		{ 0x07, 0x0057, "KeypadPlus" },
		{ 0x07, 0x0058, "KeypadENTER" },
		{ 0x07, 0x0059, "Keypad1andEnd" },
		{ 0x07, 0x005a, "Keypad2andDownArrow" },
		{ 0x07, 0x005b, "Keypad3andPageDn" },
		{ 0x07, 0x005c, "Keypad4andLeftArrow" },
		{ 0x07, 0x005d, "Keypad5" },
		{ 0x07, 0x005e, "Keypad6andRightArrow" },
		{ 0x07, 0x005f, "Keypad7andHome" },
		{ 0x07, 0x0060, "Keypad8andUpArrow" },
		{ 0x07, 0x0061, "Keypad9andPageUp" },
		{ 0x07, 0x0062, "Keypad0andInsert" },
		{ 0x07, 0x0063, "KeypadPeriodandDelete" },
		{ 0x07, 0x0064, "KeyboardNonUSBackslashandPipe" },
		{ 0x07, 0x0065, "KeyboardApplication" },
		{ 0x07, 0x0066, "KeyboardPower" },
		{ 0x07, 0x0067, "KeypadEquals" },
		{ 0x07, 0x0068, "KeyboardF13" },
		{ 0x07, 0x0069, "KeyboardF14" },
		{ 0x07, 0x006a, "KeyboardF15" },
		{ 0x07, 0x006b, "KeyboardF16" },
		{ 0x07, 0x006c, "KeyboardF17" },
		{ 0x07, 0x006d, "KeyboardF18" },
		{ 0x07, 0x006e, "KeyboardF19" },
		{ 0x07, 0x006f, "KeyboardF20" },
		{ 0x07, 0x0070, "KeyboardF21" },
		{ 0x07, 0x0071, "KeyboardF22" },
		{ 0x07, 0x0072, "KeyboardF23" },
		{ 0x07, 0x0073, "KeyboardF24" },
		{ 0x07, 0x0074, "KeyboardExecute" },
		{ 0x07, 0x0075, "KeyboardHelp" },
		{ 0x07, 0x0076, "KeyboardMenu" },
		{ 0x07, 0x0077, "KeyboardSelect" },
		{ 0x07, 0x0078, "KeyboardStop" },
		{ 0x07, 0x0079, "KeyboardAgain" },
		{ 0x07, 0x007a, "KeyboardUndo" },
		{ 0x07, 0x007b, "KeyboardCut" },
		{ 0x07, 0x007c, "KeyboardCopy" },
		{ 0x07, 0x007d, "KeyboardPaste" },
		{ 0x07, 0x007e, "KeyboardFind" },
		{ 0x07, 0x007f, "KeyboardMute" },
		{ 0x07, 0x0080, "KeyboardVolumeUp" },
		{ 0x07, 0x0081, "KeyboardVolumeDown" },
		{ 0x07, 0x0082, "KeyboardLockingCapsLock" },
		{ 0x07, 0x0083, "KeyboardLockingNumLock" },
		{ 0x07, 0x0084, "KeyboardLockingScrollLock" },
		{ 0x07, 0x0085, "KeypadComma" },
		{ 0x07, 0x0086, "KeypadEqualSign" },
		{ 0x07, 0x0087, "KeyboardInternational1" },
		{ 0x07, 0x0088, "KeyboardInternational2" },
		{ 0x07, 0x0089, "KeyboardInternational3" },
		{ 0x07, 0x008a, "KeyboardInternational4" },
		{ 0x07, 0x008b, "KeyboardInternational5" },
		{ 0x07, 0x008c, "KeyboardInternational6" },
		{ 0x07, 0x008d, "KeyboardInternational7" },
		{ 0x07, 0x008e, "KeyboardInternational8" },
		{ 0x07, 0x008f, "KeyboardInternational9" },
		{ 0x07, 0x0090, "KeyboardLANG1" },
		{ 0x07, 0x0091, "KeyboardLANG2" },
		{ 0x07, 0x0092, "KeyboardLANG3" },
		{ 0x07, 0x0093, "KeyboardLANG4" },
		{ 0x07, 0x0094, "KeyboardLANG5" },
		{ 0x07, 0x0095, "KeyboardLANG6" },
		{ 0x07, 0x0096, "KeyboardLANG7" },
		{ 0x07, 0x0097, "KeyboardLANG8" },
		{ 0x07, 0x0098, "KeyboardLANG9" },
		{ 0x07, 0x0099, "KeyboardAlternateErase" },
		{ 0x07, 0x009a, "KeyboardSysReqAttention" },
		{ 0x07, 0x009b, "KeyboardCancel" },
		{ 0x07, 0x009c, "KeyboardClear" },
		{ 0x07, 0x009d, "KeyboardPrior" },
		{ 0x07, 0x009e, "KeyboardReturn" },
		{ 0x07, 0x009f, "KeyboardSeparator" },
		{ 0x07, 0x00a0, "KeyboardOut" },
		{ 0x07, 0x00a1, "KeyboardOper" },
		{ 0x07, 0x00a2, "KeyboardClearAgain" },
		{ 0x07, 0x00a3, "KeyboardCrSelProps" },
		{ 0x07, 0x00a4, "KeyboardExSel" },
		{ 0x07, 0x00b0, "KeypadDouble0" },
		{ 0x07, 0x00b1, "KeypadTriple0" },
		{ 0x07, 0x00b2, "ThousandsSeparator" },
		{ 0x07, 0x00b3, "DecimalSeparator" },
		{ 0x07, 0x00b4, "CurrencyUnit" },
		{ 0x07, 0x00b5, "CurrencySubunit" },
		{ 0x07, 0x00b6, "KeypadLeftBracket" },
		{ 0x07, 0x00b7, "KeypadRightBracket" },
		{ 0x07, 0x00b8, "KeypadLeftBrace" },
		{ 0x07, 0x00b9, "KeypadRightBrace" },
		{ 0x07, 0x00ba, "KeypadTab" },
		{ 0x07, 0x00bb, "KeypadBackspace" },
		{ 0x07, 0x00bc, "KeypadA" },
		{ 0x07, 0x00bd, "KeypadB" },
		{ 0x07, 0x00be, "KeypadC" },
		{ 0x07, 0x00bf, "KeypadD" },
		{ 0x07, 0x00c0, "KeypadE" },
		{ 0x07, 0x00c1, "KeypadF" },
		{ 0x07, 0x00c2, "KeypadXOR" },
		{ 0x07, 0x00c3, "KeypadCaret" },
		{ 0x07, 0x00c4, "KeypadPercentage" },
		{ 0x07, 0x00c5, "KeypadLess" },
		{ 0x07, 0x00c6, "KeypadGreater" },
		{ 0x07, 0x00c7, "KeypadAmpersand" },
		{ 0x07, 0x00c8, "KeypadDoubleAmpersand" },
		{ 0x07, 0x00c9, "KeypadBar" },
		{ 0x07, 0x00ca, "KeypadDoubleBar" },
		{ 0x07, 0x00cb, "KeypadColon" },
		{ 0x07, 0x00cc, "KeypadHash" },
		{ 0x07, 0x00cd, "KeypadSpace" },
		{ 0x07, 0x00ce, "KeypadAt" },
		{ 0x07, 0x00cf, "KeypadBang" },
		{ 0x07, 0x00d0, "KeypadMemoryStore" },
		{ 0x07, 0x00d1, "KeypadMemoryRecall" },
		{ 0x07, 0x00d2, "KeypadMemoryClear" },
		{ 0x07, 0x00d3, "KeypadMemoryAdd" },
		{ 0x07, 0x00d4, "KeypadMemorySubtract" },
		{ 0x07, 0x00d5, "KeypadMemoryMultiply" },
		{ 0x07, 0x00d6, "KeypadMemoryDivide" },
		{ 0x07, 0x00d7, "KeypadPlusMinus" },
		{ 0x07, 0x00d8, "KeypadClear" },
		{ 0x07, 0x00d9, "KeypadClearEntry" },
		{ 0x07, 0x00da, "KeypadBinary" },
		{ 0x07, 0x00db, "KeypadOctal" },
		{ 0x07, 0x00dc, "KeypadDecimal" },
		{ 0x07, 0x00dd, "KeypadHexadecimal" },
		{ 0x07, 0x00e0, "KeyboardLeftControl" },
		{ 0x07, 0x00e1, "KeyboardLeftShift" },
		{ 0x07, 0x00e2, "KeyboardLeftAlt" },
		{ 0x07, 0x00e3, "KeyboardLeftGUI" },
		{ 0x07, 0x00e4, "KeyboardRightControl" },
		{ 0x07, 0x00e5, "KeyboardRightShift" },
		{ 0x07, 0x00e6, "KeyboardRightAlt" },
		{ 0x07, 0x00e7, "KeyboardRightGUI" },
	{ 0x08, 0, "LED" },
		{ 0x08, 0x0001, "NumLock" },
		{ 0x08, 0x0002, "CapsLock" },
		{ 0x08, 0x0003, "ScrollLock" },
		{ 0x08, 0x0004, "Compose" },
		{ 0x08, 0x0005, "Kana" },
		{ 0x08, 0x0006, "Power" },
		{ 0x08, 0x0007, "Shift" },
		{ 0x08, 0x0008, "DoNotDisturb" },
		{ 0x08, 0x0009, "Mute" },
		{ 0x08, 0x000a, "ToneEnable" },
		{ 0x08, 0x000b, "HighCutFilter" },
		{ 0x08, 0x000c, "LowCutFilter" },
		{ 0x08, 0x000d, "EqualizerEnable" },
		{ 0x08, 0x000e, "SoundFieldOn" },
		{ 0x08, 0x000f, "SurroundOn" },
		{ 0x08, 0x0010, "Repeat" },
		{ 0x08, 0x0011, "Stereo" },
		{ 0x08, 0x0012, "SamplingRateDetect" },
		{ 0x08, 0x0013, "Spinning" },
		{ 0x08, 0x0014, "CAV" },
		{ 0x08, 0x0015, "CLV" },
		{ 0x08, 0x0016, "RecordingFormatDetect" },
		{ 0x08, 0x0017, "OffHook" },
		{ 0x08, 0x0018, "Ring" },
		{ 0x08, 0x0019, "MessageWaiting" },
		{ 0x08, 0x001a, "DataMode" },
		{ 0x08, 0x001b, "BatteryOperation" },
		{ 0x08, 0x001c, "BatteryOK" },
		{ 0x08, 0x001d, "BatteryLow" },
		{ 0x08, 0x001e, "Speaker" },
		{ 0x08, 0x001f, "Headset" },
		{ 0x08, 0x0020, "Hold" },
		{ 0x08, 0x0021, "Microphone" },
		{ 0x08, 0x0022, "Coverage" },
		{ 0x08, 0x0023, "NightMode" },
		{ 0x08, 0x0024, "SendCalls" },
		{ 0x08, 0x0025, "CallPickup" },
		{ 0x08, 0x0026, "Conference" },
		{ 0x08, 0x0027, "Standby" },
		{ 0x08, 0x0028, "CameraOn" },
		{ 0x08, 0x0029, "CameraOff" },
		{ 0x08, 0x002a, "OnLine" },
		{ 0x08, 0x002b, "OffLine" },
		{ 0x08, 0x002c, "Busy" },
		{ 0x08, 0x002d, "Ready" },
		{ 0x08, 0x002e, "PaperOut" },
		{ 0x08, 0x002f, "PaperJam" },
		{ 0x08, 0x0030, "Remote" },
		{ 0x08, 0x0031, "Forward" },
		{ 0x08, 0x0032, "Reverse" },
		{ 0x08, 0x0033, "Stop" },
		{ 0x08, 0x0034, "Rewind" },
		{ 0x08, 0x0035, "FastForward" },
		{ 0x08, 0x0036, "Play" },
		{ 0x08, 0x0037, "Pause" },
		{ 0x08, 0x0038, "Record" },
		{ 0x08, 0x0039, "Error" },
		{ 0x08, 0x003a, "UsageSelectedIndicator" },
		{ 0x08, 0x003b, "UsageInUseIndicator" },
		{ 0x08, 0x003c, "UsageMultiModeIndicator" },
		{ 0x08, 0x003d, "IndicatorOn" },
		{ 0x08, 0x003e, "IndicatorFlash" },
		{ 0x08, 0x003f, "IndicatorSlowBlink" },
		{ 0x08, 0x0040, "IndicatorFastBlink" },
		{ 0x08, 0x0041, "IndicatorOff" },
		{ 0x08, 0x0042, "FlashOnTime" },
		{ 0x08, 0x0043, "SlowBlinkOnTime" },
		{ 0x08, 0x0044, "SlowBlinkOffTime" },
		{ 0x08, 0x0045, "FastBlinkOnTime" },
		{ 0x08, 0x0046, "FastBlinkOffTime" },
		{ 0x08, 0x0047, "UsageIndicatorColor" },
		{ 0x08, 0x0048, "IndicatorRed" },
		{ 0x08, 0x0049, "IndicatorGreen" },
		{ 0x08, 0x004a, "IndicatorAmber" },
		{ 0x08, 0x004b, "GenericIndicator" },
		{ 0x08, 0x004c, "SystemSuspend" },
		{ 0x08, 0x004d, "ExternalPowerConnected" },
		{ 0x08, 0x004e, "IndicatorBlue" },
		{ 0x08, 0x004f, "IndicatorOrange" },
		{ 0x08, 0x0050, "GoodStatus" },
		{ 0x08, 0x0051, "WarningStatus" },
		{ 0x08, 0x0052, "RGBLED" },
		{ 0x08, 0x0053, "RedLEDChannel" },
		{ 0x08, 0x0054, "BlueLEDChannel" },
		{ 0x08, 0x0055, "GreenLEDChannel" },
		{ 0x08, 0x0056, "LEDIntensity" },
		{ 0x08, 0x0057, "SystemMicrophoneMute" },
		{ 0x08, 0x0060, "PlayerIndicator" },
		{ 0x08, 0x0061, "Player1" },
		{ 0x08, 0x0062, "Player2" },
		{ 0x08, 0x0063, "Player3" },
		{ 0x08, 0x0064, "Player4" },
		{ 0x08, 0x0065, "Player5" },
		{ 0x08, 0x0066, "Player6" },
		{ 0x08, 0x0067, "Player7" },
		{ 0x08, 0x0068, "Player8" },
	{ 0x09, 0, "Button" },
	{ 0x0a, 0, "Ordinal" },
	{ 0x0b, 0, "TelephonyDevice" },
		{ 0x0b, 0x0001, "Phone" },
		{ 0x0b, 0x0002, "AnsweringMachine" },
		{ 0x0b, 0x0003, "MessageControls" },
		{ 0x0b, 0x0004, "Handset" },
		{ 0x0b, 0x0005, "Headset" },
		{ 0x0b, 0x0006, "TelephonyKeyPad" },
		{ 0x0b, 0x0007, "ProgrammableButton" },
		{ 0x0b, 0x0020, "HookSwitch" },
		{ 0x0b, 0x0021, "Flash" },
		{ 0x0b, 0x0022, "Feature" },
		{ 0x0b, 0x0023, "Hold" },
		{ 0x0b, 0x0024, "Redial" },
		{ 0x0b, 0x0025, "Transfer" },
		{ 0x0b, 0x0026, "Drop" },
		{ 0x0b, 0x0027, "Park" },
		{ 0x0b, 0x0028, "ForwardCalls" },
		{ 0x0b, 0x0029, "AlternateFunction" },
		{ 0x0b, 0x002a, "Line" },
		{ 0x0b, 0x002b, "SpeakerPhone" },
		{ 0x0b, 0x002c, "Conference" },
		{ 0x0b, 0x002d, "RingEnable" },
		{ 0x0b, 0x002e, "RingSelect" },
		{ 0x0b, 0x002f, "PhoneMute" },
		{ 0x0b, 0x0030, "CallerID" },
		{ 0x0b, 0x0031, "Send" },
		{ 0x0b, 0x0050, "SpeedDial" },
		{ 0x0b, 0x0051, "StoreNumber" },
		{ 0x0b, 0x0052, "RecallNumber" },
		{ 0x0b, 0x0053, "PhoneDirectory" },
		{ 0x0b, 0x0070, "VoiceMail" },
		{ 0x0b, 0x0071, "ScreenCalls" },
		{ 0x0b, 0x0072, "DoNotDisturb" },
		{ 0x0b, 0x0073, "Message" },
		{ 0x0b, 0x0074, "AnswerOnOff" },
		{ 0x0b, 0x0090, "InsideDialTone" },
		{ 0x0b, 0x0091, "OutsideDialTone" },
		{ 0x0b, 0x0092, "InsideRingTone" },
		{ 0x0b, 0x0093, "OutsideRingTone" },
		{ 0x0b, 0x0094, "PriorityRingTone" },
		{ 0x0b, 0x0095, "InsideRingback" },
		{ 0x0b, 0x0096, "PriorityRingback" },
		{ 0x0b, 0x0097, "LineBusyTone" },
		{ 0x0b, 0x0098, "ReorderTone" },
		{ 0x0b, 0x0099, "CallWaitingTone" },
		{ 0x0b, 0x009a, "ConfirmationTone1" },
		{ 0x0b, 0x009b, "ConfirmationTone2" },
		{ 0x0b, 0x009c, "TonesOff" },
		{ 0x0b, 0x009d, "OutsideRingback" },
		{ 0x0b, 0x009e, "Ringer" },
		{ 0x0b, 0x00b0, "PhoneKey0" },
		{ 0x0b, 0x00b1, "PhoneKey1" },
		{ 0x0b, 0x00b2, "PhoneKey2" },
		{ 0x0b, 0x00b3, "PhoneKey3" },
		{ 0x0b, 0x00b4, "PhoneKey4" },
		{ 0x0b, 0x00b5, "PhoneKey5" },
		{ 0x0b, 0x00b6, "PhoneKey6" },
		{ 0x0b, 0x00b7, "PhoneKey7" },
		{ 0x0b, 0x00b8, "PhoneKey8" },
		{ 0x0b, 0x00b9, "PhoneKey9" },
		{ 0x0b, 0x00ba, "PhoneKeyStar" },
		{ 0x0b, 0x00bb, "PhoneKeyPound" },
		{ 0x0b, 0x00bc, "PhoneKeyA" },
		{ 0x0b, 0x00bd, "PhoneKeyB" },
		{ 0x0b, 0x00be, "PhoneKeyC" },
		{ 0x0b, 0x00bf, "PhoneKeyD" },
		{ 0x0b, 0x00c0, "PhoneCallHistoryKey" },
		{ 0x0b, 0x00c1, "PhoneCallerIDKey" },
		{ 0x0b, 0x00c2, "PhoneSettingsKey" },
		{ 0x0b, 0x00f0, "HostControl" },
		{ 0x0b, 0x00f1, "HostAvailable" },
		{ 0x0b, 0x00f2, "HostCallActive" },
		{ 0x0b, 0x00f3, "ActivateHandsetAudio" },
		{ 0x0b, 0x00f4, "RingType" },
		{ 0x0b, 0x00f5, "RedialablePhoneNumber" },
		{ 0x0b, 0x00f8, "StopRingTone" },
		{ 0x0b, 0x00f9, "PSTNRingTone" },
		{ 0x0b, 0x00fa, "HostRingTone" },
		{ 0x0b, 0x00fb, "AlertSoundError" },
		{ 0x0b, 0x00fc, "AlertSoundConfirm" },
		{ 0x0b, 0x00fd, "AlertSoundNotification" },
		{ 0x0b, 0x00fe, "SilentRing" },
		{ 0x0b, 0x0108, "EmailMessageWaiting" },
		{ 0x0b, 0x0109, "VoicemailMessageWaiting" },
		{ 0x0b, 0x010a, "HostHold" },
		{ 0x0b, 0x0110, "IncomingCallHistoryCount" },
		{ 0x0b, 0x0111, "OutgoingCallHistoryCount" },
		{ 0x0b, 0x0112, "IncomingCallHistory" },
		{ 0x0b, 0x0113, "OutgoingCallHistory" },
		{ 0x0b, 0x0114, "PhoneLocale" },
		{ 0x0b, 0x0140, "PhoneTimeSecond" },
		{ 0x0b, 0x0141, "PhoneTimeMinute" },
		{ 0x0b, 0x0142, "PhoneTimeHour" },
		{ 0x0b, 0x0143, "PhoneDateDay" },
		{ 0x0b, 0x0144, "PhoneDateMonth" },
		{ 0x0b, 0x0145, "PhoneDateYear" },
		{ 0x0b, 0x0146, "HandsetNickname" },
		{ 0x0b, 0x0147, "AddressBookID" },
		{ 0x0b, 0x014a, "CallDuration" },
		{ 0x0b, 0x014b, "DualModePhone" },
	{ 0x0c, 0, "Consumer" },
		{ 0x0c, 0x0001, "ConsumerControl" },
		{ 0x0c, 0x0002, "NumericKeyPad" },
		{ 0x0c, 0x0003, "ProgrammableButtons" },
		{ 0x0c, 0x0004, "Microphone" },
		{ 0x0c, 0x0005, "Headphone" },
		{ 0x0c, 0x0006, "GraphicEqualizer" },
		{ 0x0c, 0x0020, "10" },
		{ 0x0c, 0x0021, "100" },
		{ 0x0c, 0x0022, "AMPM" },
		{ 0x0c, 0x0030, "Power" },
		{ 0x0c, 0x0031, "Reset" },
		{ 0x0c, 0x0032, "Sleep" },
		{ 0x0c, 0x0033, "SleepAfter" },
		{ 0x0c, 0x0034, "SleepMode" },
		{ 0x0c, 0x0035, "Illumination" },
		{ 0x0c, 0x0036, "FunctionButtons" },
		{ 0x0c, 0x0040, "Menu" },
		{ 0x0c, 0x0041, "MenuPick" },
		{ 0x0c, 0x0042, "MenuUp" },
		{ 0x0c, 0x0043, "MenuDown" },
		{ 0x0c, 0x0044, "MenuLeft" },
		{ 0x0c, 0x0045, "MenuRight" },
		{ 0x0c, 0x0046, "MenuEscape" },
		{ 0x0c, 0x0047, "MenuValueIncrease" },
		{ 0x0c, 0x0048, "MenuValueDecrease" },
		{ 0x0c, 0x0060, "DataOnScreen" },
		{ 0x0c, 0x0061, "ClosedCaption" },
		{ 0x0c, 0x0062, "ClosedCaptionSelect" },
		{ 0x0c, 0x0063, "VCRTV" },
		{ 0x0c, 0x0064, "BroadcastMode" },
		{ 0x0c, 0x0065, "Snapshot" },
		{ 0x0c, 0x0066, "Still" },
		{ 0x0c, 0x0067, "PictureinPictureToggle" },
		{ 0x0c, 0x0068, "PictureinPictureSwap" },
		{ 0x0c, 0x0069, "RedMenuButton" },
		{ 0x0c, 0x006a, "GreenMenuButton" },
		{ 0x0c, 0x006b, "BlueMenuButton" },
		{ 0x0c, 0x006c, "YellowMenuButton" },
		{ 0x0c, 0x006d, "Aspect" },
		{ 0x0c, 0x006e, "3DModeSelect" },
		{ 0x0c, 0x006f, "DisplayBrightnessIncrement" },
		{ 0x0c, 0x0070, "DisplayBrightnessDecrement" },
		{ 0x0c, 0x0071, "DisplayBrightness" },
		{ 0x0c, 0x0072, "DisplayBacklightToggle" },
		{ 0x0c, 0x0073, "DisplaySetBrightnesstoMinimum" },
		{ 0x0c, 0x0074, "DisplaySetBrightnesstoMaximum" },
		{ 0x0c, 0x0075, "DisplaySetAutoBrightness" },
		{ 0x0c, 0x0076, "CameraAccessEnabled" },
		{ 0x0c, 0x0077, "CameraAccessDisabled" },
		{ 0x0c, 0x0078, "CameraAccessToggle" },
		{ 0x0c, 0x0079, "KeyboardBrightnessIncrement" },
		{ 0x0c, 0x007a, "KeyboardBrightnessDecrement" },
		{ 0x0c, 0x007b, "KeyboardBacklightSetLevel" },
		{ 0x0c, 0x007c, "KeyboardBacklightOOC" },
		{ 0x0c, 0x007d, "KeyboardBacklightSetMinimum" },
		{ 0x0c, 0x007e, "KeyboardBacklightSetMaximum" },
		{ 0x0c, 0x007f, "KeyboardBacklightAuto" },
		{ 0x0c, 0x0080, "Selection" },
		{ 0x0c, 0x0081, "AssignSelection" },
		{ 0x0c, 0x0082, "ModeStep" },
		{ 0x0c, 0x0083, "RecallLast" },
		{ 0x0c, 0x0084, "EnterChannel" },
		{ 0x0c, 0x0085, "OrderMovie" },
		{ 0x0c, 0x0086, "Channel" },
		{ 0x0c, 0x0087, "MediaSelection" },
		{ 0x0c, 0x0088, "MediaSelectComputer" },
		{ 0x0c, 0x0089, "MediaSelectTV" },
		{ 0x0c, 0x008a, "MediaSelectWWW" },
		{ 0x0c, 0x008b, "MediaSelectDVD" },
		{ 0x0c, 0x008c, "MediaSelectTelephone" },
		{ 0x0c, 0x008d, "MediaSelectProgramGuide" },
		{ 0x0c, 0x008e, "MediaSelectVideoPhone" },
		{ 0x0c, 0x008f, "MediaSelectGames" },
		{ 0x0c, 0x0090, "MediaSelectMessages" },
		{ 0x0c, 0x0091, "MediaSelectCD" },
		{ 0x0c, 0x0092, "MediaSelectVCR" },
		{ 0x0c, 0x0093, "MediaSelectTuner" },
		{ 0x0c, 0x0094, "Quit" },
		{ 0x0c, 0x0095, "Help" },
		{ 0x0c, 0x0096, "MediaSelectTape" },
		{ 0x0c, 0x0097, "MediaSelectCable" },
		{ 0x0c, 0x0098, "MediaSelectSatellite" },
		{ 0x0c, 0x0099, "MediaSelectSecurity" },
		{ 0x0c, 0x009a, "MediaSelectHome" },
		{ 0x0c, 0x009b, "MediaSelectCall" },
		{ 0x0c, 0x009c, "ChannelIncrement" },
		{ 0x0c, 0x009d, "ChannelDecrement" },
		{ 0x0c, 0x009e, "MediaSelectSAP" },
		{ 0x0c, 0x00a0, "VCRPlus" },
		{ 0x0c, 0x00a1, "Once" },
		{ 0x0c, 0x00a2, "Daily" },
		{ 0x0c, 0x00a3, "Weekly" },
		{ 0x0c, 0x00a4, "Monthly" },
		{ 0x0c, 0x00b0, "Play" },
		{ 0x0c, 0x00b1, "Pause" },
		{ 0x0c, 0x00b2, "Record" },
		{ 0x0c, 0x00b3, "FastForward" },
		{ 0x0c, 0x00b4, "Rewind" },
		{ 0x0c, 0x00b5, "ScanNextTrack" },
		{ 0x0c, 0x00b6, "ScanPreviousTrack" },
		{ 0x0c, 0x00b7, "Stop" },
		{ 0x0c, 0x00b8, "Eject" },
		{ 0x0c, 0x00b9, "RandomPlay" },
		{ 0x0c, 0x00ba, "SelectDisc" },
		{ 0x0c, 0x00bb, "EnterDisc" },
		{ 0x0c, 0x00bc, "Repeat" },
		{ 0x0c, 0x00bd, "Tracking" },
		{ 0x0c, 0x00be, "TrackNormal" },
		{ 0x0c, 0x00bf, "SlowTracking" },
		{ 0x0c, 0x00c0, "FrameForward" },
		{ 0x0c, 0x00c1, "FrameBack" },
		{ 0x0c, 0x00c2, "Mark" },
		{ 0x0c, 0x00c3, "ClearMark" },
		{ 0x0c, 0x00c4, "RepeatFromMark" },
		{ 0x0c, 0x00c5, "ReturnToMark" },
		{ 0x0c, 0x00c6, "SearchMarkForward" },
		{ 0x0c, 0x00c7, "SearchMarkBackwards" },
		{ 0x0c, 0x00c8, "CounterReset" },
		{ 0x0c, 0x00c9, "ShowCounter" },
		{ 0x0c, 0x00ca, "TrackingIncrement" },
		{ 0x0c, 0x00cb, "TrackingDecrement" },
		{ 0x0c, 0x00cc, "StopEject" },
		{ 0x0c, 0x00cd, "PlayPause" },
		{ 0x0c, 0x00ce, "PlaySkip" },
		{ 0x0c, 0x00cf, "VoiceCommand" },
		{ 0x0c, 0x00d0, "InvokeCaptureInterface" },
		{ 0x0c, 0x00d1, "StartorStopGameRecording" },
		{ 0x0c, 0x00d2, "HistoricalGameCapture" },
		{ 0x0c, 0x00d3, "CaptureGameScreenshot" },
		{ 0x0c, 0x00d4, "ShoworHideRecordingIndicator" },
		{ 0x0c, 0x00d5, "StartorStopMicrophoneCapture" },
		{ 0x0c, 0x00d6, "StartorStopCameraCapture" },
		{ 0x0c, 0x00d7, "StartorStopGameBroadcast" },
		{ 0x0c, 0x00d8, "StartorStopVoiceDictationSession" },
		{ 0x0c, 0x00d9, "InvokeDismissEmojiPicker" },
		{ 0x0c, 0x00e0, "Volume" },
		{ 0x0c, 0x00e1, "Balance" },
		{ 0x0c, 0x00e2, "Mute" },
		{ 0x0c, 0x00e3, "Bass" },
		{ 0x0c, 0x00e4, "Treble" },
		{ 0x0c, 0x00e5, "BassBoost" },
		{ 0x0c, 0x00e6, "SurroundMode" },
		{ 0x0c, 0x00e7, "Loudness" },
		{ 0x0c, 0x00e8, "MPX" },
		{ 0x0c, 0x00e9, "VolumeIncrement" },
		{ 0x0c, 0x00ea, "VolumeDecrement" },
		{ 0x0c, 0x00f0, "SpeedSelect" },
		{ 0x0c, 0x00f1, "PlaybackSpeed" },
		{ 0x0c, 0x00f2, "StandardPlay" },
		{ 0x0c, 0x00f3, "LongPlay" },
		{ 0x0c, 0x00f4, "ExtendedPlay" },
		{ 0x0c, 0x00f5, "Slow" },
		{ 0x0c, 0x0100, "FanEnable" },
		{ 0x0c, 0x0101, "FanSpeed" },
		{ 0x0c, 0x0102, "LightEnable" },
		{ 0x0c, 0x0103, "LightIlluminationLevel" },
		{ 0x0c, 0x0104, "ClimateControlEnable" },
		{ 0x0c, 0x0105, "RoomTemperature" },
		{ 0x0c, 0x0106, "SecurityEnable" },
		{ 0x0c, 0x0107, "FireAlarm" },
		{ 0x0c, 0x0108, "PoliceAlarm" },
		{ 0x0c, 0x0109, "Proximity" },
		{ 0x0c, 0x010a, "Motion" },
		{ 0x0c, 0x010b, "DuressAlarm" },
		{ 0x0c, 0x010c, "HoldupAlarm" },
		{ 0x0c, 0x010d, "MedicalAlarm" },
		{ 0x0c, 0x0150, "BalanceRight" },
		{ 0x0c, 0x0151, "BalanceLeft" },
		{ 0x0c, 0x0152, "BassIncrement" },
		{ 0x0c, 0x0153, "BassDecrement" },
		{ 0x0c, 0x0154, "TrebleIncrement" },
		{ 0x0c, 0x0155, "TrebleDecrement" },
		{ 0x0c, 0x0160, "SpeakerSystem" },
		{ 0x0c, 0x0161, "ChannelLeft" },
		{ 0x0c, 0x0162, "ChannelRight" },
		{ 0x0c, 0x0163, "ChannelCenter" },
		{ 0x0c, 0x0164, "ChannelFront" },
		{ 0x0c, 0x0165, "ChannelCenterFront" },
		{ 0x0c, 0x0166, "ChannelSide" },
		{ 0x0c, 0x0167, "ChannelSurround" },
		{ 0x0c, 0x0168, "ChannelLowFrequencyEnhancement" },
		{ 0x0c, 0x0169, "ChannelTop" },
		{ 0x0c, 0x016a, "ChannelUnknown" },
		{ 0x0c, 0x0170, "Subchannel" },
		{ 0x0c, 0x0171, "SubchannelIncrement" },
		{ 0x0c, 0x0172, "SubchannelDecrement" },
		{ 0x0c, 0x0173, "AlternateAudioIncrement" },
		{ 0x0c, 0x0174, "AlternateAudioDecrement" },
		{ 0x0c, 0x0180, "ApplicationLaunchButtons" },
		{ 0x0c, 0x0181, "ALLaunchButtonConfigurationTool" },
		{ 0x0c, 0x0182, "ALProgrammableButtonConfiguration" },
		{ 0x0c, 0x0183, "ALConsumerControlConfiguration" },
		{ 0x0c, 0x0184, "ALWordProcessor" },
		{ 0x0c, 0x0185, "ALTextEditor" },
		{ 0x0c, 0x0186, "ALSpreadsheet" },
		{ 0x0c, 0x0187, "ALGraphicsEditor" },
		{ 0x0c, 0x0188, "ALPresentationApp" },
		{ 0x0c, 0x0189, "ALDatabaseApp" },
		{ 0x0c, 0x018a, "ALEmailReader" },
		{ 0x0c, 0x018b, "ALNewsreader" },
		{ 0x0c, 0x018c, "ALVoicemail" },
		{ 0x0c, 0x018d, "ALContactsAddressBook" },
		{ 0x0c, 0x018e, "ALCalendarSchedule" },
		{ 0x0c, 0x018f, "ALTaskProjectManager" },
		{ 0x0c, 0x0190, "ALLogJournalTimecard" },
		{ 0x0c, 0x0191, "ALCheckbookFinance" },
		{ 0x0c, 0x0192, "ALCalculator" },
		{ 0x0c, 0x0193, "ALAVCapturePlayback" },
		{ 0x0c, 0x0194, "ALLocalMachineBrowser" },
		{ 0x0c, 0x0195, "ALLANWANBrowser" },
		{ 0x0c, 0x0196, "ALInternetBrowser" },
		{ 0x0c, 0x0197, "ALRemoteNetworkingISPConnect" },
		{ 0x0c, 0x0198, "ALNetworkConference" },
		{ 0x0c, 0x0199, "ALNetworkChat" },
		{ 0x0c, 0x019a, "ALTelephonyDialer" },
		{ 0x0c, 0x019b, "ALLogon" },
		{ 0x0c, 0x019c, "ALLogoff" },
		{ 0x0c, 0x019d, "ALLogonLogoff" },
		{ 0x0c, 0x019e, "ALTerminalLockScreensaver" },
		{ 0x0c, 0x019f, "ALControlPanel" },
		{ 0x0c, 0x01a0, "ALCommandLineProcessorRun" },
		{ 0x0c, 0x01a1, "ALProcessTaskManager" },
		{ 0x0c, 0x01a2, "ALSelectTaskApplication" },
		{ 0x0c, 0x01a3, "ALNextTaskApplication" },
		{ 0x0c, 0x01a4, "ALPreviousTaskApplication" },
		{ 0x0c, 0x01a5, "ALPreemptiveHaltTaskApplication" },
		{ 0x0c, 0x01a6, "ALIntegratedHelpCenter" },
		{ 0x0c, 0x01a7, "ALDocuments" },
		{ 0x0c, 0x01a8, "ALThesaurus" },
		{ 0x0c, 0x01a9, "ALDictionary" },
		{ 0x0c, 0x01aa, "ALDesktop" },
		{ 0x0c, 0x01ab, "ALSpellCheck" },
		{ 0x0c, 0x01ac, "ALGrammarCheck" },
		{ 0x0c, 0x01ad, "ALWirelessStatus" },
		{ 0x0c, 0x01ae, "ALKeyboardLayout" },
		{ 0x0c, 0x01af, "ALVirusProtection" },
		{ 0x0c, 0x01b0, "ALEncryption" },
		{ 0x0c, 0x01b1, "ALScreenSaver" },
		{ 0x0c, 0x01b2, "ALAlarms" },
		{ 0x0c, 0x01b3, "ALClock" },
		{ 0x0c, 0x01b4, "ALFileBrowser" },
		{ 0x0c, 0x01b5, "ALPowerStatus" },
		{ 0x0c, 0x01b6, "ALImageBrowser" },
		{ 0x0c, 0x01b7, "ALAudioBrowser" },
		{ 0x0c, 0x01b8, "ALMovieBrowser" },
		{ 0x0c, 0x01b9, "ALDigitalRightsManager" },
		{ 0x0c, 0x01ba, "ALDigitalWallet" },
		{ 0x0c, 0x01bc, "ALInstantMessaging" },
		{ 0x0c, 0x01bd, "ALOEMFeaturesTipsTutorialBrowser" },
		{ 0x0c, 0x01be, "ALOEMHelp" },
		{ 0x0c, 0x01bf, "ALOnlineCommunity" },
		{ 0x0c, 0x01c0, "ALEntertainmentContentBrowser" },
		{ 0x0c, 0x01c1, "ALOnlineShoppingBrowser" },
		{ 0x0c, 0x01c2, "ALSmartCardInformationHelp" },
		{ 0x0c, 0x01c3, "ALMarketMonitorFinanceBrowser" },
		{ 0x0c, 0x01c4, "ALCustomizedCorporateNewsBrowser" },
		{ 0x0c, 0x01c5, "ALOnlineActivityBrowser" },
		{ 0x0c, 0x01c6, "ALResearchSearchBrowser" },
		{ 0x0c, 0x01c7, "ALAudioPlayer" },
		{ 0x0c, 0x01c8, "ALMessageStatus" },
		{ 0x0c, 0x01c9, "ALContactSync" },
		{ 0x0c, 0x01ca, "ALNavigation" },
		{ 0x0c, 0x01cb, "ALContextawareDesktopAssistant" },
		{ 0x0c, 0x0200, "GenericGUIApplicationControls" },
		{ 0x0c, 0x0201, "ACNew" },
		{ 0x0c, 0x0202, "ACOpen" },
		{ 0x0c, 0x0203, "ACClose" },
		{ 0x0c, 0x0204, "ACExit" },
		{ 0x0c, 0x0205, "ACMaximize" },
		{ 0x0c, 0x0206, "ACMinimize" },
		{ 0x0c, 0x0207, "ACSave" },
		{ 0x0c, 0x0208, "ACPrint" },
		{ 0x0c, 0x0209, "ACProperties" },
		{ 0x0c, 0x021a, "ACUndo" },
		{ 0x0c, 0x021b, "ACCopy" },
		{ 0x0c, 0x021c, "ACCut" },
		{ 0x0c, 0x021d, "ACPaste" },
		{ 0x0c, 0x021e, "ACSelectAll" },
		{ 0x0c, 0x021f, "ACFind" },
		{ 0x0c, 0x0220, "ACFindandReplace" },
		{ 0x0c, 0x0221, "ACSearch" },
		{ 0x0c, 0x0222, "ACGoTo" },
		{ 0x0c, 0x0223, "ACHome" },
		{ 0x0c, 0x0224, "ACBack" },
		{ 0x0c, 0x0225, "ACForward" },
		{ 0x0c, 0x0226, "ACStop" },
		{ 0x0c, 0x0227, "ACRefresh" },
		{ 0x0c, 0x0228, "ACPreviousLink" },
		{ 0x0c, 0x0229, "ACNextLink" },
		{ 0x0c, 0x022a, "ACBookmarks" },
		{ 0x0c, 0x022b, "ACHistory" },
		{ 0x0c, 0x022c, "ACSubscriptions" },
		{ 0x0c, 0x022d, "ACZoomIn" },
		{ 0x0c, 0x022e, "ACZoomOut" },
		{ 0x0c, 0x022f, "ACZoom" },
		{ 0x0c, 0x0230, "ACFullScreenView" },
		{ 0x0c, 0x0231, "ACNormalView" },
		{ 0x0c, 0x0232, "ACViewToggle" },
		{ 0x0c, 0x0233, "ACScrollUp" },
		{ 0x0c, 0x0234, "ACScrollDown" },
		{ 0x0c, 0x0235, "ACScroll" },
		{ 0x0c, 0x0236, "ACPanLeft" },
		{ 0x0c, 0x0237, "ACPanRight" },
		{ 0x0c, 0x0238, "ACPan" },
		{ 0x0c, 0x0239, "ACNewWindow" },
		{ 0x0c, 0x023a, "ACTileHorizontally" },
		{ 0x0c, 0x023b, "ACTileVertically" },
		{ 0x0c, 0x023c, "ACFormat" },
		{ 0x0c, 0x023d, "ACEdit" },
		{ 0x0c, 0x023e, "ACBold" },
		{ 0x0c, 0x023f, "ACItalics" },
		{ 0x0c, 0x0240, "ACUnderline" },
		{ 0x0c, 0x0241, "ACStrikethrough" },
		{ 0x0c, 0x0242, "ACSubscript" },
		{ 0x0c, 0x0243, "ACSuperscript" },
		{ 0x0c, 0x0244, "ACAllCaps" },
		{ 0x0c, 0x0245, "ACRotate" },
		{ 0x0c, 0x0246, "ACResize" },
		{ 0x0c, 0x0247, "ACFlipHorizontal" },
		{ 0x0c, 0x0248, "ACFlipVertical" },
		{ 0x0c, 0x0249, "ACMirrorHorizontal" },
		{ 0x0c, 0x024a, "ACMirrorVertical" },
		{ 0x0c, 0x024b, "ACFontSelect" },
		{ 0x0c, 0x024c, "ACFontColor" },
		{ 0x0c, 0x024d, "ACFontSize" },
		{ 0x0c, 0x024e, "ACJustifyLeft" },
		{ 0x0c, 0x024f, "ACJustifyCenterH" },
		{ 0x0c, 0x0250, "ACJustifyRight" },
		{ 0x0c, 0x0251, "ACJustifyBlockH" },
		{ 0x0c, 0x0252, "ACJustifyTop" },
		{ 0x0c, 0x0253, "ACJustifyCenterV" },
		{ 0x0c, 0x0254, "ACJustifyBottom" },
		{ 0x0c, 0x0255, "ACJustifyBlockV" },
		{ 0x0c, 0x0256, "ACIndentDecrease" },
		{ 0x0c, 0x0257, "ACIndentIncrease" },
		{ 0x0c, 0x0258, "ACNumberedList" },
		{ 0x0c, 0x0259, "ACRestartNumbering" },
		{ 0x0c, 0x025a, "ACBulletedList" },
		{ 0x0c, 0x025b, "ACPromote" },
		{ 0x0c, 0x025c, "ACDemote" },
		{ 0x0c, 0x025d, "ACYes" },
		{ 0x0c, 0x025e, "ACNo" },
		{ 0x0c, 0x025f, "ACCancel" },
		{ 0x0c, 0x0260, "ACCatalog" },
		{ 0x0c, 0x0261, "ACBuyCheckout" },
		{ 0x0c, 0x0262, "ACAddtoCart" },
		{ 0x0c, 0x0263, "ACExpand" },
		{ 0x0c, 0x0264, "ACExpandAll" },
		{ 0x0c, 0x0265, "ACCollapse" },
		{ 0x0c, 0x0266, "ACCollapseAll" },
		{ 0x0c, 0x0267, "ACPrintPreview" },
		{ 0x0c, 0x0268, "ACPasteSpecial" },
		{ 0x0c, 0x0269, "ACInsertMode" },
		{ 0x0c, 0x026a, "ACDelete" },
		{ 0x0c, 0x026b, "ACLock" },
		{ 0x0c, 0x026c, "ACUnlock" },
		{ 0x0c, 0x026d, "ACProtect" },
		{ 0x0c, 0x026e, "ACUnprotect" },
		{ 0x0c, 0x026f, "ACAttachComment" },
		{ 0x0c, 0x0270, "ACDeleteComment" },
		{ 0x0c, 0x0271, "ACViewComment" },
		{ 0x0c, 0x0272, "ACSelectWord" },
		{ 0x0c, 0x0273, "ACSelectSentence" },
		{ 0x0c, 0x0274, "ACSelectParagraph" },
		{ 0x0c, 0x0275, "ACSelectColumn" },
		{ 0x0c, 0x0276, "ACSelectRow" },
		{ 0x0c, 0x0277, "ACSelectTable" },
		{ 0x0c, 0x0278, "ACSelectObject" },
		{ 0x0c, 0x0279, "ACRedoRepeat" },
		{ 0x0c, 0x027a, "ACSort" },
		{ 0x0c, 0x027b, "ACSortAscending" },
		{ 0x0c, 0x027c, "ACSortDescending" },
		{ 0x0c, 0x027d, "ACFilter" },
		{ 0x0c, 0x027e, "ACSetClock" },
		{ 0x0c, 0x027f, "ACViewClock" },
		{ 0x0c, 0x0280, "ACSelectTimeZone" },
		{ 0x0c, 0x0281, "ACEditTimeZones" },
		{ 0x0c, 0x0282, "ACSetAlarm" },
		{ 0x0c, 0x0283, "ACClearAlarm" },
		{ 0x0c, 0x0284, "ACSnoozeAlarm" },
		{ 0x0c, 0x0285, "ACResetAlarm" },
		{ 0x0c, 0x0286, "ACSynchronize" },
		{ 0x0c, 0x0287, "ACSendReceive" },
		{ 0x0c, 0x0288, "ACSendTo" },
		{ 0x0c, 0x0289, "ACReply" },
		{ 0x0c, 0x028a, "ACReplyAll" },
		{ 0x0c, 0x028b, "ACForwardMsg" },
		{ 0x0c, 0x028c, "ACSend" },
		{ 0x0c, 0x028d, "ACAttachFile" },
		{ 0x0c, 0x028e, "ACUpload" },
		{ 0x0c, 0x028f, "ACDownloadSaveTargetAs" },
		{ 0x0c, 0x0290, "ACSetBorders" },
		{ 0x0c, 0x0291, "ACInsertRow" },
		{ 0x0c, 0x0292, "ACInsertColumn" },
		{ 0x0c, 0x0293, "ACInsertFile" },
		{ 0x0c, 0x0294, "ACInsertPicture" },
		{ 0x0c, 0x0295, "ACInsertObject" },
		{ 0x0c, 0x0296, "ACInsertSymbol" },
		{ 0x0c, 0x0297, "ACSaveandClose" },
		{ 0x0c, 0x0298, "ACRename" },
		{ 0x0c, 0x0299, "ACMerge" },
		{ 0x0c, 0x029a, "ACSplit" },
		{ 0x0c, 0x029b, "ACDisributeHorizontally" },
		{ 0x0c, 0x029c, "ACDistributeVertically" },
		{ 0x0c, 0x029d, "ACNextKeyboardLayoutSelect" },
		{ 0x0c, 0x029e, "ACNavigationGuidance" },
		{ 0x0c, 0x029f, "ACDesktopShowAllWindows" },
		{ 0x0c, 0x02a0, "ACSoftKeyLeft" },
		{ 0x0c, 0x02a1, "ACSoftKeyRight" },
		{ 0x0c, 0x02a2, "ACDesktopShowAllApplications" },
		{ 0x0c, 0x02b0, "ACIdleKeepAlive" },
		{ 0x0c, 0x02c0, "ExtendedKeyboardAttributesCollection" },
		{ 0x0c, 0x02c1, "KeyboardFormFactor" },
		{ 0x0c, 0x02c2, "KeyboardKeyType" },
		{ 0x0c, 0x02c3, "KeyboardPhysicalLayout" },
		{ 0x0c, 0x02c4, "VendorSpecificKeyboardPhysicalLayout" },
		{ 0x0c, 0x02c5, "KeyboardIETFLanguageTagIndex" },
		{ 0x0c, 0x02c6, "ImplementedKeyboardInputAssistControls" },
		{ 0x0c, 0x02c7, "KeyboardInputAssistPrevious" },
		{ 0x0c, 0x02c8, "KeyboardInputAssistNext" },
		{ 0x0c, 0x02c9, "KeyboardInputAssistPreviousGroup" },
		{ 0x0c, 0x02ca, "KeyboardInputAssistNextGroup" },
		{ 0x0c, 0x02cb, "KeyboardInputAssistAccept" },
		{ 0x0c, 0x02cc, "KeyboardInputAssistCancel" },
		{ 0x0c, 0x02d0, "PrivacyScreenToggle" },
		{ 0x0c, 0x02d1, "PrivacyScreenLevelDecrement" },
		{ 0x0c, 0x02d2, "PrivacyScreenLevelIncrement" },
		{ 0x0c, 0x02d3, "PrivacyScreenLevelMinimum" },
		{ 0x0c, 0x02d4, "PrivacyScreenLevelMaximum" },
		{ 0x0c, 0x0500, "ContactEdited" },
		{ 0x0c, 0x0501, "ContactAdded" },
		{ 0x0c, 0x0502, "ContactRecordActive" },
		{ 0x0c, 0x0503, "ContactIndex" },
		{ 0x0c, 0x0504, "ContactNickname" },
		{ 0x0c, 0x0505, "ContactFirstName" },
		{ 0x0c, 0x0506, "ContactLastName" },
		{ 0x0c, 0x0507, "ContactFullName" },
		{ 0x0c, 0x0508, "ContactPhoneNumberPersonal" },
		{ 0x0c, 0x0509, "ContactPhoneNumberBusiness" },
		{ 0x0c, 0x050a, "ContactPhoneNumberMobile" },
		{ 0x0c, 0x050b, "ContactPhoneNumberPager" },
		{ 0x0c, 0x050c, "ContactPhoneNumberFax" },
		{ 0x0c, 0x050d, "ContactPhoneNumberOther" },
		{ 0x0c, 0x050e, "ContactEmailPersonal" },
		{ 0x0c, 0x050f, "ContactEmailBusiness" },
		{ 0x0c, 0x0510, "ContactEmailOther" },
		{ 0x0c, 0x0511, "ContactEmailMain" },
		{ 0x0c, 0x0512, "ContactSpeedDialNumber" },
		{ 0x0c, 0x0513, "ContactStatusFlag" },
		{ 0x0c, 0x0514, "ContactMisc" },
	{ 0x0d, 0, "Digitizers" },
		{ 0x0d, 0x0001, "Digitizer" },
		{ 0x0d, 0x0002, "Pen" },
		{ 0x0d, 0x0003, "LightPen" },
		{ 0x0d, 0x0004, "TouchScreen" },
		{ 0x0d, 0x0005, "TouchPad" },
		{ 0x0d, 0x0006, "Whiteboard" },
		{ 0x0d, 0x0007, "CoordinateMeasuringMachine" },
		{ 0x0d, 0x0008, "3DDigitizer" },
		{ 0x0d, 0x0009, "StereoPlotter" },
		{ 0x0d, 0x000a, "ArticulatedArm" },
		{ 0x0d, 0x000b, "Armature" },
		{ 0x0d, 0x000c, "MultiplePointDigitizer" },
		{ 0x0d, 0x000d, "FreeSpaceWand" },
		{ 0x0d, 0x000e, "DeviceConfiguration" },
		{ 0x0d, 0x000f, "CapacitiveHeatMapDigitizer" },
		{ 0x0d, 0x0020, "Stylus" },
		{ 0x0d, 0x0021, "Puck" },
		{ 0x0d, 0x0022, "Finger" },
		{ 0x0d, 0x0023, "Devicesettings" },
		{ 0x0d, 0x0024, "CharacterGesture" },
		{ 0x0d, 0x0030, "TipPressure" },
		{ 0x0d, 0x0031, "BarrelPressure" },
		{ 0x0d, 0x0032, "InRange" },
		{ 0x0d, 0x0033, "Touch" },
		{ 0x0d, 0x0034, "Untouch" },
		{ 0x0d, 0x0035, "Tap" },
		{ 0x0d, 0x0036, "Quality" },
		{ 0x0d, 0x0037, "DataValid" },
		{ 0x0d, 0x0038, "TransducerIndex" },
		{ 0x0d, 0x0039, "TabletFunctionKeys" },
		{ 0x0d, 0x003a, "ProgramChangeKeys" },
		{ 0x0d, 0x003b, "BatteryStrength" },
		{ 0x0d, 0x003c, "Invert" },
		{ 0x0d, 0x003d, "XTilt" },
		{ 0x0d, 0x003e, "YTilt" },
		{ 0x0d, 0x003f, "Azimuth" },
		{ 0x0d, 0x0040, "Altitude" },
		{ 0x0d, 0x0041, "Twist" },
		{ 0x0d, 0x0042, "TipSwitch" },
		{ 0x0d, 0x0043, "SecondaryTipSwitch" },
		{ 0x0d, 0x0044, "BarrelSwitch" },
		{ 0x0d, 0x0045, "Eraser" },
		{ 0x0d, 0x0046, "TabletPick" },
		{ 0x0d, 0x0047, "TouchValid" },
		{ 0x0d, 0x0048, "Width" },
		{ 0x0d, 0x0049, "Height" },
		{ 0x0d, 0x0051, "ContactIdentifier" },
		{ 0x0d, 0x0052, "DeviceMode" },
		{ 0x0d, 0x0053, "DeviceIdentifier" },
		{ 0x0d, 0x0054, "ContactCount" },
		{ 0x0d, 0x0055, "ContactCountMaximum" },
		{ 0x0d, 0x0056, "ScanTime" },
		{ 0x0d, 0x0057, "SurfaceSwitch" },
		{ 0x0d, 0x0058, "ButtonSwitch" },
		{ 0x0d, 0x0059, "PadType" },
		{ 0x0d, 0x005a, "SecondaryBarrelSwitch" },
		{ 0x0d, 0x005b, "TransducerSerialNumber" },
		{ 0x0d, 0x005c, "PreferredColor" },
		{ 0x0d, 0x005d, "PreferredColorisLocked" },
		{ 0x0d, 0x005e, "PreferredLineWidth" },
		{ 0x0d, 0x005f, "PreferredLineWidthisLocked" },
		{ 0x0d, 0x0060, "LatencyMode" },
		{ 0x0d, 0x0061, "GestureCharacterQuality" },
		{ 0x0d, 0x0062, "CharacterGestureDataLength" },
		{ 0x0d, 0x0063, "CharacterGestureData" },
		{ 0x0d, 0x0064, "GestureCharacterEncoding" },
		{ 0x0d, 0x0065, "UTF8CharacterGestureEncoding" },
		{ 0x0d, 0x0066, "UTF16LittleEndianCharacterGestureEncoding" },
		{ 0x0d, 0x0067, "UTF16BigEndianCharacterGestureEncoding" },
		{ 0x0d, 0x0068, "UTF32LittleEndianCharacterGestureEncoding" },
		{ 0x0d, 0x0069, "UTF32BigEndianCharacterGestureEncoding" },
		{ 0x0d, 0x006a, "CapacitiveHeatMapProtocolVendorID" },
		{ 0x0d, 0x006b, "CapacitiveHeatMapProtocolVersion" },
		{ 0x0d, 0x006c, "CapacitiveHeatMapFrameData" },
		{ 0x0d, 0x006d, "GestureCharacterEnable" },
		{ 0x0d, 0x006e, "TransducerSerialNumberPart2" },
		{ 0x0d, 0x006f, "NoPreferredColor" },
		{ 0x0d, 0x0070, "PreferredLineStyle" },
		{ 0x0d, 0x0071, "PreferredLineStyleisLocked" },
		{ 0x0d, 0x0072, "Ink" },
		{ 0x0d, 0x0073, "Pencil" },
		{ 0x0d, 0x0074, "Highlighter" },
		{ 0x0d, 0x0075, "ChiselMarker" },
		{ 0x0d, 0x0076, "Brush" },
		{ 0x0d, 0x0077, "NoPreference" },
		{ 0x0d, 0x0080, "DigitizerDiagnostic" },
		{ 0x0d, 0x0081, "DigitizerError" },
		{ 0x0d, 0x0082, "ErrNormalStatus" },
		{ 0x0d, 0x0083, "ErrTransducersExceeded" },
		{ 0x0d, 0x0084, "ErrFullTransFeaturesUnavailable" },
		{ 0x0d, 0x0085, "ErrChargeLow" },
		{ 0x0d, 0x0090, "TransducerSoftwareInfo" },
		{ 0x0d, 0x0091, "TransducerVendorId" },
		{ 0x0d, 0x0092, "TransducerProductId" },
		{ 0x0d, 0x0093, "DeviceSupportedProtocols" },
		{ 0x0d, 0x0094, "TransducerSupportedProtocols" },
		{ 0x0d, 0x0095, "NoProtocol" },
		{ 0x0d, 0x0096, "WacomAESProtocol" },
		{ 0x0d, 0x0097, "USIProtocol" },
		{ 0x0d, 0x0098, "MicrosoftPenProtocol" },
		{ 0x0d, 0x00a0, "SupportedReportRates" },
		{ 0x0d, 0x00a1, "ReportRate" },
		{ 0x0d, 0x00a2, "TransducerConnected" },
		{ 0x0d, 0x00a3, "SwitchDisabled" },
		{ 0x0d, 0x00a4, "SwitchUnimplemented" },
		{ 0x0d, 0x00a5, "TransducerSwitches" },
		{ 0x0d, 0x00a6, "TransducerIndexSelector" },
		{ 0x0d, 0x00b0, "ButtonPressThreshold" },
	{ 0x0e, 0, "Haptics" },
		{ 0x0e, 0x0001, "SimpleHapticController" },
		{ 0x0e, 0x0010, "WaveformList" },
		{ 0x0e, 0x0011, "DurationList" },
		{ 0x0e, 0x0020, "AutoTrigger" },
		{ 0x0e, 0x0021, "ManualTrigger" },
		{ 0x0e, 0x0022, "AutoTriggerAssociatedControl" },
		{ 0x0e, 0x0023, "Intensity" },
		{ 0x0e, 0x0024, "RepeatCount" },
		{ 0x0e, 0x0025, "RetriggerPeriod" },
		{ 0x0e, 0x0026, "WaveformVendorPage" },
		{ 0x0e, 0x0027, "WaveformVendorID" },
		{ 0x0e, 0x0028, "WaveformCutoffTime" },
		{ 0x0e, 0x1001, "WaveformNone" },
		{ 0x0e, 0x1002, "WaveformStop" },
		{ 0x0e, 0x1003, "WaveformClick" },
		{ 0x0e, 0x1004, "WaveformBuzzContinuous" },
		{ 0x0e, 0x1005, "WaveformRumbleContinuous" },
		{ 0x0e, 0x1006, "WaveformPress" },
		{ 0x0e, 0x1007, "WaveformRelease" },
		{ 0x0e, 0x1008, "WaveformHover" },
		{ 0x0e, 0x1009, "WaveformSuccess" },
		{ 0x0e, 0x100a, "WaveformError" },
		{ 0x0e, 0x100b, "WaveformInkContinuous" },
		{ 0x0e, 0x100c, "WaveformPencilContinuous" },
		{ 0x0e, 0x100d, "WaveformMarkerContinuous" },
		{ 0x0e, 0x100e, "WaveformChiselMarkerContinuous" },
		{ 0x0e, 0x100f, "WaveformBrushContinuous" },
		{ 0x0e, 0x1010, "WaveformEraserContinuous" },
		{ 0x0e, 0x1011, "WaveformSparkleContinuous" },
	{ 0x0f, 0, "PhysicalInputDevice" },
		{ 0x0f, 0x0001, "PhysicalInputDevice" },
		{ 0x0f, 0x0020, "Normal" },
		{ 0x0f, 0x0021, "SetEffectReport" },
		{ 0x0f, 0x0022, "EffectParameterBlockIndex" },
		{ 0x0f, 0x0023, "ParameterBlockOffset" },
		{ 0x0f, 0x0024, "ROMFlag" },
		{ 0x0f, 0x0025, "EffectType" },
		{ 0x0f, 0x0026, "ETConstantForce" },
		{ 0x0f, 0x0027, "ETRamp" },
		{ 0x0f, 0x0028, "ETCustomForce" },
		{ 0x0f, 0x0030, "ETSquare" },
		{ 0x0f, 0x0031, "ETSine" },
		{ 0x0f, 0x0032, "ETTriangle" },
		{ 0x0f, 0x0033, "ETSawtoothUp" },
		{ 0x0f, 0x0034, "ETSawtoothDown" },
		{ 0x0f, 0x0040, "ETSpring" },
		{ 0x0f, 0x0041, "ETDamper" },
		{ 0x0f, 0x0042, "ETInertia" },
		{ 0x0f, 0x0043, "ETFriction" },
		{ 0x0f, 0x0050, "Duration" },
		{ 0x0f, 0x0051, "SamplePeriod" },
		{ 0x0f, 0x0052, "Gain" },
		{ 0x0f, 0x0053, "TriggerButton" },
		{ 0x0f, 0x0054, "TriggerRepeatInterval" },
		{ 0x0f, 0x0055, "AxesEnable" },
		{ 0x0f, 0x0056, "DirectionEnable" },
		{ 0x0f, 0x0057, "Direction" },
		{ 0x0f, 0x0058, "TypeSpecificBlockOffset" },
		{ 0x0f, 0x0059, "BlockType" },
		{ 0x0f, 0x005a, "SetEnvelopeReport" },
		{ 0x0f, 0x005b, "AttackLevel" },
		{ 0x0f, 0x005c, "AttackTime" },
		{ 0x0f, 0x005d, "FadeLevel" },
		{ 0x0f, 0x005e, "FadeTime" },
		{ 0x0f, 0x005f, "SetConditionReport" },
		{ 0x0f, 0x0060, "CenterPointOffset" },
		{ 0x0f, 0x0061, "PositiveCoefficient" },
		{ 0x0f, 0x0062, "NegativeCoefficient" },
		{ 0x0f, 0x0063, "PositiveSaturation" },
		{ 0x0f, 0x0064, "NegativeSaturation" },
		{ 0x0f, 0x0065, "DeadBand" },
		{ 0x0f, 0x0066, "DownloadForceSample" },
		{ 0x0f, 0x0067, "IsochCustomForceEnable" },
		{ 0x0f, 0x0068, "CustomForceDataReport" },
		{ 0x0f, 0x0069, "CustomForceData" },
		{ 0x0f, 0x006a, "CustomForceVendorDefinedData" },
		{ 0x0f, 0x006b, "SetCustomForceReport" },
		{ 0x0f, 0x006c, "CustomForceDataOffset" },
		{ 0x0f, 0x006d, "SampleCount" },
		{ 0x0f, 0x006e, "SetPeriodicReport" },
		{ 0x0f, 0x006f, "Offset" },
		{ 0x0f, 0x0070, "Magnitude" },
		{ 0x0f, 0x0071, "Phase" },
		{ 0x0f, 0x0072, "Period" },
		{ 0x0f, 0x0073, "SetConstantForceReport" },
		{ 0x0f, 0x0074, "SetRampForceReport" },
		{ 0x0f, 0x0075, "RampStart" },
		{ 0x0f, 0x0076, "RampEnd" },
		{ 0x0f, 0x0077, "EffectOperationReport" },
		{ 0x0f, 0x0078, "EffectOperation" },
		{ 0x0f, 0x0079, "OpEffectStart" },
		{ 0x0f, 0x007a, "OpEffectStartSolo" },
		{ 0x0f, 0x007b, "OpEffectStop" },
		{ 0x0f, 0x007c, "LoopCount" },
		{ 0x0f, 0x007d, "DeviceGainReport" },
		{ 0x0f, 0x007e, "DeviceGain" },
		{ 0x0f, 0x007f, "ParameterBlockPoolsReport" },
		{ 0x0f, 0x0080, "RAMPoolSize" },
		{ 0x0f, 0x0081, "ROMPoolSize" },
		{ 0x0f, 0x0082, "ROMEffectBlockCount" },
		{ 0x0f, 0x0083, "SimultaneousEffectsMax" },
		{ 0x0f, 0x0084, "PoolAlignment" },
		{ 0x0f, 0x0085, "ParameterBlockMoveReport" },
		{ 0x0f, 0x0086, "MoveSource" },
		{ 0x0f, 0x0087, "MoveDestination" },
		{ 0x0f, 0x0088, "MoveLength" },
		{ 0x0f, 0x0089, "EffectParameterBlockLoadReport" },
		{ 0x0f, 0x008b, "EffectParameterBlockLoadStatus" },
		{ 0x0f, 0x008c, "BlockLoadSuccess" },
		{ 0x0f, 0x008d, "BlockLoadFull" },
		{ 0x0f, 0x008e, "BlockLoadError" },
		{ 0x0f, 0x008f, "BlockHandle" },
		{ 0x0f, 0x0090, "EffectParameterBlockFreeReport" },
		{ 0x0f, 0x0091, "TypeSpecificBlockHandle" },
		{ 0x0f, 0x0092, "PIDStateReport" },
		{ 0x0f, 0x0094, "EffectPlaying" },
		{ 0x0f, 0x0095, "PIDDeviceControlReport" },
		{ 0x0f, 0x0096, "PIDDeviceControl" },
		{ 0x0f, 0x0097, "DCEnableActuators" },
		{ 0x0f, 0x0098, "DCDisableActuators" },
		{ 0x0f, 0x0099, "DCStopAllEffects" },
		{ 0x0f, 0x009a, "DCReset" },
		{ 0x0f, 0x009b, "DCPause" },
		{ 0x0f, 0x009c, "DCContinue" },
		{ 0x0f, 0x009f, "DevicePaused" },
		{ 0x0f, 0x00a0, "ActuatorsEnabled" },
		{ 0x0f, 0x00a4, "SafetySwitch" },
		{ 0x0f, 0x00a5, "ActuatorOverrideSwitch" },
		{ 0x0f, 0x00a6, "ActuatorPower" },
		{ 0x0f, 0x00a7, "StartDelay" },
		{ 0x0f, 0x00a8, "ParameterBlockSize" },
		{ 0x0f, 0x00a9, "DeviceManagedPool" },
		{ 0x0f, 0x00aa, "SharedParameterBlocks" },
		{ 0x0f, 0x00ab, "CreateNewEffectParameterBlockReport" },
		{ 0x0f, 0x00ac, "RAMPoolAvailable" },
	{ 0x11, 0, "SoC" },
		{ 0x11, 0x0001, "SocControl" },
		{ 0x11, 0x0002, "FirmwareTransfer" },
		{ 0x11, 0x0003, "FirmwareFileId" },
		{ 0x11, 0x0004, "FileOffsetInBytes" },
		{ 0x11, 0x0005, "FileTransferSizeMaxInBytes" },
		{ 0x11, 0x0006, "FilePayload" },
		{ 0x11, 0x0007, "FilePayloadSizeInBytes" },
		{ 0x11, 0x0008, "FilePayloadContainsLastBytes" },
		{ 0x11, 0x0009, "FileTransferStop" },
		{ 0x11, 0x000a, "FileTransferTillEnd" },
	{ 0x12, 0, "EyeandHeadTrackers" },
		{ 0x12, 0x0001, "EyeTracker" },
		{ 0x12, 0x0002, "HeadTracker" },
		{ 0x12, 0x0010, "TrackingData" },
		{ 0x12, 0x0011, "Capabilities" },
		{ 0x12, 0x0012, "Configuration" },
		{ 0x12, 0x0013, "Status" },
		{ 0x12, 0x0014, "Control" },
		{ 0x12, 0x0020, "SensorTimestamp" },
		{ 0x12, 0x0021, "PositionX" },
		{ 0x12, 0x0022, "PositionY" },
		{ 0x12, 0x0023, "PositionZ" },
		{ 0x12, 0x0024, "GazePoint" },
		{ 0x12, 0x0025, "LeftEyePosition" },
		{ 0x12, 0x0026, "RightEyePosition" },
		{ 0x12, 0x0027, "HeadPosition" },
		{ 0x12, 0x0028, "HeadDirectionPoint" },
		{ 0x12, 0x0029, "RotationaboutXaxis" },
		{ 0x12, 0x002a, "RotationaboutYaxis" },
		{ 0x12, 0x002b, "RotationaboutZaxis" },
		{ 0x12, 0x0100, "TrackerQuality" },
		{ 0x12, 0x0101, "MinimumTrackingDistance" },
		{ 0x12, 0x0102, "OptimumTrackingDistance" },
		{ 0x12, 0x0103, "MaximumTrackingDistance" },
		{ 0x12, 0x0104, "MaximumScreenPlaneWidth" },
		{ 0x12, 0x0105, "MaximumScreenPlaneHeight" },
		{ 0x12, 0x0200, "DisplayManufacturerID" },
		{ 0x12, 0x0201, "DisplayProductID" },
		{ 0x12, 0x0202, "DisplaySerialNumber" },
		{ 0x12, 0x0203, "DisplayManufacturerDate" },
		{ 0x12, 0x0204, "CalibratedScreenWidth" },
		{ 0x12, 0x0205, "CalibratedScreenHeight" },
		{ 0x12, 0x0300, "SamplingFrequency" },
		{ 0x12, 0x0301, "ConfigurationStatus" },
		{ 0x12, 0x0400, "DeviceModeRequest" },
	{ 0x14, 0, "AuxiliaryDisplay" },
		{ 0x14, 0x0001, "AlphanumericDisplay" },
		{ 0x14, 0x0002, "AuxiliaryDisplay" },
		{ 0x14, 0x0020, "DisplayAttributesReport" },
		{ 0x14, 0x0021, "ASCIICharacterSet" },
		{ 0x14, 0x0022, "DataReadBack" },
		{ 0x14, 0x0023, "FontReadBack" },
		{ 0x14, 0x0024, "DisplayControlReport" },
		{ 0x14, 0x0025, "ClearDisplay" },
		{ 0x14, 0x0026, "DisplayEnable" },
		{ 0x14, 0x0027, "ScreenSaverDelay" },
		{ 0x14, 0x0028, "ScreenSaverEnable" },
		{ 0x14, 0x0029, "VerticalScroll" },
		{ 0x14, 0x002a, "HorizontalScroll" },
		{ 0x14, 0x002b, "CharacterReport" },
		{ 0x14, 0x002c, "DisplayData" },
		{ 0x14, 0x002d, "DisplayStatus" },
		{ 0x14, 0x002e, "StatNotReady" },
		{ 0x14, 0x002f, "StatReady" },
		{ 0x14, 0x0030, "ErrNotaloadablecharacter" },
		{ 0x14, 0x0031, "ErrFontdatacannotberead" },
		{ 0x14, 0x0032, "CursorPositionReport" },
		{ 0x14, 0x0033, "Row" },
		{ 0x14, 0x0034, "Column" },
		{ 0x14, 0x0035, "Rows" },
		{ 0x14, 0x0036, "Columns" },
		{ 0x14, 0x0037, "CursorPixelPositioning" },
		{ 0x14, 0x0038, "CursorMode" },
		{ 0x14, 0x0039, "CursorEnable" },
		{ 0x14, 0x003a, "CursorBlink" },
		{ 0x14, 0x003b, "FontReport" },
		{ 0x14, 0x003c, "FontData" },
		{ 0x14, 0x003d, "CharacterWidth" },
		{ 0x14, 0x003e, "CharacterHeight" },
		{ 0x14, 0x003f, "CharacterSpacingHorizontal" },
		{ 0x14, 0x0040, "CharacterSpacingVertical" },
		{ 0x14, 0x0041, "UnicodeCharacterSet" },
		{ 0x14, 0x0042, "Font7Segment" },
		{ 0x14, 0x0043, "7SegmentDirectMap" },
		{ 0x14, 0x0044, "Font14Segment" },
		{ 0x14, 0x0045, "14SegmentDirectMap" },
		{ 0x14, 0x0046, "DisplayBrightness" },
		{ 0x14, 0x0047, "DisplayContrast" },
		{ 0x14, 0x0048, "CharacterAttribute" },
		{ 0x14, 0x0049, "AttributeReadback" },
		{ 0x14, 0x004a, "AttributeData" },
		{ 0x14, 0x004b, "CharAttrEnhance" },
		{ 0x14, 0x004c, "CharAttrUnderline" },
		{ 0x14, 0x004d, "CharAttrBlink" },
		{ 0x14, 0x0080, "BitmapSizeX" },
		{ 0x14, 0x0081, "BitmapSizeY" },
		{ 0x14, 0x0082, "MaxBlitSize" },
		{ 0x14, 0x0083, "BitDepthFormat" },
		{ 0x14, 0x0084, "DisplayOrientation" },
		{ 0x14, 0x0085, "PaletteReport" },
		{ 0x14, 0x0086, "PaletteDataSize" },
		{ 0x14, 0x0087, "PaletteDataOffset" },
		{ 0x14, 0x0088, "PaletteData" },
		{ 0x14, 0x008a, "BlitReport" },
		{ 0x14, 0x008b, "BlitRectangleX1" },
		{ 0x14, 0x008c, "BlitRectangleY1" },
		{ 0x14, 0x008d, "BlitRectangleX2" },
		{ 0x14, 0x008e, "BlitRectangleY2" },
		{ 0x14, 0x008f, "BlitData" },
		{ 0x14, 0x0090, "SoftButton" },
		{ 0x14, 0x0091, "SoftButtonID" },
		{ 0x14, 0x0092, "SoftButtonSide" },
		{ 0x14, 0x0093, "SoftButtonOffset1" },
		{ 0x14, 0x0094, "SoftButtonOffset2" },
		{ 0x14, 0x0095, "SoftButtonReport" },
		{ 0x14, 0x00c2, "SoftKeys" },
		{ 0x14, 0x00cc, "DisplayDataExtensions" },
		{ 0x14, 0x00cf, "CharacterMapping" },
		{ 0x14, 0x00dd, "UnicodeEquivalent" },
		{ 0x14, 0x00df, "CharacterPageMapping" },
		{ 0x14, 0x00ff, "RequestReport" },
	{ 0x20, 0, "Sensors" },
		{ 0x20, 0x0001, "Sensor" },
		{ 0x20, 0x0010, "Biometric" },
		{ 0x20, 0x0011, "BiometricHumanPresence" },
		{ 0x20, 0x0012, "BiometricHumanProximity" },
		{ 0x20, 0x0013, "BiometricHumanTouch" },
		{ 0x20, 0x0014, "BiometricBloodPressure" },
		{ 0x20, 0x0015, "BiometricBodyTemperature" },
		{ 0x20, 0x0016, "BiometricHeartRate" },
		{ 0x20, 0x0017, "BiometricHeartRateVariability" },
		{ 0x20, 0x0018, "BiometricPeripheralOxygenSaturation" },
		{ 0x20, 0x0019, "BiometricRespiratoryRate" },
		{ 0x20, 0x0020, "Electrical" },
		{ 0x20, 0x0021, "ElectricalCapacitance" },
		{ 0x20, 0x0022, "ElectricalCurrent" },
		{ 0x20, 0x0023, "ElectricalPower" },
		{ 0x20, 0x0024, "ElectricalInductance" },
		{ 0x20, 0x0025, "ElectricalResistance" },
		{ 0x20, 0x0026, "ElectricalVoltage" },
		{ 0x20, 0x0027, "ElectricalPotentiometer" },
		{ 0x20, 0x0028, "ElectricalFrequency" },
		{ 0x20, 0x0029, "ElectricalPeriod" },
		{ 0x20, 0x0030, "Environmental" },
		{ 0x20, 0x0031, "EnvironmentalAtmosphericPressure" },
		{ 0x20, 0x0032, "EnvironmentalHumidity" },
		{ 0x20, 0x0033, "EnvironmentalTemperature" },
		{ 0x20, 0x0034, "EnvironmentalWindDirection" },
		{ 0x20, 0x0035, "EnvironmentalWindSpeed" },
		{ 0x20, 0x0036, "EnvironmentalAirQuality" },
		{ 0x20, 0x0037, "EnvironmentalHeatIndex" },
		{ 0x20, 0x0038, "EnvironmentalSurfaceTemperature" },
		{ 0x20, 0x0039, "EnvironmentalVolatileOrganicCompounds" },
		{ 0x20, 0x003a, "EnvironmentalObjectPresence" },
		{ 0x20, 0x003b, "EnvironmentalObjectProximity" },
		{ 0x20, 0x0040, "Light" },
		{ 0x20, 0x0041, "LightAmbientLight" },
		{ 0x20, 0x0042, "LightConsumerInfrared" },
		{ 0x20, 0x0043, "LightInfraredLight" },
		{ 0x20, 0x0044, "LightVisibleLight" },
		{ 0x20, 0x0045, "LightUltravioletLight" },
		{ 0x20, 0x0050, "Location" },
		{ 0x20, 0x0051, "LocationBroadcast" },
		{ 0x20, 0x0052, "LocationDeadReckoning" },
		{ 0x20, 0x0053, "LocationGPSGlobalPositioningSystem" },
		{ 0x20, 0x0054, "LocationLookup" },
		{ 0x20, 0x0055, "LocationOther" },
		{ 0x20, 0x0056, "LocationStatic" },
		{ 0x20, 0x0057, "LocationTriangulation" },
		{ 0x20, 0x0060, "Mechanical" },
		{ 0x20, 0x0061, "MechanicalBooleanSwitch" },
		{ 0x20, 0x0062, "MechanicalBooleanSwitchArray" },
		{ 0x20, 0x0063, "MechanicalMultivalueSwitch" },
		{ 0x20, 0x0064, "MechanicalForce" },
		{ 0x20, 0x0065, "MechanicalPressure" },
		{ 0x20, 0x0066, "MechanicalStrain" },
		{ 0x20, 0x0067, "MechanicalWeight" },
		{ 0x20, 0x0068, "MechanicalHapticVibrator" },
		{ 0x20, 0x0069, "MechanicalHallEffectSwitch" },
		{ 0x20, 0x0070, "Motion" },
		{ 0x20, 0x0071, "MotionAccelerometer1D" },
		{ 0x20, 0x0072, "MotionAccelerometer2D" },
		{ 0x20, 0x0073, "MotionAccelerometer3D" },
		{ 0x20, 0x0074, "MotionGyrometer1D" },
		{ 0x20, 0x0075, "MotionGyrometer2D" },
		{ 0x20, 0x0076, "MotionGyrometer3D" },
		{ 0x20, 0x0077, "MotionMotionDetector" },
		{ 0x20, 0x0078, "MotionSpeedometer" },
		{ 0x20, 0x0079, "MotionAccelerometer" },
		{ 0x20, 0x007a, "MotionGyrometer" },
		{ 0x20, 0x007b, "MotionGravityVector" },
		{ 0x20, 0x007c, "MotionLinearAccelerometer" },
		{ 0x20, 0x0080, "Orientation" },
		{ 0x20, 0x0081, "OrientationCompass1D" },
		{ 0x20, 0x0082, "OrientationCompass2D" },
		{ 0x20, 0x0083, "OrientationCompass3D" },
		{ 0x20, 0x0084, "OrientationInclinometer1D" },
		{ 0x20, 0x0085, "OrientationInclinometer2D" },
		{ 0x20, 0x0086, "OrientationInclinometer3D" },
		{ 0x20, 0x0087, "OrientationDistance1D" },
		{ 0x20, 0x0088, "OrientationDistance2D" },
		{ 0x20, 0x0089, "OrientationDistance3D" },
		{ 0x20, 0x008a, "OrientationDeviceOrientation" },
		{ 0x20, 0x008b, "OrientationCompass" },
		{ 0x20, 0x008c, "OrientationInclinometer" },
		{ 0x20, 0x008d, "OrientationDistance" },
		{ 0x20, 0x008e, "OrientationRelativeOrientation" },
		{ 0x20, 0x008f, "OrientationSimpleOrientation" },
		{ 0x20, 0x0090, "Scanner" },
		{ 0x20, 0x0091, "ScannerBarcode" },
		{ 0x20, 0x0092, "ScannerRFID" },
		{ 0x20, 0x0093, "ScannerNFC" },
		{ 0x20, 0x00a0, "Time" },
		{ 0x20, 0x00a1, "TimeAlarmTimer" },
		{ 0x20, 0x00a2, "TimeRealTimeClock" },
		{ 0x20, 0x00b0, "PersonalActivity" },
		{ 0x20, 0x00b1, "PersonalActivityActivityDetection" },
		{ 0x20, 0x00b2, "PersonalActivityDevicePosition" },
		{ 0x20, 0x00b3, "PersonalActivityFloorTracker" },
		{ 0x20, 0x00b4, "PersonalActivityPedometer" },
		{ 0x20, 0x00b5, "PersonalActivityStepDetection" },
		{ 0x20, 0x00c0, "OrientationExtended" },
		{ 0x20, 0x00c1, "OrientationExtendedGeomagneticOrientation" },
		{ 0x20, 0x00c2, "OrientationExtendedMagnetometer" },
		{ 0x20, 0x00d0, "Gesture" },
		{ 0x20, 0x00d1, "GestureChassisFlipGesture" },
		{ 0x20, 0x00d2, "GestureHingeFoldGesture" },
		{ 0x20, 0x00e0, "Other" },
		{ 0x20, 0x00e1, "OtherCustom" },
		{ 0x20, 0x00e2, "OtherGeneric" },
		{ 0x20, 0x00e3, "OtherGenericEnumerator" },
		{ 0x20, 0x00e4, "OtherHingeAngle" },
		{ 0x20, 0x00f0, "VendorReserved1" },
		{ 0x20, 0x00f1, "VendorReserved2" },
		{ 0x20, 0x00f2, "VendorReserved3" },
		{ 0x20, 0x00f3, "VendorReserved4" },
		{ 0x20, 0x00f4, "VendorReserved5" },
		{ 0x20, 0x00f5, "VendorReserved6" },
		{ 0x20, 0x00f6, "VendorReserved7" },
		{ 0x20, 0x00f7, "VendorReserved8" },
		{ 0x20, 0x00f8, "VendorReserved9" },
		{ 0x20, 0x00f9, "VendorReserved10" },
		{ 0x20, 0x00fa, "VendorReserved11" },
		{ 0x20, 0x00fb, "VendorReserved12" },
		{ 0x20, 0x00fc, "VendorReserved13" },
		{ 0x20, 0x00fd, "VendorReserved14" },
		{ 0x20, 0x00fe, "VendorReserved15" },
		{ 0x20, 0x00ff, "VendorReserved16" },
		{ 0x20, 0x0200, "Event" },
		{ 0x20, 0x0201, "EventSensorState" },
		{ 0x20, 0x0202, "EventSensorEvent" },
		{ 0x20, 0x0300, "Property" },
		{ 0x20, 0x0301, "PropertyFriendlyName" },
		{ 0x20, 0x0302, "PropertyPersistentUniqueID" },
		{ 0x20, 0x0303, "PropertySensorStatus" },
		{ 0x20, 0x0304, "PropertyMinimumReportInterval" },
		{ 0x20, 0x0305, "PropertySensorManufacturer" },
		{ 0x20, 0x0306, "PropertySensorModel" },
		{ 0x20, 0x0307, "PropertySensorSerialNumber" },
		{ 0x20, 0x0308, "PropertySensorDescription" },
		{ 0x20, 0x0309, "PropertySensorConnectionType" },
		{ 0x20, 0x030a, "PropertySensorDevicePath" },
		{ 0x20, 0x030b, "PropertyHardwareRevision" },
		{ 0x20, 0x030c, "PropertyFirmwareVersion" },
		{ 0x20, 0x030d, "PropertyReleaseDate" },
		{ 0x20, 0x030e, "PropertyReportInterval" },
		{ 0x20, 0x030f, "PropertyChangeSensitivityAbsolute" },
		{ 0x20, 0x0310, "PropertyChangeSensitivityPercentofRange" },
		{ 0x20, 0x0311, "PropertyChangeSensitivityPercentRelative" },
		{ 0x20, 0x0312, "PropertyAccuracy" },
		{ 0x20, 0x0313, "PropertyResolution" },
		{ 0x20, 0x0314, "PropertyMaximum" },
		{ 0x20, 0x0315, "PropertyMinimum" },
		{ 0x20, 0x0316, "PropertyReportingState" },
		{ 0x20, 0x0317, "PropertySamplingRate" },
		{ 0x20, 0x0318, "PropertyResponseCurve" },
		{ 0x20, 0x0319, "PropertyPowerState" },
		{ 0x20, 0x031a, "PropertyMaximumFIFOEvents" },
		{ 0x20, 0x031b, "PropertyReportLatency" },
		{ 0x20, 0x031c, "PropertyFlushFIFOEvents" },
		{ 0x20, 0x031d, "PropertyMaximumPowerConsumption" },
		{ 0x20, 0x031e, "PropertyIsPrimary" },
		{ 0x20, 0x031f, "PropertyHumanPresenceDetectionType" },
		{ 0x20, 0x0400, "DataFieldLocation" },
		{ 0x20, 0x0402, "DataFieldAltitudeAntennaSeaLevel" },
		{ 0x20, 0x0403, "DataFieldDifferentialReferenceStationID" },
		{ 0x20, 0x0404, "DataFieldAltitudeEllipsoidError" },
		{ 0x20, 0x0405, "DataFieldAltitudeEllipsoid" },
		{ 0x20, 0x0406, "DataFieldAltitudeSeaLevelError" },
		{ 0x20, 0x0407, "DataFieldAltitudeSeaLevel" },
		{ 0x20, 0x0408, "DataFieldDifferentialGPSDataAge" },
		{ 0x20, 0x0409, "DataFieldErrorRadius" },
		{ 0x20, 0x040a, "DataFieldFixQuality" },
		{ 0x20, 0x040b, "DataFieldFixType" },
		{ 0x20, 0x040c, "DataFieldGeoidalSeparation" },
		{ 0x20, 0x040d, "DataFieldGPSOperationMode" },
		{ 0x20, 0x040e, "DataFieldGPSSelectionMode" },
		{ 0x20, 0x040f, "DataFieldGPSStatus" },
		{ 0x20, 0x0410, "DataFieldPositionDilutionofPrecision" },
		{ 0x20, 0x0411, "DataFieldHorizontalDilutionofPrecision" },
		{ 0x20, 0x0412, "DataFieldVerticalDilutionofPrecision" },
		{ 0x20, 0x0413, "DataFieldLatitude" },
		{ 0x20, 0x0414, "DataFieldLongitude" },
		{ 0x20, 0x0415, "DataFieldTrueHeading" },
		{ 0x20, 0x0416, "DataFieldMagneticHeading" },
		{ 0x20, 0x0417, "DataFieldMagneticVariation" },
		{ 0x20, 0x0418, "DataFieldSpeed" },
		{ 0x20, 0x0419, "DataFieldSatellitesinView" },
		{ 0x20, 0x041a, "DataFieldSatellitesinViewAzimuth" },
		{ 0x20, 0x041b, "DataFieldSatellitesinViewElevation" },
		{ 0x20, 0x041c, "DataFieldSatellitesinViewIDs" },
		{ 0x20, 0x041d, "DataFieldSatellitesinViewPRNs" },
		{ 0x20, 0x041e, "DataFieldSatellitesinViewSNRatios" },
		{ 0x20, 0x041f, "DataFieldSatellitesUsedCount" },
		{ 0x20, 0x0420, "DataFieldSatellitesUsedPRNs" },
		{ 0x20, 0x0421, "DataFieldNMEASentence" },
		{ 0x20, 0x0422, "DataFieldAddressLine1" },
		{ 0x20, 0x0423, "DataFieldAddressLine2" },
		{ 0x20, 0x0424, "DataFieldCity" },
		{ 0x20, 0x0425, "DataFieldStateorProvince" },
		{ 0x20, 0x0426, "DataFieldCountryorRegion" },
		{ 0x20, 0x0427, "DataFieldPostalCode" },
		{ 0x20, 0x042a, "PropertyLocation" },
		{ 0x20, 0x042b, "PropertyLocationDesiredAccuracy" },
		{ 0x20, 0x0430, "DataFieldEnvironmental" },
		{ 0x20, 0x0431, "DataFieldAtmosphericPressure" },
		{ 0x20, 0x0433, "DataFieldRelativeHumidity" },
		{ 0x20, 0x0434, "DataFieldTemperature" },
		{ 0x20, 0x0435, "DataFieldWindDirection" },
		{ 0x20, 0x0436, "DataFieldWindSpeed" },
		{ 0x20, 0x0437, "DataFieldAirQualityIndex" },
		{ 0x20, 0x0438, "DataFieldEquivalentCO2" },
		{ 0x20, 0x0439, "DataFieldVolatileOrganicCompoundConcentration" },
		{ 0x20, 0x043a, "DataFieldObjectPresence" },
		{ 0x20, 0x043b, "DataFieldObjectProximityRange" },
		{ 0x20, 0x043c, "DataFieldObjectProximityOutofRange" },
		{ 0x20, 0x0440, "PropertyEnvironmental" },
		{ 0x20, 0x0441, "PropertyReferencePressure" },
		{ 0x20, 0x0450, "DataFieldMotion" },
		{ 0x20, 0x0451, "DataFieldMotionState" },
		{ 0x20, 0x0452, "DataFieldAcceleration" },
		{ 0x20, 0x0453, "DataFieldAccelerationAxisX" },
		{ 0x20, 0x0454, "DataFieldAccelerationAxisY" },
		{ 0x20, 0x0455, "DataFieldAccelerationAxisZ" },
		{ 0x20, 0x0456, "DataFieldAngularVelocity" },
		{ 0x20, 0x0457, "DataFieldAngularVelocityaboutXAxis" },
		{ 0x20, 0x0458, "DataFieldAngularVelocityaboutYAxis" },
		{ 0x20, 0x0459, "DataFieldAngularVelocityaboutZAxis" },
		{ 0x20, 0x045a, "DataFieldAngularPosition" },
		{ 0x20, 0x045b, "DataFieldAngularPositionaboutXAxis" },
		{ 0x20, 0x045c, "DataFieldAngularPositionaboutYAxis" },
		{ 0x20, 0x045d, "DataFieldAngularPositionaboutZAxis" },
		{ 0x20, 0x045e, "DataFieldMotionSpeed" },
		{ 0x20, 0x045f, "DataFieldMotionIntensity" },
		{ 0x20, 0x0470, "DataFieldOrientation" },
		{ 0x20, 0x0471, "DataFieldHeading" },
		{ 0x20, 0x0472, "DataFieldHeadingXAxis" },
		{ 0x20, 0x0473, "DataFieldHeadingYAxis" },
		{ 0x20, 0x0474, "DataFieldHeadingZAxis" },
		{ 0x20, 0x0475, "DataFieldHeadingCompensatedMagneticNorth" },
		{ 0x20, 0x0476, "DataFieldHeadingCompensatedTrueNorth" },
		{ 0x20, 0x0477, "DataFieldHeadingMagneticNorth" },
		{ 0x20, 0x0478, "DataFieldHeadingTrueNorth" },
		{ 0x20, 0x0479, "DataFieldDistance" },
		{ 0x20, 0x047a, "DataFieldDistanceXAxis" },
		{ 0x20, 0x047b, "DataFieldDistanceYAxis" },
		{ 0x20, 0x047c, "DataFieldDistanceZAxis" },
		{ 0x20, 0x047d, "DataFieldDistanceOutofRange" },
		{ 0x20, 0x047e, "DataFieldTilt" },
		{ 0x20, 0x047f, "DataFieldTiltXAxis" },
		{ 0x20, 0x0480, "DataFieldTiltYAxis" },
		{ 0x20, 0x0481, "DataFieldTiltZAxis" },
		{ 0x20, 0x0482, "DataFieldRotationMatrix" },
		{ 0x20, 0x0483, "DataFieldQuaternion" },
		{ 0x20, 0x0484, "DataFieldMagneticFlux" },
		{ 0x20, 0x0485, "DataFieldMagneticFluxXAxis" },
		{ 0x20, 0x0486, "DataFieldMagneticFluxYAxis" },
		{ 0x20, 0x0487, "DataFieldMagneticFluxZAxis" },
		{ 0x20, 0x0488, "DataFieldMagnetometerAccuracy" },
		{ 0x20, 0x0489, "DataFieldSimpleOrientationDirection" },
		{ 0x20, 0x0490, "DataFieldMechanical" },
		{ 0x20, 0x0491, "DataFieldBooleanSwitchState" },
		{ 0x20, 0x0492, "DataFieldBooleanSwitchArrayStates" },
		{ 0x20, 0x0493, "DataFieldMultivalueSwitchValue" },
		{ 0x20, 0x0494, "DataFieldForce" },
		{ 0x20, 0x0495, "DataFieldAbsolutePressure" },
		{ 0x20, 0x0496, "DataFieldGaugePressure" },
		{ 0x20, 0x0497, "DataFieldStrain" },
		{ 0x20, 0x0498, "DataFieldWeight" },
		{ 0x20, 0x04a0, "PropertyMechanical" },
		{ 0x20, 0x04a1, "PropertyVibrationState" },
		{ 0x20, 0x04a2, "PropertyForwardVibrationSpeed" },
		{ 0x20, 0x04a3, "PropertyBackwardVibrationSpeed" },
		{ 0x20, 0x04b0, "DataFieldBiometric" },
		{ 0x20, 0x04b1, "DataFieldHumanPresence" },
		{ 0x20, 0x04b2, "DataFieldHumanProximityRange" },
		{ 0x20, 0x04b3, "DataFieldHumanProximityOutofRange" },
		{ 0x20, 0x04b4, "DataFieldHumanTouchState" },
		{ 0x20, 0x04b5, "DataFieldBloodPressure" },
		{ 0x20, 0x04b6, "DataFieldBloodPressureDiastolic" },
		{ 0x20, 0x04b7, "DataFieldBloodPressureSystolic" },
		{ 0x20, 0x04b8, "DataFieldHeartRate" },
		{ 0x20, 0x04b9, "DataFieldRestingHeartRate" },
		{ 0x20, 0x04ba, "DataFieldHeartbeatInterval" },
		{ 0x20, 0x04bb, "DataFieldRespiratoryRate" },
		{ 0x20, 0x04bc, "DataFieldSpO2" },
		{ 0x20, 0x04bd, "DataFieldHumanAttentionDetected" },
		{ 0x20, 0x04be, "DataFieldHumanHeadAzimuth" },
		{ 0x20, 0x04bf, "DataFieldHumanHeadAltitude" },
		{ 0x20, 0x04c0, "DataFieldHumanHeadRoll" },
		{ 0x20, 0x04c1, "DataFieldHumanHeadPitch" },
		{ 0x20, 0x04c2, "DataFieldHumanHeadYaw" },
		{ 0x20, 0x04c3, "DataFieldHumanCorrelationId" },
		{ 0x20, 0x04d0, "DataFieldLight" },
		{ 0x20, 0x04d1, "DataFieldIlluminance" },
		{ 0x20, 0x04d2, "DataFieldColorTemperature" },
		{ 0x20, 0x04d3, "DataFieldChromaticity" },
		{ 0x20, 0x04d4, "DataFieldChromaticityX" },
		{ 0x20, 0x04d5, "DataFieldChromaticityY" },
		{ 0x20, 0x04d6, "DataFieldConsumerIRSentenceReceive" },
		{ 0x20, 0x04d7, "DataFieldInfraredLight" },
		{ 0x20, 0x04d8, "DataFieldRedLight" },
		{ 0x20, 0x04d9, "DataFieldGreenLight" },
		{ 0x20, 0x04da, "DataFieldBlueLight" },
		{ 0x20, 0x04db, "DataFieldUltravioletALight" },
		{ 0x20, 0x04dc, "DataFieldUltravioletBLight" },
		{ 0x20, 0x04dd, "DataFieldUltravioletIndex" },
		{ 0x20, 0x04de, "DataFieldNearInfraredLight" },
		{ 0x20, 0x04df, "PropertyLight" },
		{ 0x20, 0x04e0, "PropertyConsumerIRSentenceSend" },
		{ 0x20, 0x04e2, "PropertyAutoBrightnessPreferred" },
		{ 0x20, 0x04e3, "PropertyAutoColorPreferred" },
		{ 0x20, 0x04f0, "DataFieldScanner" },
		{ 0x20, 0x04f1, "DataFieldRFIDTag40Bit" },
		{ 0x20, 0x04f2, "DataFieldNFCSentenceReceive" },
		{ 0x20, 0x04f8, "PropertyScanner" },
		{ 0x20, 0x04f9, "PropertyNFCSentenceSend" },
		{ 0x20, 0x0500, "DataFieldElectrical" },
		{ 0x20, 0x0501, "DataFieldCapacitance" },
		{ 0x20, 0x0502, "DataFieldCurrent" },
		{ 0x20, 0x0503, "DataFieldElectricalPower" },
		{ 0x20, 0x0504, "DataFieldInductance" },
		{ 0x20, 0x0505, "DataFieldResistance" },
		{ 0x20, 0x0506, "DataFieldVoltage" },
		{ 0x20, 0x0507, "DataFieldFrequency" },
		{ 0x20, 0x0508, "DataFieldPeriod" },
		{ 0x20, 0x0509, "DataFieldPercentofRange" },
		{ 0x20, 0x0520, "DataFieldTime" },
		{ 0x20, 0x0521, "DataFieldYear" },
		{ 0x20, 0x0522, "DataFieldMonth" },
		{ 0x20, 0x0523, "DataFieldDay" },
		{ 0x20, 0x0524, "DataFieldDayofWeek" },
		{ 0x20, 0x0525, "DataFieldHour" },
		{ 0x20, 0x0526, "DataFieldMinute" },
		{ 0x20, 0x0527, "DataFieldSecond" },
		{ 0x20, 0x0528, "DataFieldMillisecond" },
		{ 0x20, 0x0529, "DataFieldTimestamp" },
		{ 0x20, 0x052a, "DataFieldJulianDayofYear" },
		{ 0x20, 0x052b, "DataFieldTimeSinceSystemBoot" },
		{ 0x20, 0x0530, "PropertyTime" },
		{ 0x20, 0x0531, "PropertyTimeZoneOffsetfromUTC" },
		{ 0x20, 0x0532, "PropertyTimeZoneName" },
		{ 0x20, 0x0533, "PropertyDaylightSavingsTimeObserved" },
		{ 0x20, 0x0534, "PropertyTimeTrimAdjustment" },
		{ 0x20, 0x0535, "PropertyArmAlarm" },
		{ 0x20, 0x0540, "DataFieldCustom" },
		{ 0x20, 0x0541, "DataFieldCustomUsage" },
		{ 0x20, 0x0542, "DataFieldCustomBooleanArray" },
		{ 0x20, 0x0543, "DataFieldCustomValue" },
		{ 0x20, 0x0544, "DataFieldCustomValue1" },
		{ 0x20, 0x0545, "DataFieldCustomValue2" },
		{ 0x20, 0x0546, "DataFieldCustomValue3" },
		{ 0x20, 0x0547, "DataFieldCustomValue4" },
		{ 0x20, 0x0548, "DataFieldCustomValue5" },
		{ 0x20, 0x0549, "DataFieldCustomValue6" },
		{ 0x20, 0x054a, "DataFieldCustomValue7" },
		{ 0x20, 0x054b, "DataFieldCustomValue8" },
		{ 0x20, 0x054c, "DataFieldCustomValue9" },
		{ 0x20, 0x054d, "DataFieldCustomValue10" },
		{ 0x20, 0x054e, "DataFieldCustomValue11" },
		{ 0x20, 0x054f, "DataFieldCustomValue12" },
		{ 0x20, 0x0550, "DataFieldCustomValue13" },
		{ 0x20, 0x0551, "DataFieldCustomValue14" },
		{ 0x20, 0x0552, "DataFieldCustomValue15" },
		{ 0x20, 0x0553, "DataFieldCustomValue16" },
		{ 0x20, 0x0554, "DataFieldCustomValue17" },
		{ 0x20, 0x0555, "DataFieldCustomValue18" },
		{ 0x20, 0x0556, "DataFieldCustomValue19" },
		{ 0x20, 0x0557, "DataFieldCustomValue20" },
		{ 0x20, 0x0558, "DataFieldCustomValue21" },
		{ 0x20, 0x0559, "DataFieldCustomValue22" },
		{ 0x20, 0x055a, "DataFieldCustomValue23" },
		{ 0x20, 0x055b, "DataFieldCustomValue24" },
		{ 0x20, 0x055c, "DataFieldCustomValue25" },
		{ 0x20, 0x055d, "DataFieldCustomValue26" },
		{ 0x20, 0x055e, "DataFieldCustomValue27" },
		{ 0x20, 0x055f, "DataFieldCustomValue28" },
		{ 0x20, 0x0560, "DataFieldGeneric" },
		{ 0x20, 0x0561, "DataFieldGenericGUIDorPROPERTYKEY" },
		{ 0x20, 0x0562, "DataFieldGenericCategoryGUID" },
		{ 0x20, 0x0563, "DataFieldGenericTypeGUID" },
		{ 0x20, 0x0564, "DataFieldGenericEventPROPERTYKEY" },
		{ 0x20, 0x0565, "DataFieldGenericPropertyPROPERTYKEY" },
		{ 0x20, 0x0566, "DataFieldGenericDataFieldPROPERTYKEY" },
		{ 0x20, 0x0567, "DataFieldGenericEvent" },
		{ 0x20, 0x0568, "DataFieldGenericProperty" },
		{ 0x20, 0x0569, "DataFieldGenericDataField" },
		{ 0x20, 0x056a, "DataFieldEnumeratorTableRowIndex" },
		{ 0x20, 0x056b, "DataFieldEnumeratorTableRowCount" },
		{ 0x20, 0x056c, "DataFieldGenericGUIDorPROPERTYKEYkind" },
		{ 0x20, 0x056d, "DataFieldGenericGUID" },
		{ 0x20, 0x056e, "DataFieldGenericPROPERTYKEY" },
		{ 0x20, 0x056f, "DataFieldGenericTopLevelCollectionID" },
		{ 0x20, 0x0570, "DataFieldGenericReportID" },
		{ 0x20, 0x0571, "DataFieldGenericReportItemPositionIndex" },
		{ 0x20, 0x0572, "DataFieldGenericFirmwareVARTYPE" },
		{ 0x20, 0x0573, "DataFieldGenericUnitofMeasure" },
		{ 0x20, 0x0574, "DataFieldGenericUnitExponent" },
		{ 0x20, 0x0575, "DataFieldGenericReportSize" },
		{ 0x20, 0x0576, "DataFieldGenericReportCount" },
		{ 0x20, 0x0580, "PropertyGeneric" },
		{ 0x20, 0x0581, "PropertyEnumeratorTableRowIndex" },
		{ 0x20, 0x0582, "PropertyEnumeratorTableRowCount" },
		{ 0x20, 0x0590, "DataFieldPersonalActivity" },
		{ 0x20, 0x0591, "DataFieldActivityType" },
		{ 0x20, 0x0592, "DataFieldActivityState" },
		{ 0x20, 0x0593, "DataFieldDevicePosition" },
		{ 0x20, 0x0594, "DataFieldStepCount" },
		{ 0x20, 0x0595, "DataFieldStepCountReset" },
		{ 0x20, 0x0596, "DataFieldStepDuration" },
		{ 0x20, 0x0597, "DataFieldStepType" },
		{ 0x20, 0x05a0, "PropertyMinimumActivityDetectionInterval" },
		{ 0x20, 0x05a1, "PropertySupportedActivityTypes" },
		{ 0x20, 0x05a2, "PropertySubscribedActivityTypes" },
		{ 0x20, 0x05a3, "PropertySupportedStepTypes" },
		{ 0x20, 0x05a4, "PropertySubscribedStepTypes" },
		{ 0x20, 0x05a5, "PropertyFloorHeight" },
		{ 0x20, 0x05b0, "DataFieldCustomTypeID" },
		{ 0x20, 0x05c0, "PropertyCustom" },
		{ 0x20, 0x05c1, "PropertyCustomValue1" },
		{ 0x20, 0x05c2, "PropertyCustomValue2" },
		{ 0x20, 0x05c3, "PropertyCustomValue3" },
		{ 0x20, 0x05c4, "PropertyCustomValue4" },
		{ 0x20, 0x05c5, "PropertyCustomValue5" },
		{ 0x20, 0x05c6, "PropertyCustomValue6" },
		{ 0x20, 0x05c7, "PropertyCustomValue7" },
		{ 0x20, 0x05c8, "PropertyCustomValue8" },
		{ 0x20, 0x05c9, "PropertyCustomValue9" },
		{ 0x20, 0x05ca, "PropertyCustomValue10" },
		{ 0x20, 0x05cb, "PropertyCustomValue11" },
		{ 0x20, 0x05cc, "PropertyCustomValue12" },
		{ 0x20, 0x05cd, "PropertyCustomValue13" },
		{ 0x20, 0x05ce, "PropertyCustomValue14" },
		{ 0x20, 0x05cf, "PropertyCustomValue15" },
		{ 0x20, 0x05d0, "PropertyCustomValue16" },
		{ 0x20, 0x05e0, "DataFieldHinge" },
		{ 0x20, 0x05e1, "DataFieldHingeAngle" },
		{ 0x20, 0x05f0, "DataFieldGestureSensor" },
		{ 0x20, 0x05f1, "DataFieldGestureState" },
		{ 0x20, 0x05f2, "DataFieldHingeFoldInitialAngle" },
		{ 0x20, 0x05f3, "DataFieldHingeFoldFinalAngle" },
		{ 0x20, 0x05f4, "DataFieldHingeFoldContributingPanel" },
		{ 0x20, 0x05f5, "DataFieldHingeFoldType" },
		{ 0x20, 0x0800, "SensorStateUndefined" },
		{ 0x20, 0x0801, "SensorStateReady" },
		{ 0x20, 0x0802, "SensorStateNotAvailable" },
		{ 0x20, 0x0803, "SensorStateNoData" },
		{ 0x20, 0x0804, "SensorStateInitializing" },
		{ 0x20, 0x0805, "SensorStateAccessDenied" },
		{ 0x20, 0x0806, "SensorStateError" },
		{ 0x20, 0x0810, "SensorEventUnknown" },
		{ 0x20, 0x0811, "SensorEventStateChanged" },
		{ 0x20, 0x0812, "SensorEventPropertyChanged" },
		{ 0x20, 0x0813, "SensorEventDataUpdated" },
		{ 0x20, 0x0814, "SensorEventPollResponse" },
		{ 0x20, 0x0815, "SensorEventChangeSensitivity" },
		{ 0x20, 0x0816, "SensorEventRangeMaximumReached" },
		{ 0x20, 0x0817, "SensorEventRangeMinimumReached" },
		{ 0x20, 0x0818, "SensorEventHighThresholdCrossUpward" },
		{ 0x20, 0x0819, "SensorEventHighThresholdCrossDownward" },
		{ 0x20, 0x081a, "SensorEventLowThresholdCrossUpward" },
		{ 0x20, 0x081b, "SensorEventLowThresholdCrossDownward" },
		{ 0x20, 0x081c, "SensorEventZeroThresholdCrossUpward" },
		{ 0x20, 0x081d, "SensorEventZeroThresholdCrossDownward" },
		{ 0x20, 0x081e, "SensorEventPeriodExceeded" },
		{ 0x20, 0x081f, "SensorEventFrequencyExceeded" },
		{ 0x20, 0x0820, "SensorEventComplexTrigger" },
		{ 0x20, 0x0830, "ConnectionTypePCIntegrated" },
		{ 0x20, 0x0831, "ConnectionTypePCAttached" },
		{ 0x20, 0x0832, "ConnectionTypePCExternal" },
		{ 0x20, 0x0840, "ReportingStateReportNoEvents" },
		{ 0x20, 0x0841, "ReportingStateReportAllEvents" },
		{ 0x20, 0x0842, "ReportingStateReportThresholdEvents" },
		{ 0x20, 0x0843, "ReportingStateWakeOnNoEvents" },
		{ 0x20, 0x0844, "ReportingStateWakeOnAllEvents" },
		{ 0x20, 0x0845, "ReportingStateWakeOnThresholdEvents" },
		{ 0x20, 0x0846, "ReportingStateAnytime" },
		{ 0x20, 0x0850, "PowerStateUndefined" },
		{ 0x20, 0x0851, "PowerStateD0FullPower" },
		{ 0x20, 0x0852, "PowerStateD1LowPower" },
		{ 0x20, 0x0853, "PowerStateD2StandbyPowerwithWakeup" },
		{ 0x20, 0x0854, "PowerStateD3SleepwithWakeup" },
		{ 0x20, 0x0855, "PowerStateD4PowerOff" },
		{ 0x20, 0x0860, "AccuracyDefault" },
		{ 0x20, 0x0861, "AccuracyHigh" },
		{ 0x20, 0x0862, "AccuracyMedium" },
		{ 0x20, 0x0863, "AccuracyLow" },
		{ 0x20, 0x0870, "FixQualityNoFix" },
		{ 0x20, 0x0871, "FixQualityGPS" },
		{ 0x20, 0x0872, "FixQualityDGPS" },
		{ 0x20, 0x0880, "FixTypeNoFix" },
		{ 0x20, 0x0881, "FixTypeGPSSPSModeFixValid" },
		{ 0x20, 0x0882, "FixTypeDGPSSPSModeFixValid" },
		{ 0x20, 0x0883, "FixTypeGPSPPSModeFixValid" },
		{ 0x20, 0x0884, "FixTypeRealTimeKinematic" },
		{ 0x20, 0x0885, "FixTypeFloatRTK" },
		{ 0x20, 0x0886, "FixTypeEstimateddeadreckoned" },
		{ 0x20, 0x0887, "FixTypeManualInputMode" },
		{ 0x20, 0x0888, "FixTypeSimulatorMode" },
		{ 0x20, 0x0890, "GPSOperationModeManual" },
		{ 0x20, 0x0891, "GPSOperationModeAutomatic" },
		{ 0x20, 0x08a0, "GPSSelectionModeAutonomous" },
		{ 0x20, 0x08a1, "GPSSelectionModeDGPS" },
		{ 0x20, 0x08a2, "GPSSelectionModeEstimateddeadreckoned" },
		{ 0x20, 0x08a3, "GPSSelectionModeManualInput" },
		{ 0x20, 0x08a4, "GPSSelectionModeSimulator" },
		{ 0x20, 0x08a5, "GPSSelectionModeDataNotValid" },
		{ 0x20, 0x08b0, "GPSStatusDataValid" },
		{ 0x20, 0x08b1, "GPSStatusDataNotValid" },
		{ 0x20, 0x08c0, "DayofWeekSunday" },
		{ 0x20, 0x08c1, "DayofWeekMonday" },
		{ 0x20, 0x08c2, "DayofWeekTuesday" },
		{ 0x20, 0x08c3, "DayofWeekWednesday" },
		{ 0x20, 0x08c4, "DayofWeekThursday" },
		{ 0x20, 0x08c5, "DayofWeekFriday" },
		{ 0x20, 0x08c6, "DayofWeekSaturday" },
		{ 0x20, 0x08d0, "KindCategory" },
		{ 0x20, 0x08d1, "KindType" },
		{ 0x20, 0x08d2, "KindEvent" },
		{ 0x20, 0x08d3, "KindProperty" },
		{ 0x20, 0x08d4, "KindDataField" },
		{ 0x20, 0x08e0, "MagnetometerAccuracyLow" },
		{ 0x20, 0x08e1, "MagnetometerAccuracyMedium" },
		{ 0x20, 0x08e2, "MagnetometerAccuracyHigh" },
		{ 0x20, 0x08f0, "SimpleOrientationDirectionNotRotated" },
		{ 0x20, 0x08f1, "SimpleOrientationDirectionRotated90DegreesCCW" },
		{ 0x20, 0x08f2, "SimpleOrientationDirectionRotated180DegreesCCW" },
		{ 0x20, 0x08f3, "SimpleOrientationDirectionRotated270DegreesCCW" },
		{ 0x20, 0x08f4, "SimpleOrientationDirectionFaceUp" },
		{ 0x20, 0x08f5, "SimpleOrientationDirectionFaceDown" },
		{ 0x20, 0x0900, "VT_NULL" },
		{ 0x20, 0x0901, "VT_BOOL" },
		{ 0x20, 0x0902, "VT_UI1" },
		{ 0x20, 0x0903, "VT_I1" },
		{ 0x20, 0x0904, "VT_UI2" },
		{ 0x20, 0x0905, "VT_I2" },
		{ 0x20, 0x0906, "VT_UI4" },
		{ 0x20, 0x0907, "VT_I4" },
		{ 0x20, 0x0908, "VT_UI8" },
		{ 0x20, 0x0909, "VT_I8" },
		{ 0x20, 0x090a, "VT_R4" },
		{ 0x20, 0x090b, "VT_R8" },
		{ 0x20, 0x090c, "VT_WSTR" },
		{ 0x20, 0x090d, "VT_STR" },
		{ 0x20, 0x090e, "VT_CLSID" },
		{ 0x20, 0x090f, "VT_VECTORVT_UI1" },
		{ 0x20, 0x0910, "VT_F16E0" },
		{ 0x20, 0x0911, "VT_F16E1" },
		{ 0x20, 0x0912, "VT_F16E2" },
		{ 0x20, 0x0913, "VT_F16E3" },
		{ 0x20, 0x0914, "VT_F16E4" },
		{ 0x20, 0x0915, "VT_F16E5" },
		{ 0x20, 0x0916, "VT_F16E6" },
		{ 0x20, 0x0917, "VT_F16E7" },
		{ 0x20, 0x0918, "VT_F16E8" },
		{ 0x20, 0x0919, "VT_F16E9" },
		{ 0x20, 0x091a, "VT_F16EA" },
		{ 0x20, 0x091b, "VT_F16EB" },
		{ 0x20, 0x091c, "VT_F16EC" },
		{ 0x20, 0x091d, "VT_F16ED" },
		{ 0x20, 0x091e, "VT_F16EE" },
		{ 0x20, 0x091f, "VT_F16EF" },
		{ 0x20, 0x0920, "VT_F32E0" },
		{ 0x20, 0x0921, "VT_F32E1" },
		{ 0x20, 0x0922, "VT_F32E2" },
		{ 0x20, 0x0923, "VT_F32E3" },
		{ 0x20, 0x0924, "VT_F32E4" },
		{ 0x20, 0x0925, "VT_F32E5" },
		{ 0x20, 0x0926, "VT_F32E6" },
		{ 0x20, 0x0927, "VT_F32E7" },
		{ 0x20, 0x0928, "VT_F32E8" },
		{ 0x20, 0x0929, "VT_F32E9" },
		{ 0x20, 0x092a, "VT_F32EA" },
		{ 0x20, 0x092b, "VT_F32EB" },
		{ 0x20, 0x092c, "VT_F32EC" },
		{ 0x20, 0x092d, "VT_F32ED" },
		{ 0x20, 0x092e, "VT_F32EE" },
		{ 0x20, 0x092f, "VT_F32EF" },
		{ 0x20, 0x0930, "ActivityTypeUnknown" },
		{ 0x20, 0x0931, "ActivityTypeStationary" },
		{ 0x20, 0x0932, "ActivityTypeFidgeting" },
		{ 0x20, 0x0933, "ActivityTypeWalking" },
		{ 0x20, 0x0934, "ActivityTypeRunning" },
		{ 0x20, 0x0935, "ActivityTypeInVehicle" },
		{ 0x20, 0x0936, "ActivityTypeBiking" },
		{ 0x20, 0x0937, "ActivityTypeIdle" },
		{ 0x20, 0x0940, "UnitNotSpecified" },
		{ 0x20, 0x0941, "UnitLux" },
		{ 0x20, 0x0942, "UnitDegreesKelvin" },
		{ 0x20, 0x0943, "UnitDegreesCelsius" },
		{ 0x20, 0x0944, "UnitPascal" },
		{ 0x20, 0x0945, "UnitNewton" },
		{ 0x20, 0x0946, "UnitMetersSecond" },
		{ 0x20, 0x0947, "UnitKilogram" },
		{ 0x20, 0x0948, "UnitMeter" },
		{ 0x20, 0x0949, "UnitMetersSecondSecond" },
		{ 0x20, 0x094a, "UnitFarad" },
		{ 0x20, 0x094b, "UnitAmpere" },
		{ 0x20, 0x094c, "UnitWatt" },
		{ 0x20, 0x094d, "UnitHenry" },
		{ 0x20, 0x094e, "UnitOhm" },
		{ 0x20, 0x094f, "UnitVolt" },
		{ 0x20, 0x0950, "UnitHertz" },
		{ 0x20, 0x0951, "UnitBar" },
		{ 0x20, 0x0952, "UnitDegreesAnticlockwise" },
		{ 0x20, 0x0953, "UnitDegreesClockwise" },
		{ 0x20, 0x0954, "UnitDegrees" },
		{ 0x20, 0x0955, "UnitDegreesSecond" },
		{ 0x20, 0x0956, "UnitDegreesSecondSecond" },
		{ 0x20, 0x0957, "UnitKnot" },
		{ 0x20, 0x0958, "UnitPercent" },
		{ 0x20, 0x0959, "UnitSecond" },
		{ 0x20, 0x095a, "UnitMillisecond" },
		{ 0x20, 0x095b, "UnitG" },
		{ 0x20, 0x095c, "UnitBytes" },
		{ 0x20, 0x095d, "UnitMilligauss" },
		{ 0x20, 0x095e, "UnitBits" },
		{ 0x20, 0x0960, "ActivityStateNoStateChange" },
		{ 0x20, 0x0961, "ActivityStateStartActivity" },
		{ 0x20, 0x0962, "ActivityStateEndActivity" },
		{ 0x20, 0x0970, "Exponent0" },
		{ 0x20, 0x0971, "Exponent1" },
		{ 0x20, 0x0972, "Exponent2" },
		{ 0x20, 0x0973, "Exponent3" },
		{ 0x20, 0x0974, "Exponent4" },
		{ 0x20, 0x0975, "Exponent5" },
		{ 0x20, 0x0976, "Exponent6" },
		{ 0x20, 0x0977, "Exponent7" },
		{ 0x20, 0x0978, "Exponent8" },
		{ 0x20, 0x0979, "Exponent9" },
		{ 0x20, 0x097a, "ExponentA" },
		{ 0x20, 0x097b, "ExponentB" },
		{ 0x20, 0x097c, "ExponentC" },
		{ 0x20, 0x097d, "ExponentD" },
		{ 0x20, 0x097e, "ExponentE" },
		{ 0x20, 0x097f, "ExponentF" },
		{ 0x20, 0x0980, "DevicePositionUnknown" },
		{ 0x20, 0x0981, "DevicePositionUnchanged" },
		{ 0x20, 0x0982, "DevicePositionOnDesk" },
		{ 0x20, 0x0983, "DevicePositionInHand" },
		{ 0x20, 0x0984, "DevicePositionMovinginBag" },
		{ 0x20, 0x0985, "DevicePositionStationaryinBag" },
		{ 0x20, 0x0990, "StepTypeUnknown" },
		{ 0x20, 0x0991, "StepTypeWalking" },
		{ 0x20, 0x0992, "StepTypeRunning" },
		{ 0x20, 0x09a0, "GestureStateUnknown" },
		{ 0x20, 0x09a1, "GestureStateStarted" },
		{ 0x20, 0x09a2, "GestureStateCompleted" },
		{ 0x20, 0x09a3, "GestureStateCancelled" },
		{ 0x20, 0x09b0, "HingeFoldContributingPanelUnknown" },
		{ 0x20, 0x09b1, "HingeFoldContributingPanelPanel1" },
		{ 0x20, 0x09b2, "HingeFoldContributingPanelPanel2" },
		{ 0x20, 0x09b3, "HingeFoldContributingPanelBoth" },
		{ 0x20, 0x09b4, "HingeFoldTypeUnknown" },
		{ 0x20, 0x09b5, "HingeFoldTypeIncreasing" },
		{ 0x20, 0x09b6, "HingeFoldTypeDecreasing" },
		{ 0x20, 0x09c0, "HumanPresenceDetectionTypeVendorDefinedNonBiometric" },
		{ 0x20, 0x09c1, "HumanPresenceDetectionTypeVendorDefinedBiometric" },
		{ 0x20, 0x09c2, "HumanPresenceDetectionTypeFacialBiometric" },
		{ 0x20, 0x09c3, "HumanPresenceDetectionTypeAudioBiometric" },
		{ 0x20, 0x1000, "ModifierChangeSensitivityAbsolute" },
		{ 0x20, 0x2000, "ModifierMaximum" },
		{ 0x20, 0x3000, "ModifierMinimum" },
		{ 0x20, 0x4000, "ModifierAccuracy" },
		{ 0x20, 0x5000, "ModifierResolution" },
		{ 0x20, 0x6000, "ModifierThresholdHigh" },
		{ 0x20, 0x7000, "ModifierThresholdLow" },
		{ 0x20, 0x8000, "ModifierCalibrationOffset" },
		{ 0x20, 0x9000, "ModifierCalibrationMultiplier" },
		{ 0x20, 0xa000, "ModifierReportInterval" },
		{ 0x20, 0xb000, "ModifierFrequencyMax" },
		{ 0x20, 0xc000, "ModifierPeriodMax" },
		{ 0x20, 0xd000, "ModifierChangeSensitivityPercentofRange" },
		{ 0x20, 0xe000, "ModifierChangeSensitivityPercentRelative" },
		{ 0x20, 0xf000, "ModifierVendorReserved" },
	{ 0x40, 0, "MedicalInstrument" },
		{ 0x40, 0x0001, "MedicalUltrasound" },
		{ 0x40, 0x0020, "VCRAcquisition" },
		{ 0x40, 0x0021, "FreezeThaw" },
		{ 0x40, 0x0022, "ClipStore" },
		{ 0x40, 0x0023, "Update" },
		{ 0x40, 0x0024, "Next" },
		{ 0x40, 0x0025, "Save" },
		{ 0x40, 0x0026, "Print" },
		{ 0x40, 0x0027, "MicrophoneEnable" },
		{ 0x40, 0x0040, "Cine" },
		{ 0x40, 0x0041, "TransmitPower" },
		{ 0x40, 0x0042, "Volume" },
		{ 0x40, 0x0043, "Focus" },
		{ 0x40, 0x0044, "Depth" },
		{ 0x40, 0x0060, "SoftStepPrimary" },
		{ 0x40, 0x0061, "SoftStepSecondary" },
		{ 0x40, 0x0070, "DepthGainCompensation" },
		{ 0x40, 0x0080, "ZoomSelect" },
		{ 0x40, 0x0081, "ZoomAdjust" },
		{ 0x40, 0x0082, "SpectralDopplerModeSelect" },
		{ 0x40, 0x0083, "SpectralDopplerAdjust" },
		{ 0x40, 0x0084, "ColorDopplerModeSelect" },
		{ 0x40, 0x0085, "ColorDopplerAdjust" },
		{ 0x40, 0x0086, "MotionModeSelect" },
		{ 0x40, 0x0087, "MotionModeAdjust" },
		{ 0x40, 0x0088, "2DModeSelect" },
		{ 0x40, 0x0089, "2DModeAdjust" },
		{ 0x40, 0x00a0, "SoftControlSelect" },
		{ 0x40, 0x00a1, "SoftControlAdjust" },
	{ 0x41, 0, "BrailleDisplay" },
		{ 0x41, 0x0001, "BrailleDisplay" },
		{ 0x41, 0x0002, "BrailleRow" },
		{ 0x41, 0x0003, "8DotBrailleCell" },
		{ 0x41, 0x0004, "6DotBrailleCell" },
		{ 0x41, 0x0005, "NumberofBrailleCells" },
		{ 0x41, 0x0006, "ScreenReaderControl" },
		{ 0x41, 0x0007, "ScreenReaderIdentifier" },
		{ 0x41, 0x00fa, "RouterSet1" },
		{ 0x41, 0x00fb, "RouterSet2" },
		{ 0x41, 0x00fc, "RouterSet3" },
		{ 0x41, 0x0100, "RouterKey" },
		{ 0x41, 0x0101, "RowRouterKey" },
		{ 0x41, 0x0200, "BrailleButtons" },
		{ 0x41, 0x0201, "BrailleKeyboardDot1" },
		{ 0x41, 0x0202, "BrailleKeyboardDot2" },
		{ 0x41, 0x0203, "BrailleKeyboardDot3" },
		{ 0x41, 0x0204, "BrailleKeyboardDot4" },
		{ 0x41, 0x0205, "BrailleKeyboardDot5" },
		{ 0x41, 0x0206, "BrailleKeyboardDot6" },
		{ 0x41, 0x0207, "BrailleKeyboardDot7" },
		{ 0x41, 0x0208, "BrailleKeyboardDot8" },
		{ 0x41, 0x0209, "BrailleKeyboardSpace" },
		{ 0x41, 0x020a, "BrailleKeyboardLeftSpace" },
		{ 0x41, 0x020b, "BrailleKeyboardRightSpace" },
		{ 0x41, 0x020c, "BrailleFaceControls" },
		{ 0x41, 0x020d, "BrailleLeftControls" },
		{ 0x41, 0x020e, "BrailleRightControls" },
		{ 0x41, 0x020f, "BrailleTopControls" },
		{ 0x41, 0x0210, "BrailleJoystickCenter" },
		{ 0x41, 0x0211, "BrailleJoystickUp" },
		{ 0x41, 0x0212, "BrailleJoystickDown" },
		{ 0x41, 0x0213, "BrailleJoystickLeft" },
		{ 0x41, 0x0214, "BrailleJoystickRight" },
		{ 0x41, 0x0215, "BrailleDPadCenter" },
		{ 0x41, 0x0216, "BrailleDPadUp" },
		{ 0x41, 0x0217, "BrailleDPadDown" },
		{ 0x41, 0x0218, "BrailleDPadLeft" },
		{ 0x41, 0x0219, "BrailleDPadRight" },
		{ 0x41, 0x021a, "BraillePanLeft" },
		{ 0x41, 0x021b, "BraillePanRight" },
		{ 0x41, 0x021c, "BrailleRockerUp" },
		{ 0x41, 0x021d, "BrailleRockerDown" },
		{ 0x41, 0x021e, "BrailleRockerPress" },
	{ 0x59, 0, "LightingAndIllumination" },
		{ 0x59, 0x0001, "LampArray" },
		{ 0x59, 0x0002, "LampArrayAttributesReport" },
		{ 0x59, 0x0003, "LampCount" },
		{ 0x59, 0x0004, "BoundingBoxWidthInMicrometers" },
		{ 0x59, 0x0005, "BoundingBoxHeightInMicrometers" },
		{ 0x59, 0x0006, "BoundingBoxDepthInMicrometers" },
		{ 0x59, 0x0007, "LampArrayKind" },
		{ 0x59, 0x0008, "MinUpdateIntervalInMicroseconds" },
		{ 0x59, 0x0020, "LampAttributesRequestReport" },
		{ 0x59, 0x0021, "LampId" },
		{ 0x59, 0x0022, "LampAttributesResponseReport" },
		{ 0x59, 0x0023, "PositionXInMicrometers" },
		{ 0x59, 0x0024, "PositionYInMicrometers" },
		{ 0x59, 0x0025, "PositionZInMicrometers" },
		{ 0x59, 0x0026, "LampPurposes" },
		{ 0x59, 0x0027, "UpdateLatencyInMicroseconds" },
		{ 0x59, 0x0028, "RedLevelCount" },
		{ 0x59, 0x0029, "GreenLevelCount" },
		{ 0x59, 0x002a, "BlueLevelCount" },
		{ 0x59, 0x002b, "IntensityLevelCount" },
		{ 0x59, 0x002c, "IsProgrammable" },
		{ 0x59, 0x002d, "InputBinding" },
		{ 0x59, 0x0050, "LampMultiUpdateReport" },
		{ 0x59, 0x0051, "RedUpdateChannel" },
		{ 0x59, 0x0052, "GreenUpdateChannel" },
		{ 0x59, 0x0053, "BlueUpdateChannel" },
		{ 0x59, 0x0054, "IntensityUpdateChannel" },
		{ 0x59, 0x0055, "LampUpdateFlags" },
		{ 0x59, 0x0060, "LampRangeUpdateReport" },
		{ 0x59, 0x0061, "LampIdStart" },
		{ 0x59, 0x0062, "LampIdEnd" },
		{ 0x59, 0x0070, "LampArrayControlReport" },
		{ 0x59, 0x0071, "AutonomousMode" },
	{ 0x80, 0, "Monitor" },
		{ 0x80, 0x0001, "MonitorControl" },
		{ 0x80, 0x0002, "EDIDInformation" },
		{ 0x80, 0x0003, "VDIFInformation" },
		{ 0x80, 0x0004, "VESAVersion" },
	{ 0x81, 0, "MonitorEnumerated" },
	{ 0x82, 0, "VESAVirtualControls" },
		{ 0x82, 0x0001, "Degauss" },
		{ 0x82, 0x0010, "Brightness" },
		{ 0x82, 0x0012, "Contrast" },
		{ 0x82, 0x0016, "RedVideoGain" },
		{ 0x82, 0x0018, "GreenVideoGain" },
		{ 0x82, 0x001a, "BlueVideoGain" },
		{ 0x82, 0x001c, "Focus" },
		{ 0x82, 0x0020, "HorizontalPosition" },
		{ 0x82, 0x0022, "HorizontalSize" },
		{ 0x82, 0x0024, "HorizontalPincushion" },
		{ 0x82, 0x0026, "HorizontalPincushionBalance" },
		{ 0x82, 0x0028, "HorizontalMisconvergence" },
		{ 0x82, 0x002a, "HorizontalLinearity" },
		{ 0x82, 0x002c, "HorizontalLinearityBalance" },
		{ 0x82, 0x0030, "VerticalPosition" },
		{ 0x82, 0x0032, "VerticalSize" },
		{ 0x82, 0x0034, "VerticalPincushion" },
		{ 0x82, 0x0036, "VerticalPincushionBalance" },
		{ 0x82, 0x0038, "VerticalMisconvergence" },
		{ 0x82, 0x003a, "VerticalLinearity" },
		{ 0x82, 0x003c, "VerticalLinearityBalance" },
		{ 0x82, 0x0040, "ParallelogramDistortionKeyBalance" },
		{ 0x82, 0x0042, "TrapezoidalDistortionKey" },
		{ 0x82, 0x0044, "TiltRotation" },
		{ 0x82, 0x0046, "TopCornerDistortionControl" },
		{ 0x82, 0x0048, "TopCornerDistortionBalance" },
		{ 0x82, 0x004a, "BottomCornerDistortionControl" },
		{ 0x82, 0x004c, "BottomCornerDistortionBalance" },
		{ 0x82, 0x0056, "HorizontalMoire" },
		{ 0x82, 0x0058, "VerticalMoire" },
		{ 0x82, 0x005e, "InputLevelSelect" },
		{ 0x82, 0x0060, "InputSourceSelect" },
		{ 0x82, 0x006c, "RedVideoBlackLevel" },
		{ 0x82, 0x006e, "GreenVideoBlackLevel" },
		{ 0x82, 0x0070, "BlueVideoBlackLevel" },
		{ 0x82, 0x00a2, "AutoSizeCenter" },
		{ 0x82, 0x00a4, "PolarityHorizontalSynchronization" },
		{ 0x82, 0x00a6, "PolarityVerticalSynchronization" },
		{ 0x82, 0x00a8, "SynchronizationType" },
		{ 0x82, 0x00aa, "ScreenOrientation" },
		{ 0x82, 0x00ac, "HorizontalFrequency" },
		{ 0x82, 0x00ae, "VerticalFrequency" },
		{ 0x82, 0x00b0, "Settings" },
		{ 0x82, 0x00ca, "OnScreenDisplay" },
		{ 0x82, 0x00d4, "StereoMode" },
	{ 0x84, 0, "Power" },
		{ 0x84, 0x0001, "iName" },
		{ 0x84, 0x0002, "PresentStatus" },
		{ 0x84, 0x0003, "ChangedStatus" },
		{ 0x84, 0x0004, "UPS" },
		{ 0x84, 0x0005, "PowerSupply" },
		{ 0x84, 0x0010, "BatterySystem" },
		{ 0x84, 0x0011, "BatterySystemId" },
		{ 0x84, 0x0012, "Battery" },
		{ 0x84, 0x0013, "BatteryId" },
		{ 0x84, 0x0014, "Charger" },
		{ 0x84, 0x0015, "ChargerId" },
		{ 0x84, 0x0016, "PowerConverter" },
		{ 0x84, 0x0017, "PowerConverterId" },
		{ 0x84, 0x0018, "OutletSystem" },
		{ 0x84, 0x0019, "OutletSystemId" },
		{ 0x84, 0x001a, "Input" },
		{ 0x84, 0x001b, "InputId" },
		{ 0x84, 0x001c, "Output" },
		{ 0x84, 0x001d, "OutputId" },
		{ 0x84, 0x001e, "Flow" },
		{ 0x84, 0x001f, "FlowId" },
		{ 0x84, 0x0020, "Outlet" },
		{ 0x84, 0x0021, "OutletId" },
		{ 0x84, 0x0022, "Gang" },
		{ 0x84, 0x0023, "GangId" },
		{ 0x84, 0x0024, "PowerSummary" },
		{ 0x84, 0x0025, "PowerSummaryId" },
		{ 0x84, 0x0030, "Voltage" },
		{ 0x84, 0x0031, "Current" },
		{ 0x84, 0x0032, "Frequency" },
		{ 0x84, 0x0033, "ApparentPower" },
		{ 0x84, 0x0034, "ActivePower" },
		{ 0x84, 0x0035, "PercentLoad" },
		{ 0x84, 0x0036, "Temperature" },
		{ 0x84, 0x0037, "Humidity" },
		{ 0x84, 0x0038, "BadCount" },
		{ 0x84, 0x0040, "ConfigVoltage" },
		{ 0x84, 0x0041, "ConfigCurrent" },
		{ 0x84, 0x0042, "ConfigFrequency" },
		{ 0x84, 0x0043, "ConfigApparentPower" },
		{ 0x84, 0x0044, "ConfigActivePower" },
		{ 0x84, 0x0045, "ConfigPercentLoad" },
		{ 0x84, 0x0046, "ConfigTemperature" },
		{ 0x84, 0x0047, "ConfigHumidity" },
		{ 0x84, 0x0050, "SwitchOnControl" },
		{ 0x84, 0x0051, "SwitchOffControl" },
		{ 0x84, 0x0052, "ToggleControl" },
		{ 0x84, 0x0053, "LowVoltageTransfer" },
		{ 0x84, 0x0054, "HighVoltageTransfer" },
		{ 0x84, 0x0055, "DelayBeforeReboot" },
		{ 0x84, 0x0056, "DelayBeforeStartup" },
		{ 0x84, 0x0057, "DelayBeforeShutdown" },
		{ 0x84, 0x0058, "Test" },
		{ 0x84, 0x0059, "ModuleReset" },
		{ 0x84, 0x005a, "AudibleAlarmControl" },
		{ 0x84, 0x0060, "Present" },
		{ 0x84, 0x0061, "Good" },
		{ 0x84, 0x0062, "InternalFailure" },
		{ 0x84, 0x0063, "VoltagOutOfRange" },
		{ 0x84, 0x0064, "FrequencyOutOfRange" },
		{ 0x84, 0x0065, "Overload" },
		{ 0x84, 0x0066, "OverCharged" },
		{ 0x84, 0x0067, "OverTemperature" },
		{ 0x84, 0x0068, "ShutdownRequested" },
		{ 0x84, 0x0069, "ShutdownImminent" },
		{ 0x84, 0x006b, "SwitchOnOff" },
		{ 0x84, 0x006c, "Switchable" },
		{ 0x84, 0x006d, "Used" },
		{ 0x84, 0x006e, "Boost" },
		{ 0x84, 0x006f, "Buck" },
		{ 0x84, 0x0070, "Initialized" },
		{ 0x84, 0x0071, "Tested" },
		{ 0x84, 0x0072, "AwaitingPower" },
		{ 0x84, 0x0073, "CommunicationLost" },
		{ 0x84, 0x00fd, "iManufacturer" },
		{ 0x84, 0x00fe, "iProduct" },
		{ 0x84, 0x00ff, "iSerialNumber" },
	{ 0x85, 0, "BatterySystem" },
		{ 0x85, 0x0001, "SmartBatteryBatteryMode" },
		{ 0x85, 0x0002, "SmartBatteryBatteryStatus" },
		{ 0x85, 0x0003, "SmartBatteryAlarmWarning" },
		{ 0x85, 0x0004, "SmartBatteryChargerMode" },
		{ 0x85, 0x0005, "SmartBatteryChargerStatus" },
		{ 0x85, 0x0006, "SmartBatteryChargerSpecInfo" },
		{ 0x85, 0x0007, "SmartBatterySelectorState" },
		{ 0x85, 0x0008, "SmartBatterySelectorPresets" },
		{ 0x85, 0x0009, "SmartBatterySelectorInfo" },
		{ 0x85, 0x0010, "OptionalMfgFunction1" },
		{ 0x85, 0x0011, "OptionalMfgFunction2" },
		{ 0x85, 0x0012, "OptionalMfgFunction3" },
		{ 0x85, 0x0013, "OptionalMfgFunction4" },
		{ 0x85, 0x0014, "OptionalMfgFunction5" },
		{ 0x85, 0x0015, "ConnectionToSMBus" },
		{ 0x85, 0x0016, "OutputConnection" },
		{ 0x85, 0x0017, "ChargerConnection" },
		{ 0x85, 0x0018, "BatteryInsertion" },
		{ 0x85, 0x0019, "UseNext" },
		{ 0x85, 0x001a, "OKToUse" },
		{ 0x85, 0x001b, "BatterySupported" },
		{ 0x85, 0x001c, "SelectorRevision" },
		{ 0x85, 0x001d, "ChargingIndicator" },
		{ 0x85, 0x0028, "ManufacturerAccess" },
		{ 0x85, 0x0029, "RemainingCapacityLimit" },
		{ 0x85, 0x002a, "RemainingTimeLimit" },
		{ 0x85, 0x002b, "AtRate" },
		{ 0x85, 0x002c, "CapacityMode" },
		{ 0x85, 0x002d, "BroadcastToCharger" },
		{ 0x85, 0x002e, "PrimaryBattery" },
		{ 0x85, 0x002f, "ChargeController" },
		{ 0x85, 0x0040, "TerminateCharge" },
		{ 0x85, 0x0041, "TerminateDischarge" },
		{ 0x85, 0x0042, "BelowRemainingCapacityLimit" },
		{ 0x85, 0x0043, "RemainingTimeLimitExpired" },
		{ 0x85, 0x0044, "Charging" },
		{ 0x85, 0x0045, "Discharging" },
		{ 0x85, 0x0046, "FullyCharged" },
		{ 0x85, 0x0047, "FullyDischarged" },
		{ 0x85, 0x0048, "ConditioningFlag" },
		{ 0x85, 0x0049, "AtRateOK" },
		{ 0x85, 0x004a, "SmartBatteryErrorCode" },
		{ 0x85, 0x004b, "NeedReplacement" },
		{ 0x85, 0x0060, "AtRateTimeToFull" },
		{ 0x85, 0x0061, "AtRateTimeToEmpty" },
		{ 0x85, 0x0062, "AverageCurrent" },
		{ 0x85, 0x0063, "MaxError" },
		{ 0x85, 0x0064, "RelativeStateOfCharge" },
		{ 0x85, 0x0065, "AbsoluteStateOfCharge" },
		{ 0x85, 0x0066, "RemainingCapacity" },
		{ 0x85, 0x0067, "FullChargeCapacity" },
		{ 0x85, 0x0068, "RunTimeToEmpty" },
		{ 0x85, 0x0069, "AverageTimeToEmpty" },
		{ 0x85, 0x006a, "AverageTimeToFull" },
		{ 0x85, 0x006b, "CycleCount" },
		{ 0x85, 0x0080, "BatteryPackModelLevel" },
		{ 0x85, 0x0081, "InternalChargeController" },
		{ 0x85, 0x0082, "PrimaryBatterySupport" },
		{ 0x85, 0x0083, "DesignCapacity" },
		{ 0x85, 0x0084, "SpecificationInfo" },
		{ 0x85, 0x0085, "ManufactureDate" },
		{ 0x85, 0x0086, "SerialNumber" },
		{ 0x85, 0x0087, "iManufacturerName" },
		{ 0x85, 0x0088, "iDeviceName" },
		{ 0x85, 0x0089, "iDeviceChemistry" },
		{ 0x85, 0x008a, "ManufacturerData" },
		{ 0x85, 0x008b, "Rechargeable" },
		{ 0x85, 0x008c, "WarningCapacityLimit" },
		{ 0x85, 0x008d, "CapacityGranularity1" },
		{ 0x85, 0x008e, "CapacityGranularity2" },
		{ 0x85, 0x008f, "iOEMInformation" },
		{ 0x85, 0x00c0, "InhibitCharge" },
		{ 0x85, 0x00c1, "EnablePolling" },
		{ 0x85, 0x00c2, "ResetToZero" },
		{ 0x85, 0x00d0, "ACPresent" },
		{ 0x85, 0x00d1, "BatteryPresent" },
		{ 0x85, 0x00d2, "PowerFail" },
		{ 0x85, 0x00d3, "AlarmInhibited" },
		{ 0x85, 0x00d4, "ThermistorUnderRange" },
		{ 0x85, 0x00d5, "ThermistorHot" },
		{ 0x85, 0x00d6, "ThermistorCold" },
		{ 0x85, 0x00d7, "ThermistorOverRange" },
		{ 0x85, 0x00d8, "VoltageOutOfRange" },
		{ 0x85, 0x00d9, "CurrentOutOfRange" },
		{ 0x85, 0x00da, "CurrentNotRegulated" },
		{ 0x85, 0x00db, "VoltageNotRegulated" },
		{ 0x85, 0x00dc, "MasterMode" },
		{ 0x85, 0x00f0, "ChargerSelectorSupport" },
		{ 0x85, 0x00f1, "ChargerSpec" },
		{ 0x85, 0x00f2, "Level2" },
		{ 0x85, 0x00f3, "Level3" },
	{ 0x8c, 0, "BarcodeScanner" },
		{ 0x8c, 0x0001, "BarcodeBadgeReader" },
		{ 0x8c, 0x0002, "BarcodeScanner" },
		{ 0x8c, 0x0003, "DumbBarCodeScanner" },
		{ 0x8c, 0x0004, "CordlessScannerBase" },
		{ 0x8c, 0x0005, "BarCodeScannerCradle" },
		{ 0x8c, 0x0010, "AttributeReport" },
		{ 0x8c, 0x0011, "SettingsReport" },
		{ 0x8c, 0x0012, "ScannedDataReport" },
		{ 0x8c, 0x0013, "RawScannedDataReport" },
		{ 0x8c, 0x0014, "TriggerReport" },
		{ 0x8c, 0x0015, "StatusReport" },
		{ 0x8c, 0x0016, "UPCEANControlReport" },
		{ 0x8c, 0x0017, "EAN23LabelControlReport" },
		{ 0x8c, 0x0018, "Code39ControlReport" },
		{ 0x8c, 0x0019, "Interleaved2of5ControlReport" },
		{ 0x8c, 0x001a, "Standard2of5ControlReport" },
		{ 0x8c, 0x001b, "MSIPlesseyControlReport" },
		{ 0x8c, 0x001c, "CodabarControlReport" },
		{ 0x8c, 0x001d, "Code128ControlReport" },
		{ 0x8c, 0x001e, "Misc1DControlReport" },
		{ 0x8c, 0x001f, "2DControlReport" },
		{ 0x8c, 0x0030, "AimingPointerMode" },
		{ 0x8c, 0x0031, "BarCodePresentSensor" },
		{ 0x8c, 0x0032, "Class1ALaser" },
		{ 0x8c, 0x0033, "Class2Laser" },
		{ 0x8c, 0x0034, "HeaterPresent" },
		{ 0x8c, 0x0035, "ContactScanner" },
		{ 0x8c, 0x0036, "ElectronicArticleSurveillanceNotification" },
		{ 0x8c, 0x0037, "ConstantElectronicArticleSurveillance" },
		{ 0x8c, 0x0038, "ErrorIndication" },
		{ 0x8c, 0x0039, "FixedBeeper" },
		{ 0x8c, 0x003a, "GoodDecodeIndication" },
		{ 0x8c, 0x003b, "HandsFreeScanning" },
		{ 0x8c, 0x003c, "IntrinsicallySafe" },
		{ 0x8c, 0x003d, "KlasseEinsLaser" },
		{ 0x8c, 0x003e, "LongRangeScanner" },
		{ 0x8c, 0x003f, "MirrorSpeedControl" },
		{ 0x8c, 0x0040, "NotOnFileIndication" },
		{ 0x8c, 0x0041, "ProgrammableBeeper" },
		{ 0x8c, 0x0042, "Triggerless" },
		{ 0x8c, 0x0043, "Wand" },
		{ 0x8c, 0x0044, "WaterResistant" },
		{ 0x8c, 0x0045, "MultiRangeScanner" },
		{ 0x8c, 0x0046, "ProximitySensor" },
		{ 0x8c, 0x004d, "FragmentDecoding" },
		{ 0x8c, 0x004e, "ScannerReadConfidence" },
		{ 0x8c, 0x004f, "DataPrefix" },
		{ 0x8c, 0x0050, "PrefixAIMI" },
		{ 0x8c, 0x0051, "PrefixNone" },
		{ 0x8c, 0x0052, "PrefixProprietary" },
		{ 0x8c, 0x0055, "ActiveTime" },
		{ 0x8c, 0x0056, "AimingLaserPattern" },
		{ 0x8c, 0x0057, "BarCodePresent" },
		{ 0x8c, 0x0058, "BeeperState" },
		{ 0x8c, 0x0059, "LaserOnTime" },
		{ 0x8c, 0x005a, "LaserState" },
		{ 0x8c, 0x005b, "LockoutTime" },
		{ 0x8c, 0x005c, "MotorState" },
		{ 0x8c, 0x005d, "MotorTimeout" },
		{ 0x8c, 0x005e, "PowerOnResetScanner" },
		{ 0x8c, 0x005f, "PreventReadofBarcodes" },
		{ 0x8c, 0x0060, "InitiateBarcodeRead" },
		{ 0x8c, 0x0061, "TriggerState" },
		{ 0x8c, 0x0062, "TriggerMode" },
		{ 0x8c, 0x0063, "TriggerModeBlinkingLaserOn" },
		{ 0x8c, 0x0064, "TriggerModeContinuousLaserOn" },
		{ 0x8c, 0x0065, "TriggerModeLaseronwhilePulled" },
		{ 0x8c, 0x0066, "TriggerModeLaserstaysonafterrelease" },
		{ 0x8c, 0x006d, "CommitParameterstoNVM" },
		{ 0x8c, 0x006e, "ParameterScanning" },
		{ 0x8c, 0x006f, "ParametersChanged" },
		{ 0x8c, 0x0070, "Setparameterdefaultvalues" },
		{ 0x8c, 0x0075, "ScannerInCradle" },
		{ 0x8c, 0x0076, "ScannerInRange" },
		{ 0x8c, 0x007a, "AimDuration" },
		{ 0x8c, 0x007b, "GoodReadLampDuration" },
		{ 0x8c, 0x007c, "GoodReadLampIntensity" },
		{ 0x8c, 0x007d, "GoodReadLED" },
		{ 0x8c, 0x007e, "GoodReadToneFrequency" },
		{ 0x8c, 0x007f, "GoodReadToneLength" },
		{ 0x8c, 0x0080, "GoodReadToneVolume" },
		{ 0x8c, 0x0082, "NoReadMessage" },
		{ 0x8c, 0x0083, "NotonFileVolume" },
		{ 0x8c, 0x0084, "PowerupBeep" },
		{ 0x8c, 0x0085, "SoundErrorBeep" },
		{ 0x8c, 0x0086, "SoundGoodReadBeep" },
		{ 0x8c, 0x0087, "SoundNotOnFileBeep" },
		{ 0x8c, 0x0088, "GoodReadWhentoWrite" },
		{ 0x8c, 0x0089, "GRWTIAfterDecode" },
		{ 0x8c, 0x008a, "GRWTIBeepLampaftertransmit" },
		{ 0x8c, 0x008b, "GRWTINoBeepLampuseatall" },
		{ 0x8c, 0x0091, "BooklandEAN" },
		{ 0x8c, 0x0092, "ConvertEAN8to13Type" },
		{ 0x8c, 0x0093, "ConvertUPCAtoEAN13" },
		{ 0x8c, 0x0094, "ConvertUPCEtoA" },
		{ 0x8c, 0x0095, "EAN13" },
		{ 0x8c, 0x0096, "EAN8" },
		{ 0x8c, 0x0097, "EAN99128Mandatory" },
		{ 0x8c, 0x0098, "EAN99P5128Optional" },
		{ 0x8c, 0x0099, "EnableEANTwoLabel" },
		{ 0x8c, 0x009a, "UPCEAN" },
		{ 0x8c, 0x009b, "UPCEANCouponCode" },
		{ 0x8c, 0x009c, "UPCEANPeriodicals" },
		{ 0x8c, 0x009d, "UPCA" },
		{ 0x8c, 0x009e, "UPCAwith128Mandatory" },
		{ 0x8c, 0x009f, "UPCAwith128Optional" },
		{ 0x8c, 0x00a0, "UPCAwithP5Optional" },
		{ 0x8c, 0x00a1, "UPCE" },
		{ 0x8c, 0x00a2, "UPCE1" },
		{ 0x8c, 0x00a9, "Periodical" },
		{ 0x8c, 0x00aa, "PeriodicalAutoDiscriminate2" },
		{ 0x8c, 0x00ab, "PeriodicalOnlyDecodewith2" },
		{ 0x8c, 0x00ac, "PeriodicalIgnore2" },
		{ 0x8c, 0x00ad, "PeriodicalAutoDiscriminate5" },
		{ 0x8c, 0x00ae, "PeriodicalOnlyDecodewith5" },
		{ 0x8c, 0x00af, "PeriodicalIgnore5" },
		{ 0x8c, 0x00b0, "Check" },
		{ 0x8c, 0x00b1, "CheckDisablePrice" },
		{ 0x8c, 0x00b2, "CheckEnable4digitPrice" },
		{ 0x8c, 0x00b3, "CheckEnable5digitPrice" },
		{ 0x8c, 0x00b4, "CheckEnableEuropean4digitPrice" },
		{ 0x8c, 0x00b5, "CheckEnableEuropean5digitPrice" },
		{ 0x8c, 0x00b7, "EANTwoLabel" },
		{ 0x8c, 0x00b8, "EANThreeLabel" },
		{ 0x8c, 0x00b9, "EAN8FlagDigit1" },
		{ 0x8c, 0x00ba, "EAN8FlagDigit2" },
		{ 0x8c, 0x00bb, "EAN8FlagDigit3" },
		{ 0x8c, 0x00bc, "EAN13FlagDigit1" },
		{ 0x8c, 0x00bd, "EAN13FlagDigit2" },
		{ 0x8c, 0x00be, "EAN13FlagDigit3" },
		{ 0x8c, 0x00bf, "AddEAN23LabelDefinition" },
		{ 0x8c, 0x00c0, "ClearallEAN23LabelDefinitions" },
		{ 0x8c, 0x00c3, "Codabar" },
		{ 0x8c, 0x00c4, "Code128" },
		{ 0x8c, 0x00c7, "Code39" },
		{ 0x8c, 0x00c8, "Code93" },
		{ 0x8c, 0x00c9, "FullASCIIConversion" },
		{ 0x8c, 0x00ca, "Interleaved2of5" },
		{ 0x8c, 0x00cb, "ItalianPharmacyCode" },
		{ 0x8c, 0x00cc, "MSIPlessey" },
		{ 0x8c, 0x00cd, "Standard2of5IATA" },
		{ 0x8c, 0x00ce, "Standard2of5" },
		{ 0x8c, 0x00d3, "TransmitStartStop" },
		{ 0x8c, 0x00d4, "TriOptic" },
		{ 0x8c, 0x00d5, "UCCEAN128" },
		{ 0x8c, 0x00d6, "CheckDigit" },
		{ 0x8c, 0x00d7, "CheckDigitDisable" },
		{ 0x8c, 0x00d8, "CheckDigitEnableInterleaved2of5OPCC" },
		{ 0x8c, 0x00d9, "CheckDigitEnableInterleaved2of5USS" },
		{ 0x8c, 0x00da, "CheckDigitEnableStandard2of5OPCC" },
		{ 0x8c, 0x00db, "CheckDigitEnableStandard2of5USS" },
		{ 0x8c, 0x00dc, "CheckDigitEnableOneMSIPlessey" },
		{ 0x8c, 0x00dd, "CheckDigitEnableTwoMSIPlessey" },
		{ 0x8c, 0x00de, "CheckDigitCodabarEnable" },
		{ 0x8c, 0x00df, "CheckDigitCode39Enable" },
		{ 0x8c, 0x00f0, "TransmitCheckDigit" },
		{ 0x8c, 0x00f1, "DisableCheckDigitTransmit" },
		{ 0x8c, 0x00f2, "EnableCheckDigitTransmit" },
		{ 0x8c, 0x00fb, "SymbologyIdentifier1" },
		{ 0x8c, 0x00fc, "SymbologyIdentifier2" },
		{ 0x8c, 0x00fd, "SymbologyIdentifier3" },
		{ 0x8c, 0x00fe, "DecodedData" },
		{ 0x8c, 0x00ff, "DecodeDataContinued" },
		{ 0x8c, 0x0100, "BarSpaceData" },
		{ 0x8c, 0x0101, "ScannerDataAccuracy" },
		{ 0x8c, 0x0102, "RawDataPolarity" },
		{ 0x8c, 0x0103, "PolarityInvertedBarCode" },
		{ 0x8c, 0x0104, "PolarityNormalBarCode" },
		{ 0x8c, 0x0106, "MinimumLengthtoDecode" },
		{ 0x8c, 0x0107, "MaximumLengthtoDecode" },
		{ 0x8c, 0x0108, "DiscreteLengthtoDecode1" },
		{ 0x8c, 0x0109, "DiscreteLengthtoDecode2" },
		{ 0x8c, 0x010a, "DataLengthMethod" },
		{ 0x8c, 0x010b, "DLMethodReadany" },
		{ 0x8c, 0x010c, "DLMethodCheckinRange" },
		{ 0x8c, 0x010d, "DLMethodCheckforDiscrete" },
		{ 0x8c, 0x0110, "AztecCode" },
		{ 0x8c, 0x0111, "BC412" },
		{ 0x8c, 0x0112, "ChannelCode" },
		{ 0x8c, 0x0113, "Code16" },
		{ 0x8c, 0x0114, "Code32" },
		{ 0x8c, 0x0115, "Code49" },
		{ 0x8c, 0x0116, "CodeOne" },
		{ 0x8c, 0x0117, "Colorcode" },
		{ 0x8c, 0x0118, "DataMatrix" },
		{ 0x8c, 0x0119, "MaxiCode" },
		{ 0x8c, 0x011a, "MicroPDF" },
		{ 0x8c, 0x011b, "PDF417" },
		{ 0x8c, 0x011c, "PosiCode" },
		{ 0x8c, 0x011d, "QRCode" },
		{ 0x8c, 0x011e, "SuperCode" },
		{ 0x8c, 0x011f, "UltraCode" },
		{ 0x8c, 0x0120, "USD5SlugCode" },
		{ 0x8c, 0x0121, "VeriCode" },
	{ 0x8d, 0, "Scales" },
		{ 0x8d, 0x0001, "Scales" },
		{ 0x8d, 0x0020, "ScaleDevice" },
		{ 0x8d, 0x0021, "ScaleClass" },
		{ 0x8d, 0x0022, "ScaleClassIMetric" },
		{ 0x8d, 0x0023, "ScaleClassIIMetric" },
		{ 0x8d, 0x0024, "ScaleClassIIIMetric" },
		{ 0x8d, 0x0025, "ScaleClassIIILMetric" },
		{ 0x8d, 0x0026, "ScaleClassIVMetric" },
		{ 0x8d, 0x0027, "ScaleClassIIIEnglish" },
		{ 0x8d, 0x0028, "ScaleClassIIILEnglish" },
		{ 0x8d, 0x0029, "ScaleClassIVEnglish" },
		{ 0x8d, 0x002a, "ScaleClassGeneric" },
		{ 0x8d, 0x0030, "ScaleAttributeReport" },
		{ 0x8d, 0x0031, "ScaleControlReport" },
		{ 0x8d, 0x0032, "ScaleDataReport" },
		{ 0x8d, 0x0033, "ScaleStatusReport" },
		{ 0x8d, 0x0034, "ScaleWeightLimitReport" },
		{ 0x8d, 0x0035, "ScaleStatisticsReport" },
		{ 0x8d, 0x0040, "DataWeight" },
		{ 0x8d, 0x0041, "DataScaling" },
		{ 0x8d, 0x0050, "WeightUnit" },
		{ 0x8d, 0x0051, "WeightUnitMilligram" },
		{ 0x8d, 0x0052, "WeightUnitGram" },
		{ 0x8d, 0x0053, "WeightUnitKilogram" },
		{ 0x8d, 0x0054, "WeightUnitCarats" },
		{ 0x8d, 0x0055, "WeightUnitTaels" },
		{ 0x8d, 0x0056, "WeightUnitGrains" },
		{ 0x8d, 0x0057, "WeightUnitPennyweights" },
		{ 0x8d, 0x0058, "WeightUnitMetricTon" },
		{ 0x8d, 0x0059, "WeightUnitAvoirTon" },
		{ 0x8d, 0x005a, "WeightUnitTroyOunce" },
		{ 0x8d, 0x005b, "WeightUnitOunce" },
		{ 0x8d, 0x005c, "WeightUnitPound" },
		{ 0x8d, 0x0060, "CalibrationCount" },
		{ 0x8d, 0x0061, "ReZeroCount" },
		{ 0x8d, 0x0070, "ScaleStatus" },
		{ 0x8d, 0x0071, "ScaleStatusFault" },
		{ 0x8d, 0x0072, "ScaleStatusStableatCenterofZero" },
		{ 0x8d, 0x0073, "ScaleStatusInMotion" },
		{ 0x8d, 0x0074, "ScaleStatusWeightStable" },
		{ 0x8d, 0x0075, "ScaleStatusUnderZero" },
		{ 0x8d, 0x0076, "ScaleStatusOverWeightLimit" },
		{ 0x8d, 0x0077, "ScaleStatusRequiresCalibration" },
		{ 0x8d, 0x0078, "ScaleStatusRequiresRezeroing" },
		{ 0x8d, 0x0080, "ZeroScale" },
		{ 0x8d, 0x0081, "EnforcedZeroReturn" },
	{ 0x8e, 0, "MagneticStripeReader" },
		{ 0x8e, 0x0001, "MSRDeviceReadOnly" },
		{ 0x8e, 0x0011, "Track1Length" },
		{ 0x8e, 0x0012, "Track2Length" },
		{ 0x8e, 0x0013, "Track3Length" },
		{ 0x8e, 0x0014, "TrackJISLength" },
		{ 0x8e, 0x0020, "TrackData" },
		{ 0x8e, 0x0021, "Track1Data" },
		{ 0x8e, 0x0022, "Track2Data" },
		{ 0x8e, 0x0023, "Track3Data" },
		{ 0x8e, 0x0024, "TrackJISData" },
	{ 0x90, 0, "CameraControl" },
		{ 0x90, 0x0020, "CameraAutofocus" },
		{ 0x90, 0x0021, "CameraShutter" },
	{ 0x91, 0, "Arcade" },
		{ 0x91, 0x0001, "GeneralPurposeIOCard" },
		{ 0x91, 0x0002, "CoinDoor" },
		{ 0x91, 0x0003, "WatchdogTimer" },
		{ 0x91, 0x0030, "GeneralPurposeAnalogInputState" },
		{ 0x91, 0x0031, "GeneralPurposeDigitalInputState" },
		{ 0x91, 0x0032, "GeneralPurposeOpticalInputState" },
		{ 0x91, 0x0033, "GeneralPurposeDigitalOutputState" },
		{ 0x91, 0x0034, "NumberofCoinDoors" },
		{ 0x91, 0x0035, "CoinDrawerDropCount" },
		{ 0x91, 0x0036, "CoinDrawerStart" },
		{ 0x91, 0x0037, "CoinDrawerService" },
		{ 0x91, 0x0038, "CoinDrawerTilt" },
		{ 0x91, 0x0039, "CoinDoorTest" },
		{ 0x91, 0x0040, "CoinDoorLockout" },
		{ 0x91, 0x0041, "WatchdogTimeout" },
		{ 0x91, 0x0042, "WatchdogAction" },
		{ 0x91, 0x0043, "WatchdogReboot" },
		{ 0x91, 0x0044, "WatchdogRestart" },
		{ 0x91, 0x0045, "AlarmInput" },
		{ 0x91, 0x0046, "CoinDoorCounter" },
		{ 0x91, 0x0047, "IODirectionMapping" },
		{ 0x91, 0x0048, "SetIODirectionMapping" },
		{ 0x91, 0x0049, "ExtendedOpticalInputState" },
		{ 0x91, 0x004a, "PinPadInputState" },
		{ 0x91, 0x004b, "PinPadStatus" },
		{ 0x91, 0x004c, "PinPadOutput" },
		{ 0x91, 0x004d, "PinPadCommand" },
	{ 0xf1d0, 0, "FIDOAlliance" },
		{ 0xf1d0, 0x0001, "U2FAuthenticatorDevice" },
		{ 0xf1d0, 0x0020, "InputReportData" },
		{ 0xf1d0, 0x0021, "OutputReportData" },
	/* pages 0xff00 to 0xffff are vendor-specific */
	{ 0xffff, 0, "Vendor-specific-FF" },
	{ 0, 0, NULL }
};

/* Either output directly into simple seq_file, or (if f == NULL)
 * allocate a separate buffer that will then be passed to the 'events'
 * ringbuffer.
 *
 * This is because these functions can be called both for "one-shot"
 * "rdesc" while resolving, or for blocking "events".
 *
 * This holds both for resolv_usage_page() and hid_resolv_usage().
 */
static char *resolv_usage_page(unsigned page, struct seq_file *f) {
	const struct hid_usage_entry *p;
	char *buf = NULL;

	if (!f) {
		buf = kzalloc(HID_DEBUG_BUFSIZE, GFP_ATOMIC);
		if (!buf)
			return ERR_PTR(-ENOMEM);
	}

	for (p = hid_usage_table; p->description; p++)
		if (p->page == page) {
			if (!f) {
				snprintf(buf, HID_DEBUG_BUFSIZE, "%s",
						p->description);
				return buf;
			}
			else {
				seq_printf(f, "%s", p->description);
				return NULL;
			}
		}
	if (!f)
		snprintf(buf, HID_DEBUG_BUFSIZE, "%04x", page);
	else
		seq_printf(f, "%04x", page);
	return buf;
}

char *hid_resolv_usage(unsigned usage, struct seq_file *f) {
	const struct hid_usage_entry *p;
	const struct hid_usage_entry *m;
	char *buf = NULL;
	int len = 0;
	const char *modifier = NULL;
	unsigned int usage_modifier = usage & 0xF000;
	unsigned int usage_actual = usage & 0xFFFF;

	buf = resolv_usage_page(usage >> 16, f);
	if (IS_ERR(buf)) {
		pr_err("error allocating HID debug buffer\n");
		return NULL;
	}


	if (!f) {
		len = strlen(buf);
		len += scnprintf(buf + len, HID_DEBUG_BUFSIZE - len, ".");
	}
	else {
		seq_printf(f, ".");
	}
	for (p = hid_usage_table; p->description; p++)
		if (p->page == (usage >> 16)) {
			if (p->page == 0x20 && usage_modifier) {
				for (m = p; m->description; m++) {
					if (p->page == m->page && m->usage
							== usage_modifier) {
						modifier = m->description;
						break;
					}
				}
				if (modifier)
					usage_actual = usage_actual & 0x0FFF;
			}

			if (!modifier)
				modifier = "";

			for(++p; p->description && p->usage != 0; p++)
				if (p->usage == usage_actual) {
					if (!f)
						snprintf(buf + len,
							HID_DEBUG_BUFSIZE - len,
							"%s%s", p->description,
							modifier);
					else
						seq_printf(f,
							"%s%s",
							p->description,
							modifier);
					return buf;
				}
			break;
		}
	if (!f)
		snprintf(buf + len, HID_DEBUG_BUFSIZE - len, "%04x",
			 usage & 0xffff);
	else
		seq_printf(f, "%04x", usage & 0xffff);
	return buf;
}
EXPORT_SYMBOL_GPL(hid_resolv_usage);

static void tab(int n, struct seq_file *f) {
	seq_printf(f, "%*s", n, "");
}

void hid_dump_field(struct hid_field *field, int n, struct seq_file *f) {
	int j;

	if (field->physical) {
		tab(n, f);
		seq_printf(f, "Physical(");
		hid_resolv_usage(field->physical, f); seq_printf(f, ")\n");
	}
	if (field->logical) {
		tab(n, f);
		seq_printf(f, "Logical(");
		hid_resolv_usage(field->logical, f); seq_printf(f, ")\n");
	}
	if (field->application) {
		tab(n, f);
		seq_printf(f, "Application(");
		hid_resolv_usage(field->application, f); seq_printf(f, ")\n");
	}
	tab(n, f); seq_printf(f, "Usage(%d)\n", field->maxusage);
	for (j = 0; j < field->maxusage; j++) {
		tab(n+2, f); hid_resolv_usage(field->usage[j].hid, f); seq_printf(f, "\n");
	}
	if (field->logical_minimum != field->logical_maximum) {
		tab(n, f); seq_printf(f, "Logical Minimum(%d)\n", field->logical_minimum);
		tab(n, f); seq_printf(f, "Logical Maximum(%d)\n", field->logical_maximum);
	}
	if (field->physical_minimum != field->physical_maximum) {
		tab(n, f); seq_printf(f, "Physical Minimum(%d)\n", field->physical_minimum);
		tab(n, f); seq_printf(f, "Physical Maximum(%d)\n", field->physical_maximum);
	}
	if (field->unit_exponent) {
		tab(n, f); seq_printf(f, "Unit Exponent(%d)\n", field->unit_exponent);
	}
	if (field->unit) {
		static const char *systems[5] = { "None", "SI Linear", "SI Rotation", "English Linear", "English Rotation" };
		static const char *units[5][8] = {
			{ "None", "None", "None", "None", "None", "None", "None", "None" },
			{ "None", "Centimeter", "Gram", "Seconds", "Kelvin",     "Ampere", "Candela", "None" },
			{ "None", "Radians",    "Gram", "Seconds", "Kelvin",     "Ampere", "Candela", "None" },
			{ "None", "Inch",       "Slug", "Seconds", "Fahrenheit", "Ampere", "Candela", "None" },
			{ "None", "Degrees",    "Slug", "Seconds", "Fahrenheit", "Ampere", "Candela", "None" }
		};

		int i;
		int sys;
                __u32 data = field->unit;

		/* First nibble tells us which system we're in. */
		sys = data & 0xf;
		data >>= 4;

		if(sys > 4) {
			tab(n, f); seq_printf(f, "Unit(Invalid)\n");
		}
		else {
			int earlier_unit = 0;

			tab(n, f); seq_printf(f, "Unit(%s : ", systems[sys]);

			for (i=1 ; i<sizeof(__u32)*2 ; i++) {
				char nibble = data & 0xf;
				data >>= 4;
				if (nibble != 0) {
					if(earlier_unit++ > 0)
						seq_printf(f, "*");
					seq_printf(f, "%s", units[sys][i]);
					if(nibble != 1) {
						/* This is a _signed_ nibble(!) */

						int val = nibble & 0x7;
						if(nibble & 0x08)
							val = -((0x7 & ~val) +1);
						seq_printf(f, "^%d", val);
					}
				}
			}
			seq_printf(f, ")\n");
		}
	}
	tab(n, f); seq_printf(f, "Report Size(%u)\n", field->report_size);
	tab(n, f); seq_printf(f, "Report Count(%u)\n", field->report_count);
	tab(n, f); seq_printf(f, "Report Offset(%u)\n", field->report_offset);

	tab(n, f); seq_printf(f, "Flags( ");
	j = field->flags;
	seq_printf(f, "%s", HID_MAIN_ITEM_CONSTANT & j ? "Constant " : "");
	seq_printf(f, "%s", HID_MAIN_ITEM_VARIABLE & j ? "Variable " : "Array ");
	seq_printf(f, "%s", HID_MAIN_ITEM_RELATIVE & j ? "Relative " : "Absolute ");
	seq_printf(f, "%s", HID_MAIN_ITEM_WRAP & j ? "Wrap " : "");
	seq_printf(f, "%s", HID_MAIN_ITEM_NONLINEAR & j ? "NonLinear " : "");
	seq_printf(f, "%s", HID_MAIN_ITEM_NO_PREFERRED & j ? "NoPreferredState " : "");
	seq_printf(f, "%s", HID_MAIN_ITEM_NULL_STATE & j ? "NullState " : "");
	seq_printf(f, "%s", HID_MAIN_ITEM_VOLATILE & j ? "Volatile " : "");
	seq_printf(f, "%s", HID_MAIN_ITEM_BUFFERED_BYTE & j ? "BufferedByte " : "");
	seq_printf(f, ")\n");
}
EXPORT_SYMBOL_GPL(hid_dump_field);

void hid_dump_device(struct hid_device *device, struct seq_file *f)
{
	struct hid_report_enum *report_enum;
	struct hid_report *report;
	struct list_head *list;
	unsigned i,k;
	static const char *table[] = {"INPUT", "OUTPUT", "FEATURE"};

	for (i = 0; i < HID_REPORT_TYPES; i++) {
		report_enum = device->report_enum + i;
		list = report_enum->report_list.next;
		while (list != &report_enum->report_list) {
			report = (struct hid_report *) list;
			tab(2, f);
			seq_printf(f, "%s", table[i]);
			if (report->id)
				seq_printf(f, "(%d)", report->id);
			seq_printf(f, "[%s]", table[report->type]);
			seq_printf(f, "\n");
			for (k = 0; k < report->maxfield; k++) {
				tab(4, f);
				seq_printf(f, "Field(%d)\n", k);
				hid_dump_field(report->field[k], 6, f);
			}
			list = list->next;
		}
	}
}
EXPORT_SYMBOL_GPL(hid_dump_device);

/* enqueue string to 'events' ring buffer */
void hid_debug_event(struct hid_device *hdev, char *buf)
{
	struct hid_debug_list *list;
	unsigned long flags;

	spin_lock_irqsave(&hdev->debug_list_lock, flags);
	list_for_each_entry(list, &hdev->debug_list, node)
		kfifo_in(&list->hid_debug_fifo, buf, strlen(buf));
	spin_unlock_irqrestore(&hdev->debug_list_lock, flags);

	wake_up_interruptible(&hdev->debug_wait);
}
EXPORT_SYMBOL_GPL(hid_debug_event);

void hid_dump_report(struct hid_device *hid, int type, u8 *data,
		int size)
{
	struct hid_report_enum *report_enum;
	char *buf;
	unsigned int i;

	buf = kmalloc(HID_DEBUG_BUFSIZE, GFP_ATOMIC);

	if (!buf)
		return;

	report_enum = hid->report_enum + type;

	/* dump the report */
	snprintf(buf, HID_DEBUG_BUFSIZE - 1,
			"\nreport (size %u) (%snumbered) = ", size,
			report_enum->numbered ? "" : "un");
	hid_debug_event(hid, buf);

	for (i = 0; i < size; i++) {
		snprintf(buf, HID_DEBUG_BUFSIZE - 1,
				" %02x", data[i]);
		hid_debug_event(hid, buf);
	}
	hid_debug_event(hid, "\n");
	kfree(buf);
}
EXPORT_SYMBOL_GPL(hid_dump_report);

void hid_dump_input(struct hid_device *hdev, struct hid_usage *usage, __s32 value)
{
	char *buf;
	int len;

	buf = hid_resolv_usage(usage->hid, NULL);
	if (!buf)
		return;
	len = strlen(buf);
	snprintf(buf + len, HID_DEBUG_BUFSIZE - len - 1, " = %d\n", value);

	hid_debug_event(hdev, buf);

	kfree(buf);
	wake_up_interruptible(&hdev->debug_wait);
}
EXPORT_SYMBOL_GPL(hid_dump_input);

static const char *events[EV_MAX + 1] = {
	[EV_SYN] = "Sync",			[EV_KEY] = "Key",
	[EV_REL] = "Relative",			[EV_ABS] = "Absolute",
	[EV_MSC] = "Misc",			[EV_LED] = "LED",
	[EV_SND] = "Sound",			[EV_REP] = "Repeat",
	[EV_FF] = "ForceFeedback",		[EV_PWR] = "Power",
	[EV_FF_STATUS] = "ForceFeedbackStatus",	[EV_SW]  = "Software",
};

static const char *syncs[SYN_CNT] = {
	[SYN_REPORT] = "Report",		[SYN_CONFIG] = "Config",
	[SYN_MT_REPORT] = "MT Report",		[SYN_DROPPED] = "Dropped",
};

static const char *keys[KEY_MAX + 1] = {
	[KEY_RESERVED] = "Reserved",		[KEY_ESC] = "Esc",
	[KEY_1] = "1",				[KEY_2] = "2",
	[KEY_3] = "3",				[KEY_4] = "4",
	[KEY_5] = "5",				[KEY_6] = "6",
	[KEY_7] = "7",				[KEY_8] = "8",
	[KEY_9] = "9",				[KEY_0] = "0",
	[KEY_MINUS] = "Minus",			[KEY_EQUAL] = "Equal",
	[KEY_BACKSPACE] = "Backspace",		[KEY_TAB] = "Tab",
	[KEY_Q] = "Q",				[KEY_W] = "W",
	[KEY_E] = "E",				[KEY_R] = "R",
	[KEY_T] = "T",				[KEY_Y] = "Y",
	[KEY_U] = "U",				[KEY_I] = "I",
	[KEY_O] = "O",				[KEY_P] = "P",
	[KEY_LEFTBRACE] = "LeftBrace",		[KEY_RIGHTBRACE] = "RightBrace",
	[KEY_ENTER] = "Enter",			[KEY_LEFTCTRL] = "LeftControl",
	[KEY_A] = "A",				[KEY_S] = "S",
	[KEY_D] = "D",				[KEY_F] = "F",
	[KEY_G] = "G",				[KEY_H] = "H",
	[KEY_J] = "J",				[KEY_K] = "K",
	[KEY_L] = "L",				[KEY_SEMICOLON] = "Semicolon",
	[KEY_APOSTROPHE] = "Apostrophe",	[KEY_GRAVE] = "Grave",
	[KEY_LEFTSHIFT] = "LeftShift",		[KEY_BACKSLASH] = "BackSlash",
	[KEY_Z] = "Z",				[KEY_X] = "X",
	[KEY_C] = "C",				[KEY_V] = "V",
	[KEY_B] = "B",				[KEY_N] = "N",
	[KEY_M] = "M",				[KEY_COMMA] = "Comma",
	[KEY_DOT] = "Dot",			[KEY_SLASH] = "Slash",
	[KEY_RIGHTSHIFT] = "RightShift",	[KEY_KPASTERISK] = "KPAsterisk",
	[KEY_LEFTALT] = "LeftAlt",		[KEY_SPACE] = "Space",
	[KEY_CAPSLOCK] = "CapsLock",		[KEY_F1] = "F1",
	[KEY_F2] = "F2",			[KEY_F3] = "F3",
	[KEY_F4] = "F4",			[KEY_F5] = "F5",
	[KEY_F6] = "F6",			[KEY_F7] = "F7",
	[KEY_F8] = "F8",			[KEY_F9] = "F9",
	[KEY_F10] = "F10",			[KEY_NUMLOCK] = "NumLock",
	[KEY_SCROLLLOCK] = "ScrollLock",	[KEY_KP7] = "KP7",
	[KEY_KP8] = "KP8",			[KEY_KP9] = "KP9",
	[KEY_KPMINUS] = "KPMinus",		[KEY_KP4] = "KP4",
	[KEY_KP5] = "KP5",			[KEY_KP6] = "KP6",
	[KEY_KPPLUS] = "KPPlus",		[KEY_KP1] = "KP1",
	[KEY_KP2] = "KP2",			[KEY_KP3] = "KP3",
	[KEY_KP0] = "KP0",			[KEY_KPDOT] = "KPDot",
	[KEY_ZENKAKUHANKAKU] = "Zenkaku/Hankaku", [KEY_102ND] = "102nd",
	[KEY_F11] = "F11",			[KEY_F12] = "F12",
	[KEY_RO] = "RO",			[KEY_KATAKANA] = "Katakana",
	[KEY_HIRAGANA] = "HIRAGANA",		[KEY_HENKAN] = "Henkan",
	[KEY_KATAKANAHIRAGANA] = "Katakana/Hiragana", [KEY_MUHENKAN] = "Muhenkan",
	[KEY_KPJPCOMMA] = "KPJpComma",		[KEY_KPENTER] = "KPEnter",
	[KEY_RIGHTCTRL] = "RightCtrl",		[KEY_KPSLASH] = "KPSlash",
	[KEY_SYSRQ] = "SysRq",			[KEY_RIGHTALT] = "RightAlt",
	[KEY_LINEFEED] = "LineFeed",		[KEY_HOME] = "Home",
	[KEY_UP] = "Up",			[KEY_PAGEUP] = "PageUp",
	[KEY_LEFT] = "Left",			[KEY_RIGHT] = "Right",
	[KEY_END] = "End",			[KEY_DOWN] = "Down",
	[KEY_PAGEDOWN] = "PageDown",		[KEY_INSERT] = "Insert",
	[KEY_DELETE] = "Delete",		[KEY_MACRO] = "Macro",
	[KEY_MUTE] = "Mute",			[KEY_VOLUMEDOWN] = "VolumeDown",
	[KEY_VOLUMEUP] = "VolumeUp",		[KEY_POWER] = "Power",
	[KEY_KPEQUAL] = "KPEqual",		[KEY_KPPLUSMINUS] = "KPPlusMinus",
	[KEY_PAUSE] = "Pause",			[KEY_KPCOMMA] = "KPComma",
	[KEY_HANGUEL] = "Hangeul",		[KEY_HANJA] = "Hanja",
	[KEY_YEN] = "Yen",			[KEY_LEFTMETA] = "LeftMeta",
	[KEY_RIGHTMETA] = "RightMeta",		[KEY_COMPOSE] = "Compose",
	[KEY_STOP] = "Stop",			[KEY_AGAIN] = "Again",
	[KEY_PROPS] = "Props",			[KEY_UNDO] = "Undo",
	[KEY_FRONT] = "Front",			[KEY_COPY] = "Copy",
	[KEY_OPEN] = "Open",			[KEY_PASTE] = "Paste",
	[KEY_FIND] = "Find",			[KEY_CUT] = "Cut",
	[KEY_HELP] = "Help",			[KEY_MENU] = "Menu",
	[KEY_CALC] = "Calc",			[KEY_SETUP] = "Setup",
	[KEY_SLEEP] = "Sleep",			[KEY_WAKEUP] = "WakeUp",
	[KEY_FILE] = "File",			[KEY_SENDFILE] = "SendFile",
	[KEY_DELETEFILE] = "DeleteFile",	[KEY_XFER] = "X-fer",
	[KEY_PROG1] = "Prog1",			[KEY_PROG2] = "Prog2",
	[KEY_WWW] = "WWW",			[KEY_MSDOS] = "MSDOS",
	[KEY_COFFEE] = "Coffee",		[KEY_ROTATE_DISPLAY] = "RotateDisplay",
	[KEY_CYCLEWINDOWS] = "CycleWindows",	[KEY_MAIL] = "Mail",
	[KEY_BOOKMARKS] = "Bookmarks",		[KEY_COMPUTER] = "Computer",
	[KEY_BACK] = "Back",			[KEY_FORWARD] = "Forward",
	[KEY_CLOSECD] = "CloseCD",		[KEY_EJECTCD] = "EjectCD",
	[KEY_EJECTCLOSECD] = "EjectCloseCD",	[KEY_NEXTSONG] = "NextSong",
	[KEY_PLAYPAUSE] = "PlayPause",		[KEY_PREVIOUSSONG] = "PreviousSong",
	[KEY_STOPCD] = "StopCD",		[KEY_RECORD] = "Record",
	[KEY_REWIND] = "Rewind",		[KEY_PHONE] = "Phone",
	[KEY_ISO] = "ISOKey",			[KEY_CONFIG] = "Config",
	[KEY_HOMEPAGE] = "HomePage",		[KEY_REFRESH] = "Refresh",
	[KEY_EXIT] = "Exit",			[KEY_MOVE] = "Move",
	[KEY_EDIT] = "Edit",			[KEY_SCROLLUP] = "ScrollUp",
	[KEY_SCROLLDOWN] = "ScrollDown",	[KEY_KPLEFTPAREN] = "KPLeftParenthesis",
	[KEY_KPRIGHTPAREN] = "KPRightParenthesis", [KEY_NEW] = "New",
	[KEY_REDO] = "Redo",			[KEY_F13] = "F13",
	[KEY_F14] = "F14",			[KEY_F15] = "F15",
	[KEY_F16] = "F16",			[KEY_F17] = "F17",
	[KEY_F18] = "F18",			[KEY_F19] = "F19",
	[KEY_F20] = "F20",			[KEY_F21] = "F21",
	[KEY_F22] = "F22",			[KEY_F23] = "F23",
	[KEY_F24] = "F24",			[KEY_PLAYCD] = "PlayCD",
	[KEY_PAUSECD] = "PauseCD",		[KEY_PROG3] = "Prog3",
	[KEY_PROG4] = "Prog4",
	[KEY_ALL_APPLICATIONS] = "AllApplications",
	[KEY_SUSPEND] = "Suspend",
	[KEY_CLOSE] = "Close",			[KEY_PLAY] = "Play",
	[KEY_FASTFORWARD] = "FastForward",	[KEY_BASSBOOST] = "BassBoost",
	[KEY_PRINT] = "Print",			[KEY_HP] = "HP",
	[KEY_CAMERA] = "Camera",		[KEY_SOUND] = "Sound",
	[KEY_QUESTION] = "Question",		[KEY_EMAIL] = "Email",
	[KEY_CHAT] = "Chat",			[KEY_SEARCH] = "Search",
	[KEY_CONNECT] = "Connect",		[KEY_FINANCE] = "Finance",
	[KEY_SPORT] = "Sport",			[KEY_SHOP] = "Shop",
	[KEY_ALTERASE] = "AlternateErase",	[KEY_CANCEL] = "Cancel",
	[KEY_BRIGHTNESSDOWN] = "BrightnessDown", [KEY_BRIGHTNESSUP] = "BrightnessUp",
	[KEY_MEDIA] = "Media",			[KEY_UNKNOWN] = "Unknown",
	[BTN_DPAD_UP] = "BtnDPadUp",		[BTN_DPAD_DOWN] = "BtnDPadDown",
	[BTN_DPAD_LEFT] = "BtnDPadLeft",	[BTN_DPAD_RIGHT] = "BtnDPadRight",
	[BTN_0] = "Btn0",			[BTN_1] = "Btn1",
	[BTN_2] = "Btn2",			[BTN_3] = "Btn3",
	[BTN_4] = "Btn4",			[BTN_5] = "Btn5",
	[BTN_6] = "Btn6",			[BTN_7] = "Btn7",
	[BTN_8] = "Btn8",			[BTN_9] = "Btn9",
	[BTN_LEFT] = "LeftBtn",			[BTN_RIGHT] = "RightBtn",
	[BTN_MIDDLE] = "MiddleBtn",		[BTN_SIDE] = "SideBtn",
	[BTN_EXTRA] = "ExtraBtn",		[BTN_FORWARD] = "ForwardBtn",
	[BTN_BACK] = "BackBtn",			[BTN_TASK] = "TaskBtn",
	[BTN_TRIGGER] = "Trigger",		[BTN_THUMB] = "ThumbBtn",
	[BTN_THUMB2] = "ThumbBtn2",		[BTN_TOP] = "TopBtn",
	[BTN_TOP2] = "TopBtn2",			[BTN_PINKIE] = "PinkieBtn",
	[BTN_BASE] = "BaseBtn",			[BTN_BASE2] = "BaseBtn2",
	[BTN_BASE3] = "BaseBtn3",		[BTN_BASE4] = "BaseBtn4",
	[BTN_BASE5] = "BaseBtn5",		[BTN_BASE6] = "BaseBtn6",
	[BTN_DEAD] = "BtnDead",			[BTN_A] = "BtnA",
	[BTN_B] = "BtnB",			[BTN_C] = "BtnC",
	[BTN_X] = "BtnX",			[BTN_Y] = "BtnY",
	[BTN_Z] = "BtnZ",			[BTN_TL] = "BtnTL",
	[BTN_TR] = "BtnTR",			[BTN_TL2] = "BtnTL2",
	[BTN_TR2] = "BtnTR2",			[BTN_SELECT] = "BtnSelect",
	[BTN_START] = "BtnStart",		[BTN_MODE] = "BtnMode",
	[BTN_THUMBL] = "BtnThumbL",		[BTN_THUMBR] = "BtnThumbR",
	[BTN_GRIPL] = "BtnGripL",		[BTN_GRIPR] = "BtnGripR",
	[BTN_GRIPL2] = "BtnGripL2",		[BTN_GRIPR2] = "BtnGripR2",
	[BTN_TOOL_PEN] = "ToolPen",		[BTN_TOOL_RUBBER] = "ToolRubber",
	[BTN_TOOL_BRUSH] = "ToolBrush",		[BTN_TOOL_PENCIL] = "ToolPencil",
	[BTN_TOOL_AIRBRUSH] = "ToolAirbrush",	[BTN_TOOL_FINGER] = "ToolFinger",
	[BTN_TOOL_MOUSE] = "ToolMouse",		[BTN_TOOL_LENS] = "ToolLens",
	[BTN_TOUCH] = "Touch",			[BTN_STYLUS] = "Stylus",
	[BTN_STYLUS2] = "Stylus2",		[BTN_TOOL_DOUBLETAP] = "ToolDoubleTap",
	[BTN_TOOL_TRIPLETAP] = "ToolTripleTap",	[BTN_TOOL_QUADTAP] = "ToolQuadrupleTap",
	[BTN_GEAR_DOWN] = "BtnGearDown",	[BTN_GEAR_UP] = "BtnGearUp",
						[KEY_OK] = "Ok",
	[KEY_SELECT] = "Select",		[KEY_GOTO] = "Goto",
	[KEY_CLEAR] = "Clear",			[KEY_POWER2] = "Power2",
	[KEY_OPTION] = "Option",		[KEY_INFO] = "Info",
	[KEY_TIME] = "Time",			[KEY_VENDOR] = "Vendor",
	[KEY_ARCHIVE] = "Archive",		[KEY_PROGRAM] = "Program",
	[KEY_CHANNEL] = "Channel",		[KEY_FAVORITES] = "Favorites",
	[KEY_EPG] = "EPG",			[KEY_PVR] = "PVR",
	[KEY_MHP] = "MHP",			[KEY_LANGUAGE] = "Language",
	[KEY_TITLE] = "Title",			[KEY_SUBTITLE] = "Subtitle",
	[KEY_ANGLE] = "Angle",
	[KEY_MODE] = "Mode",			[KEY_KEYBOARD] = "Keyboard",
	[KEY_PC] = "PC",
	[KEY_TV] = "TV",			[KEY_TV2] = "TV2",
	[KEY_VCR] = "VCR",			[KEY_VCR2] = "VCR2",
	[KEY_SAT] = "Sat",			[KEY_SAT2] = "Sat2",
	[KEY_CD] = "CD",			[KEY_TAPE] = "Tape",
	[KEY_RADIO] = "Radio",			[KEY_TUNER] = "Tuner",
	[KEY_PLAYER] = "Player",		[KEY_TEXT] = "Text",
	[KEY_DVD] = "DVD",			[KEY_AUX] = "Aux",
	[KEY_MP3] = "MP3",			[KEY_AUDIO] = "Audio",
	[KEY_VIDEO] = "Video",			[KEY_DIRECTORY] = "Directory",
	[KEY_LIST] = "List",			[KEY_MEMO] = "Memo",
	[KEY_CALENDAR] = "Calendar",		[KEY_RED] = "Red",
	[KEY_GREEN] = "Green",			[KEY_YELLOW] = "Yellow",
	[KEY_BLUE] = "Blue",			[KEY_CHANNELUP] = "ChannelUp",
	[KEY_CHANNELDOWN] = "ChannelDown",	[KEY_FIRST] = "First",
	[KEY_LAST] = "Last",			[KEY_AB] = "AB",
	[KEY_NEXT] = "Next",			[KEY_RESTART] = "Restart",
	[KEY_SLOW] = "Slow",			[KEY_SHUFFLE] = "Shuffle",
	[KEY_BREAK] = "Break",			[KEY_PREVIOUS] = "Previous",
	[KEY_DIGITS] = "Digits",		[KEY_TEEN] = "TEEN",
	[KEY_TWEN] = "TWEN",			[KEY_DEL_EOL] = "DeleteEOL",
	[KEY_DEL_EOS] = "DeleteEOS",		[KEY_INS_LINE] = "InsertLine",
	[KEY_DEL_LINE] = "DeleteLine",
	[KEY_SEND] = "Send",			[KEY_REPLY] = "Reply",
	[KEY_FORWARDMAIL] = "ForwardMail",	[KEY_SAVE] = "Save",
	[KEY_DOCUMENTS] = "Documents",		[KEY_SPELLCHECK] = "SpellCheck",
	[KEY_LOGOFF] = "Logoff",
	[KEY_FN] = "Fn",			[KEY_FN_ESC] = "Fn+ESC",
	[KEY_FN_1] = "Fn+1",			[KEY_FN_2] = "Fn+2",
	[KEY_FN_B] = "Fn+B",			[KEY_FN_D] = "Fn+D",
	[KEY_FN_E] = "Fn+E",			[KEY_FN_F] = "Fn+F",
	[KEY_FN_S] = "Fn+S",
	[KEY_FN_F1] = "Fn+F1",			[KEY_FN_F2] = "Fn+F2",
	[KEY_FN_F3] = "Fn+F3",			[KEY_FN_F4] = "Fn+F4",
	[KEY_FN_F5] = "Fn+F5",			[KEY_FN_F6] = "Fn+F6",
	[KEY_FN_F7] = "Fn+F7",			[KEY_FN_F8] = "Fn+F8",
	[KEY_FN_F9] = "Fn+F9",			[KEY_FN_F10] = "Fn+F10",
	[KEY_FN_F11] = "Fn+F11",		[KEY_FN_F12] = "Fn+F12",
	[KEY_KBDILLUMTOGGLE] = "KbdIlluminationToggle",
	[KEY_KBDILLUMDOWN] = "KbdIlluminationDown",
	[KEY_KBDILLUMUP] = "KbdIlluminationUp",
	[KEY_SWITCHVIDEOMODE] = "SwitchVideoMode",
	[KEY_BUTTONCONFIG] = "ButtonConfig",
	[KEY_TASKMANAGER] = "TaskManager",
	[KEY_JOURNAL] = "Journal",
	[KEY_CONTROLPANEL] = "ControlPanel",
	[KEY_APPSELECT] = "AppSelect",
	[KEY_SCREENSAVER] = "ScreenSaver",
	[KEY_VOICECOMMAND] = "VoiceCommand",
	[KEY_ASSISTANT] = "Assistant",
	[KEY_KBD_LAYOUT_NEXT] = "KbdLayoutNext",
	[KEY_EMOJI_PICKER] = "EmojiPicker",
	[KEY_CAMERA_ACCESS_ENABLE] = "CameraAccessEnable",
	[KEY_CAMERA_ACCESS_DISABLE] = "CameraAccessDisable",
	[KEY_CAMERA_ACCESS_TOGGLE] = "CameraAccessToggle",
	[KEY_ACCESSIBILITY] = "Accessibility",
	[KEY_DO_NOT_DISTURB] = "DoNotDisturb",
	[KEY_DICTATE] = "Dictate",
	[KEY_MICMUTE] = "MicrophoneMute",
	[KEY_BRIGHTNESS_MIN] = "BrightnessMin",
	[KEY_BRIGHTNESS_MAX] = "BrightnessMax",
	[KEY_BRIGHTNESS_AUTO] = "BrightnessAuto",
	[KEY_KBDINPUTASSIST_PREV] = "KbdInputAssistPrev",
	[KEY_KBDINPUTASSIST_NEXT] = "KbdInputAssistNext",
	[KEY_KBDINPUTASSIST_PREVGROUP] = "KbdInputAssistPrevGroup",
	[KEY_KBDINPUTASSIST_NEXTGROUP] = "KbdInputAssistNextGroup",
	[KEY_KBDINPUTASSIST_ACCEPT] = "KbdInputAssistAccept",
	[KEY_KBDINPUTASSIST_CANCEL] = "KbdInputAssistCancel",
	[KEY_MACRO1] = "Macro1", [KEY_MACRO2] = "Macro2", [KEY_MACRO3] = "Macro3",
	[KEY_MACRO4] = "Macro4", [KEY_MACRO5] = "Macro5", [KEY_MACRO6] = "Macro6",
	[KEY_MACRO7] = "Macro7", [KEY_MACRO8] = "Macro8", [KEY_MACRO9] = "Macro9",
	[KEY_MACRO10] = "Macro10", [KEY_MACRO11] = "Macro11", [KEY_MACRO12] = "Macro12",
	[KEY_MACRO13] = "Macro13", [KEY_MACRO14] = "Macro14", [KEY_MACRO15] = "Macro15",
	[KEY_MACRO16] = "Macro16", [KEY_MACRO17] = "Macro17", [KEY_MACRO18] = "Macro18",
	[KEY_MACRO19] = "Macro19", [KEY_MACRO20] = "Macro20", [KEY_MACRO21] = "Macro21",
	[KEY_MACRO22] = "Macro22", [KEY_MACRO23] = "Macro23", [KEY_MACRO24] = "Macro24",
	[KEY_MACRO25] = "Macro25", [KEY_MACRO26] = "Macro26", [KEY_MACRO27] = "Macro27",
	[KEY_MACRO28] = "Macro28", [KEY_MACRO29] = "Macro29", [KEY_MACRO30] = "Macro30",
	[BTN_TRIGGER_HAPPY1] = "TriggerHappy1", [BTN_TRIGGER_HAPPY2] = "TriggerHappy2",
	[BTN_TRIGGER_HAPPY3] = "TriggerHappy3", [BTN_TRIGGER_HAPPY4] = "TriggerHappy4",
	[BTN_TRIGGER_HAPPY5] = "TriggerHappy5", [BTN_TRIGGER_HAPPY6] = "TriggerHappy6",
	[BTN_TRIGGER_HAPPY7] = "TriggerHappy7", [BTN_TRIGGER_HAPPY8] = "TriggerHappy8",
	[BTN_TRIGGER_HAPPY9] = "TriggerHappy9", [BTN_TRIGGER_HAPPY10] = "TriggerHappy10",
	[BTN_TRIGGER_HAPPY11] = "TriggerHappy11", [BTN_TRIGGER_HAPPY12] = "TriggerHappy12",
	[BTN_TRIGGER_HAPPY13] = "TriggerHappy13", [BTN_TRIGGER_HAPPY14] = "TriggerHappy14",
	[BTN_TRIGGER_HAPPY15] = "TriggerHappy15", [BTN_TRIGGER_HAPPY16] = "TriggerHappy16",
	[BTN_TRIGGER_HAPPY17] = "TriggerHappy17", [BTN_TRIGGER_HAPPY18] = "TriggerHappy18",
	[BTN_TRIGGER_HAPPY19] = "TriggerHappy19", [BTN_TRIGGER_HAPPY20] = "TriggerHappy20",
	[BTN_TRIGGER_HAPPY21] = "TriggerHappy21", [BTN_TRIGGER_HAPPY22] = "TriggerHappy22",
	[BTN_TRIGGER_HAPPY23] = "TriggerHappy23", [BTN_TRIGGER_HAPPY24] = "TriggerHappy24",
	[BTN_TRIGGER_HAPPY25] = "TriggerHappy25", [BTN_TRIGGER_HAPPY26] = "TriggerHappy26",
	[BTN_TRIGGER_HAPPY27] = "TriggerHappy27", [BTN_TRIGGER_HAPPY28] = "TriggerHappy28",
	[BTN_TRIGGER_HAPPY29] = "TriggerHappy29", [BTN_TRIGGER_HAPPY30] = "TriggerHappy30",
	[BTN_TRIGGER_HAPPY31] = "TriggerHappy31", [BTN_TRIGGER_HAPPY32] = "TriggerHappy32",
	[BTN_TRIGGER_HAPPY33] = "TriggerHappy33", [BTN_TRIGGER_HAPPY34] = "TriggerHappy34",
	[BTN_TRIGGER_HAPPY35] = "TriggerHappy35", [BTN_TRIGGER_HAPPY36] = "TriggerHappy36",
	[BTN_TRIGGER_HAPPY37] = "TriggerHappy37", [BTN_TRIGGER_HAPPY38] = "TriggerHappy38",
	[BTN_TRIGGER_HAPPY39] = "TriggerHappy39", [BTN_TRIGGER_HAPPY40] = "TriggerHappy40",
	[BTN_STYLUS3] = "Stylus3",		 [BTN_TOOL_QUINTTAP] = "ToolQuintTap",
	[KEY_10CHANNELSDOWN] = "10ChannelsDown",
	[KEY_10CHANNELSUP] = "10ChannelsUp",
	[KEY_3D_MODE] = "3DMode",		[KEY_ADDRESSBOOK] = "Addressbook",
	[KEY_ALS_TOGGLE] = "ALSToggle",		[KEY_ASPECT_RATIO] = "AspectRatio",
	[KEY_ATTENDANT_OFF] = "AttendantOff",	[KEY_ATTENDANT_ON] = "AttendantOn",
	[KEY_ATTENDANT_TOGGLE] = "AttendantToggle",
	[KEY_AUDIO_DESC] = "AudioDesc",
	[KEY_AUTOPILOT_ENGAGE_TOGGLE] = "AutoPiloteEngage",
	[KEY_BATTERY] = "Battery",		[KEY_BLUETOOTH] = "BlueTooth",
	[KEY_BRIGHTNESS_CYCLE] = "BrightnessCycle",
	[KEY_BRIGHTNESS_MENU] = "BrightnessMenu",
	[KEY_BRL_DOT1] = "BrlDot1",		[KEY_BRL_DOT10] = "BrlDot10",
	[KEY_BRL_DOT2] = "BrlDot2",		[KEY_BRL_DOT3] = "BrlDot3",
	[KEY_BRL_DOT4] = "BrlDot4",		[KEY_BRL_DOT5] = "BrlDot5",
	[KEY_BRL_DOT6] = "BrlDot6",		[KEY_BRL_DOT7] = "BrlDot7",
	[KEY_BRL_DOT8] = "BrlDot8",		[KEY_BRL_DOT9] = "BrlDot9",
	[KEY_CAMERA_DOWN] = "CameraDown",	[KEY_CAMERA_FOCUS] = "CameraFocus",
	[KEY_CAMERA_LEFT] = "CameraLeft",	[KEY_CAMERA_RIGHT] = "CameraRight",
	[KEY_CAMERA_UP] = "CameraUp",		[KEY_CAMERA_ZOOMIN] = "CameraZoomIn",
	[KEY_CAMERA_ZOOMOUT] = "CameraZoomOut",	[KEY_CLEARVU_SONAR] = "ClearVUSonar",
	[KEY_CONTEXT_MENU] = "ContextMenu",	[KEY_DATA] = "Data",
	[KEY_DATABASE] = "DataBase",		[KEY_DISPLAY_OFF] = "DisplayOff",
	[KEY_DISPLAYTOGGLE] = "DisplayToggle",	[KEY_DOLLAR] = "Dollar",
	[KEY_DUAL_RANGE_RADAR] = "DualRangeRadat",
	[KEY_EDITOR] = "Editor",		[KEY_EURO] = "Euro",
	[KEY_FASTREVERSE] = "FastReverse",	[KEY_FISHING_CHART] = "FishingChart",
	[KEY_FN_RIGHT_SHIFT] = "FnRightShift",	[KEY_FRAMEBACK] = "FrameBack",
	[KEY_FRAMEFORWARD] = "FrameForward",	[KEY_FULL_SCREEN] = "FullScreen",
	[KEY_GAMES] = "Games",			[KEY_GRAPHICSEDITOR] = "GraphicsEditor",
	[KEY_HANGUP_PHONE] = "HangUpPhone",
	[KEY_IMAGES] = "Images",		[KEY_KBD_LCD_MENU1] = "KbdLcdMenu1",
	[KEY_KBD_LCD_MENU2] = "KbdLcdMenu2",	[KEY_KBD_LCD_MENU3] = "KbdLcdMenu3",
	[KEY_KBD_LCD_MENU4] = "KbdLcdMenu4",	[KEY_KBD_LCD_MENU5] = "KbdLcdMenu5",
	[KEY_LEFT_DOWN] = "LeftDown",		[KEY_LEFT_UP] = "LeftUp",
	[KEY_LIGHTS_TOGGLE] = "LightToggle",	[KEY_MACRO_PRESET1] = "MacroPreset1",
	[KEY_MACRO_PRESET2] = "MacroPreset2",	[KEY_MACRO_PRESET3] = "MacroPrest3",
	[KEY_MACRO_PRESET_CYCLE] = "MacroPresetCycle",
	[KEY_MACRO_RECORD_START] = "MacroRecordStart",
	[KEY_MACRO_RECORD_STOP] = "MacroRecordStop",
	[KEY_MARK_WAYPOINT] = "MarkWayPoint",	[KEY_MEDIA_REPEAT] = "MediaRepeat",
	[KEY_MEDIA_TOP_MENU] = "MediaTopMenu",	[KEY_MESSENGER] = "Messenger",
	[KEY_NAV_CHART] = "NavChar",		[KEY_NAV_INFO] = "NavInfo",
	[KEY_NEWS] = "News",			[KEY_NEXT_ELEMENT] = "NextElement",
	[KEY_NEXT_FAVORITE] = "NextFavorite",	[KEY_NOTIFICATION_CENTER] = "NotificationCenter",
	[KEY_NUMERIC_0] = "Numeric0",		[KEY_NUMERIC_1] = "Numeric1",
	[KEY_NUMERIC_11] = "Numceric11",	[KEY_NUMERIC_12] = "Numeric12",
	[KEY_NUMERIC_2] = "Numeric2",		[KEY_NUMERIC_3] = "Numeric3",
	[KEY_NUMERIC_4] = "Numeric4",		[KEY_NUMERIC_5] = "Numeric5",
	[KEY_NUMERIC_6] = "Numeric6",		[KEY_NUMERIC_7] = "Numeric7",
	[KEY_NUMERIC_8] = "Numeric8",		[KEY_NUMERIC_9] = "Numeric9",
	[KEY_NUMERIC_A] = "NumericA",		[KEY_NUMERIC_B] = "NumericB",
	[KEY_NUMERIC_C] = "NumericC",		[KEY_NUMERIC_D] = "NumericD",
	[KEY_NUMERIC_POUND] = "NumericPound",	[KEY_NUMERIC_STAR] = "NumericStar",
	[KEY_ONSCREEN_KEYBOARD] = "OnScreenKeyBoard",
	[KEY_PAUSE_RECORD] = "PauseRecord",	[KEY_PICKUP_PHONE] = "PickUpPhone",
	[KEY_PRESENTATION] = "Presentation",	[KEY_PREVIOUS_ELEMENT] = "PreviousElement",
	[KEY_PRIVACY_SCREEN_TOGGLE] = "PrivacyScreenToggle",
	[KEY_RADAR_OVERLAY] = "RadarOverLay",
	[KEY_RFKILL] = "RFKill",		[KEY_RIGHT_DOWN] = "RightDown",
	[KEY_RIGHT_UP] = "RightUp",		[KEY_ROOT_MENU] = "RootMenu",
	[KEY_ROTATE_LOCK_TOGGLE] = "RotateLockToggle",
	[KEY_SCALE] = "Scale",			[KEY_SELECTIVE_SCREENSHOT] = "SelectiveScreenshot",
	[KEY_SIDEVU_SONAR] = "SideVUSonar",	[KEY_SINGLE_RANGE_RADAR] = "SingleRangeRadar",
	[KEY_SLOWREVERSE] = "SlowReverse",	[KEY_SOS] = "SOS",
	[KEY_SPREADSHEET] = "SpreadSheet",	[KEY_STOP_RECORD] = "StopRecord",
	[KEY_TOUCHPAD_OFF] = "TouchPadOff",	[KEY_TOUCHPAD_ON] = "TouchPadOn",
	[KEY_TOUCHPAD_TOGGLE] = "TouchPadToggle",
	[KEY_TRADITIONAL_SONAR] = "TraditionalSonar",
	[KEY_UNMUTE] = "Unmute",		[KEY_UWB] = "UWB",
	[KEY_VIDEO_NEXT] = "VideoNext",		[KEY_VIDEOPHONE] = "VideoPhone",
	[KEY_VIDEO_PREV] = "VideoPrev",		[KEY_VOD] = "VOD",
	[KEY_VOICEMAIL] = "VoiceMail",		[KEY_WLAN] = "WLAN",
	[KEY_WORDPROCESSOR] = "WordProcessor",	[KEY_WPS_BUTTON] = "WPSButton",
	[KEY_WWAN] = "WWAN",			[KEY_ZOOMIN] = "ZoomIn",
	[KEY_ZOOMOUT] = "ZoomOut",		[KEY_ZOOMRESET] = "ZoomReset",
};

static const char *relatives[REL_MAX + 1] = {
	[REL_X] = "X",			[REL_Y] = "Y",
	[REL_Z] = "Z",			[REL_RX] = "Rx",
	[REL_RY] = "Ry",		[REL_RZ] = "Rz",
	[REL_HWHEEL] = "HWheel",	[REL_DIAL] = "Dial",
	[REL_WHEEL] = "Wheel",		[REL_MISC] = "Misc",
	[REL_WHEEL_HI_RES] = "WheelHiRes",
	[REL_HWHEEL_HI_RES] = "HWheelHiRes"
};

static const char *absolutes[ABS_CNT] = {
	[ABS_X] = "X",			[ABS_Y] = "Y",
	[ABS_Z] = "Z",			[ABS_RX] = "Rx",
	[ABS_RY] = "Ry",		[ABS_RZ] = "Rz",
	[ABS_THROTTLE] = "Throttle",	[ABS_RUDDER] = "Rudder",
	[ABS_WHEEL] = "Wheel",		[ABS_GAS] = "Gas",
	[ABS_BRAKE] = "Brake",		[ABS_HAT0X] = "Hat0X",
	[ABS_HAT0Y] = "Hat0Y",		[ABS_HAT1X] = "Hat1X",
	[ABS_HAT1Y] = "Hat1Y",		[ABS_HAT2X] = "Hat2X",
	[ABS_HAT2Y] = "Hat2Y",		[ABS_HAT3X] = "Hat3X",
	[ABS_HAT3Y] = "Hat 3Y",		[ABS_PRESSURE] = "Pressure",
	[ABS_DISTANCE] = "Distance",	[ABS_TILT_X] = "XTilt",
	[ABS_TILT_Y] = "YTilt",		[ABS_TOOL_WIDTH] = "ToolWidth",
	[ABS_VOLUME] = "Volume",	[ABS_PROFILE] = "Profile",
	[ABS_SND_PROFILE] = "SoundProfile",
	[ABS_MISC] = "Misc",
	[ABS_MT_SLOT] = "MTSlot",
	[ABS_MT_TOUCH_MAJOR] = "MTMajor",
	[ABS_MT_TOUCH_MINOR] = "MTMinor",
	[ABS_MT_WIDTH_MAJOR] = "MTMajorW",
	[ABS_MT_WIDTH_MINOR] = "MTMinorW",
	[ABS_MT_ORIENTATION] = "MTOrientation",
	[ABS_MT_POSITION_X] = "MTPositionX",
	[ABS_MT_POSITION_Y] = "MTPositionY",
	[ABS_MT_TOOL_TYPE] = "MTToolType",
	[ABS_MT_BLOB_ID] = "MTBlobID",
	[ABS_MT_TRACKING_ID] = "MTTrackingID",
	[ABS_MT_PRESSURE] = "MTPressure",
	[ABS_MT_DISTANCE] = "MTDistance",
	[ABS_MT_TOOL_X] = "MTToolX",
	[ABS_MT_TOOL_Y] = "MTToolY",
};

static const char *misc[MSC_MAX + 1] = {
	[MSC_SERIAL] = "Serial",	[MSC_PULSELED] = "Pulseled",
	[MSC_GESTURE] = "Gesture",	[MSC_RAW] = "RawData",
	[MSC_SCAN] = "Scan",		[MSC_TIMESTAMP] = "TimeStamp",
};

static const char *leds[LED_MAX + 1] = {
	[LED_NUML] = "NumLock",		[LED_CAPSL] = "CapsLock",
	[LED_SCROLLL] = "ScrollLock",	[LED_COMPOSE] = "Compose",
	[LED_KANA] = "Kana",		[LED_SLEEP] = "Sleep",
	[LED_SUSPEND] = "Suspend",	[LED_MUTE] = "Mute",
	[LED_MISC] = "Misc",		[LED_MAIL] = "Mail",
	[LED_CHARGING] = "Charging",
};

static const char *repeats[REP_MAX + 1] = {
	[REP_DELAY] = "Delay",		[REP_PERIOD] = "Period"
};

static const char *sounds[SND_MAX + 1] = {
	[SND_CLICK] = "Click",		[SND_BELL] = "Bell",
	[SND_TONE] = "Tone"
};

static const char *software[SW_CNT] = {
	[SW_LID] = "Lid",
	[SW_TABLET_MODE] = "TabletMode",
	[SW_HEADPHONE_INSERT] = "HeadPhoneInsert",
	[SW_RFKILL_ALL] = "RFKillAll",
	[SW_MICROPHONE_INSERT] = "MicrophoneInsert",
	[SW_DOCK] = "Dock",
	[SW_LINEOUT_INSERT] = "LineOutInsert",
	[SW_JACK_PHYSICAL_INSERT] = "JackPhysicalInsert",
	[SW_VIDEOOUT_INSERT] = "VideoOutInsert",
	[SW_CAMERA_LENS_COVER] = "CameraLensCover",
	[SW_KEYPAD_SLIDE] = "KeyPadSlide",
	[SW_FRONT_PROXIMITY] = "FrontProximity",
	[SW_ROTATE_LOCK] = "RotateLock",
	[SW_LINEIN_INSERT] = "LineInInsert",
	[SW_MUTE_DEVICE] = "MuteDevice",
	[SW_PEN_INSERTED] = "PenInserted",
	[SW_MACHINE_COVER] = "MachineCover",
};

static const char *force[FF_CNT] = {
	[FF_RUMBLE] = "FF_RUMBLE",
	[FF_PERIODIC] = "FF_PERIODIC",
	[FF_CONSTANT] = "FF_CONSTANT",
	[FF_SPRING] = "FF_SPRING",
	[FF_FRICTION] = "FF_FRICTION",
	[FF_DAMPER] = "FF_DAMPER",
	[FF_INERTIA] = "FF_INERTIA",
	[FF_RAMP] = "FF_RAMP",
	[FF_SQUARE] = "FF_SQUARE",
	[FF_TRIANGLE] = "FF_TRIANGLE",
	[FF_SINE] = "FF_SINE",
	[FF_SAW_UP] = "FF_SAW_UP",
	[FF_SAW_DOWN] = "FF_SAW_DOWN",
	[FF_CUSTOM] = "FF_CUSTOM",
	[FF_GAIN] = "FF_GAIN",
	[FF_AUTOCENTER] = "FF_AUTOCENTER",
	[FF_MAX] = "FF_MAX",
};

static const char *force_status[FF_STATUS_MAX + 1] = {
	[FF_STATUS_STOPPED] = "FF_STATUS_STOPPED",
	[FF_STATUS_PLAYING] = "FF_STATUS_PLAYING",
};

static const char **names[EV_MAX + 1] = {
	[EV_SYN] = syncs,			[EV_KEY] = keys,
	[EV_REL] = relatives,			[EV_ABS] = absolutes,
	[EV_MSC] = misc,			[EV_LED] = leds,
	[EV_SND] = sounds,			[EV_REP] = repeats,
	[EV_SW]  = software,			[EV_FF] = force,
	[EV_FF_STATUS] = force_status,
};

static void hid_resolv_event(__u8 type, __u16 code, struct seq_file *f)
{
	if (events[type])
		seq_printf(f, "%s.", events[type]);
	else
		seq_printf(f, "%02x.", type);

	if (names[type] && names[type][code])
		seq_printf(f, "%s", names[type][code]);
	else
		seq_printf(f, "%04x", code);
}

static void hid_dump_input_mapping(struct hid_device *hid, struct seq_file *f)
{
	int i, j, k;
	struct hid_report *report;
	struct hid_usage *usage;

	for (k = HID_INPUT_REPORT; k <= HID_OUTPUT_REPORT; k++) {
		list_for_each_entry(report, &hid->report_enum[k].report_list, list) {
			for (i = 0; i < report->maxfield; i++) {
				for ( j = 0; j < report->field[i]->maxusage; j++) {
					usage = report->field[i]->usage + j;
					hid_resolv_usage(usage->hid, f);
					seq_printf(f, " ---> ");
					hid_resolv_event(usage->type, usage->code, f);
					seq_printf(f, "\n");
				}
			}
		}
	}

}

static int hid_debug_rdesc_show(struct seq_file *f, void *p)
{
	struct hid_device *hdev = f->private;
	const __u8 *rdesc = hdev->rdesc;
	unsigned rsize = hdev->rsize;
	int i;

	if (!rdesc) {
		rdesc = hdev->dev_rdesc;
		rsize = hdev->dev_rsize;
	}

	/* dump HID report descriptor */
	for (i = 0; i < rsize; i++)
		seq_printf(f, "%02x ", rdesc[i]);
	seq_printf(f, "\n\n");

	/* dump parsed data and input mappings */
	if (down_interruptible(&hdev->driver_input_lock))
		return 0;

	hid_dump_device(hdev, f);
	seq_printf(f, "\n");
	hid_dump_input_mapping(hdev, f);

	up(&hdev->driver_input_lock);

	return 0;
}

static int hid_debug_events_open(struct inode *inode, struct file *file)
{
	int err = 0;
	struct hid_debug_list *list;
	unsigned long flags;

	if (!(list = kzalloc(sizeof(struct hid_debug_list), GFP_KERNEL))) {
		err = -ENOMEM;
		goto out;
	}

	err = kfifo_alloc(&list->hid_debug_fifo, HID_DEBUG_FIFOSIZE, GFP_KERNEL);
	if (err) {
		kfree(list);
		goto out;
	}
	list->hdev = (struct hid_device *) inode->i_private;
	kref_get(&list->hdev->ref);
	file->private_data = list;
	mutex_init(&list->read_mutex);

	spin_lock_irqsave(&list->hdev->debug_list_lock, flags);
	list_add_tail(&list->node, &list->hdev->debug_list);
	spin_unlock_irqrestore(&list->hdev->debug_list_lock, flags);

out:
	return err;
}

static ssize_t hid_debug_events_read(struct file *file, char __user *buffer,
		size_t count, loff_t *ppos)
{
	struct hid_debug_list *list = file->private_data;
	int ret = 0, copied;
	DECLARE_WAITQUEUE(wait, current);

	mutex_lock(&list->read_mutex);
	if (kfifo_is_empty(&list->hid_debug_fifo)) {
		add_wait_queue(&list->hdev->debug_wait, &wait);
		set_current_state(TASK_INTERRUPTIBLE);

		while (kfifo_is_empty(&list->hid_debug_fifo)) {
			if (signal_pending(current)) {
				ret = -ERESTARTSYS;
				break;
			}

			/* if list->hdev is NULL we cannot remove_wait_queue().
			 * if list->hdev->debug is 0 then hid_debug_unregister()
			 * was already called and list->hdev is being destroyed.
			 * if we add remove_wait_queue() here we can hit a race.
			 */
			if (!list->hdev || !list->hdev->debug) {
				ret = -EIO;
				__set_current_state(TASK_RUNNING);
				goto out;
			}

			if (file->f_flags & O_NONBLOCK) {
				ret = -EAGAIN;
				break;
			}

			/* allow O_NONBLOCK from other threads */
			mutex_unlock(&list->read_mutex);
			schedule();
			mutex_lock(&list->read_mutex);
			set_current_state(TASK_INTERRUPTIBLE);
		}

		__set_current_state(TASK_RUNNING);
		remove_wait_queue(&list->hdev->debug_wait, &wait);

		if (ret)
			goto out;
	}

	/* pass the fifo content to userspace, locking is not needed with only
	 * one concurrent reader and one concurrent writer
	 */
	ret = kfifo_to_user(&list->hid_debug_fifo, buffer, count, &copied);
	if (ret)
		goto out;
	ret = copied;
out:
	mutex_unlock(&list->read_mutex);
	return ret;
}

static __poll_t hid_debug_events_poll(struct file *file, poll_table *wait)
{
	struct hid_debug_list *list = file->private_data;

	poll_wait(file, &list->hdev->debug_wait, wait);
	if (!kfifo_is_empty(&list->hid_debug_fifo))
		return EPOLLIN | EPOLLRDNORM;
	if (!list->hdev->debug)
		return EPOLLERR | EPOLLHUP;
	return 0;
}

static int hid_debug_events_release(struct inode *inode, struct file *file)
{
	struct hid_debug_list *list = file->private_data;
	unsigned long flags;

	spin_lock_irqsave(&list->hdev->debug_list_lock, flags);
	list_del(&list->node);
	spin_unlock_irqrestore(&list->hdev->debug_list_lock, flags);
	kfifo_free(&list->hid_debug_fifo);

	kref_put(&list->hdev->ref, hiddev_free);
	kfree(list);

	return 0;
}

DEFINE_SHOW_ATTRIBUTE(hid_debug_rdesc);

static const struct file_operations hid_debug_events_fops = {
	.owner =        THIS_MODULE,
	.open           = hid_debug_events_open,
	.read           = hid_debug_events_read,
	.poll		= hid_debug_events_poll,
	.release        = hid_debug_events_release,
	.llseek		= noop_llseek,
};


void hid_debug_register(struct hid_device *hdev, const char *name)
{
	hdev->debug_dir = debugfs_create_dir(name, hid_debug_root);
	hdev->debug_rdesc = debugfs_create_file("rdesc", 0400,
			hdev->debug_dir, hdev, &hid_debug_rdesc_fops);
	hdev->debug_events = debugfs_create_file("events", 0400,
			hdev->debug_dir, hdev, &hid_debug_events_fops);
	hdev->debug = 1;
}

void hid_debug_unregister(struct hid_device *hdev)
{
	hdev->debug = 0;
	wake_up_interruptible(&hdev->debug_wait);
	debugfs_remove(hdev->debug_rdesc);
	debugfs_remove(hdev->debug_events);
	debugfs_remove(hdev->debug_dir);
}

void hid_debug_init(void)
{
	hid_debug_root = debugfs_create_dir("hid", NULL);
}

void hid_debug_exit(void)
{
	debugfs_remove_recursive(hid_debug_root);
}
