{-# LANGUAGE OverloadedStrings #-}
module Typst.Emoji (
  typstEmojis
)
where
import Data.Text (Text)

-- | A list of triples, each consisting of the emoji name,
-- a Boolean indicating whether the symbol is an accent, and
-- the resolved emoji.
typstEmojis :: [(Text, Bool, Text)]
typstEmojis =
-- autogenerated by make update-symbols
  [ ( "ABCD" , False , "\128288" )
  , ( "a" , False , "\127344" )
  , ( "ab" , False , "\127374" )
  , ( "abacus" , False , "\129518" )
  , ( "abc" , False , "\128292" )
  , ( "abcd" , False , "\128289" )
  , ( "accordion" , False , "\129687" )
  , ( "aesculapius" , False , "\9877" )
  , ( "airplane" , False , "\9992" )
  , ( "airplane.landing" , False , "\128748" )
  , ( "airplane.small" , False , "\128745" )
  , ( "airplane.takeoff" , False , "\128747" )
  , ( "alembic" , False , "\9879" )
  , ( "alien" , False , "\128125" )
  , ( "alien.monster" , False , "\128126" )
  , ( "ambulance" , False , "\128657" )
  , ( "amphora" , False , "\127994" )
  , ( "anchor" , False , "\9875" )
  , ( "anger" , False , "\128162" )
  , ( "ant" , False , "\128028" )
  , ( "apple.green" , False , "\127823" )
  , ( "apple.red" , False , "\127822" )
  , ( "arm.mech" , False , "\129470" )
  , ( "arm.muscle" , False , "\128170" )
  , ( "arm.selfie" , False , "\129331" )
  , ( "arrow.r.filled" , False , "\10145" )
  , ( "arrow.r.hook" , False , "\8618" )
  , ( "arrow.r.soon" , False , "\128284" )
  , ( "arrow.l.filled" , False , "\11013" )
  , ( "arrow.l.hook" , False , "\8617" )
  , ( "arrow.l.back" , False , "\128281" )
  , ( "arrow.l.end" , False , "\128282" )
  , ( "arrow.t.filled" , False , "\11014" )
  , ( "arrow.t.curve" , False , "\10548" )
  , ( "arrow.t.top" , False , "\128285" )
  , ( "arrow.b.filled" , False , "\11015" )
  , ( "arrow.b.curve" , False , "\10549" )
  , ( "arrow.l.r" , True , "\8596" )
  , ( "arrow.l.r.on" , False , "\128283" )
  , ( "arrow.t.b" , False , "\8597" )
  , ( "arrow.bl" , False , "\8601" )
  , ( "arrow.br" , False , "\8600" )
  , ( "arrow.tl" , False , "\8598" )
  , ( "arrow.tr" , False , "\8599" )
  , ( "arrows.cycle" , False , "\128260" )
  , ( "ast" , False , "*" )
  , ( "ast.box" , False , "\10035" )
  , ( "atm" , False , "\127975" )
  , ( "atom" , False , "\9883" )
  , ( "aubergine" , False , "\127814" )
  , ( "avocado" , False , "\129361" )
  , ( "axe" , False , "\129683" )
  , ( "b" , False , "\127345" )
  , ( "baby" , False , "\128118" )
  , ( "baby.angel" , False , "\128124" )
  , ( "baby.box" , False , "\128700" )
  , ( "babybottle" , False , "\127868" )
  , ( "backpack" , False , "\127890" )
  , ( "bacon" , False , "\129363" )
  , ( "badger" , False , "\129441" )
  , ( "badminton" , False , "\127992" )
  , ( "bagel" , False , "\129391" )
  , ( "baggageclaim" , False , "\128708" )
  , ( "baguette" , False , "\129366" )
  , ( "balloon" , False , "\127880" )
  , ( "ballot.check" , False , "\9745" )
  , ( "ballotbox" , False , "\128499" )
  , ( "banana" , False , "\127820" )
  , ( "banjo" , False , "\129685" )
  , ( "bank" , False , "\127974" )
  , ( "barberpole" , False , "\128136" )
  , ( "baseball" , False , "\9918" )
  , ( "basecap" , False , "\129506" )
  , ( "basket" , False , "\129530" )
  , ( "basketball" , False , "\9977" )
  , ( "basketball.ball" , False , "\127936" )
  , ( "bat" , False , "\129415" )
  , ( "bathtub" , False , "\128704" )
  , ( "bathtub.foam" , False , "\128705" )
  , ( "battery" , False , "\128267" )
  , ( "battery.low" , False , "\129707" )
  , ( "beach.palm" , False , "\127965" )
  , ( "beach.umbrella" , False , "\127958" )
  , ( "beads" , False , "\128255" )
  , ( "beans" , False , "\129752" )
  , ( "bear" , False , "\128059" )
  , ( "beaver" , False , "\129451" )
  , ( "bed" , False , "\128719" )
  , ( "bed.person" , False , "\128716" )
  , ( "bee" , False , "\128029" )
  , ( "beer" , False , "\127866" )
  , ( "beer.clink" , False , "\127867" )
  , ( "beet" , False , "\129756" )
  , ( "beetle" , False , "\129714" )
  , ( "beetle.lady" , False , "\128030" )
  , ( "bell" , False , "\128276" )
  , ( "bell.ding" , False , "\128718" )
  , ( "bell.not" , False , "\128277" )
  , ( "bento" , False , "\127857" )
  , ( "bicyclist" , False , "\128692" )
  , ( "bicyclist.mountain" , False , "\128693" )
  , ( "bike" , False , "\128690" )
  , ( "bike.not" , False , "\128691" )
  , ( "bikini" , False , "\128089" )
  , ( "billiards" , False , "\127921" )
  , ( "bin" , False , "\128465" )
  , ( "biohazard" , False , "\9763" )
  , ( "bird" , False , "\128038" )
  , ( "bison" , False , "\129452" )
  , ( "blood" , False , "\129656" )
  , ( "blouse" , False , "\128090" )
  , ( "blowfish" , False , "\128033" )
  , ( "blueberries" , False , "\129744" )
  , ( "boar" , False , "\128023" )
  , ( "boat.sail" , False , "\9973" )
  , ( "boat.row" , False , "\128675" )
  , ( "boat.motor" , False , "\128741" )
  , ( "boat.speed" , False , "\128676" )
  , ( "boat.canoe" , False , "\128758" )
  , ( "bolt" , False , "\128297" )
  , ( "bomb" , False , "\128163" )
  , ( "bone" , False , "\129460" )
  , ( "book.red" , False , "\128213" )
  , ( "book.blue" , False , "\128216" )
  , ( "book.green" , False , "\128215" )
  , ( "book.orange" , False , "\128217" )
  , ( "book.spiral" , False , "\128210" )
  , ( "book.open" , False , "\128214" )
  , ( "bookmark" , False , "\128278" )
  , ( "books" , False , "\128218" )
  , ( "boomerang" , False , "\129667" )
  , ( "bordercontrol" , False , "\128706" )
  , ( "bouquet" , False , "\128144" )
  , ( "bow" , False , "\127993" )
  , ( "bowl.spoon" , False , "\129379" )
  , ( "bowl.steam" , False , "\127836" )
  , ( "bowling" , False , "\127923" )
  , ( "boxing" , False , "\129354" )
  , ( "boy" , False , "\128102" )
  , ( "brain" , False , "\129504" )
  , ( "bread" , False , "\127838" )
  , ( "brick" , False , "\129521" )
  , ( "bride" , False , "\128112" )
  , ( "bridge.fog" , False , "\127745" )
  , ( "bridge.night" , False , "\127753" )
  , ( "briefcase" , False , "\128188" )
  , ( "briefs" , False , "\129650" )
  , ( "brightness.high" , False , "\128262" )
  , ( "brightness.low" , False , "\128261" )
  , ( "broccoli" , False , "\129382" )
  , ( "broom" , False , "\129529" )
  , ( "brush" , False , "\128396" )
  , ( "bubble.speech.r" , False , "\128172" )
  , ( "bubble.speech.l" , False , "\128488" )
  , ( "bubble.thought" , False , "\128173" )
  , ( "bubble.anger.r" , False , "\128495" )
  , ( "bubbles" , False , "\129767" )
  , ( "bubbletea" , False , "\129483" )
  , ( "bucket" , False , "\129699" )
  , ( "buffalo.water" , False , "\128003" )
  , ( "bug" , False , "\128027" )
  , ( "builder" , False , "\128119" )
  , ( "burger" , False , "\127828" )
  , ( "burrito" , False , "\127791" )
  , ( "bus" , False , "\128652" )
  , ( "bus.front" , False , "\128653" )
  , ( "bus.small" , False , "\128656" )
  , ( "bus.stop" , False , "\128655" )
  , ( "bus.trolley" , False , "\128654" )
  , ( "butter" , False , "\129480" )
  , ( "butterfly" , False , "\129419" )
  , ( "button" , False , "\128306" )
  , ( "button.alt" , False , "\128307" )
  , ( "button.radio" , False , "\128280" )
  , ( "cabinet.file" , False , "\128452" )
  , ( "cablecar" , False , "\128672" )
  , ( "cablecar.small" , False , "\128673" )
  , ( "cactus" , False , "\127797" )
  , ( "cake" , False , "\127874" )
  , ( "cake.fish" , False , "\127845" )
  , ( "cake.moon" , False , "\129390" )
  , ( "cake.slice" , False , "\127856" )
  , ( "calendar" , False , "\128197" )
  , ( "calendar.spiral" , False , "\128467" )
  , ( "calendar.tearoff" , False , "\128198" )
  , ( "camel" , False , "\128043" )
  , ( "camel.dromedar" , False , "\128042" )
  , ( "camera" , False , "\128247" )
  , ( "camera.flash" , False , "\128248" )
  , ( "camera.movie" , False , "\127909" )
  , ( "camera.movie.box" , False , "\127910" )
  , ( "camera.video" , False , "\128249" )
  , ( "camping" , False , "\127957" )
  , ( "can" , False , "\129387" )
  , ( "candle" , False , "\128367" )
  , ( "candy" , False , "\127852" )
  , ( "cane" , False , "\129455" )
  , ( "car" , False , "\128663" )
  , ( "car.front" , False , "\128664" )
  , ( "car.pickup" , False , "\128763" )
  , ( "car.police" , False , "\128659" )
  , ( "car.police.front" , False , "\128660" )
  , ( "car.racing" , False , "\127950" )
  , ( "car.rickshaw" , False , "\128762" )
  , ( "car.suv" , False , "\128665" )
  , ( "card.credit" , False , "\128179" )
  , ( "card.id" , False , "\129706" )
  , ( "cardindex" , False , "\128199" )
  , ( "carrot" , False , "\129365" )
  , ( "cart" , False , "\128722" )
  , ( "cassette" , False , "\128252" )
  , ( "castle.eu" , False , "\127984" )
  , ( "castle.jp" , False , "\127983" )
  , ( "cat" , False , "\128008" )
  , ( "cat.face" , False , "\128049" )
  , ( "cat.face.angry" , False , "\128574" )
  , ( "cat.face.cry" , False , "\128575" )
  , ( "cat.face.heart" , False , "\128571" )
  , ( "cat.face.joy" , False , "\128569" )
  , ( "cat.face.kiss" , False , "\128573" )
  , ( "cat.face.laugh" , False , "\128568" )
  , ( "cat.face.shock" , False , "\128576" )
  , ( "cat.face.smile" , False , "\128570" )
  , ( "cat.face.smirk" , False , "\128572" )
  , ( "chain" , False , "\128279" )
  , ( "chains" , False , "\9939" )
  , ( "chair" , False , "\129681" )
  , ( "champagne" , False , "\127870" )
  , ( "chart.bar" , False , "\128202" )
  , ( "chart.up" , False , "\128200" )
  , ( "chart.down" , False , "\128201" )
  , ( "chart.yen.up" , False , "\128185" )
  , ( "checkmark.heavy" , False , "\10004" )
  , ( "checkmark.box" , False , "\9989" )
  , ( "cheese" , False , "\129472" )
  , ( "cherries" , False , "\127826" )
  , ( "chess" , False , "\9823" )
  , ( "chestnut" , False , "\127792" )
  , ( "chicken" , False , "\128020" )
  , ( "chicken.baby" , False , "\128037" )
  , ( "chicken.baby.egg" , False , "\128035" )
  , ( "chicken.baby.head" , False , "\128036" )
  , ( "chicken.leg" , False , "\127831" )
  , ( "chicken.male" , False , "\128019" )
  , ( "child" , False , "\129490" )
  , ( "chipmunk" , False , "\128063" )
  , ( "chocolate" , False , "\127851" )
  , ( "chopsticks" , False , "\129378" )
  , ( "church" , False , "\9962" )
  , ( "church.love" , False , "\128146" )
  , ( "cigarette" , False , "\128684" )
  , ( "cigarette.not" , False , "\128685" )
  , ( "circle.black" , False , "\9899" )
  , ( "circle.blue" , False , "\128309" )
  , ( "circle.brown" , False , "\128996" )
  , ( "circle.green" , False , "\128994" )
  , ( "circle.orange" , False , "\128992" )
  , ( "circle.purple" , False , "\128995" )
  , ( "circle.white" , False , "\9898" )
  , ( "circle.red" , False , "\128308" )
  , ( "circle.yellow" , False , "\128993" )
  , ( "circle.stroked" , False , "\11093" )
  , ( "circus" , False , "\127914" )
  , ( "city" , False , "\127961" )
  , ( "city.dusk" , False , "\127750" )
  , ( "city.night" , False , "\127747" )
  , ( "city.sunset" , False , "\127751" )
  , ( "cl" , False , "\127377" )
  , ( "clamp" , False , "\128476" )
  , ( "clapperboard" , False , "\127916" )
  , ( "climbing" , False , "\129495" )
  , ( "clip" , False , "\128206" )
  , ( "clipboard" , False , "\128203" )
  , ( "clips" , False , "\128391" )
  , ( "clock.one" , False , "\128336" )
  , ( "clock.one.thirty" , False , "\128348" )
  , ( "clock.two" , False , "\128337" )
  , ( "clock.two.thirty" , False , "\128349" )
  , ( "clock.three" , False , "\128338" )
  , ( "clock.three.thirty" , False , "\128350" )
  , ( "clock.four" , False , "\128339" )
  , ( "clock.four.thirty" , False , "\128351" )
  , ( "clock.five" , False , "\128340" )
  , ( "clock.five.thirty" , False , "\128352" )
  , ( "clock.six" , False , "\128341" )
  , ( "clock.six.thirty" , False , "\128353" )
  , ( "clock.seven" , False , "\128342" )
  , ( "clock.seven.thirty" , False , "\128354" )
  , ( "clock.eight" , False , "\128343" )
  , ( "clock.eight.thirty" , False , "\128355" )
  , ( "clock.nine" , False , "\128344" )
  , ( "clock.nine.thirty" , False , "\128356" )
  , ( "clock.ten" , False , "\128345" )
  , ( "clock.ten.thirty" , False , "\128357" )
  , ( "clock.eleven" , False , "\128346" )
  , ( "clock.eleven.thirty" , False , "\128358" )
  , ( "clock.twelve" , False , "\128347" )
  , ( "clock.twelve.thirty" , False , "\128359" )
  , ( "clock.alarm" , False , "\9200" )
  , ( "clock.old" , False , "\128368" )
  , ( "clock.timer" , False , "\9202" )
  , ( "cloud" , False , "\9729" )
  , ( "cloud.dust" , False , "\128168" )
  , ( "cloud.rain" , False , "\127783" )
  , ( "cloud.snow" , False , "\127784" )
  , ( "cloud.storm" , False , "\9928" )
  , ( "cloud.sun" , False , "\9925" )
  , ( "cloud.sun.hidden" , False , "\127781" )
  , ( "cloud.sun.rain" , False , "\127782" )
  , ( "cloud.thunder" , False , "\127785" )
  , ( "coat" , False , "\129509" )
  , ( "coat.lab" , False , "\129404" )
  , ( "cockroach" , False , "\129715" )
  , ( "cocktail.martini" , False , "\127864" )
  , ( "cocktail.tropical" , False , "\127865" )
  , ( "coconut" , False , "\129381" )
  , ( "coffee" , False , "\9749" )
  , ( "coffin" , False , "\9904" )
  , ( "coin" , False , "\129689" )
  , ( "comet" , False , "\9732" )
  , ( "compass" , False , "\129517" )
  , ( "computer" , False , "\128421" )
  , ( "computermouse" , False , "\128433" )
  , ( "confetti" , False , "\127882" )
  , ( "construction" , False , "\128679" )
  , ( "controller" , False , "\127918" )
  , ( "cookie" , False , "\127850" )
  , ( "cookie.fortune" , False , "\129376" )
  , ( "cooking" , False , "\127859" )
  , ( "cool" , False , "\127378" )
  , ( "copyright" , False , "\169" )
  , ( "coral" , False , "\129720" )
  , ( "corn" , False , "\127805" )
  , ( "couch" , False , "\128715" )
  , ( "couple" , False , "\128145" )
  , ( "cow" , False , "\128004" )
  , ( "cow.face" , False , "\128046" )
  , ( "crab" , False , "\129408" )
  , ( "crane" , False , "\127959" )
  , ( "crayon" , False , "\128397" )
  , ( "cricket" , False , "\129431" )
  , ( "cricketbat" , False , "\127951" )
  , ( "crocodile" , False , "\128010" )
  , ( "croissant" , False , "\129360" )
  , ( "crossmark" , False , "\10060" )
  , ( "crossmark.box" , False , "\10062" )
  , ( "crown" , False , "\128081" )
  , ( "crutch" , False , "\129660" )
  , ( "crystal" , False , "\128302" )
  , ( "cucumber" , False , "\129362" )
  , ( "cup.straw" , False , "\129380" )
  , ( "cupcake" , False , "\129473" )
  , ( "curling" , False , "\129356" )
  , ( "curry" , False , "\127835" )
  , ( "custard" , False , "\127854" )
  , ( "customs" , False , "\128707" )
  , ( "cutlery" , False , "\127860" )
  , ( "cyclone" , False , "\127744" )
  , ( "dancing.man" , False , "\128378" )
  , ( "dancing.woman" , False , "\128131" )
  , ( "dancing.women.bunny" , False , "\128111" )
  , ( "darts" , False , "\127919" )
  , ( "dash.wave.double" , False , "\12336" )
  , ( "deer" , False , "\129420" )
  , ( "desert" , False , "\127964" )
  , ( "detective" , False , "\128373" )
  , ( "diamond.blue" , False , "\128311" )
  , ( "diamond.blue.small" , False , "\128313" )
  , ( "diamond.orange" , False , "\128310" )
  , ( "diamond.orange.small" , False , "\128312" )
  , ( "diamond.dot" , False , "\128160" )
  , ( "die" , False , "\127922" )
  , ( "dino.pod" , False , "\129429" )
  , ( "dino.rex" , False , "\129430" )
  , ( "disc.cd" , False , "\128191" )
  , ( "disc.dvd" , False , "\128192" )
  , ( "disc.mini" , False , "\128189" )
  , ( "discoball" , False , "\129705" )
  , ( "diving" , False , "\129343" )
  , ( "dodo" , False , "\129444" )
  , ( "dog" , False , "\128021" )
  , ( "dog.face" , False , "\128054" )
  , ( "dog.guide" , False , "\129454" )
  , ( "dog.poodle" , False , "\128041" )
  , ( "dollar" , False , "\128178" )
  , ( "dolphin" , False , "\128044" )
  , ( "donut" , False , "\127849" )
  , ( "door" , False , "\128682" )
  , ( "dove.peace" , False , "\128330" )
  , ( "dragon" , False , "\128009" )
  , ( "dragon.face" , False , "\128050" )
  , ( "dress" , False , "\128087" )
  , ( "dress.kimono" , False , "\128088" )
  , ( "dress.sari" , False , "\129403" )
  , ( "drop" , False , "\128167" )
  , ( "drops" , False , "\128166" )
  , ( "drum" , False , "\129345" )
  , ( "drum.big" , False , "\129688" )
  , ( "duck" , False , "\129414" )
  , ( "dumpling" , False , "\129375" )
  , ( "eagle" , False , "\129413" )
  , ( "ear" , False , "\128066" )
  , ( "ear.aid" , False , "\129467" )
  , ( "egg" , False , "\129370" )
  , ( "eighteen.not" , False , "\128286" )
  , ( "elephant" , False , "\128024" )
  , ( "elevator" , False , "\128727" )
  , ( "elf" , False , "\129501" )
  , ( "email" , False , "\128231" )
  , ( "excl" , False , "\10071" )
  , ( "excl.white" , False , "\10069" )
  , ( "excl.double" , False , "\8252" )
  , ( "excl.quest" , False , "\8265" )
  , ( "explosion" , False , "\128165" )
  , ( "extinguisher" , False , "\129519" )
  , ( "eye" , False , "\128065" )
  , ( "eyes" , False , "\128064" )
  , ( "face.grin" , False , "\128512" )
  , ( "face.angry" , False , "\128544" )
  , ( "face.angry.red" , False , "\128545" )
  , ( "face.anguish" , False , "\128551" )
  , ( "face.astonish" , False , "\128562" )
  , ( "face.bandage" , False , "\129301" )
  , ( "face.beam" , False , "\128513" )
  , ( "face.blank" , False , "\128566" )
  , ( "face.clown" , False , "\129313" )
  , ( "face.cold" , False , "\129398" )
  , ( "face.concern" , False , "\128550" )
  , ( "face.cool" , False , "\128526" )
  , ( "face.cover" , False , "\129325" )
  , ( "face.cowboy" , False , "\129312" )
  , ( "face.cry" , False , "\128557" )
  , ( "face.devil.smile" , False , "\128520" )
  , ( "face.devil.frown" , False , "\128127" )
  , ( "face.diagonal" , False , "\129764" )
  , ( "face.disguise" , False , "\129400" )
  , ( "face.distress" , False , "\128555" )
  , ( "face.dizzy" , False , "\128565" )
  , ( "face.dotted" , False , "\129765" )
  , ( "face.down" , False , "\128542" )
  , ( "face.down.sweat" , False , "\128531" )
  , ( "face.drool" , False , "\129316" )
  , ( "face.explode" , False , "\129327" )
  , ( "face.eyeroll" , False , "\128580" )
  , ( "face.friendly" , False , "\9786" )
  , ( "face.fear" , False , "\128552" )
  , ( "face.fear.sweat" , False , "\128560" )
  , ( "face.fever" , False , "\129298" )
  , ( "face.flush" , False , "\128563" )
  , ( "face.frown" , False , "\9785" )
  , ( "face.frown.slight" , False , "\128577" )
  , ( "face.frust" , False , "\128547" )
  , ( "face.goofy" , False , "\129322" )
  , ( "face.halo" , False , "\128519" )
  , ( "face.happy" , False , "\128522" )
  , ( "face.heart" , False , "\128525" )
  , ( "face.hearts" , False , "\129392" )
  , ( "face.heat" , False , "\129397" )
  , ( "face.hug" , False , "\129303" )
  , ( "face.inv" , False , "\128579" )
  , ( "face.joy" , False , "\128514" )
  , ( "face.kiss" , False , "\128535" )
  , ( "face.kiss.smile" , False , "\128537" )
  , ( "face.kiss.heart" , False , "\128536" )
  , ( "face.kiss.blush" , False , "\128538" )
  , ( "face.lick" , False , "\128523" )
  , ( "face.lie" , False , "\129317" )
  , ( "face.mask" , False , "\128567" )
  , ( "face.meh" , False , "\128530" )
  , ( "face.melt" , False , "\129760" )
  , ( "face.money" , False , "\129297" )
  , ( "face.monocle" , False , "\129488" )
  , ( "face.nausea" , False , "\129314" )
  , ( "face.nerd" , False , "\129299" )
  , ( "face.neutral" , False , "\128528" )
  , ( "face.open" , False , "\128515" )
  , ( "face.party" , False , "\129395" )
  , ( "face.peek" , False , "\129763" )
  , ( "face.plead" , False , "\129402" )
  , ( "face.relief" , False , "\128524" )
  , ( "face.rofl" , False , "\129315" )
  , ( "face.sad" , False , "\128532" )
  , ( "face.salute" , False , "\129761" )
  , ( "face.shock" , False , "\128561" )
  , ( "face.shush" , False , "\129323" )
  , ( "face.skeptic" , False , "\129320" )
  , ( "face.sleep" , False , "\128564" )
  , ( "face.sleepy" , False , "\128554" )
  , ( "face.smile" , False , "\128516" )
  , ( "face.smile.slight" , False , "\128578" )
  , ( "face.smile.sweat" , False , "\128517" )
  , ( "face.smile.tear" , False , "\129394" )
  , ( "face.smirk" , False , "\128527" )
  , ( "face.sneeze" , False , "\129319" )
  , ( "face.speak.not" , False , "\129762" )
  , ( "face.squint" , False , "\128518" )
  , ( "face.stars" , False , "\129321" )
  , ( "face.straight" , False , "\128529" )
  , ( "face.suffer" , False , "\128534" )
  , ( "face.surprise" , False , "\128559" )
  , ( "face.symbols" , False , "\129324" )
  , ( "face.tear" , False , "\128546" )
  , ( "face.tear.relief" , False , "\128549" )
  , ( "face.tear.withheld" , False , "\129401" )
  , ( "face.teeth" , False , "\128556" )
  , ( "face.think" , False , "\129300" )
  , ( "face.tired" , False , "\129769" )
  , ( "face.tongue" , False , "\128539" )
  , ( "face.tongue.squint" , False , "\128541" )
  , ( "face.tongue.wink" , False , "\128540" )
  , ( "face.triumph" , False , "\128548" )
  , ( "face.unhappy" , False , "\128533" )
  , ( "face.vomit" , False , "\129326" )
  , ( "face.weary" , False , "\128553" )
  , ( "face.wink" , False , "\128521" )
  , ( "face.woozy" , False , "\129396" )
  , ( "face.worry" , False , "\128543" )
  , ( "face.wow" , False , "\128558" )
  , ( "face.yawn" , False , "\129393" )
  , ( "face.zip" , False , "\129296" )
  , ( "factory" , False , "\127981" )
  , ( "fairy" , False , "\129498" )
  , ( "faith.christ" , False , "\10013" )
  , ( "faith.dharma" , False , "\9784" )
  , ( "faith.islam" , False , "\9770" )
  , ( "faith.judaism" , False , "\10017" )
  , ( "faith.menorah" , False , "\128334" )
  , ( "faith.om" , False , "\128329" )
  , ( "faith.orthodox" , False , "\9766" )
  , ( "faith.peace" , False , "\9774" )
  , ( "faith.star.dot" , False , "\128303" )
  , ( "faith.worship" , False , "\128720" )
  , ( "faith.yinyang" , False , "\9775" )
  , ( "falafel" , False , "\129478" )
  , ( "family" , False , "\128106" )
  , ( "fax" , False , "\128224" )
  , ( "feather" , False , "\129718" )
  , ( "feeding.breast" , False , "\129329" )
  , ( "fencing" , False , "\129338" )
  , ( "ferriswheel" , False , "\127905" )
  , ( "filebox" , False , "\128451" )
  , ( "filedividers" , False , "\128450" )
  , ( "film" , False , "\127902" )
  , ( "finger.r" , False , "\128073" )
  , ( "finger.l" , False , "\128072" )
  , ( "finger.t" , False , "\128070" )
  , ( "finger.t.alt" , False , "\9757" )
  , ( "finger.b" , False , "\128071" )
  , ( "finger.front" , False , "\129781" )
  , ( "finger.m" , False , "\128405" )
  , ( "fingerprint" , False , "\129734" )
  , ( "fingers.cross" , False , "\129310" )
  , ( "fingers.pinch" , False , "\129292" )
  , ( "fingers.snap" , False , "\129776" )
  , ( "fire" , False , "\128293" )
  , ( "firecracker" , False , "\129512" )
  , ( "fireengine" , False , "\128658" )
  , ( "fireworks" , False , "\127878" )
  , ( "fish" , False , "\128031" )
  , ( "fish.tropical" , False , "\128032" )
  , ( "fishing" , False , "\127907" )
  , ( "fist.front" , False , "\128074" )
  , ( "fist.r" , False , "\129308" )
  , ( "fist.l" , False , "\129307" )
  , ( "fist.raised" , False , "\9994" )
  , ( "flag.black" , False , "\127988" )
  , ( "flag.white" , False , "\127987" )
  , ( "flag.goal" , False , "\127937" )
  , ( "flag.golf" , False , "\9971" )
  , ( "flag.red" , False , "\128681" )
  , ( "flags.jp.crossed" , False , "\127884" )
  , ( "flamingo" , False , "\129449" )
  , ( "flashlight" , False , "\128294" )
  , ( "flatbread" , False , "\129747" )
  , ( "fleur" , False , "\9884" )
  , ( "floppy" , False , "\128190" )
  , ( "flower.hibiscus" , False , "\127802" )
  , ( "flower.lotus" , False , "\129719" )
  , ( "flower.pink" , False , "\127800" )
  , ( "flower.rose" , False , "\127801" )
  , ( "flower.sun" , False , "\127803" )
  , ( "flower.tulip" , False , "\127799" )
  , ( "flower.white" , False , "\128174" )
  , ( "flower.wilted" , False , "\129344" )
  , ( "flower.yellow" , False , "\127804" )
  , ( "fly" , False , "\129712" )
  , ( "fog" , False , "\127787" )
  , ( "folder" , False , "\128193" )
  , ( "folder.open" , False , "\128194" )
  , ( "fondue" , False , "\129749" )
  , ( "foot" , False , "\129462" )
  , ( "football" , False , "\9917" )
  , ( "football.am" , False , "\127944" )
  , ( "forex" , False , "\128177" )
  , ( "fountain" , False , "\9970" )
  , ( "fox" , False , "\129418" )
  , ( "free" , False , "\127379" )
  , ( "fries" , False , "\127839" )
  , ( "frisbee" , False , "\129359" )
  , ( "frog.face" , False , "\128056" )
  , ( "fuelpump" , False , "\9981" )
  , ( "gachi" , False , "\127543" )
  , ( "garlic" , False , "\129476" )
  , ( "gear" , False , "\9881" )
  , ( "gem" , False , "\128142" )
  , ( "genie" , False , "\129502" )
  , ( "ghost" , False , "\128123" )
  , ( "giraffe" , False , "\129426" )
  , ( "girl" , False , "\128103" )
  , ( "glass.clink" , False , "\129346" )
  , ( "glass.milk" , False , "\129371" )
  , ( "glass.pour" , False , "\129751" )
  , ( "glass.tumbler" , False , "\129347" )
  , ( "glasses" , False , "\128083" )
  , ( "glasses.sun" , False , "\128374" )
  , ( "globe.am" , False , "\127758" )
  , ( "globe.as.au" , False , "\127759" )
  , ( "globe.eu.af" , False , "\127757" )
  , ( "globe.meridian" , False , "\127760" )
  , ( "gloves" , False , "\129508" )
  , ( "go" , False , "\127540" )
  , ( "goal" , False , "\129349" )
  , ( "goat" , False , "\128016" )
  , ( "goggles" , False , "\129405" )
  , ( "golfing" , False , "\127948" )
  , ( "gorilla" , False , "\129421" )
  , ( "grapes" , False , "\127815" )
  , ( "guard.man" , False , "\128130" )
  , ( "guitar" , False , "\127928" )
  , ( "gymnastics" , False , "\129336" )
  , ( "haircut" , False , "\128135" )
  , ( "hammer" , False , "\128296" )
  , ( "hammer.pick" , False , "\9874" )
  , ( "hammer.wrench" , False , "\128736" )
  , ( "hamsa" , False , "\129708" )
  , ( "hamster.face" , False , "\128057" )
  , ( "hand.raised" , False , "\9995" )
  , ( "hand.raised.alt" , False , "\129306" )
  , ( "hand.r" , False , "\129777" )
  , ( "hand.l" , False , "\129778" )
  , ( "hand.t" , False , "\129780" )
  , ( "hand.b" , False , "\129779" )
  , ( "hand.ok" , False , "\128076" )
  , ( "hand.call" , False , "\129305" )
  , ( "hand.love" , False , "\129311" )
  , ( "hand.part" , False , "\128406" )
  , ( "hand.peace" , False , "\9996" )
  , ( "hand.pinch" , False , "\129295" )
  , ( "hand.rock" , False , "\129304" )
  , ( "hand.splay" , False , "\128400" )
  , ( "hand.wave" , False , "\128075" )
  , ( "hand.write" , False , "\9997" )
  , ( "handbag" , False , "\128092" )
  , ( "handball" , False , "\129342" )
  , ( "handholding.man.man" , False , "\128108" )
  , ( "handholding.woman.man" , False , "\128107" )
  , ( "handholding.woman.woman" , False , "\128109" )
  , ( "hands.folded" , False , "\128591" )
  , ( "hands.palms" , False , "\129330" )
  , ( "hands.clap" , False , "\128079" )
  , ( "hands.heart" , False , "\129782" )
  , ( "hands.open" , False , "\128080" )
  , ( "hands.raised" , False , "\128588" )
  , ( "hands.shake" , False , "\129309" )
  , ( "harp" , False , "\129673" )
  , ( "hash" , False , "#" )
  , ( "hat.ribbon" , False , "\128082" )
  , ( "hat.top" , False , "\127913" )
  , ( "headphone" , False , "\127911" )
  , ( "heart" , False , "\10084" )
  , ( "heart.arrow" , False , "\128152" )
  , ( "heart.beat" , False , "\128147" )
  , ( "heart.black" , False , "\128420" )
  , ( "heart.blue" , False , "\128153" )
  , ( "heart.box" , False , "\128159" )
  , ( "heart.broken" , False , "\128148" )
  , ( "heart.brown" , False , "\129294" )
  , ( "heart.double" , False , "\128149" )
  , ( "heart.excl" , False , "\10083" )
  , ( "heart.green" , False , "\128154" )
  , ( "heart.grow" , False , "\128151" )
  , ( "heart.orange" , False , "\129505" )
  , ( "heart.purple" , False , "\128156" )
  , ( "heart.real" , False , "\129728" )
  , ( "heart.revolve" , False , "\128158" )
  , ( "heart.ribbon" , False , "\128157" )
  , ( "heart.spark" , False , "\128150" )
  , ( "heart.white" , False , "\129293" )
  , ( "heart.yellow" , False , "\128155" )
  , ( "hedgehog" , False , "\129428" )
  , ( "helicopter" , False , "\128641" )
  , ( "helix" , False , "\129516" )
  , ( "helmet.cross" , False , "\9937" )
  , ( "helmet.military" , False , "\129686" )
  , ( "hi" , False , "\12953" )
  , ( "hippo" , False , "\129435" )
  , ( "hockey" , False , "\127953" )
  , ( "hole" , False , "\128371" )
  , ( "honey" , False , "\127855" )
  , ( "hongbao" , False , "\129511" )
  , ( "hook" , False , "\129693" )
  , ( "horn.postal" , False , "\128239" )
  , ( "horse" , False , "\128014" )
  , ( "horse.carousel" , False , "\127904" )
  , ( "horse.face" , False , "\128052" )
  , ( "horse.race" , False , "\127943" )
  , ( "hospital" , False , "\127973" )
  , ( "hotdog" , False , "\127789" )
  , ( "hotel" , False , "\127976" )
  , ( "hotel.love" , False , "\127977" )
  , ( "hotspring" , False , "\9832" )
  , ( "hourglass" , False , "\8987" )
  , ( "hourglass.flow" , False , "\9203" )
  , ( "house" , False , "\127968" )
  , ( "house.derelict" , False , "\127962" )
  , ( "house.garden" , False , "\127969" )
  , ( "house.multiple" , False , "\127960" )
  , ( "hundred" , False , "\128175" )
  , ( "hut" , False , "\128726" )
  , ( "ice" , False , "\129482" )
  , ( "icecream" , False , "\127848" )
  , ( "icecream.shaved" , False , "\127847" )
  , ( "icecream.soft" , False , "\127846" )
  , ( "icehockey" , False , "\127954" )
  , ( "id" , False , "\127380" )
  , ( "info" , False , "\8505" )
  , ( "izakaya" , False , "\127982" )
  , ( "jar" , False , "\129753" )
  , ( "jeans" , False , "\128086" )
  , ( "jigsaw" , False , "\129513" )
  , ( "joystick" , False , "\128377" )
  , ( "juggling" , False , "\129337" )
  , ( "juice" , False , "\129475" )
  , ( "ka" , False , "\127569" )
  , ( "kaaba" , False , "\128331" )
  , ( "kachi" , False , "\127545" )
  , ( "kadomatsu" , False , "\127885" )
  , ( "kangaroo" , False , "\129432" )
  , ( "kara" , False , "\127539" )
  , ( "kebab" , False , "\129369" )
  , ( "key" , False , "\128273" )
  , ( "key.old" , False , "\128477" )
  , ( "keyboard" , False , "\9000" )
  , ( "kiss" , False , "\128143" )
  , ( "kissmark" , False , "\128139" )
  , ( "kite" , False , "\129665" )
  , ( "kiwi" , False , "\129373" )
  , ( "knife" , False , "\128298" )
  , ( "knife.dagger" , False , "\128481" )
  , ( "knot" , False , "\129698" )
  , ( "koala" , False , "\128040" )
  , ( "koinobori" , False , "\127887" )
  , ( "koko" , False , "\127489" )
  , ( "kon" , False , "\127538" )
  , ( "label" , False , "\127991" )
  , ( "lacrosse" , False , "\129357" )
  , ( "ladder" , False , "\129692" )
  , ( "lamp.diya" , False , "\129684" )
  , ( "laptop" , False , "\128187" )
  , ( "leaf.clover.three" , False , "\9752" )
  , ( "leaf.clover.four" , False , "\127808" )
  , ( "leaf.fall" , False , "\127810" )
  , ( "leaf.herb" , False , "\127807" )
  , ( "leaf.maple" , False , "\127809" )
  , ( "leaf.wind" , False , "\127811" )
  , ( "leftluggage" , False , "\128709" )
  , ( "leg" , False , "\129461" )
  , ( "leg.mech" , False , "\129471" )
  , ( "lemon" , False , "\127819" )
  , ( "leopard" , False , "\128006" )
  , ( "letter.love" , False , "\128140" )
  , ( "liberty" , False , "\128509" )
  , ( "lightbulb" , False , "\128161" )
  , ( "lightning" , False , "\9889" )
  , ( "lion" , False , "\129409" )
  , ( "lipstick" , False , "\128132" )
  , ( "litter" , False , "\128686" )
  , ( "litter.not" , False , "\128687" )
  , ( "lizard" , False , "\129422" )
  , ( "llama" , False , "\129433" )
  , ( "lobster" , False , "\129438" )
  , ( "lock" , False , "\128274" )
  , ( "lock.key" , False , "\128272" )
  , ( "lock.open" , False , "\128275" )
  , ( "lock.pen" , False , "\128271" )
  , ( "lollipop" , False , "\127853" )
  , ( "lotion" , False , "\129524" )
  , ( "luggage" , False , "\129523" )
  , ( "lungs" , False , "\129729" )
  , ( "mage" , False , "\129497" )
  , ( "magnet" , False , "\129522" )
  , ( "magnify.r" , False , "\128270" )
  , ( "magnify.l" , False , "\128269" )
  , ( "mahjong.dragon.red" , False , "\126980" )
  , ( "mail" , False , "\9993" )
  , ( "mail.arrow" , False , "\128233" )
  , ( "mailbox.closed.empty" , False , "\128234" )
  , ( "mailbox.closed.full" , False , "\128235" )
  , ( "mailbox.open.empty" , False , "\128237" )
  , ( "mailbox.open.full" , False , "\128236" )
  , ( "mammoth" , False , "\129443" )
  , ( "man" , False , "\128104" )
  , ( "man.box" , False , "\128697" )
  , ( "man.crown" , False , "\129332" )
  , ( "man.guapimao" , False , "\128114" )
  , ( "man.levitate" , False , "\128372" )
  , ( "man.old" , False , "\128116" )
  , ( "man.pregnant" , False , "\129731" )
  , ( "man.turban" , False , "\128115" )
  , ( "man.tuxedo" , False , "\129333" )
  , ( "mango" , False , "\129389" )
  , ( "map.world" , False , "\128506" )
  , ( "map.jp" , False , "\128510" )
  , ( "martialarts" , False , "\129355" )
  , ( "masks" , False , "\127917" )
  , ( "mate" , False , "\129481" )
  , ( "matryoshka" , False , "\129670" )
  , ( "meat" , False , "\129385" )
  , ( "meat.bone" , False , "\127830" )
  , ( "medal.first" , False , "\129351" )
  , ( "medal.second" , False , "\129352" )
  , ( "medal.third" , False , "\129353" )
  , ( "medal.sports" , False , "\127941" )
  , ( "medal.military" , False , "\127894" )
  , ( "megaphone" , False , "\128226" )
  , ( "megaphone.simple" , False , "\128227" )
  , ( "melon" , False , "\127816" )
  , ( "merperson" , False , "\129500" )
  , ( "metro" , False , "\9410" )
  , ( "microbe" , False , "\129440" )
  , ( "microphone" , False , "\127908" )
  , ( "microphone.studio" , False , "\127897" )
  , ( "microscope" , False , "\128300" )
  , ( "milkyway" , False , "\127756" )
  , ( "mirror" , False , "\129694" )
  , ( "mixer" , False , "\127899" )
  , ( "money.bag" , False , "\128176" )
  , ( "money.dollar" , False , "\128181" )
  , ( "money.euro" , False , "\128182" )
  , ( "money.pound" , False , "\128183" )
  , ( "money.yen" , False , "\128180" )
  , ( "money.wings" , False , "\128184" )
  , ( "monkey" , False , "\128018" )
  , ( "monkey.face" , False , "\128053" )
  , ( "monkey.hear.not" , False , "\128585" )
  , ( "monkey.see.not" , False , "\128584" )
  , ( "monkey.speak.not" , False , "\128586" )
  , ( "moon.crescent" , False , "\127769" )
  , ( "moon.full" , False , "\127765" )
  , ( "moon.full.face" , False , "\127773" )
  , ( "moon.new" , False , "\127761" )
  , ( "moon.new.face" , False , "\127770" )
  , ( "moon.wane.one" , False , "\127766" )
  , ( "moon.wane.two" , False , "\127767" )
  , ( "moon.wane.three.face" , False , "\127772" )
  , ( "moon.wane.three" , False , "\127768" )
  , ( "moon.wax.one" , False , "\127762" )
  , ( "moon.wax.two" , False , "\127763" )
  , ( "moon.wax.two.face" , False , "\127771" )
  , ( "moon.wax.three" , False , "\127764" )
  , ( "mortarboard" , False , "\127891" )
  , ( "mosque" , False , "\128332" )
  , ( "mosquito" , False , "\129439" )
  , ( "motorcycle" , False , "\127949" )
  , ( "motorway" , False , "\128739" )
  , ( "mountain" , False , "\9968" )
  , ( "mountain.fuji" , False , "\128507" )
  , ( "mountain.snow" , False , "\127956" )
  , ( "mountain.sunrise" , False , "\127748" )
  , ( "mouse" , False , "\128001" )
  , ( "mouse.face" , False , "\128045" )
  , ( "mousetrap" , False , "\129700" )
  , ( "mouth" , False , "\128068" )
  , ( "mouth.bite" , False , "\129766" )
  , ( "moyai" , False , "\128511" )
  , ( "muryo" , False , "\127514" )
  , ( "museum" , False , "\127963" )
  , ( "mushroom" , False , "\127812" )
  , ( "musicalscore" , False , "\127932" )
  , ( "nails.polish" , False , "\128133" )
  , ( "namebadge" , False , "\128219" )
  , ( "nazar" , False , "\129535" )
  , ( "necktie" , False , "\128084" )
  , ( "needle" , False , "\129697" )
  , ( "nest.empty" , False , "\129721" )
  , ( "nest.eggs" , False , "\129722" )
  , ( "new" , False , "\127381" )
  , ( "newspaper" , False , "\128240" )
  , ( "newspaper.rolled" , False , "\128478" )
  , ( "ng" , False , "\127382" )
  , ( "ningyo" , False , "\127886" )
  , ( "ninja" , False , "\129399" )
  , ( "noentry" , False , "\9940" )
  , ( "nose" , False , "\128067" )
  , ( "notebook" , False , "\128211" )
  , ( "notebook.deco" , False , "\128212" )
  , ( "notepad" , False , "\128466" )
  , ( "notes" , False , "\127925" )
  , ( "notes.triple" , False , "\127926" )
  , ( "numbers" , False , "\128290" )
  , ( "o" , False , "\127358" )
  , ( "octopus" , False , "\128025" )
  , ( "office" , False , "\127970" )
  , ( "oil" , False , "\128738" )
  , ( "ok" , False , "\127383" )
  , ( "olive" , False , "\129746" )
  , ( "oni" , False , "\128121" )
  , ( "onion" , False , "\129477" )
  , ( "orangutan" , False , "\129447" )
  , ( "otter" , False , "\129446" )
  , ( "owl" , False , "\129417" )
  , ( "ox" , False , "\128002" )
  , ( "oyster" , False , "\129450" )
  , ( "package" , False , "\128230" )
  , ( "paella" , False , "\129368" )
  , ( "page" , False , "\128196" )
  , ( "page.curl" , False , "\128195" )
  , ( "page.pencil" , False , "\128221" )
  , ( "pager" , False , "\128223" )
  , ( "pages.tabs" , False , "\128209" )
  , ( "painting" , False , "\128444" )
  , ( "palette" , False , "\127912" )
  , ( "pancakes" , False , "\129374" )
  , ( "panda" , False , "\128060" )
  , ( "parachute" , False , "\129666" )
  , ( "park" , False , "\127966" )
  , ( "parking" , False , "\127359" )
  , ( "parrot" , False , "\129436" )
  , ( "partalteration" , False , "\12349" )
  , ( "party" , False , "\127881" )
  , ( "peach" , False , "\127825" )
  , ( "peacock" , False , "\129434" )
  , ( "peanuts" , False , "\129372" )
  , ( "pear" , False , "\127824" )
  , ( "pedestrian" , False , "\128694" )
  , ( "pedestrian.not" , False , "\128695" )
  , ( "pen.ball" , False , "\128394" )
  , ( "pen.fountain" , False , "\128395" )
  , ( "pencil" , False , "\9999" )
  , ( "penguin" , False , "\128039" )
  , ( "pepper" , False , "\129745" )
  , ( "pepper.hot" , False , "\127798" )
  , ( "person" , False , "\129489" )
  , ( "person.angry" , False , "\128590" )
  , ( "person.beard" , False , "\129492" )
  , ( "person.blonde" , False , "\128113" )
  , ( "person.bow" , False , "\128583" )
  , ( "person.crown" , False , "\129733" )
  , ( "person.deaf" , False , "\129487" )
  , ( "person.facepalm" , False , "\129318" )
  , ( "person.frown" , False , "\128589" )
  , ( "person.hijab" , False , "\129493" )
  , ( "person.kneel" , False , "\129486" )
  , ( "person.lotus" , False , "\129496" )
  , ( "person.massage" , False , "\128134" )
  , ( "person.no" , False , "\128581" )
  , ( "person.ok" , False , "\128582" )
  , ( "person.old" , False , "\129491" )
  , ( "person.pregnant" , False , "\129732" )
  , ( "person.raise" , False , "\128587" )
  , ( "person.sassy" , False , "\128129" )
  , ( "person.shrug" , False , "\129335" )
  , ( "person.stand" , False , "\129485" )
  , ( "person.steam" , False , "\129494" )
  , ( "petri" , False , "\129515" )
  , ( "phone" , False , "\128241" )
  , ( "phone.arrow" , False , "\128242" )
  , ( "phone.classic" , False , "\9742" )
  , ( "phone.not" , False , "\128245" )
  , ( "phone.off" , False , "\128244" )
  , ( "phone.receiver" , False , "\128222" )
  , ( "phone.signal" , False , "\128246" )
  , ( "phone.vibrate" , False , "\128243" )
  , ( "piano" , False , "\127929" )
  , ( "pick" , False , "\9935" )
  , ( "pie" , False , "\129383" )
  , ( "pig" , False , "\128022" )
  , ( "pig.face" , False , "\128055" )
  , ( "pig.nose" , False , "\128061" )
  , ( "pill" , False , "\128138" )
  , ( "pin" , False , "\128204" )
  , ( "pin.round" , False , "\128205" )
  , ( "pinata" , False , "\129669" )
  , ( "pineapple" , False , "\127821" )
  , ( "pingpong" , False , "\127955" )
  , ( "pistol" , False , "\128299" )
  , ( "pizza" , False , "\127829" )
  , ( "placard" , False , "\129703" )
  , ( "planet" , False , "\129680" )
  , ( "plant" , False , "\129716" )
  , ( "plaster" , False , "\129657" )
  , ( "plate.cutlery" , False , "\127869" )
  , ( "playback.down" , False , "\9196" )
  , ( "playback.eject" , False , "\9167" )
  , ( "playback.forward" , False , "\9193" )
  , ( "playback.pause" , False , "\9208" )
  , ( "playback.record" , False , "\9210" )
  , ( "playback.repeat" , False , "\128257" )
  , ( "playback.repeat.once" , False , "\128258" )
  , ( "playback.repeat.v" , False , "\128259" )
  , ( "playback.restart" , False , "\9198" )
  , ( "playback.rewind" , False , "\9194" )
  , ( "playback.shuffle" , False , "\128256" )
  , ( "playback.skip" , False , "\9197" )
  , ( "playback.stop" , False , "\9209" )
  , ( "playback.toggle" , False , "\9199" )
  , ( "playback.up" , False , "\9195" )
  , ( "playingcard.flower" , False , "\127924" )
  , ( "playingcard.joker" , False , "\127183" )
  , ( "plunger" , False , "\129696" )
  , ( "policeofficer" , False , "\128110" )
  , ( "poo" , False , "\128169" )
  , ( "popcorn" , False , "\127871" )
  , ( "post.eu" , False , "\127972" )
  , ( "post.jp" , False , "\127971" )
  , ( "postbox" , False , "\128238" )
  , ( "potato" , False , "\129364" )
  , ( "potato.sweet" , False , "\127840" )
  , ( "pouch" , False , "\128093" )
  , ( "powerplug" , False , "\128268" )
  , ( "present" , False , "\127873" )
  , ( "pretzel" , False , "\129384" )
  , ( "printer" , False , "\128424" )
  , ( "prints.foot" , False , "\128099" )
  , ( "prints.paw" , False , "\128062" )
  , ( "prohibited" , False , "\128683" )
  , ( "projector" , False , "\128253" )
  , ( "pumpkin.lantern" , False , "\127875" )
  , ( "purse" , False , "\128091" )
  , ( "quest" , False , "\10067" )
  , ( "quest.white" , False , "\10068" )
  , ( "rabbit" , False , "\128007" )
  , ( "rabbit.face" , False , "\128048" )
  , ( "raccoon" , False , "\129437" )
  , ( "radio" , False , "\128251" )
  , ( "radioactive" , False , "\9762" )
  , ( "railway" , False , "\128740" )
  , ( "rainbow" , False , "\127752" )
  , ( "ram" , False , "\128015" )
  , ( "rat" , False , "\128000" )
  , ( "razor" , False , "\129682" )
  , ( "receipt" , False , "\129534" )
  , ( "recycling" , False , "\9851" )
  , ( "reg" , False , "\174" )
  , ( "restroom" , False , "\128699" )
  , ( "rhino" , False , "\129423" )
  , ( "ribbon" , False , "\127872" )
  , ( "ribbon.remind" , False , "\127895" )
  , ( "rice" , False , "\127834" )
  , ( "rice.cracker" , False , "\127832" )
  , ( "rice.ear" , False , "\127806" )
  , ( "rice.onigiri" , False , "\127833" )
  , ( "ring" , False , "\128141" )
  , ( "ringbuoy" , False , "\128735" )
  , ( "robot" , False , "\129302" )
  , ( "rock" , False , "\129704" )
  , ( "rocket" , False , "\128640" )
  , ( "rollercoaster" , False , "\127906" )
  , ( "rosette" , False , "\127989" )
  , ( "rugby" , False , "\127945" )
  , ( "ruler" , False , "\128207" )
  , ( "ruler.triangle" , False , "\128208" )
  , ( "running" , False , "\127939" )
  , ( "sa" , False , "\127490" )
  , ( "safetypin" , False , "\129527" )
  , ( "safetyvest" , False , "\129466" )
  , ( "sake" , False , "\127862" )
  , ( "salad" , False , "\129367" )
  , ( "salt" , False , "\129474" )
  , ( "sandwich" , False , "\129386" )
  , ( "santa.man" , False , "\127877" )
  , ( "santa.woman" , False , "\129334" )
  , ( "satdish" , False , "\128225" )
  , ( "satellite" , False , "\128752" )
  , ( "saw" , False , "\129690" )
  , ( "saxophone" , False , "\127927" )
  , ( "scales" , False , "\9878" )
  , ( "scarf" , False , "\129507" )
  , ( "school" , False , "\127979" )
  , ( "scissors" , False , "\9986" )
  , ( "scooter" , False , "\128756" )
  , ( "scooter.motor" , False , "\128757" )
  , ( "scorpion" , False , "\129410" )
  , ( "screwdriver" , False , "\129691" )
  , ( "scroll" , False , "\128220" )
  , ( "seal" , False , "\129453" )
  , ( "seat" , False , "\128186" )
  , ( "seedling" , False , "\127793" )
  , ( "shark" , False , "\129416" )
  , ( "sheep" , False , "\128017" )
  , ( "shell.spiral" , False , "\128026" )
  , ( "shield" , False , "\128737" )
  , ( "shin" , False , "\127544" )
  , ( "ship" , False , "\128674" )
  , ( "ship.cruise" , False , "\128755" )
  , ( "ship.ferry" , False , "\9972" )
  , ( "shirt.sports" , False , "\127933" )
  , ( "shirt.t" , False , "\128085" )
  , ( "shoe" , False , "\128094" )
  , ( "shoe.ballet" , False , "\129648" )
  , ( "shoe.flat" , False , "\129407" )
  , ( "shoe.heel" , False , "\128096" )
  , ( "shoe.hike" , False , "\129406" )
  , ( "shoe.ice" , False , "\9976" )
  , ( "shoe.roller" , False , "\128764" )
  , ( "shoe.sandal.heel" , False , "\128097" )
  , ( "shoe.ski" , False , "\127935" )
  , ( "shoe.sneaker" , False , "\128095" )
  , ( "shoe.tall" , False , "\128098" )
  , ( "shoe.thong" , False , "\129652" )
  , ( "shopping" , False , "\128717" )
  , ( "shorts" , False , "\129651" )
  , ( "shoshinsha" , False , "\128304" )
  , ( "shovel" , False , "\129679" )
  , ( "shower" , False , "\128703" )
  , ( "shrimp" , False , "\129424" )
  , ( "shrimp.fried" , False , "\127844" )
  , ( "shrine" , False , "\9961" )
  , ( "shuku" , False , "\12951" )
  , ( "sign.crossing" , False , "\128696" )
  , ( "sign.stop" , False , "\128721" )
  , ( "silhouette" , False , "\128100" )
  , ( "silhouette.double" , False , "\128101" )
  , ( "silhouette.hug" , False , "\129730" )
  , ( "silhouette.speak" , False , "\128483" )
  , ( "siren" , False , "\128680" )
  , ( "skateboard" , False , "\128761" )
  , ( "skewer.dango" , False , "\127841" )
  , ( "skewer.oden" , False , "\127842" )
  , ( "skiing" , False , "\9975" )
  , ( "skull" , False , "\128128" )
  , ( "skull.bones" , False , "\9760" )
  , ( "skunk" , False , "\129448" )
  , ( "sled" , False , "\128759" )
  , ( "slide" , False , "\128733" )
  , ( "slider" , False , "\127898" )
  , ( "sloth" , False , "\129445" )
  , ( "slots" , False , "\127920" )
  , ( "snail" , False , "\128012" )
  , ( "snake" , False , "\128013" )
  , ( "snowboarding" , False , "\127938" )
  , ( "snowflake" , False , "\10052" )
  , ( "snowman" , False , "\9924" )
  , ( "snowman.snow" , False , "\9731" )
  , ( "soap" , False , "\129532" )
  , ( "socks" , False , "\129510" )
  , ( "softball" , False , "\129358" )
  , ( "sos" , False , "\127384" )
  , ( "soup" , False , "\127858" )
  , ( "spaghetti" , False , "\127837" )
  , ( "sparkle.box" , False , "\10055" )
  , ( "sparkler" , False , "\127879" )
  , ( "sparkles" , False , "\10024" )
  , ( "speaker" , False , "\128264" )
  , ( "speaker.not" , False , "\128263" )
  , ( "speaker.wave" , False , "\128265" )
  , ( "speaker.waves" , False , "\128266" )
  , ( "spider" , False , "\128375" )
  , ( "spiderweb" , False , "\128376" )
  , ( "spinach" , False , "\129388" )
  , ( "splatter" , False , "\129759" )
  , ( "sponge" , False , "\129533" )
  , ( "spoon" , False , "\129348" )
  , ( "square.black" , False , "\11035" )
  , ( "square.black.tiny" , False , "\9642" )
  , ( "square.black.small" , False , "\9726" )
  , ( "square.black.medium" , False , "\9724" )
  , ( "square.white" , False , "\11036" )
  , ( "square.white.tiny" , False , "\9643" )
  , ( "square.white.small" , False , "\9725" )
  , ( "square.white.medium" , False , "\9723" )
  , ( "square.blue" , False , "\128998" )
  , ( "square.brown" , False , "\129003" )
  , ( "square.green" , False , "\129001" )
  , ( "square.orange" , False , "\128999" )
  , ( "square.purple" , False , "\129002" )
  , ( "square.red" , False , "\128997" )
  , ( "square.yellow" , False , "\129000" )
  , ( "squid" , False , "\129425" )
  , ( "stadium" , False , "\127967" )
  , ( "star" , False , "\11088" )
  , ( "star.arc" , False , "\128171" )
  , ( "star.box" , False , "\10036" )
  , ( "star.glow" , False , "\127775" )
  , ( "star.shoot" , False , "\127776" )
  , ( "stethoscope" , False , "\129658" )
  , ( "store.big" , False , "\127980" )
  , ( "store.small" , False , "\127978" )
  , ( "strawberry" , False , "\127827" )
  , ( "suit.club" , False , "\9827" )
  , ( "suit.diamond" , False , "\9830" )
  , ( "suit.heart" , False , "\9829" )
  , ( "suit.spade" , False , "\9824" )
  , ( "sun" , False , "\9728" )
  , ( "sun.cloud" , False , "\127780" )
  , ( "sun.face" , False , "\127774" )
  , ( "sunrise" , False , "\127749" )
  , ( "superhero" , False , "\129464" )
  , ( "supervillain" , False , "\129465" )
  , ( "surfing" , False , "\127940" )
  , ( "sushi" , False , "\127843" )
  , ( "swan" , False , "\129442" )
  , ( "swimming" , False , "\127946" )
  , ( "swimsuit" , False , "\129649" )
  , ( "swords" , False , "\9876" )
  , ( "symbols" , False , "\128291" )
  , ( "synagogue" , False , "\128333" )
  , ( "syringe" , False , "\128137" )
  , ( "taco" , False , "\127790" )
  , ( "takeout" , False , "\129377" )
  , ( "tamale" , False , "\129748" )
  , ( "tanabata" , False , "\127883" )
  , ( "tangerine" , False , "\127818" )
  , ( "tap" , False , "\128688" )
  , ( "tap.not" , False , "\128689" )
  , ( "taxi" , False , "\128661" )
  , ( "taxi.front" , False , "\128662" )
  , ( "teacup" , False , "\127861" )
  , ( "teapot" , False , "\129750" )
  , ( "teddy" , False , "\129528" )
  , ( "telescope" , False , "\128301" )
  , ( "temple" , False , "\128725" )
  , ( "ten" , False , "\128287" )
  , ( "tengu" , False , "\128122" )
  , ( "tennis" , False , "\127934" )
  , ( "tent" , False , "\9978" )
  , ( "testtube" , False , "\129514" )
  , ( "thermometer" , False , "\127777" )
  , ( "thread" , False , "\129525" )
  , ( "thumb.up" , False , "\128077" )
  , ( "thumb.down" , False , "\128078" )
  , ( "ticket.event" , False , "\127903" )
  , ( "ticket.travel" , False , "\127915" )
  , ( "tiger" , False , "\128005" )
  , ( "tiger.face" , False , "\128047" )
  , ( "tm" , False , "\8482" )
  , ( "toilet" , False , "\128701" )
  , ( "toiletpaper" , False , "\129531" )
  , ( "toku" , False , "\127568" )
  , ( "tomato" , False , "\127813" )
  , ( "tombstone" , False , "\129702" )
  , ( "tongue" , False , "\128069" )
  , ( "toolbox" , False , "\129520" )
  , ( "tooth" , False , "\129463" )
  , ( "toothbrush" , False , "\129701" )
  , ( "tornado" , False , "\127786" )
  , ( "tower.tokyo" , False , "\128508" )
  , ( "trackball" , False , "\128434" )
  , ( "tractor" , False , "\128668" )
  , ( "trafficlight.v" , False , "\128678" )
  , ( "trafficlight.h" , False , "\128677" )
  , ( "train" , False , "\128646" )
  , ( "train.car" , False , "\128643" )
  , ( "train.light" , False , "\128648" )
  , ( "train.metro" , False , "\128647" )
  , ( "train.mono" , False , "\128669" )
  , ( "train.mountain" , False , "\128670" )
  , ( "train.speed" , False , "\128644" )
  , ( "train.speed.bullet" , False , "\128645" )
  , ( "train.steam" , False , "\128642" )
  , ( "train.stop" , False , "\128649" )
  , ( "train.suspend" , False , "\128671" )
  , ( "train.tram" , False , "\128650" )
  , ( "train.tram.car" , False , "\128651" )
  , ( "transgender" , False , "\9895" )
  , ( "tray.inbox" , False , "\128229" )
  , ( "tray.mail" , False , "\128232" )
  , ( "tray.outbox" , False , "\128228" )
  , ( "tree.deciduous" , False , "\127795" )
  , ( "tree.evergreen" , False , "\127794" )
  , ( "tree.leafless" , False , "\129726" )
  , ( "tree.palm" , False , "\127796" )
  , ( "tree.xmas" , False , "\127876" )
  , ( "triangle.r" , False , "\9654" )
  , ( "triangle.l" , False , "\9664" )
  , ( "triangle.t" , False , "\128316" )
  , ( "triangle.b" , False , "\128317" )
  , ( "triangle.t.red" , False , "\128314" )
  , ( "triangle.b.red" , False , "\128315" )
  , ( "trident" , False , "\128305" )
  , ( "troll" , False , "\129484" )
  , ( "trophy" , False , "\127942" )
  , ( "truck" , False , "\128666" )
  , ( "truck.trailer" , False , "\128667" )
  , ( "trumpet" , False , "\127930" )
  , ( "tsukimi" , False , "\127889" )
  , ( "turkey" , False , "\129411" )
  , ( "turtle" , False , "\128034" )
  , ( "tv" , False , "\128250" )
  , ( "ufo" , False , "\128760" )
  , ( "umbrella.open" , False , "\9730" )
  , ( "umbrella.closed" , False , "\127746" )
  , ( "umbrella.rain" , False , "\9748" )
  , ( "umbrella.sun" , False , "\9969" )
  , ( "unicorn" , False , "\129412" )
  , ( "unknown" , False , "\129459" )
  , ( "up" , False , "\127385" )
  , ( "urn" , False , "\9905" )
  , ( "vampire" , False , "\129499" )
  , ( "violin" , False , "\127931" )
  , ( "volcano" , False , "\127755" )
  , ( "volleyball" , False , "\127952" )
  , ( "vs" , False , "\127386" )
  , ( "waffle" , False , "\129479" )
  , ( "wand" , False , "\129668" )
  , ( "warning" , False , "\9888" )
  , ( "watch" , False , "\8986" )
  , ( "watch.stop" , False , "\9201" )
  , ( "watermelon" , False , "\127817" )
  , ( "waterpolo" , False , "\129341" )
  , ( "wave" , False , "\127754" )
  , ( "wc" , False , "\128702" )
  , ( "weightlifting" , False , "\127947" )
  , ( "whale" , False , "\128011" )
  , ( "whale.spout" , False , "\128051" )
  , ( "wheel" , False , "\128734" )
  , ( "wheelchair" , False , "\129469" )
  , ( "wheelchair.box" , False , "\9855" )
  , ( "wheelchair.motor" , False , "\129468" )
  , ( "wind" , False , "\127788" )
  , ( "windchime" , False , "\127888" )
  , ( "window" , False , "\129695" )
  , ( "wine" , False , "\127863" )
  , ( "wolf" , False , "\128058" )
  , ( "woman" , False , "\128105" )
  , ( "woman.box" , False , "\128698" )
  , ( "woman.crown" , False , "\128120" )
  , ( "woman.old" , False , "\128117" )
  , ( "woman.pregnant" , False , "\129328" )
  , ( "wood" , False , "\129717" )
  , ( "worm" , False , "\129713" )
  , ( "wrench" , False , "\128295" )
  , ( "wrestling" , False , "\129340" )
  , ( "xray" , False , "\129659" )
  , ( "yarn" , False , "\129526" )
  , ( "yo" , False , "\127546" )
  , ( "yoyo" , False , "\129664" )
  , ( "yubi" , False , "\127535" )
  , ( "yuryo" , False , "\127542" )
  , ( "zebra" , False , "\129427" )
  , ( "zodiac.aquarius" , False , "\9810" )
  , ( "zodiac.aries" , False , "\9800" )
  , ( "zodiac.cancer" , False , "\9803" )
  , ( "zodiac.capri" , False , "\9809" )
  , ( "zodiac.gemini" , False , "\9802" )
  , ( "zodiac.leo" , False , "\9804" )
  , ( "zodiac.libra" , False , "\9806" )
  , ( "zodiac.ophi" , False , "\9934" )
  , ( "zodiac.pisces" , False , "\9811" )
  , ( "zodiac.sagit" , False , "\9808" )
  , ( "zodiac.scorpio" , False , "\9807" )
  , ( "zodiac.taurus" , False , "\9801" )
  , ( "zodiac.virgo" , False , "\9805" )
  , ( "zombie" , False , "\129503" )
  , ( "zzz" , False , "\128164" )
  ]
