/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	_context "context"
	"fmt"
	"io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// FirewallRulesApiService FirewallRulesApi service
type FirewallRulesApiService service

type ApiDatacentersServersNicsFirewallrulesDeleteRequest struct {
	ctx             _context.Context
	ApiService      *FirewallRulesApiService
	datacenterId    string
	serverId        string
	nicId           string
	firewallruleId  string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesDeleteExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesDelete Delete firewall rules
 * Delete the specified firewall rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param serverId The unique ID of the server.
 * @param nicId The unique ID of the NIC.
 * @param firewallruleId The unique ID of the firewall rule.
 * @return ApiDatacentersServersNicsFirewallrulesDeleteRequest
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesDelete(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	return ApiDatacentersServersNicsFirewallrulesDeleteRequest{
		ApiService:     a,
		ctx:            ctx,
		datacenterId:   datacenterId,
		serverId:       serverId,
		nicId:          nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesDeleteExecute(r ApiDatacentersServersNicsFirewallrulesDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FirewallRulesApiService.DatacentersServersNicsFirewallrulesDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersServersNicsFirewallrulesDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesFindByIdRequest struct {
	ctx             _context.Context
	ApiService      *FirewallRulesApiService
	datacenterId    string
	serverId        string
	nicId           string
	firewallruleId  string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesFindByIdExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesFindById Retrieve firewall rules
 * Retrieve the properties of the specified firewall rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param serverId The unique ID of the server.
 * @param nicId The unique ID of the NIC.
 * @param firewallruleId The unique ID of the firewall rule.
 * @return ApiDatacentersServersNicsFirewallrulesFindByIdRequest
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesFindById(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	return ApiDatacentersServersNicsFirewallrulesFindByIdRequest{
		ApiService:     a,
		ctx:            ctx,
		datacenterId:   datacenterId,
		serverId:       serverId,
		nicId:          nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesFindByIdExecute(r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FirewallRulesApiService.DatacentersServersNicsFirewallrulesFindById")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersServersNicsFirewallrulesFindById",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesGetRequest struct {
	ctx             _context.Context
	ApiService      *FirewallRulesApiService
	filters         _neturl.Values
	orderBy         *string
	maxResults      *int32
	datacenterId    string
	serverId        string
	nicId           string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
	offset          *int32
	limit           *int32
}

func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Offset(offset int32) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.offset = &offset
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Limit(limit int32) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.limit = &limit
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Filter(key string, value string) ApiDatacentersServersNicsFirewallrulesGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = append(r.filters[filterKey], value)
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) OrderBy(orderBy string) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) MaxResults(maxResults int32) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Execute() (FirewallRules, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesGetExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesGet List firewall rules
 * List all firewall rules for the specified NIC.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param serverId The unique ID of the server.
 * @param nicId The unique ID of the NIC.
 * @return ApiDatacentersServersNicsFirewallrulesGetRequest
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesGet(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsFirewallrulesGetRequest {
	return ApiDatacentersServersNicsFirewallrulesGetRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		serverId:     serverId,
		nicId:        nicId,
		filters:      _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return FirewallRules
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesGetExecute(r ApiDatacentersServersNicsFirewallrulesGetRequest) (FirewallRules, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRules
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FirewallRulesApiService.DatacentersServersNicsFirewallrulesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("offset")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("offset", parameterToString(0, ""))
		}
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("limit")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("limit", parameterToString(1000, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersServersNicsFirewallrulesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesPatchRequest struct {
	ctx             _context.Context
	ApiService      *FirewallRulesApiService
	datacenterId    string
	serverId        string
	nicId           string
	firewallruleId  string
	firewallrule    *FirewallruleProperties
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Firewallrule(firewallrule FirewallruleProperties) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.firewallrule = &firewallrule
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesPatchExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesPatch Partially modify firewall rules
 * Update the properties of the specified firewall rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param serverId The unique ID of the server.
 * @param nicId The unique ID of the NIC.
 * @param firewallruleId The unique ID of the firewall rule.
 * @return ApiDatacentersServersNicsFirewallrulesPatchRequest
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesPatch(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	return ApiDatacentersServersNicsFirewallrulesPatchRequest{
		ApiService:     a,
		ctx:            ctx,
		datacenterId:   datacenterId,
		serverId:       serverId,
		nicId:          nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesPatchExecute(r ApiDatacentersServersNicsFirewallrulesPatchRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FirewallRulesApiService.DatacentersServersNicsFirewallrulesPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.firewallrule == nil {
		return localVarReturnValue, nil, reportError("firewallrule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.firewallrule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersServersNicsFirewallrulesPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesPostRequest struct {
	ctx             _context.Context
	ApiService      *FirewallRulesApiService
	datacenterId    string
	serverId        string
	nicId           string
	firewallrule    *FirewallRule
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Firewallrule(firewallrule FirewallRule) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.firewallrule = &firewallrule
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesPostExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesPost Create a Firewall Rule
 * Creates a firewall rule for the specified NIC.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param serverId The unique ID of the server.
 * @param nicId The unique ID of the NIC.
 * @return ApiDatacentersServersNicsFirewallrulesPostRequest
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesPost(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsFirewallrulesPostRequest {
	return ApiDatacentersServersNicsFirewallrulesPostRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		serverId:     serverId,
		nicId:        nicId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesPostExecute(r ApiDatacentersServersNicsFirewallrulesPostRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FirewallRulesApiService.DatacentersServersNicsFirewallrulesPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.firewallrule == nil {
		return localVarReturnValue, nil, reportError("firewallrule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.firewallrule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersServersNicsFirewallrulesPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesPutRequest struct {
	ctx             _context.Context
	ApiService      *FirewallRulesApiService
	datacenterId    string
	serverId        string
	nicId           string
	firewallruleId  string
	firewallrule    *FirewallRule
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Firewallrule(firewallrule FirewallRule) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.firewallrule = &firewallrule
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesPutExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesPut Modify a Firewall Rule
 * Modifies the properties of the specified firewall rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param serverId The unique ID of the server.
 * @param nicId The unique ID of the NIC.
 * @param firewallruleId The unique ID of the firewall rule.
 * @return ApiDatacentersServersNicsFirewallrulesPutRequest
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesPut(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesPutRequest {
	return ApiDatacentersServersNicsFirewallrulesPutRequest{
		ApiService:     a,
		ctx:            ctx,
		datacenterId:   datacenterId,
		serverId:       serverId,
		nicId:          nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *FirewallRulesApiService) DatacentersServersNicsFirewallrulesPutExecute(r ApiDatacentersServersNicsFirewallrulesPutRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FirewallRulesApiService.DatacentersServersNicsFirewallrulesPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.firewallrule == nil {
		return localVarReturnValue, nil, reportError("firewallrule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.firewallrule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersServersNicsFirewallrulesPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
