// Copyright 2019 Google Inc. Use of this source code is governed by an
// MIT-style license that can be found in the LICENSE file or at
// https://opensource.org/licenses/MIT.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.14.0
// source: embedded_sass.proto

package embeddedsass

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible syntaxes for a Sass stylesheet.
type InboundMessage_Syntax int32

const (
	// The CSS-superset `.scss` syntax.
	InboundMessage_SCSS InboundMessage_Syntax = 0
	// The indented `.sass` syntax.
	InboundMessage_INDENTED InboundMessage_Syntax = 1
	// Plain CSS syntax that doesn't support any special Sass features.
	InboundMessage_CSS InboundMessage_Syntax = 2
)

// Enum value maps for InboundMessage_Syntax.
var (
	InboundMessage_Syntax_name = map[int32]string{
		0: "SCSS",
		1: "INDENTED",
		2: "CSS",
	}
	InboundMessage_Syntax_value = map[string]int32{
		"SCSS":     0,
		"INDENTED": 1,
		"CSS":      2,
	}
)

func (x InboundMessage_Syntax) Enum() *InboundMessage_Syntax {
	p := new(InboundMessage_Syntax)
	*p = x
	return p
}

func (x InboundMessage_Syntax) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InboundMessage_Syntax) Descriptor() protoreflect.EnumDescriptor {
	return file_embedded_sass_proto_enumTypes[0].Descriptor()
}

func (InboundMessage_Syntax) Type() protoreflect.EnumType {
	return &file_embedded_sass_proto_enumTypes[0]
}

func (x InboundMessage_Syntax) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InboundMessage_Syntax.Descriptor instead.
func (InboundMessage_Syntax) EnumDescriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 0}
}

// Possible ways to format the CSS output. The compiler is not required to
// support all possible options; if the host requests an unsupported style,
// the compiler should choose the closest supported style.
type InboundMessage_CompileRequest_OutputStyle int32

const (
	// Each selector and declaration is written on its own line.
	InboundMessage_CompileRequest_EXPANDED InboundMessage_CompileRequest_OutputStyle = 0
	// The entire stylesheet is written on a single line, with as few
	// characters as possible.
	InboundMessage_CompileRequest_COMPRESSED InboundMessage_CompileRequest_OutputStyle = 1
	// CSS rules and declarations are indented to match the nesting of the
	// Sass source.
	InboundMessage_CompileRequest_NESTED InboundMessage_CompileRequest_OutputStyle = 2
	// Each CSS rule is written on its own single line, along with all its
	// declarations.
	InboundMessage_CompileRequest_COMPACT InboundMessage_CompileRequest_OutputStyle = 3
)

// Enum value maps for InboundMessage_CompileRequest_OutputStyle.
var (
	InboundMessage_CompileRequest_OutputStyle_name = map[int32]string{
		0: "EXPANDED",
		1: "COMPRESSED",
		2: "NESTED",
		3: "COMPACT",
	}
	InboundMessage_CompileRequest_OutputStyle_value = map[string]int32{
		"EXPANDED":   0,
		"COMPRESSED": 1,
		"NESTED":     2,
		"COMPACT":    3,
	}
)

func (x InboundMessage_CompileRequest_OutputStyle) Enum() *InboundMessage_CompileRequest_OutputStyle {
	p := new(InboundMessage_CompileRequest_OutputStyle)
	*p = x
	return p
}

func (x InboundMessage_CompileRequest_OutputStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InboundMessage_CompileRequest_OutputStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_embedded_sass_proto_enumTypes[1].Descriptor()
}

func (InboundMessage_CompileRequest_OutputStyle) Type() protoreflect.EnumType {
	return &file_embedded_sass_proto_enumTypes[1]
}

func (x InboundMessage_CompileRequest_OutputStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InboundMessage_CompileRequest_OutputStyle.Descriptor instead.
func (InboundMessage_CompileRequest_OutputStyle) EnumDescriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The type of message.
type OutboundMessage_LogEvent_Type int32

const (
	// A warning for something other than a deprecated Sass feature. Often
	// emitted due to a stylesheet using the `@warn` rule.
	OutboundMessage_LogEvent_WARNING OutboundMessage_LogEvent_Type = 0
	// A warning indicating that the stylesheet is using a deprecated Sass
	// feature. Compilers should not add text like "deprecation warning" to
	// deprecation warnings; it's up to the host to determine how to signal
	// that to the user.
	OutboundMessage_LogEvent_DEPRECATION_WARNING OutboundMessage_LogEvent_Type = 1
	// A message generated by the user for their own debugging purposes.
	OutboundMessage_LogEvent_DEBUG OutboundMessage_LogEvent_Type = 2
)

// Enum value maps for OutboundMessage_LogEvent_Type.
var (
	OutboundMessage_LogEvent_Type_name = map[int32]string{
		0: "WARNING",
		1: "DEPRECATION_WARNING",
		2: "DEBUG",
	}
	OutboundMessage_LogEvent_Type_value = map[string]int32{
		"WARNING":             0,
		"DEPRECATION_WARNING": 1,
		"DEBUG":               2,
	}
)

func (x OutboundMessage_LogEvent_Type) Enum() *OutboundMessage_LogEvent_Type {
	p := new(OutboundMessage_LogEvent_Type)
	*p = x
	return p
}

func (x OutboundMessage_LogEvent_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutboundMessage_LogEvent_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_embedded_sass_proto_enumTypes[2].Descriptor()
}

func (OutboundMessage_LogEvent_Type) Type() protoreflect.EnumType {
	return &file_embedded_sass_proto_enumTypes[2]
}

func (x OutboundMessage_LogEvent_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutboundMessage_LogEvent_Type.Descriptor instead.
func (OutboundMessage_LogEvent_Type) EnumDescriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 1, 0}
}

// Potential types of errors.
type ProtocolError_ErrorType int32

const (
	// A message was received that couldn't be decoded as an `InboundMessage`
	// (for the compiler) or `OutboundMessage` (for the host).
	ProtocolError_PARSE ProtocolError_ErrorType = 0
	// A message was received that violated a documented restriction, such as
	// not providing a mandatory field.
	ProtocolError_PARAMS ProtocolError_ErrorType = 1
	// Something unexpected went wrong within the endpoint.
	ProtocolError_INTERNAL ProtocolError_ErrorType = 2
)

// Enum value maps for ProtocolError_ErrorType.
var (
	ProtocolError_ErrorType_name = map[int32]string{
		0: "PARSE",
		1: "PARAMS",
		2: "INTERNAL",
	}
	ProtocolError_ErrorType_value = map[string]int32{
		"PARSE":    0,
		"PARAMS":   1,
		"INTERNAL": 2,
	}
)

func (x ProtocolError_ErrorType) Enum() *ProtocolError_ErrorType {
	p := new(ProtocolError_ErrorType)
	*p = x
	return p
}

func (x ProtocolError_ErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProtocolError_ErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_embedded_sass_proto_enumTypes[3].Descriptor()
}

func (ProtocolError_ErrorType) Type() protoreflect.EnumType {
	return &file_embedded_sass_proto_enumTypes[3]
}

func (x ProtocolError_ErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProtocolError_ErrorType.Descriptor instead.
func (ProtocolError_ErrorType) EnumDescriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{2, 0}
}

// Singleton SassScript values that have no internal state.
type Value_Singleton int32

const (
	// The SassScript boolean true value.
	Value_TRUE Value_Singleton = 0
	// The SassScript boolean false value.
	Value_FALSE Value_Singleton = 1
	// The SassScript null value.
	Value_NULL Value_Singleton = 2
)

// Enum value maps for Value_Singleton.
var (
	Value_Singleton_name = map[int32]string{
		0: "TRUE",
		1: "FALSE",
		2: "NULL",
	}
	Value_Singleton_value = map[string]int32{
		"TRUE":  0,
		"FALSE": 1,
		"NULL":  2,
	}
)

func (x Value_Singleton) Enum() *Value_Singleton {
	p := new(Value_Singleton)
	*p = x
	return p
}

func (x Value_Singleton) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Value_Singleton) Descriptor() protoreflect.EnumDescriptor {
	return file_embedded_sass_proto_enumTypes[4].Descriptor()
}

func (Value_Singleton) Type() protoreflect.EnumType {
	return &file_embedded_sass_proto_enumTypes[4]
}

func (x Value_Singleton) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Value_Singleton.Descriptor instead.
func (Value_Singleton) EnumDescriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 0}
}

// Different types of separators a list can have.
type Value_List_Separator int32

const (
	// List elements are separated by a comma.
	Value_List_COMMA Value_List_Separator = 0
	// List elements are separated by whitespace.
	Value_List_SPACE Value_List_Separator = 1
	// List elements are separated by a forward slash.
	Value_List_SLASH Value_List_Separator = 2
	// The list's separator hasn't yet been determined.
	//
	// Singleton lists and empty lists don't have separators defiend. This
	// means that list functions will prefer other lists' separators if
	// possible.
	Value_List_UNDECIDED Value_List_Separator = 3
)

// Enum value maps for Value_List_Separator.
var (
	Value_List_Separator_name = map[int32]string{
		0: "COMMA",
		1: "SPACE",
		2: "SLASH",
		3: "UNDECIDED",
	}
	Value_List_Separator_value = map[string]int32{
		"COMMA":     0,
		"SPACE":     1,
		"SLASH":     2,
		"UNDECIDED": 3,
	}
)

func (x Value_List_Separator) Enum() *Value_List_Separator {
	p := new(Value_List_Separator)
	*p = x
	return p
}

func (x Value_List_Separator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Value_List_Separator) Descriptor() protoreflect.EnumDescriptor {
	return file_embedded_sass_proto_enumTypes[5].Descriptor()
}

func (Value_List_Separator) Type() protoreflect.EnumType {
	return &file_embedded_sass_proto_enumTypes[5]
}

func (x Value_List_Separator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Value_List_Separator.Descriptor instead.
func (Value_List_Separator) EnumDescriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 4, 0}
}

// The wrapper type for all messages sent from the host to the compiler. This
// provides a `oneof` that makes it possible to determine the type of each
// inbound message.
type InboundMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The wrapped message. Mandatory.
	//
	// Types that are assignable to Message:
	//	*InboundMessage_CompileRequest_
	//	*InboundMessage_CanonicalizeResponse_
	//	*InboundMessage_ImportResponse_
	//	*InboundMessage_FileImportResponse_
	//	*InboundMessage_FunctionCallResponse_
	Message isInboundMessage_Message `protobuf_oneof:"message"`
}

func (x *InboundMessage) Reset() {
	*x = InboundMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage) ProtoMessage() {}

func (x *InboundMessage) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage.ProtoReflect.Descriptor instead.
func (*InboundMessage) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0}
}

func (m *InboundMessage) GetMessage() isInboundMessage_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *InboundMessage) GetCompileRequest() *InboundMessage_CompileRequest {
	if x, ok := x.GetMessage().(*InboundMessage_CompileRequest_); ok {
		return x.CompileRequest
	}
	return nil
}

func (x *InboundMessage) GetCanonicalizeResponse() *InboundMessage_CanonicalizeResponse {
	if x, ok := x.GetMessage().(*InboundMessage_CanonicalizeResponse_); ok {
		return x.CanonicalizeResponse
	}
	return nil
}

func (x *InboundMessage) GetImportResponse() *InboundMessage_ImportResponse {
	if x, ok := x.GetMessage().(*InboundMessage_ImportResponse_); ok {
		return x.ImportResponse
	}
	return nil
}

func (x *InboundMessage) GetFileImportResponse() *InboundMessage_FileImportResponse {
	if x, ok := x.GetMessage().(*InboundMessage_FileImportResponse_); ok {
		return x.FileImportResponse
	}
	return nil
}

func (x *InboundMessage) GetFunctionCallResponse() *InboundMessage_FunctionCallResponse {
	if x, ok := x.GetMessage().(*InboundMessage_FunctionCallResponse_); ok {
		return x.FunctionCallResponse
	}
	return nil
}

type isInboundMessage_Message interface {
	isInboundMessage_Message()
}

type InboundMessage_CompileRequest_ struct {
	CompileRequest *InboundMessage_CompileRequest `protobuf:"bytes,2,opt,name=compileRequest,proto3,oneof"`
}

type InboundMessage_CanonicalizeResponse_ struct {
	CanonicalizeResponse *InboundMessage_CanonicalizeResponse `protobuf:"bytes,3,opt,name=canonicalizeResponse,proto3,oneof"`
}

type InboundMessage_ImportResponse_ struct {
	ImportResponse *InboundMessage_ImportResponse `protobuf:"bytes,4,opt,name=importResponse,proto3,oneof"`
}

type InboundMessage_FileImportResponse_ struct {
	FileImportResponse *InboundMessage_FileImportResponse `protobuf:"bytes,5,opt,name=fileImportResponse,proto3,oneof"`
}

type InboundMessage_FunctionCallResponse_ struct {
	FunctionCallResponse *InboundMessage_FunctionCallResponse `protobuf:"bytes,6,opt,name=functionCallResponse,proto3,oneof"`
}

func (*InboundMessage_CompileRequest_) isInboundMessage_Message() {}

func (*InboundMessage_CanonicalizeResponse_) isInboundMessage_Message() {}

func (*InboundMessage_ImportResponse_) isInboundMessage_Message() {}

func (*InboundMessage_FileImportResponse_) isInboundMessage_Message() {}

func (*InboundMessage_FunctionCallResponse_) isInboundMessage_Message() {}

// The wrapper type for all messages sent from the compiler to the host. This
// provides a `oneof` that makes it possible to determine the type of each
// outbound message.
type OutboundMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The wrapped message. Mandatory.
	//
	// Types that are assignable to Message:
	//	*OutboundMessage_Error
	//	*OutboundMessage_CompileResponse_
	//	*OutboundMessage_LogEvent_
	//	*OutboundMessage_CanonicalizeRequest_
	//	*OutboundMessage_ImportRequest_
	//	*OutboundMessage_FileImportRequest_
	//	*OutboundMessage_FunctionCallRequest_
	Message isOutboundMessage_Message `protobuf_oneof:"message"`
}

func (x *OutboundMessage) Reset() {
	*x = OutboundMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage) ProtoMessage() {}

func (x *OutboundMessage) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage.ProtoReflect.Descriptor instead.
func (*OutboundMessage) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1}
}

func (m *OutboundMessage) GetMessage() isOutboundMessage_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *OutboundMessage) GetError() *ProtocolError {
	if x, ok := x.GetMessage().(*OutboundMessage_Error); ok {
		return x.Error
	}
	return nil
}

func (x *OutboundMessage) GetCompileResponse() *OutboundMessage_CompileResponse {
	if x, ok := x.GetMessage().(*OutboundMessage_CompileResponse_); ok {
		return x.CompileResponse
	}
	return nil
}

func (x *OutboundMessage) GetLogEvent() *OutboundMessage_LogEvent {
	if x, ok := x.GetMessage().(*OutboundMessage_LogEvent_); ok {
		return x.LogEvent
	}
	return nil
}

func (x *OutboundMessage) GetCanonicalizeRequest() *OutboundMessage_CanonicalizeRequest {
	if x, ok := x.GetMessage().(*OutboundMessage_CanonicalizeRequest_); ok {
		return x.CanonicalizeRequest
	}
	return nil
}

func (x *OutboundMessage) GetImportRequest() *OutboundMessage_ImportRequest {
	if x, ok := x.GetMessage().(*OutboundMessage_ImportRequest_); ok {
		return x.ImportRequest
	}
	return nil
}

func (x *OutboundMessage) GetFileImportRequest() *OutboundMessage_FileImportRequest {
	if x, ok := x.GetMessage().(*OutboundMessage_FileImportRequest_); ok {
		return x.FileImportRequest
	}
	return nil
}

func (x *OutboundMessage) GetFunctionCallRequest() *OutboundMessage_FunctionCallRequest {
	if x, ok := x.GetMessage().(*OutboundMessage_FunctionCallRequest_); ok {
		return x.FunctionCallRequest
	}
	return nil
}

type isOutboundMessage_Message interface {
	isOutboundMessage_Message()
}

type OutboundMessage_Error struct {
	Error *ProtocolError `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type OutboundMessage_CompileResponse_ struct {
	CompileResponse *OutboundMessage_CompileResponse `protobuf:"bytes,2,opt,name=compileResponse,proto3,oneof"`
}

type OutboundMessage_LogEvent_ struct {
	LogEvent *OutboundMessage_LogEvent `protobuf:"bytes,3,opt,name=logEvent,proto3,oneof"`
}

type OutboundMessage_CanonicalizeRequest_ struct {
	CanonicalizeRequest *OutboundMessage_CanonicalizeRequest `protobuf:"bytes,4,opt,name=canonicalizeRequest,proto3,oneof"`
}

type OutboundMessage_ImportRequest_ struct {
	ImportRequest *OutboundMessage_ImportRequest `protobuf:"bytes,5,opt,name=importRequest,proto3,oneof"`
}

type OutboundMessage_FileImportRequest_ struct {
	FileImportRequest *OutboundMessage_FileImportRequest `protobuf:"bytes,6,opt,name=fileImportRequest,proto3,oneof"`
}

type OutboundMessage_FunctionCallRequest_ struct {
	FunctionCallRequest *OutboundMessage_FunctionCallRequest `protobuf:"bytes,7,opt,name=functionCallRequest,proto3,oneof"`
}

func (*OutboundMessage_Error) isOutboundMessage_Message() {}

func (*OutboundMessage_CompileResponse_) isOutboundMessage_Message() {}

func (*OutboundMessage_LogEvent_) isOutboundMessage_Message() {}

func (*OutboundMessage_CanonicalizeRequest_) isOutboundMessage_Message() {}

func (*OutboundMessage_ImportRequest_) isOutboundMessage_Message() {}

func (*OutboundMessage_FileImportRequest_) isOutboundMessage_Message() {}

func (*OutboundMessage_FunctionCallRequest_) isOutboundMessage_Message() {}

// An error reported when an endpoint violates the embedded Sass protocol.
type ProtocolError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type ProtocolError_ErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=sass.embedded_protocol.ProtocolError_ErrorType" json:"type,omitempty"`
	// The ID of the request that had an error. This MUST be `-1` if the request
	// ID couldn't be determined, or if the error is being reported for a response
	// or an event.
	Id int32 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// A human-readable message providing more detail about the error.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *ProtocolError) Reset() {
	*x = ProtocolError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProtocolError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProtocolError) ProtoMessage() {}

func (x *ProtocolError) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProtocolError.ProtoReflect.Descriptor instead.
func (*ProtocolError) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{2}
}

func (x *ProtocolError) GetType() ProtocolError_ErrorType {
	if x != nil {
		return x.Type
	}
	return ProtocolError_PARSE
}

func (x *ProtocolError) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ProtocolError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// A chunk of a source file.
type SourceSpan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text covered by the source span. Compilers must guarantee that this is
	// the text between `start.offset` and `end.offset` in the source file
	// referred to by `url`.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The location of the first character in this span. Mandatory.
	Start *SourceSpan_SourceLocation `protobuf:"bytes,2,opt,name=start,proto3" json:"start,omitempty"`
	// The location of the first character after this span. Optional.
	//
	// If this is omitted, it indicates that the span is empty and points
	// immediately before `start`. In that case, `text` must be empty.
	//
	// This must not point to a location before `start`.
	End *SourceSpan_SourceLocation `protobuf:"bytes,3,opt,name=end,proto3" json:"end,omitempty"`
	// The URL of the file to which this span refers.
	//
	// This may be empty, indicating that the span refers to a
	// `CompileRequest.StringInput` file that doesn't specify a URL.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// Additional source text surrounding this span.
	//
	// If this isn't empty, it must contain `text`. Furthermore, `text` must begin
	// at column `start.column` of a line in `context`.
	//
	// This usually contains the full lines the span begins and ends on if the
	// span itself doesn't cover the full lines.
	Context string `protobuf:"bytes,5,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *SourceSpan) Reset() {
	*x = SourceSpan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceSpan) ProtoMessage() {}

func (x *SourceSpan) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceSpan.ProtoReflect.Descriptor instead.
func (*SourceSpan) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{3}
}

func (x *SourceSpan) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *SourceSpan) GetStart() *SourceSpan_SourceLocation {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *SourceSpan) GetEnd() *SourceSpan_SourceLocation {
	if x != nil {
		return x.End
	}
	return nil
}

func (x *SourceSpan) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *SourceSpan) GetContext() string {
	if x != nil {
		return x.Context
	}
	return ""
}

// A SassScript value, passed to and returned by functions.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value itself. Mandatory.
	//
	// This is wrapped in a message type rather than used directly to reduce
	// repetition, and because oneofs can't be repeated.
	//
	// Types that are assignable to Value:
	//	*Value_String_
	//	*Value_Number_
	//	*Value_RgbColor_
	//	*Value_HslColor_
	//	*Value_List_
	//	*Value_Map_
	//	*Value_Singleton_
	//	*Value_CompilerFunction_
	//	*Value_HostFunction_
	Value isValue_Value `protobuf_oneof:"value"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4}
}

func (m *Value) GetValue() isValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Value) GetString_() *Value_String {
	if x, ok := x.GetValue().(*Value_String_); ok {
		return x.String_
	}
	return nil
}

func (x *Value) GetNumber() *Value_Number {
	if x, ok := x.GetValue().(*Value_Number_); ok {
		return x.Number
	}
	return nil
}

func (x *Value) GetRgbColor() *Value_RgbColor {
	if x, ok := x.GetValue().(*Value_RgbColor_); ok {
		return x.RgbColor
	}
	return nil
}

func (x *Value) GetHslColor() *Value_HslColor {
	if x, ok := x.GetValue().(*Value_HslColor_); ok {
		return x.HslColor
	}
	return nil
}

func (x *Value) GetList() *Value_List {
	if x, ok := x.GetValue().(*Value_List_); ok {
		return x.List
	}
	return nil
}

func (x *Value) GetMap() *Value_Map {
	if x, ok := x.GetValue().(*Value_Map_); ok {
		return x.Map
	}
	return nil
}

func (x *Value) GetSingleton() Value_Singleton {
	if x, ok := x.GetValue().(*Value_Singleton_); ok {
		return x.Singleton
	}
	return Value_TRUE
}

func (x *Value) GetCompilerFunction() *Value_CompilerFunction {
	if x, ok := x.GetValue().(*Value_CompilerFunction_); ok {
		return x.CompilerFunction
	}
	return nil
}

func (x *Value) GetHostFunction() *Value_HostFunction {
	if x, ok := x.GetValue().(*Value_HostFunction_); ok {
		return x.HostFunction
	}
	return nil
}

type isValue_Value interface {
	isValue_Value()
}

type Value_String_ struct {
	String_ *Value_String `protobuf:"bytes,1,opt,name=string,proto3,oneof"`
}

type Value_Number_ struct {
	Number *Value_Number `protobuf:"bytes,2,opt,name=number,proto3,oneof"`
}

type Value_RgbColor_ struct {
	RgbColor *Value_RgbColor `protobuf:"bytes,3,opt,name=rgb_color,json=rgbColor,proto3,oneof"`
}

type Value_HslColor_ struct {
	HslColor *Value_HslColor `protobuf:"bytes,4,opt,name=hsl_color,json=hslColor,proto3,oneof"`
}

type Value_List_ struct {
	List *Value_List `protobuf:"bytes,5,opt,name=list,proto3,oneof"`
}

type Value_Map_ struct {
	Map *Value_Map `protobuf:"bytes,6,opt,name=map,proto3,oneof"`
}

type Value_Singleton_ struct {
	Singleton Value_Singleton `protobuf:"varint,7,opt,name=singleton,proto3,enum=sass.embedded_protocol.Value_Singleton,oneof"`
}

type Value_CompilerFunction_ struct {
	CompilerFunction *Value_CompilerFunction `protobuf:"bytes,8,opt,name=compiler_function,json=compilerFunction,proto3,oneof"`
}

type Value_HostFunction_ struct {
	HostFunction *Value_HostFunction `protobuf:"bytes,9,opt,name=host_function,json=hostFunction,proto3,oneof"`
}

func (*Value_String_) isValue_Value() {}

func (*Value_Number_) isValue_Value() {}

func (*Value_RgbColor_) isValue_Value() {}

func (*Value_HslColor_) isValue_Value() {}

func (*Value_List_) isValue_Value() {}

func (*Value_Map_) isValue_Value() {}

func (*Value_Singleton_) isValue_Value() {}

func (*Value_CompilerFunction_) isValue_Value() {}

func (*Value_HostFunction_) isValue_Value() {}

// A request that compiles an entrypoint to CSS.
type InboundMessage_CompileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This compilation's request id. This is included in messages sent from the
	// compiler to the host. Mandatory.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The input stylesheet to parse. Mandatory.
	//
	// Types that are assignable to Input:
	//	*InboundMessage_CompileRequest_String_
	//	*InboundMessage_CompileRequest_Path
	Input isInboundMessage_CompileRequest_Input `protobuf_oneof:"input"`
	// How to format the CSS output.
	Style InboundMessage_CompileRequest_OutputStyle `protobuf:"varint,4,opt,name=style,proto3,enum=sass.embedded_protocol.InboundMessage_CompileRequest_OutputStyle" json:"style,omitempty"`
	// Whether to generate a source map. Note that this will *not* add a source
	// map comment to the stylesheet; that's up to the host or its users.
	SourceMap bool `protobuf:"varint,5,opt,name=source_map,json=sourceMap,proto3" json:"source_map,omitempty"`
	// Importers (including load paths on the filesystem) to use when resolving
	// imports that can't be resolved relative to the file that contains it. Each
	// importer is checked in order until one recognizes the imported URL.
	Importers []*InboundMessage_CompileRequest_Importer `protobuf:"bytes,6,rep,name=importers,proto3" json:"importers,omitempty"`
	// Signatures for custom global functions whose behavior is defined by the
	// host. These must be valid Sass function signatures that could appear in
	// after `@function` in a Sass stylesheet, such as
	// `mix($color1, $color2, $weight: 50%)`.
	//
	// Compilers must ensure that pure-Sass functions take precedence over
	// custom global functions. They must also reject any custom function names
	// that conflict with function names built into the Sass language.
	GlobalFunctions []string `protobuf:"bytes,7,rep,name=global_functions,json=globalFunctions,proto3" json:"global_functions,omitempty"`
}

func (x *InboundMessage_CompileRequest) Reset() {
	*x = InboundMessage_CompileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_CompileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_CompileRequest) ProtoMessage() {}

func (x *InboundMessage_CompileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_CompileRequest.ProtoReflect.Descriptor instead.
func (*InboundMessage_CompileRequest) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 0}
}

func (x *InboundMessage_CompileRequest) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *InboundMessage_CompileRequest) GetInput() isInboundMessage_CompileRequest_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *InboundMessage_CompileRequest) GetString_() *InboundMessage_CompileRequest_StringInput {
	if x, ok := x.GetInput().(*InboundMessage_CompileRequest_String_); ok {
		return x.String_
	}
	return nil
}

func (x *InboundMessage_CompileRequest) GetPath() string {
	if x, ok := x.GetInput().(*InboundMessage_CompileRequest_Path); ok {
		return x.Path
	}
	return ""
}

func (x *InboundMessage_CompileRequest) GetStyle() InboundMessage_CompileRequest_OutputStyle {
	if x != nil {
		return x.Style
	}
	return InboundMessage_CompileRequest_EXPANDED
}

func (x *InboundMessage_CompileRequest) GetSourceMap() bool {
	if x != nil {
		return x.SourceMap
	}
	return false
}

func (x *InboundMessage_CompileRequest) GetImporters() []*InboundMessage_CompileRequest_Importer {
	if x != nil {
		return x.Importers
	}
	return nil
}

func (x *InboundMessage_CompileRequest) GetGlobalFunctions() []string {
	if x != nil {
		return x.GlobalFunctions
	}
	return nil
}

type isInboundMessage_CompileRequest_Input interface {
	isInboundMessage_CompileRequest_Input()
}

type InboundMessage_CompileRequest_String_ struct {
	// A stylesheet loaded from its contents.
	String_ *InboundMessage_CompileRequest_StringInput `protobuf:"bytes,2,opt,name=string,proto3,oneof"`
}

type InboundMessage_CompileRequest_Path struct {
	// A stylesheet loaded from the given path on the filesystem.
	Path string `protobuf:"bytes,3,opt,name=path,proto3,oneof"`
}

func (*InboundMessage_CompileRequest_String_) isInboundMessage_CompileRequest_Input() {}

func (*InboundMessage_CompileRequest_Path) isInboundMessage_CompileRequest_Input() {}

// A response indicating the result of canonicalizing an imported URL.
type InboundMessage_CanonicalizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The result of canonicalization. Optional. If this is `null`, it indicates
	// that the importer either did not recognize the URL, or could not find a
	// stylesheet at the location it referred to.
	//
	// Types that are assignable to Result:
	//	*InboundMessage_CanonicalizeResponse_Url
	//	*InboundMessage_CanonicalizeResponse_Error
	Result isInboundMessage_CanonicalizeResponse_Result `protobuf_oneof:"result"`
}

func (x *InboundMessage_CanonicalizeResponse) Reset() {
	*x = InboundMessage_CanonicalizeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_CanonicalizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_CanonicalizeResponse) ProtoMessage() {}

func (x *InboundMessage_CanonicalizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_CanonicalizeResponse.ProtoReflect.Descriptor instead.
func (*InboundMessage_CanonicalizeResponse) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 1}
}

func (x *InboundMessage_CanonicalizeResponse) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *InboundMessage_CanonicalizeResponse) GetResult() isInboundMessage_CanonicalizeResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *InboundMessage_CanonicalizeResponse) GetUrl() string {
	if x, ok := x.GetResult().(*InboundMessage_CanonicalizeResponse_Url); ok {
		return x.Url
	}
	return ""
}

func (x *InboundMessage_CanonicalizeResponse) GetError() string {
	if x, ok := x.GetResult().(*InboundMessage_CanonicalizeResponse_Error); ok {
		return x.Error
	}
	return ""
}

type isInboundMessage_CanonicalizeResponse_Result interface {
	isInboundMessage_CanonicalizeResponse_Result()
}

type InboundMessage_CanonicalizeResponse_Url struct {
	// The successfully canonicalized URL. This must be an absolute URL,
	// including scheme.
	Url string `protobuf:"bytes,2,opt,name=url,proto3,oneof"`
}

type InboundMessage_CanonicalizeResponse_Error struct {
	// An error message explaining why canonicalization failed.
	//
	// This indicates that a stylesheet was found, but a canonical URL for it
	// could not be determined. If no stylesheet was found, `result` should be
	// `null` instead.
	Error string `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*InboundMessage_CanonicalizeResponse_Url) isInboundMessage_CanonicalizeResponse_Result() {}

func (*InboundMessage_CanonicalizeResponse_Error) isInboundMessage_CanonicalizeResponse_Result() {}

// A response indicating the result of importing a canonical URL.
type InboundMessage_ImportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The result of loading the URL. Mandatory.
	//
	// Types that are assignable to Result:
	//	*InboundMessage_ImportResponse_Success
	//	*InboundMessage_ImportResponse_Error
	Result isInboundMessage_ImportResponse_Result `protobuf_oneof:"result"`
}

func (x *InboundMessage_ImportResponse) Reset() {
	*x = InboundMessage_ImportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_ImportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_ImportResponse) ProtoMessage() {}

func (x *InboundMessage_ImportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_ImportResponse.ProtoReflect.Descriptor instead.
func (*InboundMessage_ImportResponse) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 2}
}

func (x *InboundMessage_ImportResponse) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *InboundMessage_ImportResponse) GetResult() isInboundMessage_ImportResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *InboundMessage_ImportResponse) GetSuccess() *InboundMessage_ImportResponse_ImportSuccess {
	if x, ok := x.GetResult().(*InboundMessage_ImportResponse_Success); ok {
		return x.Success
	}
	return nil
}

func (x *InboundMessage_ImportResponse) GetError() string {
	if x, ok := x.GetResult().(*InboundMessage_ImportResponse_Error); ok {
		return x.Error
	}
	return ""
}

type isInboundMessage_ImportResponse_Result interface {
	isInboundMessage_ImportResponse_Result()
}

type InboundMessage_ImportResponse_Success struct {
	// The contents of the loaded stylesheet.
	Success *InboundMessage_ImportResponse_ImportSuccess `protobuf:"bytes,2,opt,name=success,proto3,oneof"`
}

type InboundMessage_ImportResponse_Error struct {
	// An error message explaining why the URL could not be loaded.
	Error string `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*InboundMessage_ImportResponse_Success) isInboundMessage_ImportResponse_Result() {}

func (*InboundMessage_ImportResponse_Error) isInboundMessage_ImportResponse_Result() {}

// A response indicating the result of redirecting a URL to the filesystem.
type InboundMessage_FileImportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The result of loading the URL. Mandatory.
	//
	// Types that are assignable to Result:
	//	*InboundMessage_FileImportResponse_FileUrl
	//	*InboundMessage_FileImportResponse_Error
	Result isInboundMessage_FileImportResponse_Result `protobuf_oneof:"result"`
}

func (x *InboundMessage_FileImportResponse) Reset() {
	*x = InboundMessage_FileImportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_FileImportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_FileImportResponse) ProtoMessage() {}

func (x *InboundMessage_FileImportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_FileImportResponse.ProtoReflect.Descriptor instead.
func (*InboundMessage_FileImportResponse) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 3}
}

func (x *InboundMessage_FileImportResponse) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *InboundMessage_FileImportResponse) GetResult() isInboundMessage_FileImportResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *InboundMessage_FileImportResponse) GetFileUrl() string {
	if x, ok := x.GetResult().(*InboundMessage_FileImportResponse_FileUrl); ok {
		return x.FileUrl
	}
	return ""
}

func (x *InboundMessage_FileImportResponse) GetError() string {
	if x, ok := x.GetResult().(*InboundMessage_FileImportResponse_Error); ok {
		return x.Error
	}
	return ""
}

type isInboundMessage_FileImportResponse_Result interface {
	isInboundMessage_FileImportResponse_Result()
}

type InboundMessage_FileImportResponse_FileUrl struct {
	// The absolute `file:` URL to look for the file on the physical
	// filesystem.
	//
	// The host must ensure that this URL follows the format for an absolute
	// `file:` URL on the current operating system without a hostname, and the
	// compiler must verify this to the best of its ability. See
	// https://en.wikipedia.org/wiki/File_URI_scheme for details on the
	// format.
	//
	// The compiler must handle turning this into a canonical URL by resolving
	// it for partials, file extensions, and index files. The compiler must
	// then loading the contents of the resulting canonical URL from the
	// filesystem.
	FileUrl string `protobuf:"bytes,2,opt,name=file_url,json=fileUrl,proto3,oneof"`
}

type InboundMessage_FileImportResponse_Error struct {
	// An error message explaining why the URL could not be loaded.
	Error string `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*InboundMessage_FileImportResponse_FileUrl) isInboundMessage_FileImportResponse_Result() {}

func (*InboundMessage_FileImportResponse_Error) isInboundMessage_FileImportResponse_Result() {}

// A response indicating the result of calling a custom Sass function defined
// in the host.
type InboundMessage_FunctionCallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The result of calling the function. Mandatory.
	//
	// Types that are assignable to Result:
	//	*InboundMessage_FunctionCallResponse_Success
	//	*InboundMessage_FunctionCallResponse_Error
	Result isInboundMessage_FunctionCallResponse_Result `protobuf_oneof:"result"`
}

func (x *InboundMessage_FunctionCallResponse) Reset() {
	*x = InboundMessage_FunctionCallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_FunctionCallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_FunctionCallResponse) ProtoMessage() {}

func (x *InboundMessage_FunctionCallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_FunctionCallResponse.ProtoReflect.Descriptor instead.
func (*InboundMessage_FunctionCallResponse) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 4}
}

func (x *InboundMessage_FunctionCallResponse) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *InboundMessage_FunctionCallResponse) GetResult() isInboundMessage_FunctionCallResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *InboundMessage_FunctionCallResponse) GetSuccess() *Value {
	if x, ok := x.GetResult().(*InboundMessage_FunctionCallResponse_Success); ok {
		return x.Success
	}
	return nil
}

func (x *InboundMessage_FunctionCallResponse) GetError() string {
	if x, ok := x.GetResult().(*InboundMessage_FunctionCallResponse_Error); ok {
		return x.Error
	}
	return ""
}

type isInboundMessage_FunctionCallResponse_Result interface {
	isInboundMessage_FunctionCallResponse_Result()
}

type InboundMessage_FunctionCallResponse_Success struct {
	// The return value of a successful function call.
	Success *Value `protobuf:"bytes,2,opt,name=success,proto3,oneof"`
}

type InboundMessage_FunctionCallResponse_Error struct {
	// An error message explaining why the function call failed.
	Error string `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*InboundMessage_FunctionCallResponse_Success) isInboundMessage_FunctionCallResponse_Result() {}

func (*InboundMessage_FunctionCallResponse_Error) isInboundMessage_FunctionCallResponse_Result() {}

// An input stylesheet provided as plain text, rather than loaded from the
// filesystem.
type InboundMessage_CompileRequest_StringInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The contents of the stylesheet.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The location from which `source` was loaded. If this is empty, it
	// indicates that the URL is unknown.
	//
	// This must be a URL recognized by `importer`, if it's passed.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The syntax to use to parse `source`.
	Syntax InboundMessage_Syntax `protobuf:"varint,3,opt,name=syntax,proto3,enum=sass.embedded_protocol.InboundMessage_Syntax" json:"syntax,omitempty"`
	// The importer to use to resolve imports relative to `url`.
	Importer *InboundMessage_CompileRequest_Importer `protobuf:"bytes,4,opt,name=importer,proto3" json:"importer,omitempty"`
}

func (x *InboundMessage_CompileRequest_StringInput) Reset() {
	*x = InboundMessage_CompileRequest_StringInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_CompileRequest_StringInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_CompileRequest_StringInput) ProtoMessage() {}

func (x *InboundMessage_CompileRequest_StringInput) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_CompileRequest_StringInput.ProtoReflect.Descriptor instead.
func (*InboundMessage_CompileRequest_StringInput) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *InboundMessage_CompileRequest_StringInput) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *InboundMessage_CompileRequest_StringInput) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *InboundMessage_CompileRequest_StringInput) GetSyntax() InboundMessage_Syntax {
	if x != nil {
		return x.Syntax
	}
	return InboundMessage_SCSS
}

func (x *InboundMessage_CompileRequest_StringInput) GetImporter() *InboundMessage_CompileRequest_Importer {
	if x != nil {
		return x.Importer
	}
	return nil
}

// A wrapper message that represents either a user-defined importer or a
// load path on disk. This must be a wrapper because `oneof` types can't be
// `repeated`.
type InboundMessage_CompileRequest_Importer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The possible types of importer. Mandatory.
	//
	// Types that are assignable to Importer:
	//	*InboundMessage_CompileRequest_Importer_Path
	//	*InboundMessage_CompileRequest_Importer_ImporterId
	//	*InboundMessage_CompileRequest_Importer_FileImporterId
	Importer isInboundMessage_CompileRequest_Importer_Importer `protobuf_oneof:"importer"`
}

func (x *InboundMessage_CompileRequest_Importer) Reset() {
	*x = InboundMessage_CompileRequest_Importer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_CompileRequest_Importer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_CompileRequest_Importer) ProtoMessage() {}

func (x *InboundMessage_CompileRequest_Importer) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_CompileRequest_Importer.ProtoReflect.Descriptor instead.
func (*InboundMessage_CompileRequest_Importer) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (m *InboundMessage_CompileRequest_Importer) GetImporter() isInboundMessage_CompileRequest_Importer_Importer {
	if m != nil {
		return m.Importer
	}
	return nil
}

func (x *InboundMessage_CompileRequest_Importer) GetPath() string {
	if x, ok := x.GetImporter().(*InboundMessage_CompileRequest_Importer_Path); ok {
		return x.Path
	}
	return ""
}

func (x *InboundMessage_CompileRequest_Importer) GetImporterId() uint32 {
	if x, ok := x.GetImporter().(*InboundMessage_CompileRequest_Importer_ImporterId); ok {
		return x.ImporterId
	}
	return 0
}

func (x *InboundMessage_CompileRequest_Importer) GetFileImporterId() uint32 {
	if x, ok := x.GetImporter().(*InboundMessage_CompileRequest_Importer_FileImporterId); ok {
		return x.FileImporterId
	}
	return 0
}

type isInboundMessage_CompileRequest_Importer_Importer interface {
	isInboundMessage_CompileRequest_Importer_Importer()
}

type InboundMessage_CompileRequest_Importer_Path struct {
	// A built-in importer that loads Sass files within the given directory
	// on disk.
	Path string `protobuf:"bytes,1,opt,name=path,proto3,oneof"`
}

type InboundMessage_CompileRequest_Importer_ImporterId struct {
	// A unique ID for a user-defined importer. This ID will be included in
	// outbound `CanonicalizeRequest` and `ImportRequest` messages to
	// indicate which importer is being called. The host is responsible for
	// generating this ID and ensuring that it's unique across all
	// importers registered for this compilation.
	ImporterId uint32 `protobuf:"varint,2,opt,name=importer_id,json=importerId,proto3,oneof"`
}

type InboundMessage_CompileRequest_Importer_FileImporterId struct {
	// A unique ID for a special kind of user-defined importer that tells
	// the compiler where to look for files on the physical filesystem, but
	// leaves the details of resolving partials and extensions and loading
	// the file from disk up to the compiler itself.
	//
	// This ID will be included in outbound `FileImportRequest` messages to
	// indicate which importer is being called. The host is responsible for
	// generating this ID and ensuring that it's unique across all importers
	// registered for this compilation.
	FileImporterId uint32 `protobuf:"varint,3,opt,name=file_importer_id,json=fileImporterId,proto3,oneof"`
}

func (*InboundMessage_CompileRequest_Importer_Path) isInboundMessage_CompileRequest_Importer_Importer() {
}

func (*InboundMessage_CompileRequest_Importer_ImporterId) isInboundMessage_CompileRequest_Importer_Importer() {
}

func (*InboundMessage_CompileRequest_Importer_FileImporterId) isInboundMessage_CompileRequest_Importer_Importer() {
}

// The stylesheet's contents were loaded successfully.
type InboundMessage_ImportResponse_ImportSuccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text of the stylesheet. Mandatory.
	Contents string `protobuf:"bytes,1,opt,name=contents,proto3" json:"contents,omitempty"`
	// The syntax of `contents`. Mandatory.
	Syntax InboundMessage_Syntax `protobuf:"varint,2,opt,name=syntax,proto3,enum=sass.embedded_protocol.InboundMessage_Syntax" json:"syntax,omitempty"`
	// An absolute, browser-accessible URL indicating the resolved location of
	// the imported stylesheet. Optional.
	//
	// This should be a `file:` URL if one is available, but an `http:` URL is
	// acceptable as well. If no URL is supplied, a `data:` URL is generated
	// automatically from `contents`.
	//
	// If this is provided, it must be an absolute URL, including scheme.
	SourceMapUrl string `protobuf:"bytes,3,opt,name=sourceMapUrl,proto3" json:"sourceMapUrl,omitempty"`
}

func (x *InboundMessage_ImportResponse_ImportSuccess) Reset() {
	*x = InboundMessage_ImportResponse_ImportSuccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMessage_ImportResponse_ImportSuccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMessage_ImportResponse_ImportSuccess) ProtoMessage() {}

func (x *InboundMessage_ImportResponse_ImportSuccess) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMessage_ImportResponse_ImportSuccess.ProtoReflect.Descriptor instead.
func (*InboundMessage_ImportResponse_ImportSuccess) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *InboundMessage_ImportResponse_ImportSuccess) GetContents() string {
	if x != nil {
		return x.Contents
	}
	return ""
}

func (x *InboundMessage_ImportResponse_ImportSuccess) GetSyntax() InboundMessage_Syntax {
	if x != nil {
		return x.Syntax
	}
	return InboundMessage_SCSS
}

func (x *InboundMessage_ImportResponse_ImportSuccess) GetSourceMapUrl() string {
	if x != nil {
		return x.SourceMapUrl
	}
	return ""
}

// A response that contains the result of a compilation.
type OutboundMessage_CompileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The compilation's request id. Mandatory.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The success or failure result of the compilation. Mandatory.
	//
	// Types that are assignable to Result:
	//	*OutboundMessage_CompileResponse_Success
	//	*OutboundMessage_CompileResponse_Failure
	Result isOutboundMessage_CompileResponse_Result `protobuf_oneof:"result"`
}

func (x *OutboundMessage_CompileResponse) Reset() {
	*x = OutboundMessage_CompileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_CompileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_CompileResponse) ProtoMessage() {}

func (x *OutboundMessage_CompileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_CompileResponse.ProtoReflect.Descriptor instead.
func (*OutboundMessage_CompileResponse) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 0}
}

func (x *OutboundMessage_CompileResponse) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *OutboundMessage_CompileResponse) GetResult() isOutboundMessage_CompileResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *OutboundMessage_CompileResponse) GetSuccess() *OutboundMessage_CompileResponse_CompileSuccess {
	if x, ok := x.GetResult().(*OutboundMessage_CompileResponse_Success); ok {
		return x.Success
	}
	return nil
}

func (x *OutboundMessage_CompileResponse) GetFailure() *OutboundMessage_CompileResponse_CompileFailure {
	if x, ok := x.GetResult().(*OutboundMessage_CompileResponse_Failure); ok {
		return x.Failure
	}
	return nil
}

type isOutboundMessage_CompileResponse_Result interface {
	isOutboundMessage_CompileResponse_Result()
}

type OutboundMessage_CompileResponse_Success struct {
	// The result of a successful compilation.
	Success *OutboundMessage_CompileResponse_CompileSuccess `protobuf:"bytes,2,opt,name=success,proto3,oneof"`
}

type OutboundMessage_CompileResponse_Failure struct {
	// The result of a failed compilation.
	Failure *OutboundMessage_CompileResponse_CompileFailure `protobuf:"bytes,3,opt,name=failure,proto3,oneof"`
}

func (*OutboundMessage_CompileResponse_Success) isOutboundMessage_CompileResponse_Result() {}

func (*OutboundMessage_CompileResponse_Failure) isOutboundMessage_CompileResponse_Result() {}

// An event indicating that a message should be displayed to the user.
type OutboundMessage_LogEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request id for the compilation that triggered the message. Mandatory.
	CompilationId uint32                        `protobuf:"varint,1,opt,name=compilation_id,json=compilationId,proto3" json:"compilation_id,omitempty"`
	Type          OutboundMessage_LogEvent_Type `protobuf:"varint,2,opt,name=type,proto3,enum=sass.embedded_protocol.OutboundMessage_LogEvent_Type" json:"type,omitempty"`
	// The text of the message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// The span associated with this message. Optional.
	Span *SourceSpan `protobuf:"bytes,4,opt,name=span,proto3" json:"span,omitempty"`
	// The stack trace associated with this message.
	//
	// The empty string indicates that no stack trace is available. Otherwise,
	// the format of this stack trace is not specified and is likely to be
	// inconsistent between implementations.
	StackTrace string `protobuf:"bytes,5,opt,name=stack_trace,json=stackTrace,proto3" json:"stack_trace,omitempty"`
}

func (x *OutboundMessage_LogEvent) Reset() {
	*x = OutboundMessage_LogEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_LogEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_LogEvent) ProtoMessage() {}

func (x *OutboundMessage_LogEvent) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_LogEvent.ProtoReflect.Descriptor instead.
func (*OutboundMessage_LogEvent) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 1}
}

func (x *OutboundMessage_LogEvent) GetCompilationId() uint32 {
	if x != nil {
		return x.CompilationId
	}
	return 0
}

func (x *OutboundMessage_LogEvent) GetType() OutboundMessage_LogEvent_Type {
	if x != nil {
		return x.Type
	}
	return OutboundMessage_LogEvent_WARNING
}

func (x *OutboundMessage_LogEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *OutboundMessage_LogEvent) GetSpan() *SourceSpan {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *OutboundMessage_LogEvent) GetStackTrace() string {
	if x != nil {
		return x.StackTrace
	}
	return ""
}

// A request for a custom importer to convert an imported URL to its canonical
// format.
//
// If the URL is not recognized by this importer, or if no stylesheet is found
// at that URL, `CanonicalizeResponse.result` must be `null`.
//
// Canonical URLs must be absolute, including a scheme. If the import is
// referring to a Sass file on disk, the importer is encouraged to respond
// with a `CanonicalizeResponse.result.file`, in which case the host will
// handle the logic of resolving partials, file extensions, and index files.
//
// If Sass has already loaded a stylesheet with the returned canonical URL, it
// re-uses the existing parse tree. This means that importers must ensure that
// the same canonical URL always refers to the same stylesheet, *even across
// different importers*. Importers must also ensure that any canonicalized
// URLs they return can be passed back to `CanonicalizeRequest` and will be
// returned unchanged.
//
// If this importer's URL format supports file extensions, it should
// canonicalize them the same way as the default filesystem importer:
//
// * The importer should look for stylesheets by adding the prefix `_` to the
//   URL's basename, and by adding the extensions `.sass` and `.scss` if the
//   URL doesn't already have one of those extensions. For example, if the URL
//   was `foo/bar/baz`, the importer would look for:
//
//   * `foo/bar/baz.sass`
//   * `foo/bar/baz.scss`
//   * `foo/bar/_baz.sass`
//   * `foo/bar/_baz.scss`
//
//   If the URL was foo/bar/baz.scss, the importer would just look for:
//
//   * `foo/bar/baz.scss`
//   * `foo/bar/_baz.scss`
//
//   If the importer finds a stylesheet at more than one of these URLs, it
//   should respond with a `CanonicalizeResponse.result.error` indicating that
//   the import is ambiguous. Note that if the extension is explicitly
//   specified, a stylesheet with another extension may exist without error.
//
// * If none of the possible paths is valid, the importer should perform the
//   same resolution on the URL followed by `/index`. In the example above, it
//   would look for:
//
//   * `foo/bar/baz/_index.sass`
//   * `foo/bar/baz/index.sass`
//   * `foo/bar/baz/_index.scss`
//   * `foo/bar/baz/index.scss`
//
//   As above, if the importer finds a stylesheet at more than one of these
//   URLs, it should respond with a `CanonicalizeResponse.result.error`
//   indicating that the import is ambiguous.
type OutboundMessage_CanonicalizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The request id for the compilation that triggered the message. Mandatory.
	CompilationId uint32 `protobuf:"varint,2,opt,name=compilation_id,json=compilationId,proto3" json:"compilation_id,omitempty"`
	// The unique ID of the importer being invoked. This must match an importer
	// ID passed to this compilation in `CompileRequest.importers` or
	// `CompileRequest.input.string.importer`. Mandatory.
	ImporterId uint32 `protobuf:"varint,3,opt,name=importer_id,json=importerId,proto3" json:"importer_id,omitempty"`
	// The URL of the import to be canonicalized. This may be either absolute or
	// relative.
	//
	// When loading a URL, the host must first try resolving that URL relative
	// to the canonical URL of the current file, and canonicalizing the result
	// using the importer that loaded the current file. If this returns `null`,
	// the host must then try canonicalizing the original URL with each importer
	// in order until one returns something other than `null`. That is the
	// result of the import.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *OutboundMessage_CanonicalizeRequest) Reset() {
	*x = OutboundMessage_CanonicalizeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_CanonicalizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_CanonicalizeRequest) ProtoMessage() {}

func (x *OutboundMessage_CanonicalizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_CanonicalizeRequest.ProtoReflect.Descriptor instead.
func (*OutboundMessage_CanonicalizeRequest) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 2}
}

func (x *OutboundMessage_CanonicalizeRequest) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *OutboundMessage_CanonicalizeRequest) GetCompilationId() uint32 {
	if x != nil {
		return x.CompilationId
	}
	return 0
}

func (x *OutboundMessage_CanonicalizeRequest) GetImporterId() uint32 {
	if x != nil {
		return x.ImporterId
	}
	return 0
}

func (x *OutboundMessage_CanonicalizeRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// A request for a custom importer to load the contents of a stylesheet.
type OutboundMessage_ImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The request id for the compilation that triggered the message. Mandatory.
	CompilationId uint32 `protobuf:"varint,2,opt,name=compilation_id,json=compilationId,proto3" json:"compilation_id,omitempty"`
	// The unique ID of the importer being invoked. This must match an
	// `Importer.importer_id` passed to this compilation in
	// `CompileRequest.importers` or `CompileRequest.input.string.importer`.
	// Mandatory.
	ImporterId uint32 `protobuf:"varint,3,opt,name=importer_id,json=importerId,proto3" json:"importer_id,omitempty"`
	// The canonical URL of the import. This is guaranteed to be a URL returned
	// by a `CanonicalizeRequest` to this importer.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *OutboundMessage_ImportRequest) Reset() {
	*x = OutboundMessage_ImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_ImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_ImportRequest) ProtoMessage() {}

func (x *OutboundMessage_ImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_ImportRequest.ProtoReflect.Descriptor instead.
func (*OutboundMessage_ImportRequest) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 3}
}

func (x *OutboundMessage_ImportRequest) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *OutboundMessage_ImportRequest) GetCompilationId() uint32 {
	if x != nil {
		return x.CompilationId
	}
	return 0
}

func (x *OutboundMessage_ImportRequest) GetImporterId() uint32 {
	if x != nil {
		return x.ImporterId
	}
	return 0
}

func (x *OutboundMessage_ImportRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// A request for a custom filesystem importer to load the contents of a
// stylesheet.
type OutboundMessage_FileImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The request id for the compilation that triggered the message. Mandatory.
	CompilationId uint32 `protobuf:"varint,2,opt,name=compilation_id,json=compilationId,proto3" json:"compilation_id,omitempty"`
	// The unique ID of the importer being invoked. This must match an
	// `Importer.file_importer_id` passed to this compilation in
	// `CompileRequest.importers` or `CompileRequest.input.string.importer`.
	// Mandatory.
	ImporterId uint32 `protobuf:"varint,3,opt,name=importer_id,json=importerId,proto3" json:"importer_id,omitempty"`
	// The canonical URL of the import. This is guaranteed to be a URL returned
	// by a `CanonicalizeRequest` to this importer.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *OutboundMessage_FileImportRequest) Reset() {
	*x = OutboundMessage_FileImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_FileImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_FileImportRequest) ProtoMessage() {}

func (x *OutboundMessage_FileImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_FileImportRequest.ProtoReflect.Descriptor instead.
func (*OutboundMessage_FileImportRequest) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 4}
}

func (x *OutboundMessage_FileImportRequest) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *OutboundMessage_FileImportRequest) GetCompilationId() uint32 {
	if x != nil {
		return x.CompilationId
	}
	return 0
}

func (x *OutboundMessage_FileImportRequest) GetImporterId() uint32 {
	if x != nil {
		return x.ImporterId
	}
	return 0
}

func (x *OutboundMessage_FileImportRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// A request to invoke a custom Sass function and return its result.
type OutboundMessage_FunctionCallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The request id for the compilation that triggered the message. Mandatory.
	CompilationId uint32 `protobuf:"varint,2,opt,name=compilation_id,json=compilationId,proto3" json:"compilation_id,omitempty"`
	// An identifier that indicates which function to invoke. Mandatory.
	//
	// Types that are assignable to Identifier:
	//	*OutboundMessage_FunctionCallRequest_Name
	//	*OutboundMessage_FunctionCallRequest_FunctionId
	Identifier isOutboundMessage_FunctionCallRequest_Identifier `protobuf_oneof:"identifier"`
	// The arguments passed to the function, in the order they appear in the
	// function signature passed to `CompileRequest.global_functions`. Mandatory.
	//
	// The compiler must ensure that a valid number of arguments are passed for
	// the given signature, that default argument values are instantiated
	// appropriately, and that variable argument lists (`$args...`) are passed
	// as `Value.ArgumentList`s.
	Arguments []*Value `protobuf:"bytes,5,rep,name=arguments,proto3" json:"arguments,omitempty"`
}

func (x *OutboundMessage_FunctionCallRequest) Reset() {
	*x = OutboundMessage_FunctionCallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_FunctionCallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_FunctionCallRequest) ProtoMessage() {}

func (x *OutboundMessage_FunctionCallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_FunctionCallRequest.ProtoReflect.Descriptor instead.
func (*OutboundMessage_FunctionCallRequest) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 5}
}

func (x *OutboundMessage_FunctionCallRequest) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *OutboundMessage_FunctionCallRequest) GetCompilationId() uint32 {
	if x != nil {
		return x.CompilationId
	}
	return 0
}

func (m *OutboundMessage_FunctionCallRequest) GetIdentifier() isOutboundMessage_FunctionCallRequest_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (x *OutboundMessage_FunctionCallRequest) GetName() string {
	if x, ok := x.GetIdentifier().(*OutboundMessage_FunctionCallRequest_Name); ok {
		return x.Name
	}
	return ""
}

func (x *OutboundMessage_FunctionCallRequest) GetFunctionId() uint32 {
	if x, ok := x.GetIdentifier().(*OutboundMessage_FunctionCallRequest_FunctionId); ok {
		return x.FunctionId
	}
	return 0
}

func (x *OutboundMessage_FunctionCallRequest) GetArguments() []*Value {
	if x != nil {
		return x.Arguments
	}
	return nil
}

type isOutboundMessage_FunctionCallRequest_Identifier interface {
	isOutboundMessage_FunctionCallRequest_Identifier()
}

type OutboundMessage_FunctionCallRequest_Name struct {
	// The name of the function to invoke.
	//
	// This must match the name of a function signature the host passed to the
	// corresponding `CompileRequest.global_functions` call, including hyphens
	// and underscores.
	Name string `protobuf:"bytes,3,opt,name=name,proto3,oneof"`
}

type OutboundMessage_FunctionCallRequest_FunctionId struct {
	// The opaque ID of the function to invoke.
	//
	// This must match the ID of a `Value.HostFunction` that the host passed
	// to the compiler.
	FunctionId uint32 `protobuf:"varint,4,opt,name=function_id,json=functionId,proto3,oneof"`
}

func (*OutboundMessage_FunctionCallRequest_Name) isOutboundMessage_FunctionCallRequest_Identifier() {}

func (*OutboundMessage_FunctionCallRequest_FunctionId) isOutboundMessage_FunctionCallRequest_Identifier() {
}

// A message indicating that the Sass file was successfully compiled to CSS.
type OutboundMessage_CompileResponse_CompileSuccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The compiled CSS.
	Css string `protobuf:"bytes,1,opt,name=css,proto3" json:"css,omitempty"`
	// The JSON-encoded source map, or the empty string if
	// `CompileRequest.source_map` was `false`.
	//
	// The compiler must not add a `"file"` key to this source map. It's the
	// host's (or the host's user's) responsibility to determine how the
	// generated CSS can be reached from the source map.
	SourceMap string `protobuf:"bytes,2,opt,name=source_map,json=sourceMap,proto3" json:"source_map,omitempty"`
}

func (x *OutboundMessage_CompileResponse_CompileSuccess) Reset() {
	*x = OutboundMessage_CompileResponse_CompileSuccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_CompileResponse_CompileSuccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_CompileResponse_CompileSuccess) ProtoMessage() {}

func (x *OutboundMessage_CompileResponse_CompileSuccess) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_CompileResponse_CompileSuccess.ProtoReflect.Descriptor instead.
func (*OutboundMessage_CompileResponse_CompileSuccess) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *OutboundMessage_CompileResponse_CompileSuccess) GetCss() string {
	if x != nil {
		return x.Css
	}
	return ""
}

func (x *OutboundMessage_CompileResponse_CompileSuccess) GetSourceMap() string {
	if x != nil {
		return x.SourceMap
	}
	return ""
}

// A message indicating that the Sass file could not be successfully
// compiled to CSS.
type OutboundMessage_CompileResponse_CompileFailure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A message describing the reason for the failure.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The span associated with the failure. Optional.
	Span *SourceSpan `protobuf:"bytes,2,opt,name=span,proto3" json:"span,omitempty"`
	// The stack trace associated with the failure.
	//
	// The empty string indicates that no stack trace is available. Otherwise,
	// the format of this stack trace is not specified and is likely to be
	// inconsistent between implementations.
	StackTrace string `protobuf:"bytes,3,opt,name=stack_trace,json=stackTrace,proto3" json:"stack_trace,omitempty"`
}

func (x *OutboundMessage_CompileResponse_CompileFailure) Reset() {
	*x = OutboundMessage_CompileResponse_CompileFailure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMessage_CompileResponse_CompileFailure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMessage_CompileResponse_CompileFailure) ProtoMessage() {}

func (x *OutboundMessage_CompileResponse_CompileFailure) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMessage_CompileResponse_CompileFailure.ProtoReflect.Descriptor instead.
func (*OutboundMessage_CompileResponse_CompileFailure) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{1, 0, 1}
}

func (x *OutboundMessage_CompileResponse_CompileFailure) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *OutboundMessage_CompileResponse_CompileFailure) GetSpan() *SourceSpan {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *OutboundMessage_CompileResponse_CompileFailure) GetStackTrace() string {
	if x != nil {
		return x.StackTrace
	}
	return ""
}

// A single point in a source file.
type SourceSpan_SourceLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The 0-based offset of this location within the source file. Mandatory.
	Offset uint32 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	// The 0-based line number of this location within the source file.
	// Mandatory.
	Line uint32 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	// The 0-based column number of this location within its line. Mandatory.
	Column uint32 `protobuf:"varint,3,opt,name=column,proto3" json:"column,omitempty"`
}

func (x *SourceSpan_SourceLocation) Reset() {
	*x = SourceSpan_SourceLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceSpan_SourceLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceSpan_SourceLocation) ProtoMessage() {}

func (x *SourceSpan_SourceLocation) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceSpan_SourceLocation.ProtoReflect.Descriptor instead.
func (*SourceSpan_SourceLocation) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{3, 0}
}

func (x *SourceSpan_SourceLocation) GetOffset() uint32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SourceSpan_SourceLocation) GetLine() uint32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *SourceSpan_SourceLocation) GetColumn() uint32 {
	if x != nil {
		return x.Column
	}
	return 0
}

// A SassScript string value.
type Value_String struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The contents of the string. Mandatory.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Whether the string is quoted or unquoted. Mandatory.
	Quoted bool `protobuf:"varint,2,opt,name=quoted,proto3" json:"quoted,omitempty"`
}

func (x *Value_String) Reset() {
	*x = Value_String{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_String) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_String) ProtoMessage() {}

func (x *Value_String) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_String.ProtoReflect.Descriptor instead.
func (*Value_String) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Value_String) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Value_String) GetQuoted() bool {
	if x != nil {
		return x.Quoted
	}
	return false
}

// A SassScript number value.
type Value_Number struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number's numeric value. Mandatory.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number's numerator units.
	//
	// The endpoint sending the number must ensure that no numerator units are
	// [compatible][] with any denominator units. Such compatible units must be
	// simplified away according to the multiplicative factor between them
	// defined in the CSS Values and Units spec.
	//
	// [compatible]: https://www.w3.org/TR/css-values-4/#compat
	Numerators []string `protobuf:"bytes,2,rep,name=numerators,proto3" json:"numerators,omitempty"`
	// The number's denominator units.
	Denominators []string `protobuf:"bytes,3,rep,name=denominators,proto3" json:"denominators,omitempty"`
}

func (x *Value_Number) Reset() {
	*x = Value_Number{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_Number) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_Number) ProtoMessage() {}

func (x *Value_Number) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_Number.ProtoReflect.Descriptor instead.
func (*Value_Number) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Value_Number) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *Value_Number) GetNumerators() []string {
	if x != nil {
		return x.Numerators
	}
	return nil
}

func (x *Value_Number) GetDenominators() []string {
	if x != nil {
		return x.Denominators
	}
	return nil
}

// A SassScript color value, represented as red, green, and blue channels.
type Value_RgbColor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The color's red channel. Mandatory. May not be above 255.
	Red uint32 `protobuf:"varint,1,opt,name=red,proto3" json:"red,omitempty"`
	// The color's green channel. Mandatory. May not be above 255.
	Green uint32 `protobuf:"varint,2,opt,name=green,proto3" json:"green,omitempty"`
	// The color's blue channel. Mandatory. May not be above 255.
	Blue uint32 `protobuf:"varint,3,opt,name=blue,proto3" json:"blue,omitempty"`
	// The color's alpha channel. Mandatory. Must be between 0 and 1,
	// inclusive.
	Alpha float64 `protobuf:"fixed64,4,opt,name=alpha,proto3" json:"alpha,omitempty"`
}

func (x *Value_RgbColor) Reset() {
	*x = Value_RgbColor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_RgbColor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_RgbColor) ProtoMessage() {}

func (x *Value_RgbColor) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_RgbColor.ProtoReflect.Descriptor instead.
func (*Value_RgbColor) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 2}
}

func (x *Value_RgbColor) GetRed() uint32 {
	if x != nil {
		return x.Red
	}
	return 0
}

func (x *Value_RgbColor) GetGreen() uint32 {
	if x != nil {
		return x.Green
	}
	return 0
}

func (x *Value_RgbColor) GetBlue() uint32 {
	if x != nil {
		return x.Blue
	}
	return 0
}

func (x *Value_RgbColor) GetAlpha() float64 {
	if x != nil {
		return x.Alpha
	}
	return 0
}

// A SassScript color value, represented as hue, saturation, and lightness channels.
type Value_HslColor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The color's hue. Mandatory.
	Hue float64 `protobuf:"fixed64,1,opt,name=hue,proto3" json:"hue,omitempty"`
	// The color's percent saturation. Mandatory. Must be between 0 and 100,
	// inclusive.
	Saturation float64 `protobuf:"fixed64,2,opt,name=saturation,proto3" json:"saturation,omitempty"`
	// The color's percent lightness. Mandatory. Must be between 0 and 100,
	// inclusive.
	Lightness float64 `protobuf:"fixed64,3,opt,name=lightness,proto3" json:"lightness,omitempty"`
	// The color's alpha channel. Mandatory. Must be between 0 and 1,
	// inclusive.
	Alpha float64 `protobuf:"fixed64,4,opt,name=alpha,proto3" json:"alpha,omitempty"`
}

func (x *Value_HslColor) Reset() {
	*x = Value_HslColor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_HslColor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_HslColor) ProtoMessage() {}

func (x *Value_HslColor) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_HslColor.ProtoReflect.Descriptor instead.
func (*Value_HslColor) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 3}
}

func (x *Value_HslColor) GetHue() float64 {
	if x != nil {
		return x.Hue
	}
	return 0
}

func (x *Value_HslColor) GetSaturation() float64 {
	if x != nil {
		return x.Saturation
	}
	return 0
}

func (x *Value_HslColor) GetLightness() float64 {
	if x != nil {
		return x.Lightness
	}
	return 0
}

func (x *Value_HslColor) GetAlpha() float64 {
	if x != nil {
		return x.Alpha
	}
	return 0
}

// A SassScript list value.
type Value_List struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of separator for this list. Mandatory.
	Separator Value_List_Separator `protobuf:"varint,1,opt,name=separator,proto3,enum=sass.embedded_protocol.Value_List_Separator" json:"separator,omitempty"`
	// Whether this list has square brackets. Mandatory.
	HasBrackets bool `protobuf:"varint,2,opt,name=has_brackets,json=hasBrackets,proto3" json:"has_brackets,omitempty"`
	// The elements of this list.
	Contents []*Value `protobuf:"bytes,3,rep,name=contents,proto3" json:"contents,omitempty"`
}

func (x *Value_List) Reset() {
	*x = Value_List{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_List) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_List) ProtoMessage() {}

func (x *Value_List) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_List.ProtoReflect.Descriptor instead.
func (*Value_List) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 4}
}

func (x *Value_List) GetSeparator() Value_List_Separator {
	if x != nil {
		return x.Separator
	}
	return Value_List_COMMA
}

func (x *Value_List) GetHasBrackets() bool {
	if x != nil {
		return x.HasBrackets
	}
	return false
}

func (x *Value_List) GetContents() []*Value {
	if x != nil {
		return x.Contents
	}
	return nil
}

// A SassScript map value.
type Value_Map struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The entries in this map. The sending endpoint must guarantee that no two
	// entries have the same key.
	Entries []*Value_Map_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *Value_Map) Reset() {
	*x = Value_Map{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_Map) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_Map) ProtoMessage() {}

func (x *Value_Map) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_Map.ProtoReflect.Descriptor instead.
func (*Value_Map) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 5}
}

func (x *Value_Map) GetEntries() []*Value_Map_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// A first-class function defined in the compiler. New `CompilerFunction`s may
// only be created by the compiler, but the host may pass `CompilerFunction`s
// back to the compiler as long as their IDs match IDs of functions received
// by the host during that same compilation.
type Value_CompilerFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique ID for this function. This ID can be used in
	// `InboundRequest.FunctionCallRequest` to invoke this function. The
	// compiler is responsible for generating this ID and ensuring it's unique
	// across all functions passed to the host for this compilation. Mandatory.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Value_CompilerFunction) Reset() {
	*x = Value_CompilerFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_CompilerFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_CompilerFunction) ProtoMessage() {}

func (x *Value_CompilerFunction) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_CompilerFunction.ProtoReflect.Descriptor instead.
func (*Value_CompilerFunction) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 6}
}

func (x *Value_CompilerFunction) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// An anonymous custom function defined in the host. New `HostFunction`s may
// only be created by the host, and `HostFunction`s may *never* be passed from
// the compiler to the host. The compiler must instead pass a
// `CompilerFunction` that wraps the `HostFunction`.
type Value_HostFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique ID for this function. The compiler must pass this ID as
	// `OutboundRequest.FunctionCallRequest.id` when invoking this function. The
	// host is responsible for generating this ID and ensuring it's unique
	// across all functions for *all* compilations. Mandatory.
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The signatures for this function. This must be a valid Sass function
	// signature that could appear in after `@function` in a Sass stylesheet,
	// such as `mix($color1, $color2, $weight: 50%)`. Mandatory.
	//
	// The compiler may not invoke the function by its name, since it's not
	// guaranteed to be globally unique. However, it may use the name to
	// generate the string representation of this function.
	Signature string `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *Value_HostFunction) Reset() {
	*x = Value_HostFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_HostFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_HostFunction) ProtoMessage() {}

func (x *Value_HostFunction) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_HostFunction.ProtoReflect.Descriptor instead.
func (*Value_HostFunction) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 7}
}

func (x *Value_HostFunction) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Value_HostFunction) GetSignature() string {
	if x != nil {
		return x.Signature
	}
	return ""
}

// A single key/value pair in the map.
type Value_Map_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key this entry is associated with. Mandatory.
	Key *Value `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value associated with this key. Mandatory.
	Value *Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Value_Map_Entry) Reset() {
	*x = Value_Map_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_embedded_sass_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_Map_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_Map_Entry) ProtoMessage() {}

func (x *Value_Map_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_embedded_sass_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_Map_Entry.ProtoReflect.Descriptor instead.
func (*Value_Map_Entry) Descriptor() ([]byte, []int) {
	return file_embedded_sass_proto_rawDescGZIP(), []int{4, 5, 0}
}

func (x *Value_Map_Entry) GetKey() *Value {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Value_Map_Entry) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

var File_embedded_sass_proto protoreflect.FileDescriptor

var file_embedded_sass_proto_rawDesc = []byte{
	0x0a, 0x13, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x61, 0x73, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65,
	0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x22, 0xa3, 0x10,
	0x0a, 0x0e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x5f, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x71, 0x0a, 0x14, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x14,
	0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x73,
	0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6b, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65,
	0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x12,
	0x66, 0x69, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x71, 0x0a, 0x14, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61,
	0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52,
	0x14, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0xbd, 0x06, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x5b, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x06, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x14, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x57, 0x0a, 0x05, 0x73,
	0x74, 0x79, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x73, 0x61, 0x73,
	0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x79, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d,
	0x61, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4d, 0x61, 0x70, 0x12, 0x5c, 0x0a, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x52, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x29, 0x0a, 0x10, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xda, 0x01, 0x0a,
	0x0b, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x45, 0x0a, 0x06, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x53,
	0x79, 0x6e, 0x74, 0x61, 0x78, 0x52, 0x06, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x12, 0x5a, 0x0a,
	0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x52,
	0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x1a, 0x7b, 0x0a, 0x08, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x0b, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x48, 0x00, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2a,
	0x0a, 0x10, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x49, 0x64, 0x42, 0x0a, 0x0a, 0x08, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x22, 0x44, 0x0a, 0x0b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x58, 0x50, 0x41, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x45, 0x53, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x10, 0x03, 0x42, 0x07, 0x0a, 0x05,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x1a, 0x5c, 0x0a, 0x14, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72,
	0x6c, 0x12, 0x16, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x1a, 0xbc, 0x02, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x5f, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x07,
	0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x16, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x1a,
	0x96, 0x01, 0x0a, 0x0d, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x45, 0x0a,
	0x06, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x52, 0x06, 0x73, 0x79,
	0x6e, 0x74, 0x61, 0x78, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61,
	0x70, 0x55, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4d, 0x61, 0x70, 0x55, 0x72, 0x6c, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x1a, 0x63, 0x0a, 0x12, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x66, 0x69,
	0x6c, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x16, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x08, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x83, 0x01, 0x0a, 0x14, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x39, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65,
	0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x48, 0x00, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x16, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x29, 0x0a,
	0x06, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x43, 0x53, 0x53, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x44, 0x45, 0x4e, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x07, 0x0a, 0x03, 0x43, 0x53, 0x53, 0x10, 0x02, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0xf4, 0x0f, 0x0a, 0x0f, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x63, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x08, 0x6c,
	0x6f, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x6f, 0x0a, 0x13, 0x63,
	0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x13, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x0d,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x75, 0x74,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x11, 0x66,
	0x69, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x11, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6f, 0x0a, 0x13, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x75, 0x74,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x13, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0xbc, 0x03, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x62, 0x0a, 0x07, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x73,
	0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x53, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x62, 0x0a, 0x07, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x48, 0x00, 0x52, 0x07, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x1a, 0x41, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x53, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x63, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4d, 0x61, 0x70, 0x1a, 0x83, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x73, 0x70, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65,
	0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x04, 0x73, 0x70, 0x61, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xa8, 0x02, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x49, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x36, 0x0a, 0x04, 0x73, 0x70, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x61,
	0x6e, 0x52, 0x04, 0x73, 0x70, 0x61, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x22, 0x37, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x00, 0x12, 0x17, 0x0a,
	0x13, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x57, 0x41, 0x52,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10,
	0x02, 0x1a, 0x7f, 0x0a, 0x13, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x1a, 0x79, 0x0a, 0x0d, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x1a, 0x7d, 0x0a,
	0x11, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x1a, 0xd0, 0x01, 0x0a,
	0x13, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x63, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0b, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x42,
	0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x0d, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x43, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x73, 0x61, 0x73,
	0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x30, 0x0a, 0x09, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x41, 0x52, 0x53,
	0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x53, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x22, 0xb0, 0x02,
	0x0a, 0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53,
	0x70, 0x61, 0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x43, 0x0a, 0x03, 0x65, 0x6e, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x1a, 0x54, 0x0a, 0x0e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x22, 0xac, 0x0c, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x61, 0x73,
	0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x3e, 0x0a, 0x06, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x61, 0x73,
	0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x09, 0x72, 0x67,
	0x62, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x52, 0x67, 0x62,
	0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x08, 0x72, 0x67, 0x62, 0x43, 0x6f, 0x6c, 0x6f,
	0x72, 0x12, 0x45, 0x0a, 0x09, 0x68, 0x73, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65,
	0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x2e, 0x48, 0x73, 0x6c, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x08,
	0x68, 0x73, 0x6c, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x38, 0x0a, 0x04, 0x6c, 0x69, 0x73, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x6c, 0x69,
	0x73, 0x74, 0x12, 0x35, 0x0a, 0x03, 0x6d, 0x61, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x4d,
	0x61, 0x70, 0x48, 0x00, 0x52, 0x03, 0x6d, 0x61, 0x70, 0x12, 0x47, 0x0a, 0x09, 0x73, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x74, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x73,
	0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x53, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x74, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x74,
	0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x5f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x10, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x51, 0x0a, 0x0d, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x34, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x1a, 0x62, 0x0a, 0x06, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x6e, 0x75,
	0x6d, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x64, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x1a, 0x5c,
	0x0a, 0x08, 0x52, 0x67, 0x62, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x72, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x67, 0x72, 0x65, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x67, 0x72, 0x65,
	0x65, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x04, 0x62, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x70, 0x0a, 0x08,
	0x48, 0x73, 0x6c, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x68, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x68, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x61,
	0x74, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a,
	0x73, 0x61, 0x74, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x69,
	0x67, 0x68, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6c,
	0x69, 0x67, 0x68, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0xed,
	0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x09, 0x73, 0x65, 0x70, 0x61, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x73, 0x61, 0x73,
	0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x53,
	0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x09, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x68, 0x61, 0x73, 0x5f, 0x62, 0x72, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x61, 0x73, 0x42, 0x72,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x22, 0x3b, 0x0a, 0x09, 0x53, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x09,
	0x0a, 0x05, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x50, 0x41,
	0x43, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4c, 0x41, 0x53, 0x48, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x44, 0x45, 0x43, 0x49, 0x44, 0x45, 0x44, 0x10, 0x03, 0x1a, 0xb7,
	0x01, 0x0a, 0x03, 0x4d, 0x61, 0x70, 0x12, 0x41, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x6d, 0x0a, 0x05, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x2f, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x33, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x61, 0x73, 0x73, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x22, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x65, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x1a, 0x3c, 0x0a, 0x0c,
	0x48, 0x6f, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1c, 0x0a, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x2a, 0x0a, 0x09, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x74, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x52, 0x55, 0x45, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x41, 0x4c, 0x53, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_embedded_sass_proto_rawDescOnce sync.Once
	file_embedded_sass_proto_rawDescData = file_embedded_sass_proto_rawDesc
)

func file_embedded_sass_proto_rawDescGZIP() []byte {
	file_embedded_sass_proto_rawDescOnce.Do(func() {
		file_embedded_sass_proto_rawDescData = protoimpl.X.CompressGZIP(file_embedded_sass_proto_rawDescData)
	})
	return file_embedded_sass_proto_rawDescData
}

var file_embedded_sass_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_embedded_sass_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_embedded_sass_proto_goTypes = []interface{}{
	(InboundMessage_Syntax)(0),                             // 0: sass.embedded_protocol.InboundMessage.Syntax
	(InboundMessage_CompileRequest_OutputStyle)(0),         // 1: sass.embedded_protocol.InboundMessage.CompileRequest.OutputStyle
	(OutboundMessage_LogEvent_Type)(0),                     // 2: sass.embedded_protocol.OutboundMessage.LogEvent.Type
	(ProtocolError_ErrorType)(0),                           // 3: sass.embedded_protocol.ProtocolError.ErrorType
	(Value_Singleton)(0),                                   // 4: sass.embedded_protocol.Value.Singleton
	(Value_List_Separator)(0),                              // 5: sass.embedded_protocol.Value.List.Separator
	(*InboundMessage)(nil),                                 // 6: sass.embedded_protocol.InboundMessage
	(*OutboundMessage)(nil),                                // 7: sass.embedded_protocol.OutboundMessage
	(*ProtocolError)(nil),                                  // 8: sass.embedded_protocol.ProtocolError
	(*SourceSpan)(nil),                                     // 9: sass.embedded_protocol.SourceSpan
	(*Value)(nil),                                          // 10: sass.embedded_protocol.Value
	(*InboundMessage_CompileRequest)(nil),                  // 11: sass.embedded_protocol.InboundMessage.CompileRequest
	(*InboundMessage_CanonicalizeResponse)(nil),            // 12: sass.embedded_protocol.InboundMessage.CanonicalizeResponse
	(*InboundMessage_ImportResponse)(nil),                  // 13: sass.embedded_protocol.InboundMessage.ImportResponse
	(*InboundMessage_FileImportResponse)(nil),              // 14: sass.embedded_protocol.InboundMessage.FileImportResponse
	(*InboundMessage_FunctionCallResponse)(nil),            // 15: sass.embedded_protocol.InboundMessage.FunctionCallResponse
	(*InboundMessage_CompileRequest_StringInput)(nil),      // 16: sass.embedded_protocol.InboundMessage.CompileRequest.StringInput
	(*InboundMessage_CompileRequest_Importer)(nil),         // 17: sass.embedded_protocol.InboundMessage.CompileRequest.Importer
	(*InboundMessage_ImportResponse_ImportSuccess)(nil),    // 18: sass.embedded_protocol.InboundMessage.ImportResponse.ImportSuccess
	(*OutboundMessage_CompileResponse)(nil),                // 19: sass.embedded_protocol.OutboundMessage.CompileResponse
	(*OutboundMessage_LogEvent)(nil),                       // 20: sass.embedded_protocol.OutboundMessage.LogEvent
	(*OutboundMessage_CanonicalizeRequest)(nil),            // 21: sass.embedded_protocol.OutboundMessage.CanonicalizeRequest
	(*OutboundMessage_ImportRequest)(nil),                  // 22: sass.embedded_protocol.OutboundMessage.ImportRequest
	(*OutboundMessage_FileImportRequest)(nil),              // 23: sass.embedded_protocol.OutboundMessage.FileImportRequest
	(*OutboundMessage_FunctionCallRequest)(nil),            // 24: sass.embedded_protocol.OutboundMessage.FunctionCallRequest
	(*OutboundMessage_CompileResponse_CompileSuccess)(nil), // 25: sass.embedded_protocol.OutboundMessage.CompileResponse.CompileSuccess
	(*OutboundMessage_CompileResponse_CompileFailure)(nil), // 26: sass.embedded_protocol.OutboundMessage.CompileResponse.CompileFailure
	(*SourceSpan_SourceLocation)(nil),                      // 27: sass.embedded_protocol.SourceSpan.SourceLocation
	(*Value_String)(nil),                                   // 28: sass.embedded_protocol.Value.String
	(*Value_Number)(nil),                                   // 29: sass.embedded_protocol.Value.Number
	(*Value_RgbColor)(nil),                                 // 30: sass.embedded_protocol.Value.RgbColor
	(*Value_HslColor)(nil),                                 // 31: sass.embedded_protocol.Value.HslColor
	(*Value_List)(nil),                                     // 32: sass.embedded_protocol.Value.List
	(*Value_Map)(nil),                                      // 33: sass.embedded_protocol.Value.Map
	(*Value_CompilerFunction)(nil),                         // 34: sass.embedded_protocol.Value.CompilerFunction
	(*Value_HostFunction)(nil),                             // 35: sass.embedded_protocol.Value.HostFunction
	(*Value_Map_Entry)(nil),                                // 36: sass.embedded_protocol.Value.Map.Entry
}
var file_embedded_sass_proto_depIdxs = []int32{
	11, // 0: sass.embedded_protocol.InboundMessage.compileRequest:type_name -> sass.embedded_protocol.InboundMessage.CompileRequest
	12, // 1: sass.embedded_protocol.InboundMessage.canonicalizeResponse:type_name -> sass.embedded_protocol.InboundMessage.CanonicalizeResponse
	13, // 2: sass.embedded_protocol.InboundMessage.importResponse:type_name -> sass.embedded_protocol.InboundMessage.ImportResponse
	14, // 3: sass.embedded_protocol.InboundMessage.fileImportResponse:type_name -> sass.embedded_protocol.InboundMessage.FileImportResponse
	15, // 4: sass.embedded_protocol.InboundMessage.functionCallResponse:type_name -> sass.embedded_protocol.InboundMessage.FunctionCallResponse
	8,  // 5: sass.embedded_protocol.OutboundMessage.error:type_name -> sass.embedded_protocol.ProtocolError
	19, // 6: sass.embedded_protocol.OutboundMessage.compileResponse:type_name -> sass.embedded_protocol.OutboundMessage.CompileResponse
	20, // 7: sass.embedded_protocol.OutboundMessage.logEvent:type_name -> sass.embedded_protocol.OutboundMessage.LogEvent
	21, // 8: sass.embedded_protocol.OutboundMessage.canonicalizeRequest:type_name -> sass.embedded_protocol.OutboundMessage.CanonicalizeRequest
	22, // 9: sass.embedded_protocol.OutboundMessage.importRequest:type_name -> sass.embedded_protocol.OutboundMessage.ImportRequest
	23, // 10: sass.embedded_protocol.OutboundMessage.fileImportRequest:type_name -> sass.embedded_protocol.OutboundMessage.FileImportRequest
	24, // 11: sass.embedded_protocol.OutboundMessage.functionCallRequest:type_name -> sass.embedded_protocol.OutboundMessage.FunctionCallRequest
	3,  // 12: sass.embedded_protocol.ProtocolError.type:type_name -> sass.embedded_protocol.ProtocolError.ErrorType
	27, // 13: sass.embedded_protocol.SourceSpan.start:type_name -> sass.embedded_protocol.SourceSpan.SourceLocation
	27, // 14: sass.embedded_protocol.SourceSpan.end:type_name -> sass.embedded_protocol.SourceSpan.SourceLocation
	28, // 15: sass.embedded_protocol.Value.string:type_name -> sass.embedded_protocol.Value.String
	29, // 16: sass.embedded_protocol.Value.number:type_name -> sass.embedded_protocol.Value.Number
	30, // 17: sass.embedded_protocol.Value.rgb_color:type_name -> sass.embedded_protocol.Value.RgbColor
	31, // 18: sass.embedded_protocol.Value.hsl_color:type_name -> sass.embedded_protocol.Value.HslColor
	32, // 19: sass.embedded_protocol.Value.list:type_name -> sass.embedded_protocol.Value.List
	33, // 20: sass.embedded_protocol.Value.map:type_name -> sass.embedded_protocol.Value.Map
	4,  // 21: sass.embedded_protocol.Value.singleton:type_name -> sass.embedded_protocol.Value.Singleton
	34, // 22: sass.embedded_protocol.Value.compiler_function:type_name -> sass.embedded_protocol.Value.CompilerFunction
	35, // 23: sass.embedded_protocol.Value.host_function:type_name -> sass.embedded_protocol.Value.HostFunction
	16, // 24: sass.embedded_protocol.InboundMessage.CompileRequest.string:type_name -> sass.embedded_protocol.InboundMessage.CompileRequest.StringInput
	1,  // 25: sass.embedded_protocol.InboundMessage.CompileRequest.style:type_name -> sass.embedded_protocol.InboundMessage.CompileRequest.OutputStyle
	17, // 26: sass.embedded_protocol.InboundMessage.CompileRequest.importers:type_name -> sass.embedded_protocol.InboundMessage.CompileRequest.Importer
	18, // 27: sass.embedded_protocol.InboundMessage.ImportResponse.success:type_name -> sass.embedded_protocol.InboundMessage.ImportResponse.ImportSuccess
	10, // 28: sass.embedded_protocol.InboundMessage.FunctionCallResponse.success:type_name -> sass.embedded_protocol.Value
	0,  // 29: sass.embedded_protocol.InboundMessage.CompileRequest.StringInput.syntax:type_name -> sass.embedded_protocol.InboundMessage.Syntax
	17, // 30: sass.embedded_protocol.InboundMessage.CompileRequest.StringInput.importer:type_name -> sass.embedded_protocol.InboundMessage.CompileRequest.Importer
	0,  // 31: sass.embedded_protocol.InboundMessage.ImportResponse.ImportSuccess.syntax:type_name -> sass.embedded_protocol.InboundMessage.Syntax
	25, // 32: sass.embedded_protocol.OutboundMessage.CompileResponse.success:type_name -> sass.embedded_protocol.OutboundMessage.CompileResponse.CompileSuccess
	26, // 33: sass.embedded_protocol.OutboundMessage.CompileResponse.failure:type_name -> sass.embedded_protocol.OutboundMessage.CompileResponse.CompileFailure
	2,  // 34: sass.embedded_protocol.OutboundMessage.LogEvent.type:type_name -> sass.embedded_protocol.OutboundMessage.LogEvent.Type
	9,  // 35: sass.embedded_protocol.OutboundMessage.LogEvent.span:type_name -> sass.embedded_protocol.SourceSpan
	10, // 36: sass.embedded_protocol.OutboundMessage.FunctionCallRequest.arguments:type_name -> sass.embedded_protocol.Value
	9,  // 37: sass.embedded_protocol.OutboundMessage.CompileResponse.CompileFailure.span:type_name -> sass.embedded_protocol.SourceSpan
	5,  // 38: sass.embedded_protocol.Value.List.separator:type_name -> sass.embedded_protocol.Value.List.Separator
	10, // 39: sass.embedded_protocol.Value.List.contents:type_name -> sass.embedded_protocol.Value
	36, // 40: sass.embedded_protocol.Value.Map.entries:type_name -> sass.embedded_protocol.Value.Map.Entry
	10, // 41: sass.embedded_protocol.Value.Map.Entry.key:type_name -> sass.embedded_protocol.Value
	10, // 42: sass.embedded_protocol.Value.Map.Entry.value:type_name -> sass.embedded_protocol.Value
	43, // [43:43] is the sub-list for method output_type
	43, // [43:43] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_embedded_sass_proto_init() }
func file_embedded_sass_proto_init() {
	if File_embedded_sass_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_embedded_sass_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProtocolError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceSpan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_CompileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_CanonicalizeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_ImportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_FileImportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_FunctionCallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_CompileRequest_StringInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_CompileRequest_Importer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMessage_ImportResponse_ImportSuccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_CompileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_LogEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_CanonicalizeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_ImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_FileImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_FunctionCallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_CompileResponse_CompileSuccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMessage_CompileResponse_CompileFailure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceSpan_SourceLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_String); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_Number); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_RgbColor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_HslColor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_List); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_Map); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_CompilerFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_HostFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_embedded_sass_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_Map_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_embedded_sass_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*InboundMessage_CompileRequest_)(nil),
		(*InboundMessage_CanonicalizeResponse_)(nil),
		(*InboundMessage_ImportResponse_)(nil),
		(*InboundMessage_FileImportResponse_)(nil),
		(*InboundMessage_FunctionCallResponse_)(nil),
	}
	file_embedded_sass_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*OutboundMessage_Error)(nil),
		(*OutboundMessage_CompileResponse_)(nil),
		(*OutboundMessage_LogEvent_)(nil),
		(*OutboundMessage_CanonicalizeRequest_)(nil),
		(*OutboundMessage_ImportRequest_)(nil),
		(*OutboundMessage_FileImportRequest_)(nil),
		(*OutboundMessage_FunctionCallRequest_)(nil),
	}
	file_embedded_sass_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Value_String_)(nil),
		(*Value_Number_)(nil),
		(*Value_RgbColor_)(nil),
		(*Value_HslColor_)(nil),
		(*Value_List_)(nil),
		(*Value_Map_)(nil),
		(*Value_Singleton_)(nil),
		(*Value_CompilerFunction_)(nil),
		(*Value_HostFunction_)(nil),
	}
	file_embedded_sass_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*InboundMessage_CompileRequest_String_)(nil),
		(*InboundMessage_CompileRequest_Path)(nil),
	}
	file_embedded_sass_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*InboundMessage_CanonicalizeResponse_Url)(nil),
		(*InboundMessage_CanonicalizeResponse_Error)(nil),
	}
	file_embedded_sass_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*InboundMessage_ImportResponse_Success)(nil),
		(*InboundMessage_ImportResponse_Error)(nil),
	}
	file_embedded_sass_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*InboundMessage_FileImportResponse_FileUrl)(nil),
		(*InboundMessage_FileImportResponse_Error)(nil),
	}
	file_embedded_sass_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*InboundMessage_FunctionCallResponse_Success)(nil),
		(*InboundMessage_FunctionCallResponse_Error)(nil),
	}
	file_embedded_sass_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*InboundMessage_CompileRequest_Importer_Path)(nil),
		(*InboundMessage_CompileRequest_Importer_ImporterId)(nil),
		(*InboundMessage_CompileRequest_Importer_FileImporterId)(nil),
	}
	file_embedded_sass_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*OutboundMessage_CompileResponse_Success)(nil),
		(*OutboundMessage_CompileResponse_Failure)(nil),
	}
	file_embedded_sass_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*OutboundMessage_FunctionCallRequest_Name)(nil),
		(*OutboundMessage_FunctionCallRequest_FunctionId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_embedded_sass_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_embedded_sass_proto_goTypes,
		DependencyIndexes: file_embedded_sass_proto_depIdxs,
		EnumInfos:         file_embedded_sass_proto_enumTypes,
		MessageInfos:      file_embedded_sass_proto_msgTypes,
	}.Build()
	File_embedded_sass_proto = out.File
	file_embedded_sass_proto_rawDesc = nil
	file_embedded_sass_proto_goTypes = nil
	file_embedded_sass_proto_depIdxs = nil
}
