/* CharBox.c generated by valac 0.12.0, the Vala compiler
 * generated from CharBox.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2004-2008,2011 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _CharBoxPrivate CharBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CharBox {
	GtkEventBox parent_instance;
	CharBoxPrivate * priv;
};

struct _CharBoxClass {
	GtkEventBoxClass parent_class;
};

struct _CharBoxPrivate {
	gchar* _letter;
	GtkShadowType _border;
	gint _points;
	GtkStateFlags _highlight;
	GtkDrawingArea* area;
};


static gpointer char_box_parent_class = NULL;

void gtk_style_context_get_color (GtkStyleContext* context, GtkStateFlags state, GdkRGBA* color);
GType char_box_get_type (void) G_GNUC_CONST;
#define CHAR_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHAR_BOX, CharBoxPrivate))
enum  {
	CHAR_BOX_DUMMY_PROPERTY,
	CHAR_BOX_LETTER,
	CHAR_BOX_BORDER,
	CHAR_BOX_POINTS,
	CHAR_BOX_HIGHLIGHT
};
static gboolean char_box_draw_request (CharBox* self, cairo_t* ctx);
GtkStateFlags char_box_get_highlight (CharBox* self);
GtkShadowType char_box_get_border (CharBox* self);
gint char_box_get_points (CharBox* self);
const gchar* char_box_get_letter (CharBox* self);
CharBox* char_box_new (const gchar* letter, GtkShadowType border);
CharBox* char_box_construct (GType object_type, const gchar* letter, GtkShadowType border);
void char_box_set_letter (CharBox* self, const gchar* value);
void char_box_set_border (CharBox* self, GtkShadowType value);
void char_box_set_points (CharBox* self, gint value);
void char_box_set_highlight (CharBox* self, GtkStateFlags value);
static GObject * char_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _char_box_draw_request_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static void char_box_finalize (GObject* obj);
static void _vala_char_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_char_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean char_box_draw_request (CharBox* self, cairo_t* ctx) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint w;
	gint _tmp1_;
	gint h;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* style;
	GtkStateFlags _tmp4_;
	GtkStateFlags _tmp5_;
	GdkRGBA color = {0};
	GtkStateFlags _tmp6_;
	GdkRGBA _tmp7_ = {0};
	cairo_text_extents_t te = {0};
	const gchar* _tmp8_ = NULL;
	cairo_text_extents_t _tmp9_ = {0};
	cairo_font_extents_t fe = {0};
	cairo_font_extents_t _tmp10_ = {0};
	const gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self->priv->area);
	w = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self->priv->area);
	h = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style = _tmp3_;
	gtk_style_context_save (style);
	gtk_style_context_add_class (style, GTK_STYLE_CLASS_RUBBERBAND);
	_tmp4_ = char_box_get_highlight (self);
	gtk_style_context_set_state (style, _tmp4_);
	_tmp5_ = char_box_get_highlight (self);
	if (_tmp5_ != GTK_STATE_FLAG_NORMAL) {
		gtk_render_background (style, ctx, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	}
	if (self->priv->_border != GTK_SHADOW_NONE) {
		gtk_render_frame (style, ctx, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	}
	_tmp6_ = char_box_get_highlight (self);
	gtk_style_context_get_color (style, _tmp6_, &_tmp7_);
	color = _tmp7_;
	cairo_set_source_rgba (ctx, color.red, color.green, color.blue, color.alpha);
	cairo_set_font_size (ctx, (gdouble) self->priv->_points);
	memset (&te, 0, sizeof (cairo_text_extents_t));
	_tmp8_ = _ (self->priv->_letter);
	cairo_text_extents (ctx, _tmp8_, &_tmp9_);
	te = _tmp9_;
	memset (&fe, 0, sizeof (cairo_font_extents_t));
	cairo_font_extents (ctx, &_tmp10_);
	fe = _tmp10_;
	cairo_move_to (ctx, ((w / 2) - te.x_bearing) - (te.width / 2), ((h / 2) - fe.descent) + (fe.height / 2));
	_tmp11_ = _ (self->priv->_letter);
	cairo_show_text (ctx, _tmp11_);
	gtk_style_context_restore (style);
	result = TRUE;
	_g_object_unref0 (style);
	return result;
}


CharBox* char_box_construct (GType object_type, const gchar* letter, GtkShadowType border) {
	CharBox * self = NULL;
	g_return_val_if_fail (letter != NULL, NULL);
	self = (CharBox*) g_object_new (object_type, NULL);
	char_box_set_letter (self, letter);
	char_box_set_border (self, border);
	return self;
}


CharBox* char_box_new (const gchar* letter, GtkShadowType border) {
	return char_box_construct (TYPE_CHAR_BOX, letter, border);
}


const gchar* char_box_get_letter (CharBox* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_letter;
	return result;
}


void char_box_set_letter (CharBox* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_letter);
	self->priv->_letter = _tmp0_;
	g_object_notify ((GObject *) self, "letter");
}


GtkShadowType char_box_get_border (CharBox* self) {
	GtkShadowType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border;
	return result;
}


void char_box_set_border (CharBox* self, GtkShadowType value) {
	g_return_if_fail (self != NULL);
	self->priv->_border = value;
	g_object_notify ((GObject *) self, "border");
}


gint char_box_get_points (CharBox* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_points;
	return result;
}


void char_box_set_points (CharBox* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_points = value;
	g_object_notify ((GObject *) self, "points");
}


GtkStateFlags char_box_get_highlight (CharBox* self) {
	GtkStateFlags result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_highlight;
	return result;
}


void char_box_set_highlight (CharBox* self, GtkStateFlags value) {
	g_return_if_fail (self != NULL);
	self->priv->_highlight = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "highlight");
}


static gboolean _char_box_draw_request_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = char_box_draw_request (self, cr);
	return result;
}


static GObject * char_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CharBox * self;
	GtkDrawingArea* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (char_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CHAR_BOX (obj);
	_tmp0_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	_g_object_unref0 (self->priv->area);
	self->priv->area = g_object_ref_sink (_tmp0_);
	g_signal_connect_object ((GtkWidget*) self->priv->area, "draw", (GCallback) _char_box_draw_request_gtk_widget_draw, self, 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->area);
	return obj;
}


static void char_box_class_init (CharBoxClass * klass) {
	char_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CharBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_char_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_char_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = char_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = char_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_LETTER, g_param_spec_string ("letter", "letter", "letter", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_BORDER, g_param_spec_enum ("border", "border", "border", GTK_TYPE_SHADOW_TYPE, GTK_SHADOW_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_POINTS, g_param_spec_int ("points", "points", "points", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_HIGHLIGHT, g_param_spec_flags ("highlight", "highlight", "highlight", GTK_TYPE_STATE_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void char_box_instance_init (CharBox * self) {
	gchar* _tmp0_;
	self->priv = CHAR_BOX_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("?");
	self->priv->_letter = _tmp0_;
	self->priv->_border = GTK_SHADOW_NONE;
	self->priv->_highlight = GTK_STATE_FLAG_NORMAL;
}


static void char_box_finalize (GObject* obj) {
	CharBox * self;
	self = CHAR_BOX (obj);
	_g_free0 (self->priv->_letter);
	_g_object_unref0 (self->priv->area);
	G_OBJECT_CLASS (char_box_parent_class)->finalize (obj);
}


GType char_box_get_type (void) {
	static volatile gsize char_box_type_id__volatile = 0;
	if (g_once_init_enter (&char_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CharBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) char_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CharBox), 0, (GInstanceInitFunc) char_box_instance_init, NULL };
		GType char_box_type_id;
		char_box_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "CharBox", &g_define_type_info, 0);
		g_once_init_leave (&char_box_type_id__volatile, char_box_type_id);
	}
	return char_box_type_id__volatile;
}


static void _vala_char_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CharBox * self;
	self = CHAR_BOX (object);
	switch (property_id) {
		case CHAR_BOX_LETTER:
		g_value_set_string (value, char_box_get_letter (self));
		break;
		case CHAR_BOX_BORDER:
		g_value_set_enum (value, char_box_get_border (self));
		break;
		case CHAR_BOX_POINTS:
		g_value_set_int (value, char_box_get_points (self));
		break;
		case CHAR_BOX_HIGHLIGHT:
		g_value_set_flags (value, char_box_get_highlight (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_char_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CharBox * self;
	self = CHAR_BOX (object);
	switch (property_id) {
		case CHAR_BOX_LETTER:
		char_box_set_letter (self, g_value_get_string (value));
		break;
		case CHAR_BOX_BORDER:
		char_box_set_border (self, g_value_get_enum (value));
		break;
		case CHAR_BOX_POINTS:
		char_box_set_points (self, g_value_get_int (value));
		break;
		case CHAR_BOX_HIGHLIGHT:
		char_box_set_highlight (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



