require "test/unit"
require "fileutils"
require "numru/dclext/gtk"
include NumRu


class TestSet < Test::Unit::TestCase
  DUMP_FNAME = ".dclext_test"

  def setup
    @padding = 2

    @width = 15
    @height = 10

    @drawing_area = Gtk::DrawingArea.new
    @drawing_area.set_size_request(@width+@padding*2, @height+@padding*2)
    @drawing_area.show
    window = Gtk::Window.new(Gtk::Window::TOPLEVEL)
    window.add(@drawing_area)
    @drawing_area.realize
    @pixmap = Gdk::Pixmap.new(window.window, @width, @height, -1)

    DCL.zgsdrw(@drawing_area)
    DCL.zgspmp(@pixmap)
    DCL.gropn(4)
  end
  def teardown
    DCL.grcls
  end

  def test_set_gobj
    assert_equal @drawing_area, DCLExt.zgqdrw
    assert_equal @pixmap,  DCLExt.zgqpmp
  end

end

