########################################################################
# ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
# Copyright (C) 1998--2011 Keiichi Ishioka <ishioka@gfd-dennou.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.
########################################################################
.text
.globl ljnswg_
ljnswg_:
       movl (%rdi), %edi  # : JH  rdi 
       vbroadcastsd  (%rsi), %ymm0 # S1R  ymm0 4ս
       vbroadcastsd 8(%rsi), %ymm1 # S1I  ymm1 4ս
       vbroadcastsd  (%rdx), %ymm2 # S2R  ymm2 4ս
       vbroadcastsd 8(%rdx), %ymm3 # S2I  ymm3 4ս
       vbroadcastsd  (%rcx), %ymm4 # R  ymm4 4ս	

       movq  8(%rsp), %r10  # : QB Υ١ɥ쥹       
       movq 16(%rsp), %r11  # : W1R Υ١ɥ쥹
       movq 24(%rsp), %rsi  # : W2R Υ١ɥ쥹                     
       
      # Y : r8, QA: r9, QB: r10, W1R: r11, W2R: rsi
      # W1I: rcx, W2I: rdi

       shlq $3,%rdi # JH*8  rdi 
       movq $0,%rdx
       subq %rdi,%rdx
       
       movq %r11,%rcx
       addq %rdi,%rcx
       addq %rsi,%rdi

       subq %rdx,%r8	
       subq %rdx,%r9
       subq %rdx,%r10
       subq %rdx,%r11
       subq %rdx,%rcx
       subq %rdx,%rsi
       subq %rdx,%rdi	

.align 16
.L0:
       vmulpd (%r8,%rdx),%ymm4,%ymm5 # Y*R		
       vmovapd (%r9,%rdx), %ymm6 # QA
       vmulpd %ymm6,%ymm5,%ymm5 # R*Y*QA	
       vaddpd (%r10,%rdx), %ymm5,%ymm5 # 줿 QB  ymm5 
       
       vmulpd %ymm0,%ymm6,%ymm7 # S1R*QA
       vaddpd (%r11,%rdx),%ymm7,%ymm7 # 줿 W1R  ymm7 
       vmulpd %ymm1,%ymm6,%ymm8 # S1I*QA
       vaddpd (%rcx,%rdx),%ymm8,%ymm8 # 줿 W1I  ymm8 
       vmulpd %ymm2,%ymm6,%ymm9 # S2R*QA
       vaddpd (%rsi,%rdx),%ymm9,%ymm9 # 줿 W2R  ymm9 
       vmulpd %ymm3,%ymm6,%ymm10 # S2I*QA
       vaddpd (%rdi,%rdx),%ymm10,%ymm10 # 줿 W2I  ymm10 
       
       vmovaps %ymm5,(%r10,%rdx) # 줿 QB 򥹥ȥ	
       vmovaps %ymm7,(%r11,%rdx)	
       vmovaps %ymm8,(%rcx,%rdx)	
       vmovaps %ymm9,(%rsi,%rdx)	
       vmovaps %ymm10,(%rdi,%rdx)

       addq $32,%rdx
       jnz .L0
       
       ret
       
