########################################################################
# ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
# Copyright (C) 1998--2011 Keiichi Ishioka <ishioka@gfd-dennou.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.
########################################################################
.text
.globl ljngws_
ljngws_:
       pushq %r12
       vzeroall 
       vbroadcastsd  (%rcx), %ymm4 # R  ymm4 4ս
       movl (%rdi), %ecx  # : JH  rcx 	

       shlq $3,%rcx # JH*8  rcx 
       movq $0,%rdi
       subq %rcx,%rdi

       movq 16(%rsp), %r10  # : QB Υ١ɥ쥹       
       movq 24(%rsp), %r11  # : W1R Υ١ɥ쥹
       movq 32(%rsp), %r12  # : W2R Υ١ɥ쥹                     
       
      # Y : r8, QA: r9, QB: r10, W1R: r11, W2R: r12, W1I: rax, W2I: rcx

       subq %rdi,%r8	
       subq %rdi,%r9
       subq %rdi,%r10
       subq %rdi,%r11
       subq %rdi,%r12

       movq %r11,%rax
       movq %r12,%rcx
       subq %rdi,%rax
       subq %rdi,%rcx

.align 16
.L0:
       vmulpd (%r8,%rdi),%ymm4,%ymm5 # Y*R		
       vmovapd (%r9,%rdi), %ymm6 # QA
       vmulpd %ymm6,%ymm5,%ymm5 # R*Y*QA	
       vaddpd (%r10,%rdi), %ymm5,%ymm5 # 줿 QB  ymm5 
       vmulpd (%r11,%rdi),%ymm6,%ymm7 # W1R*QA  ymm7 
       vmulpd (%rax,%rdi),%ymm6,%ymm8 # W1I*QA  ymm8 	
       vmulpd (%r12,%rdi),%ymm6,%ymm9 # W2R*QA  ymm9 
       vmulpd (%rcx,%rdi),%ymm6,%ymm10 # W2I*QA  ymm10 	
       vaddpd %ymm7,%ymm0,%ymm0
       vaddpd %ymm8,%ymm1,%ymm1
       vaddpd %ymm9,%ymm2,%ymm2
       vaddpd %ymm10,%ymm3,%ymm3
       vmovaps %ymm5,(%r10,%rdi) # 줿 QB 򥹥ȥ	
       addq $32,%rdi
       jnz .L0

       vmovapd (%r11),%ymm5 # W1I Ƭö ymm5 
       vmovapd %ymm0,(%r11) # ymm0  W1I Ƭ
       fldl (%r11)
       faddl 8(%r11)
       faddl 16(%r11)
       faddl 24(%r11)			
       fstpl (%rsi) # S1R ¤ (%rsi) 
       vmovapd %ymm1,(%r11) # ymm0  W1I Ƭ
       fldl (%r11)
       faddl 8(%r11)
       faddl 16(%r11)
       faddl 24(%r11)			
       fstpl 8(%rsi) # S1I ¤ 8(%rsi) 
       vmovapd %ymm2,(%r11) # ymm2  W1I Ƭ
       fldl (%r11)
       faddl 8(%r11)
       faddl 16(%r11)
       faddl 24(%r11)			
       fstpl (%rdx) # S2R ¤ (%rdx) 
       vmovapd %ymm3,(%r11) # ymm3  W1I Ƭ
       fldl (%r11)
       faddl 8(%r11)
       faddl 16(%r11)
       faddl 24(%r11)			
       fstpl 8(%rdx) # S2I ¤ 8(%rdx) 
       vmovapd %ymm5,(%r11) # W1I Ƭ

       popq %r12
       
       ret
       
