!--
!----------------------------------------------------------------------
! Copyright(c) 2002-2013 SPMDODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  et_module
!      2 ϩΰ, Fourier Ÿ + Chebyshev Ÿˡ
!
!      spml/et_module ⥸塼 2 ϩΰǤήαư
!      ڥȥˡˤͷ׻¹Ԥ뤿 Fortran90 ؿ󶡤.
!      Ūʶ򰷤 X ؤΥաꥨѴȶɤ򰷤
!      Y ΥӥѴѤΥڥȥ׻ΤΤޤޤ
!      ؿ󶡤.
!
!       ae_module, at_module ѤƤ.
!      ǲǤϥաꥨѴӥӥѴΥ󥸥Ȥ
!      ISPACK/FTPACK  Fortran77 ֥롼ѤƤ.
!
!
!  2002/01/27  ݹ
!      2002/03/30  ݹ  ⥸塼̾ѹ
!      2002/08/19  ݹ  ʻҥǡź gg -> xy, eg -> ey ѹ
!                            ʬʿѴؿɲ
!      2005/01/09  ݹ  msgdmp -> MessageNotify ѹ
!      2005/03/15  ݹ  xy -> yx ƬҤѹ
!      2006/03/04  ݹ  ;פѿ(et_Jacobian_et_et)
!      2006/03/06  ݹ  Ȥ RDoc Ѥ˽
!      2007/11/20  ݹ  -ήؿ׻˹ꥹåƳ
!      2007/11/21  ݹ  ֥롼å
!      2009/01/09  ݹ  et_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ˽
!      2009/07/31  ݹ  ׻ threadprivate (OpenMP)
!      2010/03/10  ʿ  threadprivate (ѥ¸)
!      2011/03/06  ʿ 凉å, RR ǥեȤ.
!      2011/12/03  ݹ  ִؿɲ
!      2012/07/08  ݹ  et_Vor2Strm_et ɲ
!      2013/08/20  ݹ  gnu fortran б
!
!++
module et_module
  !
  != et_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: et_module.f90 598 2013-08-20 03:23:44Z takepiro $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! 2 ϩΰ, Fourier Ÿ + Chebyshev Ÿˡ
  !
  ! spml/et_module ⥸塼 2 ϩΰǤήαư
  ! ڥȥˡˤͷ׻¹Ԥ뤿 Fortran90 ؿ󶡤.
  ! Ūʶ򰷤 X ؤΥաꥨѴȶɤ򰷤
  ! Y ΥӥѴѤΥڥȥ׻ΤΤޤޤ
  ! ؿ󶡤.
  !
  !  ae_module, at_module ѤƤ.
  ! ǲǤϥաꥨѴӥӥѴΥ󥸥Ȥ
  ! ISPACK/FTPACK  Fortran77 ֥롼ѤƤ.
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (et_, yx_, x_, y_) , ֤ͤη򼨤Ƥ.
  !   et_ :: 2ڥȥǡ
  !   yx_ :: 2 ʻǡ
  !   x_  :: X  1 ʻǡ
  !   y_  :: Y  1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(Dx, Dy, Lapla, LaplaInv, Jacobian),
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_et_et, _et, _yx, _x, _y) , ѿΥڥȥǡ
  !   ӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _et    :: 2ڥȥǡ
  !   _et_et :: 2 Ĥ2ڥȥǡ
  !   _yx    :: 2 ʻǡ
  !   _x     :: X  1 ʻǡ
  !   _y     :: Y  1 ʻǡ
  !
  !=== ƥǡμ
  !
  ! * yx : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:jm,0:im-1).
  !   * im, jm Ϥ줾 X, Y ɸγʻǤ, ֥롼
  !     et_initial ˤƤ餫ꤷƤ.
  !   *  1  Y ɸγʻֹ,  2  X ɸ
  !     ʻֹǤ (X, Y νǤϤʤ)Ȥ.
  !
  ! * et : 2 ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-km:km,0:lm).
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼
  !     et_initial ˤƤ餫ꤷƤ.
  !   * ڥȥǡγǼΤˤĤƤ...
  !
  ! * x, y : X, Y  1 ʻǡ.
  !   * ѿμȼϤ줾 real(8), dimension(0:im-1)
  !      real(8), dimension(0:jm).
  !
  ! * e, t : 1 ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-km:km)
  !      real(8), dimension(-lm:lm).
  !
  ! * ax, ay : 1 ʻǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(:,0:im-1)
  !      real(8), dimension(:,0:jm).
  !
  ! * ae, at : 1 ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(:,-km:km)
  !      real(8), dimension(:,0:lm).
  !
  ! * et_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * yx_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !== ѿ³
  !
  !==== 
  !
  ! et_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  !
  !==== ɸѿ
  !
  ! x_X, y_Y     ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! x_X_Weight, y_Y_Weight ::  ŤߺɸǼ 1 
  ! yx_X, yx_Y   :: ʻǡ XY ɸ(X,Y)(ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! yx_et :: ڥȥǡʻҥǡؤѴ
  ! et_yx :: ʻҥǡ饹ڥȥǡؤѴ
  ! ax_ae, x_e :: X ΥڥȥǡʻҥǡؤѴ
  ! ay_at, y_t :: Y ΥڥȥǡʻҥǡؤѴ
  ! ae_ax, e_x :: X γʻǡ饹ڥȥǡؤѴ
  ! at_ay, t_y :: Y γʻǡ饹ڥȥǡؤѴ
  !
  !==== ʬ
  !
  ! et_Lapla_et  :: ڥȥǡ˥ץ饷Ѥ
  ! et_Dx_et, ae_Dx_ae, e_Dx_e :: ڥȥǡ X ʬѤ
  ! et_Dy_et, at_Dy_at, t_Dy_t :: ڥȥǡ Y ʬѤ
  ! et_Jacobian_et_et :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  !==== 
  !
  ! et_Boundaries  :: ǥꥯ, Υޥ󶭳Ŭ
  ! et_LaplaInv_et :: ڥȥǡ˥ץ饷εѴѤ
  ! et_Vor2Strm_et :: ٤ή׻
  ! ey_Vor2Strm_ey :: ٤ή׻
  !
  !==== ʬʿ
  !
  ! IntYX_yx, AvrYX_yx   :: 2 ʻǡΰʬʿ
  ! y_IntX_yx, y_AvrX_yx :: 2 ʻǡ X ʬʿ
  ! IntX_x, AvrX_x       :: 1 (X)ʻǡ X ʬʿ
  ! x_IntY_yx, x_AvrY_yx :: 2 ʻǡ Y ʬʿ
  ! IntY_y, AvrY_y       :: 1 (Y)ʻǡ Y ʬʿ
  !
  !==== 
  !
  ! Interpolate_et       :: ڥȥǡκɸͤ
  !
  use dc_message
  use lumatrix
  use ae_module, x_X => g_X, x_X_weight => g_X_Weight, &
                 e_x => e_g, ae_ax => ae_ag, &
                 x_e => g_e, ax_ae => ag_ae
  use at_module, y_Y => g_X, y_Y_Weight => g_X_Weight, &
                 at_ay => at_ag, t_y => t_g, &
                 ay_at => ag_at, y_t => g_t, &
                 t_Dy_t => t_Dx_t, at_Dy_at => at_Dx_at

  implicit none
  private

  public et_Initial                                       ! 
  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y     ! ɸѿ

  public yx_et, et_yx                                     ! Ѵ
  public yx_ey, ey_yx                                     ! Ѵ
  public ey_et, et_ey                                     ! Ѵ
  public e_x, x_e, ae_ax, ax_ae                           ! Ѵ
  public t_y, y_t, at_ay, ay_at                           ! Ѵ

  public et_Dx_et, e_Dx_e, ae_Dx_ae                       ! ʬ
  public et_Dy_et, t_Dy_t, at_Dy_at                       ! ʬ
  public et_Lapla_et                                      ! ʬ

  public et_Jacobian_et_et                                ! ׻

  public et_Boundaries                                    ! 
  public at_Boundaries_DD, at_Boundaries_DN               ! 
  public at_Boundaries_ND, at_Boundaries_NN               ! 
  public et_LaplaInv_et, ey_Vor2Strm_ey                   ! 
  public et_Vor2Strm_et                                   ! 

  public IntYX_yx, y_IntX_yx, x_IntY_yx, IntX_x, IntY_y   ! ʬ
  public AvrYX_yx, y_AvrX_yx, x_AvrY_yx, AvrX_x, AvrY_y   ! ʿ

  public Interpolate_et                                   ! 

  integer            :: im=32, jm=8      ! ʻ(X,Y)
  integer            :: km=10, lm=5      ! ȿ(X,Y)
  real(8)            :: xl=2.0, yl=1.0   ! ΰ礭
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:), allocatable :: yx_X, yx_Y

  save im, jm, km, lm, xl, yl

  contains
  !---------------  -----------------
    subroutine et_Initial(i,j,k,l,xmin,xmax,ymin,ymax)
      !
      ! ڥȥѴγʻ, ȿ, ΰ礭ꤹ.
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      integer,intent(in) :: i           ! ʻ(X)
      integer,intent(in) :: j           ! ʻ(Y)
      integer,intent(in) :: k           ! ȿ(X)
      integer,intent(in) :: l           ! ȿ(Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      im = i       ; jm = j
      km = k       ; lm = l
      xl = xmax-xmin ; yl = ymax-ymin

      call ae_initial(im,km,xmin,xmax)
      call at_initial(jm,lm,ymin,ymax)

      allocate(yx_X(0:jm,0:im-1),yx_Y(0:jm,0:im-1))
      yx_X = spread(x_X,1,jm+1)
      yx_Y = spread(y_Y,2,im)

      call MessageNotify('M','et_initial','et_module (2013/08/20) is initialized')
    end subroutine et_initial

  !--------------- Ѵ -----------------

    function yx_et(et)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_et
      !(out) ʻǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ڥȥǡ

      real(8), dimension(-km:km,0:jm)              :: ey
      real(8), dimension(0:jm,-km:km)              :: ye

      integer :: j, k
      
      !yx_et = ax_ae(transpose(ay_at(et)))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !
      ey = ay_at(et)
      do j=0,jm
         do k=-km,km
            ye(j,k) = ey(k,j)
         enddo
      enddo
      yx_et = ax_ae(ye)

    end function yx_et

    function et_yx(yx)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      real(8), dimension(-km:km,0:jm)              :: ey
      real(8), dimension(0:jm,-km:km)              :: ye

      integer :: j, k

      !et_yx = at_ay(transpose(ae_ax(yx)))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !
      ye = ae_ax(yx)
      do j=0,jm
         do k=-km,km
            ey(k,j) = ye(j,k) 
         enddo
      enddo
      et_yx = at_ay(ey)

    end function et_yx

    function yx_ey(ey)
      !
      ! X ɸڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_ey
      !(out) ʻǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ڥȥǡ

      real(8), dimension(0:jm,-km:km)              :: ye

      integer :: j, k
      
      !yx_ey = ax_ae(transpose(ey))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !
      do j=0,jm
         do k=-km,km
            ye(j,k) = ey(k,j)
         enddo
      enddo
      yx_ey = ax_ae(ye)

    end function yx_ey

    function ey_yx(yx)
      !
      ! X ɸʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      real(8), dimension(0:jm,-km:km)              :: ye

      integer :: j, k

      !ey_yx = transpose(ae_ax(yx))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !
      ye = ae_ax(yx)
      do j=0,jm
         do k=-km,km
            ey_yx(k,j) = ye(j,k) 
         enddo
      enddo

    end function ey_yx

    function et_ey(ey)
      !
      ! Y ɸγʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      et_ey = at_ay(ey)

    end function et_ey

    function ey_et(et)
      !
      ! Y ɸڥȥǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_et
      !(out) ʻǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ڥȥǡ

      ey_et = ay_at(et)

    end function ey_et

  !--------------- ʬ׻ -----------------

    function et_Dx_et(et)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,0:lm)                :: et_Dx_et
      real(8), dimension(-km:km,0:lm), intent(in)    :: et
      integer k

      do k=-km,km
         et_Dx_et(k,:)  =  (-2*pi*k/xl)*et(-k,:)
      enddo
    end function et_Dx_et

    function et_Dy_et(et)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm)               :: et_Dy_et
      !(out) ڥȥǡ Y ʬ

      real(8), dimension(-km:km,0:lm), intent(in)   :: et
      !(in) ϥڥȥǡ

      et_Dy_et = at_Dy_at(et)

    end function et_Dy_et

    function et_Lapla_et(et)
      !
      ! ϥڥȥǡ˥ץ饷(xx+yy)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm)                :: et_Lapla_et
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-km:km,0:lm), intent(in)    :: et
      !(in) ϥڥȥǡ

      integer k

      do k=-km,km
         et_Lapla_et(k,:) = -(2*pi*k/xl)**2*et(k,:)
      enddo

      et_Lapla_et = et_Lapla_et + et_Dy_et(et_Dy_et(et))

    end function et_Lapla_et

    function et_Jacobian_et_et(et_a,et_b)
      !
      !  2 ĤΥڥȥǡ䥳ӥ
      !
      !     J(A,B)=(xA)(yB)-(yA)(xB)
      !
      !  ׻.
      !
      !  2 ĤΥڥȥǡΥ䥳ӥȤ, б 2 Ĥ
      !  ʻǡΥ䥳ӥΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm)                :: et_Jacobian_et_et
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), dimension(-km:km,0:lm), intent(in)    :: et_a
      !(in) 1ܤϥڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)    :: et_b
      !(in) 2ܤϥڥȥǡ

      et_Jacobian_et_et = et_yx(&
           yx_et(et_Dx_et(et_a)) * yx_et(et_Dy_et(et_b)) &
           -yx_et(et_Dy_et(et_a)) * yx_et(et_Dx_et(et_b)) )

    end function et_Jacobian_et_et


  !---------------  -----------------

    subroutine et_Boundaries(et,values,cond)
      !
      ! ǥꥯ, ΥޥŬ. ӥն֤Ǥη׻
      !
      ! ºݤˤǸƤФƤ at_module Υ֥롼 at_Boundaries_DD,
      ! at_Boundaries_DN, at_Boundaries_ND, at_Boundaries_NN ѤƤ.
      ! ľܸƤ֤Ȥ.
      !
      real(8), dimension(-km:km,0:lm),intent(inout)      :: et
              ! ŬѤǡ. 줿֤ͤ.

      real(8), dimension(-km:km,2), intent(in), optional :: values
              ! Ǥ / ʬۤʿڥȥѴΤͿ.
              ! ά/ 0 Ȥʤ.

      character(len=2), intent(in), optional             :: cond
              ! . ά 'RR'
              !   DD : ξüǥꥯ
              !   DN,ND : ǥꥯ/Υޥ
              !   NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_Boundaries_DD(et,values)
         else
            call at_Boundaries_DD(et)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_Boundaries_NN(et,values)
         else
            call at_Boundaries_NN(et)
         endif
      case ('DN')
         if (present(values)) then
            call at_Boundaries_DN(et,values)
         else
            call at_Boundaries_DN(et)
         endif
      case ('ND')
         if (present(values)) then
            call at_Boundaries_ND(et,values)
         else
            call at_Boundaries_ND(et)
         endif
      case ('DD')
         if (present(values)) then
            call at_Boundaries_DD(et,values)
         else
            call at_Boundaries_DD(et)
         endif
      case default
         call MessageNotify('E','et_Boundaries','B.C. not supported')
      end select

    end subroutine et_Boundaries

    function et_LaplaInv_et(et,values)
      !
      ! ǰͤͤͿ(ǥꥯ),
      ! ϥڥȥǡ˵եץ饷(xx+yy)**(-1)Ѥ.
      !
      ! Chebyshev-tau ˡˤ׻
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm),intent(in)  :: et
      !(in) ڥȥǡ

      real(8), dimension(-km:km,0:lm)             :: et_LaplaInv_et
      !(out) ڥȥǡεեץ饷

      real(8), dimension(-km:km,2), intent(in), optional :: values
      !(in) . ά 0 ꤵ.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(-km:km,0:jm)         :: ey_work
      real(8), dimension(-km:km)              :: value1, value2   ! 

      logical :: first = .true.
      integer :: l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0.0D0 ; value2=0.0D0
      else
         value1 = values(:,1) ; value2 = values(:,2)
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         do l=0,lm
            et_work=0.0D0 ; et_work(:,l) = 1.0D0
            alu(:,:,l) = et_Lapla_et(et_work)

            ey_work = ay_at(et_work)
            alu(:,lm-1,l) = ey_work(:,0)
            alu(:,lm,l)   = ey_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      et_work = et
      et_work(:,lm-1) = value1
      et_work(:,lm)   = value2
      et_LaplaInv_et = lusolve(alu,kp,et_work)

    end function et_LaplaInv_et

    function ey_Vor2Strm_ey(ey,values,cond,new)    ! ٤ή.
      !
      ! ٤ή.
      ! Y ʻ֤Ǥ Chebyshev-Collocation ˡˤ׻
      !
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta,
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries
      !

      real(8), dimension(-km:km,0:jm),intent(in)  :: ey
              !(in) ϱʬ

      real(8), dimension(-km:km,0:jm)             :: ey_Vor2Strm_ey
              !(out) ήʬ

      real(8), dimension(2), intent(in), optional :: values
              !(in) ή. ǰʤΤȿ 0 ʬΤ
              !     ά 0.

      character(len=2), intent(in), optional  :: cond
              ! (in) 凉å. ά 'RR'
              !      RR : ξüǴ
              !      RF : üǴ岼üϤʤ
              !      FR : üϤʤüǴ
              !      FF : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:jm)         :: ey_work
      real(8), dimension(-km:km,0:jm)         :: ey_I
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1 = .true.
      logical                                 :: rigid2 = .true.

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: j
      save    :: alu, kp, first

      if (.not. present(values)) then
        value1=0.0D0 ; value2=0.0D0
      else
        value1 = values(1) ; value2 = values(2)
      endif

      if ( present(cond) ) then
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','ey_Vor2Strm_ey','B.C. not supported')
         end select
      else
         rigid1 = .TRUE.  ; rigid2 = .TRUE.
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu(-km:km,0:jm,0:jm),kp(-km:km,0:jm))

         do j=0,jm
            ey_I = 0 ; ey_I(:,j) = 1.0D0
            alu(:,:,j) = ey_et(et_Lapla_et(et_ey(ey_I)))
         enddo

         do j=0,jm
            ey_I = 0
            ey_I(:,j) = 1.0D0

            ! ưŪ. ή϶ǰ
            alu(:,0,j)   = ey_I(:,0)
            alu(:,jm,j)  = ey_I(:,jm)

            if ( rigid1 ) then                               ! Ǵ(top)
               ey_work=ey_et(et_Dy_et(et_ey(ey_I)))
            else
               ey_work=ey_et(et_Dy_et(et_Dy_et(et_ey(ey_I))))  ! ٤(top)
            endif

            alu(:,1,j) = ey_work(:,0)

            if ( rigid2 ) then                               ! Ǵ(bottom)
               ey_work=ey_et(et_Dy_et(et_ey(ey_I)))
            else
               ey_work=ey_et(et_Dy_et(et_Dy_et(et_ey(ey_I))))  ! ٤(bottom)
            endif
            alu(:,jm-1,j) = ey_work(:,jm)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','ey_Vor2Strm_ey',&
                            'Matrix for stream func. calc. produced')
      endif

      ey_work = ey
      ey_work(:,1)    = 0.0D0               ! ϳŪ
      ey_work(:,jm-1) = 0.0D0               ! ϳŪ

      ey_work(:,0) = 0.0D0                  ! ưŪ. ȿ 0 ʳ 0
      ey_work(0,0) = value1*2.0D0           ! ưŪ. ȿ 0 ϽŤ 1/2

      ey_work(:,jm)   = 0.0D0               ! ưŪ. ȿ 0 ʳ 0
      ey_work(0,jm)   = value2*2.0D0        ! ưŪ. ȿ 0 ϽŤ 1/2

      ey_Vor2Strm_ey = lusolve(alu,kp,ey_work)

    end function ey_Vor2Strm_ey

   !------------------- ٤ή ----------------------
    function et_Vor2Strm_et(et,values,cond,new)    ! ٤ή.
      !
      ! ٤ή.
      !
      ! Chebyshev-tau ˡ + Crank Nicolson ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2\psi = \zeta, 
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries
      !
      real(8), dimension(-km:km,0:lm),intent(in)  :: et
              !(in) ϱʬ

      real(8), dimension(-km:km,0:lm)             :: et_Vor2Strm_et
              !(out) ήʬ

      real(8), dimension(2), intent(in), optional :: values
              !(in) ή. ǰʤΤȿ 0 ʬΤ
              !     ά 0.

      character(len=2), intent(in), optional  :: cond
              ! (in) 凉å. ά 'RR'
              !      RR : ξüǴ
              !      RF : üǴ岼üϤʤ
              !      FR : üϤʤüǴ
              !      FF : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(-km:km,0:jm)         :: ey_work
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0.0D0 ; value2=0.0D0
      else
         value1 = values(1) ; value2 = values(2)
      endif

      if ( present(cond) ) then
         select case (cond)
         case ('RR')
           rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
           rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
           rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
           rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
           call MessageNotify('E','et_Vor2Strm_et','B.C. not supported')
         end select
      else
         rigid1 = .TRUE.  ; rigid2 = .TRUE.
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         alu = 0.0D0
         do l=0,lm-2
            et_work(:,:)= 0.0D0
            et_work(:,l)= 1.0D0

            alu(:,:,l) = et_Lapla_et(et_work)
         enddo

         do l=0,lm
            et_work(:,:)= 0.0D0
            et_work(:,l)= 1.0D0

            ! ưŪ. ή϶ǰ
            ey_work = ay_at(et_work)
            alu(:,lm,l) = ey_work(:,0)
            alu(:,lm-1,l) = ey_work(:,jm)

            if ( rigid1 ) then                   ! ϳŪǴ(Top)
               ey_work=ay_at(et_Dy_et(et_work))
               alu(:,lm-2,l) = ey_work(:,0)
            else                                 ! ϳŪ魯٤(Top)
               ey_work=ay_at(et_Dy_et(et_Dy_et(et_work)))
               alu(:,lm-2,l) = ey_work(:,0)
            endif
            if ( rigid2 ) then                   ! ϳŪǴ(bottom)
               ey_work=ay_at(et_Dy_et(et_work))
               alu(:,lm-3,l) = ey_work(:,jm)
            else                                 ! ϳŪ魯٤(bottom)
               ey_work=ay_at(et_Dy_et(et_Dy_et(et_work)))
               alu(:,lm-3,l) = ey_work(:,jm)
            endif
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','et_Vor2Strm_et',&
                            'Matrix for stream func. calc. produced')
      endif

      ! ΰ׻
      et_work = et

      et_work(:,lm-2) = 0.0D0           ! ϳŪ
      et_work(:,lm-3) = 0.0D0           ! ϳŪ

      et_work(:,lm-1) = 0.0D0        ! ưŪ. ȿ 0 ʳ 0
      et_work(0,lm-1) = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_work(:,lm)   = 0.0D0        ! ưŪ. ȿ 0 ʳ 0
      et_work(0,lm)   = value2*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_Vor2Strm_et = lusolve(alu,kp,et_work)

    end function et_Vor2Strm_et

  !--------------- ʬ׻ -----------------
    function IntYX_yx(yx)   ! ΰʬ
      !
      ! 2 ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ.
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in)  2 ʻǡ

      real(8)                           :: IntYX_yx
      !(out) ʬ

      integer :: i, j

      IntYX_yx = 0.0d0
      do i=0,im-1
         do j=0,jm
            IntYX_yx = IntYX_yx + yx(j,i) * y_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo
    end function IntYX_yx

    function y_IntX_yx(yx)  ! X ʬ
      !
      ! 2 ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ.
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm)          :: y_IntX_yx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i
      ! ѿ

      y_IntX_yx = 0.0d0
      do i=0,im-1
         y_IntX_yx(:) = y_IntX_yx(:) + yx(:,i) * x_X_Weight(i)
      enddo
    end function y_IntX_yx

    function x_IntY_yx(yx)  ! Y ʬ
      !
      ! 2 ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ.
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in)  2 ʻǡ

      real(8), dimension(0:im-1)        :: x_IntY_yx
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: j
      ! ѿ

      x_IntY_yx = 0.0d0
      do j=0,jm
         x_IntY_yx(:) = x_IntY_yx(:) + yx(j,:) * y_Y_Weight(j)
      enddo
    end function x_IntY_yx

    function IntX_x(x)      ! X ʬ
      !
      ! 1 (X)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ.
      !
      real(8), dimension(0:im-1)   :: x         !(in)  1 ʻǡ
      real(8)                      :: IntX_x    !(out) ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntY_y(y)      ! Y ʬ
      !
      ! 1 (Y)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ.
      !
      real(8), dimension(0:jm)   :: y          !(in)  1 ʻǡ
      real(8)                    :: IntY_y     !(out) ʬ

      IntY_y = sum(y*y_Y_Weight)
    end function IntY_y

  !--------------- ʿѷ׻ -----------------
    function AvrYX_yx(yx)
      !
      ! 2 ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ.
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in)  2 ʻǡ

      real(8)                           :: AvrYX_yx
      !(out) ʿ

      AvrYX_yx = IntYX_yx(yx)/(sum(x_X_weight)*sum(y_Y_weight))
    end function AvrYX_yx

    function y_AvrX_yx(yx)
      !
      ! 2 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻,
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ.
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm)          :: y_AvrX_yx
      !(out) ʿѤ줿 1 (Y)ʻ

      y_AvrX_yx = y_IntX_yx(yx)/sum(x_X_weight)
    end function y_AvrX_yx

    function x_AvrY_yx(yx)
      !
      ! 2 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻,
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ.
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)        :: x_AvrY_yx
      !(out) ʿѤ줿 1 (X)ʻ

      x_AvrY_yx = x_IntY_yx(yx)/sum(y_Y_weight)
    end function x_AvrY_yx

    function AvrX_x(x)
      !
      ! 1 (X)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻,
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ.
      !
      real(8), dimension(0:im-1)   :: x          !(in)  1 ʻǡ
      real(8)                      :: AvrX_x     !(out) ʿ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrY_y(y)
      !
      ! 1 (Y)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻,
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ.
      !
      real(8), dimension(0:jm)   :: y          !(in)  1 ʻǡ
      real(8)                    :: AvrY_y     !(out) ʿ

      AvrY_y = IntY_y(y)/sum(y_Y_weight)
    end function AvrY_y

  !--------------------- ִؿ ---------------------------
    function Interpolate_et(et_data,xval,yval)

      real(8), dimension(-km:km,0:lm), intent(IN) :: et_data
      !(in) ϥաꥨǡ

      real(8), intent(in)                         :: xval, yval
      ! ֤ X, Y ɸ

      real(8)                                     :: Interpolate_et
      ! ֤̤

      Interpolate_et = Interpolate_e(a_Interpolate_at(et_data,yval),xval)

    end function Interpolate_et

  end module et_module
