!------------------------------------------------------------------------
! Copyright (c) 2002-2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  ee_module ƥȥץ (ַ׻)
!
!  2008/10/28  ݹ
!      2011/02/15  ʿ dc_test Ȥ褦ѹ
!
program ee_test_transform

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use ee_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32            ! ʻ(X,Y)
  integer, parameter :: km=10, lm=10              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yx_Data(0:jm-1,0:im-1)    ! ʻҥǡ
  real(8)            :: yx_Data1(0:jm-1,0:im-1)   ! ʻҥǡ
  real(8)            :: ee_Data(-lm:lm,-km:km)    ! ڥȥǡ

  integer            :: k=2,l=5
  integer            :: i, j

 !---- ɸѿʤ ----
!!$  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: xmin = 0.0d0, xmax=4.0d0
!!$  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0
  real(8), parameter :: ymin = 2.0d0, ymax=4.0d0

  real(8), parameter :: x0 = 2.0/3.0, x1=3.0/5.0d0
  real(8), parameter :: y0 = 1.0/7.0, y1=5.0/9.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','ee_test_transform', &
       'ee_module transform function tests')

 !---------------- ɸͤ ---------------------
  call ee_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------

!!$  write(6,*) '  Input wavenumbers of the grid data, k and l :'
!!$  read(5,*) k,l
!!$  write(6,*) '  k,l = ', k,l

  yx_Data = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation sin(k*pi*X)*sin(l*pi*Y)')
  call check0d(sin(k*pi*x0)*sin(l*pi*y0), Interpolate_ee(ee_Data, x0, y0), &
    'check (x0, y0)')
  call check0d(sin(k*pi*x1)*sin(l*pi*y1), Interpolate_ee(ee_Data, x1, y1), &
    'check (x1, y1)')

  yx_Data = cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation cos(k*pi*X)*cos(l*pi*Y)')
  call check0d(cos(k*pi*x0)*cos(l*pi*y0), Interpolate_ee(ee_Data, x0, y0), &
    'check (x0, y0)')
  call check0d(cos(k*pi*x1)*cos(l*pi*y1), Interpolate_ee(ee_Data, x1, y1), &
    'check (x1, y1)')

  yx_Data = sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation sin(k*pi*X)*cos(l*pi*Y)')
  call check0d(sin(k*pi*x0)*cos(l*pi*y0), Interpolate_ee(ee_Data, x0, y0), &
    'check (x0, y0)')
  call check0d(sin(k*pi*x1)*cos(l*pi*y1), Interpolate_ee(ee_Data, x1, y1), &
    'check (x1, y1)')

  yx_Data = cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation cos(k*pi*X)*sin(l*pi*Y)')
  call check0d(cos(k*pi*x0)*sin(l*pi*y0), Interpolate_ee(ee_Data, x0, y0), &
    'check (x0, y0)')
  call check0d(cos(k*pi*x1)*sin(l*pi*y1), Interpolate_ee(ee_Data, x1, y1), &
    'check (x1, y1)')

  yx_Data = sin(k*pi*yx_X)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation sin(k*pi*X)')
  call check0d(sin(k*pi*x0), Interpolate_ee(ee_Data, x0, y0), &
    'check (x0, y0)')
  call check0d(sin(k*pi*x1), Interpolate_ee(ee_Data, x1, y1), &
    'check (x1, y1)')

  yx_Data = cos(k*pi*yx_X)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(ee_yx(yx_Data), ee_Data, 'Interpolation cos(k*pi*X)')

  call check0d(cos(k*pi*x0), Interpolate_ee(ee_Data, x0, y0), &
    'check (x0, y0)')
  call check0d(cos(k*pi*x1), Interpolate_ee(ee_Data, x1, y1), &
    'check (x1, y1)')

  yx_Data = cos(l*pi*yx_Y)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation cos(l*pi*Y)')
  call check0d(cos(l*pi*y0), Interpolate_ee(ee_Data, x0, y0),&
    'check (x0, y0)')
  call check0d(cos(l*pi*y1), Interpolate_ee(ee_Data, x1, y1),&
    'check (x1, y1)')

  yx_Data = sin(l*pi*yx_Y)
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation sin(l*pi*Y)')
  call check0d(sin(l*pi*y0), Interpolate_ee(ee_Data, x0, y0),&
    'check (x0, y0)')
  call check0d(sin(l*pi*y1), Interpolate_ee(ee_Data, x1, y1),&
    'check (x1, y1)')

  yx_Data = 1.0D0
  ee_Data = ee_yx(yx_Data)
  do i=0,im-1
     do j=0,jm-1
        yx_Data1(j,i) = Interpolate_ee( ee_Data, x_X(i), y_Y(j) )
     enddo
  enddo
  call check2d(yx_Data1, yx_Data, 'Interpolation 1.0')

  call check0d(1.0D0, Interpolate_ee(ee_Data, x0, y0), 'check (x0, y0)')
  call check0d(1.0D0, Interpolate_ee(ee_Data, x1, y1), 'check (x1, y1)')

  call MessageNotify('M','ee_test_Interpolate', &
       'ee_module Interpolation function tests succeeded!')

 stop
contains

  subroutine check0d(var0,sol0,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var0                     ! Ƚꤹ
    real(8) :: sol0                     ! 
    character(len=*)  :: funcname
    call AssertEqual(      &
      message = funcname,  &
      answer = sol0,       &
      check = var0,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check0d

  subroutine check2d(var,sol,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var(:,:)                ! Ƚꤹ
    real(8) :: sol(:,:)
    character(len=*) :: funcname

    call AssertEqual(     &
      message = funcname, &
      answer = sol,       &
      check = var,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check2d

end program ee_test_transform

