[//]: # (generated using SlashBack 0.2.0)

  
# norm methods  
The following methods are all part of the **norm methods**\.  
Various ways to compute vector norms\.  
## Table of contents  
  
* [**distance2** function](#distance2-function)  
* [**l1Norm** function](#l1norm-function)  
* [**l2Norm** function](#l2norm-function)  
* [**lMaxNorm** function](#lmaxnorm-function)  
* [**length2** function](#length2-function)  
* [**lxNorm** function](#lxnorm-function)  
  
### distance2\(\) function  
#### <code>glm.<code>**distance2**(**p0**: *vecN*, **p1**: *vecN*) -\> *float*</code></code>  
&emsp;&emsp;Returns the squared distance between ``` p0 ``` and ``` p1 ```, i\.e\., ``` length2(p0 - p1) ```\.  
  
### l1Norm\(\) function  
#### <code>glm.<code>**l1Norm**(**v**: *vec3*) -\> *float*</code></code>  
&emsp;&emsp;Returns the L1 norm of ``` v ```\.  
  
#### <code>glm.<code>**l1Norm**(**x**: *vec3*, **y**: *vec3*) -\> *float*</code></code>  
&emsp;&emsp;Returns the L1 norm between ``` x ``` and ``` y ```\.  
  
### l2Norm\(\) function  
#### <code>glm.<code>**l2Norm**(**v**: *vec3*) -\> *float*</code></code>  
&emsp;&emsp;Returns the L2 norm of ``` v ```\.  
  
#### <code>glm.<code>**l2Norm**(**x**: *vec3*, **y**: *vec3*) -\> *float*</code></code>  
&emsp;&emsp;Returns the L2 norm between ``` x ``` and ``` y ```\.  
  
### lMaxNorm\(\) function  
#### <code>glm.<code>**lMaxNorm**(**v**: *vec3*) -\> *float*</code></code>  
&emsp;&emsp;Returns the LMax norm of ``` v ```\.  
  
#### <code>glm.<code>**lMaxNorm**(**x**: *vec3*, **y**: *vec3*) -\> *float*</code></code>  
&emsp;&emsp;Returns the LMax norm between ``` x ``` and ``` y ```\.  
  
### length2\(\) function  
#### <code>glm.<code>**length2**(**v**: *vecN*) -\> *float*</code></code>  
&emsp;&emsp;Returns the squared length of ``` x ```\.  
  
### lxNorm\(\) function  
#### <code>glm.<code>**lxNorm**(**v**: *vec3*, **Depth**: *int*) -\> *float*</code></code>  
&emsp;&emsp;Returns the L norm of ``` v ```\.  
  
#### <code>glm.<code>**lxNorm**(**x**: *vec3*, **y**: *vec3*, **Depth**: *int*) -\> *float*</code></code>  
&emsp;&emsp;Returns the L norm between ``` x ``` and ``` y ```\.  
  
