%feature("docstring") OT::CenteredFiniteDifferenceHessian
R"RAW(Second order centered finite-difference scheme.

Available constructors:
    CenteredFiniteDifferenceHessian(*epsilon, evalImpl*)

    CenteredFiniteDifferenceHessian(*step, evalImpl*)

Parameters
----------
evalImpl : :class:`~openturns.EvaluationImplementation`
    Implementation of the evaluation of a function.
epsilon : float, sequence of float
    Finite difference steps for each dimension.
step : :class:`~openturns.FiniteDifferenceStep`
    Defines how finite difference steps values are computed.

Notes
-----
*CenteredFiniteDifferenceHessian* provides a second order centered finite-
difference scheme:

.. math::

  \frac{\partial^2 f_k}{\partial x_i \partial x_j} \approx
                                     \frac{
                                        f_k(x + \epsilon_i + \epsilon_j) -
                                        f_k(x + \epsilon_i - \epsilon_j) +
                                        f_k(x - \epsilon_i - \epsilon_j) -
                                        f_k(x - \epsilon_i + \epsilon_j)}
                                     {4 \epsilon_i \epsilon_j}

Examples
--------
>>> import openturns as ot
>>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
>>> myFunc = ot.SymbolicFunction(['x1', 'x2'], formulas)
>>> epsilon = [0.01]*2
>>> myHessian = ot.CenteredFiniteDifferenceHessian(epsilon, myFunc.getEvaluation())
>>> inPoint = [1.0]*2
>>> print(myHessian.hessian(inPoint))
sheet #0
[[  0         0.540293 ]
 [  0.540293 -0.841443 ]]
sheet #1
[[  0.416133  0.416133 ]
 [  0.416133  0.416133 ]]
sheet #2
[[  0.735783 -1.10368  ]
 [ -1.10368   1.47152  ]])RAW"
