#ifndef __RENDER_PARMS__H__
#define __RENDER_PARMS__H__

#include <optional>
#include <string>
#include <vector>

using namespace std;

class LineFilterKeyword;
class PinManager;

/* structure storing the current values of a set of render parms at the time of
 * rendering in case they change during the process
 */
struct RenderParms {
	// renderer parameters
	bool colour;
	bool line_numbers_off;
	size_t cols;
	size_t radius;
	// epoch parameters
	size_t cur_epoch;
	// filter manager parameters
	size_t context_length;
	int filter_keywords;
	vector<LineFilterKeyword*> keywords;
	PinManager* pins;
	// loglines parameters
	size_t total_length;

	// character to use as tab
	optional<char> tab_key;
	set<size_t> suppressed_tabs;
	TabData* tab_data;

	// logline pointer
	LogLines* ll;
	// navigation position
	Navigation* navi;
};

#endif  // __RENDER_PARMS__H__
