; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-gnu-linux \
; RUN:   -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names < %s | FileCheck %s

define { ppc_fp128, ppc_fp128 } @test_sincos_ppcf128(ppc_fp128 %a) {
; CHECK-LABEL: test_sincos_ppcf128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -64(r1)
; CHECK-NEXT:    std r0, 80(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    addi r5, r1, 48
; CHECK-NEXT:    addi r6, r1, 32
; CHECK-NEXT:    bl sincosl
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfd f1, 48(r1)
; CHECK-NEXT:    lfd f2, 56(r1)
; CHECK-NEXT:    lfd f3, 32(r1)
; CHECK-NEXT:    lfd f4, 40(r1)
; CHECK-NEXT:    addi r1, r1, 64
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %result = call { ppc_fp128, ppc_fp128 } @llvm.sincos.ppcf128(ppc_fp128 %a)
  ret { ppc_fp128, ppc_fp128 } %result
}

; FIXME: This could be made a tail call with the default expansion of llvm.sincos.
define void @test_sincos_ppcf128_void_tail_call(ppc_fp128 %a, ptr noalias %out_sin, ptr noalias %out_cos) {
; CHECK-LABEL: test_sincos_ppcf128_void_tail_call:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    bl sincosl
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %result = tail call { ppc_fp128, ppc_fp128 } @llvm.sincos.ppcf128(ppc_fp128 %a)
  %result.0 = extractvalue { ppc_fp128, ppc_fp128 } %result, 0
  %result.1 = extractvalue { ppc_fp128, ppc_fp128 } %result, 1
  store ppc_fp128 %result.0, ptr %out_sin, align 16
  store ppc_fp128 %result.1, ptr %out_cos, align 16
  ret void
}

; NOTE: This would need a struct-return library call for llvm.sincos to become a tail call.
define { ppc_fp128, ppc_fp128 } @test_sincos_ppcf128_tail_call(ppc_fp128 %a) {
; CHECK-LABEL: test_sincos_ppcf128_tail_call:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -64(r1)
; CHECK-NEXT:    std r0, 80(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    addi r5, r1, 48
; CHECK-NEXT:    addi r6, r1, 32
; CHECK-NEXT:    bl sincosl
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfd f1, 48(r1)
; CHECK-NEXT:    lfd f2, 56(r1)
; CHECK-NEXT:    lfd f3, 32(r1)
; CHECK-NEXT:    lfd f4, 40(r1)
; CHECK-NEXT:    addi r1, r1, 64
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %result = tail call { ppc_fp128, ppc_fp128 } @llvm.sincos.ppcf128(ppc_fp128 %a)
  ret { ppc_fp128, ppc_fp128 } %result
}
