; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -dxil-mem-intrinsics -mtriple=dxil-pc-shadermodel6.3-library %s | FileCheck %s

%struct.S = type { <4 x i32>, [2 x <4 x i32>] }

define void @test_structarray_alloca() "hlsl.export" {
; CHECK-LABEL: define void @test_structarray_alloca(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[OUT:%.*]] = alloca [[STRUCT_S:%.*]], align 16
; CHECK-NEXT:    [[IN:%.*]] = alloca [[STRUCT_S]], align 16
; CHECK-NEXT:    [[OUT_I:%.*]] = getelementptr inbounds nuw i8, ptr [[OUT]], i32 16
; CHECK-NEXT:    [[IN_I:%.*]] = getelementptr inbounds nuw i8, ptr [[IN]], i32 16
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds i8, ptr [[IN_I]], i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr [[TMP0]], align 16
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i8, ptr [[OUT_I]], i32 0
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr [[TMP2]], align 16
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[IN_I]], i32 16
; CHECK-NEXT:    [[TMP4:%.*]] = load <4 x i32>, ptr [[TMP3]], align 16
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[OUT_I]], i32 16
; CHECK-NEXT:    store <4 x i32> [[TMP4]], ptr [[TMP5]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %out = alloca %struct.S
  %in = alloca %struct.S
  %out.i = getelementptr inbounds nuw i8, ptr %out, i32 16
  %in.i = getelementptr inbounds nuw i8, ptr %in, i32 16
  tail call void @llvm.memcpy(ptr noundef nonnull align 1 dereferenceable(32) %out.i, ptr noundef nonnull align 1 dereferenceable(32) %in.i, i32 32, i1 false)
  ret void
}

define void @test_structarray_alloca_typed() "hlsl.export" {
; CHECK-LABEL: define void @test_structarray_alloca_typed(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[OUT:%.*]] = alloca [[STRUCT_S:%.*]], align 16
; CHECK-NEXT:    [[IN:%.*]] = alloca [[STRUCT_S]], align 16
; CHECK-NEXT:    [[OUT_I:%.*]] = getelementptr { <4 x i32>, [2 x <4 x i32>] }, ptr [[OUT]], i32 0, i32 1
; CHECK-NEXT:    [[IN_I:%.*]] = getelementptr { <4 x i32>, [2 x <4 x i32>] }, ptr [[IN]], i32 0, i32 1
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[IN_I]], i32 0
; CHECK-NEXT:    [[TMP0:%.*]] = load <4 x i32>, ptr [[GEP]], align 16
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr inbounds i8, ptr [[OUT_I]], i32 0
; CHECK-NEXT:    store <4 x i32> [[TMP0]], ptr [[GEP1]], align 16
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr inbounds i8, ptr [[IN_I]], i32 16
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr [[GEP2]], align 16
; CHECK-NEXT:    [[GEP3:%.*]] = getelementptr inbounds i8, ptr [[OUT_I]], i32 16
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr [[GEP3]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %out = alloca %struct.S
  %in = alloca %struct.S
  %out.i = getelementptr { <4 x i32>, [2 x <4 x i32>] }, ptr %out, i32 0, i32 1
  %in.i = getelementptr { <4 x i32>, [2 x <4 x i32>] }, ptr %in, i32 0, i32 1
  tail call void @llvm.memcpy(ptr noundef nonnull align 1 dereferenceable(32) %out.i, ptr noundef nonnull align 1 dereferenceable(32) %in.i, i32 32, i1 false)
  ret void
}

@shared1 = external hidden local_unnamed_addr addrspace(3) global %struct.S
@shared2 = external hidden local_unnamed_addr addrspace(3) global %struct.S
define void @test_structarray_groupshared() "hlsl.export" {
; CHECK-LABEL: define void @test_structarray_groupshared(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = load <4 x i32>, ptr addrspace(3) getelementptr inbounds nuw (i8, ptr addrspace(3) @shared2, i32 16), align 16
; CHECK-NEXT:    store <4 x i32> [[TMP0]], ptr addrspace(3) getelementptr inbounds nuw (i8, ptr addrspace(3) @shared1, i32 16), align 16
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr addrspace(3) getelementptr inbounds (i8, ptr addrspace(3) getelementptr inbounds nuw (i8, ptr addrspace(3) @shared2, i32 16), i32 16), align 16
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr addrspace(3) getelementptr inbounds (i8, ptr addrspace(3) getelementptr inbounds nuw (i8, ptr addrspace(3) @shared1, i32 16), i32 16), align 16
; CHECK-NEXT:    ret void
;
entry:
  tail call void @llvm.memcpy.p3.p3.i32(ptr addrspace(3) noundef nonnull align 1 dereferenceable(32) getelementptr inbounds nuw (i8, ptr addrspace(3) @shared1, i32 16), ptr addrspace(3) noundef nonnull align 1 dereferenceable(32) getelementptr inbounds nuw (i8, ptr addrspace(3) @shared2, i32 16), i32 32, i1 false)
  ret void
}

define void @test_structarray_in_buffer() "hlsl.export" {
; CHECK-LABEL: define void @test_structarray_in_buffer(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[H_OUT:%.*]] = tail call target("dx.RawBuffer", [[STRUCT_S:%.*]], 1, 0) @llvm.dx.resource.handlefrombinding.tdx.RawBuffer_s_struct.Ss_1_0t(i32 0, i32 0, i32 1, i32 0, ptr null)
; CHECK-NEXT:    [[H_IN:%.*]] = tail call target("dx.RawBuffer", [[STRUCT_S]], 0, 0) @llvm.dx.resource.handlefrombinding.tdx.RawBuffer_s_struct.Ss_0_0t(i32 0, i32 1, i32 1, i32 0, ptr null)
; CHECK-NEXT:    [[P_OUT:%.*]] = tail call noundef nonnull align 1 dereferenceable(48) ptr @llvm.dx.resource.getpointer.p0.tdx.RawBuffer_s_struct.Ss_1_0t(target("dx.RawBuffer", [[STRUCT_S]], 1, 0) [[H_OUT]], i32 0)
; CHECK-NEXT:    [[OUT_I:%.*]] = getelementptr inbounds nuw i8, ptr [[P_OUT]], i32 16
; CHECK-NEXT:    [[P_IN:%.*]] = tail call noundef nonnull align 1 dereferenceable(48) ptr @llvm.dx.resource.getpointer.p0.tdx.RawBuffer_s_struct.Ss_0_0t(target("dx.RawBuffer", [[STRUCT_S]], 0, 0) [[H_IN]], i32 0)
; CHECK-NEXT:    [[IN_I:%.*]] = getelementptr inbounds nuw i8, ptr [[P_IN]], i32 16
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds i8, ptr [[OUT_I]], i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr [[TMP0]], align 16
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i8, ptr [[IN_I]], i32 0
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr [[TMP2]], align 16
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[OUT_I]], i32 16
; CHECK-NEXT:    [[TMP4:%.*]] = load <4 x i32>, ptr [[TMP3]], align 16
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[IN_I]], i32 16
; CHECK-NEXT:    store <4 x i32> [[TMP4]], ptr [[TMP5]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %h_out = tail call target("dx.RawBuffer", %struct.S, 1, 0) @llvm.dx.resource.handlefrombinding(i32 0, i32 0, i32 1, i32 0, ptr null)
  %h_in = tail call target("dx.RawBuffer", %struct.S, 0, 0) @llvm.dx.resource.handlefrombinding(i32 0, i32 1, i32 1, i32 0, ptr null)
  %p_out = tail call noundef nonnull align 1 dereferenceable(48) ptr @llvm.dx.resource.getpointer(target("dx.RawBuffer", %struct.S, 1, 0) %h_out, i32 0)
  %out.i = getelementptr inbounds nuw i8, ptr %p_out, i32 16
  %p_in = tail call noundef nonnull align 1 dereferenceable(48) ptr @llvm.dx.resource.getpointer(target("dx.RawBuffer", %struct.S, 0, 0) %h_in, i32 0)
  %in.i = getelementptr inbounds nuw i8, ptr %p_in, i32 16
  tail call void @llvm.memcpy(ptr noundef nonnull align 1 dereferenceable(32) %in.i, ptr noundef nonnull align 1 dereferenceable(32) %out.i, i32 32, i1 false)
  ret void
}
