; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=armv7-none-eabi -float-abi=soft | FileCheck %s --check-prefixes=CHECK,CHECK-SOFT
; RUN: llc < %s -mtriple=armv7-none-eabihf -mattr=+vfp2 -float-abi=hard | FileCheck %s --check-prefixes=CHECK,CHECK-NOFP16
; RUN: llc < %s -mtriple=armv8-none-eabihf -mattr=+fp-armv8 -float-abi=hard | FileCheck %s --check-prefixes=CHECK,CHECK-FPv8
; RUN: llc < %s -mtriple=armv8-none-eabihf -mattr=+fp-armv8,+fullfp16 -float-abi=hard | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

define i64 @testmsxh_builtin(half %x) {
; CHECK-SOFT-LABEL: testmsxh_builtin:
; CHECK-SOFT:       @ %bb.0: @ %entry
; CHECK-SOFT-NEXT:    .save {r11, lr}
; CHECK-SOFT-NEXT:    push {r11, lr}
; CHECK-SOFT-NEXT:    bl __aeabi_h2f
; CHECK-SOFT-NEXT:    bl llrintf
; CHECK-SOFT-NEXT:    pop {r11, pc}
;
; CHECK-NOFP16-LABEL: testmsxh_builtin:
; CHECK-NOFP16:       @ %bb.0: @ %entry
; CHECK-NOFP16-NEXT:    .save {r11, lr}
; CHECK-NOFP16-NEXT:    push {r11, lr}
; CHECK-NOFP16-NEXT:    vmov r0, s0
; CHECK-NOFP16-NEXT:    bl __aeabi_h2f
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    bl llrintf
; CHECK-NOFP16-NEXT:    pop {r11, pc}
;
; CHECK-FPv8-LABEL: testmsxh_builtin:
; CHECK-FPv8:       @ %bb.0: @ %entry
; CHECK-FPv8-NEXT:    .save {r11, lr}
; CHECK-FPv8-NEXT:    push {r11, lr}
; CHECK-FPv8-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FPv8-NEXT:    bl llrintf
; CHECK-FPv8-NEXT:    pop {r11, pc}
;
; CHECK-FP16-LABEL: testmsxh_builtin:
; CHECK-FP16:       @ %bb.0: @ %entry
; CHECK-FP16-NEXT:    .save {r11, lr}
; CHECK-FP16-NEXT:    push {r11, lr}
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl llrintf
; CHECK-FP16-NEXT:    pop {r11, pc}
entry:
  %0 = tail call i64 @llvm.llrint.i64.f16(half %x)
  ret i64 %0
}

define i64 @testmsxs_builtin(float %x) {
; CHECK-LABEL: testmsxs_builtin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    bl llrintf
; CHECK-NEXT:    pop {r11, pc}
entry:
  %0 = tail call i64 @llvm.llrint.i64.f32(float %x)
  ret i64 %0
}

define i64 @testmsxd_builtin(double %x) {
; CHECK-LABEL: testmsxd_builtin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    bl llrint
; CHECK-NEXT:    pop {r11, pc}
entry:
  %0 = tail call i64 @llvm.llrint.i64.f64(double %x)
  ret i64 %0
}

define i64 @testmsxq_builtin(fp128 %x) {
; CHECK-LABEL: testmsxq_builtin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    bl llrintl
; CHECK-NEXT:    pop {r11, pc}
entry:
  %0 = tail call i64 @llvm.llrint.i64.f128(fp128 %x)
  ret i64 %0
}
