{ Lazarus IDE wizard for fpweb package.

  Copyright (C) 2010 Lagunov Aleksey alexs75@hotbox.ru

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Library General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at your
  option) any later version with the following modification:

  As a special exception, the copyright holders of this library give you
  permission to link this library with independent modules to produce an
  executable, regardless of the license terms of these independent modules,and
  to copy and distribute the resulting executable under terms of your choice,
  provided that you also meet, for each linked independent module, the terms
  and conditions of the license of that module. An independent module is a
  module which is not derived from or based on this library. If you modify
  this library, you may extend this exception to your version of the library,
  but you are not obligated to do so. If you do not wish to do so, delete this
  exception statement from your version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License
  for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; if not, write to the Free Software Foundation,
  Inc., 51 Franklin Street - Fifth Floor, Boston, MA 02110-1335, USA.
}
unit fpIDEExtEditorInsertFileNameUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LazFileUtils, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ButtonPanel;

type

  { TfpIDEExtEditorInsertFileNameForm }

  TfpIDEExtEditorInsertFileNameForm = class(TForm)
    ButtonPanel1: TButtonPanel;
    CBFullPath: TCheckBox;
    EFileName: TEdit;
    LEFileName: TLabel;
    LBFiles: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure LBFilesDblClick(Sender: TObject);
  private
    procedure FillFilesList;
  public
    function SelectedFile:string;
  end; 

var
  fpIDEExtEditorInsertFileNameForm: TfpIDEExtEditorInsertFileNameForm;

implementation
uses fpWebStrConsts, SrcEditorIntf, ProjectIntf, LazIDEIntf;

{$R *.lfm}

{ TfpIDEExtEditorInsertFileNameForm }

procedure TfpIDEExtEditorInsertFileNameForm.FormCreate(Sender: TObject);
begin
  FillFilesList;
end;

procedure TfpIDEExtEditorInsertFileNameForm.LBFilesDblClick(Sender: TObject);
begin
  ModalResult:=mrOk;
end;

procedure TfpIDEExtEditorInsertFileNameForm.FillFilesList;
var
  i:integer;
  S:string;
begin
  LBFiles.Items.Clear;
  if Assigned(LazarusIDE) and Assigned(LazarusIDE.ActiveProject) then
  begin
    for i:=0 to LazarusIDE.ActiveProject.FileCount - 1 do
    begin
      if LazarusIDE.ActiveProject.Files[i].IsPartOfProject then
      begin
        S:=LazarusIDE.ActiveProject.Files[i].Filename;
        LBFiles.Items.Add(S);
      end;
    end;
  end;
end;

function TfpIDEExtEditorInsertFileNameForm.SelectedFile: string;
begin
  if (LBFiles.Items.Count>0) and (LBFiles.ItemIndex>-1) and (LBFiles.ItemIndex < LBFiles.Items.Count) then
  begin
    Result:=LBFiles.Items[LBFiles.ItemIndex];
    if not CBFullPath.Checked then
      Result:=ExtractFileNameOnly(Result);
  end
  else
    Result:='';
end;

end.

