// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/valued_resource.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// How valuable the resource is.
type ValuedResource_ResourceValue int32

const (
	// The resource value isn't specified.
	ValuedResource_RESOURCE_VALUE_UNSPECIFIED ValuedResource_ResourceValue = 0
	// This is a low-value resource.
	ValuedResource_RESOURCE_VALUE_LOW ValuedResource_ResourceValue = 1
	// This is a medium-value resource.
	ValuedResource_RESOURCE_VALUE_MEDIUM ValuedResource_ResourceValue = 2
	// This is a high-value resource.
	ValuedResource_RESOURCE_VALUE_HIGH ValuedResource_ResourceValue = 3
)

// Enum value maps for ValuedResource_ResourceValue.
var (
	ValuedResource_ResourceValue_name = map[int32]string{
		0: "RESOURCE_VALUE_UNSPECIFIED",
		1: "RESOURCE_VALUE_LOW",
		2: "RESOURCE_VALUE_MEDIUM",
		3: "RESOURCE_VALUE_HIGH",
	}
	ValuedResource_ResourceValue_value = map[string]int32{
		"RESOURCE_VALUE_UNSPECIFIED": 0,
		"RESOURCE_VALUE_LOW":         1,
		"RESOURCE_VALUE_MEDIUM":      2,
		"RESOURCE_VALUE_HIGH":        3,
	}
)

func (x ValuedResource_ResourceValue) Enum() *ValuedResource_ResourceValue {
	p := new(ValuedResource_ResourceValue)
	*p = x
	return p
}

func (x ValuedResource_ResourceValue) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValuedResource_ResourceValue) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_valued_resource_proto_enumTypes[0].Descriptor()
}

func (ValuedResource_ResourceValue) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_valued_resource_proto_enumTypes[0]
}

func (x ValuedResource_ResourceValue) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValuedResource_ResourceValue.Descriptor instead.
func (ValuedResource_ResourceValue) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescGZIP(), []int{0, 0}
}

// A resource that is determined to have value to a user's system
type ValuedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Valued resource name, for example,
	//
	//	e.g.:
	//	`organizations/123/simulations/456/valuedResources/789`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The
	// [full resource
	// name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// of the valued resource.
	Resource string `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// The [resource
	// type](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// of the valued resource.
	ResourceType string `protobuf:"bytes,3,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Human-readable name of the valued resource.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// How valuable this resource is.
	ResourceValue ValuedResource_ResourceValue `protobuf:"varint,5,opt,name=resource_value,json=resourceValue,proto3,enum=google.cloud.securitycenter.v2.ValuedResource_ResourceValue" json:"resource_value,omitempty"`
	// Exposed score for this valued resource. A value of 0 means no exposure was
	// detected exposure.
	ExposedScore float64 `protobuf:"fixed64,6,opt,name=exposed_score,json=exposedScore,proto3" json:"exposed_score,omitempty"`
	// List of resource value configurations' metadata used to determine the value
	// of this resource. Maximum of 100.
	ResourceValueConfigsUsed []*ResourceValueConfigMetadata `protobuf:"bytes,7,rep,name=resource_value_configs_used,json=resourceValueConfigsUsed,proto3" json:"resource_value_configs_used,omitempty"`
}

func (x *ValuedResource) Reset() {
	*x = ValuedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValuedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValuedResource) ProtoMessage() {}

func (x *ValuedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValuedResource.ProtoReflect.Descriptor instead.
func (*ValuedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescGZIP(), []int{0}
}

func (x *ValuedResource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ValuedResource) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *ValuedResource) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *ValuedResource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ValuedResource) GetResourceValue() ValuedResource_ResourceValue {
	if x != nil {
		return x.ResourceValue
	}
	return ValuedResource_RESOURCE_VALUE_UNSPECIFIED
}

func (x *ValuedResource) GetExposedScore() float64 {
	if x != nil {
		return x.ExposedScore
	}
	return 0
}

func (x *ValuedResource) GetResourceValueConfigsUsed() []*ResourceValueConfigMetadata {
	if x != nil {
		return x.ResourceValueConfigsUsed
	}
	return nil
}

// Metadata about a ResourceValueConfig. For example, id and name.
type ResourceValueConfigMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource value config name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResourceValueConfigMetadata) Reset() {
	*x = ResourceValueConfigMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceValueConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceValueConfigMetadata) ProtoMessage() {}

func (x *ResourceValueConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceValueConfigMetadata.ProtoReflect.Descriptor instead.
func (*ResourceValueConfigMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescGZIP(), []int{1}
}

func (x *ResourceValueConfigMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_securitycenter_v2_valued_resource_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_valued_resource_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xba, 0x05, 0x0a, 0x0e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65,
	0x64, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x7a, 0x0a, 0x1b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x5f, 0x75, 0x73, 0x65, 0x64, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x55, 0x73,
	0x65, 0x64, 0x22, 0x7b, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4d, 0x45,
	0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x3a,
	0xac, 0x01, 0xea, 0x41, 0xa8, 0x01, 0x0a, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x57, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2a, 0x0f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x32, 0x0e,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x31,
	0x0a, 0x1b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x42, 0xed, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x13, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescData = file_google_cloud_securitycenter_v2_valued_resource_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_valued_resource_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_valued_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_securitycenter_v2_valued_resource_proto_goTypes = []interface{}{
	(ValuedResource_ResourceValue)(0),   // 0: google.cloud.securitycenter.v2.ValuedResource.ResourceValue
	(*ValuedResource)(nil),              // 1: google.cloud.securitycenter.v2.ValuedResource
	(*ResourceValueConfigMetadata)(nil), // 2: google.cloud.securitycenter.v2.ResourceValueConfigMetadata
}
var file_google_cloud_securitycenter_v2_valued_resource_proto_depIdxs = []int32{
	0, // 0: google.cloud.securitycenter.v2.ValuedResource.resource_value:type_name -> google.cloud.securitycenter.v2.ValuedResource.ResourceValue
	2, // 1: google.cloud.securitycenter.v2.ValuedResource.resource_value_configs_used:type_name -> google.cloud.securitycenter.v2.ResourceValueConfigMetadata
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_valued_resource_proto_init() }
func file_google_cloud_securitycenter_v2_valued_resource_proto_init() {
	if File_google_cloud_securitycenter_v2_valued_resource_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValuedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceValueConfigMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_valued_resource_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_valued_resource_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_valued_resource_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_valued_resource_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_valued_resource_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_valued_resource_proto = out.File
	file_google_cloud_securitycenter_v2_valued_resource_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_valued_resource_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_valued_resource_proto_depIdxs = nil
}
