// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about the specified association between a service network
// and a resource configuration.
func (c *Client) GetServiceNetworkResourceAssociation(ctx context.Context, params *GetServiceNetworkResourceAssociationInput, optFns ...func(*Options)) (*GetServiceNetworkResourceAssociationOutput, error) {
	if params == nil {
		params = &GetServiceNetworkResourceAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetServiceNetworkResourceAssociation", params, optFns, c.addOperationGetServiceNetworkResourceAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetServiceNetworkResourceAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetServiceNetworkResourceAssociationInput struct {

	// The ID of the association.
	//
	// This member is required.
	ServiceNetworkResourceAssociationIdentifier *string

	noSmithyDocumentSerde
}

type GetServiceNetworkResourceAssociationOutput struct {

	// The Amazon Resource Name (ARN) of the association.
	Arn *string

	// The date and time that the association was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The account that created the association.
	CreatedBy *string

	// The DNS entry for the service.
	DnsEntry *types.DnsEntry

	// The failure code.
	FailureCode *string

	// The reason the association request failed.
	FailureReason *string

	// The ID of the association.
	Id *string

	// Indicates whether the association is managed by Amazon.
	IsManagedAssociation *bool

	// The most recent date and time that the association was updated, in ISO-8601
	// format.
	LastUpdatedAt *time.Time

	// The private DNS entry for the service.
	PrivateDnsEntry *types.DnsEntry

	// The Amazon Resource Name (ARN) of the association.
	ResourceConfigurationArn *string

	// The ID of the resource configuration that is associated with the service
	// network.
	ResourceConfigurationId *string

	// The name of the resource configuration that is associated with the service
	// network.
	ResourceConfigurationName *string

	// The Amazon Resource Name (ARN) of the service network that is associated with
	// the resource configuration.
	ServiceNetworkArn *string

	// The ID of the service network that is associated with the resource
	// configuration.
	ServiceNetworkId *string

	// The name of the service network that is associated with the resource
	// configuration.
	ServiceNetworkName *string

	// The status of the association.
	Status types.ServiceNetworkResourceAssociationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetServiceNetworkResourceAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetServiceNetworkResourceAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetServiceNetworkResourceAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetServiceNetworkResourceAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetServiceNetworkResourceAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetServiceNetworkResourceAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetServiceNetworkResourceAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetServiceNetworkResourceAssociation",
	}
}
