// Code generated by smithy-go-codegen DO NOT EDIT.

package taxsettings

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/taxsettings/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves supplemental tax registrations for a single account.
func (c *Client) ListSupplementalTaxRegistrations(ctx context.Context, params *ListSupplementalTaxRegistrationsInput, optFns ...func(*Options)) (*ListSupplementalTaxRegistrationsOutput, error) {
	if params == nil {
		params = &ListSupplementalTaxRegistrationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSupplementalTaxRegistrations", params, optFns, c.addOperationListSupplementalTaxRegistrationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSupplementalTaxRegistrationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSupplementalTaxRegistrationsInput struct {

	//  The number of taxRegistrations results you want in one response.
	MaxResults *int32

	//  The token to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSupplementalTaxRegistrationsOutput struct {

	//  The list of supplemental tax registrations.
	//
	// This member is required.
	TaxRegistrations []types.SupplementalTaxRegistration

	//  The token to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSupplementalTaxRegistrationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSupplementalTaxRegistrations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSupplementalTaxRegistrations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSupplementalTaxRegistrations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSupplementalTaxRegistrations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSupplementalTaxRegistrationsPaginatorOptions is the paginator options for
// ListSupplementalTaxRegistrations
type ListSupplementalTaxRegistrationsPaginatorOptions struct {
	//  The number of taxRegistrations results you want in one response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSupplementalTaxRegistrationsPaginator is a paginator for
// ListSupplementalTaxRegistrations
type ListSupplementalTaxRegistrationsPaginator struct {
	options   ListSupplementalTaxRegistrationsPaginatorOptions
	client    ListSupplementalTaxRegistrationsAPIClient
	params    *ListSupplementalTaxRegistrationsInput
	nextToken *string
	firstPage bool
}

// NewListSupplementalTaxRegistrationsPaginator returns a new
// ListSupplementalTaxRegistrationsPaginator
func NewListSupplementalTaxRegistrationsPaginator(client ListSupplementalTaxRegistrationsAPIClient, params *ListSupplementalTaxRegistrationsInput, optFns ...func(*ListSupplementalTaxRegistrationsPaginatorOptions)) *ListSupplementalTaxRegistrationsPaginator {
	if params == nil {
		params = &ListSupplementalTaxRegistrationsInput{}
	}

	options := ListSupplementalTaxRegistrationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSupplementalTaxRegistrationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSupplementalTaxRegistrationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSupplementalTaxRegistrations page.
func (p *ListSupplementalTaxRegistrationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSupplementalTaxRegistrationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSupplementalTaxRegistrations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSupplementalTaxRegistrationsAPIClient is a client that implements the
// ListSupplementalTaxRegistrations operation.
type ListSupplementalTaxRegistrationsAPIClient interface {
	ListSupplementalTaxRegistrations(context.Context, *ListSupplementalTaxRegistrationsInput, ...func(*Options)) (*ListSupplementalTaxRegistrationsOutput, error)
}

var _ ListSupplementalTaxRegistrationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSupplementalTaxRegistrations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSupplementalTaxRegistrations",
	}
}
