// Code generated by smithy-go-codegen DO NOT EDIT.

package supportapp

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supportapp/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Registers a Slack workspace for your Amazon Web Services account. To call this
// API, your account must be part of an organization in Organizations.
//
// If you're the management account and you want to register Slack workspaces for
// your organization, you must complete the following tasks:
//
//   - Sign in to the [Amazon Web Services Support Center]and authorize the Slack workspaces where you want your
//     organization to have access to. See [Authorize a Slack workspace]in the Amazon Web Services Support User
//     Guide.
//
//   - Call the RegisterSlackWorkspaceForOrganization API to authorize each Slack
//     workspace for the organization.
//
// After the management account authorizes the Slack workspace, member accounts
// can call this API to authorize the same Slack workspace for their individual
// accounts. Member accounts don't need to authorize the Slack workspace manually
// through the [Amazon Web Services Support Center].
//
// To use the Amazon Web Services Support App, each account must then complete the
// following tasks:
//
//   - Create an Identity and Access Management (IAM) role with the required
//     permission. For more information, see [Managing access to the Amazon Web Services Support App].
//
//   - Configure a Slack channel to use the Amazon Web Services Support App for
//     support cases for that account. For more information, see [Configuring a Slack channel].
//
// [Authorize a Slack workspace]: https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html
// [Managing access to the Amazon Web Services Support App]: https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html
// [Amazon Web Services Support Center]: https://console.aws.amazon.com/support/app
// [Configuring a Slack channel]: https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html
func (c *Client) RegisterSlackWorkspaceForOrganization(ctx context.Context, params *RegisterSlackWorkspaceForOrganizationInput, optFns ...func(*Options)) (*RegisterSlackWorkspaceForOrganizationOutput, error) {
	if params == nil {
		params = &RegisterSlackWorkspaceForOrganizationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RegisterSlackWorkspaceForOrganization", params, optFns, c.addOperationRegisterSlackWorkspaceForOrganizationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RegisterSlackWorkspaceForOrganizationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RegisterSlackWorkspaceForOrganizationInput struct {

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such as
	// T012ABCDEFG . Specify the Slack workspace that you want to use for your
	// organization.
	//
	// This member is required.
	TeamId *string

	noSmithyDocumentSerde
}

type RegisterSlackWorkspaceForOrganizationOutput struct {

	// Whether the Amazon Web Services account is a management or member account
	// that's part of an organization in Organizations.
	AccountType types.AccountType

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such as
	// T012ABCDEFG .
	TeamId *string

	// The name of the Slack workspace.
	TeamName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRegisterSlackWorkspaceForOrganizationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRegisterSlackWorkspaceForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRegisterSlackWorkspaceForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RegisterSlackWorkspaceForOrganization"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRegisterSlackWorkspaceForOrganizationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRegisterSlackWorkspaceForOrganization(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRegisterSlackWorkspaceForOrganization(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RegisterSlackWorkspaceForOrganization",
	}
}
