// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the tenant databases that exist in a DB snapshot. This command only
// applies to RDS for Oracle DB instances in the multi-tenant configuration.
//
// You can use this command to inspect the tenant databases within a snapshot
// before restoring it. You can't directly interact with the tenant databases in a
// DB snapshot. If you restore a snapshot that was taken from DB instance using the
// multi-tenant configuration, you restore all its tenant databases.
func (c *Client) DescribeDBSnapshotTenantDatabases(ctx context.Context, params *DescribeDBSnapshotTenantDatabasesInput, optFns ...func(*Options)) (*DescribeDBSnapshotTenantDatabasesOutput, error) {
	if params == nil {
		params = &DescribeDBSnapshotTenantDatabasesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDBSnapshotTenantDatabases", params, optFns, c.addOperationDescribeDBSnapshotTenantDatabasesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDBSnapshotTenantDatabasesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeDBSnapshotTenantDatabasesInput struct {

	// The ID of the DB instance used to create the DB snapshots. This parameter isn't
	// case-sensitive.
	//
	// Constraints:
	//
	//   - If supplied, must match the identifier of an existing DBInstance .
	DBInstanceIdentifier *string

	// The ID of a DB snapshot that contains the tenant databases to describe. This
	// value is stored as a lowercase string.
	//
	// Constraints:
	//
	//   - If you specify this parameter, the value must match the ID of an existing
	//   DB snapshot.
	//
	//   - If you specify an automatic snapshot, you must also specify SnapshotType .
	DBSnapshotIdentifier *string

	// A specific DB resource identifier to describe.
	DbiResourceId *string

	// A filter that specifies one or more tenant databases to describe.
	//
	// Supported filters:
	//
	//   - tenant-db-name - Tenant database names. The results list only includes
	//   information about the tenant databases that match these tenant DB names.
	//
	//   - tenant-database-resource-id - Tenant database resource identifiers. The
	//   results list only includes information about the tenant databases contained
	//   within the DB snapshots.
	//
	//   - dbi-resource-id - DB instance resource identifiers. The results list only
	//   includes information about snapshots containing tenant databases contained
	//   within the DB instances identified by these resource identifiers.
	//
	//   - db-instance-id - Accepts DB instance identifiers and DB instance Amazon
	//   Resource Names (ARNs).
	//
	//   - db-snapshot-id - Accepts DB snapshot identifiers.
	//
	//   - snapshot-type - Accepts types of DB snapshots.
	Filters []types.Filter

	// An optional pagination token provided by a previous
	// DescribeDBSnapshotTenantDatabases request. If this parameter is specified, the
	// response includes only records beyond the marker, up to the value specified by
	// MaxRecords .
	Marker *string

	// The maximum number of records to include in the response. If more records exist
	// than the specified MaxRecords value, a pagination token called a marker is
	// included in the response so that you can retrieve the remaining results.
	MaxRecords *int32

	// The type of DB snapshots to be returned. You can specify one of the following
	// values:
	//
	//   - automated – All DB snapshots that have been automatically taken by Amazon
	//   RDS for my Amazon Web Services account.
	//
	//   - manual – All DB snapshots that have been taken by my Amazon Web Services
	//   account.
	//
	//   - shared – All manual DB snapshots that have been shared to my Amazon Web
	//   Services account.
	//
	//   - public – All DB snapshots that have been marked as public.
	//
	//   - awsbackup – All DB snapshots managed by the Amazon Web Services Backup
	//   service.
	SnapshotType *string

	noSmithyDocumentSerde
}

type DescribeDBSnapshotTenantDatabasesOutput struct {

	// A list of DB snapshot tenant databases.
	DBSnapshotTenantDatabases []types.DBSnapshotTenantDatabase

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to the
	// value specified by MaxRecords .
	Marker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDBSnapshotTenantDatabasesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeDBSnapshotTenantDatabases{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeDBSnapshotTenantDatabases{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeDBSnapshotTenantDatabases"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeDBSnapshotTenantDatabasesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDBSnapshotTenantDatabases(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeDBSnapshotTenantDatabasesPaginatorOptions is the paginator options for
// DescribeDBSnapshotTenantDatabases
type DescribeDBSnapshotTenantDatabasesPaginatorOptions struct {
	// The maximum number of records to include in the response. If more records exist
	// than the specified MaxRecords value, a pagination token called a marker is
	// included in the response so that you can retrieve the remaining results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeDBSnapshotTenantDatabasesPaginator is a paginator for
// DescribeDBSnapshotTenantDatabases
type DescribeDBSnapshotTenantDatabasesPaginator struct {
	options   DescribeDBSnapshotTenantDatabasesPaginatorOptions
	client    DescribeDBSnapshotTenantDatabasesAPIClient
	params    *DescribeDBSnapshotTenantDatabasesInput
	nextToken *string
	firstPage bool
}

// NewDescribeDBSnapshotTenantDatabasesPaginator returns a new
// DescribeDBSnapshotTenantDatabasesPaginator
func NewDescribeDBSnapshotTenantDatabasesPaginator(client DescribeDBSnapshotTenantDatabasesAPIClient, params *DescribeDBSnapshotTenantDatabasesInput, optFns ...func(*DescribeDBSnapshotTenantDatabasesPaginatorOptions)) *DescribeDBSnapshotTenantDatabasesPaginator {
	if params == nil {
		params = &DescribeDBSnapshotTenantDatabasesInput{}
	}

	options := DescribeDBSnapshotTenantDatabasesPaginatorOptions{}
	if params.MaxRecords != nil {
		options.Limit = *params.MaxRecords
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeDBSnapshotTenantDatabasesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeDBSnapshotTenantDatabasesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeDBSnapshotTenantDatabases page.
func (p *DescribeDBSnapshotTenantDatabasesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeDBSnapshotTenantDatabasesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxRecords = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeDBSnapshotTenantDatabases(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeDBSnapshotTenantDatabasesAPIClient is a client that implements the
// DescribeDBSnapshotTenantDatabases operation.
type DescribeDBSnapshotTenantDatabasesAPIClient interface {
	DescribeDBSnapshotTenantDatabases(context.Context, *DescribeDBSnapshotTenantDatabasesInput, ...func(*Options)) (*DescribeDBSnapshotTenantDatabasesOutput, error)
}

var _ DescribeDBSnapshotTenantDatabasesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeDBSnapshotTenantDatabases(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeDBSnapshotTenantDatabases",
	}
}
